/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.RackAwareMode;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.api.BaseProducerSendTest$callback$4$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh!B\u0001\u0003\u0003\u00039!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C\u0001+\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\nW\u0001\u0001\r\u00111A\u0005\n1\n\u0001bY8ogVlWM]\u000b\u0002[A!afN\u001d:\u001b\u0005y#BA\u00161\u0015\t\t$'A\u0004dY&,g\u000e^:\u000b\u0005\u0015\u0019$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001O\u0018\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\rQ4(P\u0007\u0002A%\u0011A\b\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003uyJ!a\u0010\u0011\u0003\t\tKH/\u001a\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\n\t\u000bAbY8ogVlWM]0%KF$\"a\u0011$\u0011\u0005i\"\u0015BA#!\u0005\u0011)f.\u001b;\t\u000f\u001d\u0003\u0015\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\u0013%\u0003\u0001\u0019!A!B\u0013i\u0013!C2p]N,X.\u001a:!\u0011\u001dY\u0005A1A\u0005\n1\u000b\u0011\u0002\u001d:pIV\u001cWM]:\u0016\u00035\u00032AT*V\u001b\u0005y%B\u0001)R\u0003\u001diW\u000f^1cY\u0016T!A\u0015\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002U\u001f\n1!)\u001e4gKJ\u0004BAV-:s5\tqK\u0003\u0002Ya\u0005A\u0001O]8ek\u000e,'/\u0003\u0002[/\ni1*\u00194lCB\u0013x\u000eZ;dKJDa\u0001\u0018\u0001!\u0002\u0013i\u0015A\u00039s_\u0012,8-\u001a:tA!9a\f\u0001b\u0001\n#y\u0016!\u0002;pa&\u001cW#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001\u00027b]\u001eT\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hE\n11\u000b\u001e:j]\u001eDa!\u001b\u0001!\u0002\u0013\u0001\u0017A\u0002;pa&\u001c\u0007\u0005C\u0004l\u0001\t\u0007I\u0011\u00027\u0002\u00159,XNU3d_J$7/F\u0001n!\tQd.\u0003\u0002pA\t\u0019\u0011J\u001c;\t\rE\u0004\u0001\u0015!\u0003n\u0003-qW/\u001c*fG>\u0014Hm\u001d\u0011\t\u000bM\u0004A\u0011\t;\u0002\u000bM,G/\u00169\u0015\u0003\rC#A\u001d<\u0011\u0005]TX\"\u0001=\u000b\u0005e,\u0014!\u00026v]&$\u0018BA>y\u0005\u0019\u0011UMZ8sK\")Q\u0010\u0001C!i\u0006AA/Z1s\t><h\u000e\u000b\u0002}\u007fB\u0019q/!\u0001\n\u0007\u0005\r\u0001PA\u0003BMR,'\u000fC\u0004\u0002\b\u0001!\t\"!\u0003\u0002\u001d\r\u0014X-\u0019;f!J|G-^2feRYQ+a\u0003\u0002\u001e\u0005\u0005\u0012QEA\u0015\u0011!\ti!!\u0002A\u0002\u0005=\u0011A\u00032s_.,'\u000fT5tiB!\u0011\u0011CA\r\u001d\u0011\t\u0019\"!\u0006\u0011\u0005e\u0001\u0013bAA\fA\u00051\u0001K]3eK\u001aL1aZA\u000e\u0015\r\t9\u0002\t\u0005\n\u0003?\t)\u0001%AA\u00025\f\u0001\u0002\\5oO\u0016\u0014Xj\u001d\u0005\n\u0003G\t)\u0001%AA\u00025\f\u0011BY1uG\"\u001c\u0016N_3\t\u0015\u0005\u001d\u0012Q\u0001I\u0001\u0002\u0004\ty!A\bd_6\u0004(/Z:tS>tG+\u001f9f\u0011)\tY#!\u0002\u0011\u0002\u0003\u0007\u0011QF\u0001\u000b[\u0006D(\t\\8dW6\u001b\bc\u0001\u001e\u00020%\u0019\u0011\u0011\u0007\u0011\u0003\t1{gn\u001a\u0005\b\u0003k\u0001A\u0011CA\u001c\u0003A\u0011XmZ5ti\u0016\u0014\bK]8ek\u000e,'\u000fF\u0002V\u0003sAa\u0001WA\u001a\u0001\u0004)\u0006bBA\u001f\u0001\u0011%\u0011qH\u0001\u0014a>dG.\u00168uS2tU/\u001c*fG>\u0014Hm\u001d\u000b\u0005\u0003\u0003\nI\u0005\u0005\u0003\u0018C\u0005\r\u0003#\u0002\u0018\u0002FeJ\u0014bAA$_\tq1i\u001c8tk6,'OU3d_J$\u0007BB6\u0002<\u0001\u0007Q\u000e\u0003\u0004\u0002N\u0001!\t\u0001^\u0001\u000fi\u0016\u001cHoU3oI>3gm]3uQ\u0011\tY%!\u0015\u0011\u0007]\f\u0019&C\u0002\u0002Va\u0014A\u0001V3ti\"1\u0011\u0011\f\u0001\u0005\u0002Q\fq\u0005^3tiN+g\u000eZ\"p[B\u0014Xm]:fI6+7o]1hK^KG\u000f[\"sK\u0006$X\rV5nK\"\"\u0011qKA)\u0011\u0019\ty\u0006\u0001C\u0001i\u0006QC/Z:u'\u0016tGMT8o\u0007>l\u0007O]3tg\u0016$W*Z:tC\u001e,w+\u001b;i\u0007J,\u0017\r^3US6,\u0007\u0006BA/\u0003#Bq!!\u001a\u0001\t#\t9'A\u0007tK:$\u0017I\u001c3WKJLg-\u001f\u000b\b\u0007\u0006%\u00141NA7\u0011\u0019A\u00161\ra\u0001+\"A1.a\u0019\u0011\u0002\u0003\u0007Q\u000e\u0003\u0006\u0002p\u0005\r\u0004\u0013!a\u0001\u0003[\t\u0011\u0002^5nK>,H/T:\t\u000f\u0005M\u0004\u0001\"\u0005\u0002v\u000512/\u001a8e\u0003:$g+\u001a:jMf$\u0016.\\3ti\u0006l\u0007\u000fF\u0003D\u0003o\nI\b\u0003\u0004Y\u0003c\u0002\r!\u0016\u0005\t\u0003w\n\t\b1\u0001\u0002~\u0005iA/[7fgR\fW\u000e\u001d+za\u0016\u0004B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0004\u0003\u000f\u0013\u0014AB2p[6|g.\u0003\u0003\u0002\f\u0006\u0005%!\u0004+j[\u0016\u001cH/Y7q)f\u0004X\r\u0003\u0004\u0002\u0010\u0002!\t\u0001^\u0001\ni\u0016\u001cHo\u00117pg\u0016DC!!$\u0002R!1\u0011Q\u0013\u0001\u0005\u0002Q\f1\u0003^3tiN+g\u000e\u001a+p!\u0006\u0014H/\u001b;j_:DC!a%\u0002R!1\u00111\u0014\u0001\u0005\u0002Q\f\u0001\u0006^3tiN+g\u000e\u001a\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d)beRLG/[8o\u000bb\u0004\u0018M\\:j_:DC!!'\u0002R!1\u0011\u0011\u0015\u0001\u0005\u0002Q\f\u0011\u0002^3ti\u001acWo\u001d5)\t\u0005}\u0015\u0011\u000b\u0005\u0007\u0003O\u0003A\u0011\u0001;\u0002QQ,7\u000f^\"m_N,w+\u001b;i5\u0016\u0014x\u000eV5nK>,HO\u0012:p[\u000e\u000bG\u000e\\3s)\"\u0014X-\u00193)\t\u0005\u0015\u0016\u0011\u000b\u0005\u0007\u0003[\u0003A\u0011\u0001;\u0002QQ,7\u000f^\"m_N,w+\u001b;i5\u0016\u0014x\u000eV5nK>,HO\u0012:p[N+g\u000eZ3s)\"\u0014X-\u00193)\t\u0005-\u0016\u0011\u000b\u0005\n\u0003g\u0003\u0011\u0013!C\t\u0003k\u000b\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t9LK\u0002n\u0003s[#!a/\u0011\t\u0005u\u0016qY\u0007\u0003\u0003\u007fSA!!1\u0002D\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000b\u0004\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011ZA`\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u001b\u0004\u0011\u0013!C\t\u0003k\u000b\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011%\t\t\u000eAI\u0001\n#\t\u0019.\u0001\rde\u0016\fG/\u001a)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIQ*\"!!6+\t\u0005=\u0011\u0011\u0018\u0005\n\u00033\u0004\u0011\u0013!C\t\u00037\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tiN\u000b\u0003\u0002.\u0005e\u0006\"CAq\u0001E\u0005I\u0011CA[\u0003]\u0019XM\u001c3B]\u00124VM]5gs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002f\u0002\t\n\u0011\"\u0005\u0002\\\u000692/\u001a8e\u0003:$g+\u001a:jMf$C-\u001a4bk2$He\r")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$19 = numServers;
        String x$20 = this.zkConnect();
        boolean x$21 = false;
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$23 = this.trustStoreFile();
        Option<Properties> x$24 = this.serverSaslProperties();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$19, x$20, x$21, x$25, (Option<SecurityProtocol>)x$22, x$23, x$24, x$26, x$27, x$28, x$29, x$30, x$31, x$32).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$33 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$34 = SecurityProtocol.PLAINTEXT;
        String x$35 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$36 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$37 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$38 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$39 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$40 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$41 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$42 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$43 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$33, x$35, x$36, x$37, x$38, x$39, x$34, x$40, x$41, x$42, x$43));
    }

    @Override
    @After
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int lingerMs, int batchSize, String compressionType, long maxBlockMs) {
        String x$44 = brokerList;
        String x$45 = compressionType;
        SecurityProtocol x$46 = this.securityProtocol();
        Option<File> x$47 = this.trustStoreFile();
        Option<Properties> x$48 = this.clientSaslProperties();
        int x$49 = lingerMs;
        long x$50 = maxBlockMs;
        int x$51 = TestUtils$.MODULE$.createProducer$default$2();
        long x$52 = TestUtils$.MODULE$.createProducer$default$4();
        int x$53 = TestUtils$.MODULE$.createProducer$default$5();
        int x$54 = TestUtils$.MODULE$.createProducer$default$6();
        int x$55 = TestUtils$.MODULE$.createProducer$default$8();
        int x$56 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$57 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$58 = TestUtils$.MODULE$.createProducer$default$15();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$44, x$51, x$50, x$52, x$53, x$54, x$49, x$55, x$45, x$56, x$46, x$47, x$48, x$57, x$58);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public int createProducer$default$3() {
        return 16384;
    }

    public String createProducer$default$4() {
        return "none";
    }

    public long createProducer$default$5() {
        return 60000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ConsumerRecord<byte[], byte[]>> pollUntilNumRecords(int numRecords) {
        void var2_2;
        ArrayBuffer records = new ArrayBuffer();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)this.consumer().poll(50L)).asScala());
            return records.size() == numRecords;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Consumed ").append(records.size()).append(" records until timeout, but expected ").append(numRecords).append(" records.").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        return var2_2;
    }

    @Test
    public void testSendOffset() {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
                producer.send(record4, (Callback)this.callback$1(partition, callback$module));
                throw this.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0, (Callback)this.callback$1(partition, callback$module)));
                Assert.assertEquals((String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords() + 4).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$1(partition, callback$module)).get()).offset());
            }
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        String x$59 = this.brokerList();
        String x$60 = "gzip";
        int x$61 = Integer.MAX_VALUE;
        int x$62 = this.createProducer$default$3();
        long x$63 = this.createProducer$default$5();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$59, x$61, x$62, x$60, x$63);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerify$1(this, producer, partition, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(timeoutMs, TimeUnit.MILLISECONDS);
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            Object object = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime") : topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            this.createTopic(this.topic(), 1, 2, topicProps);
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, producer, timestampType, partition, baseTimestamp, startTime, callback$module, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(20000L, TimeUnit.MILLISECONDS);
            recordAndFutures.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)new StringBuilder(47).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).append(" but only successfully sent ").append(this.callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset()).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset());
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testClose() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0));
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
    }

    @Test
    public void testSendToPartition() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            int partition = 1;
            long now = System.currentTimeMillis();
            IndexedSeq futures = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendToPartition$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$4);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
            Seq<ConsumerRecord<byte[], byte[]>> records = this.pollUntilNumRecords(this.kafka$api$BaseProducerSendTest$$numRecords());
            ((IterableLike)records.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        String x$64 = this.brokerList();
        long x$65 = 5000L;
        int x$66 = this.createProducer$default$2();
        int x$67 = this.createProducer$default$3();
        String x$68 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$64, x$66, x$67, x$68, x$65);
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition0 = 0;
        IndexedSeq futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> (RecordMetadata)x$5.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
        ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$6);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get();
            throw this.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (!(throwable instanceof TimeoutException)) {
                throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            AdminZkClient qual$1 = this.adminZkClient();
            String x$71 = this.topic();
            scala.collection.immutable.Map x$72 = existingAssignment;
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$69 = qual$2.getBrokerMetadatas$default$1();
            Option x$70 = qual$2.getBrokerMetadatas$default$2();
            Seq x$73 = qual$2.getBrokerMetadatas(x$69, x$70);
            int x$74 = 2;
            Option x$75 = qual$1.addPartitions$default$5();
            boolean x$76 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$71, (Map)x$72, x$73, x$74, x$75, x$76);
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            IndexedSeq futures1 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures1.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$8(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$9(this, partition1, x$8);
                return BoxedUnit.UNIT;
            });
            futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> (RecordMetadata)x$9.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$12(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$13(this, partition0, x$10);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testFlush() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$11 -> producer.send(record), IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$12))));
                producer.flush();
                Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDone())));
            });
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5());
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$14 -> producer.send(record0), IndexedSeq$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$15))));
            producer.close(0L, TimeUnit.MILLISECONDS);
            responses.foreach((Function1 & Serializable & scala.Serializable)future -> {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(this, future);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)this.consumer().poll(50L).count());
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, BoxesRunTime.unboxToInt((Object)i)));
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$1(int partition$1, LazyRef callback$module$1) {
        BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$;
        LazyRef lazyRef = callback$module$1;
        synchronized (lazyRef) {
            baseProducerSendTest$callback$3$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$1.value() : (BaseProducerSendTest$callback$3$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$3$(this, partition$1));
        }
        return baseProducerSendTest$callback$3$;
    }

    private final BaseProducerSendTest$callback$3$ callback$1(int partition$1, LazyRef callback$module$1) {
        return callback$module$1.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$1.value() : this.callback$lzycompute$1(partition$1, callback$module$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, KafkaProducer producer$3, int partition$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$2), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$3.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition$2, (long)recordMetadata.partition());
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$4$ callback$lzycompute$2(TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, LazyRef callback$module$2) {
        BaseProducerSendTest$callback$4$ baseProducerSendTest$callback$4$;
        LazyRef lazyRef = callback$module$2;
        synchronized (lazyRef) {
            baseProducerSendTest$callback$4$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$4$)callback$module$2.value() : (BaseProducerSendTest$callback$4$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$4$(this, timestampType$1, partition$3, baseTimestamp$1, startTime$1));
        }
        return baseProducerSendTest$callback$4$;
    }

    private final BaseProducerSendTest$callback$4$ callback$2(TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, LazyRef callback$module$2) {
        return callback$module$2.initialized() ? (BaseProducerSendTest$callback$4$)callback$module$2.value() : this.callback$lzycompute$2(timestampType$1, partition$3, baseTimestamp$1, startTime$1, callback$module$2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, KafkaProducer producer$2, TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, LazyRef callback$module$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$3), Predef$.MODULE$.long2Long(baseTimestamp$1 + (long)i), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$2.send(record, (Callback)$this.callback$2(timestampType$1, partition$3, baseTimestamp$1, startTime$1, callback$module$2)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ProducerRecord record = (ProducerRecord)tuple2._1();
            Future future = (Future)tuple2._2();
            RecordMetadata recordMetadata = (RecordMetadata)future.get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Assert.assertEquals((Object)record.timestamp(), (Object)BoxesRunTime.boxToLong((long)recordMetadata.timestamp()));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$testSendToPartition$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition$4, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ConsumerRecord record = (ConsumerRecord)tuple2._1();
        int i = tuple2._2$mcI$sp();
        Assert.assertEquals((Object)$this.topic(), (Object)record.topic());
        Assert.assertEquals((long)partition$4, (long)record.partition());
        Assert.assertEquals((long)i, (long)record.offset());
        Assert.assertNull((Object)record.key());
        Assert.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
        Assert.assertEquals((long)now$1, (long)record.timestamp());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$8(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$9(BaseProducerSendTest $this, int partition1$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition1$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$12(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$13(BaseProducerSendTest $this, int partition0$1, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$12) {
        return !x$12.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$15) {
        return !x$15.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(BaseProducerSendTest $this, Future future) {
        try {
            future.get();
            throw $this.fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, ProducerRecord record$2, KafkaProducer producer$9, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, BoxesRunTime.unboxToInt((Object)x$16)));
                }
                this.producer.close(0L, TimeUnit.MILLISECONDS);
                this.producer.close(Long.MAX_VALUE, TimeUnit.MICROSECONDS);
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$16) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(BaseProducerSendTest $outer, KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCompletion$1$adapted(kafka.api.BaseProducerSendTest$CloseCallback$1 java.lang.Object )}, serializedLambda);
            }
        }
        return producer$9.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$9, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$17) {
        return !x$17.isDone();
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i2) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer($this.brokerList(), Integer.MAX_VALUE, $this.createProducer$default$3(), $this.createProducer$default$4(), $this.createProducer$default$5());){
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, record$2, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$17))));
            producer.flush();
            Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isDone())));
            seq = $this.pollUntilNumRecords($this.kafka$api$BaseProducerSendTest$$numRecords());
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

