/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.cluster.Replica;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0001\u0003\u0001\u001d\u0011!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011A\u000e\u0002\u000bQ|\u0007/[2\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0004TiJLgn\u001a\u0005\u0007K\u0001\u0001\u000b\u0011\u0002\u000f\u0002\rQ|\u0007/[2!\u0011\u001d9\u0003A1A\u0005\u0002!\nA\u0001]1siV\t\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3FA\u0002J]RDa\u0001\r\u0001!\u0002\u0013I\u0013!\u00029beR\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%\taM\u0001\u0003iB,\u0012\u0001\u000e\t\u0003kuj\u0011A\u000e\u0006\u0003oa\naaY8n[>t'BA\u0003:\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\n\u0005y2$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001b\u0002\u0007Q\u0004\b\u0005C\u0004C\u0001\t\u0007I\u0011\u0001\u0015\u0002'\u001d\u0014\u0018mY3gk2\u001cEn\\:f)&lW-T:\t\r\u0011\u0003\u0001\u0015!\u0003*\u0003Q9'/Y2fMVd7\t\\8tKRKW.Z'tA!9a\t\u0001b\u0001\n\u00039\u0015\u0001C3yK\u000e,Ho\u001c:\u0016\u0003!\u0003\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002NA\u0005!Q\u000f^5m\u0013\ty%J\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016Da!\u0015\u0001!\u0002\u0013A\u0015!C3yK\u000e,Ho\u001c:!\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A+\u0011\u0007Ys\u0016M\u0004\u0002X9:\u0011\u0001lW\u0007\u00023*\u0011!LB\u0001\u0007yI|w\u000e\u001e \n\u00031J!!X\u0016\u0002\u000fA\f7m[1hK&\u0011q\f\u0019\u0002\u0004'\u0016\f(BA/,!\tI!-\u0003\u0002d\u0015\tY1*\u00194lC\u000e{gNZ5h\u0011\u0015)\u0007\u0001\"\u0011g\u0003\u0015\u0019X\r^+q)\u00059\u0007C\u0001\u0016i\u0013\tI7F\u0001\u0003V]&$\bF\u00013l!\taw.D\u0001n\u0015\tq7(A\u0003kk:LG/\u0003\u0002q[\n1!)\u001a4pe\u0016DQA\u001d\u0001\u0005B\u0019\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003cR\u0004\"\u0001\\;\n\u0005Yl'!B!gi\u0016\u0014\b\"\u0002=\u0001\t\u00031\u0017!\t;fgR\u001cuN\\:v[B$\u0018n\u001c8XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001c\bFA<{!\ta70\u0003\u0002}[\n1\u0011j\u001a8pe\u0016D#a\u001e@\u0011\u00051|\u0018bAA\u0001[\n!A+Z:u\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\t\u0011dY8ogVlWmV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fgR\u0019q-!\u0003\t\u000f\u0005-\u00111\u0001a\u0001S\u0005Aa.^7Ji\u0016\u00148\u000f\u0003\u0004\u0002\u0010\u0001!\tAZ\u0001$i\u0016\u001cHoU3fW\u0006sGmQ8n[&$x+\u001b;i\u0005J|7.\u001a:GC&dWO]3tQ\r\tiA \u0005\b\u0003+\u0001A\u0011AA\f\u0003}\u0019X-Z6B]\u0012\u001cu.\\7ji^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u000b\u0004O\u0006e\u0001bBA\u0006\u0003'\u0001\r!\u000b\u0005\u0007\u0003;\u0001A\u0011\u00014\u0002CQ,7\u000f^*vEN\u001c'/\u001b2f/\",g\u000eV8qS\u000e,f.\u0019<bS2\f'\r\\3)\u0007\u0005ma\u0010\u0003\u0004\u0002$\u0001!\tAZ\u0001\ni\u0016\u001cHo\u00117pg\u0016D3!!\t\u007f\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\t!c\u00195fG.\u001cEn\\:f\u000f>|G\rU1uQR)q-!\f\u00022!9\u0011qFA\u0014\u0001\u0004I\u0013A\u00038v[J+7m\u001c:eg\"A\u00111GA\u0014\u0001\u0004\t)$A\u0004he>,\b/\u00133\u0011\t\u0005]\u0012q\b\b\u0005\u0003s\tY\u0004\u0005\u0002YW%\u0019\u0011QH\u0016\u0002\rA\u0013X\rZ3g\u0013\r\u0019\u0013\u0011\t\u0006\u0004\u0003{Y\u0003bBA#\u0001\u0011%\u0011qI\u0001!G\",7m[\"m_N,w+\u001b;i\u0007>|'\u000fZ5oCR|'OR1jYV\u0014X\rF\u0004h\u0003\u0013\nY%a\u0014\t\u000f\u0005=\u00121\ta\u0001S!A\u0011QJA\"\u0001\u0004\t)$\u0001\u0007es:\fW.[2He>,\b\u000f\u0003\u0005\u0002R\u0005\r\u0003\u0019AA\u001b\u0003-i\u0017M\\;bY\u001e\u0013x.\u001e9\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\u0005ya-\u001b8e\u0007>|'\u000fZ5oCR|'\u000fF\u0002*\u00033B\u0001\"a\u0017\u0002T\u0001\u0007\u0011QG\u0001\u0006OJ|W\u000f\u001d\u0005\b\u0003?\u0002A\u0011BA1\u0003q\u0019\u0007.Z2l\u00072|7/Z,ji\"\u001cE.^:uKJ4\u0015-\u001b7ve\u0016$raZA2\u0003K\nI\u0007C\u0004\u00020\u0005u\u0003\u0019A\u0015\t\u0011\u0005\u001d\u0014Q\fa\u0001\u0003k\taa\u001a:pkB\f\u0004\u0002CA6\u0003;\u0002\r!!\u000e\u0002\r\u001d\u0014x.\u001e93\u0011\u0019\ty\u0007\u0001C\u0001M\u0006AB/Z:u\u00072|7/\u001a#ve&twMU3cC2\fgnY3)\u0007\u00055d\u0010C\u0004\u0002v\u0001!I!a\u001e\u00023\rDWmY6DY>\u001cX\rR;sS:<'+\u001a2bY\u0006t7-\u001a\u000b\nO\u0006e\u00141PA?\u0003\u000bC\u0001\"a\r\u0002t\u0001\u0007\u0011Q\u0007\u0005\b5\u0005M\u0004\u0019AA\u001b\u0011\u001d1\u00151\u000fa\u0001\u0003\u007f\u00022!SAA\u0013\r\t\u0019I\u0013\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\"A\u0011qQA:\u0001\u0004\tI)A\u000ece>\\WM]:Bm\u0006LG.\u00192mK\u0012+(/\u001b8h\u00072|7/\u001a\t\u0004U\u0005-\u0015bAAGW\t9!i\\8mK\u0006t\u0007bBAI\u0001\u0011%\u00111S\u0001\u001aGJ,\u0017\r^3D_:\u001cX/\\3s/&$\bn\u0012:pkBLE\r\u0006\u0003\u0002\u0016\u0006E\u0006\u0003CAL\u0003C\u000b)+!*\u000e\u0005\u0005e%\u0002BAN\u0003;\u000b\u0001bY8ogVlWM\u001d\u0006\u0004\u0003?C\u0014aB2mS\u0016tGo]\u0005\u0005\u0003G\u000bIJA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006U\u0005\u001d\u00161V\u0005\u0004\u0003S[#!B!se\u0006L\bc\u0001\u0016\u0002.&\u0019\u0011qV\u0016\u0003\t\tKH/\u001a\u0005\t\u0003g\ty\t1\u0001\u00026!9\u0011Q\u0017\u0001\u0005\n\u0005]\u0016\u0001G2sK\u0006$XmQ8ogVlWM]!oIJ+7-Z5wKRA\u0011QSA]\u0003w\u000by\f\u0003\u0005\u00024\u0005M\u0006\u0019AA\u001b\u0011!\ti,a-A\u0002\u0005%\u0015\u0001D7b]V\fG.Q:tS\u001et\u0007bBA\u0018\u0003g\u0003\r!\u000b\u0005\b\u0003\u0007\u0004A\u0011BAc\u00039\u0011XmY3jm\u0016\u0014VmY8sIN$\u0012bZAd\u0003\u0013\fY-!4\t\u0011\u0005m\u0015\u0011\u0019a\u0001\u0003+Cq!a\f\u0002B\u0002\u0007\u0011\u0006C\u0005\u001b\u0003\u0003\u0004\n\u00111\u0001\u00026!Q\u0011qZAa!\u0003\u0005\r!!5\u0002\u0013QLW.Z8vi6\u001b\bc\u0001\u0016\u0002T&\u0019\u0011Q[\u0016\u0003\t1{gn\u001a\u0005\b\u00033\u0004A\u0011BAn\u0003Y\u0019XOY7ji\u000ecwn]3B]\u00124\u0016\r\\5eCR,GCCAo\u0003S\fY/a<\u0002zB)\u0011*a8\u0002d&\u0019\u0011\u0011\u001d&\u0003\r\u0019+H/\u001e:f!\rQ\u0013Q]\u0005\u0004\u0003O\\#aA!os\"A\u00111TAl\u0001\u0004\t)\n\u0003\u0005\u0002n\u0006]\u0007\u0019AAi\u00039\u0019Gn\\:f)&lWm\\;u\u001bND\u0001\"!=\u0002X\u0002\u0007\u00111_\u0001\u000f[&t7\t\\8tKRKW.Z't!\u0015Q\u0013Q_Ai\u0013\r\t9p\u000b\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005m\u0018q\u001ba\u0001\u0003g\fa\"\\1y\u00072|7/\u001a+j[\u0016l5\u000fC\u0004\u0002\u0000\u0002!IA!\u0001\u0002!\rDWmY6DY>\u001cX\rZ*uCR,G#B4\u0003\u0004\t\u0015\u0001\u0002CA\u001a\u0003{\u0004\r!!\u000e\t\u000f\t\u001d\u0011Q a\u0001S\u0005\u00012m\\7nSR$X\r\u001a*fG>\u0014Hm\u001d\u0004\u0007\u0005\u0017\u0001AA!\u0004\u0003+\t{WO\\2f\u0005J|7.\u001a:TG\",G-\u001e7feN!!\u0011\u0002B\b!\ry!\u0011C\u0005\u0004\u0005'\u0001\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D!\"a\u0003\u0003\n\t\u0015\r\u0011\"\u0001)\u0011)\u0011IB!\u0003\u0003\u0002\u0003\u0006I!K\u0001\n]Vl\u0017\n^3sg\u0002Bq!\u0006B\u0005\t\u0003\u0011i\u0002\u0006\u0003\u0003 \t\r\u0002\u0003\u0002B\u0011\u0005\u0013i\u0011\u0001\u0001\u0005\b\u0003\u0017\u0011Y\u00021\u0001*\u0011%\u00119C!\u0003A\u0002\u0013\u0005\u0001&\u0001\u0003ji\u0016\u0014\bB\u0003B\u0016\u0005\u0013\u0001\r\u0011\"\u0001\u0003.\u0005A\u0011\u000e^3s?\u0012*\u0017\u000fF\u0002h\u0005_A\u0011B!\r\u0003*\u0005\u0005\t\u0019A\u0015\u0002\u0007a$\u0013\u0007\u0003\u0005\u00036\t%\u0001\u0015)\u0003*\u0003\u0015IG/\u001a:!\u0011\u001d\u0011ID!\u0003\u0005B\u0019\fa\u0001Z8X_J\\\u0007b\u0002B\u001f\u0001\u0011%!qH\u0001\fg\u0016tGMU3d_J$7\u000fF\u0004h\u0005\u0003\u0012yE!\u0015\t\u0011\t\r#1\ba\u0001\u0005\u000b\n\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0005\u000f\u0012Y%!*\u0002&6\u0011!\u0011\n\u0006\u0005\u0005\u0007\ni*\u0003\u0003\u0003N\t%#!D&bM.\f\u0007K]8ek\u000e,'\u000fC\u0004\u00020\tm\u0002\u0019A\u0015\t\u0013i\u0011Y\u0004%AA\u0002\u0005U\u0002\"\u0003B+\u0001E\u0005I\u0011\u0002B,\u0003U\u0019XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"A!\u0017+\t\u0005U\"1L\u0016\u0003\u0005;\u0002BAa\u0018\u0003j5\u0011!\u0011\r\u0006\u0005\u0005G\u0012)'A\u0005v]\u000eDWmY6fI*\u0019!qM\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003l\t\u0005$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!q\u000e\u0001\u0012\u0002\u0013%!qK\u0001\u0019e\u0016\u001cW-\u001b<f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003B:\u0001E\u0005I\u0011\u0002B;\u0003a\u0011XmY3jm\u0016\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005oRC!!5\u0003\\\u0001")
public class ConsumerBounceTest
extends BaseRequestTest {
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int gracefulCloseTimeMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, properties), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 1, this.numBrokers(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
        }
        finally {
            super.tearDown();
        }
    }

    @Ignore
    @Test
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3());
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$1(consumed, record);
                return BoxedUnit.UNIT;
            });
            if (!records.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$3(this, numRecords, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for followers after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to end of log");
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Seeking to ").append(pos).toString());
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Committing offset.");
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.numBrokers(), this.$outer.numBrokers(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(0L);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords$1(numRecords, newtopic, producer);
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, newtopic, 10000L);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        Future<?> future = this.executor().submit(new Runnable(this, numRecords, newtopic, consumer){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final int numRecords$2;
            private final String newtopic$1;
            private final KafkaConsumer consumer$1;

            public void run() {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)this.consumer$1, this.numRecords$2, this.newtopic$1, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$2 = numRecords$2;
                this.newtopic$1 = newtopic$1;
                this.consumer$1 = consumer$1;
            }
        });
        this.sendRecords$1(numRecords, newtopic, producer);
        future.get();
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.GROUP, group).build();
        ByteBuffer resp = this.connectAndSend((AbstractRequest)request, ApiKeys.FIND_COORDINATOR, this.connectAndSend$default$3(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        FindCoordinatorResponse response = FindCoordinatorResponse.parse((ByteBuffer)resp, (short)ApiKeys.FIND_COORDINATOR.latestVersion());
        return response.node().id();
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.numBrokers(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, ConsumerBounceTest.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, ConsumerBounceTest.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, topic, executor);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, topic, executor);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        this.consumerConfig().setProperty("group.id", groupId);
        return this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        if (manualAssign) {
            consumer.assign(Collections.singleton(this.tp()));
        } else {
            consumer.subscribe(Collections.singleton(this.topic()));
        }
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, this.receiveRecords$default$3(), this.receiveRecords$default$4());
        return consumer;
    }

    public void kafka$api$ConsumerBounceTest$$receiveRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, String topic, long timeoutMs) {
        long received;
        long endTimeMs = System.currentTimeMillis() + timeoutMs;
        for (received = 0L; received < (long)numRecords && System.currentTimeMillis() < endTimeMs; received += (long)consumer.poll(1000L).count()) {
        }
        Assert.assertEquals((long)numRecords, (long)received);
    }

    private String receiveRecords$default$3() {
        return this.topic();
    }

    private long receiveRecords$default$4() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int closeGraceTimeMs = 2000;
            long startNanos = System.nanoTime();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Closing consumer with timeout ").append(closeTimeoutMs).append(" ms.").toString());
            consumer.close(closeTimeoutMs, TimeUnit.MILLISECONDS);
            long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            maxCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assert.assertTrue((String)new StringBuilder(20).append("Close took too long ").append(timeTakenMs).toString(), (timeTakenMs < ms + (long)closeGraceTimeMs ? 1 : 0) != 0));
            minCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assert.assertTrue((String)new StringBuilder(27).append("Close finished too quickly ").append(timeTakenMs).toString(), (timeTakenMs >= ms ? 1 : 0) != 0));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("consumer.close() completed in ").append(timeTakenMs).append(" ms.").toString());
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(3000L);
        Assert.assertTrue((String)"Assignment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes())), IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1 & Serializable & scala.Serializable)x$2 -> (RecordMetadata)x$2.get(), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$3() {
        return this.topic();
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$1(LongRef consumed$1, ConsumerRecord record) {
        Assert.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$3(ConsumerBounceTest $this, int numRecords$1, KafkaServer server) {
        return ((Replica)server.replicaManager().localReplica($this.tp()).get()).highWatermark().messageOffset() == (long)numRecords$1;
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
        }
        catch (Exception exception) {}
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$2) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1 & Serializable & scala.Serializable)i -> producer$2.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes())), IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1 & Serializable & scala.Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    private static final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, String topic$3, ExecutorService executor$1) {
        return executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            consumer.subscribe(Collections.singletonList(topic$3), new ConsumerRebalanceListener(null, revokeSemaphore){
                private final Option revokeSemaphore$1;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.revokeSemaphore$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
                        $anon$3.$anonfun$onPartitionsRevoked$1(s);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$onPartitionsRevoked$1(Semaphore s) {
                    s.release();
                }
                {
                    this.revokeSemaphore$1 = revokeSemaphore$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPartitionsRevoked$1$adapted(java.util.concurrent.Semaphore )}, serializedLambda);
                }
            });
            consumer.poll(0L);
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumer.poll(100L));
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, String topic$3, ExecutorService executor$1) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), topic$3, executor$1);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public ConsumerBounceTest() {
        this.topic = "topic";
        this.part = 0;
        this.gracefulCloseTimeMs = 1000;
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

