/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.CustomQuotaCallbackTest$GroupedUser$;
import kafka.api.GroupedUserPrincipal;
import kafka.api.GroupedUserPrincipalBuilder;
import kafka.api.GroupedUserPrincipalBuilder$;
import kafka.api.GroupedUserQuotaCallback;
import kafka.api.GroupedUserQuotaCallback$;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.QuotaTestClients;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.JaasTestUtils$ScramLoginModule$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001B\u0001\u0003\u0001\u001d\u0011qcQ;ti>l\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.$Vm\u001d;\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001AA\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\n\u001b%\u0011aB\u0001\u0002\n'\u0006\u001cHnU3ukBDQ\u0001\u0005\u0001\u0005\u0002E\ta\u0001P5oSRtD#\u0001\n\u0011\u0005%\u0001\u0001\"\u0002\u000b\u0001\t#*\u0012\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\u00051\u0002CA\f$\u001b\u0005A\"BA\r\u001b\u0003\u0011\tW\u000f\u001e5\u000b\u0005ma\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005uq\u0012AB2p[6|gN\u0003\u0002\u0006?)\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0013\t!\u0003D\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\")a\u0005\u0001C)O\u0005aA.[:uK:,'OT1nKV\t\u0001\u0006\u0005\u0002*Y5\t!F\u0003\u0002,9\u00059a.\u001a;x_J\\\u0017BA\u0017+\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u0015y\u0003\u0001\"\u0015(\u0003]Ig\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW\r\u0003\u00052\u0001!\u0015\r\u0011\"\u00153\u00039!(/^:u'R|'/\u001a$jY\u0016,\u0012a\r\t\u0004i]JT\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\tM{W.\u001a\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n!![8\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\u0005\r&dW\rC\u0004C\u0001\t\u0007I\u0011I\"\u0002\u0017M,'O^3s\u0007>,h\u000e^\u000b\u0002\tB\u0011A'R\u0005\u0003\rV\u00121!\u00138u\u0011\u0019A\u0005\u0001)A\u0005\t\u0006a1/\u001a:wKJ\u001cu.\u001e8uA!9!\n\u0001b\u0001\n\u0013Y\u0015!G6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N,\u0012\u0001\u0014\t\u0004\u001bB\u0013V\"\u0001(\u000b\u0005=+\u0014AC2pY2,7\r^5p]&\u0011\u0011K\u0014\u0002\u0004'\u0016\f\bCA*W\u001b\u0005!&BA+>\u0003\u0011a\u0017M\\4\n\u0005]#&AB*ue&tw\r\u0003\u0004Z\u0001\u0001\u0006I\u0001T\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000f\t\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0003aY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\\\u000b\u0002%\"1a\f\u0001Q\u0001\nI\u000b\u0011d[1gW\u0006\u001cE.[3oiN\u000b7\u000f\\'fG\"\fg.[:nA!9\u0001\r\u0001b\u0001\n#\n\u0017\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/F\u0001c!\r!tg\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003Mv\nA!\u001e;jY&\u0011\u0001.\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u00026\u0001A\u0003%!-A\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm\u001d\u0011\t\u000f1\u0004!\u0019!C)C\u0006!2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKNDaA\u001c\u0001!\u0002\u0013\u0011\u0017!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000f\t\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u00031\tG-\\5o\u00072LWM\u001c;t+\u0005\u0011\bcA:wq6\tAO\u0003\u0002v\u001d\u00069Q.\u001e;bE2,\u0017BA<u\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018!B1e[&t'BA?\u001f\u0003\u001d\u0019G.[3oiNL!a >\u0003\u0017\u0005#W.\u001b8DY&,g\u000e\u001e\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003s\u00035\tG-\\5o\u00072LWM\u001c;tA!Y\u0011q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0005\u0003Q\u0001(o\u001c3vG\u0016\u0014x+\u001b;i_V$\u0018+^8uCV\u0011\u00111\u0002\t\t\u0003\u001b\t\u0019\"a\u0006\u0002\u00185\u0011\u0011q\u0002\u0006\u0004\u0003#a\u0018\u0001\u00039s_\u0012,8-\u001a:\n\t\u0005U\u0011q\u0002\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000bQ\nI\"!\b\n\u0007\u0005mQGA\u0003BeJ\f\u0017\u0010E\u00025\u0003?I1!!\t6\u0005\u0011\u0011\u0015\u0010^3\t\u0017\u0005\u0015\u0002\u00011AA\u0002\u0013%\u0011qE\u0001\u0019aJ|G-^2fe^KG\u000f[8viF+x\u000e^1`I\u0015\fH\u0003BA\u0015\u0003_\u00012\u0001NA\u0016\u0013\r\ti#\u000e\u0002\u0005+:LG\u000f\u0003\u0006\u00022\u0005\r\u0012\u0011!a\u0001\u0003\u0017\t1\u0001\u001f\u00132\u0011-\t)\u0004\u0001a\u0001\u0002\u0003\u0006K!a\u0003\u0002+A\u0014x\u000eZ;dKJ<\u0016\u000e\u001e5pkR\fVo\u001c;bA!A\u0011\u0011\b\u0001C\u0002\u0013\u00051)A\neK\u001a\fW\u000f\u001c;SKF,Xm\u001d;Rk>$\u0018\rC\u0004\u0002>\u0001\u0001\u000b\u0011\u0002#\u0002)\u0011,g-Y;miJ+\u0017/^3tiF+x\u000e^1!\u0011!\t\t\u0005\u0001b\u0001\n\u0003\u0019\u0015a\u00053fM\u0006,H\u000e\u001e)s_\u0012,8-Z)v_R\f\u0007bBA#\u0001\u0001\u0006I\u0001R\u0001\u0015I\u00164\u0017-\u001e7u!J|G-^2f#V|G/\u0019\u0011\t\u0011\u0005%\u0003A1A\u0005\u0002\r\u000b1\u0003Z3gCVdGoQ8ogVlW-U;pi\u0006Dq!!\u0014\u0001A\u0003%A)\u0001\u000beK\u001a\fW\u000f\u001c;D_:\u001cX/\\3Rk>$\u0018\r\t\u0005\b\u0003#\u0002A\u0011IA*\u0003\u0015\u0019X\r^+q)\t\tI\u0003\u000b\u0003\u0002P\u0005]\u0003\u0003BA-\u0003?j!!a\u0017\u000b\u0007\u0005u\u0013%A\u0003kk:LG/\u0003\u0003\u0002b\u0005m#A\u0002\"fM>\u0014X\rC\u0004\u0002f\u0001!\t%a\u0015\u0002\u0011Q,\u0017M\u001d#po:DC!a\u0019\u0002jA!\u0011\u0011LA6\u0013\u0011\ti'a\u0017\u0003\u000b\u00053G/\u001a:\t\u000f\u0005E\u0004\u0001\"\u0011\u0002T\u0005\u00193m\u001c8gS\u001e,(/Z*fGV\u0014\u0018\u000e^=CK\u001a|'/Z*feZ,'o]*uCJ$\bbBA;\u0001\u0011\u0005\u00111K\u0001\u0018i\u0016\u001cHoQ;ti>l\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.DC!a\u001d\u0002zA!\u0011\u0011LA>\u0013\u0011\ti(a\u0017\u0003\tQ+7\u000f\u001e\u0005\b\u0003\u0003\u0003A\u0011BAB\u0003Y\u0019'/Z1uK\u001e\u0013x.\u001e9XSRDwJ\\3Vg\u0016\u0014HCBAC\u0007+\u001aI\u0006\u0005\u0003\u0002\b\u0006%U\"\u0001\u0001\u0007\r\u0005-\u0005\u0001QAG\u0005-9%o\\;qK\u0012,6/\u001a:\u0014\u0011\u0005%\u0015qRAK\u00037\u00032!CAI\u0013\r\t\u0019J\u0001\u0002\u0011#V|G/\u0019+fgR\u001cE.[3oiN\u00042\u0001NAL\u0013\r\tI*\u000e\u0002\b!J|G-^2u!\r!\u0014QT\u0005\u0004\u0003?+$\u0001D*fe&\fG.\u001b>bE2,\u0007bCAR\u0003\u0013\u0013)\u001a!C\u0001\u0003K\u000bA!^:feV\u0011\u0011q\u0015\t\u0005\u0003S\u000b9L\u0004\u0003\u0002,\u0006M\u0006cAAWk5\u0011\u0011q\u0016\u0006\u0004\u0003c3\u0011A\u0002\u001fs_>$h(C\u0002\u00026V\na\u0001\u0015:fI\u00164\u0017bA,\u0002:*\u0019\u0011QW\u001b\t\u0017\u0005u\u0016\u0011\u0012B\tB\u0003%\u0011qU\u0001\u0006kN,'\u000f\t\u0005\f\u0003\u0003\fII!f\u0001\n\u0003\t)+A\u0005vg\u0016\u0014xI]8va\"Y\u0011QYAE\u0005#\u0005\u000b\u0011BAT\u0003))8/\u001a:He>,\b\u000f\t\u0005\f\u0003\u0013\fII!f\u0001\n\u0003\t)+A\u0003u_BL7\rC\u0006\u0002N\u0006%%\u0011#Q\u0001\n\u0005\u001d\u0016A\u0002;pa&\u001c\u0007\u0005C\u0006\u0002R\u0006%%Q3A\u0005\u0002\u0005M\u0017A\u00037fC\u0012,'OT8eKV\u0011\u0011Q\u001b\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\u001c\u0003\u0002\rM,'O^3s\u0013\u0011\ty.!7\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\f\u0003G\fII!E!\u0002\u0013\t).A\u0006mK\u0006$WM\u001d(pI\u0016\u0004\u0003bCAt\u0003\u0013\u0013)\u001a!C\u0001\u0003K\u000b\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\t\u0017\u0005-\u0018\u0011\u0012B\tB\u0003%\u0011qU\u0001\u0012aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012\u0004\u0003bCAx\u0003\u0013\u0013)\u001a!C\u0001\u0003K\u000b\u0001cY8ogVlWM]\"mS\u0016tG/\u00133\t\u0017\u0005M\u0018\u0011\u0012B\tB\u0003%\u0011qU\u0001\u0012G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\u0004\u0003bCA\t\u0003\u0013\u0013)\u001a!C!\u0003\u0013AQ\"!?\u0002\n\nE\t\u0015!\u0003\u0002\f\u0005m\u0018!\u00039s_\u0012,8-\u001a:!\u0013\u0011\t\t\"!%\t\u0017\u0005}\u0018\u0011\u0012BK\u0002\u0013\u0005#\u0011A\u0001\tG>t7/^7feV\u0011!1\u0001\t\t\u0005\u000b\u0011I!a\u0006\u0002\u00185\u0011!q\u0001\u0006\u0004\u0003\u007fd\u0018\u0002\u0002B\u0006\u0005\u000f\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b\"\u0004B\b\u0003\u0013\u0013\t\u0012)A\u0005\u0005\u0007\u0011\t\"A\u0005d_:\u001cX/\\3sA%!\u0011q`AI\u0011\u001d\u0001\u0012\u0011\u0012C\u0001\u0005+!\"#!\"\u0003\u0018\te!1\u0004B\u000f\u0005?\u0011\tCa\t\u0003&!A\u00111\u0015B\n\u0001\u0004\t9\u000b\u0003\u0005\u0002B\nM\u0001\u0019AAT\u0011!\tIMa\u0005A\u0002\u0005\u001d\u0006\u0002CAi\u0005'\u0001\r!!6\t\u0011\u0005\u001d(1\u0003a\u0001\u0003OC\u0001\"a<\u0003\u0014\u0001\u0007\u0011q\u0015\u0005\t\u0003#\u0011\u0019\u00021\u0001\u0002\f!A\u0011q B\n\u0001\u0004\u0011\u0019\u0001\u0003\u0005\u0003*\u0005%E\u0011\tB\u0016\u00035)8/\u001a:Qe&t7-\u001b9bYV\u0011!Q\u0006\t\u0004/\t=\u0012b\u0001B\u00191\tq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0007\u0002\u0003B\u001b\u0003\u0013#\tEa\u000e\u0002\u001fE,x\u000e^1NKR\u0014\u0018n\u0019+bON$BA!\u000f\u0003@AA\u0011\u0011\u0016B\u001e\u0003O\u000b9+\u0003\u0003\u0003>\u0005e&aA'ba\"A!\u0011\tB\u001a\u0001\u0004\t9+\u0001\u0005dY&,g\u000e^%e\u0011!\u0011)%!#\u0005B\t\u001d\u0013AD8wKJ\u0014\u0018\u000eZ3Rk>$\u0018m\u001d\u000b\t\u0003S\u0011IEa\u0015\u0003X!A!1\nB\"\u0001\u0004\u0011i%A\u0007qe>$WoY3s#V|G/\u0019\t\u0004i\t=\u0013b\u0001B)k\t!Aj\u001c8h\u0011!\u0011)Fa\u0011A\u0002\t5\u0013!D2p]N,X.\u001a:Rk>$\u0018\r\u0003\u0005\u0003Z\t\r\u0003\u0019\u0001B.\u00031\u0011X-];fgR\fVo\u001c;b!\r!$QL\u0005\u0004\u0005?*$A\u0002#pk\ndW\r\u0003\u0005\u0003d\u0005%E\u0011IA*\u0003Q\u0011X-\\8wKF+x\u000e^1Pm\u0016\u0014(/\u001b3fg\"A!qMAE\t\u0003\u0011I'\u0001\bd_:4\u0017nZ;sKF+x\u000e^1\u0015\u0015\u0005%\"1\u000eB7\u0005_\u0012\t\b\u0003\u0005\u0002B\n\u0015\u0004\u0019AAT\u0011!\u0011YE!\u001aA\u0002\t5\u0003\u0002\u0003B+\u0005K\u0002\rA!\u0014\t\u0011\te#Q\ra\u0001\u00057B\u0001B!\u001e\u0002\n\u0012\u0005!qO\u0001\u0019G>tg-[4ve\u0016\fe\u000eZ,bSR4uN])v_R\fGCCA\u0015\u0005s\u0012iH!!\u0003\u0006\"A!1\u0010B:\u0001\u0004\u0011i%\u0001\u0007qe>$WoY3Rk>$\u0018\r\u0003\u0005\u0003\u0000\tM\u0004\u0019\u0001B'\u0003)1W\r^2i#V|G/\u0019\u0005\n\u0005\u0007\u0013\u0019\b%AA\u0002\u0011\u000bq\u0001Z5wSN|'\u000f\u0003\u0006\u0003\b\nM\u0004\u0013!a\u0001\u0005\u0013\u000bQa\u001a:pkB\u0004R\u0001\u000eBF\u0003OK1A!$6\u0005\u0019y\u0005\u000f^5p]\"A!\u0011SAE\t\u0003\u0011\u0019*\u0001\bqe>$WoY3D_:\u001cX/\\3\u0015\r\u0005%\"Q\u0013BP\u0011!\u00119Ja$A\u0002\te\u0015!F3ya\u0016\u001cG\u000f\u0015:pIV\u001cW\r\u00165s_R$H.\u001a\t\u0004i\tm\u0015b\u0001BOk\t9!i\\8mK\u0006t\u0007\u0002\u0003BQ\u0005\u001f\u0003\rA!'\u0002+\u0015D\b/Z2u\u0007>t7/^7f)\"\u0014x\u000e\u001e;mK\"A!QUAE\t\u0003\t\u0019&A\u000bsK6|g/\u001a+ie>$H\u000f\\3NKR\u0014\u0018nY:\t\u0011\t%\u0016\u0011\u0012C\u0005\u0005W\u000bq\"];pi\u0006,e\u000e^5us:\u000bW.\u001a\u000b\u0005\u0003O\u0013i\u000b\u0003\u0005\u0002B\n\u001d\u0006\u0019AAT\u0011)\u0011\t,!#\u0002\u0002\u0013\u0005!1W\u0001\u0005G>\u0004\u0018\u0010\u0006\n\u0002\u0006\nU&q\u0017B]\u0005w\u0013iLa0\u0003B\n\r\u0007BCAR\u0005_\u0003\n\u00111\u0001\u0002(\"Q\u0011\u0011\u0019BX!\u0003\u0005\r!a*\t\u0015\u0005%'q\u0016I\u0001\u0002\u0004\t9\u000b\u0003\u0006\u0002R\n=\u0006\u0013!a\u0001\u0003+D!\"a:\u00030B\u0005\t\u0019AAT\u0011)\tyOa,\u0011\u0002\u0003\u0007\u0011q\u0015\u0005\u000b\u0003#\u0011y\u000b%AA\u0002\u0005-\u0001BCA\u0000\u0005_\u0003\n\u00111\u0001\u0003\u0004!Q!qYAE#\u0003%\tA!3\u0002E\r|gNZ5hkJ,\u0017I\u001c3XC&$hi\u001c:Rk>$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YMK\u0002E\u0005\u001b\\#Aa4\u0011\t\tE'1\\\u0007\u0003\u0005'TAA!6\u0003X\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053,\u0014AC1o]>$\u0018\r^5p]&!!Q\u001cBj\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005C\fI)%A\u0005\u0002\t\r\u0018AI2p]\u001aLw-\u001e:f\u0003:$w+Y5u\r>\u0014\u0018+^8uC\u0012\"WMZ1vYR$C'\u0006\u0002\u0003f*\"!\u0011\u0012Bg\u0011)\u0011I/!#\u0012\u0002\u0013\u0005!1^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iO\u000b\u0003\u0002(\n5\u0007B\u0003By\u0003\u0013\u000b\n\u0011\"\u0001\u0003l\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003B{\u0003\u0013\u000b\n\u0011\"\u0001\u0003l\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003B}\u0003\u0013\u000b\n\u0011\"\u0001\u0003|\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B\u007fU\u0011\t)N!4\t\u0015\r\u0005\u0011\u0011RI\u0001\n\u0003\u0011Y/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\t\u0015\r\u0015\u0011\u0011RI\u0001\n\u0003\u0011Y/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\t\u0015\r%\u0011\u0011RI\u0001\n\u0003\u0019Y!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\r5!\u0006BA\u0006\u0005\u001bD!b!\u0005\u0002\nF\u0005I\u0011AB\n\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"a!\u0006+\t\t\r!Q\u001a\u0005\n\u00073\tI)!A\u0005Bq\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\b\"CB\u000f\u0003\u0013\u000b\t\u0011\"\u0001D\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\u0019\t#!#\u0002\u0002\u0013\u000511E\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019)ca\u000b\u0011\u0007Q\u001a9#C\u0002\u0004*U\u00121!\u00118z\u0011%\t\tda\b\u0002\u0002\u0003\u0007A\t\u0003\u0006\u00040\u0005%\u0015\u0011!C!\u0007c\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007g\u0001R!TB\u001b\u0007KI1aa\u000eO\u0005!IE/\u001a:bi>\u0014\bBCB\u001e\u0003\u0013\u000b\t\u0011\"\u0001\u0004>\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u001a\u000e}\u0002BCA\u0019\u0007s\t\t\u00111\u0001\u0004&!Q11IAE\u0003\u0003%\te!\u0012\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u0012\u0005\u000b\u0007\u0013\nI)!A\u0005B\r-\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003IC!ba\u0014\u0002\n\u0006\u0005I\u0011IB)\u0003\u0019)\u0017/^1mgR!!\u0011TB*\u0011)\t\td!\u0014\u0002\u0002\u0003\u00071Q\u0005\u0005\t\u0007/\ny\b1\u0001\u0002(\u0006Ia-\u001b:tiV\u001bXM\u001d\u0005\b\u00077\ny\b1\u0001E\u0003!\u0011'o\\6fe&#\u0007bBB0\u0001\u0011%1\u0011M\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\u0005\u0002*\r\r4QMB5\u0011!\tIm!\u0018A\u0002\u0005\u001d\u0006bBB4\u0007;\u0002\r\u0001R\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u000f\r-4Q\fa\u0001\t\u00061A.Z1eKJDqaa\u001c\u0001\t\u0013\u0019\t(A\tde\u0016\fG/Z!e[&t7\t\\5f]R$\u0012\u0001\u001f\u0005\b\u0007k\u0002A\u0011BB<\u0003Y\u0001(o\u001c3vG\u0016<\u0016\u000e\u001e5pkR$\u0006N]8ui2,GCBA\u0015\u0007s\u001aY\b\u0003\u0005\u0002J\u000eM\u0004\u0019AAT\u0011\u001d\u0019iha\u001dA\u0002\u0011\u000b!B\\;n%\u0016\u001cwN\u001d3t\u0011\u001d\u0019\t\t\u0001C\u0005\u0007\u0007\u000bq!\u00193e+N,'\u000f\u0006\u0004\u0002\u0006\u000e\u00155q\u0011\u0005\t\u0003G\u001by\b1\u0001\u0002(\"911NB@\u0001\u0004!u!CBF\u0001\u0005\u0005\t\u0012ABG\u0003-9%o\\;qK\u0012,6/\u001a:\u0011\t\u0005\u001d5q\u0012\u0004\n\u0003\u0017\u0003\u0011\u0011!E\u0001\u0007#\u001bbaa$\u0004\u0014\u0006m\u0005CFBK\u00077\u000b9+a*\u0002(\u0006U\u0017qUAT\u0003\u0017\u0011\u0019!!\"\u000e\u0005\r]%bABMk\u00059!/\u001e8uS6,\u0017\u0002BBO\u0007/\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c89\u0011\u001d\u00012q\u0012C\u0001\u0007C#\"a!$\t\u0015\r%3qRA\u0001\n\u000b\u001aY\u0005\u0003\u0006\u0004(\u000e=\u0015\u0011!CA\u0007S\u000bQ!\u00199qYf$\"#!\"\u0004,\u000e56qVBY\u0007g\u001b)la.\u0004:\"A\u00111UBS\u0001\u0004\t9\u000b\u0003\u0005\u0002B\u000e\u0015\u0006\u0019AAT\u0011!\tIm!*A\u0002\u0005\u001d\u0006\u0002CAi\u0007K\u0003\r!!6\t\u0011\u0005\u001d8Q\u0015a\u0001\u0003OC\u0001\"a<\u0004&\u0002\u0007\u0011q\u0015\u0005\t\u0003#\u0019)\u000b1\u0001\u0002\f!A\u0011q`BS\u0001\u0004\u0011\u0019\u0001\u0003\u0006\u0004>\u000e=\u0015\u0011!CA\u0007\u007f\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004B\u000e%\u0007#\u0002\u001b\u0003\f\u000e\r\u0007c\u0005\u001b\u0004F\u0006\u001d\u0016qUAT\u0003+\f9+a*\u0002\f\t\r\u0011bABdk\t1A+\u001e9mKbB!ba3\u0004<\u0006\u0005\t\u0019AAC\u0003\rAH\u0005\r")
public class CustomQuotaCallbackTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private volatile CustomQuotaCallbackTest$GroupedUser$ GroupedUser$module;
    private final int serverCount;
    private final Seq<String> kafkaServerSaslMechanisms;
    private final String kafkaClientSaslMechanism;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final ArrayBuffer<AdminClient> adminClients;
    private KafkaProducer<byte[], byte[]> producerWithoutQuota;
    private final int defaultRequestQuota;
    private final int defaultProduceQuota;
    private final int defaultConsumeQuota;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    public CustomQuotaCallbackTest$GroupedUser$ GroupedUser() {
        if (this.GroupedUser$module == null) {
            this.GroupedUser$lzycompute$1();
        }
        return this.GroupedUser$module;
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName("BROKER");
    }

    private Some<File> trustStoreFile$lzycompute() {
        CustomQuotaCallbackTest customQuotaCallbackTest = this;
        synchronized (customQuotaCallbackTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    private Seq<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    private ArrayBuffer<AdminClient> adminClients() {
        return this.adminClients;
    }

    private KafkaProducer<byte[], byte[]> producerWithoutQuota() {
        return this.producerWithoutQuota;
    }

    private void producerWithoutQuota_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producerWithoutQuota = x$1;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public int defaultProduceQuota() {
        return this.defaultProduceQuota;
    }

    public int defaultConsumeQuota() {
        return this.defaultConsumeQuota;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections(this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)"SCRAM-SHA-256"), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), GroupedUserQuotaCallback.class.getName());
        this.serverConfig().setProperty(new StringBuilder(0).append(this.listenerName().configPrefix()).append(KafkaConfig$.MODULE$.PrincipalBuilderClassProp()).toString(), GroupedUserPrincipalBuilder.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
        super.setUp();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.producerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        this.producerWithoutQuota_$eq(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()));
    }

    @Override
    @After
    public void tearDown() {
        this.adminClients().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Test
    public void testCustomQuotaCallback() {
        GroupedUser user;
        int brokerId = 0;
        GroupedUser qual$1 = user = this.createGroupWithOneUser("group0_user1", brokerId);
        long x$5 = 1000000L;
        long x$6 = 2000000L;
        int x$7 = qual$1.configureAndWaitForQuota$default$3();
        Option<String> x$8 = qual$1.configureAndWaitForQuota$default$4();
        qual$1.configureAndWaitForQuota(x$5, x$6, x$7, x$8);
        GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.set(0);
            return BoxedUnit.UNIT;
        });
        user.produceConsume(false, false);
        Assert.assertEquals((long)1L, (long)((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.PRODUCE)).get());
        Assert.assertEquals((long)1L, (long)((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.FETCH)).get());
        Assert.assertTrue((String)new StringBuilder(26).append("Too many quotaLimit calls ").append(GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls()).toString(), (((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.REQUEST)).get() <= this.serverCount() ? 1 : 0) != 0);
        GroupedUser qual$2 = user;
        long x$9 = 9000L;
        long x$10 = 3000L;
        int x$11 = qual$2.configureAndWaitForQuota$default$3();
        Option<String> x$12 = qual$2.configureAndWaitForQuota$default$4();
        qual$2.configureAndWaitForQuota(x$9, x$10, x$11, x$12);
        user.produceConsume(true, true);
        user = this.addUser("group0_user2", brokerId);
        user.removeQuotaOverrides();
        GroupedUser qual$3 = user;
        long x$13 = this.defaultProduceQuota();
        long x$14 = this.defaultConsumeQuota();
        double x$15 = this.defaultRequestQuota();
        KafkaServer x$16 = qual$3.waitForQuotaUpdate$default$4();
        qual$3.waitForQuotaUpdate(x$13, x$14, x$15, x$16);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        user.configureAndWaitForQuota(8000L, 2500L, 1, (Option<String>)None$.MODULE$);
        user.produceConsume(true, true);
        GroupedUser qual$4 = user = this.addUser("group0_user3", brokerId);
        long x$17 = 2000000L;
        long x$18 = 2000000L;
        int x$19 = qual$4.configureAndWaitForQuota$default$3();
        Option<String> x$20 = qual$4.configureAndWaitForQuota$default$4();
        qual$4.configureAndWaitForQuota(x$17, x$18, x$19, x$20);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        brokerId = 1;
        GroupedUser qual$5 = user = this.createGroupWithOneUser("group1_user1", brokerId);
        long x$21 = 800000L;
        long x$22 = 250000L;
        int x$23 = qual$5.configureAndWaitForQuota$default$3();
        Option<String> x$24 = qual$5.configureAndWaitForQuota$default$4();
        qual$5.configureAndWaitForQuota(x$21, x$22, x$23, x$24);
        user.produceConsume(false, false);
        String largeTopic = "group1_largeTopic";
        this.createTopic(largeTopic, 99, 0);
        GroupedUser qual$6 = user;
        long x$25 = 8000L;
        long x$26 = 2500L;
        double x$27 = this.defaultRequestQuota();
        KafkaServer x$28 = qual$6.waitForQuotaUpdate$default$4();
        qual$6.waitForQuotaUpdate(x$25, x$26, x$27, x$28);
        user.produceConsume(true, true);
        GroupedUser qual$7 = user = this.addUser("group1_user2", brokerId);
        long x$29 = this.defaultProduceQuota() / 100;
        long x$30 = this.defaultConsumeQuota() / 100;
        double x$31 = this.defaultRequestQuota();
        KafkaServer x$32 = qual$7.waitForQuotaUpdate$default$4();
        qual$7.waitForQuotaUpdate(x$29, x$30, x$31, x$32);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        user.configureAndWaitForQuota(800000L, 250000L, 100, (Option<String>)None$.MODULE$);
        user.produceConsume(true, true);
        this.adminZkClient().deleteTopic(largeTopic);
        GroupedUser qual$8 = user = this.addUser("group1_user3", brokerId);
        long x$33 = 800000L;
        long x$34 = 250000L;
        double x$35 = this.defaultRequestQuota();
        KafkaServer x$36 = qual$8.waitForQuotaUpdate$default$4();
        qual$8.waitForQuotaUpdate(x$33, x$34, x$35, x$36);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        AdminClient adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(GroupedUserQuotaCallback$.MODULE$.DefaultProduceQuotaProp(), "8000");
        newProps.put(GroupedUserQuotaCallback$.MODULE$.DefaultFetchQuotaProp(), "2500");
        TestUtils$.MODULE$.alterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, false);
        GroupedUser qual$9 = user;
        long x$37 = 8000L;
        long x$38 = 2500L;
        double x$39 = this.defaultRequestQuota();
        KafkaServer x$40 = qual$9.waitForQuotaUpdate$default$4();
        qual$9.waitForQuotaUpdate(x$37, x$38, x$39, x$40);
        user.produceConsume(true, true);
        Assert.assertEquals((long)this.serverCount(), (long)GroupedUserQuotaCallback$.MODULE$.callbackInstances().get());
    }

    /*
     * WARNING - void declaration
     */
    private GroupedUser createGroupWithOneUser(String firstUser, int brokerId) {
        void var3_3;
        GroupedUser user = this.addUser(firstUser, brokerId);
        this.createTopic(user.topic(), 1, brokerId);
        user.configureAndWaitForQuota(this.defaultProduceQuota(), this.defaultConsumeQuota(), 1, (Option<String>)None$.MODULE$);
        return var3_3;
    }

    private void createTopic(String topic, int numPartitions, int leader) {
        scala.collection.immutable.Map assignment = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)this.servers());
    }

    /*
     * WARNING - void declaration
     */
    private AdminClient createAdminClient() {
        void var2_2;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName("BROKER")));
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.clientSecurityProps("admin-client")).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Object object = config.put(key.toString(), (String)value);
            return object;
        });
        config.put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        AdminClient adminClient = AdminClient.create(config);
        this.adminClients().$plus$eq((Object)adminClient);
        return var2_2;
    }

    public void kafka$api$CustomQuotaCallbackTest$$produceWithoutThrottle(String topic, int numRecords) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> CustomQuotaCallbackTest.$anonfun$produceWithoutThrottle$1(this, topic, BoxesRunTime.unboxToInt((Object)i)));
    }

    private GroupedUser addUser(String user, int leader) {
        String password = new StringBuilder(7).append(user).append(":secret").toString();
        this.createScramCredentials(this.zkConnect(), user, password);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CustomQuotaCallbackTest.$anonfun$addUser$1(this, user, server);
            return BoxedUnit.UNIT;
        });
        String userGroup = GroupedUserPrincipalBuilder$.MODULE$.group(user);
        String topic = new StringBuilder(6).append(userGroup).append("_topic").toString();
        String producerClientId = new StringBuilder(19).append(user).append(":producer-client-id").toString();
        String consumerClientId = new StringBuilder(19).append(user).append(":consumer-client-id").toString();
        this.producerConfig().put("client.id", producerClientId);
        this.producerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(user, password, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.consumerConfig().put("client.id", consumerClientId);
        this.consumerConfig().put("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().put("group.id", new StringBuilder(6).append(user).append("-group").toString());
        this.consumerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(user, password, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        return new GroupedUser(this, user, userGroup, topic, (KafkaServer)this.servers().apply(leader), producerClientId, consumerClientId, producer, consumer);
    }

    private final void GroupedUser$lzycompute$1() {
        CustomQuotaCallbackTest customQuotaCallbackTest = this;
        synchronized (customQuotaCallbackTest) {
            if (this.GroupedUser$module == null) {
                this.GroupedUser$module = new CustomQuotaCallbackTest$GroupedUser$(this);
            }
        }
    }

    public static final /* synthetic */ Future $anonfun$produceWithoutThrottle$1(CustomQuotaCallbackTest $this, String topic$1, int i) {
        byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes();
        return $this.producerWithoutQuota().send(new ProducerRecord(topic$1, null, null, (Object)payload));
    }

    public static final /* synthetic */ void $anonfun$addUser$1(CustomQuotaCallbackTest $this, String user$1, KafkaServer server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache($this.kafkaClientSaslMechanism(), ScramCredential.class);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> cache.get(user$1) != null, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SCRAM credentials not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public CustomQuotaCallbackTest() {
        SaslSetup.$init$(this);
        this.serverCount = 2;
        this.kafkaServerSaslMechanisms = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}));
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties(this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.adminClients = new ArrayBuffer();
        this.defaultRequestQuota = 1000;
        this.defaultProduceQuota = 2000000000;
        this.defaultConsumeQuota = 1000000000;
    }

    public class GroupedUser
    extends QuotaTestClients
    implements Product,
    scala.Serializable {
        private final String user;
        private final String userGroup;
        private final String topic;
        private final KafkaServer leaderNode;
        private final String producerClientId;
        private final String consumerClientId;
        public final /* synthetic */ CustomQuotaCallbackTest $outer;

        public String user() {
            return this.user;
        }

        public String userGroup() {
            return this.userGroup;
        }

        public String topic() {
            return this.topic;
        }

        public KafkaServer leaderNode() {
            return this.leaderNode;
        }

        public String producerClientId() {
            return this.producerClientId;
        }

        public String consumerClientId() {
            return this.consumerClientId;
        }

        @Override
        public KafkaProducer<byte[], byte[]> producer() {
            return super.producer();
        }

        @Override
        public KafkaConsumer<byte[], byte[]> consumer() {
            return super.consumer();
        }

        @Override
        public KafkaPrincipal userPrincipal() {
            return new GroupedUserPrincipal(this.user(), this.userGroup());
        }

        @Override
        public scala.collection.immutable.Map<String, String> quotaMetricTags(String clientId) {
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GroupedUserQuotaCallback$.MODULE$.QuotaGroupTag()), (Object)this.userGroup())}));
        }

        @Override
        public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
            this.configureQuota(this.userGroup(), producerQuota, consumerQuota, requestQuota);
        }

        @Override
        public void removeQuotaOverrides() {
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().adminZkClient().changeUserOrUserClientIdConfig(this.quotaEntityName(this.userGroup()), new Properties());
        }

        public void configureQuota(String userGroup, long producerQuota, long consumerQuota, double requestQuota) {
            Properties quotaProps = this.quotaProperties(producerQuota, consumerQuota, requestQuota);
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().adminZkClient().changeUserOrUserClientIdConfig(this.quotaEntityName(userGroup), quotaProps);
        }

        public void configureAndWaitForQuota(long produceQuota, long fetchQuota, int divisor, Option<String> group) {
            this.configureQuota((String)group.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), produceQuota, fetchQuota, this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().defaultRequestQuota());
            this.waitForQuotaUpdate(produceQuota / (long)divisor, fetchQuota / (long)divisor, this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().defaultRequestQuota(), this.waitForQuotaUpdate$default$4());
        }

        public int configureAndWaitForQuota$default$3() {
            return 1;
        }

        public Option<String> configureAndWaitForQuota$default$4() {
            return new Some((Object)this.userGroup());
        }

        public void produceConsume(boolean expectProduceThrottle, boolean expectConsumeThrottle) {
            int numRecords = 1000;
            int produced = this.produceUntilThrottled(numRecords, false);
            this.verifyProduceThrottle(expectProduceThrottle, false);
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().kafka$api$CustomQuotaCallbackTest$$produceWithoutThrottle(this.topic(), numRecords - produced);
            this.consumeUntilThrottled(numRecords, false);
            this.verifyConsumeThrottle(expectConsumeThrottle, false);
        }

        public void removeThrottleMetrics() {
            this.removeSensors$1((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
        }

        private String quotaEntityName(String userGroup) {
            return new StringBuilder(1).append(userGroup).append("_").toString();
        }

        public GroupedUser copy(String user, String userGroup, String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
            return new GroupedUser(this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer(), user, userGroup, topic, leaderNode, producerClientId, consumerClientId, producer, consumer);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.userGroup();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public KafkaServer copy$default$4() {
            return this.leaderNode();
        }

        public String copy$default$5() {
            return this.producerClientId();
        }

        public String copy$default$6() {
            return this.consumerClientId();
        }

        public KafkaProducer<byte[], byte[]> copy$default$7() {
            return this.producer();
        }

        public KafkaConsumer<byte[], byte[]> copy$default$8() {
            return this.consumer();
        }

        public String productPrefix() {
            return "GroupedUser";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            KafkaProducer<byte[], byte[]> kafkaProducer;
            int n = x$1;
            switch (n) {
                case 0: {
                    kafkaProducer = this.user();
                    break;
                }
                case 1: {
                    kafkaProducer = this.userGroup();
                    break;
                }
                case 2: {
                    kafkaProducer = this.topic();
                    break;
                }
                case 3: {
                    kafkaProducer = this.leaderNode();
                    break;
                }
                case 4: {
                    kafkaProducer = this.producerClientId();
                    break;
                }
                case 5: {
                    kafkaProducer = this.consumerClientId();
                    break;
                }
                case 6: {
                    kafkaProducer = this.producer();
                    break;
                }
                case 7: {
                    kafkaProducer = this.consumer();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return kafkaProducer;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof GroupedUser;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof GroupedUser)) return false;
            if (((GroupedUser)object).kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer() != this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            GroupedUser groupedUser = (GroupedUser)x$1;
            String string = this.user();
            String string2 = groupedUser.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.userGroup();
            String string4 = groupedUser.userGroup();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.topic();
            String string6 = groupedUser.topic();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            KafkaServer kafkaServer = this.leaderNode();
            KafkaServer kafkaServer2 = groupedUser.leaderNode();
            if (kafkaServer == null) {
                if (kafkaServer2 != null) {
                    return false;
                }
            } else if (!kafkaServer.equals(kafkaServer2)) return false;
            String string7 = this.producerClientId();
            String string8 = groupedUser.producerClientId();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.consumerClientId();
            String string10 = groupedUser.consumerClientId();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            KafkaProducer<byte[], byte[]> kafkaProducer = this.producer();
            KafkaProducer<byte[], byte[]> kafkaProducer2 = groupedUser.producer();
            if (kafkaProducer == null) {
                if (kafkaProducer2 != null) {
                    return false;
                }
            } else if (!kafkaProducer.equals(kafkaProducer2)) return false;
            KafkaConsumer<byte[], byte[]> kafkaConsumer = this.consumer();
            KafkaConsumer<byte[], byte[]> kafkaConsumer2 = groupedUser.consumer();
            if (kafkaConsumer == null) {
                if (kafkaConsumer2 != null) {
                    return false;
                }
            } else if (!kafkaConsumer.equals(kafkaConsumer2)) return false;
            if (!groupedUser.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ CustomQuotaCallbackTest kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer() {
            return this.$outer;
        }

        private final void removeSensors$1(QuotaType quotaType, String clientId) {
            String sensorSuffix = this.quotaMetricTags(clientId).values().mkString(":");
            this.leaderNode().metrics().removeSensor(new StringBuilder(13).append(quotaType).append("ThrottleTime-").append(sensorSuffix).toString());
            this.leaderNode().metrics().removeSensor(new StringBuilder(1).append(quotaType).append("-").append(sensorSuffix).toString());
        }

        public GroupedUser(CustomQuotaCallbackTest $outer, String user, String userGroup, String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
            this.user = user;
            this.userGroup = userGroup;
            this.topic = topic;
            this.leaderNode = leaderNode;
            this.producerClientId = producerClientId;
            this.consumerClientId = consumerClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(topic, leaderNode, producerClientId, consumerClientId, producer, consumer);
            Product.$init$((Product)this);
        }
    }
}

