/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tef!B\u0001\u0003\u0003\u00039!!G#oIR{WI\u001c3BkRDwN]5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\tIQ\"\u0003\u0002\u000f\u0005\tI1+Y:m'\u0016$X\u000f\u001d\u0005\u0006!\u0001!\t!E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0001\"!\u0003\u0001\t\u000fQ\u0001!\u0019!C!+\u0005Y1/\u001a:wKJ\u001cu.\u001e8u+\u00051\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aA%oi\"1Q\u0004\u0001Q\u0001\nY\tAb]3sm\u0016\u00148i\\;oi\u0002BQa\b\u0001\u0005B\u0001\n1eY8oM&<WO]3TK\u000e,(/\u001b;z\u0005\u00164wN]3TKJ4XM]:Ti\u0006\u0014H\u000fF\u0001\"!\t9\"%\u0003\u0002$1\t!QK\\5u\u0011\u001d)\u0003A1A\u0005\u0002U\t!B\\;n%\u0016\u001cwN\u001d3t\u0011\u00199\u0003\u0001)A\u0005-\u0005Ya.^7SK\u000e|'\u000fZ:!\u0011\u001dI\u0003A1A\u0005\u0002)\n1b\u001a:pkB\u0004&/\u001a4jqV\t1\u0006\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A.\u00198h\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\rM#(/\u001b8h\u0011\u0019!\u0004\u0001)A\u0005W\u0005aqM]8vaB\u0013XMZ5yA!9a\u0007\u0001b\u0001\n\u00039\u0014!B4s_V\u0004X#\u0001\u001d\u0011\u0005e\u0002eB\u0001\u001e?!\tY\u0004$D\u0001=\u0015\tid!\u0001\u0004=e>|GOP\u0005\u0003\u007fa\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001aB\u0015\ty\u0004\u0004\u0003\u0004D\u0001\u0001\u0006I\u0001O\u0001\u0007OJ|W\u000f\u001d\u0011\t\u000f\u0015\u0003!\u0019!C\u0001U\u0005YAo\u001c9jGB\u0013XMZ5y\u0011\u00199\u0005\u0001)A\u0005W\u0005aAo\u001c9jGB\u0013XMZ5yA!9\u0011\n\u0001b\u0001\n\u00039\u0014!\u0002;pa&\u001c\u0007BB&\u0001A\u0003%\u0001(\u0001\u0004u_BL7\r\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001+\u0003!9\u0018\u000e\u001c3dCJ$\u0007BB(\u0001A\u0003%1&A\u0005xS2$7-\u0019:eA!9\u0011\u000b\u0001b\u0001\n\u0003)\u0012\u0001\u00029beRDaa\u0015\u0001!\u0002\u00131\u0012!\u00029beR\u0004\u0003bB+\u0001\u0005\u0004%\tAV\u0001\u0003iB,\u0012a\u0016\t\u00031\u0002l\u0011!\u0017\u0006\u00035n\u000baaY8n[>t'BA\u0003]\u0015\tif,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0006\u0019qN]4\n\u0005\u0005L&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007G\u0002\u0001\u000b\u0011B,\u0002\u0007Q\u0004\b\u0005C\u0004f\u0001\t\u0007i\u0011A\u001c\u0002\u001f\rd\u0017.\u001a8u!JLgnY5qC2Dqa\u001a\u0001C\u0002\u001b\u0005q'\u0001\blC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\u0011%\u0004\u0001R1A\u0005R)\fa\u0002\u001e:vgR\u001cFo\u001c:f\r&dW-F\u0001l!\r9BN\\\u0005\u0003[b\u0011AaU8nKB\u0011qN]\u0007\u0002a*\u0011\u0011oL\u0001\u0003S>L!a\u001d9\u0003\t\u0019KG.\u001a\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u00035!x\u000e]5d%\u0016\u001cx.\u001e:dKV\tq\u000f\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006!\u0011-\u001e;i\u0015\taH!\u0001\u0005tK\u000e,(/\u001b;z\u0013\tq\u0018P\u0001\u0005SKN|WO]2f\u0011\u001d\t\t\u0001\u0001Q\u0001\n]\fa\u0002^8qS\u000e\u0014Vm]8ve\u000e,\u0007\u0005\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001w\u000359'o\\;q%\u0016\u001cx.\u001e:dK\"9\u0011\u0011\u0002\u0001!\u0002\u00139\u0018AD4s_V\u0004(+Z:pkJ\u001cW\r\t\u0005\t\u0003\u001b\u0001!\u0019!C\u0001m\u0006y1\r\\;ti\u0016\u0014(+Z:pkJ\u001cW\rC\u0004\u0002\u0012\u0001\u0001\u000b\u0011B<\u0002!\rdWo\u001d;feJ+7o\\;sG\u0016\u0004\u0003\u0002CA\u000b\u0001\t\u0007I\u0011\u0001<\u0002+A\u0014XMZ5yK\u0012$v\u000e]5d%\u0016\u001cx.\u001e:dK\"9\u0011\u0011\u0004\u0001!\u0002\u00139\u0018A\u00069sK\u001aL\u00070\u001a3U_BL7MU3t_V\u00148-\u001a\u0011\t\u0011\u0005u\u0001A1A\u0005\u0002Y\fQ\u0003\u001d:fM&DX\rZ$s_V\u0004(+Z:pkJ\u001cW\rC\u0004\u0002\"\u0001\u0001\u000b\u0011B<\u0002-A\u0014XMZ5yK\u0012<%o\\;q%\u0016\u001cx.\u001e:dK\u0002B\u0001\"!\n\u0001\u0005\u0004%\tA^\u0001\u0016o&dGmY1sIR{\u0007/[2SKN|WO]2f\u0011\u001d\tI\u0003\u0001Q\u0001\n]\fac^5mI\u000e\f'\u000f\u001a+pa&\u001c'+Z:pkJ\u001cW\r\t\u0005\t\u0003[\u0001!\u0019!C\u0001m\u0006)r/\u001b7eG\u0006\u0014Hm\u0012:pkB\u0014Vm]8ve\u000e,\u0007bBA\u0019\u0001\u0001\u0006Ia^\u0001\u0017o&dGmY1sI\u001e\u0013x.\u001e9SKN|WO]2fA!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0012!E2mkN$XM]!di&|g.\u0011:hgV\u0011\u0011\u0011\b\t\u0005/\u0005m\u0002(C\u0002\u0002>a\u0011Q!\u0011:sCfDq!!\u0011\u0001\t\u0003\t9$\u0001\fu_BL7M\u0011:pW\u0016\u0014(+Z1e\u0003\u000ed\u0017I]4t\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\na\u0002\u001d:pIV\u001cW-Q2m\u0003J<7\u000f\u0006\u0003\u0002:\u0005%\u0003BB%\u0002D\u0001\u0007\u0001\bC\u0004\u0002N\u0001!\t!a\u000e\u0002\u001f\u0011,7o\u0019:jE\u0016\f5\r\\!sONDq!!\u0015\u0001\t\u0003\t9$A\u000beK2,G/\u001a#fg\u000e\u0014\u0018NY3BG2\f%oZ:\t\u000f\u0005U\u0003\u0001\"\u0001\u00028\u0005\u0011B-\u001a7fi\u0016<&/\u001b;f\u0003\u000ed\u0017I]4t\u0011\u001d\tI\u0006\u0001C\u0001\u00037\nabY8ogVlW-Q2m\u0003J<7\u000f\u0006\u0003\u0002:\u0005u\u0003BB%\u0002X\u0001\u0007\u0001\bC\u0004\u0002b\u0001!\t!a\u000e\u0002\u0019\u001d\u0014x.\u001e9BG2\f%oZ:\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u00028\u0005i\u0002O]8ek\u000e,7i\u001c8tk6,w+\u001b7eG\u0006\u0014H-Q2m\u0003J<7\u000fC\u0004\u0002j\u0001!\t!a\u000e\u0002=A\u0014x\u000eZ;dK\u000e{gn];nKB\u0013XMZ5yK\u0012\f5\r\\:Be\u001e\u001c\bbBA7\u0001\u0011\u0005\u0011qN\u0001\u0011\u00072,8\u000f^3s\u0003\u000e$\u0018n\u001c8BG2,\"!!\u001d\u0011\r\u0005M\u0014QPAA\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014!C5n[V$\u0018M\u00197f\u0015\r\tY\bG\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA@\u0003k\u00121aU3u!\rA\u00181Q\u0005\u0004\u0003\u000bK(aA!dY\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005=\u0014A\u0005+pa&\u001c'I]8lKJ\u0014V-\u00193BG2Dq!!$\u0001\t\u0003\ty'\u0001\u0007He>,\bOU3bI\u0006\u001bG\u000eC\u0004\u0002\u0012\u0002!\t!a\u001c\u0002\u0019Q{\u0007/[2SK\u0006$\u0017i\u00197\t\u000f\u0005U\u0005\u0001\"\u0001\u0002p\u0005iAk\u001c9jG^\u0013\u0018\u000e^3BG2Dq!!'\u0001\t\u0003\ty'\u0001\tU_BL7\rR3tGJL'-Z!dY\"9\u0011Q\u0014\u0001\u0005\u0002\u0005=\u0014A\u0004+pa&\u001c7I]3bi\u0016\f5\r\u001c\u0005\u0007\u0003C\u0003A\u0011\t\u0011\u0002\u000bM,G/\u00169)\t\u0005}\u0015Q\u0015\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111\u00160\u0002\u000b),h.\u001b;\n\t\u0005=\u0016\u0011\u0016\u0002\u0007\u0005\u00164wN]3\t\r\u0005M\u0006\u0001\"\u0011!\u0003!!X-\u0019:E_^t\u0007\u0006BAY\u0003o\u0003B!a*\u0002:&!\u00111XAU\u0005\u0015\te\r^3s\u0011\u0019\ty\f\u0001C\u0001A\u0005YB/Z:u!J|G-^2f\u0007>t7/^7f-&\f\u0017i]:jO:DC!!0\u0002DB!\u0011qUAc\u0013\u0011\t9-!+\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003\u0017\u0004A\u0011\u0001\u0011\u0002=Q,7\u000f\u001e)s_\u0012,8-Z\"p]N,X.\u001a,jCN+(m]2sS\n,\u0007\u0006BAe\u0003\u0007Da!!5\u0001\t\u0003\u0001\u0013A\t;fgR\u0004&o\u001c3vG\u0016\u001cuN\\:v[\u0016<\u0016\u000e\u001e5XS2$7-\u0019:e\u0003\u000ed7\u000f\u000b\u0003\u0002P\u0006\r\u0007BBAl\u0001\u0011\u0005\u0001%\u0001\u0012uKN$\bK]8ek\u000e,7i\u001c8tk6,w+\u001b;i!J,g-\u001b=fI\u0006\u001bGn\u001d\u0015\u0005\u0003+\f\u0019\r\u0003\u0004\u0002^\u0002!\t\u0001I\u00010i\u0016\u001cH\u000f\u0015:pIV\u001cWmQ8ogVlW\rV8qS\u000e\fU\u000f^8De\u0016\fG/\u001a+pa&\u001c7I]3bi\u0016\f5\r\u001c\u0015\u0005\u00037\f\u0019\r\u0003\u0004\u0002d\u0002!I\u0001I\u0001\u0018g\u0016$x+\u001b7eG\u0006\u0014HMU3t_V\u00148-Z!dYNDa!a:\u0001\t\u0013\u0001\u0013aF:fiB\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0017i\u00197t\u0011\u001d\tY\u000f\u0001C\t\u0003[\f\u0011c]3u\u0003\u000ed7/\u00118e!J|G-^2f)\r\t\u0013q\u001e\u0005\u0007+\u0006%\b\u0019A,\t\r\u0005M\b\u0001\"\u0001!\u0003}!Xm\u001d;O_B\u0013x\u000eZ;dK^KG\u000f[8vi\u0012+7o\u0019:jE\u0016\f5\r\u001c\u0015\t\u0003c\f\u0019-a>\u0002z\u0006AQ\r\u001f9fGR,Gm\t\u0002\u0002|B!\u0011Q B\u0002\u001b\t\tyPC\u0002\u0003\u0002e\u000ba!\u001a:s_J\u001c\u0018\u0002\u0002B\u0003\u0003\u007f\u00141\u0004V8qS\u000e\fU\u000f\u001e5pe&T\u0018\r^5p]\u0016C8-\u001a9uS>t\u0007B\u0002B\u0005\u0001\u0011\u0005\u0001%\u0001\u000fuKN$hj\u001c)s_\u0012,8-Z,ji\"$Um]2sS\n,\u0017i\u00197)\t\t\u001d\u00111\u0019\u0005\u0007\u0005\u001f\u0001A\u0011\u0001\u0011\u0002QQ,7\u000f\u001e(p\u0007>t7/^7f/&$\bn\\;u\t\u0016\u001c8M]5cK\u0006\u001bGNV5b\u0003N\u001c\u0018n\u001a8)\u0011\t5\u00111YA|\u0005'\u0019#A!\u0006\u0011\u0007a\u00139\"C\u0002\u0003\u001ae\u0013abS1gW\u0006,\u0005pY3qi&|g\u000e\u0003\u0004\u0003\u001e\u0001!\t\u0001I\u0001,i\u0016\u001cHOT8D_:\u001cX/\\3XSRDw.\u001e;EKN\u001c'/\u001b2f\u0003\u000edg+[1Tk\n\u001c8M]5cK\"B!1DAb\u0003o\fI\u0010\u0003\u0004\u0003$\u0001!I\u0001I\u0001!]>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5pkR$Um]2sS\n,\u0017i\u00197TKR,\b\u000f\u0003\u0004\u0003(\u0001!\t\u0001I\u0001&i\u0016\u001cHOT8D_:\u001cX/\\3XSRDG)Z:de&\u0014W-Q2m-&\f\u0017i]:jO:DCA!\n\u0002D\"1!Q\u0006\u0001\u0005\u0002\u0001\n\u0001\u0006^3ti:{7i\u001c8tk6,w+\u001b;i\t\u0016\u001c8M]5cK\u0006\u001bGNV5b'V\u00147o\u0019:jE\u0016DCAa\u000b\u0002D\"1!1\u0007\u0001\u0005\n\u0001\nQD\\8D_:\u001cX/\\3XSRDG)Z:de&\u0014W-Q2m'\u0016$X\u000f\u001d\u0005\u0007\u0005o\u0001A\u0011\u0001\u0011\u0002\u001dQ,7\u000f\u001e(p\u000fJ|W\u000f]!dY\"\"!QGAb\u0011\u001d\u0011i\u0004\u0001C\u000b\u0005\u007f\t1b]3oIJ+7m\u001c:egR9\u0011E!\u0011\u0003\\\tu\u0003\u0002\u0003B\"\u0005w\u0001\rA!\u0012\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002Ba\u0012\u0003P\tM#1K\u0007\u0003\u0005\u0013RAAa\u0011\u0003L)\u0019!QJ.\u0002\u000f\rd\u0017.\u001a8ug&!!\u0011\u000bB%\u00055Y\u0015MZ6b!J|G-^2feB)q#a\u000f\u0003VA\u0019qCa\u0016\n\u0007\te\u0003D\u0001\u0003CsR,\u0007BB\u0013\u0003<\u0001\u0007a\u0003\u0003\u0004V\u0005w\u0001\ra\u0016\u0005\b\u0005C\u0002AQ\u0003B2\u00039\u0019wN\\:v[\u0016\u0014VmY8sIN$R\"\tB3\u0005g\u0012)H!\u001f\u0003|\tu\u0004\u0002\u0003B4\u0005?\u0002\rA!\u001b\u0002\u0011\r|gn];nKJ\u0004\u0002Ba\u001b\u0003p\tM#1K\u0007\u0003\u0005[RAAa\u001a\u0003L%!!\u0011\u000fB7\u0005!\u0019uN\\:v[\u0016\u0014\b\u0002C\u0013\u0003`A\u0005\t\u0019\u0001\f\t\u0013\t]$q\fI\u0001\u0002\u00041\u0012AD:uCJ$\u0018N\\4PM\u001a\u001cX\r\u001e\u0005\t\u0013\n}\u0003\u0013!a\u0001q!A\u0011Ka\u0018\u0011\u0002\u0003\u0007a\u0003\u0003\u0006\u0003\u0000\t}\u0003\u0013!a\u0001\u0005\u0003\u000bq\u0001^5nK>,H\u000fE\u0002\u0018\u0005\u0007K1A!\"\u0019\u0005\u0011auN\\4\t\u0013\t%\u0005!%A\u0005\u0016\t-\u0015\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0012\u0016\u0004-\t=5F\u0001BI!\u0011\u0011\u0019J!(\u000e\u0005\tU%\u0002\u0002BL\u00053\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tm\u0005$\u0001\u0006b]:|G/\u0019;j_:LAAa(\u0003\u0016\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\r\u0006!%A\u0005\u0016\t-\u0015\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I!q\u0015\u0001\u0012\u0002\u0013U!\u0011V\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TC\u0001BVU\rA$q\u0012\u0005\n\u0005_\u0003\u0011\u0013!C\u000b\u0005\u0017\u000b\u0001dY8ogVlWMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0011%\u0011\u0019\fAI\u0001\n+\u0011),\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIY*\"Aa.+\t\t\u0005%q\u0012")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final int serverCount;
    private final int numRecords;
    private final String groupPrefix;
    private final String group;
    private final String topicPrefix;
    private final String topic;
    private final String wildcard;
    private final int part;
    private final TopicPartition tp;
    private final Resource topicResource;
    private final Resource groupResource;
    private final Resource clusterResource;
    private final Resource prefixedTopicResource;
    private final Resource prefixedGroupResource;
    private final Resource wildcardTopicResource;
    private final Resource wildcardGroupResource;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterActionArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String groupPrefix() {
        return this.groupPrefix;
    }

    public String group() {
        return this.group;
    }

    public String topicPrefix() {
        return this.topicPrefix;
    }

    public String topic() {
        return this.topic;
    }

    public String wildcard() {
        return this.wildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public abstract String clientPrincipal();

    public abstract String kafkaPrincipal();

    private Some<File> trustStoreFile$lzycompute() {
        EndToEndAuthorizationTest endToEndAuthorizationTest = this;
        synchronized (endToEndAuthorizationTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    public Resource topicResource() {
        return this.topicResource;
    }

    public Resource groupResource() {
        return this.groupResource;
    }

    public Resource clusterResource() {
        return this.clusterResource;
    }

    public Resource prefixedTopicResource() {
        return this.prefixedTopicResource;
    }

    public Resource prefixedGroupResource() {
        return this.prefixedGroupResource;
    }

    public Resource wildcardTopicResource() {
        return this.wildcardTopicResource;
    }

    public Resource wildcardGroupResource() {
        return this.wildcardGroupResource;
    }

    public String[] clusterActionArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", "--cluster", "--operation=ClusterAction", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.kafkaPrincipal()).toString()});
    }

    public String[] topicBrokerReadAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), "--operation=Read", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.kafkaPrincipal()).toString()});
    }

    public String[] produceAclArgs(String topic) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] describeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] deleteDescribeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] deleteWriteAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Write", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] consumeAclArgs(String topic) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), new StringBuilder(8).append("--group=").append(this.group()).toString(), "--consumer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] groupAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--group=").append(this.group()).toString(), "--operation=Read", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] produceConsumeWildcardAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), new StringBuilder(8).append("--group=").append(this.wildcard()).toString(), "--consumer", "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] produceConsumePrefixedAclsArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topicPrefix()).toString(), new StringBuilder(8).append("--group=").append(this.groupPrefix()).toString(), "--resource-pattern-type=prefixed", "--consumer", "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public scala.collection.immutable.Set<Acl> ClusterActionAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)ClusterAction$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicBrokerReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> GroupReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicWriteAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicDescribeAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicCreateAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Create$.MODULE$)}));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setUp$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.createTopic(this.topic(), 1, 3, this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test
    public void testProduceConsumeWithWildcardAcls() {
        this.setWildcardResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test
    public void testProduceConsumeWithPrefixedAcls() {
        this.setPrefixedResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test
    public void testProduceConsumeTopicAutoCreateTopicCreateAcl() {
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        this.setAclsAndProduce(tp2);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$2 = consumer;
        int x$3 = this.numRecords();
        String x$4 = tp2.topic();
        int x$5 = this.consumeRecords$default$3();
        int x$6 = this.consumeRecords$default$5();
        long x$7 = this.consumeRecords$default$6();
        this.consumeRecords((Consumer<byte[], byte[]>)x$2, x$3, x$5, x$4, x$6, x$7);
    }

    private void setWildcardResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumeWildcardAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setWildcardResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setPrefixedResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumePrefixedAclsArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setPrefixedResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    public void setAclsAndProduce(TopicPartition tp) {
        AclCommand$.MODULE$.main(this.produceAclArgs(tp.topic()));
        AclCommand$.MODULE$.main(this.consumeAclArgs(tp.topic()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setAclsAndProduce$1(this, tp, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), tp);
    }

    @Test(expected=TopicAuthorizationException.class)
    public void testNoProduceWithoutDescribeAcl() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
    }

    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.TopicDescribeAcl(), (Authorizer)s.apis().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        try {
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            this.sendRecords(producer, this.numRecords(), this.tp());
            throw this.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test(expected=TopicAuthorizationException.class)
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$8 = consumer;
        long x$9 = 3000L;
        int x$10 = this.consumeRecords$default$2();
        int x$11 = this.consumeRecords$default$3();
        String x$12 = this.consumeRecords$default$4();
        int x$13 = this.consumeRecords$default$5();
        this.consumeRecords((Consumer<byte[], byte[]>)x$8, x$10, x$11, x$12, x$13, x$9);
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithoutDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.groupResource());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            return;
        }
    }

    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.TopicWriteAcl().$plus$plus(this.TopicDescribeAcl()).$plus$plus(this.TopicCreateAcl())), (Authorizer)s.apis().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        }
        catch (GroupAuthorizationException e) {
            Assert.assertEquals((Object)this.group(), (Object)e.groupId());
            return;
        }
    }

    public final void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> EndToEndAuthorizationTest.$anonfun$sendRecords$1(this, producer, tp, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        try {
            futures.foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public final void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        ArrayList records = new ArrayList();
        long deadlineMs = System.currentTimeMillis() + timeout;
        while (records.size() < numRecords && System.currentTimeMillis() < deadlineMs) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer.poll(50L)).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)records.add(record)));
        }
        if (records.size() < numRecords) {
            throw new TimeoutException();
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.get(i);
            int offset = startingOffset + i;
            Assert.assertEquals((Object)topic, (Object)record.topic());
            Assert.assertEquals((long)part, (long)record.partition());
            Assert.assertEquals((long)offset, (long)record.offset());
        });
    }

    public final int consumeRecords$default$2() {
        return 1;
    }

    public final int consumeRecords$default$3() {
        return 0;
    }

    public final String consumeRecords$default$4() {
        return this.topic();
    }

    public final int consumeRecords$default$5() {
        return this.part();
    }

    public final long consumeRecords$default$6() {
        return 10000L;
    }

    public static final /* synthetic */ void $anonfun$setUp$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls($this.ClusterActionAcl(), (Authorizer)s.apis().authorizer().get(), Resource$.MODULE$.ClusterResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.TopicBrokerReadAcl(), (Authorizer)s.apis().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, "*", PatternType.LITERAL));
    }

    public static final /* synthetic */ void $anonfun$setWildcardResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl()).$plus$plus($this.TopicBrokerReadAcl())), (Authorizer)s.apis().authorizer().get(), $this.wildcardTopicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), $this.wildcardGroupResource());
    }

    public static final /* synthetic */ void $anonfun$setPrefixedResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.apis().authorizer().get(), $this.prefixedTopicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), $this.prefixedGroupResource());
    }

    public static final /* synthetic */ void $anonfun$setAclsAndProduce$1(EndToEndAuthorizationTest $this, TopicPartition tp$1, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.apis().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, tp$1.topic(), PatternType.LITERAL));
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithoutDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.apis().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.apis().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(EndToEndAuthorizationTest $this, KafkaProducer producer$1, TopicPartition tp$2, int i) {
        ProducerRecord record = new ProducerRecord(tp$2.topic(), Predef$.MODULE$.int2Integer(tp$2.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    public EndToEndAuthorizationTest() {
        SaslSetup.$init$(this);
        this.serverCount = 3;
        this.numRecords = 1;
        this.groupPrefix = "gr";
        this.group = new StringBuilder(3).append(this.groupPrefix()).append("oup").toString();
        this.topicPrefix = "e2e";
        this.topic = new StringBuilder(5).append(this.topicPrefix()).append("topic").toString();
        this.wildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicResource = new Resource((ResourceType)Topic$.MODULE$, this.topic(), PatternType.LITERAL);
        this.groupResource = new Resource((ResourceType)Group$.MODULE$, this.group(), PatternType.LITERAL);
        this.clusterResource = Resource$.MODULE$.ClusterResource();
        this.prefixedTopicResource = new Resource((ResourceType)Topic$.MODULE$, this.topicPrefix(), PatternType.PREFIXED);
        this.prefixedGroupResource = new Resource((ResourceType)Group$.MODULE$, this.groupPrefix(), PatternType.PREFIXED);
        this.wildcardTopicResource = new Resource((ResourceType)Topic$.MODULE$, this.wildcard(), PatternType.LITERAL);
        this.wildcardGroupResource = new Resource((ResourceType)Group$.MODULE$, this.wildcard(), PatternType.LITERAL);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        this.consumerConfig().setProperty("group.id", "group");
    }
}

