/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%g\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\u0007\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u0005%i\u0011B\u0001\b\u0003\u0005%\u0019\u0016m\u001d7TKR,\b\u000fC\u0003\u0011\u0001\u0011\u0005\u0011#\u0001\u0004=S:LGO\u0010\u000b\u0002%A\u0011\u0011\u0002\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0011\u0016\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\u0016\u0003Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111!\u00138u\u0011\u0019i\u0002\u0001)A\u0005-\u0005a1/\u001a:wKJ\u001cu.\u001e8uA!)q\u0004\u0001C)A\u0005aA.[:uK:,'OT1nKV\t\u0011\u0005\u0005\u0002#Y5\t1E\u0003\u0002%K\u00059a.\u001a;x_J\\'B\u0001\u0014(\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u000b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.G\taA*[:uK:,'OT1nK\"9q\u0006\u0001b\u0001\n\u0013\u0001\u0014\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[V\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005!A.\u00198h\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\rM#(/\u001b8h\u0011\u0019Q\u0004\u0001)A\u0005c\u0005I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0011\u001da\u0004A1A\u0005\nu\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\ta\bE\u0002@\tFj\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\rC\u0012AC2pY2,7\r^5p]&\u0011Q\t\u0011\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004H\u0001\u0001\u0006IAP\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000f\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0003aY\u0017MZ6b'\u0016\u0014h/\u001a:KC\u0006\u001cXI\u001c;ss:\u000bW.Z\u000b\u0002\u0017B\u0011Aj\u0015\b\u0003\u001bF\u0003\"A\u0014\r\u000e\u0003=S!\u0001\u0015\u0004\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0006$\u0001\u0004Qe\u0016$WMZ\u0005\u0003qQS!A\u0015\r\t\rY\u0003\u0001\u0015!\u0003L\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:KC\u0006\u001cXI\u001c;ss:\u000bW.\u001a\u0011\t\u000ba\u0003A\u0011K-\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016\u0001B1vi\"T!aX\u0013\u0002\u0011M,7-\u001e:jifL!!\u0019/\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0007bB2\u0001\u0005\u0004%\t\u0006Z\u0001\u0015g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:\u0016\u0003\u0015\u00042a\u00064i\u0013\t9\u0007D\u0001\u0003T_6,\u0007CA5m\u001b\u0005Q'BA66\u0003\u0011)H/\u001b7\n\u00055T'A\u0003)s_B,'\u000f^5fg\"1q\u000e\u0001Q\u0001\n\u0015\fQc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b\u0005C\u0004r\u0001\t\u0007I\u0011\u000b3\u0002)\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t\u0011\u0019\u0019\b\u0001)A\u0005K\u0006)2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0003\"B;\u0001\t\u00032\u0018!B:fiV\u0003H#A<\u0011\u0005]A\u0018BA=\u0019\u0005\u0011)f.\u001b;)\u0005Q\\\bC\u0001?\u0000\u001b\u0005i(B\u0001@+\u0003\u0015QWO\\5u\u0013\r\t\t! \u0002\u0007\u0005\u00164wN]3\t\r\u0005\u0015\u0001\u0001\"\u0011w\u0003!!X-\u0019:E_^t\u0007\u0006BA\u0002\u0003\u0013\u00012\u0001`A\u0006\u0013\r\ti! \u0002\u0006\u0003\u001a$XM\u001d\u0005\u0007\u0003#\u0001A\u0011\u0001<\u0002\u0017Q,7\u000f^'fiJL7m\u001d\u0015\u0005\u0003\u001f\t)\u0002E\u0002}\u0003/I1!!\u0007~\u0005\u0011!Vm\u001d;\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 \u0005Y1/\u001a8e%\u0016\u001cwN\u001d3t)%9\u0018\u0011EA \u0003\u0007\n9\u0005\u0003\u0005\u0002$\u0005m\u0001\u0019AA\u0013\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003CA\u0014\u0003_\t\u0019$a\r\u000e\u0005\u0005%\"\u0002BA\u0012\u0003WQ1!!\f(\u0003\u001d\u0019G.[3oiNLA!!\r\u0002*\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004RaFA\u001b\u0003sI1!a\u000e\u0019\u0005\u0015\t%O]1z!\r9\u00121H\u0005\u0004\u0003{A\"\u0001\u0002\"zi\u0016Dq!!\u0011\u0002\u001c\u0001\u0007a#\u0001\u0006ok6\u0014VmY8sINDq!!\u0012\u0002\u001c\u0001\u0007a#\u0001\u0006sK\u000e|'\u000fZ*ju\u0016D\u0001\"!\u0013\u0002\u001c\u0001\u0007\u00111J\u0001\u0003iB\u0004B!!\u0014\u0002P5\tQ%C\u0002\u0002R\u0015\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002V\u0001!I!a\u0016\u0002;\u001d,g.\u001a:bi\u0016\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016$2a^A-\u0011!\tI%a\u0015A\u0002\u0005-\u0003bBA/\u0001\u0011%\u0011qL\u0001*m\u0016\u0014\u0018NZ=LC\u001a\\\u0017MU1uK6+GO]5dg\"\u000bg/Z\"v[Vd\u0017\r^5wK\u000e{WO\u001c;\u0015\u000b]\f\t'a\u0019\t\u0011\u0005\r\u00121\fa\u0001\u0003KA\u0001\"!\u001a\u0002\\\u0001\u0007\u0011qM\u0001\tG>t7/^7feBA\u0011\u0011NA7\u0003g\t\u0019$\u0004\u0002\u0002l)!\u0011QMA\u0016\u0013\u0011\ty'a\u001b\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\n!D^3sS\u001aL8\t\\5f]R4VM]:j_:lU\r\u001e:jGN$Ra^A<\u0003?C\u0001\"!\u001f\u0002r\u0001\u0007\u00111P\u0001\b[\u0016$(/[2ta\u0011\ti(!$\u0011\u000f%\fy(a!\u0002\n&\u0019\u0011\u0011\u00116\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002N\u0005\u0015\u0015bAADK\tQQ*\u001a;sS\u000et\u0015-\\3\u0011\t\u0005-\u0015Q\u0012\u0007\u0001\t1\ty)a\u001e\u0002\u0002\u0003\u0005)\u0011AAI\u0005\ryF%M\t\u0005\u0003'\u000bI\nE\u0002\u0018\u0003+K1!a&\u0019\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0014\u0002\u001c&\u0019\u0011QT\u0013\u0003\r5+GO]5d\u0011\u001d\t\t+!\u001dA\u0002-\u000ba!\u001a8uSRL\bbBAS\u0001\u0011%\u0011qU\u0001\"m\u0016\u0014\u0018NZ=Ce>\\WM]!vi\",g\u000e^5dCRLwN\\'fiJL7m\u001d\u000b\u0004o\u0006%\u0006\u0002CAV\u0003G\u0003\r!!,\u0002\rM,'O^3s!\u0011\ty+a-\u000e\u0005\u0005E&bAAV\t%!\u0011QWAY\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\u0006!c/\u001a:jMf\u0014%o\\6fe6+7o]1hK\u000e{gN^3sg&|g.T3ue&\u001c7\u000fF\u0004x\u0003{\u000by,!1\t\u0011\u0005-\u0016q\u0017a\u0001\u0003[Cq!!\u0012\u00028\u0002\u0007a\u0003\u0003\u0005\u0002J\u0005]\u0006\u0019AA&\u0011\u001d\t)\r\u0001C\u0005\u0003\u000f\fQC^3sS\u001aL(I]8lKJT6.T3ue&\u001c7\u000fF\u0003x\u0003\u0013\fY\r\u0003\u0005\u0002,\u0006\r\u0007\u0019AAW\u0011\u001d\ti-a1A\u0002-\u000bQ\u0001^8qS\u000eDq!!5\u0001\t\u0013\t\u0019.\u0001\rwKJLg-\u001f\"s_.,'/\u0012:s_JlU\r\u001e:jGN$2a^Ak\u0011!\tY+a4A\u0002\u00055\u0006bBAm\u0001\u0011%\u00111\\\u0001\u0012m\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001cW\u0003BAo\u0003G$\"\"a8\u0003\f\t=!1\u0004B\u000f)\u0011\t\t/a<\u0011\t\u0005-\u00151\u001d\u0003\t\u0003K\f9N1\u0001\u0002h\n\tA+\u0005\u0003\u0002\u0014\u0006%\bcA\f\u0002l&\u0019\u0011Q\u001e\r\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002r\u0006]\u0007\u0019AAz\u0003\u00191XM]5gsB9q#!>\u0002z\u0006\u0005\u0018bAA|1\tIa)\u001e8di&|g.\r\t\u0007\u0003w\u0014)!!'\u000f\t\u0005u(\u0011\u0001\b\u0004\u001d\u0006}\u0018\"A\r\n\u0007\t\r\u0001$A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d!\u0011\u0002\u0002\t\u0013R,'/\u00192mK*\u0019!1\u0001\r\t\u000f\t5\u0011q\u001ba\u0001\u0017\u0006!a.Y7f\u0011!\tI(a6A\u0002\tE\u0001\u0007\u0002B\n\u0005/\u0001r![A@\u0003\u0007\u0013)\u0002\u0005\u0003\u0002\f\n]A\u0001\u0004B\r\u0005\u001f\t\t\u0011!A\u0003\u0002\u0005E%aA0%e!9\u0011\u0011UAl\u0001\u0004Y\u0005B\u0003B\u0010\u0003/\u0004\n\u00111\u0001\u0003\"\u0005)qM]8vaB!qCa\tL\u0013\r\u0011)\u0003\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t%\u0002\u0001\"\u0003\u0003,\u0005\u0019R.\u0019=LC\u001a\\\u0017-T3ue&\u001cg+\u00197vKRQ!Q\u0006B\u001a\u0005k\u0011\tEa\u0011\u0011\u0007]\u0011y#C\u0002\u00032a\u0011a\u0001R8vE2,\u0007b\u0002B\u0007\u0005O\u0001\ra\u0013\u0005\t\u0003s\u00129\u00031\u0001\u00038A\"!\u0011\bB\u001f!\u001dI\u0017qPAB\u0005w\u0001B!a#\u0003>\u0011a!q\bB\u001b\u0003\u0003\u0005\tQ!\u0001\u0002\u0012\n\u0019q\fJ\u001a\t\u000f\u0005\u0005&q\u0005a\u0001\u0017\"A!q\u0004B\u0014\u0001\u0004\u0011\t\u0003C\u0004\u0003H\u0001!IA!\u0013\u00023Y,'/\u001b4z\u0017\u000647.Y'fiJL7MU3d_J$W\r\u001a\u000b\no\n-#Q\nB-\u00057BqA!\u0004\u0003F\u0001\u00071\n\u0003\u0005\u0002z\t\u0015\u0003\u0019\u0001B(a\u0011\u0011\tF!\u0016\u0011\u000f%\fy(a!\u0003TA!\u00111\u0012B+\t1\u00119F!\u0014\u0002\u0002\u0003\u0005)\u0011AAI\u0005\ryF\u0005\u000e\u0005\b\u0003C\u0013)\u00051\u0001L\u0011)\u0011yB!\u0012\u0011\u0002\u0003\u0007!\u0011\u0005\u0005\b\u0005?\u0002A\u0011\u0002B1\u0003EI\u0018-\\7fe6+GO]5d-\u0006dW/\u001a\u000b\u0005\u0003S\u0014\u0019\u0007C\u0004\u0003\u000e\tu\u0003\u0019A&\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j\u0005y\u00110Y7nKJD\u0015n\u001d;pOJ\fW\u000e\u0006\u0003\u0003l\t\u0005\u0005\u0003\u0002B7\u0005{j!Aa\u001c\u000b\t\tE$1O\u0001\u0005G>\u0014XM\u0003\u0003\u0002z\tU$\u0002\u0002B<\u0005s\na!_1n[\u0016\u0014(B\u0001B>\u0003\r\u0019w.\\\u0005\u0005\u0005\u007f\u0012yGA\u0005ISN$xn\u001a:b[\"9!Q\u0002B3\u0001\u0004Y\u0005b\u0002BC\u0001\u0011%!qQ\u0001\u001bm\u0016\u0014\u0018NZ=ZC6lWM]'fiJL7MU3d_J$W\r\u001a\u000b\u0007\u0005[\u0011IIa#\t\u000f\t5!1\u0011a\u0001\u0017\"Q\u0011\u0011\u001fBB!\u0003\u0005\rA!$\u0011\u000f]\t)P!\f\u0003\u0010B\u0019qC!%\n\u0007\tM\u0005DA\u0004C_>dW-\u00198\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\u00061b/\u001a:jMftuNU3rk\u0016\u001cH/T3ue&\u001c7\u000fF\u0002x\u00057CqA!(\u0003\u0016\u0002\u00071*\u0001\u0007feJ|'/T3tg\u0006<W\rC\u0005\u0003\"\u0002\t\n\u0011\"\u0003\u0003$\u0006\u0019c/\u001a:jMf\\\u0015MZ6b\u001b\u0016$(/[2SK\u000e|'\u000fZ3eI\u0011,g-Y;mi\u0012\"TC\u0001BSU\u0011\u0011\tCa*,\u0005\t%\u0006\u0003\u0002BV\u0005kk!A!,\u000b\t\t=&\u0011W\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa-\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005o\u0013iKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba/\u0001#\u0003%IA!0\u00027Y,'/\u001b4z\u0017\u000647.Y'fiJL7\r\n3fM\u0006,H\u000e\u001e\u00135+\u0011\u0011\u0019Ka0\u0005\u0011\u0005\u0015(\u0011\u0018b\u0001\u0003OD\u0011Ba1\u0001#\u0003%IA!2\u0002IY,'/\u001b4z3\u0006lW.\u001a:NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3%I\u00164\u0017-\u001e7uII*\"Aa2+\t\t5%q\u0015")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @Before
    public void setUp() {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic, 1, 1, props);
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, TestUtils$.MODULE$.consumeRecords$default$3());
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", "SCRAM-SHA-256");
        String x$9 = this.brokerList();
        int x$10 = 0;
        int x$11 = 1000;
        long x$12 = 1000L;
        SecurityProtocol x$13 = this.securityProtocol();
        Option<File> x$14 = this.trustStoreFile();
        Some x$15 = new Some((Object)saslProps);
        long x$16 = TestUtils$.MODULE$.createProducer$default$4();
        int x$17 = TestUtils$.MODULE$.createProducer$default$5();
        int x$18 = TestUtils$.MODULE$.createProducer$default$6();
        int x$19 = TestUtils$.MODULE$.createProducer$default$7();
        int x$20 = TestUtils$.MODULE$.createProducer$default$8();
        String x$21 = TestUtils$.MODULE$.createProducer$default$9();
        ByteArraySerializer x$22 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$23 = TestUtils$.MODULE$.createProducer$default$15();
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$9, x$10, x$12, x$16, x$17, x$18, x$19, x$20, x$21, x$11, x$13, x$14, (Option<Properties>)x$15, x$22, x$23);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(consumer.metrics().keySet()).asScala()).toSet();
        ((IterableLike)consumerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(producer.metrics().keySet()).asScala()).toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableLike)((TraversableLike)producerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"commit-id", "version"}))).foreach((Function1 & Serializable & scala.Serializable)name -> {
            this.verifyKafkaMetric(name, metrics, entity, this.verifyKafkaMetric$default$4(), (Function1 & Serializable & scala.Serializable)matchingMetrics -> {
                MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, matchingMetrics);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.maxKafkaMetricValue("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed-authentication-total not updated", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assert.assertTrue((String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString(), (tempBytes >= (double)recordSize ? 1 : 0) != 0);
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        this.verifyYammerMetricRecorded(new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString(), (Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)value -> value > 0.0);
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        this.verifyYammerMetricRecorded(new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString(), (Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)value -> value == 0.0);
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        long newCount = histogram.count();
        Assert.assertTrue((String)"ZooKeeper latency not recorded", (newCount > initialCount ? 1 : 0) != 0);
        double min = histogram.min();
        Assert.assertTrue((String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString(), (min >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unexpected ZK state", (Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"));
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        Object object;
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        try {
            KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
            object = consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {
            object = BoxedUnit.UNIT;
        }
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assert.assertEquals((long)(startErrorMetricCount + 1), (long)currentErrorMetricCount);
        Assert.assertTrue((String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString(), (currentErrorMetricCount < 10 ? 1 : 0) != 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 1, 100, new TopicPartition("non-existent", 0));
        this.verifyYammerMetricRecorded(new StringBuilder(44).append(errorMetricPrefix).append(",request=Metadata,error=LEADER_NOT_AVAILABLE").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assert.assertTrue((String)new StringBuilder(17).append("Metric not found ").append(name).toString(), (boolean)matchingMetrics.nonEmpty());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        return BoxesRunTime.unboxToDouble(this.verifyKafkaMetric(name, metrics, entity, group, (Function1 & Serializable & scala.Serializable)matchingMetrics -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics))));
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assert.assertTrue((String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString(), (value > 0.0 ? 1 : 0) != 0);
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    private Object yammerMetricValue(String name) {
        Object object;
        Metric metric;
        Metric metric2;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Metric metric3 = metric2 = (Metric)tuple2._2();
        Metric metric4 = metric = metric3;
        if (metric4 instanceof Meter) {
            Meter meter = (Meter)metric4;
            object = BoxesRunTime.boxToDouble((double)meter.count());
        } else if (metric4 instanceof Histogram) {
            Histogram histogram = (Histogram)metric4;
            object = BoxesRunTime.boxToDouble((double)histogram.max());
        } else if (metric4 instanceof Gauge) {
            Gauge gauge = (Gauge)metric4;
            object = gauge.value();
        } else {
            throw this.fail(new StringBuilder(34).append("Unexpected broker metric of class ").append(metric4.getClass()).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        }
        return object;
    }

    private Histogram yammerHistogram(String name) {
        Histogram histogram;
        Metric metric;
        Metric metric2;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Metric metric3 = metric2 = (Metric)tuple2._2();
        Metric metric4 = metric = metric3;
        if (!(metric4 instanceof Histogram)) {
            throw this.fail(new StringBuilder(34).append("Unexpected broker metric of class ").append(metric4.getClass()).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        }
        Histogram histogram2 = histogram = (Histogram)metric4;
        return histogram2;
    }

    /*
     * WARNING - void declaration
     */
    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        void var3_3;
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assert.assertTrue((String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString(), (boolean)verify.apply$mcZD$sp(metricValue));
        return (double)var3_3;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable & scala.Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$4)));
        Assert.assertTrue((String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString(), (boolean)metrics.isEmpty());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assert.assertTrue((String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString(), (totalExists || totalTimeExists ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$4, Iterable matchingMetrics) {
        Assert.assertEquals((long)1L, (long)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assert.assertNotNull((String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$4).toString(), (Object)value);
        Assert.assertNotNull((String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$4).append(" should be a non-empty String").toString(), (Object)BoxesRunTime.boxToBoolean((value instanceof String && !((String)value).isEmpty() ? 1 : 0) != 0));
        Assert.assertTrue((String)"Client-id not specified", (boolean)metric.metricName().tags().containsKey("client-id"));
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final int errorMetricCount$1() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)))).size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$1, Option group$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MetricName metricName = (MetricName)tuple2._1();
        String string = metricName.name();
        String string2 = name$1;
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && group$1.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        return bl;
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
        boolean bl = n.getMBeanName().endsWith(name$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
        boolean bl = n.getMBeanName().endsWith(name$2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        com.yammer.metrics.core.MetricName n = (com.yammer.metrics.core.MetricName)tuple2._1();
        boolean bl = n.getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        return bl;
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableDoc(), "false");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

