/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.api.BaseConsumerTest;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015a\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012a\u0003;fgRDU-\u00193feN$\u0012a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u00115A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgR4qa\t\u0001\u0011\u0002\u0007\u0005AE\u0001\bTKJL\u0017\r\\5{KJLU\u000e\u001d7\u0014\u0007\t*S\u0006\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\r=\u0013'.Z2u!\rqc\u0007O\u0007\u0002_)\u0011\u0001'M\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005I\u001a\u0014AB2p[6|gN\u0003\u0002\u0006i)\u0011QGH\u0001\u0007CB\f7\r[3\n\u0005]z#AC*fe&\fG.\u001b>feB\u0019A#O\u001e\n\u0005i*\"!B!se\u0006L\bC\u0001\u000b=\u0013\tiTC\u0001\u0003CsR,\u0007\"B #\t\u0003\u0011\u0012A\u0002\u0013j]&$H\u0005C\u0004BE\u0001\u0007I\u0011\u0001\"\u0002\u0015M,'/[1mSj,'/F\u0001D!\tqC)\u0003\u0002F_\t\u0019\")\u001f;f\u0003J\u0014\u0018-_*fe&\fG.\u001b>fe\"9qI\ta\u0001\n\u0003A\u0015AD:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0003'%CqA\u0013$\u0002\u0002\u0003\u00071)A\u0002yIEBQ\u0001\u0014\u0012\u0005B5\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\tar5l\u0019\u0005\u0006\u001f.\u0003\r\u0001U\u0001\u0006i>\u0004\u0018n\u0019\t\u0003#bs!A\u0015,\u0011\u0005M+R\"\u0001+\u000b\u0005U3\u0011A\u0002\u001fs_>$h(\u0003\u0002X+\u00051\u0001K]3eK\u001aL!!\u0017.\u0003\rM#(/\u001b8h\u0015\t9V\u0003C\u0003]\u0017\u0002\u0007Q,A\u0004iK\u0006$WM]:\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\f\u0014A\u00025fC\u0012,'/\u0003\u0002c?\n9\u0001*Z1eKJ\u001c\b\"\u00023L\u0001\u0004A\u0014\u0001\u00023bi\u0006DQA\u001a\u0012\u0005B\u001d\f\u0011bY8oM&<WO]3\u0015\u0007MAG\u0010C\u0003jK\u0002\u0007!.A\u0004d_:4\u0017nZ:1\u0005-\u001c\b\u0003\u00027p!Fl\u0011!\u001c\u0006\u0003]&\nA!\u001e;jY&\u0011\u0001/\u001c\u0002\u0004\u001b\u0006\u0004\bC\u0001:t\u0019\u0001!\u0011\u0002\u001e5\u0002\u0002\u0003\u0005)\u0011A;\u0003\u0007}#\u0013'\u0005\u0002wsB\u0011Ac^\u0005\u0003qV\u0011qAT8uQ&tw\r\u0005\u0002\u0015u&\u001110\u0006\u0002\u0004\u0003:L\b\"B?f\u0001\u0004q\u0018!B5t\u0017\u0016L\bC\u0001\u000b\u0000\u0013\r\t\t!\u0006\u0002\b\u0005>|G.Z1o\u0011\u0019\t)A\tC!%\u0005)1\r\\8tK\"1AJ\tC!\u0003\u0013!R\u0001OA\u0006\u0003\u001bAaaTA\u0004\u0001\u0004\u0001\u0006B\u00023\u0002\b\u0001\u0007\u0001HB\u0005\u0002\u0012\u0001\u0001\n1!\u0001\u0002\u0014\t\u0001B)Z:fe&\fG.\u001b>fe&k\u0007\u000f\\\n\u0006\u0003\u001f)\u0013Q\u0003\t\u0005]\u0005]\u0001(C\u0002\u0002\u001a=\u0012A\u0002R3tKJL\u0017\r\\5{KJDaaPA\b\t\u0003\u0011\u0002BCA\u0010\u0003\u001f\u0001\r\u0011\"\u0001\u0002\"\u0005aA-Z:fe&\fG.\u001b>feV\u0011\u00111\u0005\t\u0004]\u0005\u0015\u0012bAA\u0014_\t)\")\u001f;f\u0003J\u0014\u0018-\u001f#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bBCA\u0016\u0003\u001f\u0001\r\u0011\"\u0001\u0002.\u0005\u0001B-Z:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0004'\u0005=\u0002\"\u0003&\u0002*\u0005\u0005\t\u0019AA\u0012\u0011!\t\u0019$a\u0004\u0005B\u0005U\u0012a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$r\u0001OA\u001c\u0003s\tY\u0004\u0003\u0004P\u0003c\u0001\r\u0001\u0015\u0005\u00079\u0006E\u0002\u0019A/\t\r\u0011\f\t\u00041\u00019\u0011\u001d1\u0017q\u0002C!\u0003\u007f!RaEA!\u0003\u001bBq![A\u001f\u0001\u0004\t\u0019\u0005\r\u0003\u0002F\u0005%\u0003#\u00027p!\u0006\u001d\u0003c\u0001:\u0002J\u0011Y\u00111JA!\u0003\u0003\u0005\tQ!\u0001v\u0005\ryFE\r\u0005\u0007{\u0006u\u0002\u0019\u0001@\t\u000f\u0005\u0015\u0011q\u0002C!%!A\u00111GA\b\t\u0003\n\u0019\u0006F\u00039\u0003+\n9\u0006\u0003\u0004P\u0003#\u0002\r\u0001\u0015\u0005\u0007I\u0006E\u0003\u0019\u0001\u001d\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^\u0005yB/Z:u\u0011\u0016\fG-\u001a:t'\u0016\u0014\u0018.\u00197ju\u0016$Um]3sS\u0006d\u0017N_3\u0015\u000bM\ty&!\u0019\t\r\u0005\u000bI\u00061\u0001.\u0011!\ty\"!\u0017A\u0002\u0005U\u0001BBA3\u0001\u0011\u0005!#A\u0015uKN$\b*Z1eKJ\u001cX\t\u001f;f]\u0012,GmU3sS\u0006d\u0017N_3s\t\u0016\u001cXM]5bY&TXM\u001d\u0015\u0004\u0003GR\u0002BBA6\u0001\u0011\u0005!#A\u0011uKN$\b*Z1eKJ\u001c8+\u001a:jC2L'0\u001a:EKN,'/[1mSj,'\u000fK\u0002\u0002jiAa!!\u001d\u0001\t\u0003\u0011\u0012A\u0005;fgRl\u0015\r\u001f)pY2\u0014VmY8sIND3!a\u001c\u001b\u0011\u0019\t9\b\u0001C\u0001%\u0005)B/Z:u\u001b\u0006D\bk\u001c7m\u0013:$XM\u001d<bY6\u001b\bfAA;5!1\u0011Q\u0010\u0001\u0005\u0002I\ta\u0005^3ti6\u000b\u0007\u0010U8mY&sG/\u001a:wC2l5\u000fR3mCfLeNU3w_\u000e\fG/[8oQ\r\tYH\u0007\u0005\u0007\u0003\u0007\u0003A\u0011\u0001\n\u0002MQ,7\u000f^'bqB{G\u000e\\%oi\u0016\u0014h/\u00197Ng\u0012+G.Y=J]\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u0002\u0002jAa!!#\u0001\t\u0003\u0011\u0012!\u0006;fgR\fU\u000f^8D_6l\u0017\u000e^(o\u00072|7/\u001a\u0015\u0004\u0003\u000fS\u0002BBAH\u0001\u0011\u0005!#\u0001\u0011uKN$\u0018)\u001e;p\u0007>lW.\u001b;P]\u000ecwn]3BMR,'oV1lKV\u0004\bfAAG5!1\u0011Q\u0013\u0001\u0005\u0002I\t1\u0003^3ti\u0006+Ho\\(gMN,GOU3tKRD3!a%\u001b\u0011\u0019\tY\n\u0001C\u0001%\u0005!B/Z:u\u000fJ|W\u000f]\"p]N,X\u000e\u001d;j_:D3!!'\u001b\u0011\u0019\t\t\u000b\u0001C\u0001%\u00059B/Z:u!\u0006$H/\u001a:o'V\u00147o\u0019:jaRLwN\u001c\u0015\u0004\u0003?S\u0002BBAT\u0001\u0011\u0005!#A\u0011uKN$8+\u001e2tKF,XM\u001c;QCR$XM\u001d8Tk\n\u001c8M]5qi&|g\u000eK\u0002\u0002&jAa!!,\u0001\t\u0003\u0011\u0012!\u0007;fgR\u0004\u0016\r\u001e;fe:,fn];cg\u000e\u0014\u0018\u000e\u001d;j_:D3!a+\u001b\u0011\u0019\t\u0019\f\u0001C\u0001%\u0005\u0011B/Z:u\u0007>lW.\u001b;NKR\fG-\u0019;bQ\r\t\tL\u0007\u0005\u0007\u0003s\u0003A\u0011\u0001\n\u0002\u001fQ,7\u000f^!ts:\u001c7i\\7nSRD3!a.\u001b\u0011\u0019\ty\f\u0001C\u0001%\u0005yB/Z:u\u000bb\u0004\u0018M\u001c3j]\u001e$v\u000e]5d'V\u00147o\u0019:jaRLwN\\:)\u0007\u0005u&\u0004\u0003\u0004\u0002F\u0002!\tAE\u0001 i\u0016\u001cHo\u00155sS:\\\u0017N\\4U_BL7mU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\bfAAb5!1\u00111\u001a\u0001\u0005\u0002I\t\u0011\u0003^3tiB\u000b'\u000f^5uS>t7OR8sQ\r\tIM\u0007\u0005\u0007\u0003#\u0004A\u0011\u0001\n\u00027Q,7\u000f\u001e)beRLG/[8og\u001a{'/Q;u_\u000e\u0013X-\u0019;fQ\r\tyM\u0007\u0005\u0007\u0003/\u0004A\u0011\u0001\n\u0002;Q,7\u000f\u001e)beRLG/[8og\u001a{'/\u00138wC2LG\rV8qS\u000eDs!!6\u001b\u00037\fi.\u0001\u0005fqB,7\r^3eG\t\ty\u000e\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)/M\u0001\u0007KJ\u0014xN]:\n\t\u0005%\u00181\u001d\u0002\u0016\u0013:4\u0018\r\\5e)>\u0004\u0018nY#yG\u0016\u0004H/[8o\u0011\u0019\ti\u000f\u0001C\u0001%\u0005AA/Z:u'\u0016,7\u000eK\u0002\u0002ljAq!a=\u0001\t\u0013\t)0\u0001\ftK:$7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3t)\u0015\u0019\u0012q\u001fB\u0001\u0011!\tI0!=A\u0002\u0005m\u0018A\u00038v[J+7m\u001c:egB\u0019A#!@\n\u0007\u0005}XCA\u0002J]RD\u0001Ba\u0001\u0002r\u0002\u0007!QA\u0001\u0003iB\u0004BAa\u0002\u0003\n5\t\u0011'C\u0002\u0003\fE\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0003\u0010\u0001!\tAE\u0001\u0016i\u0016\u001cH\u000fU8tSRLwN\\!oI\u000e{W.\\5uQ\r\u0011iA\u0007\u0005\u0007\u0005+\u0001A\u0011\u0001\n\u00027Q,7\u000f\u001e)beRLG/[8o!\u0006,8/Z!oIJ+7/^7fQ\r\u0011\u0019B\u0007\u0005\u0007\u00057\u0001A\u0011\u0001\n\u0002-Q,7\u000f\u001e$fi\u000eD\u0017J\u001c<bY&$wJ\u001a4tKRD3A!\u0007\u001b\u0011\u0019\u0011\t\u0003\u0001C\u0001%\u00051C/Z:u\r\u0016$8\r\u001b*fG>\u0014H\rT1sO\u0016\u0014H\u000b[1o\r\u0016$8\r['bq\nKH/Z:)\u0007\t}!\u0004C\u0004\u0003(\u0001!IA!\u000b\u0002!\rDWmY6MCJ<WMU3d_J$GcA\n\u0003,!A!Q\u0006B\u0013\u0001\u0004\tY0\u0001\nqe>$WoY3s%\u0016\u001cwN\u001d3TSj,\u0007B\u0002B\u0019\u0001\u0011\u0005!#\u0001\u0018uKN$h)\u001a;dQ\"{gn\\;sg\u001a+Go\u00195TSj,\u0017J\u001a'be\u001e,'+Z2pe\u0012tu\u000e\u001e$jeN$\bf\u0001B\u00185!9!q\u0007\u0001\u0005\n\te\u0012AK2iK\u000e\\g)\u001a;dQ\"{gn\\;sgNK'0Z%g\u0019\u0006\u0014x-\u001a*fG>\u0014HMT8u\r&\u00148\u000f\u001e\u000b\u0004'\tm\u0002\u0002\u0003B\u001f\u0005k\u0001\r!a?\u0002/1\f'oZ3Qe>$WoY3s%\u0016\u001cwN\u001d3TSj,\u0007B\u0002B!\u0001\u0011\u0005!#A\u001euKN$h)\u001a;dQ\"{gn\\;sg6\u000b\u0007\u0010U1si&$\u0018n\u001c8GKR\u001c\u0007NQ=uKNLe\rT1sO\u0016\u0014VmY8sI:{GOR5sgRD3Aa\u0010\u001b\u0011\u0019\u00119\u0005\u0001C\u0001%\u0005yC/Z:u\r\u0016$8\r\u001b*fG>\u0014H\rT1sO\u0016\u0014H\u000b[1o\u001b\u0006D\b+\u0019:uSRLwN\u001c$fi\u000eD')\u001f;fg\"\u001a!Q\t\u000e\t\r\t5\u0003\u0001\"\u0001\u0013\u0003%\"Xm\u001d;M_^l\u0015\r\u001f$fi\u000eD7+\u001b>f\r>\u0014(+Z9vKN$\u0018I\u001c3QCJ$\u0018\u000e^5p]\"\u001a!1\n\u000e\t\r\tM\u0003\u0001\"\u0001\u0013\u0003a!Xm\u001d;S_VtGMU8cS:\f5o]5h]6,g\u000e\u001e\u0015\u0004\u0005#R\u0002B\u0002B-\u0001\u0011\u0005!#A\u0013uKN$X*\u001e7uS\u000e{gn];nKJ\u0014v.\u001e8e%>\u0014\u0017N\\!tg&<g.\\3oi\"\u001a!q\u000b\u000e\t\r\t}\u0003\u0001\"\u0001\u0013\u0003\u0005\"Xm\u001d;Nk2$\u0018nQ8ogVlWM]*uS\u000e\\\u00170Q:tS\u001etW.\u001a8uQ\r\u0011iF\u0007\u0005\u0007\u0005K\u0002A\u0011\u0001\n\u0002EQ,7\u000f^'vYRL7i\u001c8tk6,'\u000fR3gCVdG/Q:tS\u001etW.\u001a8uQ\r\u0011\u0019G\u0007\u0005\u0007\u0005W\u0002A\u0011\u0001\n\u0002YQ,7\u000f^'vYRL7i\u001c8tk6,'oU3tg&|g\u000eV5nK>,Ho\u00148Ti>\u0004\bk\u001c7mS:<\u0007f\u0001B55!1!\u0011\u000f\u0001\u0005\u0002I\ta\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s'\u0016\u001c8/[8o)&lWm\\;u\u001f:\u001cEn\\:fQ\r\u0011yG\u0007\u0005\u0007\u0005o\u0002A\u0011\u0001\n\u0002!Q,7\u000f^%oi\u0016\u00148-\u001a9u_J\u001c\bf\u0001B;5!1!Q\u0010\u0001\u0005\u0002I\tq\u0003^3ti\u0006+Ho\\\"p[6LG/\u00138uKJ\u001cW\r\u001d;)\u0007\tm$\u0004\u0003\u0004\u0003\u0004\u0002!\tAE\u0001\"i\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peN<\u0016\u000e\u001e5Xe>twmS3z-\u0006dW/\u001a\u0015\u0004\u0005\u0003S\u0002B\u0002BE\u0001\u0011\u0005!#A\u0011uKN$8i\u001c8tk6,W*Z:tC\u001e,7oV5uQ\u000e\u0013X-\u0019;f)&lW\rK\u0002\u0003\bjAaAa$\u0001\t\u0003\u0011\u0012\u0001\n;fgR\u001cuN\\:v[\u0016lUm]:bO\u0016\u001cx+\u001b;i\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3)\u0007\t5%\u0004\u0003\u0004\u0003\u0016\u0002!\tAE\u0001\u000fi\u0016\u001cH\u000fT5tiR{\u0007/[2tQ\r\u0011\u0019J\u0007\u0005\u0007\u00057\u0003A\u0011\u0001\n\u0002'Q,7\u000f^(gMN,Go\u001d$peRKW.Z:)\u0007\te%\u0004\u0003\u0004\u0003\"\u0002!\tAE\u0001\u001ci\u0016\u001cH/R1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r^:)\u0007\t}%\u0004\u0003\u0004\u0003(\u0002!\tAE\u0001\u0015i\u0016\u001cH/\u00168tk\n\u001c8M]5cKR{\u0007/[2)\u0007\t\u0015&\u0004\u0003\u0004\u0003.\u0002!\tAE\u0001&i\u0016\u001cH\u000fU1vg\u0016\u001cF/\u0019;f\u001d>$\bK]3tKJ4X\r\u001a\"z%\u0016\u0014\u0017\r\\1oG\u0016D3Aa+\u001b\u0011\u0019\u0011\u0019\f\u0001C\u0001%\u0005QB/Z:u\u0007>lW.\u001b;Ta\u0016\u001c\u0017NZ5fI>3gm]3ug\"\u001a!\u0011\u0017\u000e\t\r\te\u0006\u0001\"\u0001\u0013\u0003e!Xm\u001d;BkR|7i\\7nSR|eNU3cC2\fgnY3)\u0007\t]&\u0004\u0003\u0004\u0003@\u0002!\tAE\u00010i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:dU-\u00193NKR\u0014\u0018nY:DY\u0016\fg.\u00169XSRD7+\u001e2tGJL'-\u001a\u0015\u0004\u0005{S\u0002B\u0002Bc\u0001\u0011\u0005!#\u0001\u0018uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2\u000bw-T3ue&\u001c7o\u00117fC:,\u0006oV5uQN+(m]2sS\n,\u0007f\u0001Bb5!1!1\u001a\u0001\u0005\u0002I\tA\u0006^3tiB+'\u000fU1si&$\u0018n\u001c8MK\u0006$W*\u001a;sS\u000e\u001c8\t\\3b]V\u0003x+\u001b;i\u0003N\u001c\u0018n\u001a8)\u0007\t%'\u0004\u0003\u0004\u0003R\u0002!\tAE\u0001,i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:d\u0015mZ'fiJL7m]\"mK\u0006tW\u000b],ji\"\f5o]5h]\"\u001a!q\u001a\u000e\t\r\t]\u0007\u0001\"\u0001\u0013\u0003-\"Xm\u001d;QKJ\u0004\u0016M\u001d;ji&|g\u000eT1h\u001b\u0016$(/[2t/\",gNU3bI\u000e{W.\\5ui\u0016$\u0007f\u0001Bk5!1!Q\u001c\u0001\u0005\u0002I\ta\u0005^3tiB+'\u000fU1si&$\u0018n\u001c8MK\u0006$w+\u001b;i\u001b\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3tQ\r\u0011YN\u0007\u0005\u0007\u0005G\u0004A\u0011\u0001\n\u0002KQ,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Y4XSRDW*\u0019=Q_2d'+Z2pe\u0012\u001c\bf\u0001Bq5!1!\u0011\u001e\u0001\u0005\u0002I\ta\u0006^3tiF+x\u000e^1NKR\u0014\u0018nY:O_R\u001c%/Z1uK\u0012LeMT8Rk>$\u0018m]\"p]\u001aLw-\u001e:fI\"\u001a!q\u001d\u000e\t\u000f\t=\b\u0001\"\u0001\u0003r\u0006\u0011#/\u001e8Nk2$\u0018nQ8ogVlWM]*fgNLwN\u001c+j[\u0016|W\u000f\u001e+fgR$2a\u0005Bz\u0011\u001d\u0011)P!<A\u0002y\fQb\u00197pg\u0016\u001cuN\\:v[\u0016\u0014\bb\u0002B}\u0001\u0011\u0005!1`\u0001\u001aGJ,\u0017\r^3U_BL7-\u00118e'\u0016tGMU3d_J$7\u000f\u0006\u0006\u0003~\u000e\r1QCB\r\u0007;\u0001R!\u0015B\u0000\u0005\u000bI1a!\u0001[\u0005\r\u0019V\r\u001e\u0005\t\u0007\u000b\u00119\u00101\u0001\u0004\b\u0005A\u0001O]8ek\u000e,'\u000f\u0005\u0004\u0004\n\rE\u0001\bO\u0007\u0003\u0007\u0017QAa!\u0002\u0004\u000e)\u00191qB\u001a\u0002\u000f\rd\u0017.\u001a8ug&!11CB\u0006\u00055Y\u0015MZ6b!J|G-^2fe\"91q\u0003B|\u0001\u0004\u0001\u0016!\u0003;pa&\u001cg*Y7f\u0011!\u0019YBa>A\u0002\u0005m\u0018!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0003\u0005\u0004 \t]\b\u0019AA~\u0003M\u0011XmY8sIN\u0004VM\u001d)beRLG/[8o\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u0007K\t\u0001e];cg\u000e\u0014\u0018NY3D_:\u001cX/\\3s\u0003:$7\u000b^1siB{G\u000e\\5oOR11qEB\u0018\u0007{\u0001Ba!\u000b\u0004,5\t\u0001!C\u0002\u0004.)\u0011\u0001dQ8ogVlWM]!tg&<g.\\3oiB{G\u000e\\3s\u0011!\u0019\td!\tA\u0002\rM\u0012\u0001C2p]N,X.\u001a:\u0011\r\rU2\u0011\b\u001d9\u001b\t\u00199D\u0003\u0003\u00042\r5\u0011\u0002BB\u001e\u0007o\u0011\u0001bQ8ogVlWM\u001d\u0005\t\u0007\u007f\u0019\t\u00031\u0001\u0004B\u0005\tBo\u001c9jGN$vnU;cg\u000e\u0014\u0018NY3\u0011\u000b\r\r3Q\n)\u000f\t\r\u00153\u0011\n\b\u0004'\u000e\u001d\u0013\"\u0001\f\n\u0007\r-S#A\u0004qC\u000e\\\u0017mZ3\n\t\r=3\u0011\u000b\u0002\u0005\u0019&\u001cHOC\u0002\u0004LUAqa!\u0016\u0001\t\u0003\u00199&\u0001\ntk\n\u001c8M]5cK\u000e{gn];nKJ\u001cHCBB-\u0007S\u001a)\b\u0005\u0004\u0004\\\r\u00154qE\u0007\u0003\u0007;RAaa\u0018\u0004b\u00059Q.\u001e;bE2,'bAB2+\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r\u001d4Q\f\u0002\u0007\u0005V4g-\u001a:\t\u0011\r-41\u000ba\u0001\u0007[\nQbY8ogVlWM]$s_V\u0004\bCBB.\u0007K\u001ay\u0007\u0005\u0004\u00046\rE\u0004\bO\u0005\u0005\u0007g\u001a9DA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\u0005\t\u0007\u007f\u0019\u0019\u00061\u0001\u0004B!91\u0011\u0010\u0001\u0005\u0002\rm\u0014aJ2sK\u0006$XmQ8ogVlWM]$s_V\u0004\u0018I\u001c3XC&$hi\u001c:BgNLwM\\7f]R$\u0002b! \u0004\u0004\u000e\u001d5\u0011\u0012\t\b)\r}4QNB-\u0013\r\u0019\t)\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\r\u00155q\u000fa\u0001\u0003w\fQbY8ogVlWM]\"pk:$\b\u0002CB \u0007o\u0002\ra!\u0011\t\u0011\r-5q\u000fa\u0001\u0005{\fQb];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\bbBBH\u0001\u0011\u00051\u0011S\u0001-C\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u001e\u0013x.\u001e9BgNLwM\\7f]R$2bEBJ\u0007/\u001bIj!(\u0004 \"A1QSBG\u0001\u0004\tY0A\nok6|emQ8ogVlWM]:U_\u0006#G\r\u0003\u0005\u0004l\r5\u0005\u0019AB7\u0011!\u0019Yj!$A\u0002\re\u0013aD2p]N,X.\u001a:Q_2dWM]:\t\u0011\r}2Q\u0012a\u0001\u0007\u0003B\u0001ba#\u0004\u000e\u0002\u0007!Q \u0005\b\u0007G\u0003A\u0011ABS\u0003]1\u0018\r\\5eCR,wI]8va\u0006\u001b8/[4o[\u0016tG\u000fF\u0005\u0014\u0007O\u001bIka+\u00040\"A11TBQ\u0001\u0004\u0019I\u0006\u0003\u0005\u0004\f\u000e\u0005\u0006\u0019\u0001B\u007f\u0011\u001d\u0019ik!)A\u0002A\u000b1!\\:h\u0011)\u0019\tl!)\u0011\u0002\u0003\u000711W\u0001\to\u0006LG\u000fV5nKB\u0019Ac!.\n\u0007\r]VC\u0001\u0003M_:<\u0007bBB^\u0001\u0011\u00051QX\u00015G\"\fgnZ3D_:\u001cX/\\3s\u000fJ|W\u000f]*vEN\u001c'/\u001b9uS>t\u0017I\u001c3WC2LG-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$HcB\n\u0004@\u000e\u000571\u0019\u0005\t\u00077\u001bI\f1\u0001\u0004Z!A1qHB]\u0001\u0004\u0019\t\u0005\u0003\u0005\u0004\f\u000ee\u0006\u0019\u0001B\u007f\u0011\u001d\u00199\r\u0001C\u0001\u0007\u0013\fqf\u00195b]\u001e,7i\u001c8tk6,'oU;cg\u000e\u0014\u0018\u000e\u001d;j_:\fe\u000e\u001a,bY&$\u0017\r^3BgNLwM\\7f]R,baa3\u0004T\u000eeG#C\n\u0004N\u000eu7q\\Bq\u0011!\u0019\td!2A\u0002\r=\u0007\u0003CB\u001b\u0007s\u0019\tna6\u0011\u0007I\u001c\u0019\u000eB\u0004\u0004V\u000e\u0015'\u0019A;\u0003\u0003-\u00032A]Bm\t\u001d\u0019Yn!2C\u0002U\u0014\u0011A\u0016\u0005\t\u0007\u007f\u0019)\r1\u0001\u0004B!A11RBc\u0001\u0004\u0011i\u0010\u0003\u0005\u0004d\u000e\u0015\u0007\u0019ABs\u0003E\u0011XMY1mC:\u001cW\rT5ti\u0016tWM\u001d\t\u0005\u0007k\u00199/\u0003\u0003\u0004j\u000e]\"!G\"p]N,X.\u001a:SK\n\fG.\u00198dK2K7\u000f^3oKJD\u0011b!<\u0001#\u0003%\taa<\u0002CY\fG.\u001b3bi\u0016<%o\\;q\u0003N\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\rE(\u0006BBZ\u0007g\\#a!>\u0011\t\r]H\u0011A\u0007\u0003\u0007sTAaa?\u0004~\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u007f,\u0012AC1o]>$\u0018\r^5p]&!A1AB}\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testHeaders() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(record);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assert.assertEquals((long)numRecords, (long)records.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            Header header = record.headers().lastHeader("headerKey");
            Assert.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        KafkaProducer producer = this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3());
        producer.send(record);
        KafkaConsumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assert.assertEquals((long)numRecords, (long)records.size());
    }

    @Test
    public void testHeadersExtendedSerializerDeserializer() {
        ExtendedSerializer<byte[]> extendedSerializer = new ExtendedSerializer<byte[]>(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return SerializerImpl.serialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                SerializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                SerializerImpl.close$(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return SerializerImpl.serialize$(this, topic, data);
            }

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                SerializerImpl.$init$(this);
            }
        };
        ExtendedDeserializer<byte[]> extendedDeserializer = new ExtendedDeserializer<byte[]>(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                DeserializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                DeserializerImpl.close$(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, data);
            }

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                DeserializerImpl.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize((Serializer<byte[]>)extendedSerializer, (Deserializer<byte[]>)extendedDeserializer);
    }

    @Test
    public void testHeadersSerializerDeserializer() {
        SerializerImpl extendedSerializer = new SerializerImpl(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return SerializerImpl.serialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                SerializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                SerializerImpl.close$(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return SerializerImpl.serialize$(this, topic, data);
            }

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                SerializerImpl.$init$(this);
            }
        };
        DeserializerImpl extendedDeserializer = new DeserializerImpl(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                DeserializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                DeserializerImpl.close$(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, data);
            }

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                DeserializerImpl.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$21 = consumer;
        int x$22 = numRecords;
        int x$23 = 0;
        int x$24 = maxPollRecords;
        int x$25 = this.consumeAndVerifyRecords$default$4();
        long x$26 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$27 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$28 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$21, x$22, x$23, x$25, x$26, x$27, x$28, x$24);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)3000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)2000)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(0L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
        Thread.sleep(3500L);
        consumer.poll(0L);
        Assert.assertEquals((long)2L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)2L, (long)listener.callsToRevoked());
    }

    @Test
    public void testMaxPollIntervalMsDelayInRevocation() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)5000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1000)).toString());
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this, consumer, commitCompleted, committedPosition){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final KafkaConsumer consumer$1;
            private final BooleanRef commitCompleted$1;
            private final LongRef committedPosition$1;

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (this.callsToRevoked() > 0) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
                this.committedPosition$1 = committedPosition$1;
                super($outer);
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(0L);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"otherTopic", (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(0L);
        Assert.assertEquals((long)0L, (long)committedPosition.elem);
        Assert.assertTrue((boolean)commitCompleted.elem);
    }

    @Test
    public void testMaxPollIntervalMsDelayInAssignment() {
        this.consumerConfig().setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)5000)).toString());
        this.consumerConfig().setProperty("heartbeat.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)500)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1000)).toString());
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        consumer.poll(0L);
        consumer.poll(0L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)300L, (long)anotherConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)anotherConsumer.committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.wakeup();
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)300L, (long)anotherConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)anotherConsumer.committed(this.tp2()).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 1, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testGroupConsumption() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1));
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1));
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener(this));
        consumer.poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions$1.elem)).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions$1.elem)).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions$1.elem)).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions$1.elem)).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0));
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener(this));
        consumer.poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions$2.elem)).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions$2.elem)).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0));
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener(this));
        consumer.poll(50L);
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions$2.elem)).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions$2.elem)).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.serverCount(), this.createTopic$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0));
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener(this));
        consumer.poll(50L);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, Optional.of(Predef$.MODULE$.int2Integer(15)), "foo");
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assert.assertEquals((Object)syncMetadata, (Object)consumer.committed(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback(this);
        consumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)asyncMetadata)}))).asJava(), (OffsetCommitCallback)callback);
        this.awaitCommitCallback(consumer, callback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((Object)asyncMetadata, (Object)consumer.committed(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)nullMetadata)}))).asJava());
        Assert.assertEquals((Object)nullMetadata, (Object)consumer.committed(this.tp()));
    }

    @Test
    public void testAsyncCommit() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.poll(0L);
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback(this);
        int count = 5;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> consumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)callback));
        this.awaitCommitCallback(consumer, callback, count);
        Assert.assertEquals((Object)new OffsetAndMetadata((long)count), (Object)consumer.committed(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.createTopic(otherTopic, 2, this.serverCount(), this.createTopic$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expandedSubscriptions).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expandedSubscriptions).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.serverCount(), this.createTopic$default$4());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        scala.collection.immutable.Set shrunkenSubscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)shrunkenSubscriptions).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)shrunkenSubscriptions).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        this.createTopic("part-test", numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        java.util.List parts = consumer.partitionsFor("part-test");
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        java.util.List partitions = consumer.partitionsFor("non-exist-topic");
        Assert.assertFalse((boolean)partitions.isEmpty());
    }

    @Test(expected=InvalidTopicException.class)
    public void testPartitionsForInvalidTopic() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.partitionsFor(";3# ads,{234");
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, (int)totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp()), (float)0.0f);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.seek(this.tp(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp2()), (float)0.0f);
        KafkaConsumer x$29 = consumer;
        int x$30 = 1;
        int x$31 = 0;
        TopicPartition x$32 = this.tp2();
        int x$33 = this.consumeAndVerifyRecords$default$4();
        long x$34 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$35 = this.consumeAndVerifyRecords$default$6();
        int x$36 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$29, x$30, x$31, x$33, x$34, x$35, x$32, x$36);
        consumer.seek(this.tp2(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        KafkaConsumer x$37 = consumer;
        int x$38 = 1;
        int x$39 = (int)mid;
        int x$40 = (int)mid;
        long x$41 = mid;
        TopicPartition x$42 = this.tp2();
        TimestampType x$43 = this.consumeAndVerifyRecords$default$6();
        int x$44 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$37, x$38, x$39, x$40, x$41, x$43, x$42, x$44);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        Properties x$45 = producerProps;
        ByteArraySerializer x$46 = this.createProducer$default$1();
        ByteArraySerializer x$47 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$46, x$47, x$45);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes())));
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        Assert.assertNull((Object)consumer.committed(new TopicPartition(this.topic(), 15)));
        this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> consumer.position(new TopicPartition(this.topic(), 15)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((String)"position() on a partition that we are subscribed to should reset the offset", (long)0L, (long)consumer.position(this.tp()));
        consumer.commitSync();
        Assert.assertEquals((long)0L, (long)consumer.committed(this.tp()).offset());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        Assert.assertEquals((String)"After consuming 5 records, position should be 5", (long)5L, (long)consumer.position(this.tp()));
        consumer.commitSync();
        Assert.assertEquals((String)"Committed offset should be returned", (long)5L, (long)consumer.committed(this.tp()).offset());
        this.sendRecords(producer, 1, this.tp());
        KafkaConsumer otherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        otherConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)otherConsumer, 1, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.pause((Collection)partitions);
        this.sendRecords(producer, 5, this.tp());
        Assert.assertTrue((boolean)consumer.poll(0L).isEmpty());
        consumer.resume((Collection)partitions);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> consumer.poll(50L), ClassTag$.MODULE$.apply(NoOffsetForPartitionException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> consumer.poll(20000L), ClassTag$.MODULE$.apply(OffsetOutOfRangeException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
        java.util.Map outOfRangePartitions = e.offsetOutOfRangePartitions();
        Assert.assertNotNull((Object)outOfRangePartitions);
        Assert.assertEquals((long)1L, (long)outOfRangePartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)outOfRangePos), outOfRangePartitions.get(this.tp()));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(record);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(20000L);
        Assert.assertEquals((long)1L, (long)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(20000L);
        Assert.assertEquals((long)1L, (long)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assert.assertEquals((long)0L, (long)consumerRecord.offset());
        Assert.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assert.assertEquals((long)this.tp().partition(), (long)consumerRecord.partition());
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assert.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxPartitionFetchBytes)).toString());
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}));
        topics.foreach((Function1 & Serializable & scala.Serializable)topicName -> this.createTopic((String)topicName, partitionCount, this.serverCount(), this.createTopic$default$4()));
        Seq partitions = (Seq)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1 & Serializable & scala.Serializable)x$1 -> PlaintextConsumerTest.$anonfun$testLowMaxFetchSizeForRequestAndPartition$3(topic, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)partitions.toSet()).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Seq producerRecords = (Seq)partitions.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, partitionCount, (TopicPartition)x$2), Seq$.MODULE$.canBuildFrom());
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((TraversableOnce)producerRecords.map((Function1 & Serializable & scala.Serializable)record -> new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp()), Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set actual = ((TraversableOnce)consumerRecords.map((Function1 & Serializable & scala.Serializable)record -> new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp())), ArrayBuffer$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newExpectedAssignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newExpectedAssignment).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)consumerGroup, (Object)consumerPollers);
        Tuple2 tuple23 = tuple22;
        Buffer consumerGroup2 = (Buffer)tuple23._1();
        Buffer consumerPollers2 = (Buffer)tuple23._2();
        try {
            this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringBuilder(52).append("Did not get valid initial assignment for partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).toString(), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        finally {
            consumerPollers2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMultiConsumerStickyAssignment() {
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)consumerGroup, (Object)consumerPollers);
        Tuple2 tuple23 = tuple22;
        Buffer consumerGroup2 = (Buffer)tuple23._1();
        Buffer consumerPollers2 = (Buffer)tuple23._2();
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, partitions, new StringBuilder(52).append("Did not get valid initial assignment for partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter(partitions).asJava()).toString(), this.validateGroupAssignment$default$4());
        scala.collection.immutable.Map prePartition2PollerId = PlaintextConsumerTest.reverse$1(((TraversableOnce)consumerPollers2.map((Function1 & Serializable & scala.Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions);
        scala.collection.immutable.Map postPartition2PollerId = PlaintextConsumerTest.reverse$1(((TraversableOnce)consumerPollers2.map((Function1 & Serializable & scala.Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((GenSet)postPartition2PollerId.keySet());
        IntRef changes = IntRef.create((int)0);
        keys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            PlaintextConsumerTest.$anonfun$testMultiConsumerStickyAssignment$5(prePartition2PollerId, postPartition2PollerId, changes, key);
            return BoxedUnit.UNIT;
        });
        consumerPollers2.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Expected only two topic partitions that have switched to other consumers.", (long)rand, (long)changes.elem);
    }

    @Test
    public void testMultiConsumerDefaultAssignment() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp());
        this.sendRecords(producer, 100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3()));
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringBuilder(52).append("Did not get valid initial assignment for partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).toString(), this.validateGroupAssignment$default$4());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$9 -> (RecordMetadata)x$9.get());
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assert.assertEquals((long)numRecords, (long)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        try {
            testProducer.send(null);
            throw this.fail("Should not allow sending a null record", new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1050));
        }
        catch (Throwable throwable) {
            Assert.assertEquals((String)"Interceptor should be notified about exception", (long)1L, (long)MockProducerInterceptor.ON_ERROR_COUNT.intValue());
            Assert.assertEquals((String)"Interceptor should not receive metadata with an exception when record is null", (long)0L, (long)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue());
            this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
            KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3());
            testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
            testConsumer.seek(this.tp(), 0L);
            ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                ConsumerRecord record = (ConsumerRecord)records.apply(i);
                Assert.assertEquals((Object)new StringBuilder(4).append("key ").append(i).toString(), (Object)new String((String)record.key()));
                Assert.assertEquals((Object)new StringBuilder(6).append("value ").append(i).append(appendStr).toString().toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
            });
            int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
            testConsumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
            Assert.assertEquals((long)2L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 1), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback(this);
            testConsumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(5L))}))).asJava(), (OffsetCommitCallback)commitCallback);
            this.awaitCommitCallback(testConsumer, commitCallback, this.awaitCommitCallback$default$3());
            Assert.assertEquals((long)5L, (long)testConsumer.committed(this.tp()).offset());
            Assert.assertEquals((long)(commitCountBefore + 2), (long)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
            testConsumer.close();
            testProducer.close();
            MockConsumerInterceptor.resetCounters();
            MockProducerInterceptor.resetCounters();
            return;
        }
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        int numRecords = 100;
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (RecordMetadata)x$10.get());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assert.assertEquals((long)10L, (long)testConsumer.committed(this.tp()).offset());
        Assert.assertEquals((long)20L, (long)testConsumer.committed(this.tp2()).offset());
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assert.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)"value will not be modified".getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        testConsumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3());
        ConsumerRecord record = (ConsumerRecord)records.head();
        Assert.assertEquals((Object)"value will not be modified", (Object)new String((byte[])record.value()));
    }

    @Test
    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, 0, 0L, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$48 = consumer;
        int x$49 = numRecords;
        TopicPartition x$50 = this.tp2();
        int x$51 = 0;
        int x$52 = 0;
        long x$53 = 0L;
        TimestampType x$54 = this.consumeAndVerifyRecords$default$6();
        int x$55 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$48, x$49, x$51, x$52, x$53, x$54, x$50, x$55);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps);
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$56 = consumer;
        int x$57 = numRecords;
        TopicPartition x$58 = tp1;
        int x$59 = 0;
        int x$60 = 0;
        long x$61 = startTime;
        TimestampType x$62 = TimestampType.LOG_APPEND_TIME;
        int x$63 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$56, x$57, x$59, x$60, x$61, x$62, x$58, x$63);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$64 = consumer;
        int x$65 = numRecords;
        TopicPartition x$66 = tp2;
        int x$67 = 0;
        int x$68 = 0;
        long x$69 = startTime;
        TimestampType x$70 = TimestampType.LOG_APPEND_TIME;
        int x$71 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$64, x$65, x$67, x$68, x$69, x$70, x$66, x$71);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        java.util.Map topics = consumer.listTopics();
        Assert.assertNotNull((Object)topics);
        Assert.assertEquals((long)5L, (long)topics.size());
        Assert.assertEquals((long)5L, (long)topics.keySet().size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic1)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic2)).size());
        Assert.assertEquals((long)2L, (long)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testOffsetsForTimes() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, props);
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition(topic1, 0), Predef$.MODULE$.long2Long(-1L))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1250));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            PlaintextConsumerTest.$anonfun$testOffsetsForTimes$2(this, numParts, producer, timestampsToSearch, i, topic);
            return BoxedUnit.UNIT;
        });
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0))).offset());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0))).timestamp());
        Assert.assertEquals((long)20L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1))).offset());
        Assert.assertEquals((long)20L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1))).timestamp());
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 0)));
        Assert.assertEquals((String)"null should be returned when message format is 0.9.0", null, timestampOffsets.get(new TopicPartition(topic2, 1)));
        Assert.assertEquals((long)80L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0))).offset());
        Assert.assertEquals((long)80L, (long)((OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0))).timestamp());
        Assert.assertEquals(null, timestampOffsets.get(new TopicPartition(topic3, 1)));
    }

    @Test
    public void testEarliestOrLatestOffsets() {
        String topic0 = "topicWithNewMessageFormat";
        String topic1 = "topicWithOldMessageFormat";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.createTopicAndSendRecords(producer, topic0, 2, 100);
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, 1, 1, props);
        this.sendRecords(producer, 100, new TopicPartition(topic1, 0));
        TopicPartition t0p0 = new TopicPartition(topic0, 0);
        TopicPartition t0p1 = new TopicPartition(topic0, 1);
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        java.util.Set partitions = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{t0p0, t0p1, t1p0}))).asJava();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        java.util.Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), earliests.get(t1p0));
        java.util.Map latests = consumer.endOffsets((Collection)partitions);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p0));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t0p1));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), latests.get(t1p0));
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener = new BaseConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        while (listener.callsToAssigned() == 0) {
            consumer.poll(50L);
        }
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        consumer.pause((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 0, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp());
        this.sendRecords(producer, 7, this.tp2());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$))).asJava());
        consumer.poll(50L);
        long pos1 = consumer.position(this.tp());
        long pos2 = consumer.position(this.tp2());
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assert.assertEquals((long)3L, (long)consumer.committed(this.tp()).offset());
        Assert.assertNull((Object)consumer.committed(this.tp2()));
        Assert.assertEquals((long)pos1, (long)consumer.position(this.tp()));
        Assert.assertEquals((long)pos2, (long)consumer.position(this.tp2()));
        consumer.commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assert.assertEquals((long)3L, (long)consumer.committed(this.tp()).offset());
        Assert.assertEquals((long)5L, (long)consumer.committed(this.tp2()).offset());
        BaseConsumerTest.CountConsumerCommitCallback commitCallback = new BaseConsumerTest.CountConsumerCommitCallback(this);
        consumer.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(7L))}))).asJava(), (OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback(consumer, commitCallback, this.awaitCommitCallback$default$3());
        Assert.assertEquals((long)7L, (long)consumer.committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, consumer){
            private final KafkaConsumer consumer$16;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer$16.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer$16 = consumer$16;
            }
        };
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), rebalanceListener);
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newAssignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newAssignment).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)300L, (long)consumer.committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)consumer.committed(this.tp2()).offset());
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener0 = new BaseConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener0);
        ObjectRef records = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records$3.elem = consumer.poll(100L);
            return !((ConsumerRecords)records$3.elem).records(this.tp()).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((String)"should be assigned once", (long)1L, (long)listener0.callsToAssigned());
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assert.assertNotNull((Object)fetchLead0);
        Assert.assertTrue((String)new StringBuilder(19).append("The lead should be ").append(((ConsumerRecords)records.elem).count()).toString(), (BoxesRunTime.equals((Object)fetchLead0.metricValue(), (Object)BoxesRunTime.boxToInteger((int)((ConsumerRecords)records.elem).count())) ? 1 : 0) != 0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(100L);
            return listener0.callsToAssigned() >= 2;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected rebalance did not occur.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.serverCount(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.TestConsumerReassignmentListener listener0 = new BaseConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener0);
        ObjectRef records = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records$4.elem = consumer.poll(100L);
            return !((ConsumerRecords)records$4.elem).records(this.tp()).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((String)"should be assigned once", (long)1L, (long)listener0.callsToAssigned());
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assert.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - ((ConsumerRecords)records.elem).count();
        Assert.assertEquals((String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString(), (double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(100L);
            return listener0.callsToAssigned() >= 2;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected rebalance did not occur.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ObjectRef records = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records$5.elem = consumer.poll(100L);
            return !((ConsumerRecords)records$5.elem).records(this.tp()).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLead);
        Assert.assertTrue((String)new StringBuilder(19).append("The lead should be ").append(((ConsumerRecords)records.elem).count()).toString(), (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)((ConsumerRecords)records.elem).count()), (Object)fetchLead.metricValue()) ? 1 : 0) != 0);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.poll(100L).isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ObjectRef records = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records$6.elem = consumer.poll(100L);
            return !((ConsumerRecords)records$6.elem).records(this.tp()).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - ((ConsumerRecords)records.elem).count();
        Assert.assertEquals((String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString(), (double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.poll(100L).isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertNull(consumer.metrics().get(new MetricName(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.tp()), ".records-lag"), "consumer-fetch-manager-metrics", "", tags)));
        Assert.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsWhenReadCommitted() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.sendRecords(producer, numMessages, this.tp2());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ObjectRef records = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records$7.elem = consumer.poll(100L);
            return !((ConsumerRecords)records$7.elem).records(this.tp()).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertNotNull((Object)fetchLag);
    }

    @Test
    public void testPerPartitionLeadWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ObjectRef records = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records$8.elem = consumer.poll(100L);
            return !((ConsumerRecords)records$8.elem).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertTrue((String)new StringBuilder(19).append("The lead should be ").append(maxPollRecords).toString(), (BoxesRunTime.equals((Object)lead.metricValue(), (Object)BoxesRunTime.boxToInteger((int)maxPollRecords)) ? 1 : 0) != 0);
    }

    @Test
    public void testPerPartitionLagWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ObjectRef records = ObjectRef.create((Object)ConsumerRecords.empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records$9.elem = consumer.poll(100L);
            return !((ConsumerRecords)records$9.elem).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer did not consume any message before timeout.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assert.assertEquals((String)new StringBuilder(18).append("The lag should be ").append(numMessages - ((ConsumerRecords)records.elem).count()).toString(), (double)(numMessages - ((ConsumerRecords)records.elem).count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon());
    }

    @Test
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured() {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$11, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$12, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$13, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$14, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$15, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$16, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$17, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$18, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            PlaintextConsumerTest.assertNoExemptRequestMetric$1(x$19);
            return BoxedUnit.UNIT;
        });
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp());
        this.sendRecords(producer, 100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$))));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$))));
        KafkaConsumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        BaseConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)));
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringBuilder(52).append("Did not get valid initial assignment for partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).toString(), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        long maxSessionTimeout = new StringOps(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp()))).toLong();
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringBuilder(68).append("Did not get valid assignment for partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).append(" after one consumer left").toString(), 3L * maxSessionTimeout);
        consumerPollers.foreach((Function1 & Serializable & scala.Serializable)poller -> {
            poller.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(KafkaProducer<byte[], byte[]> producer, String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.serverCount(), this.createTopic$default$4());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(topicName, partition);
            this.sendRecords(producer, recordsPerPartition, tp);
            parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)parts$1.elem).$plus((Object)tp);
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConsumerTest.ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
        void var3_3;
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        BaseConsumerTest.ConsumerAssignmentPoller consumerPoller = new BaseConsumerTest.ConsumerAssignmentPoller(this, consumer, topicsToSubscribe);
        consumerPoller.start();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<BaseConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, topicsToSubscribe)));
        return var3_3;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1 & Serializable & scala.Serializable)_ -> consumerGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3())));
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1 & Serializable & scala.Serializable)_ -> PlaintextConsumerTest.$anonfun$addConsumersToGroupAndWaitForGroupAssignment$1(this, consumerGroup, consumerPollers, topicsToSubscribe, BoxesRunTime.unboxToInt((Object)_)));
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringBuilder(72).append("Did not get valid assignment for partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()).append(" after we added ").append(numOfConsumersToAdd).append(" consumer(s)").toString(), this.validateGroupAssignment$default$4());
    }

    public void validateGroupAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, String msg, long waitTime) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$20 -> assignments.$plus$eq(x$20.consumerAssignment()));
            return this.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments, subscriptions);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, waitTime, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1 & Serializable & scala.Serializable)poller -> {
            poller.subscribe((List<String>)topicsToSubscribe);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> consumerPollers.forall((Function1 & Serializable & scala.Serializable)poller -> BoxesRunTime.boxToBoolean((boolean)poller.isSubscribeRequestProcessed())), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Failed to call subscribe on all consumers in the group for subscription ").append(subscriptions).toString(), 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringBuilder(74).append("Did not get valid assignment for partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()).append(" after we changed subscription").toString(), this.validateGroupAssignment$default$4());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), rebalanceListener);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(50L);
            java.util.Set set = consumer.assignment();
            Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Expected partitions ").append(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).append(" but actually got ").append(consumer.assignment()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ TopicPartition $anonfun$testLowMaxFetchSizeForRequestAndPartition$3(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    private static final scala.collection.immutable.Map reverse$1(scala.collection.immutable.Map m) {
        return ((TraversableOnce)((SetLike)m.values().toSet().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, ((IterableLike)m.keys().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$5 -> ((SetLike)m.apply((Object)BoxesRunTime.boxToLong((long)x$5))).contains(v))).head()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$testMultiConsumerStickyAssignment$5(scala.collection.immutable.Map prePartition2PollerId$1, scala.collection.immutable.Map postPartition2PollerId$1, IntRef changes$1, TopicPartition key) {
        Option preVal = prePartition2PollerId$1.get((Object)key);
        Option postVal = postPartition2PollerId$1.get((Object)key);
        if (preVal.nonEmpty() && postVal.nonEmpty()) {
            if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                ++changes$1.elem;
            }
        } else {
            ++changes$1.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$testOffsetsForTimes$2(PlaintextConsumerTest $this, int numParts$1, KafkaProducer producer$4, HashMap timestampsToSearch$1, IntRef i$1, String topic) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numParts$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)part -> {
            TopicPartition tp = new TopicPartition(topic, part);
            $this.sendRecords((KafkaProducer<byte[], byte[]>)producer$4, 100, tp);
            timestampsToSearch$1.put(tp, Predef$.MODULE$.long2Long((long)(i$1.elem * 20)));
            ++i$1.elem;
        });
    }

    private static final void assertNoMetric$1(KafkaServer broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assert.assertNull((String)new StringBuilder(37).append("Metric should not hanve been created ").append(metricName).toString(), (Object)broker.metrics().metric(metricName));
    }

    private static final void assertNoExemptRequestMetric$1(KafkaServer broker) {
        MetricName metricName = broker.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        Assert.assertNull((String)new StringBuilder(37).append("Metric should not hanve been created ").append(metricName).toString(), (Object)broker.metrics().metric(metricName));
    }

    public static final /* synthetic */ Buffer $anonfun$addConsumersToGroupAndWaitForGroupAssignment$1(PlaintextConsumerTest $this, Buffer consumerGroup$1, Buffer consumerPollers$2, List topicsToSubscribe$1, int _) {
        KafkaConsumer consumer = $this.createConsumer($this.createConsumer$default$1(), $this.createConsumer$default$2(), $this.createConsumer$default$3());
        consumerGroup$1.$plus$eq(consumer);
        return consumerPollers$2.$plus$eq((Object)$this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)topicsToSubscribe$1));
    }

    public interface DeserializerImpl
    extends Deserializer<byte[]> {
        public ByteArrayDeserializer deserializer();

        public void deserializer_$eq(ByteArrayDeserializer var1);

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.deserialize(topic, headers, data);
        }

        default public byte[] deserialize(String topic, Headers headers, byte[] data) {
            Header header = headers.lastHeader("content-type");
            Assert.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
            return this.deserializer().deserialize(topic, data);
        }

        public static /* synthetic */ void configure$(DeserializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.deserializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(DeserializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.deserializer().close();
        }

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, byte[] data) {
            return $this.deserialize(topic, data);
        }

        default public byte[] deserialize(String topic, byte[] data) {
            throw this.kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer().fail("method should not be invoked", new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer();

        public static void $init$(DeserializerImpl $this) {
            $this.deserializer_$eq(new ByteArrayDeserializer());
        }
    }

    public interface SerializerImpl
    extends Serializer<byte[]> {
        public ByteArraySerializer serializer();

        public void serializer_$eq(ByteArraySerializer var1);

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.serialize(topic, headers, data);
        }

        default public byte[] serialize(String topic, Headers headers, byte[] data) {
            headers.add("content-type", "application/octet-stream".getBytes());
            return this.serializer().serialize(topic, data);
        }

        public static /* synthetic */ void configure$(SerializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.serializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(SerializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.serializer().close();
        }

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, byte[] data) {
            return $this.serialize(topic, data);
        }

        default public byte[] serialize(String topic, byte[] data) {
            throw this.kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer().fail("method should not be invoked", new Position("PlaintextConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer();

        public static void $init$(SerializerImpl $this) {
            $this.serializer_$eq(new ByteArraySerializer());
        }
    }
}

