/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Assert;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-r!B\u0001\u0003\u0011\u00039\u0011\u0001E)v_R\fG+Z:u\u00072LWM\u001c;t\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u0005A\tVo\u001c;b)\u0016\u001cHo\u00117jK:$8o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000bYIA\u0011A\f\u0002\u00175,GO]5d-\u0006dW/\u001a\u000b\u00031m\u0001\"!D\r\n\u0005iq!A\u0002#pk\ndW\rC\u0003\u001d+\u0001\u0007Q$\u0001\u0004nKR\u0014\u0018n\u0019\t\u0003=\u0019j\u0011a\b\u0006\u0003A\u0005\naaY8n[>t'BA\u0003#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dz\"AB'fiJL7MB\u0003\u000b\u0005\u0005\u0005\u0011f\u0005\u0002)\u0019!A1\u0006\u000bB\u0001B\u0003%A&A\u0003u_BL7\r\u0005\u0002.i9\u0011aF\r\t\u0003_9i\u0011\u0001\r\u0006\u0003c\u0019\ta\u0001\u0010:p_Rt\u0014BA\u001a\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Mr\u0001\u0002\u0003\u001d)\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u00151,\u0017\rZ3s\u001d>$W\r\u0005\u0002;{5\t1H\u0003\u0002=\t\u000511/\u001a:wKJL!AP\u001e\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\t\u0001\"\u0012\t\u0011)A\u0005Y\u0005\u0001\u0002O]8ek\u000e,'o\u00117jK:$\u0018\n\u001a\u0005\t\u0005\"\u0012\t\u0011)A\u0005Y\u0005\u00012m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0005\t\t\"\u0012)\u0019!C\u0001\u000b\u0006A\u0001O]8ek\u000e,'/F\u0001G!\u001195*T'\u000e\u0003!S!\u0001R%\u000b\u0005)\u000b\u0013aB2mS\u0016tGo]\u0005\u0003\u0019\"\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bcA\u0007O!&\u0011qJ\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001bEK!A\u0015\b\u0003\t\tKH/\u001a\u0005\t)\"\u0012\t\u0011)A\u0005\r\u0006I\u0001O]8ek\u000e,'\u000f\t\u0005\t-\"\u0012)\u0019!C\u0001/\u0006A1m\u001c8tk6,'/F\u0001Y!\u0011I6,T'\u000e\u0003iS!AV%\n\u0005qS&!D&bM.\f7i\u001c8tk6,'\u000f\u0003\u0005_Q\t\u0005\t\u0015!\u0003Y\u0003%\u0019wN\\:v[\u0016\u0014\b\u0005C\u0003\u0014Q\u0011\u0005\u0001\rF\u0004bE\u000e$WMZ4\u0011\u0005!A\u0003\"B\u0016`\u0001\u0004a\u0003\"\u0002\u001d`\u0001\u0004I\u0004\"\u0002!`\u0001\u0004a\u0003\"\u0002\"`\u0001\u0004a\u0003\"\u0002#`\u0001\u00041\u0005\"\u0002,`\u0001\u0004A\u0006\"B5)\r\u0003Q\u0017!D;tKJ\u0004&/\u001b8dSB\fG.F\u0001l!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0003bkRD'B\u00019 \u0003!\u0019XmY;sSRL\u0018B\u0001:n\u00059Y\u0015MZ6b!JLgnY5qC2DQ\u0001\u001e\u0015\u0007\u0002U\fab\u001c<feJLG-Z)v_R\f7\u000fF\u0003wsz\f\t\u0001\u0005\u0002\u000eo&\u0011\u0001P\u0004\u0002\u0005+:LG\u000fC\u0003{g\u0002\u000710A\u0007qe>$WoY3s#V|G/\u0019\t\u0003\u001bqL!! \b\u0003\t1{gn\u001a\u0005\u0006\u007fN\u0004\ra_\u0001\u000eG>t7/^7feF+x\u000e^1\t\r\u0005\r1\u000f1\u0001\u0019\u00031\u0011X-];fgR\fVo\u001c;b\u0011\u001d\t9\u0001\u000bD\u0001\u0003\u0013\tAC]3n_Z,\u0017+^8uC>3XM\u001d:jI\u0016\u001cH#\u0001<\t\u000f\u00055\u0001F\"\u0001\u0002\u0010\u0005y\u0011/^8uC6+GO]5d)\u0006<7\u000f\u0006\u0003\u0002\u0012\u0005]\u0001#B\u0017\u0002\u00141b\u0013bAA\u000bm\t\u0019Q*\u00199\t\u000f\u0005e\u00111\u0002a\u0001Y\u0005A1\r\\5f]RLE\rC\u0004\u0002\u001e!\"\t!a\b\u0002\u000bE,x\u000e^1\u0015\u0011\u0005\u0005\u0012QFA\u001c\u0003s\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003Oy\u0012aB7fiJL7m]\u0005\u0005\u0003W\t)CA\u0003Rk>$\u0018\r\u0003\u0005\u00020\u0005m\u0001\u0019AA\u0019\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\rQ\u00141G\u0005\u0004\u0003kY$AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJDa![A\u000e\u0001\u0004Y\u0007bBA\r\u00037\u0001\r\u0001\f\u0005\b\u0003{AC\u0011AA \u0003U\u0001(o\u001c3vG\u0016,f\u000e^5m)\"\u0014x\u000e\u001e;mK\u0012$b!!\u0011\u0002H\u0005-\u0003cA\u0007\u0002D%\u0019\u0011Q\t\b\u0003\u0007%sG\u000f\u0003\u0005\u0002J\u0005m\u0002\u0019AA!\u0003)i\u0017\r\u001f*fG>\u0014Hm\u001d\u0005\u000b\u0003\u001b\nY\u0004%AA\u0002\u0005=\u0013\u0001G<bSR4uN\u001d*fcV,7\u000f^\"p[BdW\r^5p]B\u0019Q\"!\u0015\n\u0007\u0005McBA\u0004C_>dW-\u00198\t\u000f\u0005]\u0003\u0006\"\u0001\u0002Z\u0005)2m\u001c8tk6,WK\u001c;jYRC'o\u001c;uY\u0016$GCBA!\u00037\ni\u0006\u0003\u0005\u0002J\u0005U\u0003\u0019AA!\u0011)\ti%!\u0016\u0011\u0002\u0003\u0007\u0011q\n\u0005\b\u0003CBC\u0011AA2\u0003U1XM]5gsB\u0013x\u000eZ;dKRC'o\u001c;uY\u0016$RA^A3\u0003SB\u0001\"a\u001a\u0002`\u0001\u0007\u0011qJ\u0001\u000fKb\u0004Xm\u0019;UQJ|G\u000f\u001e7f\u0011)\tY'a\u0018\u0011\u0002\u0003\u0007\u0011qJ\u0001\u0013m\u0016\u0014\u0018NZ=DY&,g\u000e^'fiJL7\rC\u0004\u0002p!\"\t!!\u001d\u0002+Y,'/\u001b4z\u0007>t7/^7f)\"\u0014x\u000e\u001e;mKR)a/a\u001d\u0002v!A\u0011qMA7\u0001\u0004\ty\u0005\u0003\u0006\u0002l\u00055\u0004\u0013!a\u0001\u0003\u001fBq!!\u001f)\t\u0003\tY(\u0001\rwKJLg-\u001f+ie>$H\u000f\\3US6,W*\u001a;sS\u000e$rA^A?\u0003\u000f\u000bI\t\u0003\u0005\u0002\u0000\u0005]\u0004\u0019AAA\u0003%\tXo\u001c;b)f\u0004X\rE\u0002;\u0003\u0007K1!!\"<\u0005%\tVo\u001c;b)f\u0004X\rC\u0004\u0002\u001a\u0005]\u0004\u0019\u0001\u0017\t\u0011\u0005\u001d\u0014q\u000fa\u0001\u0003\u001fBq!!$)\t\u0003\ty)\u0001\nuQJ|G\u000f\u001e7f\u001b\u0016$(/[2OC6,GCBAI\u0003/\u000bI\nE\u0002\u001f\u0003'K1!!& \u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\t\u0003\u007f\nY\t1\u0001\u0002\u0002\"9\u0011\u0011DAF\u0001\u0004a\u0003bBAOQ\u0011\u0005\u0011qT\u0001\u000fi\"\u0014x\u000e\u001e;mK6+GO]5d)\u0019\t\t+a*\u0002*B!\u00111EAR\u0013\u0011\t)+!\n\u0003\u0017-\u000bgm[1NKR\u0014\u0018n\u0019\u0005\t\u0003\u007f\nY\n1\u0001\u0002\u0002\"9\u0011\u0011DAN\u0001\u0004a\u0003bBAWQ\u0011\u0005\u0011qV\u0001\u0014Kb,W\u000e\u001d;SKF,Xm\u001d;NKR\u0014\u0018nY\u000b\u0003\u0003CCq!a-)\t\u0003\t),\u0001\u0014wKJLg-\u001f)s_\u0012,8-\u001a:DY&,g\u000e\u001e+ie>$H\u000f\\3US6,W*\u001a;sS\u000e$2A^A\\\u0011!\t9'!-A\u0002\u0005=\u0003bBA^Q\u0011\u0005\u0011QX\u0001'm\u0016\u0014\u0018NZ=D_:\u001cX/\\3s\u00072LWM\u001c;UQJ|G\u000f\u001e7f)&lW-T3ue&\u001cG#\u0002<\u0002@\u0006\u0005\u0007\u0002CA4\u0003s\u0003\r!a\u0014\t\u0015\u0005\r\u0017\u0011\u0018I\u0001\u0002\u0004\t)-A\bnCb$\u0006N]8ui2,G+[7f!\u0011i\u0011q\u0019\r\n\u0007\u0005%gB\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u001bDC\u0011AAh\u0003=\tXo\u001c;b!J|\u0007/\u001a:uS\u0016\u001cH\u0003CAi\u0003C\f\u0019/!:\u0011\t\u0005M\u0017Q\\\u0007\u0003\u0003+TA!a6\u0002Z\u0006!Q\u000f^5m\u0015\t\tY.\u0001\u0003kCZ\f\u0017\u0002BAp\u0003+\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019Q\u00181\u001aa\u0001w\"1q0a3A\u0002mDq!a\u0001\u0002L\u0002\u0007\u0001\u0004C\u0004\u0002j\"\"\t!a;\u0002%]\f\u0017\u000e\u001e$peF+x\u000e^1Va\u0012\fG/\u001a\u000b\nm\u00065\u0018q^Ay\u0003gDaA_At\u0001\u0004Y\bBB@\u0002h\u0002\u00071\u0010C\u0004\u0002\u0004\u0005\u001d\b\u0019\u0001\r\t\u0011q\n9\u000f%AA\u0002eB\u0011\"a>)#\u0003%\t!!?\u0002?A\u0014x\u000eZ;dKVsG/\u001b7UQJ|G\u000f\u001e7fI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002|*\"\u0011qJA\u007fW\t\ty\u0010\u0005\u0003\u0003\u0002\t-QB\u0001B\u0002\u0015\u0011\u0011)Aa\u0002\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0005\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5!1\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B\tQE\u0005I\u0011AA}\u0003}1XM]5gsB\u0013x\u000eZ;dKRC'o\u001c;uY\u0016$C-\u001a4bk2$HE\r\u0005\n\u0005+A\u0013\u0013!C\u0001\u0003s\fqdY8ogVlW-\u00168uS2$\u0006N]8ui2,G\r\n3fM\u0006,H\u000e\u001e\u00133\u0011%\u0011I\u0002KI\u0001\n\u0003\tI0A\u0010wKJLg-_\"p]N,X.\u001a+ie>$H\u000f\\3%I\u00164\u0017-\u001e7uIIB\u0011B!\b)#\u0003%\tAa\b\u00029]\f\u0017\u000e\u001e$peF+x\u000e^1Va\u0012\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0005\u0016\u0004s\u0005u\b\"\u0003B\u0013QE\u0005I\u0011\u0001B\u0014\u0003A2XM]5gs\u000e{gn];nKJ\u001cE.[3oiRC'o\u001c;uY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0006\u0016\u0005\u0003\u000b\fi\u0010")
public abstract class QuotaTestClients {
    private final String topic;
    private final KafkaServer leaderNode;
    private final String producerClientId;
    private final String consumerClientId;
    private final KafkaProducer<byte[], byte[]> producer;
    private final KafkaConsumer<byte[], byte[]> consumer;

    public static double metricValue(Metric metric) {
        return QuotaTestClients$.MODULE$.metricValue(metric);
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public abstract KafkaPrincipal userPrincipal();

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    public abstract Map<String, String> quotaMetricTags(String var1);

    public Quota quota(ClientQuotaManager quotaManager, KafkaPrincipal userPrincipal, String clientId) {
        return quotaManager.quota(userPrincipal, clientId);
    }

    /*
     * WARNING - void declaration
     */
    public int produceUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        void var3_3;
        int numProduced = 0;
        boolean throttled = false;
        do {
            byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)numProduced)).toString().getBytes();
            Future future = this.producer().send(new ProducerRecord(this.topic, null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic, null, null, true));
            ++numProduced;
            do {
                KafkaMetric metric;
                boolean bl = throttled = (metric = this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId)) != null && QuotaTestClients$.MODULE$.metricValue((Metric)metric) > 0.0;
            } while (!future.isDone() && (!throttled || waitForRequestCompletion));
        } while (numProduced < maxRecords && !throttled);
        return (int)var3_3;
    }

    public boolean produceUntilThrottled$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int consumeUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        void var3_3;
        this.consumer().subscribe(Collections.singleton(this.topic));
        int numConsumed = 0;
        boolean throttled = false;
        do {
            KafkaMetric metric;
            boolean bl = throttled = (metric = this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId)) != null && QuotaTestClients$.MODULE$.metricValue((Metric)metric) > 0.0;
        } while ((numConsumed += this.consumer().poll(100L).count()) < maxRecords && !throttled);
        if (throttled && numConsumed < maxRecords && waitForRequestCompletion) {
            int minRecords = numConsumed + 1;
            while (numConsumed < minRecords) {
                numConsumed += this.consumer().poll(100L).count();
            }
        }
        return (int)var3_3;
    }

    public boolean consumeUntilThrottled$default$2() {
        return true;
    }

    public void verifyProduceThrottle(boolean expectThrottle, boolean verifyClientMetric) {
        block0: {
            this.verifyThrottleTimeMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId, expectThrottle);
            if (!verifyClientMetric) break block0;
            this.verifyProducerClientThrottleTimeMetric(expectThrottle);
        }
    }

    public boolean verifyProduceThrottle$default$2() {
        return true;
    }

    public void verifyConsumeThrottle(boolean expectThrottle, boolean verifyClientMetric) {
        block0: {
            this.verifyThrottleTimeMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId, expectThrottle);
            if (!verifyClientMetric) break block0;
            this.verifyConsumerClientThrottleTimeMetric(expectThrottle, this.verifyConsumerClientThrottleTimeMetric$default$2());
        }
    }

    public boolean verifyConsumeThrottle$default$2() {
        return true;
    }

    public void verifyThrottleTimeMetric(QuotaType quotaType, String clientId, boolean expectThrottle) {
        double throttleMetricValue = QuotaTestClients$.MODULE$.metricValue((Metric)this.throttleMetric(quotaType, clientId));
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(42).append("Client with id=").append(clientId).append(" should have been throttled").toString(), (throttleMetricValue > 0.0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringBuilder(46).append("Client with id=").append(clientId).append(" should not have been throttled").toString(), (double)0.0, (double)throttleMetricValue, (double)0.0);
        }
    }

    public MetricName throttleMetricName(QuotaType quotaType, String clientId) {
        return this.leaderNode.metrics().metricName("throttle-time", quotaType.toString(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.quotaMetricTags(clientId)).asJava());
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, String clientId) {
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(this.throttleMetricName(quotaType, clientId));
    }

    public KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(metricName);
    }

    public void verifyProducerClientThrottleTimeMetric(boolean expectThrottle) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId);
        Metric avgMetric = (Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        Metric maxMetric = (Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        if (expectThrottle) {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> QuotaTestClients$.MODULE$.metricValue(avgMetric) > 0.0 && QuotaTestClients$.MODULE$.metricValue(maxMetric) > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Producer throttle metric not updated: avg=").append(QuotaTestClients$.MODULE$.metricValue(avgMetric)).append(" max=").append(QuotaTestClients$.MODULE$.metricValue(maxMetric)).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        } else {
            Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)QuotaTestClients$.MODULE$.metricValue(maxMetric), (double)0.0);
        }
    }

    public void verifyConsumerClientThrottleTimeMetric(boolean expectThrottle, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId);
        Metric avgMetric = (Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        Metric maxMetric = (Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        if (expectThrottle) {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> QuotaTestClients$.MODULE$.metricValue(avgMetric) > 0.0 && QuotaTestClients$.MODULE$.metricValue(maxMetric) > 0.0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Consumer throttle metric not updated: avg=").append(QuotaTestClients$.MODULE$.metricValue(avgMetric)).append(" max=").append(QuotaTestClients$.MODULE$.metricValue(maxMetric)).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            maxThrottleTime.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)max -> Assert.assertTrue((String)new StringBuilder(36).append("Maximum consumer throttle too high: ").append(QuotaTestClients$.MODULE$.metricValue(maxMetric)).toString(), (QuotaTestClients$.MODULE$.metricValue(maxMetric) <= max ? 1 : 0) != 0));
        } else {
            Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)QuotaTestClients$.MODULE$.metricValue(maxMetric), (double)0.0);
        }
    }

    public Option<Object> verifyConsumerClientThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    public Properties quotaProperties(long producerQuota, long consumerQuota, double requestQuota) {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        return props;
    }

    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota, KafkaServer server) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            QuotaFactory.QuotaManagers quotaManagers = server.apis().quotas();
            Quota overrideProducerQuota = this.quota(quotaManagers.produce(), this.userPrincipal(), $this.producerClientId);
            Quota overrideConsumerQuota = this.quota(quotaManagers.fetch(), this.userPrincipal(), $this.consumerClientId);
            Quota overrideProducerRequestQuota = this.quota((ClientQuotaManager)quotaManagers.request(), this.userPrincipal(), $this.producerClientId);
            Quota overrideConsumerRequestQuota = this.quota((ClientQuotaManager)quotaManagers.request(), this.userPrincipal(), $this.consumerClientId);
            Assert.assertEquals((String)new StringBuilder(43).append("ClientId ").append($this.producerClientId).append(" of user ").append(this.userPrincipal()).append(" must have producer quota").toString(), (Object)Quota.upperBound((double)producerQuota), (Object)overrideProducerQuota);
            Assert.assertEquals((String)new StringBuilder(43).append("ClientId ").append($this.consumerClientId).append(" of user ").append(this.userPrincipal()).append(" must have consumer quota").toString(), (Object)Quota.upperBound((double)consumerQuota), (Object)overrideConsumerQuota);
            Assert.assertEquals((String)new StringBuilder(42).append("ClientId ").append($this.producerClientId).append(" of user ").append(this.userPrincipal()).append(" must have request quota").toString(), (Object)Quota.upperBound((double)requestQuota), (Object)overrideProducerRequestQuota);
            Assert.assertEquals((String)new StringBuilder(42).append("ClientId ").append($this.consumerClientId).append(" of user ").append(this.userPrincipal()).append(" must have request quota").toString(), (Object)Quota.upperBound((double)requestQuota), (Object)overrideConsumerRequestQuota);
        });
    }

    public KafkaServer waitForQuotaUpdate$default$4() {
        return this.leaderNode;
    }

    public QuotaTestClients(String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        this.topic = topic;
        this.leaderNode = leaderNode;
        this.producerClientId = producerClientId;
        this.consumerClientId = consumerClientId;
        this.producer = producer;
        this.consumer = consumer;
    }
}

