/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.TimestampOffset;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.DelayedOperationKey;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TopicPartitionOperationKey;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\re\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002U1si&$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0005ce>\\WM]%e+\u00051\u0002CA\u0005\u0018\u0013\tA\"BA\u0002J]RDaA\u0007\u0001!\u0002\u00131\u0012!\u00032s_.,'/\u00133!\u0011\u001da\u0002A1A\u0005\u0002u\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001\u001f!\tyr%D\u0001!\u0015\t\t#%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001\u0006\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019Q\u0003\u0001)A\u0005=\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\tQLW.Z\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u0006kRLGn]\u0005\u0003gA\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u000bQLW.\u001a\u0011\t\u000f]\u0002!\u0019!C\u0001q\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005yZ$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019\u0001\u0005\u0001)A\u0005s\u0005\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u00069Q.\u001a;sS\u000e\u001cX#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\t\u0003\u0013B\u0001%G\u0005\u001diU\r\u001e:jGNDaA\u0013\u0001!\u0002\u0013!\u0015\u0001C7fiJL7m\u001d\u0011\t\u00131\u0003\u0001\u0019!a\u0001\n\u0003i\u0015A\u0002;na\u0012K'/F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002j_*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u00111\u0015\u000e\\3\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0016A\u0003;na\u0012K'o\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003\u0013iK!a\u0017\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b;Z\u000b\t\u00111\u0001O\u0003\rAH%\r\u0005\n?\u0002\u0001\r\u0011!Q!\n9\u000bq\u0001^7q\t&\u0014\b\u0005C\u0005b\u0001\u0001\u0007\t\u0019!C\u0001\u001b\u00069An\\4ESJ\f\u0004\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0001e\u0003-awn\u001a#jeFzF%Z9\u0015\u0005e+\u0007bB/c\u0003\u0003\u0005\rA\u0014\u0005\nO\u0002\u0001\r\u0011!Q!\n9\u000b\u0001\u0002\\8h\t&\u0014\u0018\u0007\t\u0005\nS\u0002\u0001\r\u00111A\u0005\u00025\u000bq\u0001\\8h\t&\u0014(\u0007C\u0005l\u0001\u0001\u0007\t\u0019!C\u0001Y\u0006YAn\\4ESJ\u0014t\fJ3r)\tIV\u000eC\u0004^U\u0006\u0005\t\u0019\u0001(\t\u0013=\u0004\u0001\u0019!A!B\u0013q\u0015\u0001\u00037pO\u0012K'O\r\u0011\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0003\u0011\u0018A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002gB\u0011!\b^\u0005\u0003kn\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0005x\u0001\u0001\u0007\t\u0019!C\u0001q\u0006\u0011\"/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x\fJ3r)\tI\u0016\u0010C\u0004^m\u0006\u0005\t\u0019A:\t\u0013m\u0004\u0001\u0019!A!B\u0013\u0019\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0003q\u0018A\u00037pO6\u000bg.Y4feV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001B\u0001\u0004Y><\u0017\u0002BA\u0005\u0003\u0007\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0011-\ti\u0001\u0001a\u0001\u0002\u0004%\t!a\u0004\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u0019\u0011,!\u0005\t\u0011u\u000bY!!AA\u0002}D!\"!\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0000\u0003-awnZ'b]\u0006<WM\u001d\u0011\t\u0017\u0005e\u0001\u00011AA\u0002\u0013\u0005\u00111D\u0001\nY><7i\u001c8gS\u001e,\"!!\b\u0011\t\u0005\u0005\u0011qD\u0005\u0005\u0003C\t\u0019AA\u0005M_\u001e\u001cuN\u001c4jO\"Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0014\u00035awnZ\"p]\u001aLwm\u0018\u0013fcR\u0019\u0011,!\u000b\t\u0013u\u000b\u0019#!AA\u0002\u0005u\u0001bCA\u0017\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;\t!\u0002\\8h\u0007>tg-[4!\u0011\u001d\t\t\u0004\u0001C\u0001\u0003g\tQa]3ukB$\u0012!\u0017\u0015\u0005\u0003_\t9\u0004\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti$J\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0003\nYD\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003\u000b\u0002A\u0011BA$\u0003M\u0019'/Z1uK2{w\r\u0015:pa\u0016\u0014H/[3t)\u0011\tI%!\u0016\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014S\u0003\u0011)H/\u001b7\n\t\u0005M\u0013Q\n\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\u0002CA,\u0003\u0007\u0002\r!!\u0017\u0002\u0013=4XM\u001d:jI\u0016\u001c\b\u0003CA.\u0003S\ny'a\u001c\u000f\t\u0005u\u0013Q\r\t\u0004\u0003?RQBAA1\u0015\r\t\u0019GB\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d$\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\niGA\u0002NCBT1!a\u001a\u000b!\u0011\tY&!\u001d\n\t\u0005M\u0014Q\u000e\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005]\u0004\u0001\"\u0001\u00024\u0005AA/Z1s\t><h\u000e\u000b\u0003\u0002v\u0005m\u0004\u0003BA\u001d\u0003{JA!a \u0002<\t)\u0011I\u001a;fe\"9\u00111\u0011\u0001\u0005\u0002\u0005M\u0012a\b;fgRl\u0015m[3MK\u0006$WM]+qI\u0006$Xm]#q_\u000eD7)Y2iK\"\"\u0011\u0011QAD!\u0011\tI$!#\n\t\u0005-\u00151\b\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002\u0010\u0002!\t!a\r\u0002eQ,7\u000f^'bW\u0016dU-\u00193fe\u0012{Wm\u001d(piV\u0003H-\u0019;f\u000bB|7\r[\"bG\",gi\u001c:PY\u00124uN]7biNDC!!$\u0002\b\"9\u0011Q\u0013\u0001\u0005\u0002\u0005M\u0012\u0001\u000b;fgRl\u0015-\u001f2f%\u0016\u0004H.Y2f\u0007V\u0014(/\u001a8u/&$\bNR;ukJ,'+\u001a9mS\u000e\f\u0007\u0006BAJ\u0003\u000fCq!a'\u0001\t\u0003\t\u0019$A\u0018uKN$h)\u001a;dQ>3gm]3u':\f\u0007o\u001d5pi\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d'fC\u0012,'\u000f\u000b\u0003\u0002\u001a\u0006\u001d\u0005bBAQ\u0001\u0011\u0005\u00111G\u00012i\u0016\u001cHOR3uG\"|eMZ:fiNs\u0017\r]:i_R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\u0011\ty*a\"\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u00024\u0005YC/Z:u\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d'fC\u0012,'\u000f\u000b\u0003\u0002&\u0006\u001d\u0005bBAW\u0001\u0011\u0005\u00111G\u0001.i\u0016\u001cHo\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\b\u0006BAV\u0003\u000fCq!a-\u0001\t\u0003\t\u0019$\u0001\u0014uKN$(+Z1e%\u0016\u001cwN\u001d3Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014H*Z1eKJDC!!-\u0002\b\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005M\u0012\u0001\u000b;fgR\u0014V-\u00193SK\u000e|'\u000fZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\b\u0006BA\\\u0003\u000fCq!a0\u0001\t\u0003\t\u0019$A\u001auKN$h)\u001a;dQ>3gm]3u\r>\u0014H+[7fgR\fW\u000e]#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\"\u0011QXAD\u0011\u001d\t)\r\u0001C\u0001\u0003g\tQ\u0007^3ti\u001a+Go\u00195PM\u001a\u001cX\r\u001e$peRKW.Z:uC6\u0004X\t]8dQZ\u000bG.\u001b3bi&|gNR8s\r>dGn\\<fe\"\"\u00111YAD\u0011\u001d\tY\r\u0001C\u0005\u0003\u001b\fqc]3ukB\u0004\u0016M\u001d;ji&|gnV5uQ6{7m[:\u0015\u0011\u0005=\u0017Q[Am\u0003G\u00042AEAi\u0013\r\t\u0019N\u0001\u0002\n!\u0006\u0014H/\u001b;j_:Dq!a6\u0002J\u0002\u0007a#A\u0006mK\u0006$WM]#q_\u000eD\u0007\u0002CAn\u0003\u0013\u0004\r!!8\u0002\u0011%\u001cH*Z1eKJ\u00042!CAp\u0013\r\t\tO\u0003\u0002\b\u0005>|G.Z1o\u0011)\t)!!3\u0011\u0002\u0003\u0007\u0011Q\u001d\t\u0005\u0003\u0003\t9/\u0003\u0003\u0002j\u0006\r!a\u0001'pO\"9\u0011Q\u001e\u0001\u0005\u0002\u0005M\u0012A\f;fgR\f\u0005\u000f]3oIJ+7m\u001c:eg\u0006\u001bhi\u001c7m_^,'OQ3m_^dunZ*uCJ$xJ\u001a4tKRDC!a;\u0002\b\"9\u00111\u001f\u0001\u0005\u0002\u0005M\u0012!\b;fgRd\u0015n\u001d;PM\u001a\u001cX\r^%t_2\fG/[8o\u0019\u00164X\r\\:)\t\u0005E\u0018q\u0011\u0005\b\u0003s\u0004A\u0011AA\u001a\u00039!Xm\u001d;HKR\u0014V\r\u001d7jG\u0006DC!a>\u0002\b\"9\u0011q \u0001\u0005\u0002\u0005M\u0012a\u000e;fgR\f\u0005\u000f]3oIJ+7m\u001c:egR{gi\u001c7m_^,'oV5uQ:{'+\u001a9mS\u000e\fG\u000b\u001b:poN,\u0005pY3qi&|g\u000e\u000b\u0003\u0002~\u0006\u001d\u0005b\u0002B\u0003\u0001\u0011\u0005\u00111G\u0001%i\u0016\u001cH/T1lK\u001a{G\u000e\\8xKJ<\u0016\u000e\u001e5O_2+\u0017\rZ3s\u0013\u0012\u001c\u0005.\u00198hK\"\"!1AAD\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003g\tq\t^3ti\u001a{G\u000e\\8xKJ$u.Z:O_RTu.\u001b8J'J+f\u000e^5m\u0007\u0006,x\r\u001b;VaR{wJ\u001a4tKR<\u0016\u000e\u001e5j]\u000e+(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\u0015\u0005\u0005\u0013\t9\tC\u0004\u0003\u0012\u0001!\t!a\r\u0002EQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eD\u0017I\u001a;fe\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3tQ\u0011\u0011y!a\"\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a\u0005i1M]3bi\u0016\u0014VmY8sIN$\u0002Ba\u0007\u0003(\t\r#Q\n\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )\u0019!\u0011\u0005\u0011\u0002\rI,7m\u001c:e\u0013\u0011\u0011)Ca\b\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011!\u0011IC!\u0006A\u0002\t-\u0012a\u0002:fG>\u0014Hm\u001d\t\u0007\u0005[\u00119D!\u0010\u000f\t\t=\"1\u0007\b\u0005\u0003?\u0012\t$C\u0001\f\u0013\r\u0011)DC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011IDa\u000f\u0003\u0011%#XM]1cY\u0016T1A!\u000e\u000b!\u0011\u0011iBa\u0010\n\t\t\u0005#q\u0004\u0002\r'&l\u0007\u000f\\3SK\u000e|'\u000f\u001a\u0005\t\u0005\u000b\u0012)\u00021\u0001\u0003H\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0011\u0007%\u0011I%C\u0002\u0003L)\u0011A\u0001T8oO\"I!q\nB\u000b!\u0003\u0005\rAF\u0001\u0015a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016\u0003xn\u00195\t\u000f\tM\u0003\u0001\"\u0001\u0003V\u0005Q2M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYJ+7m\u001c:egRA!1\u0004B,\u00053\u0012Y\u0006\u0003\u0005\u0003*\tE\u0003\u0019\u0001B\u0016\u0011!\u0011)E!\u0015A\u0002\t\u001d\u0003\"\u0003B(\u0005#\u0002\n\u00111\u0001\u0017\u0011%\u0011y\u0006AI\u0001\n\u0013\u0011\t'A\u0011tKR,\b\u000fU1si&$\u0018n\u001c8XSRDWj\\2lg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003d)\"\u0011Q\u001dB3W\t\u00119\u0007\u0005\u0003\u0003j\tMTB\u0001B6\u0015\u0011\u0011iGa\u001c\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B9\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU$1\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B=\u0001E\u0005I\u0011\u0001B>\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003~)\u001aaC!\u001a\t\u0013\t\u0005\u0005!%A\u0005\u0002\tm\u0014\u0001J2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Metrics metrics = new Metrics();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private LogConfig logConfig;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$10 = false;
        int x$11 = CleanerConfig$.MODULE$.apply$default$1();
        long x$12 = CleanerConfig$.MODULE$.apply$default$2();
        double x$13 = CleanerConfig$.MODULE$.apply$default$3();
        int x$14 = CleanerConfig$.MODULE$.apply$default$4();
        int x$15 = CleanerConfig$.MODULE$.apply$default$5();
        double x$16 = CleanerConfig$.MODULE$.apply$default$6();
        long x$17 = CleanerConfig$.MODULE$.apply$default$7();
        String x$18 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$10, x$18), this.time()));
        this.logManager().startup();
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        brokerProps.put(KafkaConfig$.MODULE$.LogDirsProp(), ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(brokerProps);
        KafkaZkClient kafkaZkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        this.replicaManager_$eq(new ReplicaManager(brokerConfig, this.metrics(), (Time)this.time(), kafkaZkClient, (Scheduler)new MockScheduler((Time)this.time()), this.logManager(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(brokerConfig, this.metrics(), (Time)this.time(), ""), this.brokerTopicStats(), new MetadataCache(this.brokerId()), new LogDirFailureChannel(brokerConfig.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        EasyMock.expect((Object)kafkaZkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)logProps).anyTimes();
        EasyMock.expect((Object)kafkaZkClient.conditionalUpdatePath((String)EasyMock.anyObject(), (byte[])EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), (Option)EasyMock.anyObject())).andReturn((Object)new Tuple2.mcZI.sp(true, 0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaZkClient});
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
        this.metrics().close();
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().shutdown(false);
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$19 = this.topicPartition();
        LogConfig x$20 = this.logConfig();
        boolean x$21 = qual$1.getOrCreateLog$default$3();
        boolean x$22 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$19, x$20, x$21, x$22);
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log.appendAsLeader$default$3());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)PartitionTest.$anonfun$testMakeLeaderUpdatesEpochCache$1(x$2))));
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_10_2_IV0$.MODULE$.shortVersion())})))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$2 = this.logManager();
        TopicPartition x$23 = this.topicPartition();
        LogConfig x$24 = logConfig;
        boolean x$25 = qual$2.getOrCreateLog$default$3();
        boolean x$26 = qual$2.getOrCreateLog$default$4();
        Log log = qual$2.getOrCreateLog(x$23, x$24, x$25, x$26);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log.appendAsLeader$default$3());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)PartitionTest.$anonfun$testMakeLeaderDoesNotUpdateEpochCacheForOldFormats$1(x$3))));
        Assert.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$3 = this.logManager();
        TopicPartition x$27 = this.topicPartition();
        LogConfig x$28 = this.logConfig();
        boolean x$29 = qual$3.getOrCreateLog$default$3();
        boolean x$30 = qual$3.getOrCreateLog$default$4();
        Log log1 = qual$3.getOrCreateLog(x$27, x$28, x$29, x$30);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$4 = this.logManager();
        TopicPartition x$31 = this.topicPartition();
        LogConfig x$32 = this.logConfig();
        boolean x$33 = true;
        boolean x$34 = qual$4.getOrCreateLog$default$3();
        Log log2 = qual$4.getOrCreateLog(x$31, x$32, x$34, x$33);
        int x$35 = this.brokerId();
        TopicPartition x$36 = this.topicPartition();
        MockTime x$37 = this.time();
        Some x$38 = new Some((Object)log1);
        long x$39 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$35, x$36, (Time)x$37, x$39, (Option)x$38);
        int x$40 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$41 = this.topicPartition();
        MockTime x$42 = this.time();
        Some x$43 = new Some((Object)log2);
        long x$44 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$40, x$41, (Time)x$42, x$44, (Option)x$43);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.localReplica());
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.futureLocalReplica());
        Thread thread1 = new Thread(null, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.removeFutureLocalReplica(this.partition$1.removeFutureLocalReplica$default$1());
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        Thread thread2 = new Thread(null, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.maybeReplaceCurrentWithFutureReplica();
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.futureLocalReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log) {
        java.util.List replicas;
        int x$49 = this.brokerId();
        TopicPartition x$50 = this.topicPartition();
        MockTime x$51 = this.time();
        Some x$52 = new Some((Object)log);
        long x$53 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$49, x$50, (Time)x$51, x$53, (Option)x$52);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        int controllerId = 0;
        int controllerEpoch = 0;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        } else {
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId() + 1, leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)partition.leaderReplicaIfLocal());
        }
        return partition;
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$10 = this.logManager();
        TopicPartition x$90 = this.topicPartition();
        LogConfig x$91 = this.logConfig();
        boolean x$92 = qual$10.getOrCreateLog$default$3();
        boolean x$93 = qual$10.getOrCreateLog$default$4();
        return qual$10.getOrCreateLog(x$90, x$91, x$92, x$93);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        LogManager qual$6 = this.logManager();
        TopicPartition x$54 = this.topicPartition();
        LogConfig x$55 = this.logConfig();
        boolean x$56 = qual$6.getOrCreateLog$default$3();
        boolean x$57 = qual$6.getOrCreateLog$default$4();
        Log log = qual$6.getOrCreateLog(x$54, x$55, x$56, x$57);
        int x$58 = this.brokerId();
        TopicPartition x$59 = this.topicPartition();
        MockTime x$60 = this.time();
        Some x$61 = new Some((Object)log);
        long x$62 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$58, x$59, (Time)x$60, x$62, (Option)x$61);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        long initialLogStartOffset = 5L;
        partition.truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 3L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), newLogStartOffset, this.createRecords$default$3());
        partition.appendRecordsToFollowerOrFutureReplica(records, false);
        Assert.assertEquals((String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)7L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)newLogStartOffset, (long)replica.logStartOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 7:", (long)8L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 3L, this.createRecords$default$3());
            return partition.appendRecordsToFollowerOrFutureReplica(records2, false);
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)8L, (long)replica.logEndOffset().messageOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 8:", (long)9L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)replica.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        java.util.List replicas;
        LogManager qual$7 = this.logManager();
        TopicPartition x$63 = this.topicPartition();
        LogConfig x$64 = this.logConfig();
        boolean x$65 = qual$7.getOrCreateLog$default$3();
        boolean x$66 = qual$7.getOrCreateLog$default$4();
        Log log = qual$7.getOrCreateLog(x$63, x$64, x$65, x$66);
        int x$67 = this.brokerId();
        TopicPartition x$68 = this.topicPartition();
        MockTime x$69 = this.time();
        Some x$70 = new Some((Object)log);
        long x$71 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$67, x$68, (Time)x$69, x$71, (Option)x$70);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), 0L, this.createTransactionalRecords$default$3());
        partition.appendRecordsToLeader(records, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((long)3L, (long)PartitionTest.fetchLatestOffset$1((Option)None$.MODULE$, partition).offset());
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition).offset());
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), partition).offset());
        replica.highWatermark_$eq(new LogOffsetMetadata(1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((long)3L, (long)PartitionTest.fetchLatestOffset$1((Option)None$.MODULE$, partition).offset());
        Assert.assertEquals((long)1L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition).offset());
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), partition).offset());
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)None$.MODULE$, partition).offset());
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition).offset());
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), partition).offset());
    }

    @Test
    public void testGetReplica() {
        LogManager qual$8 = this.logManager();
        TopicPartition x$72 = this.topicPartition();
        LogConfig x$73 = this.logConfig();
        boolean x$74 = qual$8.getOrCreateLog$default$3();
        boolean x$75 = qual$8.getOrCreateLog$default$4();
        Log log = qual$8.getOrCreateLog(x$72, x$73, x$74, x$75);
        int x$76 = this.brokerId();
        TopicPartition x$77 = this.topicPartition();
        MockTime x$78 = this.time();
        Some x$79 = new Some((Object)log);
        long x$80 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$76, x$77, (Time)x$78, x$80, (Option)x$79);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.localReplica());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.localReplicaOrException(), ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        Assert.assertEquals((Object)replica, (Object)partition.localReplicaOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 0L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        LeaderAndIsrRequest.PartitionState partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        partition.makeFollower(0, partitionStateInfo, 0);
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        Assert.assertTrue((boolean)partition.makeFollower(0, partitionStateInfo, 2));
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        Assert.assertFalse((boolean)partition.makeFollower(0, partitionStateInfo, 2));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition.getReplica(leader).get();
        Replica follower1Replica = (Replica)partition.getReplica(follower1).get();
        Replica follower2Replica = (Replica)partition.getReplica(follower2).get();
        long lastOffsetOfFirstBatch = partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3()).lastOffset();
        partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)leaderReplica.highWatermark().messageOffset());
        partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)partition.makeLeader(controllerEpoch, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch + 2, isr, 1, replicas, false), 2));
        long currentLeaderEpochStartOffset = leaderReplica.logEndOffset().messageOffset();
        partition.appendRecordsToLeader(batch3, true, partition.appendRecordsToLeader$default$3());
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()), Set$.MODULE$.canBuildFrom()));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch3, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()), Set$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDelayedFetchAfterAppendRecords() {
        java.util.List replicaIds;
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicaIds = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)i -> PartitionTest.$anonfun$testDelayedFetchAfterAppendRecords$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq logs = (IndexedSeq)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
            LogManager qual$9 = this.logManager();
            TopicPartition x$81 = tp;
            LogConfig x$82 = logConfig;
            boolean x$83 = qual$9.getOrCreateLog$default$3();
            boolean x$84 = qual$9.getOrCreateLog$default$4();
            return qual$9.getOrCreateLog(x$81, x$82, x$83, x$84);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq replicas = (IndexedSeq)logs.map((Function1 & Serializable & scala.Serializable)log -> {
            int x$85 = this.brokerId();
            TopicPartition x$86 = log.topicPartition();
            MockTime x$87 = this.time();
            Some x$88 = new Some(log);
            long x$89 = Replica$.MODULE$.$lessinit$greater$default$4();
            return new Replica(x$85, x$86, (Time)x$87, x$89, (Option)x$88);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq partitions = (IndexedSeq)replicas.map((Function1 & Serializable & scala.Serializable)replica -> {
            TopicPartition tp = replica.topicPartition();
            Partition partition = new Partition(tp, false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
            partition.addReplicaIfNotExists(replica);
            partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicaIds, true), 0);
            return partition;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Capture tpKey = EasyMock.newCapture();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.capture((Capture)tpKey));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, leaderEpoch, topicPartitions, partitions, tpKey){
            private final int leaderEpoch$1;
            private final IndexedSeq topicPartitions$1;
            private final IndexedSeq partitions$1;
            private final Capture tpKey$1;

            public void answer() {
                int anotherPartition = (((TopicPartitionOperationKey)this.tpKey$1.getValue()).partition() + 1) % this.topicPartitions$1.size();
                Partition partition = (Partition)this.partitions$1.apply(anotherPartition);
                partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(this.leaderEpoch$1)), true);
            }
            {
                this.leaderEpoch$1 = leaderEpoch$1;
                this.topicPartitions$1 = topicPartitions$1;
                this.partitions$1 = partitions$1;
                this.tpKey$1 = tpKey$1;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        AtomicBoolean done = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(topicPartitions.size() + 1);
        try {
            try {
                executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    while (!done.get()) {
                        partitions.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                            x$7.maybeShrinkIsr(10000L);
                            return BoxedUnit.UNIT;
                        });
                    }
                }));
                IndexedSeq futures = (IndexedSeq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10000).foreach((Function1 & Serializable & scala.Serializable)x$8 -> partition.appendRecordsToLeader(this.createRecords$1(0L), true, partition.appendRecordsToLeader$default$3())))), IndexedSeq$.MODULE$.canBuildFrom());
                futures.foreach((Function1 & Serializable & scala.Serializable)x$9 -> x$9.get(10L, TimeUnit.SECONDS));
                done.set(true);
            }
            catch (TimeoutException e) {
                String allThreads = TestUtils$.MODULE$.allThreadStackTraces();
                Assert.fail((String)new StringBuilder(53).append("Test timed out with exception ").append(e).append(", thread stack traces: ").append(allThreads).toString());
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createTransactionalRecords$default$3() {
        return 0;
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ long $anonfun$testMakeLeaderUpdatesEpochCache$1(Replica x$2) {
        return x$2.logEndOffset().messageOffset();
    }

    public static final /* synthetic */ long $anonfun$testMakeLeaderDoesNotUpdateEpochCacheForOldFormats$1(Replica x$3) {
        return x$3.logEndOffset().messageOffset();
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        Either either = partition$2.fetchOffsetSnapshotOrError(currentLeaderEpoch, true);
        if (either instanceof Left) {
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Errors error = (Errors)right.value();
            Assert.assertEquals((Object)expectedError, (Object)error);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        Either either = partition$3.fetchOffsetSnapshotOrError(currentLeaderEpoch, fetchOnlyLeader);
        if (either instanceof Left) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.NONE);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Errors error = (Errors)right.value();
            Assert.assertEquals((Object)expectedError, (Object)error);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final TimestampOffset fetchLatestOffset$1(Option isolationLevel, Partition partition$11) {
        return partition$11.fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
    }

    private static final TimestampOffset fetchEarliestOffset$1(Option isolationLevel, Partition partition$11) {
        return partition$11.fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
    }

    private final LogReadResult readResult$1(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset().messageOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    public static final /* synthetic */ TopicPartition $anonfun$testDelayedFetchAfterAppendRecords$1(int i) {
        return new TopicPartition("test-topic", i);
    }

    private final MemoryRecords createRecords$1(long baseOffset) {
        .colon.colon records = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)0);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public PartitionTest() {
        this.brokerId = 101;
    }
}

