/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import kafka.common.InterBrokerSendThread;
import kafka.common.InterBrokerSendThread$;
import kafka.common.RequestAndCompletionHandler;
import kafka.utils.MockTime;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fG\rV3ti*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0005+\u0005!A/[7f+\u00051\u0002CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0015)H/\u001b7t\u0013\tY\u0002D\u0001\u0005N_\u000e\\G+[7f\u0011\u0019i\u0002\u0001)A\u0005-\u0005)A/[7fA!9q\u0004\u0001b\u0001\n\u0013\u0001\u0013!\u00048fi^|'o[\"mS\u0016tG/F\u0001\"!\t\u0011#&D\u0001$\u0015\t!S%A\u0004dY&,g\u000e^:\u000b\u0005\u00151#BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001eL!aK\u0012\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0011\u0019i\u0003\u0001)A\u0005C\u0005qa.\u001a;x_J\\7\t\\5f]R\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\u0012G>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014X#A\u0019\u0011\u0005I\u001aT\"\u0001\u0001\u0007\tQ\u0002A!\u000e\u0002\u0016'R,(mQ8na2,G/[8o\u0011\u0006tG\r\\3s'\r\u0019dG\u0010\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nA\u0001\\1oO*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u0019y%M[3diB\u0011!eP\u0005\u0003\u0001\u000e\u0012\u0001DU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0011\u0015y1\u0007\"\u0001C)\u0005\t\u0004b\u0002#4\u0001\u0004%\t!R\u0001!Kb,7-\u001e;fI^KG\u000f\u001b#jg\u000e|gN\\3di\u0016$'+Z:q_:\u001cX-F\u0001G!\tIq)\u0003\u0002I\u0015\t9!i\\8mK\u0006t\u0007b\u0002&4\u0001\u0004%\taS\u0001%Kb,7-\u001e;fI^KG\u000f\u001b#jg\u000e|gN\\3di\u0016$'+Z:q_:\u001cXm\u0018\u0013fcR\u0011Aj\u0014\t\u0003\u00135K!A\u0014\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b!&\u000b\t\u00111\u0001G\u0003\rAH%\r\u0005\u0007%N\u0002\u000b\u0015\u0002$\u0002C\u0015DXmY;uK\u0012<\u0016\u000e\u001e5ESN\u001cwN\u001c8fGR,GMU3ta>t7/\u001a\u0011\t\u0013Q\u001b\u0004\u0019!a\u0001\n\u0003)\u0016\u0001\u0003:fgB|gn]3\u0016\u0003Y\u0003\"AI,\n\u0005a\u001b#AD\"mS\u0016tGOU3ta>t7/\u001a\u0005\n5N\u0002\r\u00111A\u0005\u0002m\u000bAB]3ta>t7/Z0%KF$\"\u0001\u0014/\t\u000fAK\u0016\u0011!a\u0001-\"Ial\ra\u0001\u0002\u0003\u0006KAV\u0001\ne\u0016\u001c\bo\u001c8tK\u0002BQ\u0001Y\u001a\u0005B\u0005\f!b\u001c8D_6\u0004H.\u001a;f)\ta%\rC\u0003U?\u0002\u0007a\u000b\u0003\u0004e\u0001\u0001\u0006I!M\u0001\u0013G>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\b\u0005C\u0004g\u0001\t\u0007I\u0011B4\u0002!I,\u0017/^3tiRKW.Z8vi6\u001bX#\u00015\u0011\u0005%I\u0017B\u00016\u000b\u0005\rIe\u000e\u001e\u0005\u0007Y\u0002\u0001\u000b\u0011\u00025\u0002#I,\u0017/^3tiRKW.Z8vi6\u001b\b\u0005C\u0003o\u0001\u0011\u0005q.A\u0012tQ>,H\u000e\u001a(piN+g\u000eZ!osRD\u0017N\\4XQ\u0016tgj\u001c*fcV,7\u000f^:\u0015\u00031C#!\\9\u0011\u0005I,X\"A:\u000b\u0005QD\u0013!\u00026v]&$\u0018B\u0001<t\u0005\u0011!Vm\u001d;\t\u000ba\u0004A\u0011A8\u0002_MDw.\u001e7e\u0007J,\u0017\r^3DY&,g\u000e\u001e*fcV,7\u000f^!oIN+g\u000eZ,iK:tu\u000eZ3JgJ+\u0017\rZ=)\u0005]\f\b\"B>\u0001\t\u0003y\u0017aQ:i_VdGmQ1mY\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'oV5uQ\u0012K7oY8o]\u0016\u001cG/\u001a3SKN\u0004xN\\:f/\",gNT8eK:{GOU3bIfD#A_9\t\u000by\u0004A\u0011A8\u00025Q,7\u000f\u001e$bS2LgnZ#ya&\u0014X\r\u001a*fcV,7\u000f^:)\u0005u\fhABA\u0002\u0001\u0011\t)A\u0001\nTiV\u0014'+Z9vKN$()^5mI\u0016\u00148\u0003BA\u0001\u0003\u000f\u0001b!!\u0003\u0002\u0018\u0005ua\u0002BA\u0006\u0003'i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\te\u0016\fX/Z:ug*\u00111!J\u0005\u0005\u0003+\ti!A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\u0011\tI\"a\u0007\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011QCA\u0007!\rI\u0011qD\u0005\u0004\u0003CQ!a\u0002(pi\"Lgn\u001a\u0005\b\u001f\u0005\u0005A\u0011AA\u0013)\t\t9\u0003E\u00023\u0003\u0003A\u0001\"a\u000b\u0002\u0002\u0011\u0005\u0013QF\u0001\u0006EVLG\u000e\u001a\u000b\u0005\u0003;\ty\u0003\u0003\u0005\u00022\u0005%\u0002\u0019AA\u001a\u0003\u001d1XM]:j_:\u00042!CA\u001b\u0013\r\t9D\u0003\u0002\u0006'\"|'\u000f\u001e")
public class InterBrokerSendThreadTest {
    private final MockTime kafka$common$InterBrokerSendThreadTest$$time = new MockTime();
    private final NetworkClient kafka$common$InterBrokerSendThreadTest$$networkClient = (NetworkClient)EasyMock.createMock(NetworkClient.class);
    private final StubCompletionHandler completionHandler = new StubCompletionHandler();
    private final int kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs;

    public MockTime kafka$common$InterBrokerSendThreadTest$$time() {
        return this.kafka$common$InterBrokerSendThreadTest$$time;
    }

    public NetworkClient kafka$common$InterBrokerSendThreadTest$$networkClient() {
        return this.kafka$common$InterBrokerSendThreadTest$$networkClient;
    }

    private StubCompletionHandler completionHandler() {
        return this.completionHandler;
    }

    public int kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs() {
        return this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs;
    }

    @Test
    public void shouldNotSendAnythingWhenNoRequests() {
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this){
            private final int requestTimeoutMs;

            public int requestTimeoutMs() {
                return this.requestTimeoutMs;
            }

            public Iterable<Nothing$> generateRequests() {
                return (Iterable)Iterable$.MODULE$.empty();
            }
            {
                this.requestTimeoutMs = $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs();
            }
        };
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn((Object)Utils.mkList((Object[])new ClientResponse[0]));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertFalse((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void shouldCreateClientRequestAndSendWhenNodeIsReady() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler handler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this, handler){
            private final int requestTimeoutMs;
            private final RequestAndCompletionHandler handler$1;

            public int requestTimeoutMs() {
                return this.requestTimeoutMs;
            }

            public List<RequestAndCompletionHandler> generateRequests() {
                return new .colon.colon((Object)this.handler$1, (List)Nil$.MODULE$);
            }
            {
                this.handler$1 = handler$1;
                super("name", $outer.kafka$common$InterBrokerSendThreadTest$$networkClient(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4());
                this.requestTimeoutMs = $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs();
            }
        };
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", 0L, true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), handler.handler());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)handler.request()), EasyMock.anyLong(), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)handler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.kafka$common$InterBrokerSendThreadTest$$networkClient().send(clientRequest, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn((Object)Utils.mkList((Object[])new ClientResponse[0]));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertFalse((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void shouldCallCompletionHandlerWithDisconnectedResponseWhenNodeNotReady() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler requestAndCompletionHandler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this, requestAndCompletionHandler){
            private final int requestTimeoutMs;
            private final RequestAndCompletionHandler requestAndCompletionHandler$1;

            public int requestTimeoutMs() {
                return this.requestTimeoutMs;
            }

            public List<RequestAndCompletionHandler> generateRequests() {
                return new .colon.colon((Object)this.requestAndCompletionHandler$1, (List)Nil$.MODULE$);
            }
            {
                this.requestAndCompletionHandler$1 = requestAndCompletionHandler$1;
                super("name", $outer.kafka$common$InterBrokerSendThreadTest$$networkClient(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4());
                this.requestTimeoutMs = $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs();
            }
        };
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", 0L, true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), requestAndCompletionHandler.handler());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)requestAndCompletionHandler.request()), EasyMock.anyLong(), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)requestAndCompletionHandler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionDelay((Node)EasyMock.anyObject(), EasyMock.anyLong()))).andReturn((Object)BoxesRunTime.boxToLong((long)0L));
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn((Object)Utils.mkList((Object[])new ClientResponse[0]));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionFailed(node))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().authenticationException(node)).andReturn((Object)new AuthenticationException(""));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertTrue((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void testFailingExpiredRequests() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler handler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this, handler){
            private final int requestTimeoutMs;
            private final RequestAndCompletionHandler handler$2;

            public int requestTimeoutMs() {
                return this.requestTimeoutMs;
            }

            public List<RequestAndCompletionHandler> generateRequests() {
                return new .colon.colon((Object)this.handler$2, (List)Nil$.MODULE$);
            }
            {
                this.handler$2 = handler$2;
                super("name", $outer.kafka$common$InterBrokerSendThreadTest$$networkClient(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4());
                this.requestTimeoutMs = $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs();
            }
        };
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds(), true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), handler.handler());
        this.kafka$common$InterBrokerSendThreadTest$$time().sleep(1500L);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)handler.request()), EasyMock.eq((long)this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)handler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionDelay((Node)EasyMock.anyObject(), EasyMock.anyLong()))).andReturn((Object)BoxesRunTime.boxToLong((long)0L));
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn((Object)Utils.mkList((Object[])new ClientResponse[0]));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionFailed(node))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertFalse((boolean)sendThread.hasUnsentRequests());
        Assert.assertTrue((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    public InterBrokerSendThreadTest() {
        this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs = 1000;
    }

    public class StubCompletionHandler
    implements RequestCompletionHandler {
        private boolean executedWithDisconnectedResponse;
        private ClientResponse response;

        public boolean executedWithDisconnectedResponse() {
            return this.executedWithDisconnectedResponse;
        }

        public void executedWithDisconnectedResponse_$eq(boolean x$1) {
            this.executedWithDisconnectedResponse = x$1;
        }

        public ClientResponse response() {
            return this.response;
        }

        public void response_$eq(ClientResponse x$1) {
            this.response = x$1;
        }

        public void onComplete(ClientResponse response) {
            this.executedWithDisconnectedResponse_$eq(response.wasDisconnected());
            this.response_$eq(response);
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$StubCompletionHandler$$$outer() {
            return InterBrokerSendThreadTest.this;
        }

        public StubCompletionHandler() {
            if (InterBrokerSendThreadTest.this == null) {
                throw null;
            }
            this.executedWithDisconnectedResponse = false;
        }
    }

    public class StubRequestBuilder
    extends AbstractRequest.Builder<Nothing$> {
        public Nothing$ build(short version) {
            return Predef$.MODULE$.$qmark$qmark$qmark();
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$StubRequestBuilder$$$outer() {
            return InterBrokerSendThreadTest.this;
        }

        public StubRequestBuilder() {
            if (InterBrokerSendThreadTest.this == null) {
                throw null;
            }
            super(ApiKeys.END_TXN);
        }
    }
}

