/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerState;
import kafka.controller.ControllerTestUtils$;
import kafka.controller.KafkaController;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionState;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001\u001d\u0011acQ8oiJ|G\u000e\\3s\r\u0006LGn\u001c<feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005\u0019An\\4\u0016\u0003q\u0001\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u000b1|w\r\u000e6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0005\u0003Ky\u0011a\u0001T8hO\u0016\u0014\bBB\u0014\u0001A\u0003%A$\u0001\u0003m_\u001e\u0004\u0003bB\u0015\u0001\u0005\u0004%\tAK\u0001\t]Vlgj\u001c3fgV\t1\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0002J]RDaA\r\u0001!\u0002\u0013Y\u0013!\u00038v[:{G-Z:!\u0011\u001d!\u0004A1A\u0005\u0002)\n\u0001B\\;n!\u0006\u0014Ho\u001d\u0005\u0007m\u0001\u0001\u000b\u0011B\u0016\u0002\u00139,X\u000eU1siN\u0004\u0003b\u0002\u001d\u0001\u0005\u0004%\tAK\u0001\r[N<\u0017+^3vKNK'0\u001a\u0005\u0007u\u0001\u0001\u000b\u0011B\u0016\u0002\u001b5\u001cx-U;fk\u0016\u001c\u0016N_3!\u0011\u001da\u0004A1A\u0005\u0002u\nQ\u0001^8qS\u000e,\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019\u0019FO]5oO\"1q\t\u0001Q\u0001\ny\na\u0001^8qS\u000e\u0004\u0003bB%\u0001\u0005\u0004%\tAS\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u0005\u0006!Q\u000f^5m\u0013\t\u0001VJ\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u0015\u0001!\u0002\u0013Y\u0015\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0011\u001d!\u0006A1A\u0005\u0002U\u000bq!\\3ue&\u001c7/F\u0001W!\t9F,D\u0001Y\u0015\t!\u0016L\u0003\u0002[7\u000611m\\7n_:T!!\u0002\u0011\n\u0005uC&aB'fiJL7m\u001d\u0005\u0007?\u0002\u0001\u000b\u0011\u0002,\u0002\u00115,GO]5dg\u0002BQ!\u0019\u0001\u0005B\t\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002GB\u0019A\r\\8\u000f\u0005\u0015TgB\u00014j\u001b\u00059'B\u00015\u0007\u0003\u0019a$o\\8u}%\ta&\u0003\u0002l[\u00059\u0001/Y2lC\u001e,\u0017BA7o\u0005\r\u0019V-\u001d\u0006\u0003W6\u0002\"\u0001]:\u000e\u0003ET!A\u001d\u0003\u0002\rM,'O^3s\u0013\t!\u0018OA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u0002<\u0001\t\u0003:\u0018\u0001\u0003;fCJ$un\u001e8\u0015\u0003a\u0004\"\u0001L=\n\u0005il#\u0001B+oSRD#!\u001e?\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty(%A\u0003kk:LG/C\u0002\u0002\u0004y\u0014Q!\u00114uKJDa!a\u0002\u0001\t\u00039\u0018a\b;fgRD\u0015M\u001c3mK&cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]\"\"\u0011QAA\u0006!\ri\u0018QB\u0005\u0004\u0003\u001fq(\u0001\u0002+fgR\u0004")
public class ControllerFailoverTest
extends KafkaServerTestHarness {
    private final Logger log = Logger.getLogger(ControllerFailoverTest.class);
    private final int numNodes;
    private final int numParts;
    private final int msgQueueSize;
    private final String topic;
    private final Properties overridingProps = new Properties();
    private final Metrics metrics = new Metrics();

    public Logger log() {
        return this.log;
    }

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public int msgQueueSize() {
        return this.msgQueueSize;
    }

    public String topic() {
        return this.topic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.metrics().close();
    }

    @Test
    public void testHandleIllegalStateException() {
        KafkaController initialController = (KafkaController)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$1(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.kafkaController()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("Could not find controller", new Position("ControllerFailoverTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58)));
        int initialEpoch = initialController.epoch();
        this.createTopic(this.topic(), 1, 1, this.createTopic$default$4());
        TopicPartition topicPartition = new TopicPartition("topic1", 0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialController.partitionStateMachine().partitionsInState((PartitionState)OnlinePartition$.MODULE$).contains((Object)topicPartition), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Partition ").append(topicPartition).append(" did not transition to online state").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        CountDownLatch latch = new CountDownLatch(1);
        VolatileObjectRef exceptionThrown = VolatileObjectRef.create((Object)None$.MODULE$);
        ControllerEvent illegalStateEvent = ControllerTestUtils$.MODULE$.createMockControllerEvent((ControllerState)ControllerState.BrokerChange$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                throw initialController.handleIllegalState(new IllegalStateException("Thrown for test purposes"));
            }
            catch (Throwable t) {
                exceptionThrown$1.elem = new Some((Object)t);
                latch.await();
                return;
            }
        });
        initialController.eventManager().put(illegalStateEvent);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !initialController.kafkaScheduler().isStarted(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Scheduler was not shutdown", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !initialController.isActive(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller did not become inactive", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Option)exceptionThrown$1.elem).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "handleIllegalState did not throw an exception", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((String)new StringBuilder(73).append("handleIllegalState should throw an IllegalStateException, but ").append((Option)exceptionThrown.elem).append(" was thrown").toString(), (boolean)(((Option)exceptionThrown.elem).get() instanceof IllegalStateException));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().exists((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ControllerFailoverTest.$anonfun$testHandleIllegalStateException$15(initialEpoch, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to find controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$1(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testHandleIllegalStateException$15(int initialEpoch$1, KafkaServer server) {
        return server.kafkaController().isActive() && server.kafkaController().epoch() > initialEpoch$1;
    }

    public ControllerFailoverTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.msgQueueSize = 1;
        this.topic = "topic1";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
    }
}

