/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.PreferredReplicaElectionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001\u001d\u0011\u0011dQ8oiJ|G\u000e\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012aB:feZ,'o]\u000b\u0002-A\u0019q\u0003\b\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\u0002DA\u0002TKF\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0003EA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB\u0013\u0001\u0001\u0004%\tAJ\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002(WA\u0011\u0001&K\u0007\u00025%\u0011!F\u0007\u0002\u0005+:LG\u000fC\u0004-I\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004/\u0001\u0001\u0006KAF\u0001\tg\u0016\u0014h/\u001a:tA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014\u0001\u00064jeN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007.F\u00013!\tA3'\u0003\u000255\t\u0019\u0011J\u001c;\t\rY\u0002\u0001\u0015!\u00033\u0003U1\u0017N]:u\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0002Bq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011'A\u000fgSJ\u001cHoQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b.l-\u0016\u00148/[8o\u0011\u0019Q\u0004\u0001)A\u0005e\u0005qb-\u001b:ti\u000e{g\u000e\u001e:pY2,'/\u00129pG\"T6NV3sg&|g\u000e\t\u0005\u0006y\u0001!\t%P\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002O!\u00121h\u0010\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bQA[;oSRT\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$B\u0005\u0019\u0011UMZ8sK\")\u0001\n\u0001C!{\u0005AA/Z1s\t><h\u000e\u000b\u0002H\u0015B\u0011\u0001iS\u0005\u0003\u0019\u0006\u0013Q!\u00114uKJDQA\u0014\u0001\u0005\u0002u\n\u0001\u0003^3ti\u0016k\u0007\u000f^=DYV\u001cH/\u001a:)\u00055\u0003\u0006C\u0001!R\u0013\t\u0011\u0016I\u0001\u0003UKN$\b\"\u0002+\u0001\t\u0003i\u0014!\f;fgR\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007+\u001a:tSN$8o\u00165f]\u0006cGN\u0011:pW\u0016\u00148\u000fR8x]\"\u00121\u000b\u0015\u0005\u0006/\u0002!\t!P\u0001,i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001b>4X-\u00138de\u0016lWM\u001c;t\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"\u0012a\u000b\u0015\u0005\u00065\u0002!\t!P\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>t\u0007FA-Q\u0011\u0015i\u0006\u0001\"\u0001>\u0003\r\"Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D#\u0001\u0018)\t\u000b\u0001\u0004A\u0011A\u001f\u00027Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\ty\u0006\u000bC\u0003d\u0001\u0011\u0005Q(A\u0017uKN$Hk\u001c9jGB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\\,ji\"|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006D#A\u0019)\t\u000b\u0019\u0004A\u0011A\u001f\u00023Q,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0003KBCQ!\u001b\u0001\u0005\u0002u\n!\b^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi^KG\u000f[(gM2Lg.\u001a*fa2L7-\u0019%bYRLgn\u001a)s_\u001e\u0014Xm]:)\u0005!\u0004\u0006\"\u00027\u0001\t\u0003i\u0014a\u000e;fgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R\u0014Vm];nKN\fe\r^3s%\u0016\u0004H.[2b\u0007>lWm](oY&tW\r\u000b\u0002l!\")q\u000e\u0001C\u0001{\u0005\u0011C/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:D#A\u001c)\t\u000bI\u0004A\u0011A\u001f\u0002[Q,7\u000f\u001e\"bG.$vNQ1dWB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7\u000f\u000b\u0002r!\")Q\u000f\u0001C\u0001{\u0005iD/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5PM\u001ad\u0017N\\3Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\"\u0012A\u000f\u0015\u0005\u0006q\u0002!\t!P\u0001'i\u0016\u001cH/Q;u_B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t\u0007FA<Q\u0011\u0015Y\b\u0001\"\u0001>\u0003\u0011#Xm\u001d;MK\u0006$WM]!oI&\u001b(o\u00165f]\u0016sG/\u001b:f\u0013N\u0014xJ\u001a4mS:,\u0017I\u001c3V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3eQ\tQ\b\u000bC\u0003\u007f\u0001\u0011\u0005Q(A\"uKN$H*Z1eKJ\fe\u000eZ%te^CWM\\#oi&\u0014X-S:s\u001f\u001a4G.\u001b8f\u0003:$WK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0007FA?Q\u0011\u0019\t\u0019\u0001\u0001C\u0001{\u00051B/Z:u\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000eK\u0002\u0002\u0002ACa!!\u0003\u0001\t\u0003i\u0014!\t;fgR\u001cuN\u001c;s_2dWM]'pm\u0016|e\u000eV8qS\u000e\u001c%/Z1uS>t\u0007fAA\u0004!\"1\u0011q\u0002\u0001\u0005\u0002u\n\u0011\u0005^3ti\u000e{g\u000e\u001e:pY2,'/T8wK>sGk\u001c9jG\u0012+G.\u001a;j_:D3!!\u0004Q\u0011\u0019\t)\u0002\u0001C\u0001{\u0005aC/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f\u001f:\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017-\u00127fGRLwN\u001c\u0015\u0004\u0003'\u0001\u0006BBA\u000e\u0001\u0011\u0005Q(A\u0015uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004\u00033\u0001\u0006bBA\u0011\u0001\u0011%\u00111E\u0001\u0013i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001b>4X\rF\u0002(\u0003KA\u0001\"a\n\u0002 \u0001\u0007\u0011\u0011F\u0001\u0004MVt\u0007\u0003\u0002\u0015\u0002,\u001dJ1!!\f\u001b\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u00022\u0001!I!a\r\u0002=A\u0014XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>tGcC\u0014\u00026\u0005e\u0012QHA*\u0003[Bq!a\u000e\u00020\u0001\u0007!'\u0001\u0007d_:$(o\u001c7mKJLE\rC\u0004\u0002<\u0005=\u0002\u0019\u0001\u0010\u0002\u0017=$\b.\u001a:Ce>\\WM\u001d\u0005\t\u0003\u007f\ty\u00031\u0001\u0002B\u0005\u0011A\u000f\u001d\t\u0005\u0003\u0007\ny%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0019\u0019w.\\7p]*\u0019Q!a\u0013\u000b\u0007\u000553)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003#\n)E\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005U\u0013q\u0006a\u0001\u0003/\n\u0001B]3qY&\u001c\u0017m\u001d\t\u0006\u00033\n9G\r\b\u0005\u00037\n\u0019\u0007E\u0002\u0002^ii!!a\u0018\u000b\u0007\u0005\u0005d!\u0001\u0004=e>|GOP\u0005\u0004\u0003KR\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002j\u0005-$aA*fi*\u0019\u0011Q\r\u000e\t\u000f\u0005=\u0014q\u0006a\u0001e\u0005YA.Z1eKJ,\u0005o\\2i\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\n\u0001d^1jiVsG/\u001b7D_:$(o\u001c7mKJ,\u0005o\\2i)\u00159\u0013qOA>\u0011\u001d\tI(!\u001dA\u0002I\nQ!\u001a9pG\"D\u0001\"! \u0002r\u0001\u0007\u0011qP\u0001\b[\u0016\u001c8/Y4f!\u0011\tI&!!\n\t\u0005\r\u00151\u000e\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\u0006)r/Y5u\r>\u0014\b+\u0019:uSRLwN\\*uCR,GcC\u0014\u0002\f\u00065\u0015\u0011SAK\u0003/C\u0001\"a\u0010\u0002\u0006\u0002\u0007\u0011\u0011\t\u0005\b\u0003\u001f\u000b)\t1\u00013\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007bBAJ\u0003\u000b\u0003\rAM\u0001\u0007Y\u0016\fG-\u001a:\t\u000f\u0005=\u0014Q\u0011a\u0001e!A\u0011QPAC\u0001\u0004\ty\bC\u0004\u0002\u001c\u0002!I!!(\u00021%\u001cX\t\u001f9fGR,G\rU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0006\u0002 \u0006\u0015\u0016qVAY\u0003g\u00032\u0001KAQ\u0013\r\t\u0019K\u0007\u0002\b\u0005>|G.Z1o\u0011!\t9+!'A\u0002\u0005%\u0016a\u00077fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eE\u0002\u0013\u0003WK1!!,\u0003\u0005maU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"9\u0011qRAM\u0001\u0004\u0011\u0004bBAJ\u00033\u0003\rA\r\u0005\b\u0003_\nI\n1\u00013\u0011\u001d\t9\f\u0001C\u0005\u0003s\u000b1\"\\1lKN+'O^3sgR9a#a/\u0002@\u0006\r\u0007bBA_\u0003k\u0003\rAM\u0001\u000b]Vl7i\u001c8gS\u001e\u001c\bBCAa\u0003k\u0003\n\u00111\u0001\u0002 \u0006I\u0012-\u001e;p\u0019\u0016\fG-\u001a:SK\n\fG.\u00198dK\u0016s\u0017M\u00197f\u0011)\t)-!.\u0011\u0002\u0003\u0007\u0011qT\u0001\u001ck:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\u0006)A/[7feR!\u0011QZAs!\u0011\ty-!9\u000e\u0005\u0005E'\u0002BAj\u0003+\fAaY8sK*!\u0011q[Am\u0003\u001diW\r\u001e:jGNTA!a7\u0002^\u00061\u00110Y7nKJT!!a8\u0002\u0007\r|W.\u0003\u0003\u0002d\u0006E'!\u0002+j[\u0016\u0014\b\u0002CAt\u0003\u000f\u0004\r!a \u0002\u00155,GO]5d\u001d\u0006lW\rC\u0004\u0002l\u0002!I!!<\u0002\u001b\u001d,GoQ8oiJ|G\u000e\\3s)\u0005q\u0002\"CAy\u0001E\u0005I\u0011BAz\u0003Ui\u0017m[3TKJ4XM]:%I\u00164\u0017-\u001e7uII*\"!!>+\t\u0005}\u0015q_\u0016\u0003\u0003s\u0004B!a?\u0003\u00065\u0011\u0011Q \u0006\u0005\u0003\u007f\u0014\t!A\u0005v]\u000eDWmY6fI*\u0019!1\u0001\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\u0005u(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!1\u0002\u0001\u0012\u0002\u0013%\u00111_\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int firstControllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() + 1;
    private final int firstControllerEpochZkVersion = KafkaController$.MODULE$.InitialControllerEpochZkVersion() + 1;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int firstControllerEpoch() {
        return this.firstControllerEpoch;
    }

    public int firstControllerEpochZkVersion() {
        return this.firstControllerEpochZkVersion;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
    }

    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to kill controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicCreationWithOfflineReplica$1(x$1)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != controllerId)).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicPartitionExpansion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().setTopicAssignment(tp0.topic(), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicPartitionExpansionWithOfflineReplica$1(x$3)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != controllerId)).head());
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().setTopicAssignment(tp0.topic(), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)this.servers().apply(controllerId)}))), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testPartitionReassignment() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(ControllerState.PartitionReassignment$.MODULE$.rateAndTimeMetricName().get()).toString();
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignment$1(x$5)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment(reassignment);
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map map = this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()})));
            scala.collection.immutable.Map map2 = reassignment;
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get updated partition assignment on topic znode after partition reassignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().reassignPartitionsInProgress(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove reassign partitions path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        long updatedTimerCount = this.timer(metricName).count();
        Assert.assertTrue((String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString(), (updatedTimerCount > timerCount ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(x$7)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        KafkaServer controller = this.getController();
        this.zkClient().setOrCreatePartitionReassignment((Map)reassignment, controller.kafkaController().controllerContext().epochZkVersion());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().reassignPartitionsInProgress(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "partition reassignment path should remain while reassignment in progress", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(x$9)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPartitionReassignment(reassignment);
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map map = this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()})));
            scala.collection.immutable.Map map2 = reassignment;
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get updated partition assignment on topic znode after partition reassignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().reassignPartitionsInProgress(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove reassign partitions path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElection$1(controllerId, x$11))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testBackToBackPreferredReplicaLeaderElections$1(controllerId, x$12))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(x$13)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$14 -> x$14 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove preferred replica leader election path after giving up", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testAutoPreferredReplicaLeaderElection$1(x$15)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$16 -> x$16 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(x$17)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$18 -> x$18 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
            if (!leaderIsrAndControllerEpochMap.contains((Object)tp)) return false;
            if (!this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get expected partition state after entire isr went offline", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        int x$26 = 2;
        boolean x$27 = true;
        boolean x$28 = this.makeServers$default$2();
        this.servers_$eq(this.makeServers(x$26, x$28, x$27));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(x$19)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$20 -> x$20 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(1)).shutdown();
        ((KafkaServer)this.servers().apply(1)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
            if (!leaderIsrAndControllerEpochMap.contains((Object)tp)) return false;
            if (!this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get expected partition state after entire isr went offline", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testControlledShutdown() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        KafkaController controller = ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$3(controllerId, p))).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Function1 & Serializable & scala.Serializable controlledShutdownCallback = (Function1 & Serializable & scala.Serializable)controlledShutdownResult -> {
            resultQueue.put(controlledShutdownResult);
            return BoxedUnit.UNIT;
        };
        controller.controlledShutdown(2, (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$5(s)))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Seq)activeServers$1.elem).forall((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$8(topic, partition, x$21))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic test not created after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        UpdateMetadataRequest.PartitionState partitionStateInfo = (UpdateMetadataRequest.PartitionState)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.basePartitionState.leader;
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertEquals((long)2L, (long)partitionStateInfo.basePartitionState.isr.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo.basePartitionState.isr).asScala());
        controller.controlledShutdown(1, (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        activeServers.elem = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$9(s)));
        partitionStateInfo = (UpdateMetadataRequest.PartitionState)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.basePartitionState.leader;
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$10(topic, partition, x$22))));
        controller.controlledShutdown(0, (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)1L, (long)partitionsRemaining.size());
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$11(topic, partition, x$23))));
    }

    @Test
    public void testControllerMoveOnTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        this.testControllerMove((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
            adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK(tp.topic(), (Map)assignment, new Properties(), adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK$default$4());
        });
    }

    @Test
    public void testControllerMoveOnTopicDeletion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.testControllerMove((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
            adminZkClient.deleteTopic(tp.topic());
        });
    }

    @Test
    public void testControllerMoveOnPreferredReplicaElection() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.testControllerMove((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
    }

    @Test
    public void testControllerMoveOnPartitionReassignment() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        this.testControllerMove((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().createPartitionReassignment(reassignment));
    }

    private void testControllerMove(Function0<BoxedUnit> fun) {
        KafkaController controller = this.getController().kafkaController();
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), Level.INFO);
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                ControllerState controllerState = controller.eventManager().state();
                ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
                return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller event thread is still busy", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            CountDownLatch latch = new CountDownLatch(1);
            controller.eventManager().put((ControllerEvent)new KafkaController.AwaitOnLatch(latch));
            fun.apply$mcV$sp();
            this.zkClient().deleteController(controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            latch.countDown();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !controller.isActive(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller fails to resign", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            Option event = appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e)));
            Assert.assertTrue((boolean)event.isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), previousLevel);
        }
    }

    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set set = ((TraversableOnce)this.zkClient().getInSyncReplicasForPartition(new TopicPartition(tp.topic(), tp.partition())).get()).toSet();
            scala.collection.immutable.Set set2 = replicas;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "restarted broker failed to join in-sync replicas", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove preferred replica leader election path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    private void waitUntilControllerEpoch(int epoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerEpoch().map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24._1$mcI$sp())).contains((Object)BoxesRunTime.boxToInteger((int)epoch)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void waitForPartitionState(TopicPartition tp, int controllerEpoch, int leader, int leaderEpoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
            return leaderIsrAndControllerEpochMap.contains((Object)tp) && this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), controllerEpoch, leader, leaderEpoch);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private boolean isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable) {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)autoLeaderRebalanceEnable)).toString());
            config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeaderElectionEnable)).toString());
            return config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
        });
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$timer$1(metricName, x$25))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489)));
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    public static final /* synthetic */ int $anonfun$testTopicCreationWithOfflineReplica$1(KafkaServer x$1) {
        return x$1.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testTopicPartitionExpansionWithOfflineReplica$1(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignment$1(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(KafkaServer x$7) {
        return x$7.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(KafkaServer x$9) {
        return x$9.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElection$1(int controllerId$6, KafkaServer x$11) {
        return x$11.config().brokerId() != controllerId$6;
    }

    public static final /* synthetic */ boolean $anonfun$testBackToBackPreferredReplicaLeaderElections$1(int controllerId$7, KafkaServer x$12) {
        return x$12.config().brokerId() != controllerId$7;
    }

    public static final /* synthetic */ int $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(KafkaServer x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testAutoPreferredReplicaLeaderElection$1(KafkaServer x$15) {
        return x$15.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(KafkaServer x$17) {
        return x$17.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(KafkaServer x$19) {
        return x$19.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$3(int controllerId$12, KafkaServer p) {
        return p.config().brokerId() == controllerId$12;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$5(KafkaServer s) {
        return s.config().brokerId() != 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$8(String topic$1, int partition$1, KafkaServer x$21) {
        return ((UpdateMetadataRequest.PartitionState)x$21.apis().metadataCache().getPartitionInfo((String)topic$1, (int)partition$1).get()).basePartitionState.isr.size() != 3;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$9(KafkaServer s) {
        return s.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$10(String topic$1, int partition$1, KafkaServer x$22) {
        return ((UpdateMetadataRequest.PartitionState)x$22.apis().metadataCache().getPartitionInfo((String)topic$1, (int)partition$1).get()).basePartitionState.leader == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$11(String topic$1, int partition$1, KafkaServer x$23) {
        return ((UpdateMetadataRequest.PartitionState)x$23.apis().metadataCache().getPartitionInfo((String)topic$1, (int)partition$1).get()).basePartitionState.leader == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testControllerMove$5(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.INFO;
        if (level == null) {
            if (level2 != null) {
                return false;
            }
        } else if (!level.equals(level2)) return false;
        if (e.getThrowableInformation() == null) return false;
        if (!e.getThrowableInformation().getThrowable().getClass().getName().equals(new ControllerMovedException("").getClass().getName())) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, MetricName x$25) {
        String string = x$25.getMBeanName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$13, KafkaServer s) {
        return s.config().brokerId() == controllerId$13;
    }
}

