/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.Callbacks;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.CreateResponse$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.GetDataResponse$;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\rV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0001\u0004%I!G\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u000e\u0011\u0005YY\u0012B\u0001\u000f\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\b=\u0001\u0001\r\u0011\"\u0003 \u0003U\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010^0%KF$\"\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bOu\t\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007S\u0001\u0001\u000b\u0015\u0002\u000e\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\bW\u0001\u0001\r\u0011\"\u0003-\u00031iwnY6[W\u000ec\u0017.\u001a8u+\u0005i\u0003C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0005\u0003\tQ8.\u0003\u00023_\ti1*\u00194lCj[7\t\\5f]RDq\u0001\u000e\u0001A\u0002\u0013%Q'\u0001\tn_\u000e\\'l[\"mS\u0016tGo\u0018\u0013fcR\u0011\u0001E\u000e\u0005\bOM\n\t\u00111\u0001.\u0011\u0019A\u0004\u0001)Q\u0005[\u0005iQn\\2l5.\u001cE.[3oi\u0002BqA\u000f\u0001A\u0002\u0013%1(\u0001\u0011n_\u000e\\7i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eDW#\u0001\u001f\u0011\u0005Yi\u0014B\u0001 \u0003\u0005q\u0019uN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"Dq\u0001\u0011\u0001A\u0002\u0013%\u0011)\u0001\u0013n_\u000e\\7i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eDw\fJ3r)\t\u0001#\tC\u0004(\u007f\u0005\u0005\t\u0019\u0001\u001f\t\r\u0011\u0003\u0001\u0015)\u0003=\u0003\u0005jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195!\u0011\u001d1\u0005\u00011A\u0005\n\u001d\u000b\u0001$\\8dWR{\u0007/[2EK2,G/[8o\u001b\u0006t\u0017mZ3s+\u0005A\u0005C\u0001\fJ\u0013\tQ%A\u0001\u000bU_BL7\rR3mKRLwN\\'b]\u0006<WM\u001d\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003N\u0003qiwnY6U_BL7\rR3mKRLwN\\'b]\u0006<WM]0%KF$\"\u0001\t(\t\u000f\u001dZ\u0015\u0011!a\u0001\u0011\"1\u0001\u000b\u0001Q!\n!\u000b\u0011$\\8dWR{\u0007/[2EK2,G/[8o\u001b\u0006t\u0017mZ3sA!9!\u000b\u0001a\u0001\n\u0013\u0019\u0016A\u00049beRLG/[8o'R\fG/Z\u000b\u0002)B!QK\u0017/f\u001b\u00051&BA,Y\u0003\u001diW\u000f^1cY\u0016T!!\u0017\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\\-\n\u0019Q*\u00199\u0011\u0005u\u001bW\"\u00010\u000b\u0005}\u0003\u0017AB2p[6|gN\u0003\u0002\u0006C*\u0011!MD\u0001\u0007CB\f7\r[3\n\u0005\u0011t&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003-\u0019L!a\u001a\u0002\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK\"9\u0011\u000e\u0001a\u0001\n\u0013Q\u0017A\u00059beRLG/[8o'R\fG/Z0%KF$\"\u0001I6\t\u000f\u001dB\u0017\u0011!a\u0001)\"1Q\u000e\u0001Q!\nQ\u000bq\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\t\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0003U\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016,\u0012!\u001d\t\u0003-IL!a\u001d\u0002\u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK\"9Q\u000f\u0001a\u0001\n\u00131\u0018!\u00079beRLG/[8o'R\fG/Z'bG\"Lg.Z0%KF$\"\u0001I<\t\u000f\u001d\"\u0018\u0011!a\u0001c\"1\u0011\u0010\u0001Q!\nE\fa\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\r\t\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0003!\u0011'o\\6fe&#W#A?\u0011\u0005\u0005r\u0018BA@#\u0005\rIe\u000e\u001e\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003~\u0003%\u0011'o\\6fe&#\u0007\u0005C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n\u000511m\u001c8gS\u001e,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u0005\u0003\u0019\u0019XM\u001d<fe&!\u0011QCA\b\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0017\tqaY8oM&<\u0007\u0005\u0003\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003}\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007bBA\u0011\u0001\u0001\u0006I!`\u0001\u0011G>tGO]8mY\u0016\u0014X\t]8dQ\u0002B\u0011\"!\n\u0001\u0005\u0004%I!a\n\u0002\u0013A\f'\u000f^5uS>tW#\u0001/\t\u000f\u0005-\u0002\u0001)A\u00059\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u0013\u0005=\u0002A1A\u0005\n\u0005E\u0012A\u00039beRLG/[8ogV\u0011\u00111\u0007\t\u0006\u0003k\t9\u0004X\u0007\u00021&\u0019\u0011\u0011\b-\u0003\u0007M+\u0017\u000f\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u001a\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D\u0005)1/\u001a;VaR\t\u0001\u0005\u000b\u0003\u0002@\u0005\u001d\u0003\u0003BA%\u0003\u001bj!!a\u0013\u000b\u0005-q\u0011\u0002BA(\u0003\u0017\u0012aAQ3g_J,\u0007bBA*\u0001\u0011\u0005\u00111I\u00011i\u0016\u001cHOT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGk\u001c(foB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\t\u0005E\u0013q\u000b\t\u0005\u0003\u0013\nI&\u0003\u0003\u0002\\\u0005-#\u0001\u0002+fgRDq!a\u0018\u0001\t\u0003\t\u0019%\u0001\u001euKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\"\u0011QLA,\u0011\u001d\t)\u0007\u0001C\u0001\u0003\u0007\n1\b^3ti&sg/\u00197jI:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8o)>|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\u0011\t\u0019'a\u0016\t\u000f\u0005-\u0004\u0001\"\u0001\u0002D\u0005YC/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0002j\u0005]\u0003bBA9\u0001\u0011\u0005\u00111I\u0001Li\u0016\u001cHOT3x!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]j[W\u000b^5mg\u0016C8-\u001a9uS>tgI]8n\u0007J,\u0017\r^3Ti\u0006$Xm\u001d\u0015\u0005\u0003_\n9\u0006C\u0004\u0002x\u0001!\t!a\u0011\u0002\tR,7\u000f\u001e(foB\u000b'\u000f^5uS>tGk\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:,%O]8s\u0007>$WM\u0012:p[\u000e\u0013X-\u0019;f'R\fG/Z:)\t\u0005U\u0014q\u000b\u0005\b\u0003{\u0002A\u0011AA\"\u00031\"Xm\u001d;OK^\u0004\u0016M\u001d;ji&|g\u000eV8PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0002|\u0005]\u0003bBAB\u0001\u0011\u0005\u00111I\u00018i\u0016\u001cH/\u00138wC2LGMT3x!\u0006\u0014H/\u001b;j_:$vNT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\t\u0005\u0005\u0015q\u000b\u0005\b\u0003\u0013\u0003A\u0011AA\"\u0003\u0015\"Xm\u001d;P]2Lg.\u001a)beRLG/[8o)>|e\u000e\\5oKR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0002\b\u0006]\u0003bBAH\u0001\u0011\u0005\u00111I\u0001;i\u0016\u001cHo\u00148mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3Ue\u0006t7/\u001b;j_:4uN]\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:DC!!$\u0002X!9\u0011Q\u0013\u0001\u0005\u0002\u0005\r\u0013A\n;fgR|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\\(gM2Lg.\u001a+sC:\u001c\u0018\u000e^5p]\"\"\u00111SA,\u0011\u001d\tY\n\u0001C\u0001\u0003\u0007\n!\b^3ti&sg/\u00197jI>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\t\u0005e\u0015q\u000b\u0005\b\u0003C\u0003A\u0011AA\"\u0003I\"Xm\u001d;J]Z\fG.\u001b3P]2Lg.\u001a)beRLG/[8o)>tUm\u001e)beRLG/[8o)J\fgn]5uS>t\u0007\u0006BAP\u0003/Bq!a*\u0001\t\u0003\t\u0019%A\u0018uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0002&\u0006]\u0003bBAW\u0001\u0011\u0005\u00111I\u0001Oi\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c.l+RLGn]#yG\u0016\u0004H/[8o\rJ|Wn\u0015;bi\u0016dun\\6va\"\"\u00111VA,\u0011\u001d\t\u0019\f\u0001C\u0001\u0003\u0007\nq\t^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:,%O]8s\u0007>$WM\u0012:p[N#\u0018\r^3M_>\\W\u000f\u001d\u0015\u0005\u0003c\u000b9\u0006C\u0004\u0002:\u0002!\t!a\u0011\u0002iQ,7\u000f^(gM2Lg.\u001a)beRLG/[8o)>tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u00028\u0006]\u0003bBA`\u0001\u0011\u0005\u00111I\u00014i\u0016\u001cH/\u00138wC2LGm\u00144gY&tW\rU1si&$\u0018n\u001c8U_:+w\u000fU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:DC!!0\u0002X!9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0017!\n9sKB\f'/Z'pG.$v.\u00127fGRdU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\r\u0001\u0013\u0011\u001a\u0005\t\u0003_\t\u0019\r1\u0001\u0002LB)\u0011QZAo9:!\u0011qZAm\u001d\u0011\t\t.a6\u000e\u0005\u0005M'bAAk\r\u00051AH]8pizJ\u0011aI\u0005\u0004\u00037\u0014\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003s\tyNC\u0002\u0002\\\nBq!a9\u0001\t\u0003\t\u0019%\u0001\u0012uKN$X\u000b\u001d3bi&twm\u00144gY&tW\rU1si&$\u0018n\u001c8t\u0007>,h\u000e\u001e\u0015\u0005\u0003C\f9\u0006C\u0004\u0002j\u0002!\t!a\u0011\u0002eQ,7\u000f\u001e(p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:\u001c8\t[1oO\u00164uN\u001d+pa&\u001c7OQ3j]\u001e$U\r\\3uK\u0012DC!a:\u0002X!9\u0011q\u001e\u0001\u0005\u0002\u0005\r\u0013!\u000e;fgR,\u0006\u000fZ1uS:<wJ\u001a4mS:,\u0007+\u0019:uSRLwN\\:D_VtG\u000fR;sS:<Gk\u001c9jG\u0012+G.\u001a;j_:DC!!<\u0002X\u0001")
public class PartitionStateMachineTest
extends JUnitSuite {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private TopicDeletionManager mockTopicDeletionManager = null;
    private Map<TopicPartition, PartitionState> partitionState = null;
    private PartitionStateMachine partitionStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}));

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private TopicDeletionManager mockTopicDeletionManager() {
        return this.mockTopicDeletionManager;
    }

    private void mockTopicDeletionManager_$eq(TopicDeletionManager x$1) {
        this.mockTopicDeletionManager = x$1;
    }

    private Map<TopicPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    private void partitionState_$eq(Map<TopicPartition, PartitionState> x$1) {
        this.partitionState = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.mockTopicDeletionManager_$eq((TopicDeletionManager)EasyMock.createMock(TopicDeletionManager.class));
        this.partitionState_$eq((Map<TopicPartition, PartitionState>)Map$.MODULE$.empty());
        this.partitionStateMachine_$eq(new PartitionStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.partitionState(), this.mockControllerBrokerRequestBatch()));
        this.partitionStateMachine().setTopicDeletionManager(this.mockTopicDeletionManager());
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        PartitionStateMachine qual$1 = this.partitionStateMachine();
        Seq<TopicPartition> x$4 = this.partitions();
        NewPartition$ x$5 = NewPartition$.MODULE$;
        Option x$6 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$4, (PartitionState)x$5, x$6);
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        PartitionStateMachine qual$2 = this.partitionStateMachine();
        Seq<TopicPartition> x$7 = this.partitions();
        OfflinePartition$ x$8 = OfflinePartition$.MODULE$;
        Option x$9 = qual$2.handleStateChanges$default$3();
        qual$2.handleStateChanges(x$7, (PartitionState)x$8, x$9);
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6())})));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), true);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZkUtilsExceptionFromCreateStates() {
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andThrow((Throwable)new ZooKeeperClientException("test"));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6())})));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        PartitionStateMachine qual$3 = this.partitionStateMachine();
        Seq<TopicPartition> x$10 = this.partitions();
        OfflinePartition$ x$11 = OfflinePartition$.MODULE$;
        Option x$12 = qual$3.handleStateChanges$default$3();
        qual$3.handleStateChanges(x$10, (PartitionState)x$11, x$12);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)NewPartition$.MODULE$);
        PartitionStateMachine qual$4 = this.partitionStateMachine();
        Seq<TopicPartition> x$13 = this.partitions();
        NonExistentPartition$ x$14 = NonExistentPartition$.MODULE$;
        Option x$15 = qual$4.handleStateChanges$default$3();
        qual$4.handleStateChanges(x$13, (PartitionState)x$14, x$15);
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L), GetDataResponse$.MODULE$.apply$default$7())})));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.brokerId() + 1;
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(otherBrokerId, "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        this.controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.brokerId()));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L), GetDataResponse$.MODULE$.apply$default$7())})));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        PartitionStateMachine qual$5 = this.partitionStateMachine();
        Seq<TopicPartition> x$16 = this.partitions();
        OfflinePartition$ x$17 = OfflinePartition$.MODULE$;
        Option x$18 = qual$5.handleStateChanges$default$3();
        qual$5.handleStateChanges(x$16, (PartitionState)x$17, x$18);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        PartitionStateMachine qual$6 = this.partitionStateMachine();
        Seq<TopicPartition> x$19 = this.partitions();
        NonExistentPartition$ x$20 = NonExistentPartition$.MODULE$;
        Option x$21 = qual$6.handleStateChanges$default$3();
        qual$6.handleStateChanges(x$19, (PartitionState)x$20, x$21);
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OnlinePartition$.MODULE$);
        PartitionStateMachine qual$7 = this.partitionStateMachine();
        Seq<TopicPartition> x$22 = this.partitions();
        NewPartition$ x$23 = NewPartition$.MODULE$;
        Option x$24 = qual$7.handleStateChanges$default$3();
        qual$7.handleStateChanges(x$22, (PartitionState)x$23, x$24);
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L), GetDataResponse$.MODULE$.apply$default$7())})));
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs((Seq)Seq$.MODULE$.empty(), this.config().originals())).andReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)LogConfig$.MODULE$.apply())})), (Object)Predef$.MODULE$.Map().empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZkUtilsExceptionFromStateLookup() {
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andThrow((Throwable)new ZooKeeperClientException(""));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L), GetDataResponse$.MODULE$.apply$default$7())})));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        PartitionStateMachine qual$8 = this.partitionStateMachine();
        Seq<TopicPartition> x$25 = this.partitions();
        NonExistentPartition$ x$26 = NonExistentPartition$.MODULE$;
        Option x$27 = qual$8.handleStateChanges$default$3();
        qual$8.handleStateChanges(x$25, (PartitionState)x$26, x$27);
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.partitionState().put((Object)this.partition(), (Object)OfflinePartition$.MODULE$);
        PartitionStateMachine qual$9 = this.partitionStateMachine();
        Seq<TopicPartition> x$28 = this.partitions();
        NewPartition$ x$29 = NewPartition$.MODULE$;
        Option x$30 = qual$9.handleStateChanges$default$3();
        qual$9.handleStateChanges(x$28, (PartitionState)x$29, x$30);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState().apply((Object)this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(partitions, leaderAndIsr);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        this.controllerContext().liveBrokers_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBroker$default$4())})));
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$1 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(BoxesRunTime.unboxToInt((Object)x$1)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.mockTopicDeletionManager().isTopicWithDeletionStarted(topic))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expectLastCall().anyTimes();
        this.prepareMockToElectLeaderForPartitions((Seq<TopicPartition>)partitions);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockTopicDeletionManager()});
        PartitionStateMachine qual$10 = this.partitionStateMachine();
        Seq x$31 = partitions;
        NewPartition$ x$32 = NewPartition$.MODULE$;
        Option x$33 = qual$10.handleStateChanges$default$3();
        qual$10.handleStateChanges(x$31, (PartitionState)x$32, x$33);
        PartitionStateMachine qual$11 = this.partitionStateMachine();
        Seq x$34 = partitions;
        OfflinePartition$ x$35 = OfflinePartition$.MODULE$;
        Option x$36 = qual$11.handleStateChanges$default$3();
        qual$11.handleStateChanges(x$34, (PartitionState)x$35, x$36);
        Assert.assertEquals((String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString(), (long)partitions.size(), (long)this.partitionStateMachine().offlinePartitionCount());
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.partitionStateMachine().offlinePartitionCount());
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$2 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.mockTopicDeletionManager().isTopicWithDeletionStarted(topic))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockTopicDeletionManager()});
        PartitionStateMachine qual$12 = this.partitionStateMachine();
        Seq x$37 = partitions;
        NewPartition$ x$38 = NewPartition$.MODULE$;
        Option x$39 = qual$12.handleStateChanges$default$3();
        qual$12.handleStateChanges(x$37, (PartitionState)x$38, x$39);
        PartitionStateMachine qual$13 = this.partitionStateMachine();
        Seq x$40 = partitions;
        OfflinePartition$ x$41 = OfflinePartition$.MODULE$;
        Option x$42 = qual$13.handleStateChanges$default$3();
        qual$13.handleStateChanges(x$40, (PartitionState)x$41, x$42);
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.partitionStateMachine().offlinePartitionCount());
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$3 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
        KafkaConfig customConfig = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaStateMachine replicaStateMachine = PartitionStateMachineTest.createMockReplicaStateMachine$1(topic);
        this.partitionStateMachine_$eq(new PartitionStateMachine(customConfig, new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.partitionState(), this.mockControllerBrokerRequestBatch()));
        KafkaController mockController = this.createMockController$1(partitions, customConfig, replicaStateMachine);
        ControllerEventManager mockEventManager = (ControllerEventManager)EasyMock.createMock(ControllerEventManager.class);
        EasyMock.replay((Object[])new Object[]{mockController, replicaStateMachine, mockEventManager});
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(mockController, mockEventManager, this.mockZkClient());
        this.partitionStateMachine().setTopicDeletionManager(topicDeletionManager);
        PartitionStateMachine qual$14 = this.partitionStateMachine();
        Seq x$43 = partitions;
        NewPartition$ x$44 = NewPartition$.MODULE$;
        Option x$45 = qual$14.handleStateChanges$default$3();
        qual$14.handleStateChanges(x$43, (PartitionState)x$44, x$45);
        PartitionStateMachine qual$15 = this.partitionStateMachine();
        Seq x$46 = partitions;
        OfflinePartition$ x$47 = OfflinePartition$.MODULE$;
        Option x$48 = qual$15.handleStateChanges$default$3();
        qual$15.handleStateChanges(x$46, (PartitionState)x$47, x$48);
        Assert.assertEquals((String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString(), (long)partitions.size(), (long)mockController.partitionStateMachine().offlinePartitionCount());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.partitionStateMachine().offlinePartitionCount());
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        Seq getDataResponses = (Seq)partitions$1.map((Function1 & Serializable & scala.Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L), GetDataResponse$.MODULE$.apply$default$7()), Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(partitions$1)).andReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        Seq topicsForPartitionsWithNoLiveInSyncReplicas = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs(topicsForPartitionsWithNoLiveInSyncReplicas, this.config().originals())).andReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Map().empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((TraversableOnce)partitions$1.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr(updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult(updatedLeaderAndIsr, (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(int x$1) {
        return new TopicPartition("test", x$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionReplicaAssignment(partition, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(int x$2) {
        return new TopicPartition("test", x$2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$3) {
        return new TopicPartition("test", x$3);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionReplicaAssignment(partition, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})));
    }

    /*
     * WARNING - void declaration
     */
    private static final ReplicaStateMachine createMockReplicaStateMachine$1(String topic$1) {
        void var1_1;
        ReplicaStateMachine replicaStateMachine = (ReplicaStateMachine)EasyMock.createMock(ReplicaStateMachine.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaStateMachine.areAllReplicasForTopicDeleted(topic$1))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaStateMachine.isAtLeastOneReplicaInDeletionStartedState(topic$1))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaStateMachine.isAnyReplicaInState(topic$1, (ReplicaState)ReplicaDeletionIneligible$.MODULE$))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)replicaStateMachine.replicasInState(topic$1, (ReplicaState)ReplicaDeletionIneligible$.MODULE$)).andReturn((Object)Predef$.MODULE$.Set().empty()).anyTimes();
        EasyMock.expect((Object)replicaStateMachine.replicasInState(topic$1, (ReplicaState)ReplicaDeletionStarted$.MODULE$)).andReturn((Object)Predef$.MODULE$.Set().empty()).anyTimes();
        EasyMock.expect((Object)replicaStateMachine.replicasInState(topic$1, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$)).andReturn((Object)Predef$.MODULE$.Set().empty()).anyTimes();
        replicaStateMachine.handleStateChanges((Seq)EasyMock.anyObject(), (ReplicaState)EasyMock.anyObject(), (Callbacks)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expectLastCall().anyTimes();
        return var1_1;
    }

    private final KafkaController createMockController$1(Seq partitions$2, KafkaConfig customConfig$1, ReplicaStateMachine replicaStateMachine$1) {
        KafkaController mockController = (KafkaController)EasyMock.createMock(KafkaController.class);
        EasyMock.expect((Object)mockController.controllerContext()).andReturn((Object)this.controllerContext()).anyTimes();
        EasyMock.expect((Object)mockController.config()).andReturn((Object)customConfig$1).anyTimes();
        EasyMock.expect((Object)mockController.partitionStateMachine()).andReturn((Object)this.partitionStateMachine()).anyTimes();
        EasyMock.expect((Object)mockController.replicaStateMachine()).andReturn((Object)replicaStateMachine$1).anyTimes();
        mockController.sendUpdateMetadataRequest((Seq)Seq$.MODULE$.empty(), (Set)partitions$2.toSet());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expectLastCall().anyTimes();
        return mockController;
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

