/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u0001%\u0011\u0011c\u0012:pkBlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0003he>,\bO\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\n\u000e\u00031Q!!\u0004\b\u0002\u000b),h.\u001b;\u000b\u0005=\u0001\u0012!C:dC2\fG/Z:u\u0015\u0005\t\u0012aA8sO&\u00111\u0003\u0004\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\nm\tA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\u0012\u0001\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019\u0019FO]5oO\"1Q\u0005\u0001Q\u0001\nq\tQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003bB\u0014\u0001\u0005\u0004%IaG\u0001\bOJ|W\u000f]%e\u0011\u0019I\u0003\u0001)A\u00059\u0005AqM]8va&#\u0007\u0005C\u0004,\u0001\t\u0007I\u0011B\u000e\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Da!\f\u0001!\u0002\u0013a\u0012!C2mS\u0016tG/\u00133!\u0011\u001dy\u0003A1A\u0005\nm\t!b\u00197jK:$\bj\\:u\u0011\u0019\t\u0004\u0001)A\u00059\u0005Y1\r\\5f]RDun\u001d;!\u0011\u001d\u0019\u0004A1A\u0005\nQ\n!C]3cC2\fgnY3US6,w.\u001e;NgV\tQ\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0002J]RDa\u0001\u0010\u0001!\u0002\u0013)\u0014a\u0005:fE\u0006d\u0017M\\2f)&lWm\\;u\u001bN\u0004\u0003b\u0002 \u0001\u0005\u0004%I\u0001N\u0001\u0011g\u0016\u001c8/[8o)&lWm\\;u\u001bNDa\u0001\u0011\u0001!\u0002\u0013)\u0014!E:fgNLwN\u001c+j[\u0016|W\u000f^'tA!91\u0001\u0001a\u0001\n\u0013\u0011U#A\"\u0011\u0005a!\u0015BA#\u0003\u000559%o\\;q\u001b\u0016$\u0018\rZ1uC\"9q\t\u0001a\u0001\n\u0013A\u0015!C4s_V\u0004x\fJ3r)\tIE\n\u0005\u00027\u0015&\u00111j\u000e\u0002\u0005+:LG\u000fC\u0004N\r\u0006\u0005\t\u0019A\"\u0002\u0007a$\u0013\u0007\u0003\u0004P\u0001\u0001\u0006KaQ\u0001\u0007OJ|W\u000f\u001d\u0011\t\u000bE\u0003A\u0011\u0001*\u0002\u000bM,G/\u00169\u0015\u0003%C#\u0001\u0015+\u0011\u0005U;V\"\u0001,\u000b\u00055\u0001\u0012B\u0001-W\u0005\u0019\u0011UMZ8sK\")!\f\u0001C\u0001%\u0006QB/Z:u\u0007\u0006t'+\u001a2bY\u0006t7-Z,iK:\u001cF/\u00192mK\"\u0012\u0011\f\u0018\t\u0003+vK!A\u0018,\u0003\tQ+7\u000f\u001e\u0005\u0006A\u0002!\tAU\u0001(i\u0016\u001cHoQ1o%\u0016\u0014\u0017\r\\1oG\u0016<\u0006.\u001a8D_6\u0004H.\u001a;j]\u001e\u0014VMY1mC:\u001cW\r\u000b\u0002`9\")1\r\u0001C\u0001%\u0006IC/Z:u\u0007\u0006tgn\u001c;SK\n\fG.\u00198dK^CWM\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D#A\u0019/\t\u000b\u0019\u0004A\u0011\u0001*\u00027Q,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016tG)Z1eQ\t)G\fC\u0003j\u0001\u0011\u0005!+\u0001\u0015uKN$8\u000b^1cY\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000e\u000b\u0002i9\")A\u000e\u0001C\u0001%\u0006QB/Z:u'R\f'\r\\3U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u00121\u000e\u0018\u0005\u0006_\u0002!\tAU\u00014i\u0016\u001cH/Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f)>\u0004&/\u001a9be&twMU3cC2\fgnY3Ue\u0006t7/\u001b;j_:D#A\u001c/\t\u000bI\u0004A\u0011\u0001*\u0002MQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v\u000eR3bIR\u0013\u0018M\\:ji&|g\u000e\u000b\u0002r9\")Q\u000f\u0001C\u0001%\u00069C/Z:u!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\rV8F[B$\u0018\u0010\u0016:b]NLG/[8oQ\t!H\fC\u0003y\u0001\u0011\u0005!+A\ruKN$X)\u001c9usR{G)Z1e)J\fgn]5uS>t\u0007FA<]\u0011\u0015Y\b\u0001\"\u0001S\u0003\u001d\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,GK]1og&$\u0018n\u001c8)\u0005id\u0006\"\u0002@\u0001\t\u0003\u0011\u0016A\t;fgR,U\u000e\u001d;z)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000e\u000b\u0004~9\u0006\u0005\u00111A\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011Q\u0001\t\u0004;\u0005\u001d\u0011bAA\u0005=\t)\u0012\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>t\u0007BBA\u0007\u0001\u0011\u0005!+A\u0012uKN$8\u000b^1cY\u0016$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007\u0005-A\f\u0003\u0004\u0002\u0014\u0001!\tAU\u0001.i\u0016\u001cH/R7qif$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fBA\t9\u0006\u0005\u00111\u0001\u0005\u0007\u00033\u0001A\u0011\u0001*\u0002wQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004\u0002\u0018q\u000b\t!a\u0001\t\r\u0005}\u0001\u0001\"\u0001S\u0003=\"Xm\u001d;Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,Gk\\*uC\ndW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\u001d\ti\u0002XA\u0001\u0003\u0007Aa!!\n\u0001\t\u0003\u0011\u0016!\u000f;fgR\fu/Y5uS:<'+\u001a2bY\u0006t7-\u001a+p\u0003^\f\u0017\u000e^5oOJ+'-\u00197b]\u000e,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u000f\u0005\rB,!\u0001\u0002\u0004!1\u00111\u0006\u0001\u0005\u0002I\u000bq\u0004^3ti\u0012+\u0017\r\u001a+p\t\u0016\fG-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8o\u0011\u0019\ty\u0003\u0001C\u0001%\u0006\tC/Z:u\t\u0016\fG\rV8Ti\u0006\u0014G.Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\":\u0011Q\u0006/\u0002\u0002\u0005\r\u0001BBA\u001b\u0001\u0011\u0005!+A\u0017uKN$H)Z1e)>\u0004&/\u001a9be&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!a\r]\u0003\u0003\t\u0019\u0001\u0003\u0004\u0002<\u0001!\tAU\u0001-i\u0016\u001cH\u000fR3bIR{\u0017i^1ji&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!!\u000f]\u0003\u0003\t\u0019\u0001\u0003\u0004\u0002B\u0001!\tAU\u0001\u0013i\u0016\u001cHoU3mK\u000e$\bK]8u_\u000e|G\u000eK\u0002\u0002@qCa!a\u0012\u0001\t\u0003\u0011\u0016a\t;fgR\u001cV\r\\3diB\u0013x\u000e^8d_2\u0014\u0016-[:fg&3gj\\'f[\n,'o\u001d\u0015\b\u0003\u000bb\u0016\u0011AA\u0002\u0011\u0019\ti\u0005\u0001C\u0001%\u0006YC/Z:u'\u0016dWm\u0019;Qe>$xnY8m\u0007\"|wn]3t\u0007>l\u0007/\u0019;jE2,\u0007K]8u_\u000e|G\u000eK\u0002\u0002LqCa!a\u0015\u0001\t\u0003\u0011\u0016!\u0006;fgR\u001cV\u000f\u001d9peR\u001c\bK]8u_\u000e|Gn\u001d\u0015\u0004\u0003#b\u0006BBA-\u0001\u0011\u0005!+\u0001\fuKN$\u0018J\\5u\u001d\u0016DHoR3oKJ\fG/[8oQ\r\t9\u0006\u0018\u0005\u0007\u0003?\u0002A\u0011\u0001*\u0002AQ,7\u000f^%oSRtU\r\u001f;HK:,'/\u0019;j_:,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0004\u0003;b\u0006BBA3\u0001\u0011\u0005!+\u0001\tuKN$xJ\u001a4tKR\u001cu.\\7ji\"\u001a\u00111\r/\t\r\u0005-\u0004\u0001\"\u0001S\u0003]!Xm\u001d;PM\u001a\u001cX\r^\"p[6LGOR1jYV\u0014X\rK\u0002\u0002jqCa!!\u001d\u0001\t\u0003\u0011\u0016!\u000b;fgR|eMZ:fi\u000e{W.\\5u\r\u0006LG.\u001e:f/&$\b.\u00118pi\",'\u000fU3oI&tw\rK\u0002\u0002pqCa!a\u001e\u0001\t\u0003\u0011\u0016A\t;fgR|eMZ:fi\u000e{W.\\5u/&$\b.\u00118pi\",'\u000fU3oI&tw\rK\u0002\u0002vqCa!! \u0001\t\u0003\u0011\u0016A\u000b;fgR\u001cuN\\:v[\u0016\u0014()Z1ugR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004\u0003wb\u0006BBAB\u0001\u0011\u0005!+\u0001\u0015uKN$HK]1og\u0006\u001cG/[8o\u0005\u0016\fGo]\"p]N,X.\u001a:PM\u001a\u001cX\r^\"p[6LG\u000fK\u0002\u0002\u0002rCa!!#\u0001\t\u0003\u0011\u0016!\u000e;fgR$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{W.\\5u\u0013N\f%m\u001c:uK\u0012\fe\u000eZ\"p]N,X.\u001a:D_6l\u0017\u000e^,j]ND3!a\"]\u0011\u0019\ty\t\u0001C\u0001%\u0006iC/Z:u\r\u0006LG.\u001a3Uq:|eMZ:fi\u000e{W.\\5u\u0019\u0016\fg/Z:O_B+g\u000eZ5oON#\u0018\r^3)\u0007\u00055E\fC\u0004\u0002\u0016\u0002!I!a&\u0002\u0017\u0005\u001c8/\u001a:u'R\fG/\u001a\u000b\u0006\u0013\u0006e\u00151\u0014\u0005\u0007\u0007\u0005M\u0005\u0019A\"\t\u0011\u0005u\u00151\u0013a\u0001\u0003?\u000b1\u0002^1sO\u0016$8\u000b^1uKB\u0019\u0001$!)\n\u0007\u0005\r&A\u0001\u0006He>,\bo\u0015;bi\u0016Dq!a*\u0001\t\u0013\tI+A\tpM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006$B!a+\u00028B!\u0011QVAZ\u001b\t\tyKC\u0002\u00022\u001a\taaY8n[>t\u0017\u0002BA[\u0003_\u0013\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0011!\tI,!*A\u0002\u0005m\u0016AB8gMN,G\u000fE\u00027\u0003{K1!a08\u0005\u0011auN\\4")
public class GroupMetadataTest
extends JUnitSuite {
    private final String protocolType;
    private final String groupId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId() {
        return this.groupId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        try {
            this.group().transitionTo((GroupState)Stable$.MODULE$);
            throw this.fail("should have failed due to illegal transition", new Position("GroupMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$2 = member;
        Function1 x$3 = qual$1.add$default$2();
        qual$1.add(x$2, x$3);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$4 = otherMember;
        Function1 x$5 = qual$2.add$default$2();
        qual$2.add(x$4, x$5);
        Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$3 = this.group();
        MemberMetadata x$6 = lastMember;
        Function1 x$7 = qual$3.add$default$2();
        qual$3.add(x$6, x$7);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        throw this.fail(new Position("GroupMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$4 = this.group();
        MemberMetadata x$8 = member;
        Function1 x$9 = qual$4.add$default$2();
        qual$4.add(x$8, x$9);
        GroupMetadata qual$5 = this.group();
        MemberMetadata x$10 = otherMember;
        Function1 x$11 = qual$5.add$default$2();
        qual$5.add(x$10, x$11);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$6 = this.group();
        MemberMetadata x$12 = member;
        Function1 x$13 = qual$6.add$default$2();
        qual$6.add(x$12, x$13);
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$7 = this.group();
        MemberMetadata x$14 = otherMember;
        Function1 x$15 = qual$7.add$default$2();
        qual$7.add(x$14, x$15);
        Assert.assertTrue((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testInitNextGeneration() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(member, (Function1 & Serializable & scala.Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().protocolOrNull());
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        Set states = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}));
        Set otherStates = (Set)states.$minus((Object)targetState);
        otherStates.foreach((Function1 & Serializable & scala.Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assert.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

