/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.util.Arrays;
import kafka.coordinator.group.MemberMetadata;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u0013\t\u0011R*Z7cKJlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0003he>,\bO\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\n\u000e\u00031Q!!\u0004\b\u0002\u000b),h.\u001b;\u000b\u0005=\u0001\u0012!C:dC2\fG/Z:u\u0015\u0005\t\u0012aA8sO&\u00111\u0003\u0004\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\u0002m\tqa\u001a:pkBLE-F\u0001\u001d!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003mC:<'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011aa\u0015;sS:<\u0007BB\u0013\u0001A\u0003%A$\u0001\u0005he>,\b/\u00133!\u0011\u001d9\u0003A1A\u0005\u0002m\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003bB\u0016\u0001\u0005\u0004%\taG\u0001\u000bG2LWM\u001c;I_N$\bBB\u0017\u0001A\u0003%A$A\u0006dY&,g\u000e\u001e%pgR\u0004\u0003bB\u0018\u0001\u0005\u0004%\taG\u0001\t[\u0016l'-\u001a:JI\"1\u0011\u0007\u0001Q\u0001\nq\t\u0011\"\\3nE\u0016\u0014\u0018\n\u001a\u0011\t\u000fM\u0002!\u0019!C\u00017\u0005a\u0001O]8u_\u000e|G\u000eV=qK\"1Q\u0007\u0001Q\u0001\nq\tQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003bB\u001c\u0001\u0005\u0004%\t\u0001O\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5/F\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\rIe\u000e\u001e\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u001d\u0002'I,'-\u00197b]\u000e,G+[7f_V$Xj\u001d\u0011\t\u000f\t\u0003!\u0019!C\u0001q\u0005\u00012/Z:tS>tG+[7f_V$Xj\u001d\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001d\u0002#M,7o]5p]RKW.Z8vi6\u001b\b\u0005C\u0003G\u0001\u0011\u0005q)A\u000fuKN$X*\u0019;dQ\u0016\u001c8+\u001e9q_J$X\r\u001a)s_R|7m\u001c7t)\u0005A\u0005C\u0001\u001eJ\u0013\tQ5H\u0001\u0003V]&$\bFA#M!\tiu*D\u0001O\u0015\ti\u0001#\u0003\u0002Q\u001d\n!A+Z:u\u0011\u0015\u0011\u0006\u0001\"\u0001H\u0003q!Xm\u001d;W_R,gi\u001c:Qe\u00164WM\u001d:fIB\u0013x\u000e^8d_2D#!\u0015'\t\u000bU\u0003A\u0011A$\u0002\u0019Q,7\u000f^'fi\u0006$\u0017\r^1)\u0005Qc\u0005\"\u0002-\u0001\t\u00039\u0015a\n;fgRlU\r^1eCR\f'+Y5tKN|e.\u00168tkB\u0004xN\u001d;fIB\u0013x\u000e^8d_2DCa\u0016'[7\u0006AQ\r\u001f9fGR,GmI\u0001]!\tiVM\u0004\u0002_G:\u0011qLY\u0007\u0002A*\u0011\u0011\rC\u0001\u0007yI|w\u000e\u001e \n\u0003qJ!\u0001Z\u001e\u0002\u000fA\f7m[1hK&\u0011am\u001a\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'B\u00013<\u0011\u0015I\u0007\u0001\"\u0001H\u0003\u0011\"Xm\u001d;W_R,'+Y5tKN|eNT8TkB\u0004xN\u001d;fIB\u0013x\u000e^8d_2\u001c\b\u0006\u00025M5n\u0003")
public class MemberMetadataTest
extends JUnitSuite {
    private final String groupId;
    private final String clientId;
    private final String clientHost;
    private final String memberId;
    private final String protocolType;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public String memberId() {
        return this.memberId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    @Test
    public void testMatchesSupportedProtocols() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$);
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertTrue((boolean)member.matches((List)protocols));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        Assert.assertFalse((boolean)member.matches((List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$))));
    }

    @Test
    public void testVoteForPreferredProtocol() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertEquals((Object)"range", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))));
        Assert.assertEquals((Object)"roundrobin", (Object)member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah", "roundrobin"}))));
    }

    @Test
    public void testMetadata() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte()), member.metadata("range")));
        Assert.assertTrue((boolean)Arrays.equals((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte()), member.metadata("roundrobin")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMetadataRaisesOnUnsupportedProtocol() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        member.metadata("blah");
        throw this.fail(new Position("MemberMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVoteRaisesOnNoSupportedProtocols() {
        .colon.colon protocols = new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)protocols);
        member.vote((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blah"})));
        throw this.fail(new Position("MemberMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    public MemberMetadataTest() {
        this.groupId = "groupId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.memberId = "memberId";
        this.protocolType = "consumer";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

