/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.AbstractCoordinatorConcurrencyTest;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.log.Log;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r]f\u0001B\u0001\u0003\u0001%\u0011Q\u0005\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\"p]\u000e,(O]3oGf$Vm\u001d;\u000b\u0005\r!\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u0002\u0004\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000b!\rYABD\u0007\u0002\t%\u0011Q\u0002\u0002\u0002#\u0003\n\u001cHO]1di\u000e{wN\u001d3j]\u0006$xN]\"p]\u000e,(O]3oGf$Vm\u001d;\u0011\u0005=AcB\u0001\t\u001a\u001d\t\t\u0002D\u0004\u0002\u0013/9\u00111CF\u0007\u0002))\u0011Q\u0003C\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dI!!\u0002\u0004\n\u0005\r!q!\u0002\u000e\u0003\u0011\u0003Y\u0012!\n+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:D_:\u001cWO\u001d:f]\u000eLH+Z:u!\taR$D\u0001\u0003\r\u0015\t!\u0001#\u0001\u001f'\tir\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\u0005\u0006Mu!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m1A!K\u000f\u0001U\tYAK]1og\u0006\u001cG/[8o'\rAsd\u000b\t\u0003Y=r!!E\u0017\n\u00059\"\u0011AI!cgR\u0014\u0018m\u0019;D_>\u0014H-\u001b8bi>\u00148i\u001c8dkJ\u0014XM\\2z)\u0016\u001cH/\u0003\u00021c\t\t2i\\8sI&t\u0017\r^8s\u001b\u0016l'-\u001a:\u000b\u00059\"\u0001\u0002C\u001a)\u0005\u000b\u0007I\u0011\u0001\u001b\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0012!\u000e\t\u0003mir!a\u000e\u001d\u0011\u0005M\t\u0013BA\u001d\"\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\n\u0003\u0002\u0003 )\u0005\u0003\u0005\u000b\u0011B\u001b\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004\u0003\u0002\u0003!)\u0005\u0003\u0005\u000b\u0011B!\u0002\u0015A\u0014x\u000eZ;dKJLE\r\u0005\u0002!\u0005&\u00111)\t\u0002\u0005\u0019>tw\r\u0003\u0005FQ\t\u0005\t\u0015!\u0003G\u0003\u0011!\u0018.\\3\u0011\u0005\u001d\u000bV\"\u0001%\u000b\u0005%S\u0015!B;uS2\u001c(BA&M\u0003\u0019\u0019w.\\7p]*\u0011q!\u0014\u0006\u0003\u001d>\u000ba!\u00199bG\",'\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u0011\nAQj\\2l)&lW\rC\u0003'Q\u0011\u0005A\u000b\u0006\u0003V/bK\u0006C\u0001,)\u001b\u0005i\u0002\"B\u001aT\u0001\u0004)\u0004\"\u0002!T\u0001\u0004\t\u0005\"B#T\u0001\u00041\u0005bB.)\u0005\u0004%\t\u0001X\u0001\u0013ibtW*Z:tC\u001e,7*Z=CsR,7/F\u0001^!\r\u0001c\fY\u0005\u0003?\u0006\u0012Q!\u0011:sCf\u0004\"\u0001I1\n\u0005\t\f#\u0001\u0002\"zi\u0016Da\u0001\u001a\u0015!\u0002\u0013i\u0016a\u0005;y]6+7o]1hK.+\u0017PQ=uKN\u0004\u0003b\u00024)\u0001\u0004%\taZ\u0001\u0006K:$W\rZ\u000b\u0002QB\u0011\u0001%[\u0005\u0003U\u0006\u0012qAQ8pY\u0016\fg\u000eC\u0004mQ\u0001\u0007I\u0011A7\u0002\u0013\u0015tG-\u001a3`I\u0015\fHC\u00018r!\t\u0001s.\u0003\u0002qC\t!QK\\5u\u0011\u001d\u00118.!AA\u0002!\f1\u0001\u001f\u00132\u0011\u0019!\b\u0006)Q\u0005Q\u00061QM\u001c3fI\u0002B#a\u001d<\u0011\u0005\u0001:\u0018B\u0001=\"\u0005!1x\u000e\\1uS2,\u0007\"\u0002>)\t\u0003Z\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003UBQA\n\u0001\u0005\u0002u$\u0012A \t\u00039\u0001A\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\u0002\u001b9$&/\u00198tC\u000e$\u0018n\u001c8t+\t\t)\u0001E\u0002!\u0003\u000fI1!!\u0003\"\u0005\rIe\u000e\u001e\u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\u0006\u0005qa\u000e\u0016:b]N\f7\r^5p]N\u0004\u0003\"CA\t\u0001\t\u0007I\u0011BA\u0002\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0011BA\u0003\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\t\u0005\n\u00033\u0001!\u0019!C\u0005\u0003\u0007\tQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0002CA\u000f\u0001\u0001\u0006I!!\u0002\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA!I\u0011\u0011\u0005\u0001C\u0002\u0013%\u00111E\u0001\nibt7i\u001c8gS\u001e,\"!!\n\u0011\u0007q\t9#C\u0002\u0002*\t\u0011\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u0015\u0012A\u0003;y]\u000e{gNZ5hA!Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001a\u0003Y!(/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014XCAA\u001b!\ra\u0012qG\u0005\u0004\u0003s\u0011!A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\t\u0017\u0005u\u0002\u00011AA\u0002\u0013%\u0011qH\u0001\u001biJ\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe~#S-\u001d\u000b\u0004]\u0006\u0005\u0003\"\u0003:\u0002<\u0005\u0005\t\u0019AA\u001b\u0011-\t)\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u000e\u0002/Q\u0014\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\u0004\u0003bCA%\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017\nq\u0002\u001e=o'R\fG/Z'b]\u0006<WM]\u000b\u0003\u0003\u001b\u00022\u0001HA(\u0013\r\t\tF\u0001\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJD1\"!\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X\u0005\u0019B\u000f\u001f8Ti\u0006$X-T1oC\u001e,'o\u0018\u0013fcR\u0019a.!\u0017\t\u0013I\f\u0019&!AA\u0002\u00055\u0003bCA/\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001b\n\u0001\u0003\u001e=o'R\fG/Z'b]\u0006<WM\u001d\u0011\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111M\u0001\u0018ibtW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ,\"!!\u001a\u0011\u0007q\t9'C\u0002\u0002j\t\u0011q\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0011-\ti\u0007\u0001a\u0001\u0002\u0004%I!a\u001c\u00027QDh.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014x\fJ3r)\rq\u0017\u0011\u000f\u0005\ne\u0006-\u0014\u0011!a\u0001\u0003KB1\"!\u001e\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002f\u0005AB\u000f\u001f8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\t\u0013\u0005e\u0004A1A\u0005\n\u0005m\u0014!D1mY>\u0003XM]1uS>t7/\u0006\u0002\u0002~A1\u0011qPAC\u0003\u0013k!!!!\u000b\u0007\u0005\r\u0015%\u0001\u0006d_2dWm\u0019;j_:LA!a\"\u0002\u0002\n\u00191+Z91\t\u0005-\u0015q\u001c\t\u0007\u0003\u001b\u000by)!8\u000e\u0003\u00011q!!%\u0001\u0003\u0003\t\u0019J\u0001\u0007Uq:|\u0005/\u001a:bi&|g.\u0006\u0003\u0002\u0016\u0006\u001d6\u0003BAH\u0003/\u0003B!!$\u0002\u001a&\u0019\u00111\u0014\u0007\u0003\u0013=\u0003XM]1uS>t\u0007b\u0002\u0014\u0002\u0010\u0012\u0005\u0011q\u0014\u000b\u0003\u0003C\u0003b!!$\u0002\u0010\u0006\r\u0006\u0003BAS\u0003Oc\u0001\u0001\u0002\u0005\u0002*\u0006=%\u0019AAV\u0005\u0005\u0011\u0016\u0003BAW\u0003g\u00032\u0001IAX\u0013\r\t\t,\t\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u0013QW\u0005\u0004\u0003o\u000b#aA!os\"Q\u00111XAH\u0001\u0004%\t!!0\u0002\rI,7/\u001e7u+\t\ty\fE\u0003!\u0003\u0003\f\u0019+C\u0002\u0002D\u0006\u0012aa\u00149uS>t\u0007BCAd\u0003\u001f\u0003\r\u0011\"\u0001\u0002J\u0006Q!/Z:vYR|F%Z9\u0015\u00079\fY\rC\u0005s\u0003\u000b\f\t\u00111\u0001\u0002@\"I\u0011qZAHA\u0003&\u0011qX\u0001\be\u0016\u001cX\u000f\u001c;!Q\r\tiM\u001e\u0005\t\u0003+\fy\t\"\u0001\u0002X\u0006q!/Z:vYR\u001c\u0015\r\u001c7cC\u000e\\Gc\u00018\u0002Z\"A\u00111\\Aj\u0001\u0004\t\u0019+A\u0001s!\u0011\t)+a8\u0005\u0017\u0005\u0005\b!!A\u0001\u0002\u000b\u0005\u00111\u001d\u0002\u0003?F\nB!!:\u0002~J1\u0011q]Av\u0003o4a!!;\u0001\u0001\u0005\u0015(\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003BAw\u0003gl!!a<\u000b\u0007\u0005E(*\u0001\u0005qe>$xnY8m\u0013\u0011\t)0a<\u0003\r\u0015\u0013(o\u001c:t!\ra\u0012\u0011`\u0005\u0004\u0003w\u0014!\u0001F%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*fgVdGO\u0005\u0004\u0002\u0000\n\u0005!\u0011\u0003\u0004\u0007\u0003S\u0004\u0001!!@\u0011\t\t\r!QB\u0007\u0003\u0005\u000bQAAa\u0002\u0003\n\u0005!A.\u00198h\u0015\t\u0011Y!\u0001\u0003kCZ\f\u0017\u0002\u0002B\b\u0005\u000b\u0011aa\u00142kK\u000e$\b\u0003\u0002B\n\u00053i!A!\u0006\u000b\t\t]!\u0011B\u0001\u0003S>LAAa\u0007\u0003\u0016\ta1+\u001a:jC2L'0\u00192mK\"A!q\u0004\u0001!\u0002\u0013\ti(\u0001\bbY2|\u0005/\u001a:bi&|gn\u001d\u0011\t\u0013\t\r\u0002A1A\u0005\n\t\u0015\u0012aD1mYR\u0013\u0018M\\:bGRLwN\\:\u0016\u0005\t\u001d\u0002#\u0002B\u0015\u0005_qQB\u0001B\u0016\u0015\u0011\u0011i#!!\u0002\u000f5,H/\u00192mK&!!\u0011\u0007B\u0016\u0005\r\u0019V\r\u001e\u0005\t\u0005k\u0001\u0001\u0015!\u0003\u0003(\u0005\u0001\u0012\r\u001c7Ue\u0006t7/Y2uS>t7\u000f\t\u0005\n\u0005s\u0001!\u0019!C\u0005\u0005w\tQ\u0003\u001e=o%\u0016\u001cwN\u001d3t\u0005f\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0003>AA\u0011q\u0010B \u0003\u000b\u0011\u0019%\u0003\u0003\u0003B\u0005\u0005%aA'baB1!\u0011\u0006B#\u0005\u0013JAAa\u0012\u0003,\tY\u0011I\u001d:bs\n+hMZ3s!\u0011\u0011YE!\u0015\u000e\u0005\t5#b\u0001B(\u0015\u00061!/Z2pe\u0012LAAa\u0015\u0003N\ta1+[7qY\u0016\u0014VmY8sI\"A!q\u000b\u0001!\u0002\u0013\u0011i$\u0001\fuq:\u0014VmY8sIN\u0014\u0015\u0010U1si&$\u0018n\u001c8!\u0011\u001d\u0011Y\u0006\u0001C!\u0005;\nQa]3u+B$\u0012A\u001c\u0015\u0005\u00053\u0012\t\u0007\u0005\u0003\u0003d\t%TB\u0001B3\u0015\r\u00119gT\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005W\u0012)G\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0005_\u0002A\u0011\tB/\u0003!!X-\u0019:E_^t\u0007\u0006\u0002B7\u0005g\u0002BAa\u0019\u0003v%!!q\u000fB3\u0005\u0015\te\r^3s\u0011\u001d\u0011Y\b\u0001C\u0001\u0005;\na\u0004^3ti\u000e{gnY;se\u0016tGoR8pIB\u000bG\u000f[*fcV,gnY3)\t\te$q\u0010\t\u0005\u0005G\u0012\t)\u0003\u0003\u0003\u0004\n\u0015$\u0001\u0002+fgRDqAa\"\u0001\t\u0003\u0011i&A\u000fuKN$8i\u001c8dkJ\u0014XM\u001c;SC:$w.\\*fcV,gnY3tQ\u0011\u0011)Ia \t\u000f\t5\u0005\u0001\"\u0001\u0003^\u0005\u0011C/Z:u\u0007>t7-\u001e:sK:$Hj\\1e+:dw.\u00193QCJ$\u0018\u000e^5p]NDCAa#\u0003\u0000!9!1\u0013\u0001\u0005\u0002\tu\u0013a\t;fgR\u001cuN\\2veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:,\u0005\u0010]5sCRLwN\u001c\u0015\u0005\u0005#\u0013y\bC\u0004\u0003\u001a\u0002!\tE!\u0018\u0002!\u0015t\u0017M\u00197f\u0007>l\u0007\u000f\\3uS>t\u0007b\u0002BO\u0001\u0011%!qT\u0001\u0012Y>\fG-\u00168m_\u0006$\u0017i\u0019;j_:\u001cHC\u0002BQ\u0005W\u0013\t\fE\u00037\u0005G\u0013)+C\u0002\u00032q\u00022\u0001\fBT\u0013\r\u0011I+\r\u0002\u0007\u0003\u000e$\u0018n\u001c8\t\u0011\t5&1\u0014a\u0001\u0005_\u000b\u0001\u0003]1si&$\u0018n\u001c8t)>du.\u00193\u0011\u000bY\u0012\u0019+!\u0002\t\u0011\tM&1\u0014a\u0001\u0005_\u000b!\u0003]1si&$\u0018n\u001c8t)>,f\u000e\\8bI\"9!q\u0017\u0001\u0005\n\te\u0016AE2sK\u0006$X\r\u0016:b]N\f7\r^5p]N$BAa/\u0003>B!aGa)\u000f\u0011\u001d\u0011yL!.A\u0002U\n\u0011\u0002\u001e=o!J,g-\u001b=\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\u0006\tb/\u001a:jMf$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u000b9\u00149Ma3\t\u000f\t%'\u0011\u0019a\u0001\u001d\u0005\u0019A\u000f\u001f8\t\u0011\t5'\u0011\u0019a\u0001\u0005\u001f\fQ\"\u001a=qK\u000e$X\rZ*uCR,\u0007c\u0001\u000f\u0003R&\u0019!1\u001b\u0002\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,\u0007b\u0002Bl\u0001\u0011%!\u0011\\\u0001\u0014iJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0005\u00057\u0014\u0019\u000fE\u0003!\u0003\u0003\u0014i\u000eE\u0002\u001d\u0005?L1A!9\u0003\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011\u001d\u0011IM!6A\u00029AqAa:\u0001\t\u0013\u0011I/\u0001\nqe\u0016\u0004\u0018M]3Ue\u0006t7/Y2uS>tGc\u00018\u0003l\"9!\u0011\u001aBs\u0001\u0004q\u0001b\u0002Bx\u0001\u0011%!\u0011_\u0001\u000eaJ,\u0007/\u0019:f)btGj\\4\u0015\u00079\u0014\u0019\u0010\u0003\u0005\u0003v\n5\b\u0019AA\u0003\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0007\r\te\b\u0001\u0001B~\u0005]Ie.\u001b;Qe>$WoY3s\u0013\u0012|\u0005/\u001a:bi&|gn\u0005\u0003\u0003x\nu\bCBAG\u0003\u001f\u000b9\u0010C\u0004'\u0005o$\ta!\u0001\u0015\u0005\r\r\u0001\u0003BAG\u0005oD\u0001ba\u0002\u0003x\u0012\u00053\u0011B\u0001\u0004eVtGc\u00018\u0004\f!9!\u0011ZB\u0003\u0001\u0004q\u0001\u0002CB\b\u0005o$\te!\u0005\u0002\u001d\u0005<\u0018-\u001b;B]\u00124VM]5gsR\u0019ana\u0005\t\u000f\t%7Q\u0002a\u0001\u001d\u001911q\u0003\u0001\u0001\u00073\u00111$\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]>\u0003XM]1uS>t7\u0003BB\u000b\u00077\u0001b!!$\u0002\u0010\u0006-\bbCB\u0010\u0007+\u0011\t\u0011)A\u0005\u0007C\t!\u0002]1si&$\u0018n\u001c8t!\u00151$1UB\u0012!\u0011\u0019)ca\n\u000e\u0003)K1a!\u000bK\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqAJB\u000b\t\u0003\u0019i\u0003\u0006\u0003\u00040\rE\u0002\u0003BAG\u0007+A\u0001ba\b\u0004,\u0001\u00071\u0011\u0005\u0005\t\u0007\u000f\u0019)\u0002\"\u0011\u00046Q\u0019ana\u000e\t\u000f\t%71\u0007a\u0001\u001d!A1qBB\u000b\t\u0003\u001aY\u0004F\u0002o\u0007{AqA!3\u0004:\u0001\u0007aB\u0002\u0004\u0004B\u0001\u000111\t\u0002\u0010\u000b:$G\u000b\u001f8Pa\u0016\u0014\u0018\r^5p]N!1qHB\u000e\u0011\u001d13q\bC\u0001\u0007\u000f\"\"a!\u0013\u0011\t\u000555q\b\u0005\t\u0007\u000f\u0019y\u0004\"\u0011\u0004NQ\u0019ana\u0014\t\u000f\t%71\na\u0001\u001d!A1qBB \t\u0003\u001a\u0019\u0006F\u0002o\u0007+BqA!3\u0004R\u0001\u0007a\u0002\u0003\u0005\u0004Z\r}B\u0011BB.\u0003E!(/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\u000b\u0005\u0007;\u001aI\u0007\u0005\u0003\u0004`\r\u0015TBAB1\u0015\r\u0019\u0019GS\u0001\te\u0016\fX/Z:ug&!1qMB1\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0005\u0013\u001c9\u00061\u0001\u000f\r\u0019\u0019i\u0007\u0001\u0001\u0004p\t1Bj\\1e)bt\u0007+\u0019:uSRLwN\\!di&|gn\u0005\u0004\u0004l\t\u0005!Q\u0015\u0005\f\u0007g\u001aYG!A!\u0002\u0013\t)!A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:LE\rC\u0004'\u0007W\"\taa\u001e\u0015\t\re41\u0010\t\u0005\u0003\u001b\u001bY\u0007\u0003\u0005\u0004t\rU\u0004\u0019AA\u0003\u0011!\u00199aa\u001b\u0005B\tu\u0003\u0002CBA\u0007W\"\tE!\u0018\u0002\u000b\u0005<\u0018-\u001b;\u0007\r\r\u0015\u0005\u0001ABD\u0005a)f\u000e\\8bIRCh\u000eU1si&$\u0018n\u001c8BGRLwN\\\n\u0007\u0007\u0007\u0013\tA!*\t\u0017\rM41\u0011B\u0001B\u0003%\u0011Q\u0001\u0005\bM\r\rE\u0011ABG)\u0011\u0019yi!%\u0011\t\u0005551\u0011\u0005\t\u0007g\u001aY\t1\u0001\u0002\u0006!Q1QSBB\u0005\u0004%\taa&\u0002\u0015QDhNU3d_J$7/\u0006\u0002\u0003D!I11TBBA\u0003%!1I\u0001\fibt'+Z2pe\u0012\u001c\b\u0005\u0003\u0005\u0004\b\r\rE\u0011\tB/\u0011!\u0019\tia!\u0005B\tucABBR\u0001\u0001\u0019)K\u0001\rFqBL'/\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0018i\u0019;j_:\u001cba!)\u0003\u0002\t\u0015\u0006bCBU\u0007C\u0013\t\u0011)A\u0005\u0005w\u000bA\u0002\u001e:b]N\f7\r^5p]NDqAJBQ\t\u0003\u0019i\u000b\u0006\u0003\u00040\u000eE\u0006\u0003BAG\u0007CC\u0001b!+\u0004,\u0002\u0007!1\u0018\u0005\t\u0007\u000f\u0019\t\u000b\"\u0011\u0003^!A1\u0011QBQ\t\u0003\u0012i\u0006")
public class TransactionCoordinatorConcurrencyTest
extends AbstractCoordinatorConcurrencyTest<Transaction> {
    private final int nTransactions = this.nThreads() * 10;
    private final int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    private final int numPartitions = this.nThreads() * 5;
    private final TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
    private TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    private TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    private TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Seq<TxnOperation<? extends Object>> allOperations = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnOperation[]{new InitProducerIdOperation(this), new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)})))), new EndTxnOperation(this)}));
    private final scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> TransactionCoordinatorConcurrencyTest.$anonfun$txnRecordsByPartition$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());

    private int nTransactions() {
        return this.nTransactions;
    }

    public int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    public TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig;
    }

    public TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    }

    private void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator_$eq(TransactionCoordinator x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator = x$1;
    }

    public TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    }

    private void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager_$eq(TransactionStateManager x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager = x$1;
    }

    private TransactionMarkerChannelManager txnMarkerChannelManager() {
        return this.txnMarkerChannelManager;
    }

    private void txnMarkerChannelManager_$eq(TransactionMarkerChannelManager x$1) {
        this.txnMarkerChannelManager = x$1;
    }

    private Seq<TxnOperation<? extends Object>> allOperations() {
        return this.allOperations;
    }

    public scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions;
    }

    private Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition() {
        return this.txnRecordsByPartition;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager_$eq(new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), (ReplicaManager)this.replicaManager(), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().addLoadedTransactionsToCache(i, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        int producerId = 11;
        ProducerIdManager pidManager = (ProducerIdManager)EasyMock.createNiceMock(ProducerIdManager.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)pidManager.generateProducerId())).andReturn((Object)BoxesRunTime.boxToLong((long)producerId)).anyTimes();
        String x$7 = "txn-purgatory-name";
        MockTimer x$8 = new MockTimer();
        boolean x$9 = false;
        int x$10 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$11 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory txnMarkerPurgatory = new DelayedOperationPurgatory(x$7, (Timer)x$8, x$10, x$11, x$9, x$12);
        Node brokerNode = new Node(0, "host", 10);
        MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getPartitionLeaderEndpoint(EasyMock.anyString(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)brokerNode)).anyTimes();
        NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
        this.txnMarkerChannelManager_$eq(new TransactionMarkerChannelManager(this, txnMarkerPurgatory, metadataCache, networkClient){
            private final DelayedOperationPurgatory txnMarkerPurgatory$1;

            public void shutdown() {
                this.txnMarkerPurgatory$1.shutdown();
            }
            {
                this.txnMarkerPurgatory$1 = txnMarkerPurgatory$1;
                super(KafkaConfig$.MODULE$.fromProps($outer.serverProps()), metadataCache$1, networkClient$1, $outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), txnMarkerPurgatory$1, (Time)$outer.time());
            }
        });
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator_$eq(new TransactionCoordinator(0, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Scheduler)this.scheduler(), pidManager, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), this.txnMarkerChannelManager(), (Time)this.time(), new LogContext()));
        EasyMock.replay((Object[])new Object[]{pidManager});
        EasyMock.replay((Object[])new Object[]{metadataCache});
        EasyMock.replay((Object[])new Object[]{networkClient});
    }

    @Override
    @After
    public void tearDown() {
        try {
            EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().shutdown();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testConcurrentGoodPathSequence() {
        this.verifyConcurrentOperations((Function1 & Serializable & scala.Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), this.allOperations());
    }

    @Test
    public void testConcurrentRandomSequences() {
        this.verifyConcurrentRandomSequences((Function1 & Serializable & scala.Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), this.allOperations());
    }

    @Test
    public void testConcurrentLoadUnloadPartitions() {
        scala.collection.immutable.Set partitionsToLoad = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions() / 2).toSet();
        scala.collection.immutable.Set partitionsToUnload = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.numPartitions() / 2), this.numPartitions()).toSet();
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload));
    }

    @Test
    public void testConcurrentTransactionExpiration() {
        scala.collection.immutable.Set partitionsToLoad = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions() / 3).toSet();
        scala.collection.immutable.Set partitionsToUnload = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.numPartitions() / 3), this.numPartitions() * 2 / 3).toSet();
        scala.collection.immutable.Set partitionsWithExpiringTxn = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.numPartitions() * 2 / 3), this.numPartitions()).toSet();
        scala.collection.immutable.Set expiringTransactions = ((TraversableOnce)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().filter((Function1 & Serializable & scala.Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)partitionsWithExpiringTxn.contains((Object)BoxesRunTime.boxToInteger((int)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId())))))).toSet();
        ExpireTransactionsAction expireAction = new ExpireTransactionsAction(this, (scala.collection.immutable.Set<Transaction>)expiringTransactions);
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload).$plus((Object)expireAction));
    }

    @Override
    public void enableCompletion() {
        super.enableCompletion();
        TransactionCoordinatorConcurrencyTest transactionCoordinatorConcurrencyTest = this;
        synchronized (transactionCoordinatorConcurrencyTest) {
            this.txnMarkerChannelManager().generateRequests().foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
                TransactionCoordinatorConcurrencyTest.$anonfun$enableCompletion$3(requestAndHandler);
                return BoxedUnit.UNIT;
            });
        }
    }

    private scala.collection.immutable.Set<AbstractCoordinatorConcurrencyTest.Action> loadUnloadActions(scala.collection.immutable.Set<Object> partitionsToLoad, scala.collection.immutable.Set<Object> partitionsToUnload) {
        scala.collection.immutable.Set transactions = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> this.createTransactions(new StringBuilder(35).append("testConcurrentLoadUnloadPartitions").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString()), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        transactions.foreach((Function1 & Serializable & scala.Serializable)txn -> {
            this.prepareTransaction(txn);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set unload = (scala.collection.immutable.Set)partitionsToLoad.map((Function1 & Serializable & scala.Serializable)x$1 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$3(this, BoxesRunTime.unboxToInt((Object)x$1)), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        unload.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.run();
            return BoxedUnit.UNIT;
        });
        unload.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.await();
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Set)((TraversableLike)partitionsToLoad.map((Function1 & Serializable & scala.Serializable)x$4 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$6(this, BoxesRunTime.unboxToInt((Object)x$4)), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsToUnload.map((Function1 & Serializable & scala.Serializable)x$5 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$7(this, BoxesRunTime.unboxToInt((Object)x$5)), scala.collection.immutable.Set$.MODULE$.canBuildFrom()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Set<Transaction> createTransactions(String txnPrefix) {
        IndexedSeq transactions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nTransactions()).map((Function1 & Serializable & scala.Serializable)i -> TransactionCoordinatorConcurrencyTest.$anonfun$createTransactions$1(this, txnPrefix, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().$plus$plus$eq((TraversableOnce)transactions);
        return transactions.toSet();
    }

    public void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(Transaction txn, TransactionState expectedState) {
        Tuple2 tuple2 = TestUtils$.MODULE$.computeUntilTrue((Function0 & Serializable & scala.Serializable)() -> {
            this.enableCompletion();
            return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
        }, TestUtils$.MODULE$.computeUntilTrue$default$2(), TestUtils$.MODULE$.computeUntilTrue$default$3(), (Function1 & Serializable & scala.Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$2(expectedState, metadata)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option metadata2 = (Option)tuple2._1();
        boolean success = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)metadata2, (Object)BoxesRunTime.boxToBoolean((boolean)success));
        Tuple2 tuple23 = tuple22;
        Option metadata3 = (Option)tuple23._1();
        boolean success2 = tuple23._2$mcZ$sp();
        Assert.assertTrue((String)new StringBuilder(23).append("Invalid metadata state ").append(metadata3).toString(), (boolean)success2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<TransactionMetadata> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(Transaction txn) {
        boolean bl = false;
        Right right = null;
        Either either = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().getTransactionState(txn.transactionalId());
        if (either instanceof Left) {
            Errors error;
            Left left = (Left)either;
            Errors errors = error = (Errors)left.value();
            Errors errors2 = Errors.NOT_COORDINATOR;
            if (errors == null) {
                if (errors2 == null) return None$.MODULE$;
                throw new AssertionError((Object)new StringBuilder(34).append("Unexpected transaction error ").append(error).append(" for ").append(txn).toString());
            }
            if (!errors.equals(errors2)) throw new AssertionError((Object)new StringBuilder(34).append("Unexpected transaction error ").append(error).append(" for ").append(txn).toString());
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (option instanceof Some) {
                Some some = (Some)option;
                CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)some.value();
                return new Some((Object)metadata.transactionMetadata());
            }
        }
        if (!bl) throw new MatchError((Object)either);
        Option option = (Option)right.value();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)either);
        return None$.MODULE$;
    }

    private void prepareTransaction(Transaction txn) {
        int partitionId = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId());
        ArrayBuffer txnRecords = (ArrayBuffer)this.txnRecordsByPartition().apply((Object)BoxesRunTime.boxToInteger((int)partitionId));
        InitProducerIdOperation initPidOp = new InitProducerIdOperation(this);
        AddPartitionsToTxnOperation addPartitionsOp = new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)}))));
        initPidOp.run(txn);
        initPidOp.awaitAndVerify(txn);
        addPartitionsOp.run(txn);
        addPartitionsOp.awaitAndVerify(txn);
        TransactionMetadata txnMetadata = (TransactionMetadata)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(22).append("Transaction not found ").append(txn).toString());
        });
        txnRecords.$plus$eq((Object)new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit())));
        txnMetadata.state_$eq((TransactionState)PrepareCommit$.MODULE$);
        txnRecords.$plus$eq((Object)new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit())));
        this.prepareTxnLog(partitionId);
    }

    private void prepareTxnLog(int partitionId) {
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        long startOffset = BoxesRunTime.unboxToLong((Object)this.replicaManager().getLogEndOffset(topicPartition).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 20L));
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)this.txnRecordsByPartition().apply((Object)BoxesRunTime.boxToInteger((int)partitionId))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (Option)EasyMock.eq((Object)None$.MODULE$), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, records, bufferCapture){
            private final MemoryRecords records$1;
            private final Capture bufferCapture$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.records$1 = records$1;
                this.bufferCapture$1 = bufferCapture$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock});
        TransactionCoordinatorConcurrencyTest transactionCoordinatorConcurrencyTest = this;
        synchronized (transactionCoordinatorConcurrencyTest) {
            this.replicaManager().updateLog(topicPartition, logMock, endOffset);
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$txnRecordsByPartition$1(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    private static final WriteTxnMarkersResponse createResponse$1(WriteTxnMarkersRequest request) {
        java.util.Map pidErrorMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.markers()).asScala()).map((Function1 & Serializable & scala.Serializable)marker -> new Tuple2((Object)BoxesRunTime.boxToLong((long)marker.producerId()), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(marker.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp, (Object)Errors.NONE), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        return new WriteTxnMarkersResponse(pidErrorMap);
    }

    public static final /* synthetic */ void $anonfun$enableCompletion$3(RequestAndCompletionHandler requestAndHandler) {
        WriteTxnMarkersRequest request = (WriteTxnMarkersRequest)((WriteTxnMarkersRequest.Builder)requestAndHandler.request()).build();
        WriteTxnMarkersResponse response = TransactionCoordinatorConcurrencyTest.createResponse$1(request);
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
    }

    public static final /* synthetic */ UnloadTxnPartitionAction $anonfun$loadUnloadActions$3(TransactionCoordinatorConcurrencyTest $this, int x$1) {
        return new UnloadTxnPartitionAction($this, x$1);
    }

    public static final /* synthetic */ LoadTxnPartitionAction $anonfun$loadUnloadActions$6(TransactionCoordinatorConcurrencyTest $this, int x$4) {
        return new LoadTxnPartitionAction($this, x$4);
    }

    public static final /* synthetic */ UnloadTxnPartitionAction $anonfun$loadUnloadActions$7(TransactionCoordinatorConcurrencyTest $this, int x$5) {
        return new UnloadTxnPartitionAction($this, x$5);
    }

    public static final /* synthetic */ Transaction $anonfun$createTransactions$1(TransactionCoordinatorConcurrencyTest $this, String txnPrefix$1, int i) {
        return new Transaction(new StringBuilder(0).append(txnPrefix$1).append(i).toString(), i, $this.time());
    }

    public static final /* synthetic */ boolean $anonfun$verifyTransaction$3(TransactionState expectedState$1, TransactionMetadata m) {
        TransactionState transactionState = m.state();
        TransactionState transactionState2 = expectedState$1;
        return !(transactionState != null ? !transactionState.equals(transactionState2) : transactionState2 != null) && m.pendingState().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTransaction$2(TransactionState expectedState$1, Option metadata) {
        return metadata.nonEmpty() && metadata.forall((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$3(expectedState$1, m)));
    }

    public TransactionCoordinatorConcurrencyTest() {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch = 10;
    }

    public class AddPartitionsToTxnOperation
    extends TxnOperation<Errors> {
        private final scala.collection.immutable.Set<TopicPartition> partitions;

        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1 & Serializable & scala.Serializable)txnMetadata -> {
                AddPartitionsToTxnOperation.$anonfun$run$2(this, txn, txnMetadata);
                return BoxedUnit.UNIT;
            });
        }

        public void awaitAndVerify(Transaction txn) {
            Errors error = (Errors)this.result().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException("AddPartitionsToTransaction has not completed");
            });
            Assert.assertEquals((Object)Errors.NONE, (Object)error);
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Ongoing$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$2(AddPartitionsToTxnOperation $this, Transaction txn$4, TransactionMetadata txnMetadata) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleAddPartitionsToTransaction(txn$4.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), $this.partitions, (Function1 & Serializable & scala.Serializable)r -> {
                $this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public AddPartitionsToTxnOperation(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<TopicPartition> partitions) {
            this.partitions = partitions;
            super($outer);
        }
    }

    public class EndTxnOperation
    extends TxnOperation<Errors> {
        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1 & Serializable & scala.Serializable)txnMetadata -> {
                EndTxnOperation.$anonfun$run$4(this, txn, txnMetadata);
                return BoxedUnit.UNIT;
            });
        }

        public void awaitAndVerify(Transaction txn) {
            Errors error = (Errors)this.result().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException("EndTransaction has not completed");
            });
            if (!txn.ended()) {
                txn.ended_$eq(true);
                Assert.assertEquals((Object)Errors.NONE, (Object)error);
                TransactionResult transactionResult = this.transactionResult(txn);
                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                CompleteCommit$ expectedState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
                this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)expectedState);
            } else {
                Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)error);
            }
        }

        private TransactionResult transactionResult(Transaction txn) {
            String txnId = txn.transactionalId();
            char lastDigit = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(txnId), txnId.length() - 1);
            return lastDigit % 2 == 0 ? TransactionResult.COMMIT : TransactionResult.ABORT;
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$4(EndTxnOperation $this, Transaction txn$1, TransactionMetadata txnMetadata) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleEndTransaction(txn$1.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), $this.transactionResult(txn$1), (Function1 & Serializable & scala.Serializable)r -> {
                $this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public EndTxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class ExpireTransactionsAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final scala.collection.immutable.Set<Transaction> transactions;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.transactions.foreach((Function1 & Serializable & scala.Serializable)txn -> {
                ExpireTransactionsAction.$anonfun$run$6(this, txn);
                return BoxedUnit.UNIT;
            });
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().enableTransactionalIdExpiration();
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().sleep(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().removeExpiredTransactionalIdsIntervalMs() + 1);
        }

        @Override
        public void await() {
            boolean success;
            Tuple2 tuple2 = TestUtils$.MODULE$.computeUntilTrue((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().replicaManager().tryCompleteDelayedRequests();
                return $this.transactions.forall((Function1 & Serializable & scala.Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)ExpireTransactionsAction.$anonfun$await$4(this, txn)));
            }, TestUtils$.MODULE$.computeUntilTrue$default$2(), TestUtils$.MODULE$.computeUntilTrue$default$3(), (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ExpireTransactionsAction.$anonfun$await$5(BoxesRunTime.unboxToBoolean((Object)x))));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean bl = success = tuple2._2$mcZ$sp();
            boolean success2 = bl;
            Assert.assertTrue((String)"Transaction not expired", (boolean)success2);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$6(ExpireTransactionsAction $this, Transaction txn) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).foreach((Function1 & Serializable & scala.Serializable)txnMetadata -> {
                txnMetadata.txnLastUpdateTimestamp_$eq($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().milliseconds() - (long)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().transactionalIdExpirationMs());
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ boolean $anonfun$await$4(ExpireTransactionsAction $this, Transaction txn) {
            return $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty();
        }

        public static final /* synthetic */ boolean $anonfun$await$5(boolean x) {
            return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
        }

        public ExpireTransactionsAction(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<Transaction> transactions) {
            this.transactions = transactions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class InitProducerIdOperation
    extends TxnOperation<InitProducerIdResult> {
        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleInitProducerId(txn.transactionalId(), 60000, (Function1 & Serializable & scala.Serializable)r -> {
                this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public void awaitAndVerify(Transaction txn) {
            InitProducerIdResult initPidResult = (InitProducerIdResult)this.result().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException("InitProducerId has not completed");
            });
            Assert.assertEquals((Object)Errors.NONE, (Object)initPidResult.error());
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Empty$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public InitProducerIdOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class LoadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final int txnTopicPartitionId;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleTxnImmigration(this.txnTopicPartitionId, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch());
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> {
                LoadTxnPartitionAction.$anonfun$await$1(this, txn);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$await$1(LoadTxnPartitionAction $this, Transaction txn) {
            block0: {
                if ($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) != $this.txnTopicPartitionId) break block0;
                $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)CompleteCommit$.MODULE$);
            }
        }

        public LoadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public static class Transaction
    implements AbstractCoordinatorConcurrencyTest.CoordinatorMember {
        private final String transactionalId;
        private final byte[] txnMessageKeyBytes;
        private volatile boolean ended;

        public String transactionalId() {
            return this.transactionalId;
        }

        public byte[] txnMessageKeyBytes() {
            return this.txnMessageKeyBytes;
        }

        public boolean ended() {
            return this.ended;
        }

        public void ended_$eq(boolean x$1) {
            this.ended = x$1;
        }

        public String toString() {
            return this.transactionalId();
        }

        public Transaction(String transactionalId, long producerId, MockTime time) {
            this.transactionalId = transactionalId;
            this.txnMessageKeyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            this.ended = false;
        }
    }

    public abstract class TxnOperation<R>
    extends AbstractCoordinatorConcurrencyTest.Operation {
        private volatile Option<R> result = None$.MODULE$;

        public Option<R> result() {
            return this.result;
        }

        public void result_$eq(Option<R> x$1) {
            this.result = x$1;
        }

        public void resultCallback(R r) {
            this.result_$eq((Option<R>)new Some(r));
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$TxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public TxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class UnloadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final int txnTopicPartitionId;
        private final ArrayBuffer<SimpleRecord> txnRecords;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        public ArrayBuffer<SimpleRecord> txnRecords() {
            return this.txnRecords;
        }

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleTxnEmigration(this.txnTopicPartitionId, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch());
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> {
                UnloadTxnPartitionAction.$anonfun$await$2(this, txn);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$await$2(UnloadTxnPartitionAction $this, Transaction txn) {
            block0: {
                if ($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) != $this.txnTopicPartitionId) break block0;
                Assert.assertTrue((String)"Transaction metadata not removed", (boolean)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty());
            }
        }

        public UnloadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }
}

