/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001B\u0001\u0003\u0001%\u00111\u0004\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:UKN$(BA\u0002\u0005\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u00151\u0011aC2p_J$\u0017N\\1u_JT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#A\u0006qCJ$\u0018\u000e^5p]&#W#\u0001\r\u0011\u0005-I\u0012B\u0001\u000e\r\u0005\rIe\u000e\u001e\u0005\u00079\u0001\u0001\u000b\u0011\u0002\r\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u000fy\u0001!\u0019!C\u0001/\u0005ia.^7QCJ$\u0018\u000e^5p]NDa\u0001\t\u0001!\u0002\u0013A\u0012A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bE\u0001\u0011\r\u0011\"\u0001\u0018\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\"1A\u0005\u0001Q\u0001\na\tQ\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\b\u0005C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0001\u0006\u0005\u0002*c5\t!F\u0003\u0002,Y\u000511m\\7n_:T!aB\u0017\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0005\u0003e)\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u00045\u0001\u0001\u0006I\u0001K\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!9a\u0007\u0001b\u0001\n\u00039\u0012\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u0019A\u0004\u0001)A\u00051\u0005\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\t\u000fi\u0002!\u0019!C\u0001w\u0005QA\u000f\u001f8SK\u000e|'\u000fZ:\u0016\u0003q\u00022!\u0010\"E\u001b\u0005q$BA A\u0003\u001diW\u000f^1cY\u0016T!!\u0011\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002D}\tY\u0011I\u001d:bs\n+hMZ3s!\t)\u0005*D\u0001G\u0015\t9%&\u0001\u0004sK\u000e|'\u000fZ\u0005\u0003\u0013\u001a\u0013AbU5na2,'+Z2pe\u0012Daa\u0013\u0001!\u0002\u0013a\u0014a\u0003;y]J+7m\u001c:eg\u0002Bq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\u0003uS6,W#A(\u0011\u0005A\u001bV\"A)\u000b\u0005IS\u0013!B;uS2\u001c\u0018B\u0001+R\u0005!iunY6US6,\u0007B\u0002,\u0001A\u0003%q*A\u0003uS6,\u0007\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001.\u0011\u0005mkV\"\u0001/\u000b\u0005I3\u0011B\u00010]\u00055iunY6TG\",G-\u001e7fe\"1\u0001\r\u0001Q\u0001\ni\u000b!b]2iK\u0012,H.\u001a:!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\f\u0001B_6DY&,g\u000e^\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011qMB\u0001\u0003u.L!!\u001b4\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u0019Y\u0007\u0001)A\u0005I\u0006I!p[\"mS\u0016tG\u000f\t\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e\u001a\taa]3sm\u0016\u0014\u0018B\u0001;r\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDaA\u001e\u0001!\u0002\u0013y\u0017a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\t\u000fa\u0004!\u0019!C\u0001s\u0006IA\u000f\u001f8D_:4\u0017nZ\u000b\u0002uB\u0011Ac_\u0005\u0003y\n\u0011\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0011\u0019q\b\u0001)A\u0005u\u0006QA\u000f\u001f8D_:4\u0017n\u001a\u0011\t\u0013\u0005\u0005\u0001A1A\u0005\u0002\u0005\r\u0011A\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ,\"!!\u0002\u0011\u0007Q\t9!C\u0002\u0002\n\t\u0011q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000b\t1\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4fe\u0002B\u0011\"!\u0005\u0001\u0005\u0004%\t!a\u0005\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fTCAA\u000b!\u0011\t9\"!\n\u000f\t\u0005e\u0011\u0011\u0005\t\u0004\u00037aQBAA\u000f\u0015\r\ty\u0002C\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\rB\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Ga\u0001\u0002CA\u0017\u0001\u0001\u0006I!!\u0006\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0004\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0001\u0002\u0014\u0005\u0001BO]1og\u0006\u001cG/[8oC2LEM\r\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002\u0016\u0005\tBO]1og\u0006\u001cG/[8oC2LEM\r\u0011\t\u0013\u0005e\u0002A1A\u0005\u0002\u0005m\u0012a\u0005;y]6+7o]1hK.+\u0017PQ=uKN\fTCAA\u001f!\u0015Y\u0011qHA\"\u0013\r\t\t\u0005\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0017\u0005\u0015\u0013bAA$\u0019\t!!)\u001f;f\u0011!\tY\u0005\u0001Q\u0001\n\u0005u\u0012\u0001\u0006;y]6+7o]1hK.+\u0017PQ=uKN\f\u0004\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0001\u0002<\u0005\u0019B\u000f\u001f8NKN\u001c\u0018mZ3LKf\u0014\u0015\u0010^3te!A\u00111\u000b\u0001!\u0002\u0013\ti$\u0001\u000buq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c(\u0007\t\u0005\n\u0003/\u0002!\u0019!C\u0001\u00033\n1\u0002\u001d:pIV\u001cWM]%egV\u0011\u00111\f\t\t\u0003;\ny&!\u0006\u0002d5\t\u0001)C\u0002\u0002b\u0001\u00131!T1q!\rY\u0011QM\u0005\u0004\u0003Ob!\u0001\u0002'p]\u001eD\u0001\"a\u001b\u0001A\u0003%\u00111L\u0001\raJ|G-^2fe&#7\u000f\t\u0005\n\u0003_\u0002\u0001\u0019!C\u0001\u0003c\nA\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCF*\"!a\u001d\u0011\u0007Q\t)(C\u0002\u0002x\t\u00111\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006D\u0011\"a\u001f\u0001\u0001\u0004%\t!! \u0002!QDh.T3uC\u0012\fG/Y\u0019`I\u0015\fH\u0003BA@\u0003\u000b\u00032aCAA\u0013\r\t\u0019\t\u0004\u0002\u0005+:LG\u000f\u0003\u0006\u0002\b\u0006e\u0014\u0011!a\u0001\u0003g\n1\u0001\u001f\u00132\u0011!\tY\t\u0001Q!\n\u0005M\u0014!\u0004;y]6+G/\u00193bi\u0006\f\u0004\u0005C\u0005\u0002\u0010\u0002\u0001\r\u0011\"\u0001\u0002r\u0005aA\u000f\u001f8NKR\fG-\u0019;be!I\u00111\u0013\u0001A\u0002\u0013\u0005\u0011QS\u0001\u0011ibtW*\u001a;bI\u0006$\u0018MM0%KF$B!a \u0002\u0018\"Q\u0011qQAI\u0003\u0003\u0005\r!a\u001d\t\u0011\u0005m\u0005\u0001)Q\u0005\u0003g\nQ\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCJ\u0002\u0003\"CAP\u0001\u0001\u0007I\u0011AAQ\u00035)\u0007\u0010]3di\u0016$WI\u001d:peV\u0011\u00111\u0015\t\u0005\u0003K\u000bY+\u0004\u0002\u0002(*\u0019\u0011\u0011\u0016\u0016\u0002\u0011A\u0014x\u000e^8d_2LA!!,\u0002(\n1QI\u001d:peND\u0011\"!-\u0001\u0001\u0004%\t!a-\u0002#\u0015D\b/Z2uK\u0012,%O]8s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\u0005U\u0006BCAD\u0003_\u000b\t\u00111\u0001\u0002$\"A\u0011\u0011\u0018\u0001!B\u0013\t\u0019+\u0001\bfqB,7\r^3e\u000bJ\u0014xN\u001d\u0011\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\u0006)1/\u001a;VaR\u0011\u0011q\u0010\u0015\u0005\u0003w\u000b\u0019\r\u0005\u0003\u0002F\u0006-WBAAd\u0015\r\tImL\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u001b\f9M\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003#\u0004A\u0011AA`\u0003!!X-\u0019:E_^t\u0007\u0006BAh\u0003+\u0004B!!2\u0002X&!\u0011\u0011\\Ad\u0005\u0015\te\r^3s\u0011\u001d\ti\u000e\u0001C\u0001\u0003\u007f\u000ba\u0004^3tiZ\u000bG.\u001b3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;)\t\u0005m\u0017\u0011\u001d\t\u0005\u0003\u000b\f\u0019/\u0003\u0003\u0002f\u0006\u001d'\u0001\u0002+fgRDq!!;\u0001\t\u0003\ty,\u0001\buKN$\u0018\t\u001a3HKR\u0004\u0016\u000eZ:)\t\u0005\u001d\u0018\u0011\u001d\u0005\b\u0003_\u0004A\u0011AA`\u0003%\"Xm\u001d;M_\u0006$\u0017I\u001c3SK6|g/\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:QCJ$\u0018\u000e^5p]\"\"\u0011Q^Aq\u0011\u001d\t)\u0010\u0001C\u0001\u0003\u007f\u000b\u0011\u0006^3ti\u000e{W\u000e\u001d7fi\u0016$&/\u00198tSRLwN\\,iK:\f\u0005\u000f]3oIN+8mY3fI\u0016$\u0007\u0006BAz\u0003CDq!a?\u0001\t\u0003\ty,\u0001\u0017uKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_\u000e{wN\u001d3j]\u0006$xN\u001d(pi\u00063\u0018-\u001b7bE2,WI\u001d:pe\"\"\u0011\u0011`Aq\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003\u007f\u000b1\u0005^3ti\u0006\u0003\b/\u001a8e\r\u0006LG\u000eV8O_R\u001cun\u001c:eS:\fGo\u001c:FeJ|'\u000f\u000b\u0003\u0002\u0000\u0006\u0005\bb\u0002B\u0004\u0001\u0011\u0005\u0011qX\u0001(i\u0016\u001cH/\u00119qK:$g)Y5m)>\u001cun\u001c:eS:\fGo\u001c:M_\u0006$\u0017N\\4FeJ|'\u000f\u000b\u0003\u0003\u0006\u0005\u0005\bb\u0002B\u0007\u0001\u0011\u0005\u0011qX\u0001\u001di\u0016\u001cH/\u00119qK:$g)Y5m)>,fn\u001b8po:,%O]8sQ\u0011\u0011Y!!9\t\u000f\tM\u0001\u0001\"\u0001\u0002@\u0006)C/Z:u!\u0016tG-\u001b8h'R\fG/\u001a(piJ+7/\u001a;P]J+GO]=BaB,g\u000e\u001a\u0015\u0005\u0005#\t\t\u000fC\u0004\u0003\u001a\u0001!\t!a0\u0002[Q,7\u000f^!qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4XQ&dW\r\u0015:pIV\u001cWM\u001d$f]\u000e,G\r\u000b\u0003\u0003\u0018\u0005\u0005\bb\u0002B\u0010\u0001\u0011\u0005\u0011qX\u00013i\u0016\u001cH/\u00119qK:$GK]1og\u0006\u001cG/[8o)>dunZ,iS2,\u0007+\u001a8eS:<7\u000b^1uK\u000eC\u0017M\\4fI\"B!QDAq\u0005G\u0011)#\u0001\u0005fqB,7\r^3eG\t\u00119\u0003\u0005\u0003\u0003*\tMRB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\t1\fgn\u001a\u0006\u0003\u0005c\tAA[1wC&!!Q\u0007B\u0016\u0005UIE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:DqA!\u000f\u0001\t\u0003\ty,A tQ>,H\u000e\u001a*fiV\u0014hNT8u\u0007>|'/\u001b3oCR|'/\u0012:s_JLe\r\u0016:b]N\f7\r^5p]&#\u0007+\u0019:uSRLwN\u001c(pi>;h.\u001a3)\t\t]\u0012\u0011\u001d\u0005\b\u0005\u007f\u0001A\u0011AA`\u0003Y\u001a\bn\\;mI>sG._\"p]NLG-\u001a:Ue\u0006t7/Y2uS>t7/\u00138UQ\u0016|enZ8j]\u001e\u001cF/\u0019;f)>\f%m\u001c:uQ\u0011\u0011i$!9\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002@\u0006A4\u000f[8vY\u0012<&/\u001b;f)btW*\u0019:lKJ\u001chi\u001c:Ue\u0006t7/Y2uS>t\u0017J\u001c)sKB\f'/\u001a3D_6l\u0017\u000e^*uCR,\u0007\u0006\u0002B\"\u0003CDqAa\u0013\u0001\t\u0003\ty,A\u001ctQ>,H\u000eZ,sSR,G\u000b\u001f8NCJ\\WM]:G_J$&/\u00198tC\u000e$\u0018n\u001c8J]B\u0013X\r]1sK\u0012\f%m\u001c:u'R\fG/\u001a\u0015\u0005\u0005\u0013\n\t\u000fC\u0004\u0003R\u0001!\t!a0\u0002eMDw.\u001e7e%\u0016lwN^3D_6\u0004H.\u001a;f\u0007>lW.\\5u\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINDCAa\u0014\u0002b\"9!q\u000b\u0001\u0005\u0002\u0005}\u0016\u0001M:i_VdGMU3n_Z,7i\\7qY\u0016$X-\u00112peR,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u000b\u0003\u0003V\u0005\u0005\bb\u0002B/\u0001\u0011\u0005\u0011qX\u0001)g\"|W\u000f\u001c3SK6|g/Z#naRLX\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0005\u00057\n\t\u000fC\u0004\u0003d\u0001!\t!a0\u0002mMDw.\u001e7e\u001d>$(+Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7/\u00134M_\u001e\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\\:)\t\t\u0005\u0014\u0011\u001d\u0005\b\u0005S\u0002A\u0011AA`\u0003\u0019\u001a\bn\\;mI:{GOU3n_Z,wJ\\4pS:<GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0005\u0005O\n\t\u000fC\u0004\u0003p\u0001!\t!a0\u0002WMDw.\u001e7e\u001d>$(+Z7pm\u0016\u0004&/\u001a9be\u0016\f%m\u001c:u)J\fgn]1di&|g.\u00197JINDCA!\u001c\u0002b\"9!Q\u000f\u0001\u0005\u0002\u0005}\u0016\u0001L:i_VdGMT8u%\u0016lwN^3Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\u0011\u0011\u0019(!9\t\u000f\tm\u0004\u0001\"\u0003\u0003~\u0005\u0011c/\u001a:jMflU\r^1eCR\fGi\\3t\u000bbL7\u000f^!oI&\u001bXk]1cY\u0016$B!a \u0003\u0000!A!\u0011\u0011B=\u0001\u0004\t)\"A\bue\u0006t7/Y2uS>t\u0017\r\\%e\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000f\u000b\u0011D^3sS\u001aLX*\u001a;bI\u0006$\u0018\rR8fg:$X\t_5tiR!\u0011q\u0010BE\u0011!\u0011\tIa!A\u0002\u0005U\u0001b\u0002BG\u0001\u0011%!qR\u0001%g\u0016$X\u000f]!oIJ+h\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]R1\u0011q\u0010BI\u0005+C\u0001Ba%\u0003\f\u0002\u0007\u00111U\u0001\u0006KJ\u0014xN\u001d\u0005\t\u0005/\u0013Y\t1\u0001\u0003\u001a\u0006AA\u000f\u001f8Ti\u0006$X\rE\u0002\u0015\u00057K1A!(\u0003\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0003\"\u0002!IAa)\u0002IY,'/\u001b4z/JLG/Z:Uq:l\u0015M]6feNLe\u000e\u0015:fa\u0006\u0014Xm\u0015;bi\u0016$B!a \u0003&\"A!q\u0015BP\u0001\u0004\u0011I*A\u0003ti\u0006$X\rC\u0004\u0003,\u0002!IA!,\u0002\u001d\u0005\u001c8/\u001a:u\u0007\u0006dGNY1dWR!\u0011q\u0010BX\u0011!\u0011\u0019J!+A\u0002\u0005\r\u0006b\u0002BZ\u0001\u0011%!QW\u0001\u0014iJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u000b\u0003g\u00129L!/\u0003>\n}\u0006\u0002\u0003BA\u0005c\u0003\r!!\u0006\t\u0011\tm&\u0011\u0017a\u0001\u0003G\n!\u0002\u001d:pIV\u001cWM]%e\u0011)\u00119K!-\u0011\u0002\u0003\u0007!\u0011\u0014\u0005\n\u0005\u0003\u0014\t\f%AA\u0002a\t!\u0002\u001e=o)&lWm\\;u\u0011\u001d\u0011)\r\u0001C\u0005\u0005\u000f\fQ\u0002\u001d:fa\u0006\u0014X\r\u0016=o\u0019><G\u0003CA@\u0005\u0013\u0014YMa4\t\r\u0019\u0012\u0019\r1\u0001)\u0011!\u0011iMa1A\u0002\u0005\r\u0014aC:uCJ$xJ\u001a4tKRD\u0001B!5\u0003D\u0002\u0007!1[\u0001\be\u0016\u001cwN\u001d3t!\r)%Q[\u0005\u0004\u0005/4%!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0003\\\u0002!IA!8\u00025A\u0014X\r]1sK\u001a{'\u000f\u0016=o\u001b\u0016\u001c8/Y4f\u0003B\u0004XM\u001c3\u0015\t\u0005}$q\u001c\u0005\t\u0005'\u0013I\u000e1\u0001\u0002$\"I!1\u001d\u0001\u0012\u0002\u0013%!Q]\u0001\u001eiJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u001d\u0016\u0005\u00053\u0013Io\u000b\u0002\u0003lB!!Q\u001eB|\u001b\t\u0011yO\u0003\u0003\u0003r\nM\u0018!C;oG\",7m[3e\u0015\r\u0011)\u0010D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B}\u0005_\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011i\u0010AI\u0001\n\u0013\u0011y0A\u000fue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\tAK\u0002\u0019\u0005S\u0004")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @Before
    public void setUp() {
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId1()));
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata2()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$1 -> TestUtils$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$2 -> TestUtils$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(x$3, x$4, x$5, x$6, x$7) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(x$3, BoxesRunTime.unboxToInt((Object)x$4), x$5, x$6, x$7);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> TestUtils$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString())));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> TestUtils$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString())));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> TestUtils$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString())));
        Assert.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assert.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$8 -> TestUtils$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$9 -> TestUtils$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString()));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_FOR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$10)));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test(expected=IllegalStateException.class)
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$11 -> TestUtils$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.transactionManager().putTransactionStateIfNotExists("ongoing", this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("not-expiring", this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists("prepare-commit", this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("prepare-abort", this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-commit", this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-abort", this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assert.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommmitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw TestUtils$.MODULE$.fail("shouldn't have been any errors");
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                throw TestUtils$.MODULE$.fail("metadata should have been removed");
            }
        }
        if (!bl || !((option = (Option)right.value()) instanceof Some)) {
            throw new MatchError((Object)either);
        }
        Some some = (Some)option;
        CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)some.value();
        Assert.assertTrue((String)"metadata shouldn't be in a pending state", (boolean)metadata.transactionMetadata().pendingState().isEmpty());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw TestUtils$.MODULE$.fail("shouldn't have been any errors");
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                throw TestUtils$.MODULE$.fail("metadata should have been removed");
            }
        }
        if (!bl || !None$.MODULE$.equals(option = (Option)right.value())) {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        BoxedUnit boxedUnit;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        Capture capturedArgument = EasyMock.newCapture();
        TopicPartition partition = new TopicPartition("__transaction_state", this.transactionManager().partitionFor(this.transactionalId1()));
        Map recordsByPartition = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds() + (long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null)}))}));
        TransactionState transactionState = txnState;
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        if (bl) {
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.eq((Object)recordsByPartition), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, error, capturedArgument, partition){
                private final Errors error$2;
                private final Capture capturedArgument$1;
                private final TopicPartition partition$1;

                public void answer() {
                    ((Function1)this.capturedArgument$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$1), (Object)new ProduceResponse.PartitionResponse(this.error$2, 0L, -1L, 0L))})));
                }
                {
                    this.error$2 = error$2;
                    this.capturedArgument$1 = capturedArgument$1;
                    this.partition$1 = partition$1;
                }
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId2(), this.txnMetadata2());
        this.transactionManager().enableTransactionalIdExpiration();
        this.time().sleep((long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assert.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (Option)EasyMock.eq((Object)None$.MODULE$), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, records, bufferCapture){
            private final MemoryRecords records$1;
            private final Capture bufferCapture$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.records$1 = records$1;
                this.bufferCapture$1 = bufferCapture$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedArgument){
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final Errors error$1;
            private final Capture capturedArgument$2;

            public void answer() {
                ((Function1)this.capturedArgument$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", this.$outer.partitionId())), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.error$1 = error$1;
                this.capturedArgument$2 = capturedArgument$2;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(String x$3, int x$4, TransactionResult x$5, TransactionMetadata x$6, TxnTransitMetadata x$7) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$10) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private static final void rememberTxnMarkers$1(String transactionalId, int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = transactionalId;
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

