/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.controller.ControllerStats;
import kafka.network.Processor;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u00111\u0001B\u0001\fS:$Xm\u001a:bi&|gNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#A\u0005ce>\\WM]%ecU\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDa!\b\u0001!\u0002\u00131\u0012A\u00032s_.,'/\u001332A!9q\u0004\u0001b\u0001\n\u0003)\u0012!\u00032s_.,'/\u001333\u0011\u0019\t\u0003\u0001)A\u0005-\u0005Q!M]8lKJLEM\r\u0011\t\u000f\r\u0002!\u0019!C\u0001I\u0005ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\u0016\u0003\u0015\u0002\"a\u0006\u0014\n\u0005\u001dB\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007S\u0001\u0001\u000b\u0011B\u0013\u00023\u0015t\u0017M\u00197f\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000e\t\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u00031\u0019wN\u001c4jOB\u0013x\u000e]:2+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002\u001c\u0001\u0001\u0004%\taN\u0001\u0011G>tg-[4Qe>\u00048/M0%KF$\"\u0001O\u001e\u0011\u0005]I\u0014B\u0001\u001e\u0019\u0005\u0011)f.\u001b;\t\u000fq*\u0014\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\ry\u0002\u0001\u0015)\u0003.\u00035\u0019wN\u001c4jOB\u0013x\u000e]:2A!9\u0001\t\u0001a\u0001\n\u0003a\u0013\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0004b\u0002\"\u0001\u0001\u0004%\taQ\u0001\u0011G>tg-[4Qe>\u00048OM0%KF$\"\u0001\u000f#\t\u000fq\n\u0015\u0011!a\u0001[!1a\t\u0001Q!\n5\nQbY8oM&<\u0007K]8qgJ\u0002\u0003b\u0002%\u0001\u0001\u0004%\t!S\u0001\bG>tg-[4t+\u0005Q\u0005cA&T-:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u001a\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005IC\u0012a\u00029bG.\fw-Z\u0005\u0003)V\u00131aU3r\u0015\t\u0011\u0006\u0004\u0005\u0002X56\t\u0001L\u0003\u0002Z\t\u000511/\u001a:wKJL!a\u0017-\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b;\u0002\u0001\r\u0011\"\u0001_\u0003-\u0019wN\u001c4jON|F%Z9\u0015\u0005az\u0006b\u0002\u001f]\u0003\u0003\u0005\rA\u0013\u0005\u0007C\u0002\u0001\u000b\u0015\u0002&\u0002\u0011\r|gNZ5hg\u0002Bqa\u0019\u0001A\u0002\u0013\u0005A-A\u0004tKJ4XM]:\u0016\u0003\u0015\u00042aS*g!\t9v-\u0003\u0002i1\nY1*\u00194lCN+'O^3s\u0011\u001dQ\u0007\u00011A\u0005\u0002-\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0001\b\u001c\u0005\by%\f\t\u00111\u0001f\u0011\u0019q\u0007\u0001)Q\u0005K\u0006A1/\u001a:wKJ\u001c\b\u0005C\u0004q\u0001\t\u0007I\u0011A9\u0002\rI\fg\u000eZ8n+\u0005\u0011\bCA:v\u001b\u0005!(B\u0001\u0019\u0019\u0013\t1HO\u0001\u0004SC:$w.\u001c\u0005\u0007q\u0002\u0001\u000b\u0011\u0002:\u0002\u000fI\fg\u000eZ8nA!9!\u0010\u0001b\u0001\n\u0003Y\u0018!\u0002;pa&\u001cW#\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018'\u0001\u0003mC:<\u0017bAA\u0002}\n11\u000b\u001e:j]\u001eDq!a\u0002\u0001A\u0003%A0\u0001\u0004u_BL7\r\t\u0005\t\u0003\u0017\u0001!\u0019!C\u0001+\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\ty\u0001\u0001Q\u0001\nY\tA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0011\"a\u0005\u0001\u0005\u0004%\t!!\u0006\u0002\u001f-\fgm[1Ba&\u001cHj\\4hKJ,\"!a\u0006\u0011\t\u0005e\u0011qE\u0007\u0003\u00037QA!!\b\u0002 \u0005)An\\45U*!\u0011\u0011EA\u0012\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QE\u0001\u0004_J<\u0017\u0002BA\u0015\u00037\u0011a\u0001T8hO\u0016\u0014\b\u0002CA\u0017\u0001\u0001\u0006I!a\u0006\u0002!-\fgm[1Ba&\u001cHj\\4hKJ\u0004\u0003\"CA\u0019\u0001\t\u0007I\u0011AA\u000b\u0003YqW\r^<pe.\u0004&o\\2fgN|'\u000fT8hO\u0016\u0014\b\u0002CA\u001b\u0001\u0001\u0006I!a\u0006\u0002/9,Go^8sWB\u0013xnY3tg>\u0014Hj\\4hKJ\u0004\u0003bBA\u001d\u0001\u0011\u0005\u00131H\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002q!\"\u0011qGA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#\u0002BA#\u0003G\tQA[;oSRLA!!\u0013\u0002D\t1!)\u001a4pe\u0016Dq!!\u0014\u0001\t\u0003\nY$\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\tY%!\u0015\u0011\t\u0005\u0005\u00131K\u0005\u0005\u0003+\n\u0019EA\u0003BMR,'\u000fC\u0004\u0002Z\u0001!I!a\u0017\u0002\u0019M$\u0018M\u001d;Ce>\\WM]:\u0015\u0007a\ni\u0006\u0003\u0005\u0002`\u0005]\u0003\u0019AA1\u0003\u001d\u0019G.^:uKJ\u00042aS*.\u0011\u001d\t)\u0007\u0001C\u0001\u0003w\t\u0001\u0005^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\"\"\u00111MA5!\u0011\t\t%a\u001b\n\t\u00055\u00141\t\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002r\u0001!\t!a\u000f\u0002CQ,7\u000f^+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3)\t\u0005=\u0014Q\u000f\t\u0005\u0003\u0003\n9(\u0003\u0003\u0002z\u0005\r#AB%h]>\u0014X\r\u000b\u0003\u0002p\u0005%\u0004bBA@\u0001\u0011\u0005\u00111H\u00010i\u0016\u001cH/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,GMQ=U_BL7m\u0014<feJLG-\u001a\u0015\u0005\u0003{\nI\u0007C\u0004\u0002\u0006\u0002!\t!a\u000f\u0002]Q,7\u000f^\"mK\u0006tG*Z1eKJ,E.Z2uS>tG)[:bE2,GMQ=U_BL7m\u0014<feJLG-\u001a\u0015\u0005\u0003\u0007\u000b)\b\u000b\u0003\u0002\u0004\u0006%\u0004bBAG\u0001\u0011\u0005\u00111H\u0001.i\u0016\u001cH/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00138wC2LG\rV8qS\u000e|e/\u001a:sS\u0012,\u0007\u0006BAF\u0003SBq!a%\u0001\t\u0003\tY$\u0001\u0012wKJLg-_+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\r\u001a\u0005\b\u0003/\u0003A\u0011AA\u001e\u0003\r2XM]5gsVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0012K7/\u00192mK\u0012Dq!a'\u0001\t\u0013\ti*\u0001\btQV$Hm\\<o'\u0016\u0014h/\u001a:\u0015\u0007a\ny\n\u0003\u0004Z\u00033\u0003\rA\u001a\u0005\b\u0003G\u0003A\u0011BAS\u0003I\u0019wN\\:v[\u0016\fE\u000e\\'fgN\fw-Z:\u0015\r\u0005\u001d\u0016qWA]!\u0011Y5+!+\u0011\t\u0005-\u00161\u0017\b\u0005\u0003[\u000by\u000b\u0005\u0002N1%\u0019\u0011\u0011\u0017\r\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!.\u000b\u0007\u0005E\u0006\u0004C\u0004{\u0003C\u0003\r!!+\t\u000f\u0005m\u0016\u0011\u0015a\u0001-\u0005Ya.^7NKN\u001c\u0018mZ3t\u0011\u001d\ty\f\u0001C\u0001\u0003w\tA\u0005^3tiR{\u0007/[2V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a\u0015\u0005\u0003{\u000bI\u0007C\u0004\u0002F\u0002!I!a2\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0002\u0002JB!\u00111ZAl\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!B1e[&t'\u0002BAj\u0003+\fqa\u00197jK:$8OC\u0002\u0006\u0003?IA!!7\u0002N\nY\u0011\tZ7j]\u000ec\u0017.\u001a8u\u0001")
public class UncleanLeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1 = null;
    private Properties configProps2 = null;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)configProps -> {
            configProps.put("controlled.shutdown.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.enableControlledShutdown())).toString());
            configProps.put("controlled.shutdown.max.retries", "1");
            return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CoreUtils$.MODULE$.delete(server.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable & scala.Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUncleanLeaderElectionEnabled() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Ignore
    @Test
    public void testUncleanLeaderElectionDisabled() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Ignore
    @Test
    public void testCleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        this.intercept((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})))}))), this.servers(), topicProps), ClassTag$.MODULE$.apply(ConfigException.class), new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assert.assertTrue((String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(x$1);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$6(leaderId, x$2)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$8(followerId, x$3))).get();
        followerServer.startup();
        KafkaZkClient x$9 = this.zkClient();
        String x$10 = this.topic();
        int x$11 = this.partitionId();
        Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$13 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$14 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$9, x$10, x$11, x$13, x$14, (Option<Object>)x$12);
        Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    public void verifyUncleanLeaderElectionDisabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assert.assertTrue((String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$6(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$8(followerId, x$4))).get();
        followerServer.startup();
        KafkaZkClient x$17 = this.zkClient();
        String x$18 = this.topic();
        int x$19 = this.partitionId();
        Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        long x$21 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$22 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$17, x$18, x$19, x$21, x$22, (Option<Object>)x$20);
        Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        try {
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
            throw this.fail("Message produced while leader is down should fail, but it succeeded", new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable2).getCause() instanceof TimeoutException)) {
                throw throwable;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
            ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$9(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
                server.startup();
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            KafkaZkClient x$23 = this.zkClient();
            String x$24 = this.topic();
            int x$25 = this.partitionId();
            Some x$26 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            long x$27 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$28 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$23, x$24, x$25, x$27, x$28, (Option<Object>)x$26);
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$11(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            KafkaZkClient x$29 = this.zkClient();
            String x$30 = this.topic();
            int x$31 = this.partitionId();
            Some x$32 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
            long x$33 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$34 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$29, x$30, x$31, x$33, x$34, (Option<Object>)x$32);
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
            return;
        }
    }

    private void shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList;
        String x$35 = brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String x$36 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        boolean x$37 = false;
        StringDeserializer x$38 = new StringDeserializer();
        String x$39 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$40 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$41 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$42 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$43 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$44 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$45 = TestUtils$.MODULE$.createConsumer$default$10();
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$35, x$36, x$39, x$37, x$40, x$41, x$42, x$43, x$44, x$45, x$38);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, TestUtils$.MODULE$.consumeRecords$default$3()).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.value(), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    @Test
    public void testTopicUncleanLeaderElectionEnable() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        AdminZkClient qual$3 = this.adminZkClient();
        String x$46 = this.topic();
        scala.collection.immutable.Map x$47 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        Properties x$48 = qual$3.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
        boolean x$49 = qual$3.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        qual$3.createOrUpdateTopicPartitionAssignmentPathInZK(x$46, (Map)x$47, x$48, x$49);
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$1(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$3(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$4(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$6(followerId, x$6))).get();
        followerServer.startup();
        Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        try {
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
            throw this.fail("Message produced while leader is down should fail, but it succeeded", new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable2).getCause() instanceof TimeoutException)) {
                throw throwable;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
            AdminClient adminClient = this.createAdminClient();
            Properties newProps = new Properties();
            newProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
            TestUtils$.MODULE$.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            adminClient.close();
            KafkaZkClient x$52 = this.zkClient();
            String x$53 = this.topic();
            int x$54 = this.partitionId();
            Some x$55 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
            long x$56 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$57 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$52, x$53, x$54, x$56, x$57, (Option<Object>)x$55);
            Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
            return;
        }
    }

    private AdminClient createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.servers(), new ListenerName("PLAINTEXT"));
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return AdminClient.create((Properties)config);
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        $this.servers_$eq((Seq<KafkaServer>)((Seq)$this.servers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)server, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaServer server) {
        return server.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionEnabled$5(KafkaServer x$1) {
        ControllerStats qual$1 = x$1.kafkaController().controllerContext().stats();
        String x$7 = "UncleanLeaderElectionsPerSec";
        Map x$8 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$7, x$8);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$6(int leaderId$1, KafkaServer x$2) {
        return x$2.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$8(int followerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaServer server) {
        return server.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionDisabled$5(KafkaServer server) {
        ControllerStats qual$2 = server.kafkaController().controllerContext().stats();
        String x$15 = "UncleanLeaderElectionsPerSec";
        Map x$16 = qual$2.removeMetric$default$2();
        qual$2.removeMetric(x$15, x$16);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$6(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$8(int followerId$2, KafkaServer x$4) {
        return x$4.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$9(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$11(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$1(int followerId$3, KafkaServer server) {
        return server.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ void $anonfun$testTopicUncleanLeaderElectionEnable$3(KafkaServer server) {
        ControllerStats qual$4 = server.kafkaController().controllerContext().stats();
        String x$50 = "UncleanLeaderElectionsPerSec";
        Map x$51 = qual$4.removeMetric$default$2();
        qual$4.removeMetric(x$50, x$51);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$4(int leaderId$3, KafkaServer server) {
        return server.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$6(int followerId$3, KafkaServer x$6) {
        return x$6.config().brokerId() == followerId$3;
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

