/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.log.BrokerCompressionTest$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalatest.junit.JUnitSuite;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001\u001d\u0011QC\u0011:pW\u0016\u00148i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016D\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0013[\u0016\u001c8/Y4f\u0007>l\u0007O]3tg&|g\u000e\u0005\u0002\u0016=9\u0011a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0019\ta\u0001\u0010:p_Rt$\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\u0012A\u0002)sK\u0012,g-\u0003\u0002 A\t11\u000b\u001e:j]\u001eT!!\b\u000e\t\u0011\t\u0002!\u0011!Q\u0001\nQ\t\u0011C\u0019:pW\u0016\u00148i\\7qe\u0016\u001c8/[8o\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0019a\u0005K\u0015\u0011\u0005\u001d\u0002Q\"\u0001\u0002\t\u000bM\u0019\u0003\u0019\u0001\u000b\t\u000b\t\u001a\u0003\u0019\u0001\u000b\t\u000f-\u0002!\u0019!C\u0001Y\u00051A/\u001c9ESJ,\u0012!\f\t\u0003]Mj\u0011a\f\u0006\u0003aE\n!![8\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u0005\r&dW\r\u0003\u00047\u0001\u0001\u0006I!L\u0001\bi6\u0004H)\u001b:!\u0011\u001dA\u0004A1A\u0005\u00021\na\u0001\\8h\t&\u0014\bB\u0002\u001e\u0001A\u0003%Q&A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005!A/[7f+\u0005q\u0004CA C\u001b\u0005\u0001%BA!\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0005I\u0001\u0005N_\u000e\\G+[7f\u0011\u0019)\u0005\u0001)A\u0005}\u0005)A/[7fA!9q\t\u0001b\u0001\n\u0003A\u0015!\u00037pO\u000e{gNZ5h+\u0005I\u0005CA\u0014K\u0013\tY%AA\u0005M_\u001e\u001cuN\u001c4jO\"1Q\n\u0001Q\u0001\n%\u000b!\u0002\\8h\u0007>tg-[4!\u0011\u0015y\u0005\u0001\"\u0001Q\u0003!!X-\u0019:E_^tG#A)\u0011\u0005I\u001bV\"\u0001\u000e\n\u0005QS\"\u0001B+oSRD#A\u0014,\u0011\u0005]KV\"\u0001-\u000b\u0005-q\u0011B\u0001.Y\u0005\u0015\te\r^3s\u0011\u0015a\u0006\u0001\"\u0001Q\u0003e!Xm\u001d;Ce>\\WM]*jI\u0016\u001cu.\u001c9sKN\u001c\u0018n\u001c8)\u0005ms\u0006CA,`\u0013\t\u0001\u0007L\u0001\u0003UKN$\b\u0006\u0002\u0001cQ&\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a-\u0002\rI,hN\\3s\u0013\t9GMA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c-\u0002\u000fI,hN\\3sg&\u0011q\u000e\u001c\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000bE\u0014\u0001\u0012\u0001:\u0002+\t\u0013xn[3s\u0007>l\u0007O]3tg&|g\u000eV3tiB\u0011qe\u001d\u0004\u0006\u0003\tA\t\u0001^\n\u0004gVD\bC\u0001*w\u0013\t9(D\u0001\u0004B]f\u0014VM\u001a\t\u0003%fL!A\u001f\u000e\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\u0011\u001aH\u0011\u0001?\u0015\u0003IDQA`:\u0005\u0002}\f!\u0002]1sC6,G/\u001a:t+\t\t\t\u0001\u0005\u0004\u0002\u0004\u0005%\u0011QB\u0007\u0003\u0003\u000bQ1!a\u00022\u0003\u0011)H/\u001b7\n\t\u0005-\u0011Q\u0001\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003\u0002*\u0002\u0010QI1!!\u0005\u001b\u0005\u0015\t%O]1zQ\ri\u0018Q\u0003\t\u0005\u0003/\tIC\u0004\u0003\u0002\u001a\u0005\u0015b\u0002BA\u000e\u0003GqA!!\b\u0002\"9\u0019q#a\b\n\u0003=I!a\u0003\b\n\u00055D\u0016bAA\u0014Y\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a\u000b\u0002.\tQ\u0001+\u0019:b[\u0016$XM]:\u000b\u0007\u0005\u001dB\u000eC\u0005\u00022M\f\t\u0011\"\u0003\u00024\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\u0004\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY$M\u0001\u0005Y\u0006tw-\u0003\u0003\u0002@\u0005e\"AB(cU\u0016\u001cG\u000f")
public class BrokerCompressionTest
extends JUnitSuite {
    private final String messageCompression;
    private final String brokerCompression;
    private final File tmpDir;
    private final File logDir;
    private final MockTime time;
    private final LogConfig logConfig;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBrokerSideCompression() {
        CompressionCodec messageCompressionCode = CompressionCodec$.MODULE$.getCompressionCodec(this.messageCompression);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), this.brokerCompression);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.forId((int)messageCompressionCode.codec()), (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3());
        if (!this.brokerCompression.equals("producer")) {
            CompressionCodec brokerCompressionCode = BrokerCompressionCodec$.MODULE$.getCompressionCodec(this.brokerCompression);
            Assert.assertEquals((String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(brokerCompressionCode.name()).toString(), (long)brokerCompressionCode.codec(), (long)BrokerCompressionTest.readBatch$1((int)0, (Log)log).compressionType().id);
        } else {
            Assert.assertEquals((String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(messageCompressionCode.name()).toString(), (long)messageCompressionCode.codec(), (long)BrokerCompressionTest.readBatch$1((int)0, (Log)log).compressionType().id);
        }
    }

    private static final RecordBatch readBatch$1(int offset, Log log$1) {
        long x$11 = offset;
        int x$12 = 4096;
        None$ x$13 = None$.MODULE$;
        boolean x$14 = false;
        boolean x$15 = true;
        FetchDataInfo fetchInfo = log$1.read(x$11, x$12, (Option)x$13, x$15, x$14);
        return (RecordBatch)fetchInfo.records().batches().iterator().next();
    }

    public BrokerCompressionTest(String messageCompression, String brokerCompression) {
        this.messageCompression = messageCompression;
        this.brokerCompression = brokerCompression;
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.time = new MockTime(0L, 0L);
        this.logConfig = LogConfig$.MODULE$.apply();
    }
}

