/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.LogSegment;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001\u001d\u0011A\u0004T8h\u00072,\u0017M\\3s\u0019\u0006<\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001eD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0015G>l\u0007O]3tg&|gnQ8eK\u000et\u0015-\\3\u0011\u0005UqbB\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\tIb!\u0001\u0004=e>|GO\u0010\u0006\u00027\u0005)1oY1mC&\u0011QDG\u0001\u0007!J,G-\u001a4\n\u0005}\u0001#AB*ue&twM\u0003\u0002\u001e5!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005%\u0001\u0001\"B\n\"\u0001\u0004!\u0002bB\u0014\u0001\u0005\u0004%\t\u0001K\u0001\n[N\u0004VM\u001d%pkJ,\u0012!\u000b\t\u0003U-j\u0011AG\u0005\u0003Yi\u00111!\u00138u\u0011\u0019q\u0003\u0001)A\u0005S\u0005QQn\u001d)fe\"{WO\u001d\u0011\t\u000fA\u0002!\u0019!C\u0001Q\u0005i1m\\7qC\u000e$\u0018n\u001c8MC\u001eDaA\r\u0001!\u0002\u0013I\u0013AD2p[B\f7\r^5p]2\u000bw\r\t\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0003\u0011!\u0018.\\3\u0016\u0003Y\u0002\"!D\u001c\n\u0005ar!\u0001C'pG.$\u0016.\\3\t\ri\u0002\u0001\u0015!\u00037\u0003\u0015!\u0018.\\3!\u0011\u001da\u0004A1A\u0005\u0002u\n\u0001c\u00197fC:,'OQ1dW>3g-T:\u0016\u0003y\u0002\"AK \n\u0005\u0001S\"\u0001\u0002'p]\u001eDaA\u0011\u0001!\u0002\u0013q\u0014!E2mK\u0006tWM\u001d\"bG.|eMZ'tA!9A\t\u0001b\u0001\n\u0003A\u0013aC:fO6,g\u000e^*ju\u0016DaA\u0012\u0001!\u0002\u0013I\u0013\u0001D:fO6,g\u000e^*ju\u0016\u0004\u0003\"\u0002%\u0001\t\u0003J\u0015!B2pI\u0016\u001cW#\u0001&\u0011\u0005-+V\"\u0001'\u000b\u00055s\u0015A\u0002:fG>\u0014HM\u0003\u0002P!\u000611m\\7n_:T!!B)\u000b\u0005I\u001b\u0016AB1qC\u000eDWMC\u0001U\u0003\ry'oZ\u0005\u0003-2\u0013qbQ8naJ,7o]5p]RK\b/\u001a\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cX#\u0001.\u0011\u0007)ZV,\u0003\u0002]5\t)\u0011I\u001d:bsB\u0011alX\u0007\u0002\u001d&\u0011\u0001M\u0014\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0011\u0007\u0001)A\u00055\u0006\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\t\u0005\u0006I\u0002!\t!Z\u0001\fG2,\u0017M\\3s)\u0016\u001cH\u000fF\u0001g!\tQs-\u0003\u0002i5\t!QK\\5uQ\t\u0019'\u000e\u0005\u0002l]6\tAN\u0003\u0002n'\u0006)!.\u001e8ji&\u0011q\u000e\u001c\u0002\u0005)\u0016\u001cH\u000fC\u0003r\u0001\u0011%!/A\u0006sK\u0006$gI]8n\u0019><GCA:}!\r!x/_\u0007\u0002k*\u0011aOG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=v\u0005!IE/\u001a:bE2,\u0007\u0003\u0002\u0016{S%J!a\u001f\u000e\u0003\rQ+\b\u000f\\33\u0011\u0015\u0019\u0001\u000f1\u0001~!\tIa0\u0003\u0002\u0000\u0005\t\u0019Aj\\4\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006\u0005IqO]5uK\u0012+\bo\u001d\u000b\r\u0003\u000f\ti!!\u0005\u0002\u0016\u0005]\u0011\u0011\u0004\t\u0005i\u0006%\u00110C\u0002\u0002\fU\u00141aU3r\u0011\u001d\ty!!\u0001A\u0002%\nqA\\;n\u0017\u0016L8\u000fC\u0004\u0002\u0014\u0005\u0005\u0001\u0019A\u0015\u0002\u000f9,X\u000eR;qg\"11!!\u0001A\u0002uDa\u0001SA\u0001\u0001\u0004Q\u0005bBA\u000e\u0003\u0003\u0001\rAP\u0001\ni&lWm\u001d;b[BDs\u0001AA\u0010\u0003W\ti\u0003\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)\u0003\\\u0001\u0007eVtg.\u001a:\n\t\u0005%\u00121\u0005\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004\\\u0001\beVtg.\u001a:t\u0013\u0011\tI$a\r\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u000f\u001d\tiD\u0001E\u0001\u0003\u007f\tA\u0004T8h\u00072,\u0017M\\3s\u0019\u0006<\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fE\u0002\n\u0003\u00032a!\u0001\u0002\t\u0002\u0005\r3\u0003BA!\u0003\u000b\u00022AKA$\u0013\r\tIE\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f\t\n\t\u0005\"\u0001\u0002NQ\u0011\u0011q\b\u0005\t\u0003#\n\t\u0005\"\u0001\u0002T\u0005aqN\\3QCJ\fW.\u001a;feV\u0011\u0011Q\u000b\t\u0007\u0003/\n\t'!\u001a\u000e\u0005\u0005e#\u0002BA.\u0003;\nA!\u001e;jY*\u0011\u0011qL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002d\u0005e#AC\"pY2,7\r^5p]B\u0019!f\u0017\u000b\t\u0011\u0005%\u0014\u0011\tC\u0001\u0003'\n!\u0002]1sC6,G/\u001a:tQ\u0011\t9'!\u001c\u0011\t\u0005=\u0014\u0011\u0011\b\u0005\u0003c\niH\u0004\u0003\u0002t\u0005md\u0002BA;\u0003sr1aFA<\u0013\u0005!\u0016BA7T\u0013\r\t)\u0004\\\u0005\u0005\u0003\u007f\n\u0019$A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0003\u0007\u000b)I\u0001\u0006QCJ\fW.\u001a;feNTA!a \u00024\u0001")
public class LogCleanerLagIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements Logging {
    private final String compressionCodecName;
    private final int msPerHour;
    private final int compactionLag;
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerLagIntegrationTest logCleanerLagIntegrationTest = this;
        synchronized (logCleanerLagIntegrationTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int compactionLag() {
        return this.compactionLag;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    @Override
    public CompressionType codec() {
        return CompressionType.forName((String)this.compressionCodecName);
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$4 = this.cleanerBackOffMs();
        long x$5 = this.compactionLag();
        int x$6 = this.segmentSize();
        float x$7 = this.makeCleaner$default$2();
        int x$8 = this.makeCleaner$default$3();
        int x$9 = this.makeCleaner$default$5();
        int x$10 = this.makeCleaner$default$7();
        Option<Object> x$11 = this.makeCleaner$default$9();
        Properties x$12 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$3, x$7, x$8, x$4, x$9, x$5, x$10, x$6, x$11, x$12));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log, this.codec(), T0);
        long startSizeBlock0 = log.size();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("total log size at T0: ").append(startSizeBlock0).toString());
        LogSegment activeSegAtT0 = log.activeSegment();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("active segment at T0 has base offset: ").append(activeSegAtT0.baseOffset()).toString());
        int sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("log size up to base offset of active segment at T0: ").append(sizeUpToActiveSegmentAtT0).toString());
        this.cleaner().startup();
        this.time().sleep(this.compactionLag() / 2);
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assert.assertEquals((String)"There should be no cleaning until the compaction lag has passed", (long)startSizeBlock0, (long)log.size());
        this.time().sleep(this.compactionLag() / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log, this.codec(), T1), Seq$.MODULE$.canBuildFrom());
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$14 = activeSegAtT0.baseOffset();
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, x$14, x$15);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends1.toMap(Predef$.MODULE$.$conforms()), (Object)read1.toMap(Predef$.MODULE$.$conforms()));
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("after cleaning the compacted size up to active segment at T0: ").append(compactedSize).toString());
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstBlock1SegmentBaseOffset).append(", but lastCleaned=").append(lastCleaned).toString(), (lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(90).append("log should have been compacted: size up to offset of active segment at T0=").append(sizeUpToActiveSegmentAtT0).append(" compacted size=").append(compactedSize).toString(), (sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log, CompressionType codec, long timestamp) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerLagIntegrationTest.$anonfun$writeDups$1(this, numKeys, log, codec, timestamp, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(LogCleanerLagIntegrationTest $this, Log log$1, CompressionType codec$1, long timestamp$1, int key) {
        int count = $this.counter();
        byte[] x$16 = ((Object)BoxesRunTime.boxToInteger((int)$this.counter())).toString().getBytes();
        CompressionType x$17 = codec$1;
        byte[] x$18 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        long x$19 = timestamp$1;
        byte x$20 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$16, x$18, x$17, x$19, x$20), 0, log$1.appendAsLeader$default$3());
        $this.incCounter();
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(LogCleanerLagIntegrationTest $this, int numKeys$1, Log log$1, CompressionType codec$1, long timestamp$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerLagIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, timestamp$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerLagIntegrationTest(String compressionCodecName) {
        this.compressionCodecName = compressionCodecName;
        Logging.$init$((Logging)this);
        this.msPerHour = 3600000;
        this.compactionLag = 1 * this.msPerHour();
        Assert.assertTrue((String)"compactionLag must be divisible by 2 for this test", (this.compactionLag() % 2 == 0 ? 1 : 0) != 0);
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 512;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

