/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.LogUtils$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0007i6\u0004H)\u001b:\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005%|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012AAR5mK\"1\u0011\u0006\u0001Q\u0001\n\u0001\nq\u0001^7q\t&\u0014\b\u0005C\u0004,\u0001\t\u0007I\u0011A\u0010\u0002\r1|w\rR5s\u0011\u0019i\u0003\u0001)A\u0005A\u00059An\\4ESJ\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005\t\u0004C\u0001\u001a9\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0019\u0019w.\\7p]*\u0011QA\u000e\u0006\u0003o9\ta!\u00199bG\",\u0017BA\u001d4\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Daa\u000f\u0001!\u0002\u0013\t\u0014a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\t\u000fu\u0002!\u0019!C\u0001}\u0005AAn\\4Qe>\u00048/F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011E%\u0001\u0003vi&d\u0017B\u0001#B\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007\r\u0002\u0001\u000b\u0011B \u0002\u00131|w\r\u0015:paN\u0004\u0003b\u0002%\u0001\u0005\u0004%\t!S\u0001\nY><7i\u001c8gS\u001e,\u0012A\u0013\t\u00039-K!\u0001\u0014\u0002\u0003\u00131{wmQ8oM&<\u0007B\u0002(\u0001A\u0003%!*\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011+\u0001\u0003uS6,W#\u0001*\u0011\u0005M\u0019\u0016B\u0001+\u0015\u0005!iunY6US6,\u0007B\u0002,\u0001A\u0003%!+A\u0003uS6,\u0007\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002%\rdW-\u00198fe\u000eCWmY6q_&tGo]\u000b\u00025B!1LY\u0019e\u001b\u0005a&BA/_\u0003\u001diW\u000f^1cY\u0016T!a\u00181\u0002\u0015\r|G\u000e\\3di&|gNC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019GLA\u0002NCB\u0004\"!\u001a4\u000e\u0003\u0001L!a\u001a1\u0003\t1{gn\u001a\u0005\u0007S\u0002\u0001\u000b\u0011\u0002.\u0002'\rdW-\u00198fe\u000eCWmY6q_&tGo\u001d\u0011\u0007\t-\u0004\u0001\u0001\u001c\u0002\u0016\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014Xj\\2l'\tQW\u000e\u0005\u0002\u001d]&\u0011qN\u0001\u0002\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b\"C9k\u0005\u0003\u0005\u000b\u0011\u0002:\u007f\u0003\u001dawn\u001a#jeN\u00042a]>!\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002x\r\u00051AH]8pizJ\u0011!Y\u0005\u0003u\u0002\fq\u0001]1dW\u0006<W-\u0003\u0002}{\n\u00191+Z9\u000b\u0005i\u0004\u0017BA9o\u00111\t\tA\u001bB\u0001B\u0003%\u00111AA\b\u0003\u0011awnZ:\u0011\rM\t)!MA\u0005\u0013\r\t9\u0001\u0006\u0002\u0005!>|G\u000eE\u0002\u001d\u0003\u0017I1!!\u0004\u0003\u0005\raunZ\u0005\u0004\u0003\u0003q\u0007\u0002DA\nU\n\u0005\t\u0015!\u0003\u0002\u0016\u0005\u0005\u0012\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002B\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005}\u0011\u0011\u0004\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\n\u0007\u0005Ma\u000e\u0003\u0004\u001aU\u0012\u0005\u0011Q\u0005\u000b\t\u0003O\tY#!\f\u00020A\u0019\u0011\u0011\u00066\u000e\u0003\u0001Aa!]A\u0012\u0001\u0004\u0011\b\u0002CA\u0001\u0003G\u0001\r!a\u0001\t\u0011\u0005M\u00111\u0005a\u0001\u0003+Aq!a\rk\t\u0003\n)$A\u000bbY2\u001cE.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\u0005]\u0002CBA\u001d\u0003\u0003\nDM\u0004\u0003\u0002<\u0005u\u0002CA;a\u0013\r\ty\u0004Y\u0001\u0007!J,G-\u001a4\n\u0007\r\f\u0019EC\u0002\u0002@\u0001Dq!a\u0012\u0001\t\u0003\tI%\u0001\u0005uK\u0006\u0014Hi\\<o)\t\tY\u0005E\u0002f\u0003\u001bJ1!a\u0014a\u0005\u0011)f.\u001b;)\t\u0005\u0015\u00131\u000b\t\u0005\u0003+\nI&\u0004\u0002\u0002X)\u00111BD\u0005\u0005\u00037\n9FA\u0003BMR,'\u000fC\u0004\u0002`\u0001!\t!!\u0013\u0002qQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e\u0014V\r^;s]NdunZ,ji\"$\u0015N\u001d;jKN$(+\u0019;j_\"\"\u0011QLA2!\u0011\t)&!\u001a\n\t\u0005\u001d\u0014q\u000b\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002l\u0001!\t!!\u0013\u0002sQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001eLuM\\8sKN,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]NDC!!\u001b\u0002d!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005%\u0013\u0001\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:J]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u0003_\n\u0019\u0007C\u0004\u0002x\u0001!\t!!\u0013\u0002)R,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001eLuM\\8sKN\u0014u\u000e\u001e5J]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn]!oIVs7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\"\"\u0011QOA2\u0011\u001d\ti\b\u0001C\u0001\u0003\u0013\nA\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$gj\u001c;D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=EK2,G/\u001a'pONDC!a\u001f\u0002d!9\u00111\u0011\u0001\u0005\u0002\u0005%\u0013\u0001\u0013;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGmQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017pQ8na\u0006\u001cG\u000fR3mKR,Gj\\4tQ\u0011\t\t)a\u0019\t\u000f\u0005%\u0005\u0001\"\u0001\u0002J\u0005\u0011E/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGRdunZ:)\t\u0005\u001d\u00151\r\u0005\b\u0003\u001f\u0003A\u0011AA%\u0003-\"Xm\u001d;M_\u001e\u001cXK\u001c3fe\u000ecW-\u00198va&sW\r\\5hS\ndWMR8s\u0007>l\u0007/Y2uS>t\u0007\u0006BAG\u0003GBq!!&\u0001\t\u0003\tI%\u0001\u0015uKN$8i\u001c8dkJ\u0014XM\u001c;M_\u001e\u001cE.Z1okB\fe\u000e\u001a'pOR\u0013XO\\2bi&|g\u000e\u000b\u0003\u0002\u0014\u0006\r\u0004bBAN\u0001\u0011\u0005\u0011\u0011J\u0001)i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0019><7\t\\3b]V\u0004\u0018I\u001c3U_BL7\rR3mKRLwN\u001c\u0015\u0005\u00033\u000b\u0019\u0007C\u0004\u0002\"\u0002!\t!!\u0013\u0002\u0005R,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u001d>$8i\u001c8tS\u0012,'/\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7\u000f\u000b\u0003\u0002 \u0006\r\u0004bBAT\u0001\u0011\u0005\u0011\u0011J\u0001\u001ci\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_JtuN\\3)\t\u0005\u0015\u00161\r\u0005\b\u0003[\u0003A\u0011AA%\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'\u000fV5nK\"\"\u00111VA2\u0011\u001d\t\u0019\f\u0001C\u0001\u0003\u0013\n\u0001\u0005^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:TQ>\u0014H\u000fV5nK\"\"\u0011\u0011WA2\u0011\u001d\tI\f\u0001C\u0001\u0003\u0013\n!\u0006^3tiVsG-Z2jI\u0016$GK]1og\u0006\u001cG/[8oC2$\u0015\r^1O_R\u001cE.Z1oC\ndW\r\u000b\u0003\u00028\u0006\r\u0004bBA`\u0001\u0011\u0005\u0011\u0011J\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eDC!!0\u0002d!9\u0011Q\u0019\u0001\u0005\u0002\u0005%\u0013\u0001\u0005;fgR$uN\\3EK2,G/\u001b8hQ\u0011\t\u0019-a\u0019\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\u0006!2M]3bi\u0016\u001cE.Z1oKJl\u0015M\\1hKJ$2!\\Ah\u0011\u001d\u0019\u0011\u0011\u001aa\u0001\u0003\u0013Aq!a3\u0001\t\u0013\t\u0019\u000eF\u0003n\u0003+\fI\u000e\u0003\u0005\u0002X\u0006E\u0007\u0019AA\u0002\u0003\u0011\u0001xn\u001c7\t\u0015\u0005m\u0017\u0011\u001bI\u0001\u0002\u0004\ti.\u0001\u0004u_6{7m\u001b\t\u0004K\u0006}\u0017bAAqA\n9!i\\8mK\u0006t\u0007bBAs\u0001\u0011%\u0011q]\u0001\nGJ,\u0017\r^3M_\u001e$\u0002\"!\u0003\u0002j\u0006M\u0018Q \u0005\t\u0003W\f\u0019\u000f1\u0001\u0002n\u0006Y1/Z4nK:$8+\u001b>f!\r)\u0017q^\u0005\u0004\u0003c\u0004'aA%oi\"A\u0011Q_Ar\u0001\u0004\t90A\u0007dY\u0016\fg.\u001e9Q_2L7-\u001f\t\u0005\u0003s\tI0\u0003\u0003\u0002|\u0006\r#AB*ue&tw\r\u0003\u0006\u0002\u0000\u0006\r\b\u0013!a\u0001\u0003[\fQb]3h[\u0016tGo]\"pk:$\bb\u0002B\u0002\u0001\u0011%!QA\u0001\b[\u0006\\W\rT8h)\u0019\tIAa\u0002\u0003\f!I!\u0011\u0002B\u0001!\u0003\u0005\r\u0001I\u0001\u0004I&\u0014\bb\u0002B\u0007\u0005\u0003\u0001\rAS\u0001\u0007G>tg-[4\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014\u00059!/Z2pe\u0012\u001cH\u0003\u0003B\u000b\u0005C\u0011)C!\u000b\u0011\t\t]!QD\u0007\u0003\u00053Q1Aa\u00074\u0003\u0019\u0011XmY8sI&!!q\u0004B\r\u00055iU-\\8ssJ+7m\u001c:eg\"A!1\u0005B\b\u0001\u0004\ti/A\u0002lKfD\u0001Ba\n\u0003\u0010\u0001\u0007\u0011Q^\u0001\u0006m\u0006dW/\u001a\u0005\b\u0005W\u0011y\u00011\u0001e\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0005\u00030\u0001\t\n\u0011\"\u0003\u00032\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0007\u0016\u0005\u0003[\u0014)d\u000b\u0002\u00038A!!\u0011\bB\"\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012!C;oG\",7m[3e\u0015\r\u0011\t\u0005Y\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B#\u0005w\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011I\u0005AI\u0001\n\u0013\u0011Y%\u0001\u0010de\u0016\fG/Z\"mK\u0006tWM]'b]\u0006<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\n\u0016\u0005\u0003;\u0014)\u0004C\u0005\u0003R\u0001\t\n\u0011\"\u0003\u0003T\u0005\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU#f\u0001\u0011\u00036\u0001")
public class LogCleanerManagerTest
extends JUnitSuite
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log2, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.markPartitionUncleanable(log2.dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log3, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp3, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time()).get();
        Assert.assertEquals((Object)log3, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp3, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(log3.dir().getParent(), tp3);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertTrue((boolean)filthiestLog.isEmpty());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3());
        log.onHighWatermarkIncremented(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$1 -> (TopicPartition)x$1._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$14 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$15 = this.makeLog$default$1();
        Log log = this.makeLog(x$15, x$14);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$16 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$17 = this.makeLog$default$1();
        Log log = this.makeLog(x$17, x$16);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$18 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$19 = this.makeLog$default$1();
        Log log = this.makeLog(x$19, x$18);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3());
        }
        this.time().sleep(compactionLag + 1);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$20 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$21 = this.makeLog$default$1();
        Log log = this.makeLog(x$21, x$20);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3());
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, false);
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$22 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$23 = this.makeLog$default$1();
        Log log = this.makeLog(x$23, x$22);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    private LogCleanerManager createCleanerManager(Log log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return this.createCleanerManager((Pool<TopicPartition, Log>)logs, this.createCleanerManager$default$2());
    }

    private LogCleanerManager createCleanerManager(Pool<TopicPartition, Log> pool, boolean toMock) {
        return toMock ? new LogCleanerManagerMock((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null) : new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null);
    }

    private boolean createCleanerManager$default$2() {
        return false;
    }

    private Log createLog(int segmentSize, String cleanupPolicy, int segmentsCount) {
        File partitionDir;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$24 = partitionDir = new File(this.logDir(), "log-0");
        LogConfig x$25 = config;
        long x$26 = 0L;
        long x$27 = 0L;
        MockScheduler x$28 = this.time().scheduler();
        MockTime x$29 = this.time();
        BrokerTopicStats x$30 = new BrokerTopicStats();
        int x$31 = 3600000;
        int x$32 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$33 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$24, x$25, x$26, x$27, (Scheduler)x$28, x$30, (Time)x$29, x$31, x$32, x$33);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentsCount).foreach((Function1 & Serializable & scala.Serializable)i -> LogCleanerManagerTest.$anonfun$createLog$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        return log;
    }

    private int createLog$default$3() {
        return 0;
    }

    private Log makeLog(File dir, LogConfig config) {
        File x$4 = dir;
        LogConfig x$5 = config;
        long x$6 = 0L;
        long x$7 = 0L;
        MockScheduler x$8 = this.time().scheduler();
        MockTime x$9 = this.time();
        BrokerTopicStats x$10 = new BrokerTopicStats();
        int x$11 = 3600000;
        int x$12 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$13 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$4, x$5, x$6, x$7, (Scheduler)x$8, x$10, (Time)x$9, x$11, x$12, x$13);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createLog$2(LogCleanerManagerTest $this, int endOffset$1, LongRef lastTimestamp$1, int offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public static final /* synthetic */ LogSegment $anonfun$createLog$1(LogCleanerManagerTest $this, Log log$2, int i) {
        int startOffset = i * 10;
        int endOffset = startOffset + 10;
        LogSegment segment = LogUtils$.MODULE$.createSegment(startOffset, $this.logDir(), LogUtils$.MODULE$.createSegment$default$3(), LogUtils$.MODULE$.createSegment$default$4());
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startOffset), endOffset).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$createLog$2($this, endOffset, lastTimestamp, BoxesRunTime.unboxToInt((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        segment.append((long)endOffset, lastTimestamp.elem, (long)endOffset, MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
        return log$2.addSegment(segment);
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

