/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerParameterizedIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u0001\u001d\u0011a\u0005T8h\u00072,\u0017M\\3s!\u0006\u0014\u0018-\\3uKJL'0\u001a3J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t\t\u0013IY:ue\u0006\u001cG\u000fT8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti\"AQ\u0002\u0001B\u0001B\u0003%a\"\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011q\u0002\u0007\b\u0003!Y\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0004\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011D\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]!\u0002\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001f?A\u0011\u0011\u0002\u0001\u0005\u0006\u001bm\u0001\rA\u0004\u0005\bC\u0001\u0011\r\u0011\"\u0001#\u0003\u0015\u0019w\u000eZ3d+\u0005\u0019\u0003C\u0001\u0013/\u001b\u0005)#B\u0001\u0014(\u0003\u0019\u0011XmY8sI*\u0011\u0001&K\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015Q#BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001eL!aL\u0013\u0003\u001f\r{W\u000e\u001d:fgNLwN\u001c+za\u0016Da!\r\u0001!\u0002\u0013\u0019\u0013AB2pI\u0016\u001c\u0007\u0005C\u00044\u0001\t\u0007I\u0011\u0001\u001b\u0002\tQLW.Z\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001\bB\u0001\u0006kRLGn]\u0005\u0003u]\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007y\u0001\u0001\u000b\u0011B\u001b\u0002\u000bQLW.\u001a\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001A!\r\t%\tR\u0007\u0002)%\u00111\t\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u000b\u001ak\u0011aJ\u0005\u0003\u000f\u001e\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004J\u0001\u0001\u0006I\u0001Q\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002BQa\u0013\u0001\u0005\u00021\u000b1b\u00197fC:,'\u000fV3tiR\tQ\n\u0005\u0002B\u001d&\u0011q\n\u0006\u0002\u0005+:LG\u000f\u000b\u0002K#B\u0011!+V\u0007\u0002'*\u0011A\u000bL\u0001\u0006UVt\u0017\u000e^\u0005\u0003-N\u0013A\u0001V3ti\")\u0001\f\u0001C\u0001\u0019\u00069C/Z:u\u00072,\u0017M\\:D_6\u0014\u0017N\\3e\u0007>l\u0007/Y2u\u0003:$G)\u001a7fi\u0016$v\u000e]5dQ\t9\u0016\u000bC\u0003\\\u0001\u0011\u0005A*\u0001\u0010uKN$8\t\\3b]\u0016\u0014x+\u001b;i\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;Wa!\u0012!,\u0015\u0005\u0006=\u0002!\t\u0001T\u0001/i\u0016\u001cHo\u00117fC:Lgn\u001a(fgR,G-T3tg\u0006<Wm],ji\"lU\u000f\u001c;ja2,g+\u001a:tS>t7\u000f\u000b\u0002^#\")\u0011\r\u0001C\u0001\u0019\u000692\r\\3b]\u0016\u00148i\u001c8gS\u001e,\u0006\u000fZ1uKR+7\u000f\u001e\u0015\u0003AFCQ\u0001\u001a\u0001\u0005\n\u0015\f\u0001c\u00195fG.d\u0015m\u001d;DY\u0016\fg.\u001a3\u0015\t53\u0007.\u001c\u0005\u0006O\u000e\u0004\rAD\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0006S\u000e\u0004\rA[\u0001\fa\u0006\u0014H/\u001b;j_:LE\r\u0005\u0002BW&\u0011A\u000e\u0006\u0002\u0004\u0013:$\b\"\u00028d\u0001\u0004y\u0017A\u00034jeN$H)\u001b:usB\u0011\u0011\t]\u0005\u0003cR\u0011A\u0001T8oO\")1\u000f\u0001C\u0005i\u0006Q2\r[3dW2{w-\u00114uKJ\f\u0005\u000f]3oI&tw\rR;qgR!Q*^=|\u0011\u0015\u0019!\u000f1\u0001w!\tIq/\u0003\u0002y\u0005\t\u0019Aj\\4\t\u000bi\u0014\b\u0019A8\u0002\u0013M$\u0018M\u001d;TSj,\u0007\"\u0002?s\u0001\u0004i\u0018aB1qa\u0016tGm\u001d\t\u0006}\u0006\u001d\u0011Q\u0002\b\u0004\u007f\u0006\rabA\t\u0002\u0002%\tQ#C\u0002\u0002\u0006Q\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0005-!aA*fc*\u0019\u0011Q\u0001\u000b\u0011\r\u0005\u000byA\u001b\bp\u0013\r\t\t\u0002\u0006\u0002\u0007)V\u0004H.Z\u001a\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\u0005)Ao\\'baR!\u0011\u0011DA\u0016!\u001d\tY\"!\tk\u0003Ki!!!\b\u000b\u0007\u0005}A#\u0001\u0006d_2dWm\u0019;j_:LA!a\t\u0002\u001e\t\u0019Q*\u00199\u0011\u000b\u0005\u000b9CD8\n\u0007\u0005%BC\u0001\u0004UkBdWM\r\u0005\t\u0003[\t\u0019\u00021\u0001\u00020\u0005AQ.Z:tC\u001e,7\u000f\u0005\u0004\u0002\u001c\u0005E\u0012QB\u0005\u0005\u0003g\tiB\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\t1B]3bI\u001a\u0013x.\u001c'pOR!\u0011qFA\u001e\u0011\u0019\u0019\u0011Q\u0007a\u0001m\"9\u0011q\b\u0001\u0005\n\u0005\u0005\u0013!G<sSR,G)\u001e9t'&tw\r\\3NKN\u001c\u0018mZ3TKR$R\"`A\"\u0003\u000f\nY%!\u0014\u0002P\u0005M\u0003bBA#\u0003{\u0001\rA[\u0001\b]Vl7*Z=t\u0011\u001d\tI%!\u0010A\u0002)\fqA\\;n\tV\u00048\u000f\u0003\u0004\u0004\u0003{\u0001\rA\u001e\u0005\u0007C\u0005u\u0002\u0019A\u0012\t\u0013\u0005E\u0013Q\bI\u0001\u0002\u0004Q\u0017\u0001C:uCJ$8*Z=\t\u0011\u0005U\u0013Q\ba\u0001\u0003/\n!\"\\1hS\u000e4\u0016\r\\;f!\r\t\u0015\u0011L\u0005\u0004\u00037\"\"\u0001\u0002\"zi\u0016D\u0011\"a\u0018\u0001#\u0003%I!!\u0019\u0002G]\u0014\u0018\u000e^3EkB\u001c8+\u001b8hY\u0016lUm]:bO\u0016\u001cV\r\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\r\u0016\u0004U\u0006\u00154FAA4!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ED#\u0001\u0006b]:|G/\u0019;j_:LA!!\u001e\u0002l\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3)\u000f\u0001\tI(!\"\u0002\bB!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000M\u000baA];o]\u0016\u0014\u0018\u0002BAB\u0003{\u0012qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002\nB!\u00111RAI\u001b\t\tiIC\u0002\u0002\u0010N\u000bqA];o]\u0016\u00148/\u0003\u0003\u0002\u0014\u00065%!\u0004)be\u0006lW\r^3sSj,GmB\u0004\u0002\u0018\nA\t!!'\u0002M1{wm\u00117fC:,'\u000fU1sC6,G/\u001a:ju\u0016$\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fE\u0002\n\u000373a!\u0001\u0002\t\u0002\u0005u5\u0003BAN\u0003?\u00032!QAQ\u0013\r\t\u0019\u000b\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000fq\tY\n\"\u0001\u0002(R\u0011\u0011\u0011\u0014\u0005\t\u0003W\u000bY\n\"\u0001\u0002.\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0016\u0005\u0005=\u0006CBAY\u0003w\u000by,\u0004\u0002\u00024*!\u0011QWA\\\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0016\u0001\u00026bm\u0006LA!!0\u00024\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007\u0005\u0013e\u0002\u000b\u0003\u0002*\u0006\r\u0007\u0003BAc\u0003/tA!a2\u0002T:!\u0011\u0011ZAi\u001d\u0011\tY-a4\u000f\u0007E\ti-C\u0001.\u0013\t!F&C\u0002\u0002\u0010NKA!!6\u0002\u000e\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!!7\u0002\\\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005U\u0017Q\u0012")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerParameterizedIntegrationTest$.MODULE$.parameters();
    }

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$12 = maxMessageSize;
        float x$13 = this.makeCleaner$default$2();
        int x$14 = this.makeCleaner$default$3();
        long x$15 = this.makeCleaner$default$4();
        long x$16 = this.makeCleaner$default$6();
        int x$17 = this.makeCleaner$default$7();
        int x$18 = this.makeCleaner$default$8();
        Option<Object> x$19 = this.makeCleaner$default$9();
        Properties x$20 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$11, x$13, x$14, x$15, x$12, x$16, x$17, x$18, x$19, x$20));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader(largeMessageSet2, 0, log.appendAsLeader$default$3());
        long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get());
        int x$21 = largeMessageKey + 1;
        int x$22 = 100;
        int x$23 = 3;
        Log x$24 = log;
        CompressionType x$25 = this.codec();
        byte x$26 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$22, x$23, x$24, x$25, x$21, x$26);
        Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        Assert.assertFalse((boolean)checkpoints.contains((Object)this.topicPartitions()[0]));
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Log log;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log2 = log = (Log)tuple2._1();
        Log log3 = log2;
        log3.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastModified_$eq(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> log3.numberOfSegments() == 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There should only be 1 segment remaining", 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)1L, (long)log3.numberOfSegments());
        this.cleaner().shutdown();
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Log log22 = (Log)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)log22, (Object)messages);
        Tuple2 tuple24 = tuple23;
        Log log23 = (Log)tuple24._1();
        Seq messages2 = (Seq)tuple24._2();
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log23);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read));
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        CompressionType compressionType = this.codec();
        CompressionType compressionType2 = CompressionType.ZSTD;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            return;
        }
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        CompressionType compressionType3 = this.codec();
        int n = CompressionType.NONE.equals(compressionType3) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
        int maxMessageSize = n;
        WrappedArray x$37 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$38 = maxMessageSize;
        float x$39 = this.makeCleaner$default$2();
        int x$40 = this.makeCleaner$default$3();
        long x$41 = this.makeCleaner$default$4();
        long x$42 = this.makeCleaner$default$6();
        int x$43 = this.makeCleaner$default$7();
        int x$44 = this.makeCleaner$default$8();
        Option<Object> x$45 = this.makeCleaner$default$9();
        Properties x$46 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$37, x$39, x$40, x$41, x$38, x$42, x$43, x$44, x$45, x$46));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$47 = maxMessageSize;
        Properties x$48 = this.logConfigProperties$default$1();
        float x$49 = this.logConfigProperties$default$3();
        long x$50 = this.logConfigProperties$default$4();
        int x$51 = this.logConfigProperties$default$5();
        int x$52 = this.logConfigProperties$default$6();
        Properties props = this.logConfigProperties(x$48, x$47, x$49, x$50, x$51, x$52);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$53 = 100;
        int x$54 = 3;
        Log x$55 = log;
        CompressionType x$56 = this.codec();
        byte x$57 = 0;
        int x$58 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$53, x$54, x$55, x$56, x$58, x$57);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$59 = 40;
        int x$60 = 3;
        Log x$61 = log;
        CompressionType x$62 = this.codec();
        byte x$63 = 0;
        int x$64 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$59, x$60, x$61, x$62, x$64, x$63);
        LogAppendInfo appendInfo = log.appendAsLeader(largeMessageSet2, 0, log.appendAsLeader$default$3());
        long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$65 = 30;
        int x$66 = 40;
        int x$67 = 3;
        Log x$68 = log;
        CompressionType x$69 = this.codec();
        byte x$70 = 1;
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$66, x$67, x$68, x$69, x$65, x$70);
        int x$71 = 15;
        int x$72 = 5;
        int x$73 = 3;
        Log x$74 = log;
        CompressionType x$75 = this.codec();
        byte x$76 = 2;
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$72, x$73, x$74, x$75, x$71, x$76);
        Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        CompressionType compressionType = this.codec();
        CompressionType compressionType2 = CompressionType.ZSTD;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            return;
        }
        int maxMessageSize = 192;
        WrappedArray x$77 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$78 = maxMessageSize;
        int x$79 = 256;
        float x$80 = this.makeCleaner$default$2();
        int x$81 = this.makeCleaner$default$3();
        long x$82 = this.makeCleaner$default$4();
        long x$83 = this.makeCleaner$default$6();
        int x$84 = this.makeCleaner$default$7();
        Option<Object> x$85 = this.makeCleaner$default$9();
        Properties x$86 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$77, x$80, x$81, x$82, x$78, x$83, x$84, x$79, x$85, x$86));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$87 = maxMessageSize;
        int x$88 = 256;
        Properties x$89 = this.logConfigProperties$default$1();
        float x$90 = this.logConfigProperties$default$3();
        long x$91 = this.logConfigProperties$default$4();
        int x$92 = this.logConfigProperties$default$5();
        Properties props = this.logConfigProperties(x$89, x$87, x$90, x$91, x$92, x$88);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$93 = 2;
        int x$94 = 3;
        Log x$95 = log;
        CompressionType x$96 = this.codec();
        byte x$97 = 0;
        int x$98 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$93, x$94, x$95, x$96, x$98, x$97);
        int x$99 = 2;
        int x$100 = 3;
        int x$101 = 2;
        Log x$102 = log;
        CompressionType x$103 = this.codec();
        byte x$104 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$99, x$101, x$102, x$103, x$100, x$104), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$105 = 4;
        int x$106 = 2;
        int x$107 = 2;
        Log x$108 = log;
        CompressionType x$109 = this.codec();
        byte x$110 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$106, x$107, x$108, x$109, x$105, x$110);
        int x$111 = 4;
        int x$112 = 2;
        int x$113 = 2;
        Log x$114 = log;
        CompressionType x$115 = this.codec();
        byte x$116 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$112, x$113, x$114, x$115, x$111, x$116), Seq$.MODULE$.canBuildFrom());
        int x$117 = 6;
        int x$118 = 2;
        int x$119 = 2;
        Log x$120 = log;
        CompressionType x$121 = this.codec();
        byte x$122 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$118, x$119, x$120, x$121, x$117, x$122), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    @Test
    public void cleanerConfigUpdateTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$123 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$124 = 1L;
        int x$125 = maxMessageSize;
        Some x$126 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$127 = this.makeCleaner$default$2();
        int x$128 = this.makeCleaner$default$3();
        long x$129 = this.makeCleaner$default$6();
        int x$130 = this.makeCleaner$default$7();
        int x$131 = this.makeCleaner$default$8();
        Properties x$132 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$123, x$127, x$128, x$124, x$125, x$129, x$130, x$131, (Option<Object>)x$126, x$132));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assert.assertEquals((long)1L, (long)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assert.assertTrue((String)"Should not have cleaned", (boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty());
        KafkaConfig oldConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
        KafkaConfig newConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize(), this.cleaner().currentConfig().dedupeBufferLoadFactor(), 100000, this.cleaner().currentConfig().maxMessageSize(), this.cleaner().currentConfig().maxIoBytesPerSecond(), this.cleaner().currentConfig().backOffMs(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assert.assertEquals((long)2L, (long)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$133 = topicPartition;
        long x$134 = firstDirty;
        long x$135 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$133, x$134, x$135);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assert.assertTrue((String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstDirty).append(", but lastCleaned=").append(lastCleaned).toString(), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int key = BoxesRunTime.unboxToInt((Object)tuple3._1());
            String value = (String)tuple3._2();
            long offset = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)deepLogEntry -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, Log log, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, numKeys, startKey, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int key = tuple2._1$mcI$sp();
            String payload = (String)tuple2._2();
            SimpleRecord simpleRecord = new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), payload.toString().getBytes());
            return simpleRecord;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log.appendAsLeader$default$3());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get()))).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 kv = (Tuple2)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            return tuple3;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        WrappedArray x$27 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions())).take(1));
        Properties x$28 = logProps$1;
        long x$29 = 100L;
        float x$30 = this.makeCleaner$default$2();
        int x$31 = this.makeCleaner$default$3();
        int x$32 = this.makeCleaner$default$5();
        long x$33 = this.makeCleaner$default$6();
        int x$34 = this.makeCleaner$default$7();
        int x$35 = this.makeCleaner$default$8();
        Option<Object> x$36 = this.makeCleaner$default$9();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$27, x$30, x$31, x$29, x$32, x$33, x$34, x$35, x$36, x$28));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.onHighWatermarkIncremented(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString(), (startSize > (long)compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log, messages);
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.numThreads())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.dedupeBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.dedupeBufferLoadFactor())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.ioBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.maxMessageSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.backOffMs())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.maxIoBytesPerSecond())).toString());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = ((Object)BoxesRunTime.boxToInteger((int)$this.counter())).toString();
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int numKeys$1, int startKey$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerParameterizedIntegrationTest(String compressionCodec) {
        this.codec = CompressionType.forName((String)compressionCodec);
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

