/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.CorruptIndexException;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u000f\tiA+[7f\u0013:$W\r\u001f+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0004\u0019\u0001\u0001\u0007I\u0011A\r\u0002\u0007%$\u00070F\u0001\u001b!\t12$\u0003\u0002\u001d\u0005\tIA+[7f\u0013:$W\r\u001f\u0005\b=\u0001\u0001\r\u0011\"\u0001 \u0003\u001dIG\r_0%KF$\"\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bOu\t\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007S\u0001\u0001\u000b\u0015\u0002\u000e\u0002\t%$\u0007\u0010\t\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0003)i\u0017\r_#oiJLWm]\u000b\u0002[A\u0011\u0011EL\u0005\u0003_\t\u00121!\u00138u\u0011\u0019\t\u0004\u0001)A\u0005[\u0005YQ.\u0019=F]R\u0014\u0018.Z:!\u0011\u001d\u0019\u0004A1A\u0005\u0002Q\n!BY1tK>3gm]3u+\u0005)\u0004CA\u00117\u0013\t9$E\u0001\u0003M_:<\u0007BB\u001d\u0001A\u0003%Q'A\u0006cCN,wJ\u001a4tKR\u0004\u0003\"B\u001e\u0001\t\u0003a\u0014!B:fiV\u0004H#\u0001\u0011)\u0005ir\u0004CA B\u001b\u0005\u0001%BA\u0006\u000f\u0013\t\u0011\u0005I\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\t\u0002!\t\u0001P\u0001\ti\u0016\f'\u000fZ8x]\"\u00121I\u0012\t\u0003\u007f\u001dK!\u0001\u0013!\u0003\u000b\u00053G/\u001a:\t\u000b)\u0003A\u0011\u0001\u001f\u0002\u0015Q,7\u000f\u001e'p_.,\u0006\u000f\u000b\u0002J\u0019B\u0011q(T\u0005\u0003\u001d\u0002\u0013A\u0001V3ti\")\u0001\u000b\u0001C\u0001y\u0005aA/Z:u)J,hnY1uK\"\u0012q\n\u0014\u0005\u0006'\u0002!\t\u0001P\u0001\u000bi\u0016\u001cH/\u00119qK:$\u0007F\u0001*M\u0011\u00151\u0006\u0001\"\u0003X\u00035\t\u0007\u000f]3oI\u0016sGO]5fgR\u0011\u0001\u0005\u0017\u0005\u00063V\u0003\r!L\u0001\u000b]VlWI\u001c;sS\u0016\u001c\b\"B.\u0001\t\u0003a\u0016a\u00058p]\u0016C\u0018n\u001d;b]R$V-\u001c9GS2,G#A/\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017AA5p\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\t\u0019KG.\u001a\u0005\u0006M\u0002!\t\u0001P\u0001\u0010i\u0016\u001cHoU1oSRL8\t[3dW\"\u0012Q\r\u0014")
public class TimeIndexTest
extends JUnitSuite {
    private TimeIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public TimeIndex idx() {
        return this.idx;
    }

    public void idx_$eq(TimeIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new TimeIndex(this.nonExistantTempFile(), this.baseOffset(), this.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        block0: {
            if (this.idx() == null) break block0;
            this.idx().file().delete();
        }
    }

    @Test
    public void testLookUp() {
        Assert.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(100L));
        this.appendEntries(this.maxEntries() - 1);
        Assert.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(9L));
        Assert.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().lookup(25L));
        Assert.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().lookup(30L));
    }

    @Test
    public void testTruncate() {
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncate();
        Assert.assertEquals((long)0L, (long)this.idx().entries());
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncateTo(10L + this.baseOffset());
        Assert.assertEquals((long)0L, (long)this.idx().entries());
    }

    @Test
    public void testAppend() {
        this.appendEntries(this.maxEntries() - 1);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TimeIndex qual$1 = this.idx();
            long x$1 = 10000L;
            long x$2 = 1000L;
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().maybeAppend(10000L, (long)((this.maxEntries() - 2) * 10), true), ClassTag$.MODULE$.apply(InvalidOffsetException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.idx().maybeAppend(10000L, 1000L, true);
    }

    private void appendEntries(int numEntries) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numEntries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            TimeIndex qual$2 = this.idx();
            long x$4 = i * 10;
            long x$5 = (long)(i * 10) + this.baseOffset();
            boolean x$6 = qual$2.maybeAppend$default$3();
            qual$2.maybeAppend(x$4, x$5, x$6);
        });
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistantTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        file.delete();
        return var1_1;
    }

    @Test
    public void testSanityCheck() {
        this.idx().sanityCheck();
        this.appendEntries(5);
        TimestampOffset firstEntry = this.idx().entry(0);
        this.idx().sanityCheck();
        this.idx().close();
        BooleanRef shouldCorruptOffset = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptTimestamp = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptLength = BooleanRef.create((boolean)false);
        this.idx_$eq(new TimeIndex(this, firstEntry, shouldCorruptOffset, shouldCorruptTimestamp, shouldCorruptLength){
            private final TimestampOffset firstEntry$1;
            private final BooleanRef shouldCorruptOffset$1;
            private final BooleanRef shouldCorruptTimestamp$1;
            private final BooleanRef shouldCorruptLength$1;

            public TimestampOffset lastEntry() {
                TimestampOffset superLastEntry = super.lastEntry();
                long offset = this.shouldCorruptOffset$1.elem ? this.baseOffset() - 1L : superLastEntry.offset();
                long timestamp = this.shouldCorruptTimestamp$1.elem ? this.firstEntry$1.timestamp() - 1L : superLastEntry.timestamp();
                return new TimestampOffset(timestamp, offset);
            }

            /*
             * WARNING - void declaration
             */
            public long length() {
                void var1_1;
                long superLength = super.length();
                return this.shouldCorruptLength$1.elem ? superLength - 1L : var1_1;
            }
            {
                this.firstEntry$1 = firstEntry$1;
                this.shouldCorruptOffset$1 = shouldCorruptOffset$1;
                this.shouldCorruptTimestamp$1 = shouldCorruptTimestamp$1;
                this.shouldCorruptLength$1 = shouldCorruptLength$1;
                super($outer.idx().file(), $outer.baseOffset(), $outer.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4());
            }
        });
        shouldCorruptOffset.elem = true;
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        shouldCorruptOffset.elem = false;
        shouldCorruptTimestamp.elem = true;
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        shouldCorruptTimestamp.elem = false;
        shouldCorruptLength.elem = true;
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.idx().sanityCheck(), ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        shouldCorruptLength.elem = false;
        this.idx().sanityCheck();
        this.idx().close();
    }

    public TimeIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

