/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.Serializable;
import java.util.Properties;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005Aa.^7O_\u0012,7/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u00139,XNT8eKN\u0004\u0003bB\u0013\u0001\u0005\u0004%\taG\u0001\t]Vl\u0007+\u0019:ug\"1q\u0005\u0001Q\u0001\nq\t\u0011B\\;n!\u0006\u0014Ho\u001d\u0011\t\u000f%\u0002!\u0019!C\u0001U\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019!\u0004\u0001)A\u0005W\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\u0006m\u0001!\taN\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t\u0001\bE\u0002:\u0003\u0012s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011A\u0002\u001fs_>$h(C\u0001 \u0013\t\u0001e$A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%aA*fc*\u0011\u0001I\b\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0012\taa]3sm\u0016\u0014\u0018BA%G\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f-\u0003!\u0019!C\u00017\u0005Ia.T3tg\u0006<Wm\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u000f\u0002\u00159lUm]:bO\u0016\u001c\b\u0005C\u0003P\u0001\u0011\u0005\u0001+A\u0013uKN$X*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u00114uKJ$U\r\\3uS:<Gk\u001c9jGR\t\u0011\u000b\u0005\u0002\u001e%&\u00111K\b\u0002\u0005+:LG\u000f\u000b\u0002O+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0006UVt\u0017\u000e\u001e\u0006\u00025\u0006\u0019qN]4\n\u0005q;&\u0001\u0002+fgRDQA\u0018\u0001\u0005\u0002A\u000bA\u0007^3ti\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m]+oe\u0016<\u0017n\u001d;fe\u0016$\u0017I\u001a;fe\u0012+G.\u001a;j]\u001e$v\u000e]5dQ\tiV\u000bC\u0003b\u0001\u0011\u0005\u0001+A\nuKN$8\t\\;ti\u0016\u0014\u0018\nZ'fiJL7\r\u000b\u0002a+\")A\r\u0001C\u0001!\u0006AB/Z:u/&tGm\\<t'RLH.\u001a+bO:\u000bW.Z:)\u0005\r,\u0006\"B4\u0001\t\u0003\u0001\u0016\u0001\t;fgR\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:CsR,7/\u00138PkRD#AZ+\t\u000b)\u0004A\u0011\u0001)\u0002+Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe6+GO]5dg\"\u0012\u0011.\u0016\u0005\u0006[\u0002!\t\u0001U\u0001!i\u0016\u001cHoU3tg&|g.\u0012=qSJ,G*[:uK:,'/T3ue&\u001c7\u000f\u000b\u0002m+\")\u0001\u000f\u0001C\u0005c\u0006QQ.\u001a;fe\u000e{WO\u001c;\u0015\u0005I,\bCA\u000ft\u0013\t!hD\u0001\u0003M_:<\u0007\"\u0002<p\u0001\u00049\u0018AC7fiJL7MT1nKB\u0011\u0001\u0010 \b\u0003sj\u0004\"a\u000f\u0010\n\u0005mt\u0012A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a\u001f\u0010\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\u0005\tBo\u001c9jG6+GO]5d\u000fJ|W\u000f]:\u0015\t\u0005\u0015\u0011\u0011\u0003\t\u0006\u0003\u000f\tia^\u0007\u0003\u0003\u0013Q1!a\u0003\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\tIAA\u0002TKRDa!a\u0005\u0000\u0001\u00049\u0018!\u0002;pa&\u001c\u0007")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((String)"Topic metrics don't exist", (boolean)this.topicMetricGroups(topic).nonEmpty());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, s);
            return BoxedUnit.UNIT;
        });
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(x$2))), (long)1L);
    }

    @Test
    public void testWindowsStyleTagNames() {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((TraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = KafkaMetricsGroup$.MODULE$.metricName("test-metric", tags);
        String $org_scalatest_assert_macro_left = metric.getMBeanName();
        String $org_scalatest_assert_macro_right = expectedMBeanName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, server);
            return BoxedUnit.UNIT;
        });
        long initialReplicationBytesIn = this.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = this.meterCount(replicationBytesOut);
        long initialBytesIn = this.meterCount(bytesIn);
        long initialBytesOut = this.meterCount(bytesOut);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assert.assertTrue((this.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        Assert.assertEquals((long)initialBytesOut, (long)this.meterCount(bytesOut));
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages() * 2, TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assert.assertTrue((this.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testControllerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$1(x$5))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$2(x$6))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$3(x$7))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$4(x$8))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$5(x$9))), (long)1L);
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$10))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$11))), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$12))), (long)1L);
    }

    private long meterCount(String metricName) {
        return ((Meter)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$meterCount$1(metricName, x$13))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162)))).count();
    }

    private Set<String> topicMetricGroups(String topic) {
        Regex topicMetricRegex = new Regex(new StringBuilder(25).append(".*BrokerTopicMetrics.*(").append(topic).append(")$").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return (Set)metricGroups.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$topicMetricGroups$1(topicMetricRegex, x$14)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaServer s) {
        Assert.assertNotNull((Object)s.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.server:type=KafkaServer,name=ClusterId";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$15 = new TopicPartition(topic$2, 0);
        boolean x$16 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$15, x$16);
        int brokerId = server.config().brokerId();
        Option logSize = log.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()));
        Assert.assertTrue((String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString(), (boolean)BoxesRunTime.unboxToBoolean((Object)logSize.map((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0L).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$1(MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$2(MetricName x$6) {
        String string = x$6.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$3(MetricName x$7) {
        String string = x$7.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$4(MetricName x$8) {
        String string = x$8.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$5(MetricName x$9) {
        String string = x$9.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(MetricName x$10) {
        String string = x$10.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(MetricName x$11) {
        String string = x$11.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$meterCount$1(String metricName$1, MetricName x$13) {
        return x$13.getMBeanName().endsWith(metricName$1);
    }

    public static final /* synthetic */ boolean $anonfun$topicMetricGroups$1(Regex topicMetricRegex$1, String x$14) {
        return topicMetricRegex$1.pattern().matcher(x$14).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }
}

