/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u0001\u001d\u0011!\u0004R=oC6L7mQ8o]\u0016\u001cG/[8o#V|G/\u0019+fgRT!a\u0001\u0003\u0002\u000f9,Go^8sW*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011QB\u0003\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t%F\u0001\u000b]Vl'I]8lKJ\u001cX#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG\u000fC\u0004\u001e\u0001\t\u0007I\u0011\u0001\u0010\u0002\u000bQ|\u0007/[2\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\t1\fgn\u001a\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0004TiJLgn\u001a\u0005\u0007Q\u0001\u0001\u000b\u0011B\u0010\u0002\rQ|\u0007/[2!\u0011\u0015Q\u0003\u0001\"\u0011,\u0003\u0015\u0019X\r^+q)\u0005a\u0003CA\f.\u0013\tq\u0003D\u0001\u0003V]&$\bFA\u00151!\t\td'D\u00013\u0015\t\u0019D'A\u0003kk:LGOC\u00016\u0003\ry'oZ\u0005\u0003oI\u0012aAQ3g_J,\u0007\"B\u001d\u0001\t\u0003Y\u0013A\u0007;fgR$\u0015P\\1nS\u000e\u001cuN\u001c8fGRLwN\\)v_R\f\u0007F\u0001\u001d<!\t\tD(\u0003\u0002>e\t!A+Z:u\u0011\u0015y\u0004\u0001\"\u0003A\u0003I\u0011XmY8oM&<WO]3TKJ4XM]:\u0015\t1\n\u0015J\u0014\u0005\u0006\u0005z\u0002\raQ\u0001\t]\u0016<\bK]8qgB\u0011AiR\u0007\u0002\u000b*\u0011aiI\u0001\u0005kRLG.\u0003\u0002I\u000b\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b)s\u0004\u0019A&\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u0004\"a\u0006'\n\u00055C\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001fz\u0002\r\u0001U\u0001\u000eCB\u0013x\u000e\u001d+p-\u0016\u0014\u0018NZ=\u0011\t]\t6kU\u0005\u0003%b\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001+\\\u001d\t)\u0016\f\u0005\u0002W15\tqK\u0003\u0002Y\r\u00051AH]8pizJ!A\u0017\r\u0002\rA\u0013X\rZ3g\u0013\t1CL\u0003\u0002[1!)a\f\u0001C\u0005?\u0006\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0015\u0003\u0001\u0004\"!Y5\u000e\u0003\tT!a\u00193\u0002\u000b\u0005$W.\u001b8\u000b\u0005\u00154\u0017aB2mS\u0016tGo\u001d\u0006\u0003\u000b\u001dT!\u0001\u001b\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tQ'MA\u0006BI6Lgn\u00117jK:$\b\"\u00027\u0001\t\u0013i\u0017!F<bSR4uN]\"p]\u001aLwm\u00148TKJ4XM\u001d\u000b\u0005Y9\u0004(\u000fC\u0003pW\u0002\u00071+\u0001\u0005qe>\u0004h*Y7f\u0011\u0015\t8\u000e1\u0001T\u0003%\u0001(o\u001c9WC2,X\rC\u0004tWB\u0005\t\u0019\u0001;\u0002\u00135\f\u0007pV1ji6\u001b\bCA\fv\u0013\t1\bD\u0001\u0003M_:<\u0007\"\u0002=\u0001\t\u0013I\u0018AE:f]\u0012\u0004&o\u001c3vG\u0016\u0014V-];fgR$\u0012A\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018\u0001\u0003:fcV,7\u000f^:\u000b\u0005}4\u0017AB2p[6|g.C\u0002\u0002\u0004q\u0014q\u0002\u0015:pIV\u001cWMU3ta>t7/\u001a\u0005\n\u0003\u000f\u0001\u0011\u0013!C\u0005\u0003\u0013\tqd^1ji\u001a{'oQ8oM&<wJ\\*feZ,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYAK\u0002u\u0003\u001bY#!a\u0004\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033A\u0012AC1o]>$\u0018\r^5p]&!\u0011QDA\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;

    @Override
    public int numBrokers() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), this.numBrokers(), this.numBrokers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testDynamicConnectionQuota() {
        SocketServer socketServer = ((KafkaServer)this.servers().head()).socketServer();
        InetAddress localAddress = InetAddress.getByName("127.0.0.1");
        int initialConnectionCount = DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress);
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), (Object)((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection count mismatch", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress)), maxConnectionsPerIP - 1).map((Function1 & Serializable & scala.Serializable)x$1 -> DynamicConnectionQuotaTest.connect$1(socketServer, DynamicConnectionQuotaTest.connect$default$2$1(), DynamicConnectionQuotaTest.connect$default$3$1()), IndexedSeq$.MODULE$.canBuildFrom());
        ProduceResponse produceResponse = this.sendProduceRequest();
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
        Tuple2 tuple23 = tuple22;
        TopicPartition tp2 = (TopicPartition)tuple23._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse2.error);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress) == maxConnectionsPerIP - 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "produce request connection is not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        conns = (IndexedSeq)conns.$colon$plus((Object)DynamicConnectionQuotaTest.connect$1(socketServer, DynamicConnectionQuotaTest.connect$default$2$1(), DynamicConnectionQuotaTest.connect$default$3$1()), IndexedSeq$.MODULE$.canBuildFrom());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> this.sendProduceRequest(), ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        conns.foreach((Function1 & Serializable & scala.Serializable)conn -> {
            conn.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection count mismatch", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        int maxConnectionsPerIPOverride = 7;
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), (Object)new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection count mismatch", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress)), maxConnectionsPerIPOverride - 1).map((Function1 & Serializable & scala.Serializable)x$3 -> DynamicConnectionQuotaTest.connect$1(socketServer, DynamicConnectionQuotaTest.connect$default$2$1(), DynamicConnectionQuotaTest.connect$default$3$1()), IndexedSeq$.MODULE$.canBuildFrom());
        produceResponse = this.sendProduceRequest();
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple24 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        TopicPartition tp1 = (TopicPartition)tuple24._1();
        ProduceResponse.PartitionResponse partitionResponse1 = (ProduceResponse.PartitionResponse)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)tp1, (Object)partitionResponse1);
        Tuple2 tuple26 = tuple25;
        TopicPartition tp12 = (TopicPartition)tuple26._1();
        ProduceResponse.PartitionResponse partitionResponse12 = (ProduceResponse.PartitionResponse)tuple26._2();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse12.error);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress) == maxConnectionsPerIPOverride - 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "produce request connection is not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        conns = (IndexedSeq)conns.$colon$plus((Object)DynamicConnectionQuotaTest.connect$1(socketServer, DynamicConnectionQuotaTest.connect$default$2$1(), DynamicConnectionQuotaTest.connect$default$3$1()), IndexedSeq$.MODULE$.canBuildFrom());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> this.sendProduceRequest(), ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        ((Socket)conns.head()).close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress) == maxConnectionsPerIPOverride - 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "connection is not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.sendProduceRequest();
    }

    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        AdminClient adminClient = this.createAdminClient();
        TestUtils$.MODULE$.alterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, perBrokerConfig).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), this.waitForConfigOnServer$default$3());
        adminClient.close();
    }

    /*
     * WARNING - void declaration
     */
    private AdminClient createAdminClient() {
        void var3_3;
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        AdminClient adminClient = AdminClient.create((Properties)config);
        return var3_3;
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$.MODULE$.retry(maxWaitMs, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.assertEquals((Object)propValue, ((KafkaServer)this.servers().head()).config().originals().get(propName)));
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    private ProduceResponse sendProduceRequest() {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceRequest request = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.PRODUCE, ((KafkaServer)this.servers().head()).socketServer(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ProduceResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private static final Socket connect$1(SocketServer socketServer, SecurityProtocol protocol, InetAddress localAddr) {
        return new Socket("localhost", socketServer.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)), localAddr, 0);
    }

    private static final SecurityProtocol connect$default$2$1() {
        return SecurityProtocol.PLAINTEXT;
    }

    private static final InetAddress connect$default$3$1() {
        return null;
    }

    private static final int connectionCount$1(SocketServer socketServer$1, InetAddress localAddress$1) {
        return socketServer$1.connectionCount(localAddress$1);
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
    }
}

