/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.Group$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rEb\u0001B\u0001\u0003\u0001%\u0011qcU5na2,\u0017i\u00197BkRDwN]5{KJ$Vm\u001d;\u000b\u0005\r!\u0011\u0001B1vi\"T!!\u0002\u0004\u0002\u0011M,7-\u001e:jifT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tAB\u0003\u0002\u000e\r\u0005\u0011!p[\u0005\u0003\u001f1\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\n]\tA\"\u00197m_^\u0014V-\u00193BG2,\u0012\u0001\u0007\t\u0003)eI!A\u0007\u0002\u0003\u0007\u0005\u001bG\u000e\u0003\u0004\u001d\u0001\u0001\u0006I\u0001G\u0001\u000eC2dwn\u001e*fC\u0012\f5\r\u001c\u0011\t\u000fy\u0001!\u0019!C\u0005/\u0005i\u0011\r\u001c7po^\u0013\u0018\u000e^3BG2Da\u0001\t\u0001!\u0002\u0013A\u0012AD1mY><xK]5uK\u0006\u001bG\u000e\t\u0005\bE\u0001\u0011\r\u0011\"\u0003\u0018\u0003-!WM\\=SK\u0006$\u0017i\u00197\t\r\u0011\u0002\u0001\u0015!\u0003\u0019\u00031!WM\\=SK\u0006$\u0017i\u00197!\u0011\u001d1\u0003A1A\u0005\n\u001d\n\u0001c^5mI\u000e\u000b'\u000f\u001a*fg>,(oY3\u0016\u0003!\u0002\"\u0001F\u0015\n\u0005)\u0012!\u0001\u0003*fg>,(oY3\t\r1\u0002\u0001\u0015!\u0003)\u0003E9\u0018\u000e\u001c3DCJ$'+Z:pkJ\u001cW\r\t\u0005\b]\u0001\u0011\r\u0011\"\u0003(\u0003A\u0001(/\u001a4jq\u0016$'+Z:pkJ\u001cW\r\u0003\u00041\u0001\u0001\u0006I\u0001K\u0001\u0012aJ,g-\u001b=fIJ+7o\\;sG\u0016\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%IaM\u0001\u0014g&l\u0007\u000f\\3BG2\fU\u000f\u001e5pe&TXM]\u000b\u0002iA\u0011A#N\u0005\u0003m\t\u00111cU5na2,\u0017i\u00197BkRDwN]5{KJDa\u0001\u000f\u0001!\u0002\u0013!\u0014\u0001F:j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014\b\u0005C\u0004;\u0001\t\u0007I\u0011B\u001a\u0002)MLW\u000e\u001d7f\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:3\u0011\u0019a\u0004\u0001)A\u0005i\u0005)2/[7qY\u0016\f5\r\\!vi\"|'/\u001b>feJ\u0002\u0003\"\u0003 \u0001\u0001\u0004\u0005\r\u0011\"\u0003(\u0003!\u0011Xm]8ve\u000e,\u0007\"\u0003!\u0001\u0001\u0004\u0005\r\u0011\"\u0003B\u00031\u0011Xm]8ve\u000e,w\fJ3r)\t\u0011\u0005\n\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0003V]&$\bbB%@\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0004\"C&\u0001\u0001\u0004\u0005\t\u0015)\u0003)\u0003%\u0011Xm]8ve\u000e,\u0007\u0005C\u0004N\u0001\t\u0007I\u0011\u0002(\u0002\u0015M,\b/\u001a:Vg\u0016\u00148/F\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003mC:<'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013aa\u0015;sS:<\u0007B\u0002-\u0001A\u0003%q*A\u0006tkB,'/V:feN\u0004\u0003b\u0002.\u0001\u0005\u0004%IAT\u0001\tkN,'O\\1nK\"1A\f\u0001Q\u0001\n=\u000b\u0011\"^:fe:\fW.\u001a\u0011\t\u000fy\u0003!\u0019!C\u0005?\u0006I\u0001O]5oG&\u0004\u0018\r\\\u000b\u0002AB\u0011\u0011m[\u0007\u0002E*\u00111a\u0019\u0006\u0003\u000b\u0011T!!\u001a4\u0002\r\r|W.\\8o\u0015\t9qM\u0003\u0002iS\u00061\u0011\r]1dQ\u0016T\u0011A[\u0001\u0004_J<\u0017B\u00017c\u00059Y\u0015MZ6b!JLgnY5qC2DaA\u001c\u0001!\u0002\u0013\u0001\u0017A\u00039sS:\u001c\u0017\u000e]1mA!9\u0001\u000f\u0001b\u0001\n\u0013\t\u0018aB:fgNLwN\\\u000b\u0002eB\u00111o \b\u0003irt!!\u001e>\u000f\u0005YLX\"A<\u000b\u0005aD\u0011A\u0002\u001fs_>$h(C\u0001\b\u0013\tYh!A\u0004oKR<xN]6\n\u0005ut\u0018A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0006\u0003w\u001aIA!!\u0001\u0002\u0004\t91+Z:tS>t'BA?\u007f\u0011\u001d\t9\u0001\u0001Q\u0001\nI\f\u0001b]3tg&|g\u000e\t\u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0013\ti!\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+1\u0011AB:feZ,'/\u0003\u0003\u0002\u001a\u0005M!aC&bM.\f7i\u001c8gS\u001eD1\"!\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002 \u0005Q1m\u001c8gS\u001e|F%Z9\u0015\u0007\t\u000b\t\u0003C\u0005J\u00037\t\t\u00111\u0001\u0002\u0010!Y\u0011Q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\b\u0003\u001d\u0019wN\u001c4jO\u0002B1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\u0005y!p\\8LK\u0016\u0004XM]\"mS\u0016tG/\u0006\u0002\u0002.A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024\u0019\t\u0011B_8pW\u0016,\u0007/\u001a:\n\t\u0005]\u0012\u0011\u0007\u0002\u00105>|7*Z3qKJ\u001cE.[3oi\"Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0003MQxn\\&fKB,'o\u00117jK:$x\fJ3r)\r\u0011\u0015q\b\u0005\n\u0013\u0006e\u0012\u0011!a\u0001\u0003[A1\"a\u0011\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002.\u0005\u0001\"p\\8LK\u0016\u0004XM]\"mS\u0016tG\u000f\t\u0004\u0007\u0003\u000f\u0002\u0001!!\u0013\u0003\u001f\r+8\u000f^8n!JLgnY5qC2\u001c2!!\u0012a\u0011-\ti%!\u0012\u0003\u0002\u0003\u0006I!a\u0014\u0002\u001bA\u0014\u0018N\\2ja\u0006dG+\u001f9f!\u0011\t\t&!\u0017\u000f\t\u0005M\u0013Q\u000b\t\u0003m\u0012K1!a\u0016E\u0003\u0019\u0001&/\u001a3fM&\u0019a+a\u0017\u000b\u0007\u0005]C\tC\u0006\u0002`\u0005\u0015#\u0011!Q\u0001\n\u0005=\u0013\u0001\u00028b[\u0016Dq!EA#\t\u0003\t\u0019\u0007\u0006\u0004\u0002f\u0005%\u00141\u000e\t\u0005\u0003O\n)%D\u0001\u0001\u0011!\ti%!\u0019A\u0002\u0005=\u0003\u0002CA0\u0003C\u0002\r!a\u0014\t\u0011\u0005=\u0014Q\tC!\u0003c\na!Z9vC2\u001cH\u0003BA:\u0003s\u00022aQA;\u0013\r\t9\b\u0012\u0002\b\u0005>|G.Z1o\u0011!\tY(!\u001cA\u0002\u0005u\u0014!A8\u0011\u0007\r\u000by(C\u0002\u0002\u0002\u0012\u00131!\u00118z\u0011\u001d\t)\t\u0001C!\u0003\u000f\u000bQa]3u+B$\u0012A\u0011\u0015\u0005\u0003\u0007\u000bY\t\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t*[\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003+\u000byI\u0001\u0004CK\u001a|'/\u001a\u0005\b\u00033\u0003A\u0011IAD\u0003!!X-\u0019:E_^t\u0007\u0006BAL\u0003;\u0003B!!$\u0002 &!\u0011\u0011UAH\u0005\u0015\te\r^3s\u0011\u001d\t)\u000b\u0001C\u0001\u0003\u000f\u000b\u0001\u0006^3ti\u0006+H\u000f[8sSj,G\u000b\u001b:poN|eNT8oK2KG/\u001a:bYJ+7o\\;sG\u0016D\u0003\"a)\u0002*\u0006=\u0016\u0011\u0017\t\u0005\u0003\u001b\u000bY+\u0003\u0003\u0002.\u0006=%\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003g\u0003B!!.\u0002@:!\u0011qWA^\u001d\r1\u0018\u0011X\u0005\u0002\u000b&\u0019\u0011Q\u0018#\u0002\u000fA\f7m[1hK&!\u0011\u0011YAb\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0004\u0003{#\u0005bBAd\u0001\u0011\u0005\u0011qQ\u0001#i\u0016\u001cH/Q;uQ>\u0014\u0018N_3XSRDW)\u001c9usJ+7o\\;sG\u0016t\u0015-\\3)\t\u0005\u0015\u0017\u0011\u0016\u0005\b\u0003\u001b\u0004A\u0011AAD\u0003m!Xm\u001d;F[B$\u00180Q2m)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"B\u00111ZAU\u0003_\u000b\t\fC\u0004\u0002T\u0002!\t!a\"\u0002\u0019Q,7\u000f\u001e+pa&\u001c\u0017i\u00197)\t\u0005E\u0017\u0011\u0016\u0005\b\u00033\u0004A\u0011AAD\u0003\t\"Xm\u001d;BY2|w/Q2dKN\u001cx+\u001b;i\u0007V\u001cHo\\7Qe&t7-\u001b9bY\"\"\u0011q[AU\u0011\u001d\ty\u000e\u0001C\u0001\u0003\u000f\u000bq\u0003^3ti\u0012+g.\u001f+bW\u0016\u001c\bK]3dK\u0012,gnY3)\t\u0005u\u0017\u0011\u0016\u0005\b\u0003K\u0004A\u0011AAD\u0003I!Xm\u001d;BY2|w/\u00117m\u0003\u000e\u001cWm]:)\t\u0005\r\u0018\u0011\u0016\u0005\b\u0003W\u0004A\u0011AAD\u0003Y!Xm\u001d;TkB,'/V:fe\"\u000b7/Q2dKN\u001c\b\u0006BAu\u0003SCq!!=\u0001\t\u0003\t9)A\u0015uKN$8+\u001e9feV\u001bXM],ji\"\u001cUo\u001d;p[B\u0013\u0018N\\2ja\u0006d\u0007*Y:BG\u000e,7o\u001d\u0015\u0005\u0003_\fI\u000bC\u0004\u0002x\u0002!\t!a\"\u0002!Q,7\u000f^,jY\u0012\u001c\u0015M\u001d3BG2\u001c\b\u0006BA{\u0003SCq!!@\u0001\t\u0003\t9)\u0001\buKN$hj\\!dY\u001a{WO\u001c3)\t\u0005m\u0018\u0011\u0016\u0005\b\u0005\u0007\u0001A\u0011AAD\u0003Y!Xm\u001d;O_\u0006\u001bGNR8v]\u0012|e/\u001a:sS\u0012,\u0007\u0006\u0002B\u0001\u0003SCqA!\u0003\u0001\t\u0003\t9)A\u000buKN$\u0018i\u00197NC:\fw-Z7f]R\f\u0005+S:)\t\t\u001d\u0011\u0011\u0016\u0005\b\u0005\u001f\u0001A\u0011AAD\u00035!Xm\u001d;M_\u0006$7)Y2iK\"\"!QBAU\u0011\u001d\u0011)\u0002\u0001C\u0001\u0003\u000f\u000b\u0001\u0004^3ti\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feRKW.\u001b8hQ\u0011\u0011\u0019\"!+\t\u000f\tm\u0001\u0001\"\u0001\u0002\b\u0006iC/Z:u\u0019>\u001c\u0017\r\\\"p]\u000e,(O]3oi6{G-\u001b4jG\u0006$\u0018n\u001c8PMJ+7o\\;sG\u0016\f5\r\\:)\t\te\u0011\u0011\u0016\u0005\b\u0005C\u0001A\u0011AAD\u0003M\"Xm\u001d;ESN$(/\u001b2vi\u0016$7i\u001c8dkJ\u0014XM\u001c;N_\u0012Lg-[2bi&|gn\u00144SKN|WO]2f\u0003\u000ed7\u000f\u000b\u0003\u0003 \u0005%\u0006b\u0002B\u0014\u0001\u0011\u0005\u0011qQ\u0001.i\u0016\u001cH\u000fS5hQ\u000e{gnY;se\u0016t7-_'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\b\u0006\u0002B\u0013\u0003SCqA!\f\u0001\t\u0003\t9)\u0001\nuKN$\u0018i\u00197J]\",'/\u001b;b]\u000e,\u0007\u0006\u0002B\u0016\u0003SCqAa\r\u0001\t\u0013\u0011)$A\fuKN$\u0018*\u001c9mS\u000e\fG/[8og>3\u0017\t\u001c7poR)!Ia\u000e\u0003B!A!\u0011\bB\u0019\u0001\u0004\u0011Y$\u0001\u0005qCJ,g\u000e^(q!\r!\"QH\u0005\u0004\u0005\u007f\u0011!!C(qKJ\fG/[8o\u0011!\u0011\u0019E!\rA\u0002\t\u0015\u0013AC1mY><X\rZ(qgB1\u0011\u0011\u000bB$\u0005wIAA!\u0013\u0002\\\t\u00191+\u001a;\t\u000f\t5\u0003\u0001\"\u0003\u0003P\u00051B/Z:u\u00136\u0004H.[2bi&|gn](g\t\u0016t\u0017\u0010F\u0003C\u0005#\u0012\u0019\u0006\u0003\u0005\u0003:\t-\u0003\u0019\u0001B\u001e\u0011!\u0011)Fa\u0013A\u0002\t\u0015\u0013!\u00033f]&,Gm\u00149t\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003\u000f\u000b\u0011\u0006^3ti\"Kw\r[\"p]\u000e,(O]3oGf$U\r\\3uS>twJ\u001a*fg>,(oY3BG2\u001c\b\u0006\u0002B,\u0003SCqAa\u0018\u0001\t\u0003\t9)A\u001auKN$\u0018iY2fgN\fE\u000e\\8xK\u0012Le-\u00117m_^\f5\r\\#ySN$8o\u00148XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\"\"!QLAU\u0011\u001d\u0011)\u0007\u0001C\u0001\u0003\u000f\u000bq\u0004^3ti\u0012+G.\u001a;f\u0003\u000edwJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\u0011\u0011\u0019'!+\t\u000f\t-\u0004\u0001\"\u0001\u0002\b\u0006\u0011C/Z:u\t\u0016dW\r^3BY2\f5\r\\(o/&dGmY1sIJ+7o\\;sG\u0016DCA!\u001b\u0002*\"9!\u0011\u000f\u0001\u0005\u0002\u0005\u001d\u0015a\r;fgR\f5mY3tg\u0006cGn\\<fI&3\u0017\t\u001c7po\u0006\u001bG.\u0012=jgR\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\u0011\u0011y'!+\t\u000f\t]\u0004\u0001\"\u0001\u0002\b\u0006yB/Z:u\t\u0016dW\r^3BG2|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\t\tU\u0014\u0011\u0016\u0005\b\u0005{\u0002A\u0011AAD\u0003\t\"Xm\u001d;EK2,G/Z!mY\u0006\u001bGn\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\"!1PAU\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0003\u000f\u000bA\u0004^3ti\u0006#G-Q2mg>sG*\u001b;fe\u0006d'+Z:pkJ\u001cW\r\u000b\u0003\u0003\u0002\u0006%\u0006b\u0002BE\u0001\u0011\u0005\u0011qQ\u0001\u001ei\u0016\u001cH/\u00113e\u0003\u000ed7o\u00148XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\"\"!qQAU\u0011\u001d\u0011y\t\u0001C\u0001\u0003\u000f\u000ba\u0004^3ti\u0006#G-Q2mg>s\u0007K]3gS\u0016DX\r\u001a*fg>,(oY3)\t\t5\u0015\u0011\u0016\u0005\b\u0005+\u0003A\u0011AAD\u0003\u0005\"Xm\u001d;BkRDwN]5{K^KG\u000f\u001b)sK\u001aL\u00070\u001a3SKN|WO]2fQ\u0011\u0011\u0019*!+\t\u000f\tm\u0005\u0001\"\u0001\u0002\b\u0006yB/Z:u'&tw\r\\3DQ\u0006\u0014\u0018m\u0019;feJ+7o\\;sG\u0016\f5\r\\:)\t\te\u0015\u0011\u0016\u0005\b\u0005C\u0003A\u0011AAD\u0003Q!Xm\u001d;HKR\f5\r\\:Qe&t7-\u001b9bY\"\"!qTAU\u0011\u001d\u00119\u000b\u0001C\u0001\u0003\u000f\u000bA\b^3tiRC'o\\<t\u001f:\fE\r\u001a)sK\u001aL\u00070\u001a3BG2Le-\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:$vn\u001c'po\"B!QUAU\u0003_\u0013Yk\t\u0002\u0003.B!!q\u0016B[\u001b\t\u0011\tLC\u0002\u00034\u0012\fa!\u001a:s_J\u001c\u0018\u0002\u0002B\\\u0005c\u00131$\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016C8-\u001a9uS>t\u0007b\u0002B^\u0001\u0011\u0005\u0011qQ\u0001<i\u0016\u001cHo\u0016:ji\u0016\u001cX\t\u001f;f]\u0012,G-Q2m\u0007\"\fgnZ3Fm\u0016tG/\u00134J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNT8u'\u0016$\b\u0006\u0002B]\u0003SCqA!1\u0001\t\u0003\t9)A#uKN$xK]5uKN,\u0005\u0010^3oI\u0016$\u0017i\u00197DQ\u0006tw-Z#wK:$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\\!u\u0019\u0016\f7\u000f^&bM.\fgK\r\u0015\u0005\u0005\u007f\u000bI\u000bC\u0004\u0003H\u0002!\t!a\"\u0002qR,7\u000f^,sSR,7\u000fT5uKJ\fGn\u0016:ji\u0016\u001cH*\u001b;fe\u0006d\u0017i\u00197DQ\u0006tw-Z#wK:$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c'fgN$\u0006.\u00198LC\u001a\\\u0017M\u0016\u001afe\u0006d\u0017i\u00197DQ\u0006tw-Z:G_J|E\u000eZ3s!J|Go\\2pYZ+'o]5p]NDCA!2\u0002*\"9!Q\u001a\u0001\u0005\u0002\u0005\u001d\u0015a\u0010;fgR<&/\u001b;fg2KG/\u001a:bY\u0006\u001bGn\u00115b]\u001e,WI^3oi^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d\u0017j]&bM.\fgK\r\u0015\u0005\u0005\u0017\fI\u000bC\u0004\u0003T\u0002!IA!6\u0002E\u001dLg/\u001a8BkRDwN]5{KJ<\u0016\u000e\u001e5Qe>$xnY8m-\u0016\u00148/[8o)\r\u0011%q\u001b\u0005\t\u00053\u0014\t\u000e1\u0001\u0003\\\u0006y\u0001O]8u_\u000e|GNV3sg&|g\u000eE\u0003D\u0005;\u0014\t/C\u0002\u0003`\u0012\u0013aa\u00149uS>t\u0007\u0003\u0002Br\u0005Sl!A!:\u000b\u0007\t\u001dh!A\u0002ba&LAAa;\u0003f\nQ\u0011\t]5WKJ\u001c\u0018n\u001c8\t\u000f\t=\b\u0001\"\u0003\u0003r\u0006Ir-\u001a;BG2\u001c\u0005.\u00198hK\u00163XM\u001c;BgN#(/\u001b8h)\ry%1\u001f\u0005\t\u0005k\u0014i\u000f1\u0001\u0003x\u0006Y\u0001/\u0019;uKJtG+\u001f9f!\u0011\u0011IP!@\u000e\u0005\tm(B\u0001 e\u0013\u0011\u0011yPa?\u0003\u0017A\u000bG\u000f^3s]RK\b/\u001a\u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0003I\u0019\u0007.\u00198hK\u0006\u001bG.\u00118e-\u0016\u0014\u0018NZ=\u0015\u0015\r\u001d1\u0011BB\u0007\u0007#\u0019)\u0002E\u0003\u0002R\t\u001d\u0003\u0004\u0003\u0005\u0004\f\r\u0005\u0001\u0019AB\u0004\u00031y'/[4j]\u0006d\u0017i\u00197t\u0011!\u0019ya!\u0001A\u0002\r\u001d\u0011!C1eI\u0016$\u0017i\u00197t\u0011!\u0019\u0019b!\u0001A\u0002\r\u001d\u0011a\u0003:f[>4X\rZ!dYND\u0001BPB\u0001!\u0003\u0005\r\u0001\u000b\u0005\n\u00073\u0001\u0011\u0013!C\u0005\u00077\tAd\u00195b]\u001e,\u0017i\u00197B]\u00124VM]5gs\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u001e)\u001a\u0001fa\b,\u0005\r\u0005\u0002\u0003BB\u0012\u0007[i!a!\n\u000b\t\r\u001d2\u0011F\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u000bE\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007_\u0019)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class SimpleAclAuthorizerTest
extends ZooKeeperTestHarness {
    private final Acl allowReadAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    private final Acl allowWriteAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
    private final Acl denyReadAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    private final Resource wildCardResource = new Resource((ResourceType)Topic$.MODULE$, Acl$.MODULE$.WildCardResource(), PatternType.LITERAL);
    private final Resource prefixedResource = new Resource((ResourceType)Topic$.MODULE$, "foo", PatternType.PREFIXED);
    private final SimpleAclAuthorizer simpleAclAuthorizer = new SimpleAclAuthorizer();
    private final SimpleAclAuthorizer simpleAclAuthorizer2 = new SimpleAclAuthorizer();
    private Resource resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestChannel.Session session = new RequestChannel.Session(this.principal(), InetAddress.getByName("192.168.0.1"));
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;

    private Acl allowReadAcl() {
        return this.allowReadAcl;
    }

    private Acl allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private Acl denyReadAcl() {
        return this.denyReadAcl;
    }

    private Resource wildCardResource() {
        return this.wildCardResource;
    }

    private Resource prefixedResource() {
        return this.prefixedResource;
    }

    private SimpleAclAuthorizer simpleAclAuthorizer() {
        return this.simpleAclAuthorizer;
    }

    private SimpleAclAuthorizer simpleAclAuthorizer2() {
        return this.simpleAclAuthorizer2;
    }

    private Resource resource() {
        return this.resource;
    }

    private void resource_$eq(Resource x$1) {
        this.resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestChannel.Session session() {
        return this.session;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.simpleAclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.simpleAclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
        this.simpleAclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "SimpleAclAuthorizerTest"));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleAclAuthorizer().close();
        this.simpleAclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuthorizeThrowsOnNoneLiteralResource() {
        this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "something", PatternType.PREFIXED));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assert.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Group$.MODULE$, Acl$.MODULE$.WildCardResource(), PatternType.LITERAL));
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyAclThrowsException() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL));
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        Acl acl5 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl acl6 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        Acl acl7 = new Acl(user3, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session(user1, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Alter$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Alter$.MODULE$, this.resource()));
        RequestChannel.Session user2Session = new RequestChannel.Session(user2, host1);
        RequestChannel.Session user3Session = new RequestChannel.Session(user3, host1);
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session((KafkaPrincipal)customUserPrincipal, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session((KafkaPrincipal)customUserPrincipal, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestChannel.Session session = new RequestChannel.Session(user, host);
        Acl allowAll = Acl$.MODULE$.AllowAllAcl();
        Acl denyAcl = new Acl(user, (PermissionType)Deny$.MODULE$, host.getHostAddress(), (Operation)All$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testAllowAllAccess() {
        Acl allowAllAcl = Acl$.MODULE$.AllowAllAcl();
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session1 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        RequestChannel.Session session2 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session1, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session2, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session((KafkaPrincipal)new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser with custom principal always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        Acl readAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Set<Acl> acls = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{readAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Assert.assertTrue((String)"User1 should have Read access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Acl writeAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Acl denyWriteOnWildCardResourceAcl = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.changeAclAndVerify(acls, (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyWriteOnWildCardResourceAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertFalse((String)"User1 should not have Write access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (SimpleAclAuthorizer testAuthorizer = new SimpleAclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should fail open with allow.everyone = true.", (boolean)testAuthorizer.authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
        }
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Write$.MODULE$);
        Acl acl3 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Write$.MODULE$);
        ObjectRef acls = ObjectRef.create(this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4()));
        Acl acl5 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        acls.elem = this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl5}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})))}));
            Map map = this.simpleAclAuthorizer().getAcls(user1);
            return !(genMap != null ? !genMap.equals(map) : map != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3, acl4, acl5})))}));
            Map map = this.simpleAclAuthorizer().getAcls(user2);
            return !(genMap != null ? !genMap.equals(map) : map != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Topic$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Cluster$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)((Set)acls.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, "test-ConsumerGroup", PatternType.LITERAL)), (Object)((Set)acls.elem))}));
        resourceToAcls.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Resource key = (Resource)tuple2._1();
            Set value = (Set)tuple2._2();
            Set<Acl> set = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)value, (Set<Acl>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map map = resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)((Set)acls$1.elem)));
            Map map2 = this.simpleAclAuthorizer().getAcls();
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        acls.elem = this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.simpleAclAuthorizer().removeAcls(this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
        acls.elem = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)acls.elem), this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, "host-1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}));
        this.simpleAclAuthorizer().addAcls(acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, "test-2", PatternType.LITERAL);
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, "host3", (Operation)Read$.MODULE$);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2}));
        this.simpleAclAuthorizer().addAcls(acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (SimpleAclAuthorizer authorizer = new SimpleAclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assert.assertEquals((Object)acls, (Object)authorizer.getAcls(this.resource()));
            Assert.assertEquals((Object)acls1, (Object)authorizer.getAcls(resource1));
        }
    }

    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        SimpleAclAuthorizer simpleAclAuthorizer3 = new SimpleAclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> simpleAclAuthorizer3.configure(this.config().originals())));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user1, (PermissionType)Deny$.MODULE$, "host-1", (Operation)Read$.MODULE$)}));
            this.simpleAclAuthorizer().addAcls(acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)acls, (Object)simpleAclAuthorizer3.getAcls(this.resource()));
        }
        finally {
            simpleAclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        Acl acl3 = new Acl(user3, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        boolean deleted = this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable & scala.Serializable)acl -> (Function0 & Serializable & scala.Serializable)() -> {
            int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
            if (aclId % 2 == 0) {
                this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource);
            } else {
                this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource);
            }
            return aclId % 10 == 0 ? BoxesRunTime.boxToBoolean((boolean)this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource)) : BoxedUnit.UNIT;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)acls.filter((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(acl)))).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Read$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Write$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Delete$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Alter$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)Describe$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow((Operation)AlterConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{DescribeConfigs$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)DescribeConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(Operation parentOp, Set<Operation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session hostSession = new RequestChannel.Session(user, host);
        Acl acl = new Acl(user, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)op -> {
            SimpleAclAuthorizerTest.$anonfun$testImplicationsOfAllow$1(this, parentOp, allowedOps, hostSession, op);
            return BoxedUnit.UNIT;
        });
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
    }

    private void testImplicationsOfDeny(Operation parentOp, Set<Operation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user1, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp), new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$)}));
        this.simpleAclAuthorizer().addAcls(acls, Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)op -> {
            SimpleAclAuthorizerTest.$anonfun$testImplicationsOfDeny$1(this, parentOp, deniedOps, host1Session, op);
            return BoxedUnit.UNIT;
        });
        this.simpleAclAuthorizer().removeAcls(acls, Resource$.MODULE$.ClusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        Acl acl = new Acl(new KafkaPrincipal("User", this.username()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)x$1 -> SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer2(), this.resource());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().removeAcls(this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().removeAcls(this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls());
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.resource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.resource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefiexedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "a_other", PatternType.LITERAL));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "a_other", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "fon-", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "f", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "f", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "foo", PatternType.LITERAL)));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "_", PatternType.PREFIXED));
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "_foo", PatternType.LITERAL)));
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "_", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        Acl aclOnSpecificPrincipal = new Acl(this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{aclOnSpecificPrincipal})), this.resource());
        Assert.assertEquals((String)"acl on specific should not be returned for wildcard request", (long)0L, (long)this.simpleAclAuthorizer().getAcls(Acl$.MODULE$.WildCardPrincipal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for specific request", (long)1L, (long)this.simpleAclAuthorizer().getAcls(this.principal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for different principal instance", (long)1L, (long)this.simpleAclAuthorizer().getAcls(new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size());
        this.simpleAclAuthorizer().removeAcls(this.resource());
        Acl aclOnWildcardPrincipal = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{aclOnWildcardPrincipal})), this.resource());
        Assert.assertEquals((String)"acl on wildcard should be returned for wildcard request", (long)1L, (long)this.simpleAclAuthorizer().getAcls(Acl$.MODULE$.WildCardPrincipal()).size());
        Assert.assertEquals((String)"acl on wildcard should not be returned for specific request", (long)0L, (long)this.simpleAclAuthorizer().getAcls(this.principal()).size());
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.simpleAclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1 & Serializable & scala.Serializable)version -> props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), GetChildrenRequest$.MODULE$.apply$default$2(), GetChildrenRequest$.MODULE$.apply$default$3()));
        children.maybeThrow();
        Assert.assertEquals((String)"Expecting 1 change event", (long)1L, (long)children.children().size());
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), GetDataRequest$.MODULE$.apply$default$2(), GetDataRequest$.MODULE$.apply$default$3()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<Acl> changeAclAndVerify(Set<Acl> originalAcls, Set<Acl> addedAcls, Set<Acl> removedAcls, Resource resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().addAcls(addedAcls, resource);
            acls = (Set)acls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().removeAcls(removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.simpleAclAuthorizer(), resource);
        return acls;
    }

    private Resource changeAclAndVerify$default$4() {
        return this.resource();
    }

    public static final /* synthetic */ Acl $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        return new Acl(useri, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Acl acl) {
        int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
        return aclId % 10 != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$1(SimpleAclAuthorizerTest $this, Operation parentOp$1, Set allowedOps$1, RequestChannel.Session hostSession$1, Operation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.simpleAclAuthorizer().authorize(hostSession$1, op, Resource$.MODULE$.ClusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                Operation operation = op;
                Operation operation2 = parentOp$1;
                if (operation != null ? !operation.equals(operation2) : operation2 != null) break block3;
            }
            Assert.assertTrue((String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertFalse((String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString(), (boolean)authorized);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$1(SimpleAclAuthorizerTest $this, Operation parentOp$2, Set deniedOps$1, RequestChannel.Session host1Session$1, Operation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.simpleAclAuthorizer().authorize(host1Session$1, op, Resource$.MODULE$.ClusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                Operation operation = op;
                Operation operation2 = parentOp$2;
                if (operation != null ? !operation.equals(operation2) : operation2 != null) break block3;
            }
            Assert.assertFalse((String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertTrue((String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(SimpleAclAuthorizerTest $this, Acl acl$1, int x$1) {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl$1})), $this.resource());
            return $this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl$1})), $this.resource());
        };
    }

    public SimpleAclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ SimpleAclAuthorizerTest kafka$security$auth$SimpleAclAuthorizerTest$CustomPrincipal$$$outer() {
            return SimpleAclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (SimpleAclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

