/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.security.auth.login.Configuration;
import kafka.admin.ZkSecurityMigrator$;
import kafka.utils.CoreUtils$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ConsumerPathZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001%\u00111CW6BkRDwN]5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\t\u0005,H\u000f\u001b\u0006\u0003\u000b\u0019\t\u0001b]3dkJLG/\u001f\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u000b!A\u00111BD\u0007\u0002\u0019)\u0011QBB\u0001\u0003u.L!a\u0004\u0007\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t\tB#D\u0001\u0013\u0015\t\u0019b!A\u0003vi&d7/\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u001da\u0002A1A\u0005\u0002u\t\u0001B[1bg\u001aKG.Z\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0003S>T\u0011aI\u0001\u0005U\u00064\u0018-\u0003\u0002&A\t!a)\u001b7f\u0011\u00199\u0003\u0001)A\u0005=\u0005I!.Y1t\r&dW\r\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u00031\tW\u000f\u001e5Qe>4\u0018\u000eZ3s+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#B\u0001\u0018#\u0003\u0011a\u0017M\\4\n\u0005Aj#AB*ue&tw\r\u0003\u00043\u0001\u0001\u0006IaK\u0001\u000eCV$\b\u000e\u0015:pm&$WM\u001d\u0011\t\u000fQ\u0002\u0001\u0019!C\u0001k\u00059!p[+uS2\u001cX#\u0001\u001c\u0011\u0005E9\u0014B\u0001\u001d\u0013\u0005\u001dQ6.\u0016;jYNDqA\u000f\u0001A\u0002\u0013\u00051(A\u0006{WV#\u0018\u000e\\:`I\u0015\fHC\u0001\u001fC!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0011)f.\u001b;\t\u000f\rK\u0014\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\t\r\u0015\u0003\u0001\u0015)\u00037\u0003!Q8.\u0016;jYN\u0004\u0003\"B$\u0001\t\u0003B\u0015!B:fiV\u0003H#\u0001\u001f)\u0005\u0019S\u0005CA&Q\u001b\u0005a%BA'O\u0003\u0015QWO\\5u\u0015\u0005y\u0015aA8sO&\u0011\u0011\u000b\u0014\u0002\u0007\u0005\u00164wN]3\t\u000bM\u0003A\u0011\t%\u0002\u0011Q,\u0017M\u001d#po:D#AU+\u0011\u0005-3\u0016BA,M\u0005\u0015\te\r^3s\u0011\u0015I\u0006\u0001\"\u0001I\u0003]!Xm\u001d;Jgj[7+Z2ve&$\u00180\u00128bE2,G\r\u000b\u0002Y7B\u00111\nX\u0005\u0003;2\u0013A\u0001V3ti\")q\f\u0001C\u0001\u0011\u0006YA/Z:u5.,F/\u001b7tQ\tq6\fC\u0003c\u0001\u0011\u0005\u0001*A\buKN$(l['jOJ\fG/[8oQ\t\t7\fC\u0003f\u0001\u0011\u0005\u0001*A\nuKN$(l[!oi&l\u0015n\u001a:bi&|g\u000e\u000b\u0002e7\")\u0001\u000e\u0001C\u0001\u0011\u0006QA/Z:u\t\u0016dW\r^3)\u0005\u001d\\\u0006\"B6\u0001\t\u0003A\u0015a\u0005;fgR$U\r\\3uKJ+7-\u001e:tSZ,\u0007F\u00016\\\u0011\u0015q\u0007\u0001\"\u0001I\u0003)!Xm\u001d;DQJ|w\u000e\u001e\u0015\u0003[nCQ!\u001d\u0001\u0005\nI\fQ\u0002^3ti6KwM]1uS>tG#\u0002\u001ft\u007f\u0006\r\u0001\"\u0002;q\u0001\u0004)\u0018!\u0002>l+Jd\u0007C\u0001<~\u001d\t98\u0010\u0005\u0002y}5\t\u0011P\u0003\u0002{\u0011\u00051AH]8pizJ!\u0001  \u0002\rA\u0013X\rZ3g\u0013\t\u0001dP\u0003\u0002}}!1\u0011\u0011\u00019A\u0002Y\nqAZ5sgRT6\u000e\u0003\u0004\u0002\u0006A\u0004\rAN\u0001\tg\u0016\u001cwN\u001c3[W\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0011A\u0002<fe&4\u0017\u0010\u0006\u0003\u0002\u000e\u0005M\u0001cA\u001f\u0002\u0010%\u0019\u0011\u0011\u0003 \u0003\u000f\t{w\u000e\\3b]\"9\u0011QCA\u0004\u0001\u0004)\u0018\u0001\u00029bi\"Dq!!\u0007\u0001\t\u0013\tY\"\u0001\u0007jg\u0006\u001bGnQ8se\u0016\u001cG\u000f\u0006\u0005\u0002\u000e\u0005u\u0011\u0011IA#\u0011!\ty\"a\u0006A\u0002\u0005\u0005\u0012\u0001\u00027jgR\u0004b!a\t\u0002*\u00055RBAA\u0013\u0015\r\t9CI\u0001\u0005kRLG.\u0003\u0003\u0002,\u0005\u0015\"\u0001\u0002'jgR\u0004B!a\f\u0002>5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003eCR\f'\u0002BA\u001c\u0003s\t\u0011B_8pW\u0016,\u0007/\u001a:\u000b\u0007\u0005mb*\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u007f\t\tDA\u0002B\u00072C\u0001\"a\u0011\u0002\u0018\u0001\u0007\u0011QB\u0001\u0007g\u0016\u001cWO]3\t\u0011\u0005\u001d\u0013q\u0003a\u0001\u0003\u001b\t\u0011b]3og&$\u0018N^3\t\r\u0005-\u0003\u0001\"\u0003I\u0003E!W\r\\3uK\u0006cG.\u00168tK\u000e,(/\u001a\u0005\b\u0003\u001f\u0002A\u0011BA)\u0003=!W\r\\3uKJ+7-\u001e:tSZ,GCBA*\u0003;\ny\u0006\u0005\u0004\u0002V\u0005e\u0013QB\u0007\u0003\u0003/R1!a\n?\u0013\u0011\tY&a\u0016\u0003\u0007Q\u0013\u0018\u0010\u0003\u00045\u0003\u001b\u0002\rA\u000e\u0005\b\u0003+\ti\u00051\u0001v\u0011\u0019\t\u0019\u0007\u0001C\u0001\u0011\u0006QB/Z:u\u0007>t7/^7fe>3gm]3u!\u0006$\b.Q2mg\"\u001a\u0011\u0011M.")
public class ZkAuthorizationTest
extends ZooKeeperTestHarness {
    private final File jaasFile = JaasTestUtils$.MODULE$.writeJaasContextsToFile(JaasTestUtils$.MODULE$.zkSections());
    private final String authProvider;
    private ZkUtils zkUtils = null;

    public File jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    @Before
    public void setUp() {
        System.setProperty("java.security.auth.login.config", this.jaasFile().getAbsolutePath());
        Configuration.setConfiguration(null);
        System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        super.setUp();
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSecurityEnabled()))));
    }

    @Override
    @After
    public void tearDown() {
        if (this.zkUtils() != null) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkUtils().close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        }
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testIsZkSecurityEnabled() {
        Assert.assertTrue((boolean)JaasUtils.isZkSecurityEnabled());
        Configuration.setConfiguration(null);
        System.clearProperty("java.security.auth.login.config");
        Assert.assertFalse((boolean)JaasUtils.isZkSecurityEnabled());
        try {
            Configuration.setConfiguration(null);
            System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
            JaasUtils.isZkSecurityEnabled();
            throw this.fail("Should have thrown an exception", new Position("ZkAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testZkUtils() {
        Assert.assertTrue((boolean)this.zkUtils().isSecure());
        this.zkUtils().persistentZkPaths().foreach((Function1 & Serializable & scala.Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testZkUtils$1(this, path);
            return BoxedUnit.UNIT;
        });
        ZkUtils qual$2 = this.zkUtils();
        String x$5 = "/a";
        String x$6 = "";
        List x$7 = qual$2.createEphemeralPathExpectConflict$default$3();
        qual$2.createEphemeralPathExpectConflict(x$5, x$6, x$7);
        this.verify("/a");
        ZkUtils qual$3 = this.zkUtils();
        String x$8 = "/b";
        String x$9 = qual$3.createPersistentPath$default$2();
        List x$10 = qual$3.createPersistentPath$default$3();
        qual$3.createPersistentPath(x$8, x$9, x$10);
        this.verify("/b");
        ZkUtils qual$4 = this.zkUtils();
        String x$11 = "/c";
        String x$12 = "";
        List x$13 = qual$4.createSequentialPersistentPath$default$3();
        String seqPath = qual$4.createSequentialPersistentPath(x$11, x$12, x$13);
        this.verify(seqPath);
        ZkUtils qual$5 = this.zkUtils();
        String x$14 = "/a";
        String x$15 = "updated";
        List x$16 = qual$5.updateEphemeralPath$default$3();
        qual$5.updateEphemeralPath(x$14, x$15, x$16);
        String valueA = (String)this.zkUtils().zkClient().readData("/a");
        Assert.assertTrue((boolean)valueA.equals("updated"));
        ZkUtils qual$6 = this.zkUtils();
        String x$17 = "/b";
        String x$18 = "updated";
        List x$19 = qual$6.updatePersistentPath$default$3();
        qual$6.updatePersistentPath(x$17, x$18, x$19);
        String valueB = (String)this.zkUtils().zkClient().readData("/b");
        Assert.assertTrue((boolean)valueB.equals("updated"));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leaving testZkUtils");
    }

    @Test
    public void testZkMigration() {
        try (ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);){
            this.testMigration(this.zkConnect(), unsecureZkUtils, this.zkUtils());
        }
    }

    @Test
    public void testZkAntiMigration() {
        try (ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);){
            this.testMigration(this.zkConnect(), this.zkUtils(), unsecureZkUtils);
        }
    }

    @Test
    public void testDelete() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(this.zkConnect()).toString());
        ZkSecurityMigrator$.MODULE$.run((String[])((Object[])new String[]{"--zookeeper.acl=secure", new StringBuilder(20).append("--zookeeper.connect=").append(this.zkConnect()).toString()}));
        this.deleteAllUnsecure();
    }

    @Test
    public void testDeleteRecursive() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(this.zkConnect()).toString());
        ZkUtils$.MODULE$.SecureZkRootPaths().foreach((Function1 & Serializable & scala.Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testDeleteRecursive$2(this, path);
            return BoxedUnit.UNIT;
        });
        this.zkUtils().zkConnection().setAcl("/", this.zkUtils().defaultAcls("/"), -1);
        this.deleteAllUnsecure();
    }

    @Test
    public void testChroot() {
        String zkUrl = new StringBuilder(6).append(this.zkConnect()).append("/kafka").toString();
        ZkUtils qual$9 = this.zkUtils();
        String x$25 = "/kafka";
        String x$26 = qual$9.createPersistentPath$default$2();
        List x$27 = qual$9.createPersistentPath$default$3();
        qual$9.createPersistentPath(x$25, x$26, x$27);
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(zkUrl, 6000, 6000, false);
        ZkUtils secureZkUtils = ZkUtils$.MODULE$.apply(zkUrl, 6000, 6000, true);
        try {
            this.testMigration(zkUrl, unsecureZkUtils, secureZkUtils);
        }
        finally {
            unsecureZkUtils.close();
            secureZkUtils.close();
        }
    }

    private void testMigration(String zkUrl, ZkUtils firstZk, ZkUtils secondZk) {
        String string;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(zkUrl).toString());
        ((IterableLike)ZkUtils$.MODULE$.SecureZkRootPaths().$plus$plus((GenTraversableOnce)ZkUtils$.MODULE$.SensitiveZkRootPaths(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testMigration$2(this, firstZk, path);
            return BoxedUnit.UNIT;
        });
        if (secondZk.isSecure()) {
            firstZk.createPersistentPath(ZkUtils$.MODULE$.ConsumersPath(), firstZk.createPersistentPath$default$2(), firstZk.createPersistentPath$default$3());
            string = "secure";
        } else {
            secondZk.createPersistentPath(ZkUtils$.MODULE$.ConsumersPath(), secondZk.createPersistentPath$default$2(), secondZk.createPersistentPath$default$3());
            string = "unsecure";
        }
        String secureOpt = string;
        ZkSecurityMigrator$.MODULE$.run((String[])((Object[])new String[]{new StringBuilder(16).append("--zookeeper.acl=").append(secureOpt).toString(), new StringBuilder(20).append("--zookeeper.connect=").append(zkUrl).toString()}));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Done with migration");
        ((IterableLike)ZkUtils$.MODULE$.SecureZkRootPaths().$plus$plus((GenTraversableOnce)ZkUtils$.MODULE$.SensitiveZkRootPaths(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testMigration$5(this, secondZk, path);
            return BoxedUnit.UNIT;
        });
        List consumersAcl = (List)firstZk.zkConnection().getAcl(ZkUtils$.MODULE$.ConsumersPath()).getKey();
        Assert.assertTrue((String)ZkUtils$.MODULE$.ConsumersPath(), (boolean)this.isAclCorrect(consumersAcl, false, false));
    }

    private boolean verify(String path) {
        boolean sensitive = ZkUtils$.MODULE$.sensitivePath(path);
        List list = (List)this.zkUtils().zkConnection().getAcl(path).getKey();
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(x$1, sensitive)));
    }

    private boolean isAclCorrect(List<ACL> list, boolean secure, boolean sensitive) {
        boolean isListSizeCorrect;
        boolean bl = secure && !sensitive ? list.size() == 2 : (isListSizeCorrect = list.size() == 1);
        return isListSizeCorrect && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).forall((Function1)(secure ? (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(x$2, sensitive)) : (Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl))));
    }

    private void deleteAllUnsecure() {
        System.setProperty("zookeeper.sasl.client", "false");
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);
        Try<Object> result = this.deleteRecursive(unsecureZkUtils, "/");
        unsecureZkUtils.close();
        System.clearProperty("zookeeper.sasl.client");
        Try<Object> try_ = result;
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw this.fail(e.getMessage(), new Position("ZkAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            }
            throw new MatchError(try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Try<Object> deleteRecursive(ZkUtils zkUtils, String path) {
        Try try_;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Deleting ").append(path).toString());
        ObjectRef result = ObjectRef.create((Object)new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        zkUtils.getChildren(path).foreach((Function1 & Serializable & scala.Serializable)child -> {
            ZkAuthorizationTest.$anonfun$deleteRecursive$2(this, zkUtils, path, result, child);
            return BoxedUnit.UNIT;
        });
        String string = path;
        if ("/".equals(string)) {
            try_ = (Try)result.elem;
        } else {
            Try try_2;
            try {
                zkUtils.deletePath(string);
                try_2 = new Failure((Throwable)new Exception(new StringBuilder(25).append("Have been able to delete ").append(string).toString()));
            }
            catch (Exception exception) {
                try_2 = (Try)result.elem;
            }
            try_ = try_2;
        }
        return try_;
    }

    @Test
    public void testConsumerOffsetPathAcls() {
        this.zkClient().makeSurePersistentPathExists(ConsumerPathZNode$.MODULE$.path());
        List consumerPathAcls = this.zkClient().currentZooKeeper().getACL(ConsumerPathZNode$.MODULE$.path(), new Stat());
        Assert.assertTrue((String)"old consumer znode path acls are not open", (boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(consumerPathAcls).asScala()).forall((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl))));
    }

    public static final /* synthetic */ void $anonfun$testZkUtils$2(ACL acl) {
        Assert.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, true));
    }

    public static final /* synthetic */ void $anonfun$testZkUtils$3(ACL acl) {
        Assert.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, false));
    }

    public static final /* synthetic */ void $anonfun$testZkUtils$1(ZkAuthorizationTest $this, String path) {
        block1: {
            block0: {
                ZkUtils qual$1 = $this.zkUtils();
                String x$3 = path;
                List x$4 = qual$1.makeSurePersistentPathExists$default$2();
                qual$1.makeSurePersistentPathExists(x$3, x$4);
                if (!ZkUtils$.MODULE$.sensitivePath(path)) break block0;
                List aclList = (List)$this.zkUtils().zkConnection().getAcl(path).getKey();
                Assert.assertEquals((String)new StringBuilder(29).append("Unexpected acl list size for ").append(path).toString(), (long)1L, (long)aclList.size());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(aclList).asScala()).foreach((Function1 & Serializable & scala.Serializable)acl -> {
                    ZkAuthorizationTest.$anonfun$testZkUtils$2(acl);
                    return BoxedUnit.UNIT;
                });
                break block1;
            }
            if (path.equals(ZkUtils$.MODULE$.ConsumersPath())) break block1;
            List aclList = (List)$this.zkUtils().zkConnection().getAcl(path).getKey();
            Assert.assertEquals((String)new StringBuilder(29).append("Unexpected acl list size for ").append(path).toString(), (long)2L, (long)aclList.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(aclList).asScala()).foreach((Function1 & Serializable & scala.Serializable)acl -> {
                ZkAuthorizationTest.$anonfun$testZkUtils$3(acl);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$testDeleteRecursive$2(ZkAuthorizationTest $this, String path) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Creating ").append(path).toString());
        ZkUtils qual$7 = $this.zkUtils();
        String x$20 = path;
        List x$21 = qual$7.makeSurePersistentPathExists$default$2();
        qual$7.makeSurePersistentPathExists(x$20, x$21);
        ZkUtils qual$8 = $this.zkUtils();
        String x$22 = new StringBuilder(11).append(path).append("/fpjwashere").toString();
        String x$23 = "";
        List x$24 = qual$8.createPersistentPath$default$3();
        qual$8.createPersistentPath(x$22, x$23, x$24);
    }

    public static final /* synthetic */ void $anonfun$testMigration$2(ZkAuthorizationTest $this, ZkUtils firstZk$1, String path) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Creating ").append(path).toString());
        firstZk$1.makeSurePersistentPathExists(path, firstZk$1.makeSurePersistentPathExists$default$2());
        firstZk$1.createPersistentPath(new StringBuilder(11).append(path).append("/fpjwashere").toString(), "", firstZk$1.createPersistentPath$default$3());
    }

    public static final /* synthetic */ void $anonfun$testMigration$5(ZkAuthorizationTest $this, ZkUtils secondZk$1, String path) {
        boolean sensitive = ZkUtils$.MODULE$.sensitivePath(path);
        List listParent = (List)secondZk$1.zkConnection().getAcl(path).getKey();
        Assert.assertTrue((String)path, (boolean)$this.isAclCorrect(listParent, secondZk$1.isSecure(), sensitive));
        String childPath = new StringBuilder(11).append(path).append("/fpjwashere").toString();
        List listChild = (List)secondZk$1.zkConnection().getAcl(childPath).getKey();
        Assert.assertTrue((String)childPath, (boolean)$this.isAclCorrect(listChild, secondZk$1.isSecure(), sensitive));
    }

    public static final /* synthetic */ void $anonfun$deleteRecursive$2(ZkAuthorizationTest $this, ZkUtils zkUtils$1, String path$1, ObjectRef result$1, String child) {
        Try try_;
        String string = path$1;
        Try<Object> try_2 = "/".equals(string) ? $this.deleteRecursive(zkUtils$1, new StringBuilder(1).append("/").append(child).toString()) : $this.deleteRecursive(zkUtils$1, new StringBuilder(1).append(string).append("/").append(child).toString());
        Try<Object> try_3 = try_2;
        if (try_3 instanceof Success) {
            try_ = (Try)result$1.elem;
        } else if (try_3 instanceof Failure) {
            Failure failure = (Failure)try_3;
            Throwable e = failure.exception();
            try_ = new Failure(e);
        } else {
            throw new MatchError(try_3);
        }
        result$1.elem = try_;
    }

    public ZkAuthorizationTest() {
        this.authProvider = "zookeeper.authProvider.1";
    }
}

