/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogAppendInfo;
import kafka.message.CompressionCodec;
import kafka.message.NoCompressionCodec$;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.AbstractFetcherThreadTest$MockFetcherThread$;
import kafka.server.FetcherMetrics$;
import kafka.server.Fetching$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r-g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002'\rdW-\u00198NKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0015\u0003Y\u0001\"!C\f\n\u0005aQ!\u0001B+oSRD#a\u0005\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!\u00026v]&$(\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"9\t1!)\u001a4pe\u0016DQa\t\u0001\u0005\n\u0011\nq\"\u00197m\u001b\u0016$(/[2t\u001d\u0006lWm]\u000b\u0002KA\u0019a%K\u0016\u000e\u0003\u001dR!\u0001\u000b\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002+O\t\u00191+\u001a;\u0011\u00051\u001adBA\u00172!\tq#\"D\u00010\u0015\t\u0001d!\u0001\u0004=e>|GOP\u0005\u0003e)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!G\u0003\u0005\u0006o\u0001!I\u0001O\u0001\b[.\u0014\u0015\r^2i)\u0011ID)\u0013(\u0011\u0005i\u0012U\"A\u001e\u000b\u0005qj\u0014A\u0002:fG>\u0014HM\u0003\u0002?\u007f\u000511m\\7n_:T!!\u0002!\u000b\u0005\u0005s\u0012AB1qC\u000eDW-\u0003\u0002Dw\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u0015)e\u00071\u0001G\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\t\u0003\u0013\u001dK!\u0001\u0013\u0006\u0003\t1{gn\u001a\u0005\u0006\u0015Z\u0002\raS\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0005\u0002\n\u0019&\u0011QJ\u0003\u0002\u0004\u0013:$\b\"B(7\u0001\u0004\u0001\u0016a\u0002:fG>\u0014Hm\u001d\t\u0004\u0013E\u001b\u0016B\u0001*\u000b\u0005)a$/\u001a9fCR,GM\u0010\t\u0003uQK!!V\u001e\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\t\u000b]\u0003A\u0011\u0002-\u0002\u001d=4gm]3u\u0003:$W\t]8dQR\u0019\u0011\f\u00180\u0011\u0005IQ\u0016BA.\u0003\u00059yeMZ:fi\u0006sG-\u00129pG\"DQ!\u0018,A\u0002\u0019\u000b1BZ3uG\"|eMZ:fi\")!J\u0016a\u0001\u0017\")\u0001\r\u0001C\u0001+\u0005aB/Z:u\u001b\u0016$(/[2t%\u0016lwN^3e\u001f:\u001c\u0006.\u001e;e_^t\u0007FA0c!\tY2-\u0003\u0002e9\t!A+Z:u\u0011\u00151\u0007\u0001\"\u0001\u0016\u0003\r\"Xm\u001d;D_:\u001cX/\\3s\u0019\u0006<'+Z7pm\u0016$w+\u001b;i!\u0006\u0014H/\u001b;j_:D#!\u001a2\t\u000b%\u0004A\u0011A\u000b\u0002\u001fQ,7\u000f^*j[BdWMR3uG\"D#\u0001\u001b2\t\u000b1\u0004A\u0011A\u000b\u0002)Q,7\u000f\u001e$f]\u000e,G\r\u0016:v]\u000e\fG/[8oQ\tY'\rC\u0003p\u0001\u0011\u0005Q#A\buKN$h)\u001a8dK\u00124U\r^2iQ\tq'\rC\u0003s\u0001\u0011\u0005Q#\u0001\u0012uKN$XK\\6o_^tG*Z1eKJ,\u0005o\\2i\u0013:$&/\u001e8dCRLwN\u001c\u0015\u0003c\nDQ!\u001e\u0001\u0005\u0002U\t1\u0005^3tiVs7N\\8x]2+\u0017\rZ3s\u000bB|7\r[,iS2,g)\u001a;dQ&tw\r\u000b\u0002uE\")\u0001\u0010\u0001C\u0001+\u0005qA/Z:u)J,hnY1uS>t\u0007FA<c\u0011\u0015Y\b\u0001\"\u0001\u0016\u0003m\"Xm\u001d;UeVt7-\u0019;f)>D\u0015n\u001a5XCR,'/\\1sW&3G*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u\u001d>$8+\u001e9q_J$X\r\u001a\u0015\u0003u\nDQA \u0001\u0005\u0002U\t\u0001\b^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0017J\u001a'fC\u0012,'/\u00129pG\"LeNZ8O_R\fe/Y5mC\ndW\r\u000b\u0002~E\"1\u00111\u0001\u0001\u0005\u0002U\tA\u0005^3tiR\u0013XO\\2bi&|gnU6jaB,G-\u00134O_\u0016\u0003xn\u00195DQ\u0006tw-\u001a\u0015\u0004\u0003\u0003\u0011\u0007BBA\u0005\u0001\u0011\u0005Q#A\u0010uKN$hi\u001c7m_^,'OR3uG\"|U\u000f^(g%\u0006tw-\u001a%jO\"D3!a\u0002c\u0011\u0019\ty\u0001\u0001C\u0001+\u0005!C/Z:u\r\u0016t7-\u001a3PM\u001a\u001cX\r\u001e*fg\u0016$\u0018I\u001a;fe>+Ho\u00144SC:<W\rK\u0002\u0002\u000e\tDa!!\u0006\u0001\t\u0003)\u0012A\b;fgR4u\u000e\u001c7po\u0016\u0014h)\u001a;dQ>+Ho\u00144SC:<W\rT8xQ\r\t\u0019B\u0019\u0005\u0007\u00037\u0001A\u0011A\u000b\u0002gQ,7\u000f\u001e*fiJL\u0018I\u001a;feVs7N\\8x]2+\u0017\rZ3s\u000bB|7\r[%o\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e$fi\u000eD\u0007fAA\rE\"1\u0011\u0011\u0005\u0001\u0005\u0002U\t!\u0003^3ti\u000e{'O];qi6+7o]1hK\"\u001a\u0011q\u00042\t\r\u0005\u001d\u0002\u0001\"\u0001\u0016\u0003Y\"Xm\u001d;MK\u0006$WM]#q_\u000eD7\t[1oO\u0016$UO]5oO\u001a+gnY3e\r\u0016$8\r[#q_\u000eD7O\u0012:p[2+\u0017\rZ3sQ\r\t)C\u0019\u0005\u0007\u0003[\u0001A\u0011A\u000b\u0002uQ,7\u000f\u001e'fC\u0012,'/\u00129pG\"\u001c\u0005.\u00198hK\u0012+(/\u001b8h'V\u001c7-Z:tMVdg)\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014\bfAA\u0016E\"9\u00111\u0007\u0001\u0005\n\u0005U\u0012\u0001\r;fgRdU-\u00193fe\u0016\u0003xn\u00195DQ\u0006tw-\u001a#ve&twMR3uG\",\u0005o\\2ig\u001a\u0013x.\u001c'fC\u0012,'\u000fF\u0002\u0017\u0003oAq!!\u000f\u00022\u0001\u00071*A\nmK\u0006$WM]#q_\u000eDwJ\u001c'fC\u0012,'\u000f\u0003\u0004\u0002>\u0001!\t!F\u0001Pi\u0016\u001cH\u000f\u0016:v]\u000e\fG/[8o)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]&3G*Z1eKJ\u0014V\r^;s]N\u0004\u0016M\u001d;ji&|gn\u001d(piJ+\u0017/^3ti\u0016$\u0017J\u001c$fi\u000eDW\t]8dQND3!a\u000fc\u000f\u001d\t\u0019\u0005\u0001E\u0001\u0003\u000b\n\u0011#T8dW\u001a+Go\u00195feRC'/Z1e!\u0011\t9%!\u0013\u000e\u0003\u00011q!a\u0013\u0001\u0011\u0003\tiEA\tN_\u000e\\g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001c2!!\u0013\t\u0011\u001dy\u0011\u0011\nC\u0001\u0003#\"\"!!\u0012\u0007\u000f\u0005U\u0013\u0011\n\u0001\u0002X\tq\u0001+\u0019:uSRLwN\\*uCR,7cAA*\u0011!Y\u00111LA*\u0005\u0003\u0007I\u0011AA/\u0003\rawnZ\u000b\u0003\u0003?\u0002R!!\u0019\u0002hej!!a\u0019\u000b\u0007\u0005\u0015t%A\u0004nkR\f'\r\\3\n\t\u0005%\u00141\r\u0002\u0007\u0005V4g-\u001a:\t\u0017\u00055\u00141\u000bBA\u0002\u0013\u0005\u0011qN\u0001\bY><w\fJ3r)\r1\u0012\u0011\u000f\u0005\u000b\u0003g\nY'!AA\u0002\u0005}\u0013a\u0001=%c!Y\u0011qOA*\u0005\u0003\u0005\u000b\u0015BA0\u0003\u0011awn\u001a\u0011\t\u0015)\u000b\u0019F!a\u0001\n\u0003\tY(F\u0001L\u0011-\ty(a\u0015\u0003\u0002\u0004%\t!!!\u0002\u001f1,\u0017\rZ3s\u000bB|7\r[0%KF$2AFAB\u0011%\t\u0019(! \u0002\u0002\u0003\u00071\n\u0003\u0006\u0002\b\u0006M#\u0011!Q!\n-\u000bA\u0002\\3bI\u0016\u0014X\t]8dQ\u0002B1\"a#\u0002T\t\u0005\r\u0011\"\u0001\u0002\u000e\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$X#\u0001$\t\u0017\u0005E\u00151\u000bBA\u0002\u0013\u0005\u00111S\u0001\u0013Y><7\u000b^1si>3gm]3u?\u0012*\u0017\u000fF\u0002\u0017\u0003+C\u0011\"a\u001d\u0002\u0010\u0006\u0005\t\u0019\u0001$\t\u0015\u0005e\u00151\u000bB\u0001B\u0003&a)A\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;!\u0011-\ti*a\u0015\u0003\u0002\u0004%\t!!$\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\t\u0017\u0005\u0005\u00161\u000bBA\u0002\u0013\u0005\u00111U\u0001\u0011Y><WI\u001c3PM\u001a\u001cX\r^0%KF$2AFAS\u0011%\t\u0019(a(\u0002\u0002\u0003\u0007a\t\u0003\u0006\u0002*\u0006M#\u0011!Q!\n\u0019\u000bQ\u0002\\8h\u000b:$wJ\u001a4tKR\u0004\u0003bCAW\u0003'\u0012\t\u0019!C\u0001\u0003\u001b\u000bQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007bCAY\u0003'\u0012\t\u0019!C\u0001\u0003g\u000b\u0011\u0003[5hQ^\u000bG/\u001a:nCJ\\w\fJ3r)\r1\u0012Q\u0017\u0005\n\u0003g\ny+!AA\u0002\u0019C!\"!/\u0002T\t\u0005\t\u0015)\u0003G\u00039A\u0017n\u001a5XCR,'/\\1sW\u0002BqaDA*\t\u0003\ti\f\u0006\u0007\u0002@\u0006\r\u0017QYAd\u0003\u0013\fY\r\u0005\u0003\u0002B\u0006MSBAA%\u0011!\tY&a/A\u0002\u0005}\u0003B\u0002&\u0002<\u0002\u00071\nC\u0004\u0002\f\u0006m\u0006\u0019\u0001$\t\u000f\u0005u\u00151\u0018a\u0001\r\"9\u0011QVA^\u0001\u00041u\u0001CAh\u0003\u0013B\t!!5\u0002\u001dA\u000b'\u000f^5uS>t7\u000b^1uKB!\u0011\u0011YAj\r!\t)&!\u0013\t\u0002\u0005U7cAAj\u0011!9q\"a5\u0005\u0002\u0005eGCAAi\u0011!\ti.a5\u0005\u0002\u0005}\u0017!B1qa2LH\u0003CA`\u0003C\f)0a>\t\u0011\u0005m\u00131\u001ca\u0001\u0003G\u0004R!!:\u0002pfrA!a:\u0002l:\u0019a&!;\n\u0003-I1!!<\u000b\u0003\u001d\u0001\u0018mY6bO\u0016LA!!=\u0002t\n\u00191+Z9\u000b\u0007\u00055(\u0002\u0003\u0004K\u00037\u0004\ra\u0013\u0005\b\u0003[\u000bY\u000e1\u0001G\u0011!\ti.a5\u0005\u0002\u0005mH\u0003BA`\u0003{DaASA}\u0001\u0004Y\u0005B\u0003B\u0001\u0003\u0013\n\n\u0011\"\u0001\u0003\u0004\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"A!\u0002+\u0007-\u00139a\u000b\u0002\u0003\nA!!1\u0002B\u000b\u001b\t\u0011iA\u0003\u0003\u0003\u0010\tE\u0011!C;oG\",7m[3e\u0015\r\u0011\u0019BC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\f\u0005\u001b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011Y\"!\u0013\u0012\u0002\u0013\u0005!1A\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0007\r\u0005-\u0003\u0001\u0001B\u0010'\u0011\u0011iB!\t\u0011\u0007I\u0011\u0019#C\u0002\u0003&\t\u0011Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rC\u0006\u0003*\tu!Q1A\u0005\u0002\u0005m\u0014!\u0003:fa2L7-Y%e\u0011)\u0011iC!\b\u0003\u0002\u0003\u0006IaS\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0003b\u0003B\u0019\u0005;\u0011)\u0019!C\u0001\u0003w\n\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\u000b\u0005k\u0011iB!A!\u0002\u0013Y\u0015!\u00037fC\u0012,'/\u00133!\u0011\u001dy!Q\u0004C\u0001\u0005s!bAa\u000f\u0003>\t}\u0002\u0003BA$\u0005;A\u0011B!\u000b\u00038A\u0005\t\u0019A&\t\u0013\tE\"q\u0007I\u0001\u0002\u0004Y\u0005B\u0003B\"\u0005;\u0011\r\u0011\"\u0003\u0003F\u00051\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0003HAA\u0011\u0011\rB%\u0005\u001b\u0012)&\u0003\u0003\u0003L\u0005\r$aA'baB!!q\nB)\u001b\u0005i\u0014b\u0001B*{\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003\u0002B,\u0003'rA!a\u0012\u0002B!I!1\fB\u000fA\u0003%!qI\u0001\u0018e\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fg\u0002B!Ba\u0018\u0003\u001e\t\u0007I\u0011\u0002B#\u0003UaW-\u00193feB\u000b'\u000f^5uS>t7\u000b^1uKND\u0011Ba\u0019\u0003\u001e\u0001\u0006IAa\u0012\u0002-1,\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fg\u0002B\u0001Ba\u001a\u0003\u001e\u0011\u0005!\u0011N\u0001\u000fg\u0016$H*Z1eKJ\u001cF/\u0019;f)\u00151\"1\u000eB8\u0011!\u0011iG!\u001aA\u0002\t5\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0005c\u0012)\u00071\u0001\u0003V\u0005)1\u000f^1uK\"A!Q\u000fB\u000f\t\u0003\u00119(A\btKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)\u00151\"\u0011\u0010B>\u0011!\u0011iGa\u001dA\u0002\t5\u0003\u0002\u0003B9\u0005g\u0002\rA!\u0016\t\u0011\t}$Q\u0004C\u0001\u0005\u0003\u000bQC]3qY&\u001c\u0017\rU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0003V\t\r\u0005\u0002\u0003B7\u0005{\u0002\rA!\u0014\t\u0011\t\u001d%Q\u0004C\u0001\u0005\u0013\u000bA\u0003\\3bI\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G\u0003\u0002B+\u0005\u0017C\u0001B!\u001c\u0003\u0006\u0002\u0007!Q\n\u0005\t\u0005\u001f\u0013i\u0002\"\u0011\u0003\u0012\u0006!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002Ba%\u0003$\n\u0015&q\u0015\t\u0006\u0013\tU%\u0011T\u0005\u0004\u0005/S!AB(qi&|g\u000e\u0005\u0003\u0003\u001c\n}UB\u0001BO\u0015\r\tY\u0006B\u0005\u0005\u0005C\u0013iJA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\t\u0005[\u0012i\t1\u0001\u0003N!1QL!$A\u0002\u0019C\u0001B!+\u0003\u000e\u0002\u0007!1V\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\t5&qV\u0007\u0003\u0005;IAA!-\u0003$\tIa)\u001a;dQ\u0012\u000bG/\u0019\u0005\t\u0005k\u0013i\u0002\"\u0011\u00038\u0006AAO];oG\u0006$X\rF\u0003\u0017\u0005s\u0013Y\f\u0003\u0005\u0003n\tM\u0006\u0019\u0001B'\u0011!\u0011iLa-A\u0002\t}\u0016a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007I\u0011\t-C\u0002\u0003D\n\u0011Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X\r\u0003\u0005\u0003H\nuA\u0011\tBe\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000fF\u0003\u0017\u0005\u0017\u0014i\r\u0003\u0005\u0003n\t\u0015\u0007\u0019\u0001B'\u0011\u001d\u0011yM!2A\u0002\u0019\u000baa\u001c4gg\u0016$\b\u0002\u0003Bj\u0005;!\tE!6\u0002\u0015\t,\u0018\u000e\u001c3GKR\u001c\u0007\u000e\u0006\u0003\u0003X\u000e\r\u0001C\u0002Bm\u0005O\u0014iO\u0004\u0003\u0003\\\n\rh\u0002\u0002Bo\u0005Ct1A\fBp\u0013\u0005)\u0011BA\u0002\u0005\u0013\r\u0011)OA\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u0011IOa;\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\u0011)O\u0001\t\u0006\u0013\tU%q\u001e\t\u0005\u0005c\u0014iP\u0004\u0003\u0003t\neXB\u0001B{\u0015\r\u001190P\u0001\te\u0016\fX/Z:ug&!!1 B{\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\u0011yp!\u0001\u0003\u000f\t+\u0018\u000e\u001c3fe*!!1 B{\u0011!\u0019)A!5A\u0002\r\u001d\u0011\u0001\u00049beRLG/[8o\u001b\u0006\u0004\bc\u0002\u0014\u0004\n\t531B\u0005\u0004\u0005\u0017:\u0003c\u0001\n\u0004\u000e%\u00191q\u0002\u0002\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u0011\rM!Q\u0004C!\u0007+\t1\u0002\\1uKN$X\t]8dQR!1qCB\r!\u0011I!QS&\t\u0011\t54\u0011\u0003a\u0001\u0005\u001bB\u0001\"!(\u0003\u001e\u0011\u00053Q\u0004\u000b\u0004\r\u000e}\u0001\u0002\u0003B7\u00077\u0001\rA!\u0014\t\u0011\r\r\"Q\u0004C!\u0007K\t\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0019\u00199c!\u000b\u0004,A!\u0011B!&Z\u0011!\u0011ig!\tA\u0002\t5\u0003bBB\u0017\u0007C\u0001\raS\u0001\u0006KB|7\r\u001b\u0005\t\u0007c\u0011i\u0002\"\u0003\u00044\u0005A2\r[3dW\u0016C\b/Z2uK\u0012dU-\u00193fe\u0016\u0003xn\u00195\u0015\r\rU21IB2!\u0015I!QSB\u001c!\u0011\u0019Ida\u0010\u000e\u0005\rm\"bAB\u001f{\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0004B\rm\"AB#se>\u00148\u000f\u0003\u0005\u0004F\r=\u0002\u0019AB$\u0003A)\u0007\u0010]3di\u0016$W\t]8dQ>\u0003H\u000f\u0005\u0004\u0004J\rM3qK\u0007\u0003\u0007\u0017RAa!\u0014\u0004P\u0005!Q\u000f^5m\u0015\t\u0019\t&\u0001\u0003kCZ\f\u0017\u0002BB+\u0007\u0017\u0012\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u00073\u001ay&\u0004\u0002\u0004\\)!1QLB(\u0003\u0011a\u0017M\\4\n\t\r\u000541\f\u0002\b\u0013:$XmZ3s\u0011!\u0019)ga\fA\u0002\tU\u0013A\u00049beRLG/[8o'R\fG/\u001a\u0005\t\u0007S\u0012i\u0002\"\u0003\u0004l\u00059Bn\\8lkB,e\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0007[\u001a\u0019h! \u0011\t\tM8qN\u0005\u0005\u0007c\u0012)P\u0001\bFa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;\t\u0011\rU4q\ra\u0001\u0007o\n\u0011\"\u001a9pG\"$\u0015\r^1\u0011\t\t56\u0011P\u0005\u0005\u0007w\u0012\u0019CA\u0005Fa>\u001c\u0007\u000eR1uC\"A1QMB4\u0001\u0004\u0011)\u0006\u0003\u0005\u0004\u0002\nuA\u0011IBB\u0003Q1W\r^2i\u000bB|7\r[#oI>3gm]3ugR!1QQBD!\u001d13\u0011\u0002B'\u0007[B\u0001b!#\u0004\u0000\u0001\u000711R\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bc\u0002\u0014\u0004\n\t53q\u000f\u0005\t\u0007\u001f\u0013i\u0002\"\u0015\u0004\u0012\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\rM\u0005cA\u0005\u0004\u0016&\u00191q\u0013\u0006\u0003\u000f\t{w\u000e\\3b]\"A11\u0014B\u000f\t\u0003\u001ai*A\bgKR\u001c\u0007N\u0012:p[2+\u0017\rZ3s)\u0011\u0019yja*\u0011\r\u0005\u0015\u0018q^BQ!\u001dI11\u0015B'\u0005WK1a!*\u000b\u0005\u0019!V\u000f\u001d7fe!A1\u0011VBM\u0001\u0004\u0011y/\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0003\u0005\u0004.\nuA\u0011BBX\u0003a\u0019\u0007.Z2l\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00118e)\"\u0014xn\u001e\u000b\u0006-\rE6Q\u0017\u0005\b\u0007g\u001bY\u000b1\u0001L\u00035)\u0007\u0010]3di\u0016$W\t]8dQ\"A1QMBV\u0001\u0004\u0011)\u0006\u0003\u0005\u0004:\nuA\u0011KB^\u0003u1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014H#\u0002$\u0004>\u000e}\u0006\u0002\u0003B7\u0007o\u0003\rA!\u0014\t\r)\u001b9\f1\u0001L\u0011!\u0019\u0019M!\b\u0005R\r\u0015\u0017a\u00074fi\u000eDG*\u0019;fgR|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000fF\u0003G\u0007\u000f\u001cI\r\u0003\u0005\u0003n\r\u0005\u0007\u0019\u0001B'\u0011\u0019Q5\u0011\u0019a\u0001\u0017\u0002")
public class AbstractFetcherThreadTest {
    private volatile AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread$module;

    public AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread() {
        if (this.MockFetcherThread$module == null) {
            this.MockFetcherThread$lzycompute$1();
        }
        return this.MockFetcherThread$module;
    }

    @Before
    public void cleanMetricRegistry() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)metricName -> {
            AbstractFetcherThreadTest.$anonfun$cleanMetricRegistry$1(metricName);
            return BoxedUnit.UNIT;
        });
    }

    private Set<String> allMetricsNames() {
        return (Set)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Set$.MODULE$.canBuildFrom());
    }

    private RecordBatch mkBatch(long baseOffset, int leaderEpoch, Seq<SimpleRecord> records) {
        return (RecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(MemoryRecords.withRecords((long)baseOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch), (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))).batches()).asScala()).head();
    }

    public OffsetAndEpoch kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    @Test
    public void testMetricsRemovedOnShutdown() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.start();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<String> set = this.allMetricsNames();
            GenTraversable genTraversable = Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
            return !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed waiting for all fetcher metrics to be registered", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        fetcher.shutdown();
        Assert.assertTrue((boolean)Metrics.defaultRegistry().allMetrics().isEmpty());
    }

    @Test
    public void testConsumerLagRemovedWithPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.doWork();
        Assert.assertTrue((String)"Failed waiting for consumer lag metric", (boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assert.assertFalse((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    @Test
    public void testSimpleFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testFencedFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(0);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testUnknownLeaderEpochInTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.state()));
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.state()));
    }

    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())}))}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.state()));
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.state()));
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.state()));
    }

    @Test
    public void testTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochRequestNotSupported() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public boolean isOffsetForLeaderEpochSupported() {
                return false;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$2, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$2 = highWatermark$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        MockFetcherThread fetcher = new MockFetcherThread(this, truncations){
            private final IntRef truncations$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(5);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 5))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)1L, (long)truncations.elem);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)truncations.elem);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 4))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.state()));
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockFetcherThread fetcher = new MockFetcherThread(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 4))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testFollowerFetchOutOfRangeLow() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.state()));
        Assert.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private final AtomicInteger tries;

            private AtomicInteger tries() {
                return this.tries;
            }

            public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffsetFromLeader(topicPartition, leaderEpoch);
            }
            {
                this.tries = new AtomicInteger(0);
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.state()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testCorruptMessage() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
                void var2_2;
                block0: {
                    Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchedData = super.fetchFromLeader(fetchRequest);
                    if (this.fetchedOnce()) break block0;
                    MemoryRecords records = (MemoryRecords)((FetchResponse.PartitionData)((Tuple2)fetchedData.head())._2()).records;
                    ByteBuffer buffer = records.buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return var2_2;
            }
            {
                this.fetchedOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        TopicPartition partition = new TopicPartition("topic", 0);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockFetcherThread fetcher = new MockFetcherThread(this, partition, nextLeaderEpochOnFollower){
            private boolean fetchEpochsFromLeaderOnce;
            private final /* synthetic */ AbstractFetcherThreadTest $outer;
            private final TopicPartition partition$4;
            private final int nextLeaderEpochOnFollower$1;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void var2_2;
                block0: {
                    Map<TopicPartition, EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                    if (this.fetchEpochsFromLeaderOnce()) break block0;
                    this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$4})));
                    this.setReplicaState(this.partition$4, this.$outer.MockFetcherThread().PartitionState().apply(this.nextLeaderEpochOnFollower$1));
                    this.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$4), (Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, this.nextLeaderEpochOnFollower$1))})));
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$4 = partition$4;
                this.nextLeaderEpochOnFollower$1 = nextLeaderEpochOnFollower$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, initialLeaderEpochOnFollower))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.state()));
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.currentLeaderEpoch())));
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L));
        }
        fetcher.doWork();
        Assert.assertEquals(fetcher.leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                return super.fetchEpochEndOffsets(partitions).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp), (Object)new EpochEndOffset(0, 0L)));
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fetcher.doWork(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("AbstractFetcherThreadTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
    }

    private final void MockFetcherThread$lzycompute$1() {
        AbstractFetcherThreadTest abstractFetcherThreadTest = this;
        synchronized (abstractFetcherThreadTest) {
            if (this.MockFetcherThread$module == null) {
                this.MockFetcherThread$module = new AbstractFetcherThreadTest$MockFetcherThread$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$cleanMetricRegistry$1(MetricName metricName) {
        Metrics.defaultRegistry().removeMetric(metricName);
    }

    public class MockFetcherThread
    extends AbstractFetcherThread {
        private final int replicaId;
        private final int leaderId;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates;
        public final /* synthetic */ AbstractFetcherThreadTest $outer;

        public int replicaId() {
            return this.replicaId;
        }

        public int leaderId() {
            return this.leaderId;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
            return this.replicaPartitionStates;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates() {
            return this.leaderPartitionStates;
        }

        public void setLeaderState(TopicPartition topicPartition, PartitionState state) {
            this.leaderPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
            this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public PartitionState replicaPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
            });
        }

        public PartitionState leaderPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.leaderPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
            });
        }

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            if (fetchOffset != state.logEndOffset()) {
                throw new RuntimeException(new StringBuilder(32).append("Offset mismatch for partition ").append(topicPartition).append(": ").append(new StringBuilder(37).append("fetched offset = ").append(fetchOffset).append(", log end offset = ").append(state.logEndOffset()).append(".").toString()).toString());
            }
            Iterable batches = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((Records)partitionData.records).batches()).asScala();
            LongRef maxTimestamp = LongRef.create((long)-1L);
            LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
            LongRef lastOffset = LongRef.create((long)state.logEndOffset());
            batches.foreach((Function1 & Serializable & scala.Serializable)batch -> {
                MockFetcherThread.$anonfun$processPartitionData$1(state, maxTimestamp, offsetOfMaxTimestamp, lastOffset, batch);
                return BoxedUnit.UNIT;
            });
            state.logStartOffset_$eq(partitionData.logStartOffset);
            state.highWatermark_$eq(partitionData.highWatermark);
            return new Some((Object)new LogAppendInfo((Option)new Some((Object)BoxesRunTime.boxToLong((long)fetchOffset)), lastOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordConversionStats.EMPTY, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, batches.size(), partitionData.records.sizeInBytes(), true, BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))));
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
            state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$15))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> state.logStartOffset())));
            state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log().clear();
            state.logStartOffset_$eq(offset);
            state.logEndOffset_$eq(offset);
            state.highWatermark_$eq(offset);
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            scala.collection.mutable.Map fetchData = Map$.MODULE$.empty();
            partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    PartitionFetchState state = (PartitionFetchState)tuple2._2();
                    if (state.isReadyForFetch()) {
                        PartitionState replicaState = this.replicaPartitionState(partition);
                        boxedUnit = fetchData.put((Object)partition, (Object)new FetchRequest.PartitionData(state.fetchOffset(), replicaState.logStartOffset(), 0x100000, Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch()))));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            FetchRequest.Builder fetchRequest = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)1, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(fetchData).asJava()));
            return new AbstractFetcherThread.ResultWithPartitions((Object)new Some((Object)fetchRequest), Set$.MODULE$.empty());
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            return state.log().lastOption().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.partitionLeaderEpoch())).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)-1)));
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return this.replicaPartitionState(topicPartition).logEndOffset();
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            OffsetsForLeaderEpochRequest.PartitionData epochData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), epoch);
            EpochEndOffset result = this.lookupEndOffsetForEpoch(epochData, this.replicaPartitionState(topicPartition));
            return result.endOffset() == -1L ? None$.MODULE$ : new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
        }

        private Option<Errors> checkExpectedLeaderEpoch(Optional<Integer> expectedEpochOpt, PartitionState partitionState) {
            Integer expectedEpoch;
            return expectedEpochOpt.isPresent() ? (Predef$.MODULE$.Integer2int(expectedEpoch = expectedEpochOpt.get()) < partitionState.leaderEpoch() ? new Some((Object)Errors.FENCED_LEADER_EPOCH) : (Predef$.MODULE$.Integer2int(expectedEpoch) > partitionState.leaderEpoch() ? new Some((Object)Errors.UNKNOWN_LEADER_EPOCH) : None$.MODULE$)) : None$.MODULE$;
        }

        private EpochEndOffset lookupEndOffsetForEpoch(OffsetsForLeaderEpochRequest.PartitionData epochData, PartitionState partitionState) {
            EpochEndOffset epochEndOffset;
            Object object = new Object();
            try {
                this.checkExpectedLeaderEpoch(epochData.currentLeaderEpoch, partitionState).foreach((Function1 & Serializable & scala.Serializable)error -> {
                    throw new NonLocalReturnControl(object, (Object)new EpochEndOffset(error, -1, -1L));
                });
                IntRef epochLowerBound = IntRef.create((int)-1);
                partitionState.log().foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    MockFetcherThread.$anonfun$lookupEndOffsetForEpoch$2(epochData, epochLowerBound, object, batch);
                    return BoxedUnit.UNIT;
                });
                epochEndOffset = new EpochEndOffset(Errors.NONE, -1, -1L);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    epochEndOffset = (EpochEndOffset)ex.value();
                }
                throw ex;
            }
            return epochEndOffset;
        }

        /*
         * WARNING - void declaration
         */
        public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
            void var2_2;
            scala.collection.mutable.Map endOffsets = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            partitions.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition partition = (TopicPartition)tuple2._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple2._2();
                PartitionState leaderState = this.leaderPartitionState(partition);
                EpochEndOffset epochEndOffset = this.lookupEndOffsetForEpoch(epochData, leaderState);
                Option option = endOffsets.put((Object)partition, (Object)epochEndOffset);
                return option;
            });
            return var2_2;
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return true;
        }

        public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
            return ((scala.collection.mutable.MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchRequest.fetchData()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2;
                PartitionState leaderState;
                TopicPartition partition;
                Tuple2 tuple22 = x0$3;
                if (tuple22 != null) {
                    Tuple2 tuple23;
                    Tuple2 tuple24;
                    partition = (TopicPartition)tuple22._1();
                    FetchRequest.PartitionData fetchData = (FetchRequest.PartitionData)tuple22._2();
                    leaderState = this.leaderPartitionState(partition);
                    Option<Errors> epochCheckError = this.checkExpectedLeaderEpoch(fetchData.currentLeaderEpoch, leaderState);
                    if (epochCheckError.isDefined()) {
                        tuple24 = new Tuple2(epochCheckError.get(), (Object)MemoryRecords.EMPTY);
                    } else if (fetchData.fetchOffset > leaderState.logEndOffset() || fetchData.fetchOffset < leaderState.logStartOffset()) {
                        tuple24 = new Tuple2((Object)Errors.OFFSET_OUT_OF_RANGE, (Object)MemoryRecords.EMPTY);
                    } else {
                        MemoryRecords memoryRecords;
                        Option option = leaderState.log().find((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$fetchFromLeader$2(fetchData, x$17)));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RecordBatch batch = (RecordBatch)some.value();
                            ByteBuffer buffer = ByteBuffer.allocate(batch.sizeInBytes());
                            batch.writeTo(buffer);
                            buffer.flip();
                            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else if (None$.MODULE$.equals(option)) {
                            memoryRecords = MemoryRecords.EMPTY;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        MemoryRecords records = memoryRecords;
                        tuple24 = tuple23 = new Tuple2((Object)Errors.NONE, (Object)records);
                    }
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    Errors error = (Errors)tuple23._1();
                    MemoryRecords records = (MemoryRecords)tuple23._2();
                    tuple2 = new Tuple2((Object)error, (Object)records);
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple25 = tuple2;
                Errors error = (Errors)tuple25._1();
                MemoryRecords records = (MemoryRecords)tuple25._2();
                Tuple2 tuple26 = new Tuple2((Object)partition, (Object)new FetchResponse.PartitionData(error, leaderState.highWatermark(), leaderState.highWatermark(), leaderState.logStartOffset(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava(), (BaseRecords)records));
                return tuple26;
            }, Map$.MODULE$.canBuildFrom())).toSeq();
        }

        private void checkLeaderEpochAndThrow(int expectedEpoch, PartitionState partitionState) {
            this.checkExpectedLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(expectedEpoch)), partitionState).foreach((Function1 & Serializable & scala.Serializable)error -> {
                throw error.exception();
            });
        }

        public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logStartOffset();
        }

        public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logEndOffset();
        }

        public /* synthetic */ AbstractFetcherThreadTest kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$processPartitionData$1(PartitionState state$1, LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef lastOffset$1, RecordBatch batch) {
            batch.ensureValid();
            if (batch.maxTimestamp() > maxTimestamp$1.elem) {
                maxTimestamp$1.elem = batch.maxTimestamp();
                offsetOfMaxTimestamp$1.elem = batch.baseOffset();
            }
            state$1.log().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}));
            state$1.logEndOffset_$eq(batch.nextOffset());
            lastOffset$1.elem = batch.lastOffset();
        }

        public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
            return batch.lastOffset() < truncationState$1.offset();
        }

        public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$15) {
            return x$15.lastOffset() + 1L;
        }

        public static final /* synthetic */ void $anonfun$lookupEndOffsetForEpoch$2(OffsetsForLeaderEpochRequest.PartitionData epochData$1, IntRef epochLowerBound$1, Object nonLocalReturnKey1$1, RecordBatch batch) {
            if (batch.partitionLeaderEpoch() > epochData$1.leaderEpoch) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new EpochEndOffset(Errors.NONE, epochLowerBound$1.elem, batch.baseOffset()));
            }
            epochLowerBound$1.elem = batch.partitionLeaderEpoch();
        }

        public static final /* synthetic */ boolean $anonfun$fetchFromLeader$2(FetchRequest.PartitionData fetchData$2, RecordBatch x$17) {
            return x$17.baseOffset() >= fetchData$2.fetchOffset;
        }

        public MockFetcherThread(AbstractFetcherThreadTest $outer, int replicaId, int leaderId) {
            this.replicaId = replicaId;
            this.leaderId = leaderId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("mock-fetcher", "mock-fetcher", new BrokerEndPoint(leaderId, "localhost", Random$.MODULE$.nextInt()), AbstractFetcherThread$.MODULE$.$lessinit$greater$default$4(), AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5());
            this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.leaderPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }

        public class PartitionState {
            private Buffer<RecordBatch> log;
            private int leaderEpoch;
            private long logStartOffset;
            private long logEndOffset;
            private long highWatermark;
            public final /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ $outer;

            public Buffer<RecordBatch> log() {
                return this.log;
            }

            public void log_$eq(Buffer<RecordBatch> x$1) {
                this.log = x$1;
            }

            public int leaderEpoch() {
                return this.leaderEpoch;
            }

            public void leaderEpoch_$eq(int x$1) {
                this.leaderEpoch = x$1;
            }

            public long logStartOffset() {
                return this.logStartOffset;
            }

            public void logStartOffset_$eq(long x$1) {
                this.logStartOffset = x$1;
            }

            public long logEndOffset() {
                return this.logEndOffset;
            }

            public void logEndOffset_$eq(long x$1) {
                this.logEndOffset = x$1;
            }

            public long highWatermark() {
                return this.highWatermark;
            }

            public void highWatermark_$eq(long x$1) {
                this.highWatermark = x$1;
            }

            public /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ kafka$server$AbstractFetcherThreadTest$MockFetcherThread$PartitionState$$$outer() {
                return this.$outer;
            }

            public PartitionState(AbstractFetcherThreadTest$MockFetcherThread$ $outer, Buffer<RecordBatch> log, int leaderEpoch, long logStartOffset, long logEndOffset, long highWatermark) {
                this.log = log;
                this.leaderEpoch = leaderEpoch;
                this.logStartOffset = logStartOffset;
                this.logEndOffset = logEndOffset;
                this.highWatermark = highWatermark;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }
}

