/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u000f\tq\u0012\t\u001c;feJ+\u0007\u000f\\5dC2{w\rR5sgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000fE\u0001!\u0019!C!%\u0005YAn\\4ESJ\u001cu.\u001e8u+\u0005\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"aA%oi\"1!\u0004\u0001Q\u0001\nM\tA\u0002\\8h\t&\u00148i\\;oi\u0002Bq\u0001\b\u0001C\u0002\u0013\u0005##\u0001\u0006ok6\u0014%o\\6feNDaA\b\u0001!\u0002\u0013\u0019\u0012a\u00038v[\n\u0013xn[3sg\u0002Bq\u0001\t\u0001C\u0002\u0013\u0005\u0011%A\u0003u_BL7-F\u0001#!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u0015;sS:<\u0007BB\u0016\u0001A\u0003%!%\u0001\u0004u_BL7\r\t\u0005\u0006[\u0001!\tAL\u0001\u001fi\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeN\u0014V-];fgR$\u0012a\f\t\u0003)AJ!!M\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0003YM\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u000b),h.\u001b;\u000b\u0003a\n1a\u001c:h\u0013\tQTG\u0001\u0003UKN$\b\"\u0002\u001f\u0001\t\u0003q\u0013a\n;fgR\fE\u000e^3s%\u0016\u0004H.[2b\u0019><G)\u001b:t%\u0016\fX/Z:u\u000bJ\u0014xN]\"pI\u0016D#aO\u001a\t\u000b}\u0002A\u0011\u0002!\u0002=M,g\u000eZ!mi\u0016\u0014(+\u001a9mS\u000e\fGj\\4ESJ\u001c(+Z9vKN$HcA!M?B\u0011!IS\u0007\u0002\u0007*\u0011A)R\u0001\te\u0016\fX/Z:ug*\u0011aiR\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015A%BA%8\u0003\u0019\t\u0007/Y2iK&\u00111j\u0011\u0002\u001c\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fgB|gn]3\t\u000b5s\u0004\u0019\u0001(\u0002\u001bA\f'\u000f^5uS>tG)\u001b:t!\u0011ye+W/\u000f\u0005A#\u0006CA)\u0016\u001b\u0005\u0011&BA*\u0007\u0003\u0019a$o\\8u}%\u0011Q+F\u0001\u0007!J,G-\u001a4\n\u0005]C&aA'ba*\u0011Q+\u0006\t\u00035nk\u0011!R\u0005\u00039\u0016\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002P=&\u0011\u0011\u0006\u0017\u0005\bAz\u0002\n\u00111\u0001b\u00031\u0019xnY6fiN+'O^3s!\t\u0011W-D\u0001d\u0015\t!G!A\u0004oKR<xN]6\n\u0005\u0019\u001c'\u0001D*pG.,GoU3sm\u0016\u0014\bb\u00025\u0001#\u0003%I![\u0001)g\u0016tG-\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeN\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0002U*\u0012\u0011m[\u0016\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\nk:\u001c\u0007.Z2lK\u0012T!!]\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002t]\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class AlterReplicaLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int numBrokers;
    private final String topic;

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int numBrokers() {
        return this.numBrokers;
    }

    public String topic() {
        return this.topic;
    }

    @Test
    public void testAlterReplicaLogDirsRequest() {
        int partitionNum = 5;
        String logDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs1 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir1), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, alterReplicaLogDirsResponse1.responses().get(tp));
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$1 = tp;
            boolean x$2 = qual$1.getLog$default$2();
            Assert.assertTrue((boolean)qual$1.getLog(x$1, x$2).isEmpty());
        });
        this.createTopic(this.topic(), partitionNum, 1, this.createTopic$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$3 = new TopicPartition(this.topic(), partition);
            boolean x$4 = qual$2.getLog$default$2();
            Assert.assertEquals((Object)logDir1, (Object)((Log)qual$2.getLog(x$3, x$4).get()).dir().getParent());
        });
        String logDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs2 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir2), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assert.assertEquals((Object)Errors.NONE, alterReplicaLogDirsResponse2.responses().get(tp));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                String string = logDir2;
                LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
                TopicPartition x$5 = new TopicPartition(this.topic(), partition);
                boolean x$6 = qual$3.getLog$default$2();
                String string2 = ((Log)qual$3.getLog(x$5, x$6).get()).dir().getParent();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        });
    }

    @Test
    public void testAlterReplicaLogDirsRequestErrorCode() {
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        String validDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(1)).getAbsolutePath();
        String validDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(2)).getAbsolutePath();
        String validDir3 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(3)).getAbsolutePath();
        scala.collection.mutable.Map partitionDirs1 = Map$.MODULE$.empty();
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir1);
        AlterReplicaLogDirsResponse alterReplicaDirResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse1.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, alterReplicaDirResponse1.responses().get(new TopicPartition(this.topic(), 1)));
        this.createTopic(this.topic(), 3, 1, this.createTopic$default$4());
        scala.collection.mutable.Map partitionDirs2 = Map$.MODULE$.empty();
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir2);
        AlterReplicaLogDirsResponse alterReplicaDirResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse2.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.NONE, alterReplicaDirResponse2.responses().get(new TopicPartition(this.topic(), 1)));
        ((KafkaServer)this.servers().head()).logDirFailureChannel().maybeAddOfflineLogDir(offlineDir, (Function0 & Serializable & scala.Serializable)() -> "", new IOException());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !((KafkaServer)this.servers().head()).logManager().isLogDirOnline(offlineDir), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("timed out waiting for ").append(offlineDir).append(" to be offline").toString(), 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        scala.collection.mutable.Map partitionDirs3 = Map$.MODULE$.empty();
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir3);
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 2), (Object)offlineDir);
        AlterReplicaLogDirsResponse alterReplicaDirResponse3 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs3.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 1)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 2)));
    }

    private AlterReplicaLogDirsResponse sendAlterReplicaLogDirsRequest(Map<TopicPartition, String> partitionDirs, SocketServer socketServer) {
        AlterReplicaLogDirsRequest request = (AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitionDirs).asJava()).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.ALTER_REPLICA_LOG_DIRS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return AlterReplicaLogDirsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private SocketServer sendAlterReplicaLogDirsRequest$default$2() {
        return this.controllerSocketServer();
    }

    public AlterReplicaLogDirsRequestTest() {
        this.logDirCount = 5;
        this.numBrokers = 1;
        this.topic = "topic";
    }
}

