/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmh\u0001B\u0001\u0003\u0001\u001d\u0011ac\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005i&lW-F\u0001\u0017!\t9\u0012%D\u0001\u0019\u0015\tI\"$A\u0003vi&d7O\u0003\u0002\u001c9\u000511m\\7n_:T!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ea\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u000bQLW.\u001a\u0011\t\u000f\u0019\u0002!\u0019!C\u0005O\u000511m\u001c8gS\u001e,\u0012\u0001\u000b\t\u0003%%J!A\u000b\u0002\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw\r\u0003\u0004-\u0001\u0001\u0006I\u0001K\u0001\bG>tg-[4!\u0011\u001dq\u0003\u00011A\u0005\u0002=\nAB\\;n\u0007\u0006dGNY1dWN,\u0012\u0001\r\t\u0003\u0013EJ!A\r\u0006\u0003\u0007%sG\u000fC\u00045\u0001\u0001\u0007I\u0011A\u001b\u0002!9,XnQ1mY\n\f7m[:`I\u0015\fHC\u0001\u001c:!\tIq'\u0003\u00029\u0015\t!QK\\5u\u0011\u001dQ4'!AA\u0002A\n1\u0001\u001f\u00132\u0011\u0019a\u0004\u0001)Q\u0005a\u0005ia.^7DC2d'-Y2lg\u0002BQA\u0010\u0001\u0005\u0002}\n\u0001bY1mY\n\f7m\u001b\u000b\u0003m\u0001CQ!Q\u001fA\u0002\t\u000b\u0001B]3ta>t7/\u001a\t\u0003\u0007&s!\u0001R$\u000e\u0003\u0015S!A\u0012\u0003\u0002\u000f9,Go^8sW&\u0011\u0001*R\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\tQ5J\u0001\u0005SKN\u0004xN\\:f\u0015\tAU\tC\u0003N\u0001\u0011\u0005a*\u0001\u0007cK\u001a|'/Z'fi\"|G\rF\u00017Q\ta\u0005\u000b\u0005\u0002R)6\t!K\u0003\u0002T?\u0005)!.\u001e8ji&\u0011QK\u0015\u0002\u0007\u0005\u00164wN]3\t\u000b]\u0003A\u0011\u0002-\u0002\u0019\t,\u0018\u000e\u001c3SKF,Xm\u001d;\u0016\u0005e{Fc\u0001.ooB!\u0011bW/l\u0013\ta&B\u0001\u0004UkBdWM\r\t\u0003=~c\u0001\u0001B\u0003a-\n\u0007\u0011MA\u0001U#\t\u0011W\r\u0005\u0002\nG&\u0011AM\u0003\u0002\b\u001d>$\b.\u001b8h!\t1\u0017.D\u0001h\u0015\tA'$\u0001\u0005sKF,Xm\u001d;t\u0013\tQwMA\bBEN$(/Y2u%\u0016\fX/Z:u!\t\u0019E.\u0003\u0002n\u0017\n9!+Z9vKN$\b\"B8W\u0001\u0004\u0001\u0018a\u00022vS2$WM\u001d\t\u0004cRlfB\u00014s\u0013\t\u0019x-A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\t)hOA\u0004Ck&dG-\u001a:\u000b\u0005M<\u0007b\u0002=W!\u0003\u0005\r!_\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0003url\u0011a\u001f\u0006\u0003\rjI!!`>\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\r}\u0004A\u0011BA\u0001\u0003-i\u0017-\u001f2f%\u0016\u001cwN\u001d3\u0015\u0013A\n\u0019!!\u0004\u0002(\u0005-\u0002bBA\u0003}\u0002\u0007\u0011qA\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u0004%\u0005%\u0011bAA\u0006\u0005\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u001d\tyA a\u0001\u0003#\tA!^:feB!\u00111CA\u0011\u001d\u0011\t)\"!\b\u0011\u0007\u0005]!\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\u0004\u0002\rq\u0012xn\u001c;?\u0013\r\tyBC\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0012Q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}!\u0002C\u0004\u0002*y\u0004\r!!\u0005\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dq!!\f\u007f\u0001\u0004\ty#A\u0003wC2,X\rE\u0002\n\u0003cI1!a\r\u000b\u0005\u0019!u.\u001e2mK\"9\u0011q\u0007\u0001\u0005\n\u0005e\u0012\u0001\u0003;ie>$H\u000f\\3\u0015\u0017Y\nY$!\u0010\u0002@\u0005\u0005\u0013Q\t\u0005\t\u0003\u000b\t)\u00041\u0001\u0002\b!A\u0011qBA\u001b\u0001\u0004\t\t\u0002\u0003\u0005\u0002*\u0005U\u0002\u0019AA\t\u0011\u001d\t\u0019%!\u000eA\u0002A\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f\u0003\u0005\u0002H\u0005U\u0002\u0019AA%\u0003e\u0019\u0007.\u00198oK2$\u0006N]8ui2LgnZ\"bY2\u0014\u0017mY6\u0011\u000b%\tYE\u0011\u001c\n\u0007\u00055#BA\u0005Gk:\u001cG/[8oc!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0013\u0001\u0005;fgR\fVo\u001c;b!\u0006\u00148/\u001b8h)-1\u0014QKA,\u0005{\u0011\tE!\u0012\t\r\u0019\ny\u00051\u0001)\u0011!\tI&a\u0014A\u0002\u0005m\u0013aB2mS\u0016tG/\r\t\u0005\u0003;\ny&D\u0001\u0001\r\u0019\t\t\u0007\u0001#\u0002d\tQQk]3s\u00072LWM\u001c;\u0014\u000f\u0005}\u0003\"!\u001a\u0002lA\u0019\u0011\"a\u001a\n\u0007\u0005%$BA\u0004Qe>$Wo\u0019;\u0011\u0007%\ti'C\u0002\u0002p)\u0011AbU3sS\u0006d\u0017N_1cY\u0016D1\"a\u0004\u0002`\tU\r\u0011\"\u0001\u0002tU\u0011\u0011\u0011\u0003\u0005\f\u0003o\nyF!E!\u0002\u0013\t\t\"A\u0003vg\u0016\u0014\b\u0005C\u0006\u0002*\u0005}#Q3A\u0005\u0002\u0005M\u0004bCA?\u0003?\u0012\t\u0012)A\u0005\u0003#\t\u0011b\u00197jK:$\u0018\n\u001a\u0011\t\u0017\u0005\u0005\u0015q\fBK\u0002\u0013\u0005\u00111Q\u0001\u000bG>tg-[4Vg\u0016\u0014XCAAC!\u0015I\u0011qQA\t\u0013\r\tII\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0017\u00055\u0015q\fB\tB\u0003%\u0011QQ\u0001\fG>tg-[4Vg\u0016\u0014\b\u0005C\u0006\u0002\u0012\u0006}#Q3A\u0005\u0002\u0005\r\u0015AD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0005\f\u0003+\u000byF!E!\u0002\u0013\t))A\bd_:4\u0017nZ\"mS\u0016tG/\u00133!\u0011\u001dy\u0011q\fC\u0001\u00033#\"\"a\u0017\u0002\u001c\u0006u\u0015qTAQ\u0011!\ty!a&A\u0002\u0005E\u0001\u0002CA\u0015\u0003/\u0003\r!!\u0005\t\u0015\u0005\u0005\u0015q\u0013I\u0001\u0002\u0004\t)\t\u0003\u0006\u0002\u0012\u0006]\u0005\u0013!a\u0001\u0003\u000bC\u0001\"!*\u0002`\u0011\u0005\u0011qU\u0001\u0018g\u0006t\u0017\u000e^5{K\u0012\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012,\"!!+\u0011\u000b%\t9)a+\u0011\t\u00055\u0016qW\u0007\u0003\u0003_SA!!-\u00024\u0006!A.\u00198h\u0015\t\t),\u0001\u0003kCZ\f\u0017\u0002BA\u0012\u0003_C!\"a/\u0002`\u0005\u0005I\u0011AA_\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005m\u0013qXAa\u0003\u0007\f)\r\u0003\u0006\u0002\u0010\u0005e\u0006\u0013!a\u0001\u0003#A!\"!\u000b\u0002:B\u0005\t\u0019AA\t\u0011)\t\t)!/\u0011\u0002\u0003\u0007\u0011Q\u0011\u0005\u000b\u0003#\u000bI\f%AA\u0002\u0005\u0015\u0005BCAe\u0003?\n\n\u0011\"\u0001\u0002L\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAgU\u0011\t\t\"a4,\u0005\u0005E\u0007\u0003BAj\u0003;l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a7\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\f)NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a9\u0002`E\u0005I\u0011AAf\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB!\"a:\u0002`E\u0005I\u0011AAu\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a;+\t\u0005\u0015\u0015q\u001a\u0005\u000b\u0003_\fy&%A\u0005\u0002\u0005%\u0018AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0003g\fy&!A\u0005B\u0005U\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002,\"I\u0011\u0011`A0\u0003\u0003%\taL\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0003{\fy&!A\u0005\u0002\u0005}\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0003\u00119\u0001E\u0002\n\u0005\u0007I1A!\u0002\u000b\u0005\r\te.\u001f\u0005\tu\u0005m\u0018\u0011!a\u0001a!Q!1BA0\u0003\u0003%\tE!\u0004\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0004\u0011\r\tE!q\u0003B\u0001\u001b\t\u0011\u0019BC\u0002\u0003\u0016)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IBa\u0005\u0003\u0011%#XM]1u_JD!B!\b\u0002`\u0005\u0005I\u0011\u0001B\u0010\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0011\u0005O\u00012!\u0003B\u0012\u0013\r\u0011)C\u0003\u0002\b\u0005>|G.Z1o\u0011%Q$1DA\u0001\u0002\u0004\u0011\t\u0001\u0003\u0006\u0003,\u0005}\u0013\u0011!C!\u0005[\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002a!Q!\u0011GA0\u0003\u0003%\tEa\r\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a+\t\u0015\t]\u0012qLA\u0001\n\u0003\u0012I$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005C\u0011Y\u0004C\u0005;\u0005k\t\t\u00111\u0001\u0003\u0002!A!qHA(\u0001\u0004\tY&A\u0004dY&,g\u000e\u001e\u001a\t\u0011\t\r\u0013q\na\u0001\u00037\nAB]1oI>l7\t\\5f]RD\u0001Ba\u0012\u0002P\u0001\u0007\u00111L\u0001\u0014I\u00164\u0017-\u001e7u\u0007>tg-[4DY&,g\u000e\u001e\u0005\u0007\u0005\u0017\u0002A\u0011\u0001(\u00021Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018\rU1sg&tw\r\u000b\u0003\u0003J\t=\u0003cA)\u0003R%\u0019!1\u000b*\u0003\tQ+7\u000f\u001e\u0005\u0007\u0005/\u0002A\u0011\u0001(\u0002)Q,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8hQ\u0011\u0011)Fa\u0014\t\r\tu\u0003\u0001\"\u0001O\u0003q!Xm\u001d;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u0004\u0016M]:j]\u001eDCAa\u0017\u0003P!1!1\r\u0001\u0005\u00029\u000bA\u0006^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<w+\u001b;i\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1)\t\t\u0005$q\n\u0005\u0007\u0005S\u0002A\u0011\u0001(\u0002iQ,7\u000f^+tKJ\u001cE.[3oiF+x\u000e^1QCJ\u001c\u0018N\\4JI^KG\u000f\u001b#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018\r\u000b\u0003\u0003h\t=\u0003B\u0002B8\u0001\u0011\u0005a*A\ruKN$\u0018+^8uC\u000e{gNZ5h!J,7-\u001a3f]\u000e,\u0007\u0006\u0002B7\u0005\u001fBaA!\u001e\u0001\t\u0003q\u0015A\u0005;fgR\fVo\u001c;b-&|G.\u0019;j_:DCAa\u001d\u0003P!1!1\u0010\u0001\u0005\u00029\u000b1\u0005^3tiJ+\u0017/^3tiB+'oY3oi\u0006<W-U;pi\u00064\u0016n\u001c7bi&|g\u000e\u000b\u0003\u0003z\t=\u0003B\u0002BA\u0001\u0011\u0005a*\u0001\u000fuKN$X\t\u001f9je\u0016$\u0006N]8ui2,G+[7f'\u0016t7o\u001c:)\t\t}$q\n\u0005\u0007\u0005\u000f\u0003A\u0011\u0001(\u0002-Q,7\u000f^#ya&\u0014X-U;pi\u0006\u001cVM\\:peNDCA!\"\u0003P!1!Q\u0012\u0001\u0005\u00029\u000b\u0001\u0004^3ti\u000ec\u0017.\u001a8u\u0013\u0012tu\u000e^*b]&$\u0018N_3eQ\u0011\u0011YIa\u0014\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\u0006Qa.Z<NKR\u0014\u0018nY:\u0016\u0005\t]\u0005\u0003\u0002BM\u0005?k!Aa'\u000b\u0007\tu%$A\u0004nKR\u0014\u0018nY:\n\t\t\u0005&1\u0014\u0002\b\u001b\u0016$(/[2t\u000f%\u0011)\u000bAA\u0001\u0012\u0013\u00119+\u0001\u0006Vg\u0016\u00148\t\\5f]R\u0004B!!\u0018\u0003*\u001aI\u0011\u0011\r\u0001\u0002\u0002#%!1V\n\u0007\u0005S\u0013i+a\u001b\u0011\u001d\t=&QWA\t\u0003#\t))!\"\u0002\\5\u0011!\u0011\u0017\u0006\u0004\u0005gS\u0011a\u0002:v]RLW.Z\u0005\u0005\u0005o\u0013\tLA\tBEN$(/Y2u\rVt7\r^5p]RBqa\u0004BU\t\u0003\u0011Y\f\u0006\u0002\u0003(\"Q!\u0011\u0007BU\u0003\u0003%)Ea\r\t\u0015\t\u0005'\u0011VA\u0001\n\u0003\u0013\u0019-A\u0003baBd\u0017\u0010\u0006\u0006\u0002\\\t\u0015'q\u0019Be\u0005\u0017D\u0001\"a\u0004\u0003@\u0002\u0007\u0011\u0011\u0003\u0005\t\u0003S\u0011y\f1\u0001\u0002\u0012!Q\u0011\u0011\u0011B`!\u0003\u0005\r!!\"\t\u0015\u0005E%q\u0018I\u0001\u0002\u0004\t)\t\u0003\u0006\u0003P\n%\u0016\u0011!CA\u0005#\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003T\nm\u0007#B\u0005\u0002\b\nU\u0007cC\u0005\u0003X\u0006E\u0011\u0011CAC\u0003\u000bK1A!7\u000b\u0005\u0019!V\u000f\u001d7fi!Q!Q\u001cBg\u0003\u0003\u0005\r!a\u0017\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003b\n%\u0016\u0013!C\u0001\u0003S\fq\"\u00199qYf$C-\u001a4bk2$He\r\u0005\u000b\u0005K\u0014I+%A\u0005\u0002\u0005%\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\t\u0015\t%(\u0011VI\u0001\n\u0003\tI/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r\u0005\u000b\u0005[\u0014I+%A\u0005\u0002\u0005%\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007C\u0005\u0003r\u0002\t\n\u0011\"\u0003\u0003t\u00061\"-^5mIJ+\u0017/^3ti\u0012\"WMZ1vYR$#'\u0006\u0003\u0003v\neXC\u0001B|U\rI\u0018q\u001a\u0003\u0007A\n=(\u0019A1")
public class ClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final MockTime time = new MockTime();
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private MockTime time() {
        return this.time;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public void callback(RequestChannel.Response response) {
        RequestChannel.Response response2 = response;
        if (response2 instanceof RequestChannel.StartThrottlingResponse) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (response2 instanceof RequestChannel.EndThrottlingResponse) {
            this.numCallbacks_$eq(this.numCallbacks() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)response2);
        }
    }

    @Before
    public void beforeMethod() {
        this.numCallbacks_$eq(0);
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return quotaManager.maybeRecordAndGetThrottleTimeMs(new RequestChannel.Session(principal, null), clientId, value, this.time().milliseconds());
    }

    private void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        RequestChannel.Request request;
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RequestChannel.Request request2 = request = (RequestChannel.Request)tuple2._2();
        RequestChannel.Request request3 = request2;
        quotaManager.throttle(request3, throttleTimeMs, channelThrottlingCallback);
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder(33).append("Default producer quota should be ").append(config.quotaBytesPerSecondDefault()).toString(), (double)config.quotaBytesPerSecondDefault(), (double)clientMetrics.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota$1("userA", "client1", 5000, 4500, false, quotaManager);
            this.checkQuota$1("userA", "client2", 4000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client3", 4000, 0, true, quotaManager);
            this.checkQuota$1("userA", "client1", 5000, 0, false, quotaManager);
            this.checkQuota$1("userB", "client1", 7000, 8000, true, quotaManager);
            this.checkQuota$1("userB", "client2", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userB", "client3", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userD", "client1", 3000, 3500, true, quotaManager);
            this.checkQuota$1("userD", "client2", 3000, 2500, false, quotaManager);
            this.checkQuota$1("userE", "client1", 3000, 2500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota$1("userD", "client1", 1000, 0, false, quotaManager);
            this.checkQuota$1("userE", "client4", 1000, 1500, true, quotaManager);
            this.checkQuota$1("userF", "client4", 1000, 800, false, quotaManager);
            this.checkQuota$1("userF", "client5", 1000, 800, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota$1("userF", "client4", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 2500, true, quotaManager);
            this.checkQuota$1("userG", "client5", 2000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota$1("userA", "client2", 8000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client2", 8000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 6000, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 8000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota$1("userA", "client6", 11000, 8500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 12000, 4000, true, quotaManager);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assert.assertEquals((long)0L, (long)this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int sleepTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            this.throttle(clientMetrics, "ANONYMOYUS", "unknown", sleepTime, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)sleepTime);
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 0.0));
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testRequestPercentageQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time(), "", (Option)None$.MODULE$);
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Request", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assert.assertEquals((long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0)));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(67.1));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            this.throttle((ClientQuotaManager)quotaManager, "ANONYMOYUS", "test-client", throttleTime, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(500.0)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.time().sleep(1000L);
                Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            });
            this.time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            metrics.removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            metrics.removeSensor("ProduceThrottleTime-:client1");
            metrics.removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        String clientId = "client@#$%";
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = metrics.getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
        }
    }

    private final void checkQuota$1(String user, String clientId, int expectedBound, int value, boolean expectThrottle, ClientQuotaManager quotaManager$1) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager$1.quota(user, clientId).bound(), (double)0.0);
        int throttleTimeMs = this.maybeRecord(quotaManager$1, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
    }

    private static final double millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable & scala.Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                return !(string != null ? !string.equals(string2) : string2 != null) ? ConfigEntityName$.MODULE$.Default() : Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.user();
                    break;
                }
                case 1: {
                    option = this.clientId();
                    break;
                }
                case 2: {
                    option = this.configUser();
                    break;
                }
                case 3: {
                    option = this.configClientId();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            if (((UserClient)object).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

