/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\t9B)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000bE\u0001A\u0011\u0001\n\u00029Q,7\u000f\u001e,bY&$G)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ugR\t1\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0003V]&$\bF\u0001\t\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\")1\u0005\u0001C\u0005I\u0005\u0001c/\u00197jI\u0006$XMV1mS\u0012$U\r\\3uKR{\u0007/[2SKF,Xm\u001d;t)\t\u0019R\u0005C\u0003'E\u0001\u0007q%A\u0004sKF,Xm\u001d;\u0011\u0005!\u0002T\"A\u0015\u000b\u0005)Z\u0013\u0001\u0003:fcV,7\u000f^:\u000b\u00051j\u0013AB2p[6|gN\u0003\u0002\u0006])\u0011qFH\u0001\u0007CB\f7\r[3\n\u0005EJ#a\u0005#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$\b\"B\u001a\u0001\t\u0003\u0011\u0012\u0001\b;fgR,%O]8s\t\u0016dW\r^3U_BL7MU3rk\u0016\u001cHo\u001d\u0015\u0003eiAQA\u000e\u0001\u0005\n]\n\u0001E^1mS\u0012\fG/Z#se>\u0014H)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ugR\u00191\u0003O\u001d\t\u000b\u0019*\u0004\u0019A\u0014\t\u000bi*\u0004\u0019A\u001e\u0002!\u0015D\b/Z2uK\u0012\u0014Vm\u001d9p]N,\u0007\u0003\u0002\u001fD\r&s!!P!\u0011\u0005y*R\"A \u000b\u0005\u00013\u0011A\u0002\u001fs_>$h(\u0003\u0002C+\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\u00075\u000b\u0007O\u0003\u0002C+A\u0011AhR\u0005\u0003\u0011\u0016\u0013aa\u0015;sS:<\u0007C\u0001&N\u001b\u0005Y%B\u0001',\u0003!\u0001(o\u001c;pG>d\u0017B\u0001(L\u0005\u0019)%O]8sg\")\u0001\u000b\u0001C\u0001%\u0005\tB/Z:u\u001d>$8i\u001c8ue>dG.\u001a:)\u0005=S\u0002\"B*\u0001\t\u0013!\u0016A\u0006<bY&$\u0017\r^3U_BL7-S:EK2,G/\u001a3\u0015\u0005M)\u0006\"\u0002,S\u0001\u00041\u0015!\u0002;pa&\u001c\u0007\"\u0002-\u0001\t\u0013I\u0016aF:f]\u0012$U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:u)\rQVL\u0018\t\u0003QmK!\u0001X\u0015\u0003)\u0011+G.\u001a;f)>\u0004\u0018nY:SKN\u0004xN\\:f\u0011\u00151s\u000b1\u0001(\u0011\u001dyv\u000b%AA\u0002\u0001\fAb]8dW\u0016$8+\u001a:wKJ\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u0003\u0002\u000f9,Go^8sW&\u0011QM\u0019\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\u0006O\u0002!I\u0001[\u0001\u0014g\u0016tG-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u000b\u0003S2\u0004\"\u0001\u000b6\n\u0005-L#\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0011\u00151c\r1\u0001n!\tAc.\u0003\u0002pS\tyQ*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fC\u0004r\u0001E\u0005I\u0011\u0002:\u0002CM,g\u000e\u001a#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003MT#\u0001\u0019;,\u0003U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u0013Ut7\r[3dW\u0016$'B\u0001>\u0016\u0003)\tgN\\8uCRLwN\\\u0005\u0003y^\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    @Test
    public void testValidDeleteTopicRequests() {
        int timeout = 10000;
        this.createTopic("topic-1", 1, 1, this.createTopic$default$4());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1"}))).asJava(), Predef$.MODULE$.int2Integer(timeout)).build());
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-3", "topic-4"}))).asJava(), Predef$.MODULE$.int2Integer(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        Option error = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.errors().values()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequests$1(x$1)));
        Assert.assertTrue((String)new StringBuilder(33).append("There should be no errors, found ").append(JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()).toString(), (boolean)error.isEmpty());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(request.topics()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.validateTopicIsDeleted(topic);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testErrorDeleteTopicRequests() {
        int timeout = 30000;
        String timeoutTopic = "invalid-timeout";
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid-topic"}))).asJava(), Predef$.MODULE$.int2Integer(timeout)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic("partial-topic-1", 1, 1, this.createTopic$default$4());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partial-topic-1", "partial-invalid-topic"}))).asJava(), Predef$.MODULE$.int2Integer(timeout)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-topic-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic(timeoutTopic, 5, 2, this.createTopic$default$4());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{timeoutTopic}))).asJava(), Predef$.MODULE$.int2Integer(0)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)timeoutTopic), (Object)Errors.REQUEST_TIMED_OUT)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !((KafkaServer)this.servers().head()).metadataCache().contains(timeoutTopic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Topic ").append(timeoutTopic).append(" is never deleted").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.validateTopicIsDeleted(timeoutTopic);
    }

    private void validateErrorDeleteTopicRequests(DeleteTopicsRequest request, Map<String, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        scala.collection.mutable.Map errors = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala();
        Assert.assertEquals((String)"The response size should match", (long)expectedResponse.size(), (long)response.errors().size());
        expectedResponse.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$1(this, expectedResponse, errors, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNotController() {
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not-controller"}))).asJava(), Predef$.MODULE$.int2Integer(1000)).build();
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.notControllerSocketServer());
        Errors error = (Errors)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()).head())._2();
        Assert.assertEquals((String)"Expected controller error when routed incorrectly", (Object)Errors.NOT_CONTROLLER, (Object)error);
    }

    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build()).topicMetadata()).asScala();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !metadata.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$3(topic, p))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("The topic ").append(topic).append(" should not exist").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.DELETE_TOPICS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return DeleteTopicsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.controllerSocketServer();
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, this.connectAndSend$default$3(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequests$1(Errors x$1) {
        Errors errors = x$1;
        Errors errors2 = Errors.NONE;
        return errors == null ? errors2 != null : !errors.equals(errors2);
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequests$1(DeleteTopicsRequestTest $this, Map expectedResponse$1, scala.collection.mutable.Map errors$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String topic = (String)tuple2._1();
            Errors expectedError = (Errors)tuple2._2();
            Assert.assertEquals((String)"The response error should match", (Object)expectedResponse$1.apply((Object)topic), (Object)errors$1.apply((Object)topic));
            Errors errors = expectedError;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                $this.validateTopicIsDeleted(topic);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$3(String topic$1, MetadataResponse.TopicMetadata p) {
        if (!p.topic().equals(topic$1)) return false;
        Errors errors = p.error();
        Errors errors2 = Errors.NONE;
        if (errors != null) {
            if (!errors.equals(errors2)) return false;
            return true;
        }
        if (errors2 == null) return true;
        return false;
    }
}

