/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001\u001d\u0011AER3uG\"\u0014V-];fgR$un\u001e8D_:4XM]:j_:\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000fE\u0001\u0001\u0019!C\u0005%\u0005A\u0001O]8ek\u000e,'/F\u0001\u0014!\u0011!RdH\u0010\u000e\u0003UQ!!\u0005\f\u000b\u0005]A\u0012aB2mS\u0016tGo\u001d\u0006\u0003\u000beQ!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO&\u0011a$\u0006\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u0005\u0001JcBA\u0011(!\t\u0011S%D\u0001$\u0015\t!c!\u0001\u0004=e>|GO\u0010\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&J\u0001\u0007!J,G-\u001a4\n\u0005)Z#AB*ue&twM\u0003\u0002)K!9Q\u0006\u0001a\u0001\n\u0013q\u0013\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHCA\u00184!\t\u0001\u0014'D\u0001&\u0013\t\u0011TE\u0001\u0003V]&$\bb\u0002\u001b-\u0003\u0003\u0005\raE\u0001\u0004q\u0012\n\u0004B\u0002\u001c\u0001A\u0003&1#A\u0005qe>$WoY3sA!)\u0001\b\u0001C!s\u0005Qa.^7Ce>\\WM]:\u0016\u0003i\u0002\"\u0001M\u001e\n\u0005q*#aA%oi\")a\b\u0001C!\u007f\u0005)1/\u001a;VaR\tq\u0006C\u0003B\u0001\u0011\u0005s(\u0001\u0005uK\u0006\u0014Hi\\<o\u0011\u0015\u0019\u0005\u0001\"\u0015E\u0003E\u0001(o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003_\u0015CQA\u0012\"A\u0002\u001d\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003vi&d'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015\u0001\u0006\u0001\"\u0003@\u00031Ig.\u001b;Qe>$WoY3s\u0011\u0015\u0011\u0006\u0001\"\u0003T\u00031\u0019'/Z1uKR{\u0007/[2t)\u0015!VlX1e!\u0011\u0001Sk\u0016\u001e\n\u0005Y[#aA'baB\u0011\u0001lW\u0007\u00023*\u0011!\fG\u0001\u0007G>lWn\u001c8\n\u0005qK&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006=F\u0003\rAO\u0001\n]VlGk\u001c9jGNDQ\u0001Y)A\u0002i\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bb\u00022R!\u0003\u0005\raY\u0001\bG>tg-[4t!\u0011\u0001SkH\u0010\t\u000f\u0015\f\u0006\u0013!a\u0001u\u0005\u0001Bo\u001c9jGN+hMZ5y'R\f'\u000f\u001e\u0005\u0006O\u0002!I\u0001[\u0001\u0013GJ,\u0017\r^3QCJ$\u0018\u000e^5p]6\u000b\u0007\u000fF\u0003jmb\f9\u0001\u0005\u0003IU^c\u0017BA6J\u00055a\u0015N\\6fI\"\u000b7\u000f['baB\u0011Qn\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003af\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003e>\fABR3uG\"\u0014V-];fgRL!\u0001^;\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\t\u0011x\u000eC\u0003xM\u0002\u0007!(A\tnCb\u0004\u0016M\u001d;ji&|gNQ=uKNDQ!\u001f4A\u0002i\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0005w\u0006\u0005qK\u0004\u0002}}:\u0011!%`\u0005\u0002M%\u0011q0J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019!!\u0002\u0003\u0007M+\u0017O\u0003\u0002\u0000K!I\u0011\u0011\u00024\u0011\u0002\u0003\u0007\u00111B\u0001\n_\u001a47/\u001a;NCB\u0004R\u0001I+X\u0003\u001b\u00012\u0001MA\b\u0013\r\t\t\"\n\u0002\u0005\u0019>tw\rC\u0004\u0002\u0016\u0001!I!a\u0006\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$HCBA\r\u0003W\ty\u0003E\u0003o\u00037\ty\"C\u0002\u0002\u001e=\u0014QBR3uG\"\u0014Vm\u001d9p]N,\u0007\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015\u0012,\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003S\t\u0019CA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0003[\t\u0019\u00021\u0001;\u0003!aW-\u00193fe&#\u0007\u0002CA\u0019\u0003'\u0001\r!a\r\u0002\u000fI,\u0017/^3tiB\u0019a.!\u000e\n\u0007\u0005]rN\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0003\u0004\u0002<\u0001!\taP\u0001&i\u0016\u001cHOV\u0019GKR\u001c\u0007nV5uQ\u0012{wO\\\"p]Z,'o]5p]\u0012K7/\u00192mK\u0012DC!!\u000f\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002Fm\tQA[;oSRLA!!\u0013\u0002D\t!A+Z:u\u0011\u0019\ti\u0005\u0001C\u0001\u007f\u0005IC/Z:u\u0019\u0006$Xm\u001d;GKR\u001c\u0007nV5uQ\u0012{wO\\\"p]Z,'o]5p]\u0012K7/\u00192mK\u0012DC!a\u0013\u0002@!1\u00111\u000b\u0001\u0005\u0002}\n!\u0005^3tiZ\u000bd)\u001a;dQ^KG\u000f\u001b+pa&\u001cG*\u001a<fY>3XM\u001d:jI\u0016\u001c\b\u0006BA)\u0003\u007fAa!!\u0017\u0001\t\u0003y\u0014A\u0006;fgR4\u0016GR3uG\"4%o\\7SKBd\u0017nY1)\t\u0005]\u0013q\b\u0005\n\u0003?\u0002\u0011\u0013!C\u0005\u0003C\nac\u0019:fCR,Gk\u001c9jGN$C-\u001a4bk2$HeM\u000b\u0003\u0003GR3aYA3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA9K\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA=\u0001E\u0005I\u0011BA>\u0003Y\u0019'/Z1uKR{\u0007/[2tI\u0011,g-Y;mi\u0012\"TCAA?U\rQ\u0014Q\r\u0005\n\u0003\u0003\u0003\u0011\u0013!C\u0005\u0003\u0007\u000bAd\u0019:fCR,\u0007+\u0019:uSRLwN\\'ba\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0006*\"\u00111BA3\u0001")
public class FetchRequestDownConversionConfigTest
extends BaseRequestTest {
    private KafkaProducer<String, String> producer = null;

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.initProducer();
    }

    @Override
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    @Override
    public void propertyOverrides(Properties properties) {
        super.propertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.LogMessageDownConversionEnableProp(), "false");
    }

    private void initProducer() {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3));
    }

    private Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, Map<String, String> configs, int topicSuffixStart) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1 & Serializable & scala.Serializable)t -> FetchRequestDownConversionConfigTest.$anonfun$createTopics$1(topicSuffixStart, BoxesRunTime.unboxToInt((Object)t)), IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = topicConfig.setProperty(k, v);
            return object;
        });
        return ((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> {
            Map<Object, Object> partitionToLeader = this.createTopic((String)topic, numPartitions, 1, topicConfig);
            return (Map)partitionToLeader.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                int leader = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToInteger((int)leader));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private int createTopics$default$4() {
        return 0;
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> partitionMap.put((TopicPartition)tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    private Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    @Test
    public void testV1FetchWithDownConversionDisabled() {
        Map<TopicPartition, Object> topicMap = this.createTopics(5, 1, this.createTopics$default$3(), this.createTopics$default$4());
        Seq topicPartitions = topicMap.keySet().toSeq();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> (RecordMetadata)this.producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get());
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)topicPartitions, this.createPartitionMap$default$3())).build((short)1);
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(((Tuple2)topicMap.head())._2$mcI$sp(), fetchRequest);
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestDownConversionConfigTest.$anonfun$testV1FetchWithDownConversionDisabled$2(fetchResponse, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLatestFetchWithDownConversionDisabled() {
        Map<TopicPartition, Object> topicMap = this.createTopics(5, 1, this.createTopics$default$3(), this.createTopics$default$4());
        Seq topicPartitions = topicMap.keySet().toSeq();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> (RecordMetadata)this.producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get());
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)topicPartitions, this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(((Tuple2)topicMap.head())._2$mcI$sp(), fetchRequest);
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestDownConversionConfigTest.$anonfun$testLatestFetchWithDownConversionDisabled$2(fetchResponse, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testV1FetchWithTopicLevelOverrides() {
        int x$16 = 5;
        int x$17 = 1;
        int x$18 = 0;
        Map<String, String> x$19 = this.createTopics$default$3();
        Map<TopicPartition, Object> conversionDisabledTopicsMap = this.createTopics(x$16, x$17, x$19, x$18);
        Seq conversionDisabledTopicPartitions = conversionDisabledTopicsMap.keySet().toSeq();
        Map topicConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true")}));
        Map<TopicPartition, Object> conversionEnabledTopicsMap = this.createTopics(5, 1, (Map<String, String>)topicConfig, 5);
        Seq conversionEnabledTopicPartitions = conversionEnabledTopicsMap.keySet().toSeq();
        Seq allTopics = (Seq)conversionDisabledTopicPartitions.$plus$plus((GenTraversableOnce)conversionEnabledTopicPartitions, Seq$.MODULE$.canBuildFrom());
        int leaderId = ((Tuple2)conversionDisabledTopicsMap.head())._2$mcI$sp();
        allTopics.foreach((Function1 & Serializable & scala.Serializable)tp -> (RecordMetadata)this.producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get());
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)allTopics, this.createPartitionMap$default$3())).build((short)1);
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId, fetchRequest);
        conversionDisabledTopicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestDownConversionConfigTest.$anonfun$testV1FetchWithTopicLevelOverrides$2(fetchResponse, tp);
            return BoxedUnit.UNIT;
        });
        conversionEnabledTopicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestDownConversionConfigTest.$anonfun$testV1FetchWithTopicLevelOverrides$3(fetchResponse, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testV1FetchFromReplica() {
        int x$20 = 5;
        int x$21 = 1;
        int x$22 = 0;
        Map<String, String> x$23 = this.createTopics$default$3();
        Map<TopicPartition, Object> conversionDisabledTopicsMap = this.createTopics(x$20, x$21, x$23, x$22);
        Seq conversionDisabledTopicPartitions = conversionDisabledTopicsMap.keySet().toSeq();
        Map topicConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true")}));
        Map<TopicPartition, Object> conversionEnabledTopicsMap = this.createTopics(5, 1, (Map<String, String>)topicConfig, 5);
        Seq conversionEnabledTopicPartitions = conversionEnabledTopicsMap.keySet().toSeq();
        Seq allTopicPartitions = (Seq)conversionDisabledTopicPartitions.$plus$plus((GenTraversableOnce)conversionEnabledTopicPartitions, Seq$.MODULE$.canBuildFrom());
        int leaderId = ((Tuple2)conversionDisabledTopicsMap.head())._2$mcI$sp();
        allTopicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> (RecordMetadata)this.producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get());
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forReplica((short)1, (int)1, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)allTopicPartitions, this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId, fetchRequest);
        allTopicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestDownConversionConfigTest.$anonfun$testV1FetchFromReplica$2(fetchResponse, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$createTopics$1(int topicSuffixStart$1, int t) {
        return new StringBuilder(5).append("topic").append(t + topicSuffixStart$1).toString();
    }

    public static final /* synthetic */ void $anonfun$testV1FetchWithDownConversionDisabled$2(FetchResponse fetchResponse$1, TopicPartition tp) {
        Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)((FetchResponse.PartitionData)fetchResponse$1.responseData().get((Object)tp)).error);
    }

    public static final /* synthetic */ void $anonfun$testLatestFetchWithDownConversionDisabled$2(FetchResponse fetchResponse$2, TopicPartition tp) {
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)fetchResponse$2.responseData().get((Object)tp)).error);
    }

    public static final /* synthetic */ void $anonfun$testV1FetchWithTopicLevelOverrides$2(FetchResponse fetchResponse$3, TopicPartition tp) {
        Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)((FetchResponse.PartitionData)fetchResponse$3.responseData().get((Object)tp)).error);
    }

    public static final /* synthetic */ void $anonfun$testV1FetchWithTopicLevelOverrides$3(FetchResponse fetchResponse$3, TopicPartition tp) {
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)fetchResponse$3.responseData().get((Object)tp)).error);
    }

    public static final /* synthetic */ void $anonfun$testV1FetchFromReplica$2(FetchResponse fetchResponse$4, TopicPartition tp) {
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)fetchResponse$4.responseData().get((Object)tp)).error);
    }
}

