/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.ProducerCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CR3uG\"\u0014V-];fgR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u001d\t\u0002\u00011A\u0005\nI\t\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002'A!A#H\u0010 \u001b\u0005)\"BA\t\u0017\u0015\t9\u0002$A\u0004dY&,g\u000e^:\u000b\u0005\u0015I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!AH\u000b\u0003\u001b-\u000bgm[1Qe>$WoY3s!\t\u0001\u0013F\u0004\u0002\"OA\u0011!%J\u0007\u0002G)\u0011AEB\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003Q\u0015Bq!\f\u0001A\u0002\u0013%a&\u0001\u0007qe>$WoY3s?\u0012*\u0017\u000f\u0006\u00020gA\u0011\u0001'M\u0007\u0002K%\u0011!'\n\u0002\u0005+:LG\u000fC\u00045Y\u0005\u0005\t\u0019A\n\u0002\u0007a$\u0013\u0007\u0003\u00047\u0001\u0001\u0006KaE\u0001\naJ|G-^2fe\u0002BQ\u0001\u000f\u0001\u0005Be\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002_!)1\b\u0001C\u0005y\u0005\u00112M]3bi\u00164U\r^2i%\u0016\fX/Z:u)\u0015iTI\u0013'\\!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0005sKF,Xm\u001d;t\u0015\t\u0011\u0005$\u0001\u0004d_6lwN\\\u0005\u0003\t~\u0012ABR3uG\"\u0014V-];fgRDQA\u0012\u001eA\u0002\u001d\u000b\u0001#\\1y%\u0016\u001c\bo\u001c8tK\nKH/Z:\u0011\u0005AB\u0015BA%&\u0005\rIe\u000e\u001e\u0005\u0006\u0017j\u0002\raR\u0001\u0012[\u0006D\b+\u0019:uSRLwN\u001c\"zi\u0016\u001c\b\"B';\u0001\u0004q\u0015a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\u0007=#vK\u0004\u0002Q%:\u0011!%U\u0005\u0002M%\u00111+J\u0001\ba\u0006\u001c7.Y4f\u0013\t)fKA\u0002TKFT!aU\u0013\u0011\u0005aKV\"A!\n\u0005i\u000b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u00069j\u0002\r!X\u0001\n_\u001a47/\u001a;NCB\u0004B\u0001\t0XA&\u0011ql\u000b\u0002\u0004\u001b\u0006\u0004\bC\u0001\u0019b\u0013\t\u0011WE\u0001\u0003M_:<\u0007\"\u00023\u0001\t\u0013)\u0017AE2sK\u0006$X\rU1si&$\u0018n\u001c8NCB$BAZ;woB!q\r\\,o\u001b\u0005A'BA5k\u0003\u0011)H/\u001b7\u000b\u0003-\fAA[1wC&\u0011Q\u000e\u001b\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u0005=\u0014hB\u0001 q\u0013\t\tx(\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0002ti\ni\u0001+\u0019:uSRLwN\u001c#bi\u0006T!!] \t\u000b-\u001b\u0007\u0019A$\t\u000b5\u001b\u0007\u0019\u0001(\t\u000fq\u001b\u0007\u0013!a\u0001;\")\u0011\u0010\u0001C\u0005u\u0006\u00012/\u001a8e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u0006w\u0006%\u0011Q\u0002\t\u0004}qt\u0018BA?@\u000551U\r^2i%\u0016\u001c\bo\u001c8tKB\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002\u0003\u00061!/Z2pe\u0012LA!a\u0002\u0002\u0002\tiQ*Z7pef\u0014VmY8sINDa!a\u0003y\u0001\u00049\u0015\u0001\u00037fC\u0012,'/\u00133\t\r\u0005=\u0001\u00101\u0001>\u0003\u001d\u0011X-];fgRDa!a\u0005\u0001\t\u0013I\u0014\u0001D5oSR\u0004&o\u001c3vG\u0016\u0014\bBBA\f\u0001\u0011\u0005\u0011(\u0001\u0018uKN$(I]8lKJ\u0014Vm\u001d9fGR\u001c\b+\u0019:uSRLwN\\:Pe\u0012,'/\u00118e'&TX\rT5nSR\u001c\b\u0006BA\u000b\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003CY\u0012!\u00026v]&$\u0018\u0002BA\u0013\u0003?\u0011A\u0001V3ti\"1\u0011\u0011\u0006\u0001\u0005\u0002e\na\u0005^3ti\u001a+Go\u00195SKF,Xm\u001d;We]KG\u000f[(wKJ\u001c\u0018N_3e\u001b\u0016\u001c8/Y4fQ\u0011\t9#a\u0007\t\r\u0005=\u0002\u0001\"\u0001:\u0003\r\"Xm\u001d;GKR\u001c\u0007NU3rk\u0016\u001cHO\u0016\u001bXSRD'+Z1e\u0007>lW.\u001b;uK\u0012DC!!\f\u0002\u001c!1\u0011Q\u0007\u0001\u0005\u0002e\nA\u0004^3ti\u001a+Go\u00195SKF,Xm\u001d;U_:{gNU3qY&\u001c\u0017\r\u000b\u0003\u00024\u0005m\u0001BBA\u001e\u0001\u0011\u0005\u0011(\u0001\u000euKN$8)\u001e:sK:$X\t]8dQZ\u000bG.\u001b3bi&|g\u000e\u000b\u0003\u0002:\u0005m\u0001BBA!\u0001\u0011\u0005\u0011(A\u0014uKN$Hi\\<o\u0007>tg/\u001a:tS>tw+\u001b;i\u0007>tg.Z2uS>tg)Y5mkJ,\u0007\u0006BA \u00037Aa!a\u0012\u0001\t\u0003I\u0014A\u000e;fgR$un\u001e8D_:4XM]:j_:4%o\\7CCR\u001c\u0007.\u001a3U_Vs'-\u0019;dQ\u0016$'+Z:qK\u000e$8o\u00144gg\u0016$\b\u0006BA#\u00037Aa!!\u0014\u0001\t\u0003I\u0014a\f;fgR\u001c%/Z1uK&s7M]3nK:$\u0018\r\u001c$fi\u000eDw+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\u0018J\\#se>\u0014\b\u0006BA&\u00037Aa!a\u0015\u0001\t\u0003I\u0014a\u0006;fgRT6\u000b\u001e3D_6\u0004(/Z:tK\u0012$v\u000e]5dQ\u0011\t\t&a\u0007\t\r\u0005e\u0003\u0001\"\u0001:\u0003e!Xm\u001d;['R$7i\\7qe\u0016\u001c8/\u001a3SK\u000e|'\u000fZ:)\t\u0005]\u00131\u0004\u0005\b\u0003?\u0002A\u0011BA1\u0003\u001d\u0011XmY8sIN$B!a\u0019\u0002lA!q\nVA3!\ry\u0018qM\u0005\u0005\u0003S\n\tA\u0001\u0004SK\u000e|'\u000f\u001a\u0005\t\u0003[\ni\u00061\u0001\u0002p\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004R!!\u001d\u0002xyt1APA:\u0013\r\t)hP\u0001\u000e\r\u0016$8\r\u001b*fgB|gn]3\n\u0007M\fIHC\u0002\u0002v}Bq!! \u0001\t\u0013\ty(\u0001\ndQ\u0016\u001c7NR3uG\"\u0014Vm\u001d9p]N,GcC\u0018\u0002\u0002\u0006\u0015\u0015\u0011RAF\u0003\u001bCq!a!\u0002|\u0001\u0007a*\u0001\nfqB,7\r^3e!\u0006\u0014H/\u001b;j_:\u001c\bbBAD\u0003w\u0002\ra_\u0001\u000eM\u0016$8\r\u001b*fgB|gn]3\t\r-\u000bY\b1\u0001H\u0011\u00191\u00151\u0010a\u0001\u000f\"9\u0011qRA>\u0001\u00049\u0015a\u00068v[6+7o]1hKN\u0004VM\u001d)beRLG/[8o\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+\u000bAb\u0019:fCR,Gk\u001c9jGN$\u0002\"a&\u0002\u001a\u0006u\u0015\u0011\u0015\t\u0005Ay;v\tC\u0004\u0002\u001c\u0006E\u0005\u0019A$\u0002\u00139,X\u000eV8qS\u000e\u001c\bbBAP\u0003#\u0003\raR\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u0015\u0005\r\u0016\u0011\u0013I\u0001\u0002\u0004\t)+A\u0004d_:4\u0017nZ:\u0011\t\u0001rvd\b\u0005\b\u0003S\u0003A\u0011BAV\u0003-\u0001(o\u001c3vG\u0016$\u0015\r^1\u0015\r\u00055\u0016QWA_!\u0011yE+a,\u0011\u000bQ\t\tlH\u0010\n\u0007\u0005MVC\u0001\bQe>$WoY3s%\u0016\u001cwN\u001d3\t\u000f5\u000b9\u000b1\u0001\u00028B!q*!/X\u0013\r\tYL\u0016\u0002\t\u0013R,'/\u00192mK\"9\u0011qRAT\u0001\u00049\u0005\"CAa\u0001E\u0005I\u0011BAb\u0003q\u0019'/Z1uKB\u000b'\u000f^5uS>tW*\u00199%I\u00164\u0017-\u001e7uIM*\"!!2+\u0007u\u000b9m\u000b\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C;oG\",7m[3e\u0015\r\t\u0019.J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAl\u0003\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tY\u000eAI\u0001\n\u0013\ti.\u0001\fde\u0016\fG/\u001a+pa&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyN\u000b\u0003\u0002&\u0006\u001d\u0007")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> producer = null;

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> partitionMap.put((TopicPartition)tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private void initProducer() {
        String x$21 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$22 = new StringSerializer();
        StringSerializer x$23 = new StringSerializer();
        int x$24 = TestUtils$.MODULE$.createProducer$default$2();
        long x$25 = TestUtils$.MODULE$.createProducer$default$3();
        long x$26 = TestUtils$.MODULE$.createProducer$default$4();
        int x$27 = TestUtils$.MODULE$.createProducer$default$5();
        int x$28 = TestUtils$.MODULE$.createProducer$default$6();
        int x$29 = TestUtils$.MODULE$.createProducer$default$7();
        int x$30 = TestUtils$.MODULE$.createProducer$default$8();
        String x$31 = TestUtils$.MODULE$.createProducer$default$9();
        int x$32 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$33 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$34 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$35 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$21, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$22, x$23));
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new scala.Serializable(null, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    int partitionLeaderId = A1._2$mcI$sp();
                    if (partitionLeaderId == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                int partitionLeaderId;
                Tuple2<TopicPartition, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (partitionLeaderId = tuple2._2$mcI$sp()) == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage1, partitionWithLargeMessage2}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        int responseSize3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse3.responseData()).asScala()).values().map((Function1 & Serializable & scala.Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(this, partitionData)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((responseSize3 <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData3.error);
        Assert.assertTrue((partitionData3.highWatermark > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData3).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(29).append("Expected ").append(size3).append(" to be smaller than ").append(maxResponseBytes).toString(), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(28).append("Expected ").append(size3).append(" to be larger than ").append(maxPartitionBytes).toString(), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < ((MemoryRecords)partitionData3.records).sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2, partitionWithLargeMessage1}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)A1._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> x2) {
                FetchResponse.PartitionData partitionData;
                Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> tuple2 = x2;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)(partitionData = (FetchResponse.PartitionData)tuple2._2())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$3) {
                return x$3.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$3) {
                return x$3.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2})), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData4.error);
        Assert.assertTrue((partitionData4.highWatermark > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData4).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(28).append("Expected ").append(size4).append(" to be larger than ").append(maxResponseBytes).toString(), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < ((MemoryRecords)partitionData4.records).sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).build((short)2);
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)maxPartitionBytes, (long)((MemoryRecords)partitionData.records).sizeInBytes());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    @Test
    public void testFetchRequestV4WithReadCommitted() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.lastStableOffset > 0L ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestToNonReplica$1(leader, x$9)));
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(nonReplicaId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)partitionData.error);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$36 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$37 = Integer.MAX_VALUE;
        int x$38 = batchSize;
        StringSerializer x$39 = new StringSerializer();
        ByteArraySerializer x$40 = new ByteArraySerializer();
        int x$41 = TestUtils$.MODULE$.createProducer$default$2();
        long x$42 = TestUtils$.MODULE$.createProducer$default$3();
        long x$43 = TestUtils$.MODULE$.createProducer$default$4();
        int x$44 = TestUtils$.MODULE$.createProducer$default$5();
        int x$45 = TestUtils$.MODULE$.createProducer$default$6();
        String x$46 = TestUtils$.MODULE$.createProducer$default$9();
        int x$47 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$48 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$49 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$50 = TestUtils$.MODULE$.createProducer$default$13();
        byte[] bytes = new byte[msgValueLen];
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$36, x$41, x$42, x$43, x$44, x$45, x$37, x$38, x$46, x$47, x$48, x$49, x$50, x$39, x$40);){
            indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable & scala.Serializable)x$11 -> producer.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)bytes)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        IndexedSeq futures = indexedSeq;
        futures.foreach((Function1 & Serializable & scala.Serializable)x$12 -> (RecordMetadata)x$12.get());
        short version = (short)1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1 & Serializable & scala.Serializable)x$13 -> this.fetch$1(version, msgValueLen * 1000, true, topicPartition2, leaderId2, batchSize));
        Option response = this.fetch$1(version, batchSize, false, topicPartition2, leaderId2, batchSize);
        FetchResponse fetchResponse = (FetchResponse)response.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No fetch response");
        });
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
        Assert.assertEquals((long)3L, (long)batches.size());
    }

    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        String x$51 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$52 = 5;
        StringSerializer x$53 = new StringSerializer();
        StringSerializer x$54 = new StringSerializer();
        int x$55 = 30000;
        int x$56 = 60000;
        int x$57 = TestUtils$.MODULE$.createProducer$default$2();
        long x$58 = TestUtils$.MODULE$.createProducer$default$3();
        long x$59 = TestUtils$.MODULE$.createProducer$default$4();
        int x$60 = TestUtils$.MODULE$.createProducer$default$8();
        String x$61 = TestUtils$.MODULE$.createProducer$default$9();
        int x$62 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$63 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$64 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$65 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$51, x$57, x$58, x$59, x$52, x$56, x$55, x$60, x$61, x$62, x$63, x$64, x$65, x$53, x$54));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_11_0_IV2$.MODULE$.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        String topic = topicPartition2.topic();
        IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        firstBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$15 -> (RecordMetadata)x$15.get());
        secondBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$16 -> (RecordMetadata)x$16.get());
        long x$66 = 3L;
        long x$67 = 3L;
        short x$68 = 1;
        int x$69 = 22;
        byte x$70 = 0;
        this.check$1(x$66, x$68, x$67, x$69, x$70, topicPartition2, leaderId2);
        long x$71 = 15L;
        long x$72 = 15L;
        short x$73 = 1;
        int x$74 = 10;
        byte x$75 = 0;
        this.check$1(x$71, x$73, x$72, x$74, x$75, topicPartition2, leaderId2);
        long x$76 = 3L;
        long x$77 = 3L;
        short x$78 = 3;
        int x$79 = 22;
        byte x$80 = 1;
        this.check$1(x$76, x$78, x$77, x$79, x$80, topicPartition2, leaderId2);
        long x$81 = 15L;
        long x$82 = 15L;
        short x$83 = 3;
        int x$84 = 10;
        byte x$85 = 1;
        this.check$1(x$81, x$83, x$82, x$84, x$85, topicPartition2, leaderId2);
        long x$86 = 3L;
        long x$87 = 0L;
        short x$88 = 4;
        int x$89 = 2;
        byte x$90 = 2;
        this.check$1(x$86, x$88, x$87, x$89, x$90, topicPartition2, leaderId2);
        long x$91 = 15L;
        long x$92 = 10L;
        short x$93 = 4;
        int x$94 = 1;
        byte x$95 = 2;
        this.check$1(x$91, x$93, x$92, x$94, x$95, topicPartition2, leaderId2);
        long x$96 = 10L;
        long x$97 = 10L;
        short x$98 = 4;
        int x$99 = 1;
        byte x$100 = 2;
        this.check$1(x$96, x$98, x$97, x$99, x$100, topicPartition2, leaderId2);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopic("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})))}))));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp1 = this.sendFetchRequest(0, req1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((String)"Expected the broker to create a new incremental fetch session", (resp1.sessionId() > 0 ? 1 : 0) != 0);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Test created an incremental fetch session ").append(resp1.sessionId()).toString());
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo0));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo0)).error);
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo1)).error);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)bar0)).error);
        FetchRequest req2 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp2 = this.sendFetchRequest(0, req2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((String)"Expected the broker to continue the incremental fetch session", (long)resp1.sessionId(), (long)resp2.sessionId());
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp2.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp2.responseData().get((Object)bar0)).error);
        this.createTopic("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))));
        FetchRequest req3 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp3 = this.sendFetchRequest(0, req3);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp3.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp3.responseData().get((Object)bar0)).error);
        FetchRequest req4 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp4 = this.sendFetchRequest(0, req4);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo1));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(bar0));
    }

    @Test
    public void testZStdCompressedTopic() {
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ZStdCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        String x$101 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$102 = new StringSerializer();
        StringSerializer x$103 = new StringSerializer();
        int x$104 = TestUtils$.MODULE$.createProducer$default$2();
        long x$105 = TestUtils$.MODULE$.createProducer$default$3();
        long x$106 = TestUtils$.MODULE$.createProducer$default$4();
        int x$107 = TestUtils$.MODULE$.createProducer$default$5();
        int x$108 = TestUtils$.MODULE$.createProducer$default$6();
        int x$109 = TestUtils$.MODULE$.createProducer$default$7();
        int x$110 = TestUtils$.MODULE$.createProducer$default$8();
        String x$111 = TestUtils$.MODULE$.createProducer$default$9();
        int x$112 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$113 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$114 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$115 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$101, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$102, x$103));
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key1", (Object)"value1")).get();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key2", (Object)"value2")).get();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key3", (Object)"value3")).get();
        this.producer().close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res0 = this.sendFetchRequest(leaderId2, req0);
        FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)res0.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data0.error);
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res1 = this.sendFetchRequest(leaderId2, req1);
        FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)res1.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)data1.error);
        Assert.assertEquals((long)3L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data1).size());
    }

    @Test
    public void testZStdCompressedRecords() {
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ProducerCompressionCodec$.MODULE$.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)"2.0.0")}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        String x$116 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$117 = GZIPCompressionCodec$.MODULE$.name();
        StringSerializer x$118 = new StringSerializer();
        StringSerializer x$119 = new StringSerializer();
        int x$120 = TestUtils$.MODULE$.createProducer$default$2();
        long x$121 = TestUtils$.MODULE$.createProducer$default$3();
        long x$122 = TestUtils$.MODULE$.createProducer$default$4();
        int x$123 = TestUtils$.MODULE$.createProducer$default$5();
        int x$124 = TestUtils$.MODULE$.createProducer$default$6();
        int x$125 = TestUtils$.MODULE$.createProducer$default$7();
        int x$126 = TestUtils$.MODULE$.createProducer$default$8();
        int x$127 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$128 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$129 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$130 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$116, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$117, x$127, x$128, x$129, x$130, x$118, x$119);
        producer1.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key1", (Object)"value1")).get();
        producer1.close();
        String x$131 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$132 = ZStdCompressionCodec$.MODULE$.name();
        StringSerializer x$133 = new StringSerializer();
        StringSerializer x$134 = new StringSerializer();
        int x$135 = TestUtils$.MODULE$.createProducer$default$2();
        long x$136 = TestUtils$.MODULE$.createProducer$default$3();
        long x$137 = TestUtils$.MODULE$.createProducer$default$4();
        int x$138 = TestUtils$.MODULE$.createProducer$default$5();
        int x$139 = TestUtils$.MODULE$.createProducer$default$6();
        int x$140 = TestUtils$.MODULE$.createProducer$default$7();
        int x$141 = TestUtils$.MODULE$.createProducer$default$8();
        int x$142 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$143 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$144 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$145 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$131, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$132, x$142, x$143, x$144, x$145, x$133, x$134);
        producer2.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key2", (Object)"value2")).get();
        producer2.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key3", (Object)"value3")).get();
        producer2.close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res0 = this.sendFetchRequest(leaderId2, req0);
        FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)res0.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)data0.error);
        Assert.assertEquals((long)1L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data0).size());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res1 = this.sendFetchRequest(leaderId2, req1);
        FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)res1.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data1.error);
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res2 = this.sendFetchRequest(leaderId2, req2);
        FetchResponse.PartitionData data2 = (FetchResponse.PartitionData)res2.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)data2.error);
        Assert.assertEquals((long)1L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data2).size());
        FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res3 = this.sendFetchRequest(leaderId2, req3);
        FetchResponse.PartitionData data3 = (FetchResponse.PartitionData)res3.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data3.error);
        FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res4 = this.sendFetchRequest(leaderId2, req4);
        FetchResponse.PartitionData data4 = (FetchResponse.PartitionData)res4.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)data4.error);
        Assert.assertEquals((long)3L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data4).size());
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData<MemoryRecords> partitionData) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)partitionData.records).records()).asScala()).toIndexedSeq();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse<MemoryRecords> fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assert.assertEquals(expectedPartitions, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$1(this, fetchResponse, maxPartitionBytes, numMessagesPerPartition, emptyResponseSeen, responseSize, responseBufferSize, tp);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1 & Serializable & scala.Serializable)t -> FetchRequestTest.$anonfun$createTopics$1(BoxesRunTime.unboxToInt((Object)t)), IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = topicConfig.setProperty(k, v);
            return object;
        });
        return ((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> {
            scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic((String)topic, numPartitions, 2, topicConfig);
            return (scala.collection.immutable.Map)partitionToLeader.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                int leader = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToInteger((int)leader));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ProducerRecord<String, String>> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        void var3_3;
        Seq records = (Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable & scala.Serializable)tp -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable & scala.Serializable)messageIndex -> FetchRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        records.map((Function1 & Serializable & scala.Serializable)x$20 -> (RecordMetadata)this.producer().send(x$20).get(), Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private static final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(FetchRequestTest $this, FetchResponse.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)$this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestToNonReplica$1(int leader$1, KafkaServer x$9) {
        return x$9.config().brokerId() != leader$1;
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(brokerId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$1);
        Assert.assertEquals((Object)error, (Object)partitionData.error);
    }

    private final Option fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$2, int leaderId$2, int batchSize$1) {
        Some some;
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$2}))), this.createPartitionMap$default$3())).build(version);
        try (Socket socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, ApiKeys.FETCH, socket, this.send$default$4());
            if (closeAfterPartialResponse) {
                int size = new DataInputStream(socket.getInputStream()).readInt();
                Assert.assertTrue((String)new StringBuilder(56).append("Fetch size too small ").append(size).append(", broker may have run out of memory").toString(), (size > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0);
                some = None$.MODULE$;
            } else {
                some = new Some((Object)FetchResponse.parse((ByteBuffer)this.receive(socket), (short)version));
            }
        }
        return some;
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$3, int leaderId$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$3}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$3), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))))).build(requestVersion);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId$3, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$3);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
            MutableRecordBatch batch = (MutableRecordBatch)batches.head();
            Assert.assertEquals((long)expectedMagic, (long)batch.magic());
            Assert.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assert.assertEquals((long)expectedNumBatches, (long)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).toForget((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(toForget).asJava()).metadata(metadata).build();
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$1(FetchRequestTest $this, FetchResponse fetchResponse$1, int maxPartitionBytes$3, int numMessagesPerPartition$2, BooleanRef emptyResponseSeen$1, IntRef responseSize$1, IntRef responseBufferSize$1, TopicPartition tp) {
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse$1.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
        MemoryRecords records = (MemoryRecords)partitionData.records;
        responseBufferSize$1.elem += records.sizeInBytes();
        IndexedSeq batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).toIndexedSeq();
        Assert.assertTrue((batches.size() < numMessagesPerPartition$2 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assert.assertEquals((long)0L, (long)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
        } else if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assert.assertTrue((batchesSize <= maxPartitionBytes$3 ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes$3, (long)records.sizeInBytes());
        } else {
            if (batchesSize != 0 && emptyResponseSeen$1.elem) {
                throw $this.fail(new StringBuilder(53).append("Expected partition with size 0, but found ").append(tp).append(" with size ").append(batchesSize).toString(), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            }
            if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
                throw $this.fail(new StringBuilder(60).append("Expected partition buffer with size 0, but found ").append(tp).append(" with size ").append(records.sizeInBytes()).toString(), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
            }
        }
    }

    public static final /* synthetic */ String $anonfun$createTopics$1(int t) {
        return new StringBuilder(5).append("topic").append(t).toString();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringBuilder(1).append(tp$1).append("-").append(messageIndex).toString();
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringBuilder(4).append("key ").append(suffix).toString(), (Object)new StringBuilder(6).append("value ").append(suffix).toString());
    }
}

