/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001\u001d\u0011\u0001dR:tCBL\u0017)\u001e;iK:$\u0018nY1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0004CBL\u0017BA\u0007\u000b\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bCA\u0005\u0010\u0013\t\u0001\"BA\u0005TCNd7+\u001a;va\")!\u0003\u0001C\u0001'\u00051A(\u001b8jiz\"\u0012\u0001\u0006\t\u0003+\u0001i\u0011A\u0001\u0005\b/\u0001\u0011\r\u0011\"\u0011\u0019\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\u0016\u0003e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u00111!\u00138u\u0011\u0019\u0001\u0003\u0001)A\u00053\u0005a1/\u001a:wKJ\u001cu.\u001e8uA!)!\u0005\u0001C)G\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002IA\u0011Q%M\u0007\u0002M)\u0011q\u0005K\u0001\u0005CV$\bN\u0003\u0002*U\u0005A1/Z2ve&$\u0018P\u0003\u0002,Y\u000511m\\7n_:T!!B\u0017\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0005\u0003e\u0019\u0012\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000fQ\u0002!\u0019!C\u0005k\u0005A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t1\fgn\u001a\u0006\u0002w\u0005!!.\u0019<b\u0013\ti\u0004H\u0001\u0004TiJLgn\u001a\u0005\u0007\u007f\u0001\u0001\u000b\u0011\u0002\u001c\u00023-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX\u000e\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003\r\u00032\u0001R%7\u001b\u0005)%B\u0001$H\u0003%IW.\\;uC\ndWM\u0003\u0002I7\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005)+%\u0001\u0002'jgRDa\u0001\u0014\u0001!\u0002\u0013\u0019\u0015AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0003b\u0002(\u0001\u0005\u0004%I\u0001G\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\bB\u0002)\u0001A\u0003%\u0011$A\u0006ok6$\u0006N]3bIN\u0004\u0003b\u0002*\u0001\u0005\u0004%IaU\u0001\tKb,7-\u001e;peV\tA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005eS\u0014\u0001B;uS2L!a\u0017,\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016Da!\u0018\u0001!\u0002\u0013!\u0016!C3yK\u000e,Ho\u001c:!\u0011\u001dy\u0006A1A\u0005\n\u0001\fAb\u00197jK:$8i\u001c8gS\u001e,\u0012!\u0019\t\u0003E\u000el\u0011\u0001W\u0005\u0003Ib\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u00191\u0007\u0001)A\u0005C\u0006i1\r\\5f]R\u001cuN\u001c4jO\u0002B\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011B5\u0002\u0015M,'O^3s\u0003\u0012$'/F\u0001k!\tYg.D\u0001m\u0015\ti'(A\u0002oKRL!a\u001c7\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fC\u0005r\u0001\u0001\u0007\t\u0019!C\u0005e\u0006q1/\u001a:wKJ\fE\r\u001a:`I\u0015\fHCA:w!\tQB/\u0003\u0002v7\t!QK\\5u\u0011\u001d9\b/!AA\u0002)\f1\u0001\u001f\u00132\u0011%I\b\u00011A\u0001B\u0003&!.A\u0006tKJ4XM]!eIJ\u0004\u0003bB>\u0001\u0005\u0004%I\u0001`\u0001\u0005i&lW-F\u0001~!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\u0016\u0002\u000bU$\u0018\u000e\\:\n\u0007\u0005\u0015qP\u0001\u0005N_\u000e\\G+[7f\u0011\u001d\tI\u0001\u0001Q\u0001\nu\fQ\u0001^5nK\u0002B\u0001\"!\u0004\u0001\u0005\u0004%\t!N\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003#\u0001\u0001\u0015!\u00037\u0003\u0019!x\u000e]5dA!A\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0001$\u0001\u0003qCJ$\bbBA\r\u0001\u0001\u0006I!G\u0001\u0006a\u0006\u0014H\u000f\t\u0005\n\u0003;\u0001!\u0019!C\u0001\u0003?\t!\u0001\u001e9\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Ki\u0011AK\u0005\u0004\u0003OQ#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\"\u0005\u0019A\u000f\u001d\u0011\t\u0011\u0005=\u0002A1A\u0005\na\t1DZ1jY\u0016$\u0017)\u001e;iK:$\u0018nY1uS>tG)\u001a7bs6\u001b\bbBA\u001a\u0001\u0001\u0006I!G\u0001\u001dM\u0006LG.\u001a3BkRDWM\u001c;jG\u0006$\u0018n\u001c8EK2\f\u00170T:!\u0011\u001d\t9\u0004\u0001C!\u0003s\tQa]3u+B$\u0012a\u001d\u0015\u0005\u0003k\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019eL\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u000f\n\tE\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003\u0017\u0002A\u0011IA\u001d\u0003!!X-\u0019:E_^t\u0007\u0006BA%\u0003\u001f\u0002B!a\u0010\u0002R%!\u00111KA!\u0005\u0015\te\r^3s\u0011\u001d\t9\u0006\u0001C\u0001\u0003s\tA\u0003^3tiJ+\u0017/^3ti&\u001b\u0018IU3qY\u0006L\b\u0006BA+\u00037\u0002B!a\u0010\u0002^%!\u0011qLA!\u0005\u0011!Vm\u001d;\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002:\u0005!C/Z:u'\u0016\u0014h/\u001a:O_R4u.\u001e8e\u0013:\\UM\u001d2fe>\u001cH)\u0019;bE\u0006\u001cX\r\u000b\u0003\u0002b\u0005m\u0003bBA5\u0001\u0011\u0005\u0011\u0011H\u0001 i\u0016\u001cHoU3sm\u0016\u0014\u0018)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007\u0006BA4\u00037Bq!a\u001c\u0001\t\u0013\t\t(A\u0016wKJLg-\u001f*fiJL\u0017M\u00197f\r\u0006LG.\u001e:fg\u0012+(/\u001b8h\u0003V$\b.\u001a8uS\u000e\fG/[8o)\r\u0019\u00181\u000f\u0005\b\u0003k\ni\u00071\u0001\u001a\u0003IqW/\\*vG\u000e,7o\u001d4vY\u0006+H\u000f[:\t\u000f\u0005e\u0004\u0001\"\u0003\u0002:\u00059c/\u001a:jMftuN\u001c*fiJL\u0017M\u00197f\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:f\u0011\u001d\ti\b\u0001C\u0005\u0003\u007f\nab\u0019:fCR,7+\u001a7fGR|'\u000f\u0006\u0002\u0002\u0002B!\u00111QAE\u001b\t\t)IC\u0002\u0002\b*\nqA\\3uo>\u00148.\u0003\u0003\u0002\f\u0006\u0015%\u0001C*fY\u0016\u001cGo\u001c:")
public class GssapiAuthenticationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final int numThreads;
    private final ExecutorService executor;
    private final Properties clientConfig;
    private InetSocketAddress serverAddr;
    private final MockTime time;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int failedAuthenticationDelayMs;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private int numThreads() {
        return this.numThreads;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private Properties clientConfig() {
        return this.clientConfig;
    }

    private InetSocketAddress serverAddr() {
        return this.serverAddr;
    }

    private void serverAddr_$eq(InetSocketAddress x$1) {
        this.serverAddr = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private int failedAuthenticationDelayMs() {
        return this.failedAuthenticationDelayMs;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        this.serverConfig().put(KafkaConfig$.MODULE$.SslClientAuthProp(), "required");
        this.serverConfig().put(KafkaConfig$.MODULE$.FailedAuthenticationDelayMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.failedAuthenticationDelayMs())).toString());
        super.setUp();
        this.serverAddr_$eq(new InetSocketAddress("localhost", ((KafkaServer)this.servers().head()).boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT))));
        this.clientConfig().put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        this.clientConfig().put("sasl.mechanism", this.kafkaClientSaslMechanism());
        this.clientConfig().put("sasl.jaas.config", this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2()));
        this.clientConfig().put("connections.max.idle.ms", "5000");
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        this.executor().shutdownNow();
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testRequestIsAReplay() {
        int successfulAuthsPerThread = 10;
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numThreads()).map((Function1 & Serializable & scala.Serializable)x$1 -> GssapiAuthenticationTest.$anonfun$testRequestIsAReplay$1(this, successfulAuthsPerThread, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(60L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "failed-authentication-total"));
        long successfulAuths = TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "successful-authentication-total");
        Assert.assertTrue((String)new StringBuilder(25).append("Too few authentications: ").append(successfulAuths).toString(), (successfulAuths > (long)(successfulAuthsPerThread * this.numThreads()) ? 1 : 0) != 0);
    }

    @Test
    public void testServerNotFoundInKerberosDatabase() {
        String jaasConfig = this.clientConfig().getProperty("sasl.jaas.config");
        String invalidServiceConfig = jaasConfig.replace("serviceName=\"kafka\"", "serviceName=\"invalid-service\"");
        this.clientConfig().put("sasl.jaas.config", invalidServiceConfig);
        this.clientConfig().put("sasl.kerberos.service.name", "invalid-service");
        this.verifyNonRetriableAuthenticationFailure();
    }

    @Test
    public void testServerAuthenticationFailure() {
        String clientLoginContext = this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), (Option<String>)new Some((Object)"another-kafka-service"));
        Properties configOverrides = new Properties();
        configOverrides.setProperty("sasl.jaas.config", clientLoginContext);
        Properties x$3 = configOverrides;
        ByteArrayDeserializer x$4 = this.createConsumer$default$1();
        ByteArrayDeserializer x$5 = this.createConsumer$default$2();
        KafkaConsumer consumer = this.createConsumer(x$4, x$5, x$3);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        long startMs = System.currentTimeMillis();
        try {
            consumer.poll(Duration.ofMillis(50L));
            throw this.fail(new Position("GssapiAuthenticationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            long endMs = System.currentTimeMillis();
            Predef$.MODULE$.require(endMs - startMs < (long)this.failedAuthenticationDelayMs(), (Function0 & Serializable & scala.Serializable)() -> "Failed authentication must not be delayed on the client");
            consumer.close();
            return;
        }
    }

    public void kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(int numSuccessfulAuths) {
        try (Selector selector = this.createSelector();){
            int actualSuccessfulAuths = 0;
            while (actualSuccessfulAuths < numSuccessfulAuths) {
                String nodeId = ((Object)BoxesRunTime.boxToInteger((int)actualSuccessfulAuths)).toString();
                selector.connect(nodeId, this.serverAddr(), 1024, 1024);
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    selector.poll(100L);
                    ChannelState disconnectState = (ChannelState)selector.disconnected().get(nodeId);
                    if (disconnectState != null) {
                        Assert.assertEquals((String)new StringBuilder(37).append("Authentication failed with exception ").append((Object)disconnectState.exception()).toString(), (Object)ChannelState.State.AUTHENTICATE, (Object)disconnectState.state());
                    }
                    return selector.isChannelReady(nodeId) || disconnectState != null;
                }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Client not ready or disconnected within timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                if (selector.isChannelReady(nodeId)) {
                    ++actualSuccessfulAuths;
                }
                selector.close(nodeId);
            }
        }
    }

    private void verifyNonRetriableAuthenticationFailure() {
        Selector selector = this.createSelector();
        String nodeId = "1";
        selector.connect(nodeId, this.serverAddr(), 1024, 1024);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            selector.poll(100L);
            ChannelState disconnectState = (ChannelState)selector.disconnected().get(nodeId);
            if (disconnectState != null) {
                Assert.assertEquals((Object)ChannelState.State.AUTHENTICATION_FAILED, (Object)disconnectState.state());
            }
            return disconnectState != null;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Client not disconnected within timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private Selector createSelector() {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig((Map)this.clientConfig()), null, (String)this.kafkaClientSaslMechanism(), (boolean)true);
        return NetworkTestUtils.createSelector((ChannelBuilder)channelBuilder, (Time)this.time());
    }

    public static final /* synthetic */ Future $anonfun$testRequestIsAReplay$1(GssapiAuthenticationTest $this, int successfulAuthsPerThread$1, int x$1) {
        return $this.executor().submit(new Runnable($this, successfulAuthsPerThread$1){
            private final /* synthetic */ GssapiAuthenticationTest $outer;
            private final int successfulAuthsPerThread$1;

            public void run() {
                this.$outer.kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(this.successfulAuthsPerThread$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulAuthsPerThread$1 = successfulAuthsPerThread$1;
            }
        });
    }

    public GssapiAuthenticationTest() {
        SaslSetup.$init$(this);
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "GSSAPI";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"GSSAPI", (List)Nil$.MODULE$);
        this.numThreads = 10;
        this.executor = Executors.newFixedThreadPool(this.numThreads());
        this.clientConfig = new Properties();
        this.time = new MockTime(10L);
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.failedAuthenticationDelayMs = 2000;
    }
}

