/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001\u001d\u0011A\u0004S5hQ^\fG/\u001a:nCJ\\\u0007+\u001a:tSN$XM\\2f)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#A\u0004d_:4\u0017nZ:\u0016\u0003Y\u00012a\u0006\u000e\u001d\u001b\u0005A\"BA\r\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00037a\u00111aU3r!\t\u0011R$\u0003\u0002\u001f\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011\u0019\u0001\u0003\u0001)A\u0005-\u0005A1m\u001c8gS\u001e\u001c\b\u0005C\u0004#\u0001\t\u0007I\u0011A\u0012\u0002\u000bQ|\u0007/[2\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004TiJLgn\u001a\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\u0013\u0002\rQ|\u0007/[2!\u0011\u001dy\u0003A1A\u0005\u0002A\n\u0001B_6DY&,g\u000e^\u000b\u0002cA\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\u0003u.L!AN\u001a\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u0019A\u0004\u0001)A\u0005c\u0005I!p[\"mS\u0016tG\u000f\t\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0003-awnZ'b]\u0006<WM]:\u0016\u0003q\u00022a\u0006\u000e>!\tq\u0014)D\u0001@\u0015\t\u0001E!A\u0002m_\u001eL!AQ \u0003\u00151{w-T1oC\u001e,'\u000f\u0003\u0004E\u0001\u0001\u0006I\u0001P\u0001\rY><W*\u00198bO\u0016\u00148\u000f\t\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYN,\u0012\u0001\u0013\t\u0004/iI\u0005C\u0001\nK\u0013\tY%A\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002%\u0002-1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mg\u0002BQa\u0014\u0001\u0005\u0002A\u000b\u0001\u0002^3be\u0012|wO\u001c\u000b\u0002#B\u0011\u0011BU\u0005\u0003'*\u0011A!\u00168ji\"\u0012a*\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bQA[;oSRT\u0011AW\u0001\u0004_J<\u0017B\u0001/X\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003-\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016\u001c\u0016N\\4mKB\u000b'\u000f^5uS>t\u0007FA/a!\t1\u0016-\u0003\u0002c/\n!A+Z:u\u0011\u0015!\u0007\u0001\"\u0001Q\u00039\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016lU\u000f\u001c;ja2,\u0007+\u0019:uSRLwN\\:)\u0005\r\u0004\u0007\"B4\u0001\t\u0003A\u0017A\u00025x[\u001a{'\u000f\u0006\u0003jYFd\bCA\u0005k\u0013\tY'B\u0001\u0003M_:<\u0007\"B7g\u0001\u0004q\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003%=L!\u0001\u001d\u0002\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\")!E\u001aa\u0001eB\u00111O\u001f\b\u0003ib\u0004\"!\u001e\u0006\u000e\u0003YT!a\u001e\u0004\u0002\rq\u0012xn\u001c;?\u0013\tI(\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003WmT!!\u001f\u0006\t\u000bu4\u0007\u0019\u0001@\u0002\u0013A\f'\u000f^5uS>t\u0007CA\u0005\u0000\u0013\r\t\tA\u0003\u0002\u0004\u0013:$\b")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> {
        Seq x$2 = (Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom());
        CleanerConfig x$3 = new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9());
        LogConfig x$4 = TestUtils$.MODULE$.createLogManager$default$2();
        MockTime x$5 = TestUtils$.MODULE$.createLogManager$default$4();
        return TestUtils$.MODULE$.createLogManager((Seq<File>)x$2, x$4, x$3, x$5);
    }, Seq$.MODULE$.canBuildFrom());
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> new LogDirFailureChannel(config.logDirs().size()), Seq$.MODULE$.canBuildFrom());

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1 & Serializable & scala.Serializable)manager -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$1(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.getOrCreatePartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$6 = new TopicPartition(this.topic(), 0);
            LogConfig x$7 = LogConfig$.MODULE$.apply();
            boolean x$8 = qual$1.getOrCreateLog$default$3();
            boolean x$9 = qual$1.getOrCreateLog$default$4();
            Log log0 = qual$1.getOrCreateLog(x$6, x$7, x$8, x$9);
            Replica leaderReplicaPartition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), tp0, (Time)time, 0L, (Option)new Some((Object)log0));
            partition0.addReplicaIfNotExists(leaderReplicaPartition0);
            Replica followerReplicaPartition0 = new Replica(((KafkaConfig)this.configs().last()).brokerId(), tp0, (Time)time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            partition0.addReplicaIfNotExists(followerReplicaPartition0);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            ((Replica)partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.getOrCreatePartition(t1p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            TopicPartition x$10 = t1p0;
            LogConfig x$11 = LogConfig$.MODULE$.apply();
            boolean x$12 = qual$2.getOrCreateLog$default$3();
            boolean x$13 = qual$2.getOrCreateLog$default$4();
            Log topic1Log0 = qual$2.getOrCreateLog(x$10, x$11, x$12, x$13);
            Replica leaderReplicaTopic1Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), t1p0, (Time)time, 0L, (Option)new Some((Object)topic1Log0));
            topic1Partition0.addReplicaIfNotExists(leaderReplicaTopic1Partition0);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)leaderReplicaTopic1Partition0.highWatermark().messageOffset(), (long)topic1Partition0Hw);
            ((Replica)topic1Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)5L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            Assert.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.getOrCreatePartition(t2p0);
            LogManager qual$3 = (LogManager)this.logManagers().head();
            TopicPartition x$14 = t2p0;
            LogConfig x$15 = LogConfig$.MODULE$.apply();
            boolean x$16 = qual$3.getOrCreateLog$default$3();
            boolean x$17 = qual$3.getOrCreateLog$default$4();
            Log topic2Log0 = qual$3.getOrCreateLog(x$14, x$15, x$16, x$17);
            Replica leaderReplicaTopic2Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), t2p0, (Time)time, 0L, (Option)new Some((Object)topic2Log0));
            topic2Partition0.addReplicaIfNotExists(leaderReplicaTopic2Partition0);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)leaderReplicaTopic2Partition0.highWatermark().messageOffset(), (long)topic2Partition0Hw);
            ((Replica)topic2Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)15L, (long)leaderReplicaTopic2Partition0.highWatermark().messageOffset());
            ((Replica)topic1Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)10L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)10L, (long)topic1Partition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    public long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$teardown$2(File dir) {
        Utils.delete((File)dir);
    }

    public static final /* synthetic */ void $anonfun$teardown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)dir -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$2(dir);
            return BoxedUnit.UNIT;
        });
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

