/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#S:s\u000bb\u0004\u0018N]1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0001\u0016\u0003E!x\u000e]5d!\u0006\u0014H/\u001b;j_:L5O]\u000b\u0002-A!q\u0003\b\u00100\u001b\u0005A\"BA\r\u001b\u0003\u001diW\u000f^1cY\u0016T!a\u0007\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u001e1\t\u0019Q*\u00199\u0011\t%y\u0012\u0005L\u0005\u0003A)\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0012*\u001d\t\u0019s\u0005\u0005\u0002%\u00155\tQE\u0003\u0002'\r\u00051AH]8pizJ!\u0001\u000b\u0006\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003Q)\u0001\"!C\u0017\n\u00059R!aA%oiB\u0019\u0001'\u000e\u0017\u000f\u0005E\u001adB\u0001\u00133\u0013\u0005Y\u0011B\u0001\u001b\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!AN\u001c\u0003\u0007M+\u0017O\u0003\u00025\u0015!9\u0011\b\u0001a\u0001\n\u0003Q\u0014!\u0006;pa&\u001c\u0007+\u0019:uSRLwN\\%te~#S-\u001d\u000b\u0003wy\u0002\"!\u0003\u001f\n\u0005uR!\u0001B+oSRDqa\u0010\u001d\u0002\u0002\u0003\u0007a#A\u0002yIEBa!\u0011\u0001!B\u00131\u0012A\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\%te\u0002Bqa\u0011\u0001C\u0002\u0013\u0005A)A\nsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5/F\u0001F!\tIa)\u0003\u0002H\u0015\t!Aj\u001c8h\u0011\u0019I\u0005\u0001)A\u0005\u000b\u0006!\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002Bqa\u0013\u0001C\u0002\u0013\u0005A*A\u000bsKBd\u0017nY1GKR\u001c\u0007nV1ji6\u000b\u00070T:\u0016\u00031BaA\u0014\u0001!\u0002\u0013a\u0013A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\t\u000fA\u0003!\u0019!C\u0001\u0019\u0006\u0011B.Z1eKJdunZ#oI>3gm]3u\u0011\u0019\u0011\u0006\u0001)A\u0005Y\u0005\u0019B.Z1eKJdunZ#oI>3gm]3uA!9A\u000b\u0001b\u0001\n\u0003)\u0016aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\tU$\u0018\u000e\u001c\u0006\u00027\u0006!!.\u0019<b\u0013\ti\u0006L\u0001\u0006Qe>\u0004XM\u001d;jKNDaa\u0018\u0001!\u0002\u00131\u0016\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0011\u001d\t\u0007A1A\u0005\u0002\t\fqaY8oM&<7/F\u0001d!\r!WMZ\u0007\u00025%\u0011aG\u0007\t\u0003%\u001dL!\u0001\u001b\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0007U\u0002\u0001\u000b\u0011B2\u0002\u0011\r|gNZ5hg\u0002Bq\u0001\u001c\u0001C\u0002\u0013\u0005Q.A\u0003u_BL7-F\u0001o!\ty'/D\u0001q\u0015\t\t(,\u0001\u0003mC:<\u0017B\u0001\u0016q\u0011\u0019!\b\u0001)A\u0005]\u00061Ao\u001c9jG\u0002BqA\u001e\u0001C\u0002\u0013\u0005q/\u0001\u0003uS6,W#\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005m$\u0011!B;uS2\u001c\u0018BA?{\u0005!iunY6US6,\u0007BB@\u0001A\u0003%\u00010A\u0003uS6,\u0007\u0005C\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0001\u0002\u0006\u00059Q.\u001a;sS\u000e\u001cXCAA\u0004!\u0011\tI!a\u0007\u000e\u0005\u0005-!\u0002BA\u0002\u0003\u001bQA!a\u0004\u0002\u0012\u000511m\\7n_:T1!BA\n\u0015\u0011\t)\"a\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI\"A\u0002pe\u001eLA!!\b\u0002\f\t9Q*\u001a;sS\u000e\u001c\b\u0002CA\u0011\u0001\u0001\u0006I!a\u0002\u0002\u00115,GO]5dg\u0002B\u0011\"!\n\u0001\u0001\u0004%\t!a\n\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011\u0011\u0006\t\u0004%\u0005-\u0012bAA\u0017\u0005\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\"CA\u0019\u0001\u0001\u0007I\u0011AA\u001a\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0007m\n)\u0004C\u0005@\u0003_\t\t\u00111\u0001\u0002*!A\u0011\u0011\b\u0001!B\u0013\tI#A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007f\tQa]3u+B$\u0012a\u000f\u0015\u0005\u0003w\t\u0019\u0005\u0005\u0003\u0002F\u0005-SBAA$\u0015\u0011\tI%a\u0006\u0002\u000b),h.\u001b;\n\t\u00055\u0013q\t\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005E\u0003\u0001\"\u0001\u0002@\u0005AA/Z1s\t><h\u000e\u000b\u0003\u0002P\u0005U\u0003\u0003BA#\u0003/JA!!\u0017\u0002H\t)\u0011I\u001a;fe\"9\u0011Q\f\u0001\u0005\u0002\u0005}\u0012A\t;fgRL5O]#ya&\u0014\u0018\r^5p]\u001a{'o\u0015;vG.4u\u000e\u001c7po\u0016\u00148\u000f\u000b\u0003\u0002\\\u0005\u0005\u0004\u0003BA#\u0003GJA!!\u001a\u0002H\t!A+Z:u\u0011\u001d\tI\u0007\u0001C\u0001\u0003\u007f\tQ\u0005^3ti&\u001b(/\u0012=qSJ\fG/[8o\u0013\u001atuNR3uG\"\u0014V-];fgRl\u0015\rZ3)\t\u0005\u001d\u0014\u0011\r\u0005\b\u0003_\u0002A\u0011AA \u0003\u0005\"Xm\u001d;JgJ,\u0005\u0010]5sCRLwN\u001c$peNcwn\u001e$pY2|w/\u001a:tQ\u0011\ti'!\u0019\t\u000f\u0005U\u0004\u0001\"\u0001\u0002@\u0005)C/Z:u\u0013N\u0014X\t\u001f9je\u0006$\u0018n\u001c8G_J\u001c\u0015-^4iiV\u0003hi\u001c7m_^,'o\u001d\u0015\u0005\u0003g\n\t\u0007C\u0004\u0002|\u0001!I!! \u0002A\u001d,G\u000fU1si&$\u0018n\u001c8XSRD\u0017\t\u001c7SKBd\u0017nY1t\u0013:L5O\u001d\u000b\r\u0003\u007f\nY)!$\u0002\u0012\u0006u\u0015\u0011\u0015\t\u0005\u0003\u0003\u000b9)\u0004\u0002\u0002\u0004*\u0019\u0011Q\u0011\u0003\u0002\u000f\rdWo\u001d;fe&!\u0011\u0011RAB\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0004m\u0003s\u0002\r!\t\u0005\b\u0003\u001f\u000bI\b1\u0001-\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000fY\fI\b1\u0001\u0002\u0014B!\u0011QSAM\u001b\t\t9JC\u0002|\u0003\u001bIA!a'\u0002\u0018\n!A+[7f\u0011\u001d\ty*!\u001fA\u0002\u0019\faaY8oM&<\u0007\u0002CAR\u0003s\u0002\r!!*\u0002\u00111|7-\u00197M_\u001e\u0004B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003W#\u0011a\u00017pO&!\u0011qVAU\u0005\raun\u001a\u0005\b\u0003g\u0003A\u0011BA[\u0003\u001dawnZ'pG.,\"!!*\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\u0006\u0019r-\u001a;G_2dwn^3s%\u0016\u0004H.[2bgRA\u0011QXAc\u0003\u0013\fi\r\u0005\u00031k\u0005}\u0006\u0003BAA\u0003\u0003LA!a1\u0002\u0004\n9!+\u001a9mS\u000e\f\u0007\u0002CAd\u0003o\u0003\r!a \u0002\u0013A\f'\u000f^5uS>t\u0007bBAf\u0003o\u0003\r\u0001L\u0001\tY\u0016\fG-\u001a:JI\"9a/a.A\u0002\u0005M\u0005")
public class IsrExpirationTest {
    private Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private ReplicaManager replicaManager;

    public Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.leaderLogEndOffset() - 1), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.brokerId()), Set$.MODULE$.canBuildFrom()));
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()), Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()), Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 2), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.leaderLogEndOffset() - 2), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()), Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)r -> {
            r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.leaderLogEndOffset() - 1), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()), Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.brokerId()), Set$.MODULE$.canBuildFrom()));
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)r -> {
            r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)this.leaderLogEndOffset(), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.brokerId()), Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)this.leaderLogEndOffset(), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.brokerId()), Set$.MODULE$.canBuildFrom()));
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.brokerId()), Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().getOrCreatePartition(tp);
        Replica leaderReplica = new Replica(leaderId, tp, time, 0L, (Option)new Some((Object)localLog));
        Seq allReplicas = (Seq)this.getFollowerReplicas(partition, leaderId, time).$colon$plus((Object)leaderReplica, Seq$.MODULE$.canBuildFrom());
        allReplicas.foreach((Function1 & Serializable & scala.Serializable)r -> partition.addReplicaIfNotExists(r));
        partition.inSyncReplicas_$eq(allReplicas.toSet());
        partition.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), 0L, 0L, 0L, 0L, time.milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Log logMock() {
        void var1_1;
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        log.onHighWatermarkIncremented(0L);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        return var1_1;
    }

    private Seq<Replica> getFollowerReplicas(Partition partition, int leaderId, Time time) {
        return (Seq)((TraversableLike)this.configs().filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)IsrExpirationTest.$anonfun$getFollowerReplicas$1(leaderId, x$19)))).map((Function1 & Serializable & scala.Serializable)config -> new Replica(config.brokerId(), partition.topicPartition(), time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$getFollowerReplicas$1(int leaderId$1, KafkaConfig x$19) {
        return x$19.brokerId() != leaderId$1;
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.replicaManager = null;
    }
}

