/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.TimestampOffset;
import kafka.network.RequestChannel;
import kafka.security.auth.Authorizer;
import kafka.server.AdminManager;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.FetchManager;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r%g\u0001B\u0001\u0003\u0001\u001d\u0011QbS1gW\u0006\f\u0005/[:UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002-A\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\b]\u0016$xo\u001c:l\u0013\tY\u0002D\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\t\ru\u0001\u0001\u0015!\u0003\u0017\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0003bB\u0010\u0001\u0005\u0004%I\u0001I\u0001\u0016e\u0016\fX/Z:u\u0007\"\fgN\\3m\u001b\u0016$(/[2t+\u0005\t\u0003C\u0001\u0012&\u001d\t92%\u0003\u0002%1\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017B\u0001\u0014(\u0005\u001diU\r\u001e:jGNT!\u0001\n\r\t\r%\u0002\u0001\u0015!\u0003\"\u0003Y\u0011X-];fgR\u001c\u0005.\u00198oK2lU\r\u001e:jGN\u0004\u0003bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005i\u0003C\u0001\n/\u0013\ty#A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\rE\u0002\u0001\u0015!\u0003.\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003bB\u001a\u0001\u0005\u0004%I\u0001N\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J,\u0012!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nQa\u001a:pkBT!A\u000f\u0003\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0003y]\u0012\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\t\ry\u0002\u0001\u0015!\u00036\u0003E9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\t\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u00031\tG-\\5o\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0005C\u0001\nD\u0013\t!%A\u0001\u0007BI6Lg.T1oC\u001e,'\u000f\u0003\u0004G\u0001\u0001\u0006IAQ\u0001\u000eC\u0012l\u0017N\\'b]\u0006<WM\u001d\u0011\t\u000f!\u0003!\u0019!C\u0005\u0013\u0006qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014X#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055K\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:L!a\u0014'\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_JDa!\u0015\u0001!\u0002\u0013Q\u0015a\u0004;y]\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\t\u000fM\u0003!\u0019!C\u0005)\u0006Q1m\u001c8ue>dG.\u001a:\u0016\u0003U\u0003\"A\u0016-\u000e\u0003]S!a\u0015\u0003\n\u0005e;&aD&bM.\f7i\u001c8ue>dG.\u001a:\t\rm\u0003\u0001\u0015!\u0003V\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\t\u000fu\u0003!\u0019!C\u0005=\u0006A!p[\"mS\u0016tG/F\u0001`!\t\u00017-D\u0001b\u0015\t\u0011G!\u0001\u0002{W&\u0011A-\u0019\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\r\u0019\u0004\u0001\u0015!\u0003`\u0003%Q8n\u00117jK:$\b\u0005C\u0004i\u0001\t\u0007I\u0011B5\u0002\u000f5,GO]5dgV\t!\u000e\u0005\u0002li6\tAN\u0003\u0002i[*\u0011an\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0001(BA9s\u0003\u0019\t\u0007/Y2iK*\t1/A\u0002pe\u001eL!A\n7\t\rY\u0004\u0001\u0015!\u0003k\u0003!iW\r\u001e:jGN\u0004\u0003b\u0002=\u0001\u0005\u0004%I!_\u0001\tEJ|7.\u001a:JIV\t!\u0010\u0005\u0002\nw&\u0011AP\u0003\u0002\u0004\u0013:$\bB\u0002@\u0001A\u0003%!0A\u0005ce>\\WM]%eA!I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111A\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005\u0015\u0001c\u0001\n\u0002\b%\u0019\u0011\u0011\u0002\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u0015\u0011AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'\t!\"Y;uQ>\u0014\u0018N_3s+\t\t)\u0002E\u0003\n\u0003/\tY\"C\u0002\u0002\u001a)\u0011aa\u00149uS>t\u0007\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0005CV$\bNC\u0002\u0002&\u0011\t\u0001b]3dkJLG/_\u0005\u0005\u0003S\tyB\u0001\u0006BkRDwN]5{KJD\u0001\"!\f\u0001A\u0003%\u0011QC\u0001\fCV$\bn\u001c:ju\u0016\u0014\b\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024\u0005\u00112\r\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s+\t\t)\u0004E\u0002\u0013\u0003oI1!!\u000f\u0003\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u0011\u0005u\u0002\u0001)A\u0005\u0003k\t1c\u00197jK:$\u0018+^8uC6\u000bg.Y4fe\u0002B\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\u00023\rd\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM]\u000b\u0003\u0003\u000b\u00022AEA$\u0013\r\tIE\u0001\u0002\u001a\u00072LWM\u001c;SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'\u000f\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA#\u0003i\u0019G.[3oiJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:!\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019&A\nsKBd\u0017nY1Rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002VA\u0019!#a\u0016\n\u0007\u0005e#AA\fSKBd\u0017nY1uS>t\u0017+^8uC6\u000bg.Y4fe\"A\u0011Q\f\u0001!\u0002\u0013\t)&\u0001\u000bsKBd\u0017nY1Rk>$\u0018-T1oC\u001e,'\u000f\t\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003G\na!];pi\u0006\u001cXCAA3!\u0011\t9'a\u001f\u000f\t\u0005%\u0014q\u000f\b\u0005\u0003W\n)H\u0004\u0003\u0002n\u0005MTBAA8\u0015\r\t\tHB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!a\u0001\u0003\n\u0007\u0005e$!\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002~\u0005}$!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002z\tA\u0001\"a!\u0001A\u0003%\u0011QM\u0001\bcV|G/Y:!\u0011%\t9\t\u0001b\u0001\n\u0013\tI)\u0001\u0007gKR\u001c\u0007.T1oC\u001e,'/\u0006\u0002\u0002\fB\u0019!#!$\n\u0007\u0005=%A\u0001\u0007GKR\u001c\u0007.T1oC\u001e,'\u000f\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0011BAF\u000351W\r^2i\u001b\u0006t\u0017mZ3sA!I\u0011q\u0013\u0001C\u0002\u0013%\u0011\u0011T\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\"!a'\u0011\u0007I\ti*C\u0002\u0002 \n\u0011\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\t\u0011\u0005\r\u0006\u0001)A\u0005\u00037\u000b\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:!\u0011%\t9\u000b\u0001b\u0001\n\u0013\tI+A\u0005dYV\u001cH/\u001a:JIV\u0011\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0016\u0001\u00026bm\u0006LA!!/\u00020\n11\u000b\u001e:j]\u001eD\u0001\"!0\u0001A\u0003%\u00111V\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0003\"CAa\u0001\t\u0007I\u0011BAb\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003\u001bl!!!3\u000b\u0007\u0005-G!A\u0003vi&d7/\u0003\u0003\u0002P\u0006%'\u0001C'pG.$\u0016.\\3\t\u0011\u0005M\u0007\u0001)A\u0005\u0003\u000b\fQ\u0001^5nK\u0002Bq!a6\u0001\t\u0003\tI.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\tY\u000eE\u0002\n\u0003;L1!a8\u000b\u0005\u0011)f.\u001b;)\t\u0005U\u00171\u001d\t\u0005\u0003K\fY/\u0004\u0002\u0002h*\u0019\u0011\u0011\u001e:\u0002\u000b),h.\u001b;\n\t\u00055\u0018q\u001d\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003c\u0004A\u0011AAz\u0003=\u0019'/Z1uK.\u000bgm[1Ba&\u001cH\u0003BA{\u0003w\u00042AEA|\u0013\r\tIP\u0001\u0002\n\u0017\u000647.Y!qSND!\"!@\u0002pB\u0005\t\u0019AA\u0000\u0003iIg\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m-\u0016\u00148/[8o!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!b\u0001B\u0003\t\u0005\u0019\u0011\r]5\n\t\t%!1\u0001\u0002\u000b\u0003BLg+\u001a:tS>t\u0007b\u0002B\u0007\u0001\u0011\u0005\u0011\u0011\\\u0001%i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR<\u0016\u000e\u001e5J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]\"\"!1\u0002B\t!\u0011\t)Oa\u0005\n\t\tU\u0011q\u001d\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0003\u001a\u0001!\t!!7\u0002OQ,7\u000f\u001e+y]>3gm]3u\u0007>lW.\u001b;XSRD\u0017J\u001c<bY&$\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0005/\u0011\t\u0002C\u0004\u0003 \u0001!\t!!7\u0002UQ,7\u000f^!eIB\u000b'\u000f^5uS>t7\u000fV8Uq:<\u0016\u000e\u001e5J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]\"\"!Q\u0004B\t\u0011\u001d\u0011)\u0003\u0001C\u0001\u00033\fam\u001d5pk2$G\u000b\u001b:poVs7/\u001e9q_J$X\r\u001a,feNLwN\\#yG\u0016\u0004H/[8o\u001f:D\u0015M\u001c3mK\u0006#Gm\u00144gg\u0016$Hk\u001c+y]J+\u0017/^3ti^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dgj\u001c;TkB\u0004xN\u001d;fI\"B!1\u0005B\t\u0005S\u0011Y#\u0001\u0005fqB,7\r^3eG\t\u0011i\u0003\u0005\u0003\u00030\tURB\u0001B\u0019\u0015\r\u0011\u0019$\\\u0001\u0007KJ\u0014xN]:\n\t\t]\"\u0011\u0007\u0002\u001c+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012=dKB$\u0018n\u001c8\t\u000f\tm\u0002\u0001\"\u0001\u0002Z\u0006Q7\u000f[8vY\u0012$\u0006N]8x+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012=dKB$\u0018n\u001c8P]\"\u000bg\u000e\u001a7f\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RChNU3rk\u0016\u001cHo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0005\u0003:\tE!\u0011\u0006B\u0016\u0011\u001d\u0011\t\u0005\u0001C\u0001\u00033\fqm\u001d5pk2$G\u000b\u001b:poVs7/\u001e9q_J$X\r\u001a,feNLwN\\#yG\u0016\u0004H/[8o\u001f:D\u0015M\u001c3mKRChn\u00144gg\u0016$8i\\7nSR\u0014V-];fgR<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNT8u'V\u0004\bo\u001c:uK\u0012D\u0003Ba\u0010\u0003\u0012\t%\"1\u0006\u0005\b\u0005\u000f\u0002A\u0011AAm\u0003y\u001b\bn\\;mIRC'o\\<V]N,\b\u000f]8si\u0016$g+\u001a:tS>tW\t_2faRLwN\\(o\u0011\u0006tG\r\\3F]\u0012$\u0006P\u001c*fcV,7\u000f^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u001d>$8+\u001e9q_J$X\r\u001a\u0015\t\u0005\u000b\u0012\tB!\u000b\u0003,!9!Q\n\u0001\u0005\u0002\u0005e\u0017aZ:i_VdG\r\u00165s_^,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]>s\u0007*\u00198eY\u0016<&/\u001b;f)btW*\u0019:lKJ\u001c(+Z9vKN$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+\b\u000f]8si\u0016$\u0007\u0006\u0003B&\u0005#\u0011ICa\u000b\t\u000f\tM\u0003\u0001\"\u0001\u0002Z\u0006i6\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$gi\u001c:NKN\u001c\u0018mZ3G_Jl\u0017\r^(o\u0011\u0006tG\r\\3Xe&$X\r\u0016=o\u001b\u0006\u00148.\u001a:t/\",g.T1hS\u000edun^3s)\"\fgNU3rk&\u0014X\r\u001a\u0015\u0005\u0005#\u0012\t\u0002C\u0004\u0003Z\u0001!\t!!7\u0002kMDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00168l]><h\u000eV8qS\u000e<\u0006.\u001a8QCJ$\u0018\u000e^5p]&\u001bhj\u001c;I_N$X\r\u001a\u0015\u0005\u0005/\u0012\t\u0002C\u0004\u0003`\u0001!\t!!7\u0002'NDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00168tkB\u0004xN\u001d;fI6+7o]1hK\u001a{'/\\1u\r>\u0014()\u00193QCJ$\u0018\u000e^5p]\u0006sGMT8FeJ|'o\u001d$pe\u001e{w\u000e\u001a)beRLG/[8oQ\u0011\u0011iF!\u0005\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002Z\u0006\u00116\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5V].twn\u001e8U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u001a{'OQ1e!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a(p\u000bJ\u0014xN]:G_J<un\u001c3QCJ$\u0018\u000e^5p]\"\"!1\rB\t\u0011\u001d\u0011Y\u0007\u0001C\u0001\u00033\f\u0011h\u001d5pk2$\u0017\t\u001d9f]\u0012$v\u000eT8h\u001f:<&/\u001b;f)btW*\u0019:lKJ\u001cx\u000b[3o\u0007>\u0014(/Z2u\u001b\u0006<\u0017n\u0019,feNLwN\u001c\u0015\u0005\u0005S\u0012\t\u0002C\u0004\u0003r\u0001!\t!!7\u0002_Q,7\u000f\u001e'fC\u0012,'OU3qY&\u001c\u0017-\u00134M_\u000e\fGNU1jg\u0016\u001ch)\u001a8dK\u0012dU-\u00193fe\u0016\u0003xn\u00195)\t\t=$\u0011\u0003\u0005\b\u0005o\u0002A\u0011AAm\u0003A\"Xm\u001d;MK\u0006$WM\u001d*fa2L7-Y%g\u0019>\u001c\u0017\r\u001c*bSN,7/\u00168l]><h\u000eT3bI\u0016\u0014X\t]8dQ\"\"!Q\u000fB\t\u0011\u001d\u0011i\b\u0001C\u0001\u00033\f1\u0007^3ti2+\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u001adunY1m%\u0006L7/Z:O_RdU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8)\t\tm$\u0011\u0003\u0005\b\u0005\u0007\u0003A\u0011AAm\u0003U\"Xm\u001d;MK\u0006$WM\u001d*fa2L7-Y%g\u0019>\u001c\u0017\r\u001c*bSN,7/\u00168l]><h\u000eV8qS\u000e|%\u000fU1si&$\u0018n\u001c8)\t\t\u0005%\u0011\u0003\u0005\b\u0005\u0013\u0003A\u0011\u0002BF\u0003\u0011\"Xm\u001d;MSN$xJ\u001a4tKR4\u0015-\u001b7fI\u001e+G\u000fT3bI\u0016\u0014(+\u001a9mS\u000e\fG\u0003BAn\u0005\u001bC\u0001Ba$\u0003\b\u0002\u0007!\u0011S\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0005'\u0013I*\u0004\u0002\u0003\u0016*\u0019!qS7\u0002\u0011A\u0014x\u000e^8d_2LAAa'\u0003\u0016\n1QI\u001d:peNDqAa(\u0001\t\u0003\tI.A\u0016uKN$(+Z1e+:\u001cw.\\7jiR,GmQ8ogVlWM\u001d'jgR|eMZ:fi2\u000bG/Z:uQ\u0011\u0011iJ!\u0005\t\u000f\t\u0015\u0006\u0001\"\u0001\u0002Z\u0006IC/Z:u%\u0016\fGmQ8n[&$H/\u001a3D_:\u001cX/\\3s\u0019&\u001cHo\u00144gg\u0016$H*\u0019;fgRDCAa)\u0003\u0012!9!1\u0016\u0001\u0005\u0002\u0005e\u0017!\u0013;fgRlU\r^1eCR\f'+Z9vKN$xJ\\*iCJ,G\rT5ti\u0016tWM],ji\"LenY8og&\u001cH/\u001a8u\u0019&\u001cH/\u001a8feN\f5M]8tg\n\u0013xn[3sg\"\"!\u0011\u0016B\t\u0011\u001d\u0011\t\f\u0001C\u0001\u00033\f1\n^3ti6+G/\u00193bi\u0006\u0014V-];fgR|e\u000eR5ti&t7\r\u001e'jgR,g.\u001a:XSRD\u0017J\\2p]NL7\u000f^3oi2K7\u000f^3oKJ\u001c\u0018i\u0019:pgN\u0014%o\\6feNDCAa,\u0003\u0012!9!q\u0017\u0001\u0005\n\te\u0016\u0001L;qI\u0006$X-T3uC\u0012\fG/Y\"bG\",w+\u001b;i\u0013:\u001cwN\\:jgR,g\u000e\u001e'jgR,g.\u001a:t)\t\u0011Y\fE\u0004\n\u0005{\u0013\tM!1\n\u0007\t}&B\u0001\u0004UkBdWM\r\t\u0005\u0005\u0007\u00149-\u0004\u0002\u0003F*\u0011\u0011$\\\u0005\u0005\u0005\u0013\u0014)M\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0003N\u0002!IAa4\u0002YM,g\u000eZ'fi\u0006$\u0017\r^1SKF,Xm\u001d;XSRD\u0017J\\2p]NL7\u000f^3oi2K7\u000f^3oKJ\u001cH\u0003\u0002Bi\u0005;\u0004BAa5\u0003Z6\u0011!Q\u001b\u0006\u0004\u0005/l\u0017\u0001\u0003:fcV,7\u000f^:\n\t\tm'Q\u001b\u0002\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016D\u0001Ba8\u0003L\u0002\u0007!\u0011Y\u0001\u0010e\u0016\fX/Z:u\u0019&\u001cH/\u001a8fe\"9!1\u001d\u0001\u0005\n\t\u0015\u0018\u0001\b;fgR\u001cuN\\:v[\u0016\u0014H*[:u\u001f\u001a47/\u001a;MCR,7\u000f\u001e\u000b\u0005\u00037\u00149\u000f\u0003\u0005\u0003j\n\u0005\b\u0019\u0001Bv\u00039I7o\u001c7bi&|g\u000eT3wK2\u0004BAa5\u0003n&!!q\u001eBk\u00059I5o\u001c7bi&|g\u000eT3wK2DqAa=\u0001\t\u0013\u0011)0\u0001\u000fde\u0016\fG/Z,sSR,G\u000b\u001f8NCJ\\WM]:SKF,Xm\u001d;\u0015\t\t]8Q\u0001\t\b\u0013\tu&\u0011 B\u0000!\u0011\u0011\u0019Na?\n\t\tu(Q\u001b\u0002\u0017/JLG/\u001a+y]6\u000b'o[3sgJ+\u0017/^3tiB\u0019!e!\u0001\n\u0007\r\rqEA\u0004SKF,Xm\u001d;\t\u0011\r\u001d!\u0011\u001fa\u0001\u0007\u0013\t!\u0002]1si&$\u0018n\u001c8t!\u0019\u0019Ya!\u0005\u0004\u00165\u00111Q\u0002\u0006\u0005\u0007\u001f\t\u0019,\u0001\u0003vi&d\u0017\u0002BB\n\u0007\u001b\u0011A\u0001T5tiB!1qCB\r\u001b\u0005i\u0017bAB\u000e[\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBB\u0010\u0001\u0011%1\u0011E\u0001\rEVLG\u000e\u001a*fcV,7\u000f^\u000b\u0005\u0007G\u0019Y\u0003\u0006\u0004\u0004&\ru2q\n\t\b\u0013\tu6q\u0005B\u0000!\u0011\u0019Ica\u000b\r\u0001\u0011A1QFB\u000f\u0005\u0004\u0019yCA\u0001U#\u0011\u0019\tda\u000e\u0011\u0007%\u0019\u0019$C\u0002\u00046)\u0011qAT8uQ&tw\r\u0005\u0003\u0003T\u000ee\u0012\u0002BB\u001e\u0005+\u0014q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\t\u0007\u007f\u0019i\u00021\u0001\u0004B\u00059!-^5mI\u0016\u0014\bCBB\"\u0007\u0013\u001a9C\u0004\u0003\u0003T\u000e\u0015\u0013\u0002BB$\u0005+\fq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0005\u0005\u0007\u0017\u001aiEA\u0004Ck&dG-\u001a:\u000b\t\r\u001d#Q\u001b\u0005\u000b\u0007#\u001ai\u0002%AA\u0002\t\u0005\u0017\u0001\u00047jgR,g.\u001a:OC6,\u0007bBB+\u0001\u0011%1qK\u0001\re\u0016\fGMU3ta>t7/\u001a\u000b\t\u00073\u001ayfa\u001a\u0004lA!!1[B.\u0013\u0011\u0019iF!6\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007\u0002\u0003B\u0003\u0007'\u0002\ra!\u0019\u0011\t\tM51M\u0005\u0005\u0007K\u0012)JA\u0004Ba&\\U-_:\t\u0011\r%41\u000ba\u0001\u0007o\tqA]3rk\u0016\u001cH\u000f\u0003\u0005\u0004n\rM\u0003\u0019AB8\u0003A\u0019\u0017\r\u001d;ve\u0016$'+Z:q_:\u001cX\r\u0005\u0004\u0004r\r]41P\u0007\u0003\u0007gR1a!\u001es\u0003!)\u0017m]=n_\u000e\\\u0017\u0002BB=\u0007g\u0012qaQ1qiV\u0014X\rE\u0002#\u0007{J1aa (\u0005!\u0011Vm\u001d9p]N,\u0007bBBB\u0001\u0011%1QQ\u0001\u0013Kb\u0004Xm\u0019;O_RC'o\u001c;uY&tw\r\u0006\u0002\u0004p!91\u0011\u0012\u0001\u0005\n\r-\u0015aF:fiV\u0004()Y:jG6+G/\u00193bi\u0006\u001c\u0015m\u00195f)\u0019\tYn!$\u0004 \"A1qRBD\u0001\u0004\u0019\t*A\u0003u_BL7\r\u0005\u0003\u0004\u0014\u000eme\u0002BBK\u0007/\u00032!!\u001c\u000b\u0013\r\u0019IJC\u0001\u0007!J,G-\u001a4\n\t\u0005e6Q\u0014\u0006\u0004\u00073S\u0001bBBQ\u0007\u000f\u0003\rA_\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u0013\r\u0015\u0006!%A\u0005\u0002\r\u001d\u0016!G2sK\u0006$XmS1gW\u0006\f\u0005/[:%I\u00164\u0017-\u001e7uIE*\"a!++\t\u0005}81V\u0016\u0003\u0007[\u0003Baa,\u0004:6\u00111\u0011\u0017\u0006\u0005\u0007g\u001b),A\u0005v]\u000eDWmY6fI*\u00191q\u0017\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004<\u000eE&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1q\u0018\u0001\u0012\u0002\u0013%1\u0011Y\u0001\u0017EVLG\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU!11YBd+\t\u0019)M\u000b\u0003\u0003B\u000e-F\u0001CB\u0017\u0007{\u0013\raa\f")
public class KafkaApisTest {
    private final RequestChannel requestChannel = (RequestChannel)EasyMock.createNiceMock(RequestChannel.class);
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)EasyMock.createNiceMock(GroupCoordinator.class);
    private final AdminManager adminManager = (AdminManager)EasyMock.createNiceMock(AdminManager.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)EasyMock.createNiceMock(TransactionCoordinator.class);
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final MetadataCache metadataCache = new MetadataCache(this.brokerId());
    private final Option<Authorizer> authorizer = None$.MODULE$;
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)EasyMock.createNiceMock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)EasyMock.createNiceMock(ClientRequestQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), (Option)None$.MODULE$);
    private final FetchManager fetchManager = (FetchManager)EasyMock.createNiceMock(FetchManager.class);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final String clusterId;
    private final MockTime time = new MockTime();

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private AdminManager adminManager() {
        return this.adminManager;
    }

    private TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private FetchManager fetchManager() {
        return this.fetchManager;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private String clusterId() {
        return this.clusterId;
    }

    private MockTime time() {
        return this.time;
    }

    @After
    public void tearDown() {
        this.quotas().shutdown();
        this.metrics().close();
    }

    public KafkaApis createKafkaApis(ApiVersion interBrokerProtocolVersion) {
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        properties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerProtocolVersion.toString());
        properties.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), interBrokerProtocolVersion.toString());
        return new KafkaApis(this.requestChannel(), this.replicaManager(), this.adminManager(), this.groupCoordinator(), this.txnCoordinator(), this.controller(), this.zkClient(), this.brokerId(), new KafkaConfig((java.util.Map)properties), this.metadataCache(), this.metrics(), this.authorizer(), this.quotas(), this.fetchManager(), this.brokerTopicStats(), this.clusterId(), (Time)this.time(), null);
    }

    public ApiVersion createKafkaApis$default$1() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    @Test
    public void testOffsetCommitWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$1(-1, topic);
        this.checkInvalidPartition$1(1, topic);
    }

    @Test
    public void testTxnOffsetCommitWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$2(-1, topic);
        this.checkInvalidPartition$2(1, topic);
    }

    @Test
    public void testAddPartitionsToTxnWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$3(-1, topic);
        this.checkInvalidPartition$3(1, topic);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddOffsetToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddOffsetsToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddPartitionsToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleTxnOffsetCommitRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleEndTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleEndTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleWriteTxnMarkersRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleWriteTxnMarkersRequest(null);
    }

    @Test
    public void shouldRespondWithUnsupportedForMessageFormatOnHandleWriteTxnMarkersWhenMagicLowerThanRequired() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnknownTopicWhenPartitionIsNotHosted() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)None$.MODULE$);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnsupportedMessageFormatForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, tp2, responseCallback){
            private final TopicPartition tp2$1;
            private final Capture responseCallback$1;

            public void answer() {
                ((Function1)this.responseCallback$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$1), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.tp2$1 = tp2$1;
                this.responseCallback$1 = responseCallback$1;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldRespondWithUnknownTopicOrPartitionForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)None$.MODULE$);
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, tp2, responseCallback){
            private final TopicPartition tp2$2;
            private final Capture responseCallback$2;

            public void answer() {
                ((Function1)this.responseCallback$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$2), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.tp2$2 = tp2$2;
                this.responseCallback$2 = responseCallback$2;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldAppendToLogOnWriteTxnMarkersWhenCorrectMagicVersion() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        RequestChannel.Request request = (RequestChannel.Request)this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}))._2();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesFencedLeaderEpoch() {
        this.testListOffsetFailedGetLeaderReplica(Errors.FENCED_LEADER_EPOCH);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesUnknownLeaderEpoch() {
        this.testListOffsetFailedGetLeaderReplica(Errors.UNKNOWN_LEADER_EPOCH);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesNotLeaderForPartition() {
        this.testListOffsetFailedGetLeaderReplica(Errors.NOT_LEADER_FOR_PARTITION);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesUnknownTopicOrPartition() {
        this.testListOffsetFailedGetLeaderReplica(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    private void testListOffsetFailedGetLeaderReplica(Errors error) {
        TopicPartition tp = new TopicPartition("foo", 0);
        IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(15));
        EasyMock.expect((Object)this.replicaManager().fetchOffsetForTimestamp(tp, -2L, (Option)new Some((Object)isolationLevel), currentLeaderEpoch, true)).andThrow((Throwable)error.exception());
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        Map targetTimes = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ListOffsetRequest.PartitionData(-2L, currentLeaderEpoch))}));
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(targetTimes).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)error, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    @Test
    public void testReadUncommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_COMMITTED);
    }

    @Test
    public void testMetadataRequestOnSharedListenerWithInconsistentListenersAcrossBrokers() {
        ListenerName plaintextListener;
        Tuple2<ListenerName, ListenerName> tuple2 = this.updateMetadataCacheWithInconsistentListeners();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = plaintextListener = (ListenerName)tuple2._1();
        ListenerName plaintextListener2 = listenerName;
        MetadataResponse response = this.sendMetadataRequestWithInconsistentListeners(plaintextListener2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testMetadataRequestOnDistinctListenerWithInconsistentListenersAcrossBrokers() {
        ListenerName anotherListener;
        Tuple2<ListenerName, ListenerName> tuple2 = this.updateMetadataCacheWithInconsistentListeners();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = anotherListener = (ListenerName)tuple2._2();
        ListenerName anotherListener2 = listenerName;
        MetadataResponse response = this.sendMetadataRequestWithInconsistentListeners(anotherListener2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    private Tuple2<ListenerName, ListenerName> updateMetadataCacheWithInconsistentListeners() {
        ListenerName plaintextListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName anotherListener = new ListenerName("LISTENER2");
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker0", 9092, SecurityProtocol.PLAINTEXT, plaintextListener), new UpdateMetadataRequest.EndPoint("broker0", 9093, SecurityProtocol.PLAINTEXT, anotherListener)}))).asJava(), "rack"), new UpdateMetadataRequest.Broker(1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker1", 9092, SecurityProtocol.PLAINTEXT, plaintextListener)}))).asJava(), "rack")}));
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        this.metadataCache().updateMetadata(0, updateMetadataRequest);
        return new Tuple2((Object)plaintextListener, (Object)anotherListener);
    }

    private MetadataResponse sendMetadataRequestWithInconsistentListeners(ListenerName requestListener) {
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)MetadataRequest.Builder.allTopics(), requestListener);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MetadataRequest metadataRequest = (MetadataRequest)tuple2._1();
        RequestChannel.Request requestChannelRequest = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metadataRequest, (Object)requestChannelRequest);
        Tuple2 tuple23 = tuple22;
        MetadataRequest metadataRequest2 = (MetadataRequest)tuple23._1();
        RequestChannel.Request requestChannelRequest2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleTopicMetadataRequest(requestChannelRequest2);
        return (MetadataResponse)this.readResponse(ApiKeys.METADATA, (AbstractRequest)metadataRequest2, capturedResponse);
    }

    private void testConsumerListOffsetLatest(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        long latestOffset = 15L;
        Optional currentLeaderEpoch = Optional.empty();
        EasyMock.expect((Object)this.replicaManager().fetchOffsetForTimestamp(tp, -1L, (Option)new Some((Object)isolationLevel), currentLeaderEpoch, true)).andReturn((Object)new TimestampOffset(-1L, latestOffset));
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        Map targetTimes = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ListOffsetRequest.PartitionData(-1L, currentLeaderEpoch))}));
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(targetTimes).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)latestOffset), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    private Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> createWriteTxnMarkersRequest(java.util.List<TopicPartition> partitions) {
        WriteTxnMarkersRequest.Builder requestBuilder = new WriteTxnMarkersRequest.Builder(Utils.mkList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(1L, (short)1, 0, TransactionResult.COMMIT, partitions)}));
        return this.buildRequest((AbstractRequest.Builder)requestBuilder, this.buildRequest$default$2());
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics()));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private AbstractResponse readResponse(ApiKeys api, AbstractRequest request, Capture<RequestChannel.Response> capturedResponse) {
        RequestChannel.Response response = (RequestChannel.Response)capturedResponse.getValue();
        Assert.assertTrue((String)new StringBuilder(26).append("Unexpected response type: ").append(response.getClass()).toString(), (boolean)(response instanceof RequestChannel.SendResponse));
        RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)response;
        Send send = sendResponse.responseSend();
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        channel.buffer().getInt();
        ResponseHeader.parse((ByteBuffer)channel.buffer());
        Struct struct = api.responseSchema(request.version()).read(channel.buffer());
        return AbstractResponse.parseResponse((ApiKeys)api, (Struct)struct);
    }

    /*
     * WARNING - void declaration
     */
    private Capture<RequestChannel.Response> expectNoThrottling() {
        void var1_1;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.clientRequestQuotaManager().maybeRecordAndGetThrottleTimeMs((RequestChannel.Request)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToInteger((int)0));
        this.clientRequestQuotaManager().throttle((RequestChannel.Request)EasyMock.anyObject(), EasyMock.eq((int)0), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Capture capturedResponse = EasyMock.newCapture();
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        return var1_1;
    }

    private void setupBasicMetadataCache(String topic, int numPartitions) {
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)0), (List)Nil$.MODULE$)).asJava();
        UpdateMetadataRequest.PartitionState partitionState = new UpdateMetadataRequest.PartitionState(1, 0, 1, replicas, 0, replicas, Collections.emptyList());
        ListenerName plaintextListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        UpdateMetadataRequest.Broker broker = new UpdateMetadataRequest.Broker(0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker0", 9092, SecurityProtocol.PLAINTEXT, plaintextListener)}))).asJava(), "rack");
        scala.collection.immutable.Map partitions = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)x$13))), (Object)partitionState), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitions).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{broker}))).asJava()).build();
        this.metadataCache().updateMetadata(0, updateMetadataRequest);
    }

    private final void checkInvalidPartition$1(int invalidPartitionId, String topic$1) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        TopicPartition invalidTopicPartition = new TopicPartition(topic$1, invalidPartitionId);
        OffsetCommitRequest.PartitionData partitionOffsetCommitData = new OffsetCommitRequest.PartitionData(15L, 23L, "");
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new OffsetCommitRequest.Builder("groupId", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)invalidTopicPartition), (Object)partitionOffsetCommitData)}))).asJava()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)offsetCommitRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        OffsetCommitRequest offsetCommitRequest2 = (OffsetCommitRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleOffsetCommitRequest(request2);
        OffsetCommitResponse response = (OffsetCommitResponse)this.readResponse(ApiKeys.OFFSET_COMMIT, (AbstractRequest)offsetCommitRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.responseData().get(invalidTopicPartition));
    }

    private final void checkInvalidPartition$2(int invalidPartitionId, String topic$3) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        TopicPartition invalidTopicPartition = new TopicPartition(topic$3, invalidPartitionId);
        TxnOffsetCommitRequest.CommittedOffset partitionOffsetCommitData = new TxnOffsetCommitRequest.CommittedOffset(15L, "", Optional.empty());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new TxnOffsetCommitRequest.Builder("txnlId", "groupId", 15L, (short)0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)invalidTopicPartition), (Object)partitionOffsetCommitData)}))).asJava()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TxnOffsetCommitRequest offsetCommitRequest = (TxnOffsetCommitRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)offsetCommitRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        TxnOffsetCommitRequest offsetCommitRequest2 = (TxnOffsetCommitRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleTxnOffsetCommitRequest(request2);
        TxnOffsetCommitResponse response = (TxnOffsetCommitResponse)this.readResponse(ApiKeys.TXN_OFFSET_COMMIT, (AbstractRequest)offsetCommitRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(invalidTopicPartition));
    }

    private final void checkInvalidPartition$3(int invalidPartitionId, String topic$4) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        TopicPartition invalidTopicPartition = new TopicPartition(topic$4, invalidPartitionId);
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new AddPartitionsToTxnRequest.Builder("txnlId", 15L, (short)0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)invalidTopicPartition, (List)Nil$.MODULE$)).asJava()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        AddPartitionsToTxnRequest addPartitionsToTxnRequest = (AddPartitionsToTxnRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)addPartitionsToTxnRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        AddPartitionsToTxnRequest addPartitionsToTxnRequest2 = (AddPartitionsToTxnRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleAddPartitionToTxnRequest(request2);
        AddPartitionsToTxnResponse response = (AddPartitionsToTxnResponse)this.readResponse(ApiKeys.ADD_PARTITIONS_TO_TXN, (AbstractRequest)addPartitionsToTxnRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(invalidTopicPartition));
    }

    public KafkaApisTest() {
        this.brokerId = 1;
        this.clusterId = "clusterId";
    }
}

