/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u000f\t1B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\u0006#\u0001!\tAE\u0001\u001ai\u0016\u001cH\u000fT5ti>3gm]3ug\u0016\u0013(o\u001c:D_\u0012,7\u000fF\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0011)f.\u001b;)\u0005AQ\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\u0005y\u0012aA8sO&\u0011\u0011\u0005\b\u0002\u0005)\u0016\u001cH\u000fC\u0003$\u0001\u0011\u0005!#\u0001\u000euKN$8)\u001e:sK:$X\t]8dQZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002#5!)a\u0005\u0001C\u0005O\u0005\u0019\u0012m]:feR\u0014Vm\u001d9p]N,WI\u001d:peR!1\u0003K\u001b;\u0011\u0015IS\u00051\u0001+\u0003\u0015)'O]8s!\tY3'D\u0001-\u0015\tic&\u0001\u0005qe>$xnY8m\u0015\ty\u0003'\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bER!A\r\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t!DF\u0001\u0004FeJ|'o\u001d\u0005\u0006m\u0015\u0002\raN\u0001\tEJ|7.\u001a:JIB\u0011A\u0003O\u0005\u0003sU\u00111!\u00138u\u0011\u0015YT\u00051\u0001=\u0003\u001d\u0011X-];fgR\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u0018\u0002\u0011I,\u0017/^3tiNL!!\u0011 \u0003#1K7\u000f^(gMN,GOU3rk\u0016\u001cH\u000fC\u0003D\u0001\u0011%A)A\u0006tK:$'+Z9vKN$HcA#I\u0015B\u0011QHR\u0005\u0003\u000fz\u0012!\u0003T5ti>3gm]3u%\u0016\u001c\bo\u001c8tK\")\u0011J\u0011a\u0001o\u0005AA.Z1eKJLE\rC\u0003<\u0005\u0002\u0007A\b")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    @Test
    public void testListOffsetsErrorCodes() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        java.util.Map targetTimes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new ListOffsetRequest.PartitionData(-2L, Optional.of(Predef$.MODULE$.int2Integer(0))))}))).asJava();
        ListOffsetRequest consumerRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        ListOffsetRequest replicaRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetRequest debugReplicaRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$2(x$2)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, replicaRequest);
        this.assertResponseError(Errors.REPLICA_NOT_AVAILABLE, nonReplica, debugReplicaRequest);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetRequest request) {
        ListOffsetResponse response = this.sendRequest(brokerId, request);
        Assert.assertEquals((long)request.partitionTimestamps().size(), (long)response.responseData().size());
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.responseData()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)partitionData -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, partitionData);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetResponse sendRequest(int leaderId, ListOffsetRequest request) {
        SocketServer socketServer = this.brokerSocketServer(leaderId);
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.LIST_OFFSETS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ListOffsetResponse.parse((ByteBuffer)response, (short)request.version());
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        java.util.Map targetTimes = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$1), (Object)new ListOffsetRequest.PartitionData(-2L, currentLeaderEpoch))}))).asJava();
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetResponse.PartitionData partitionData) {
        Assert.assertEquals((Object)error$1, (Object)partitionData.error);
    }
}

