/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureTest$Checkpoint$;
import kafka.server.LogDirFailureTest$Roll$;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0002ba&L!!\u0004\u0006\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bBB\u000f\u0001A\u0003%a#\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f}\u0001!\u0019!C\u0001+\u0005i1m\u001c8tk6,'oQ8v]RDa!\t\u0001!\u0002\u00131\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bG\u0001\u0011\r\u0011\"\u0001\u0016\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\t\r\u0015\u0002\u0001\u0015!\u0003\u0017\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u001d9\u0003A1A\u0005\n!\nQ\u0001^8qS\u000e,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\"1!\u0007\u0001Q\u0001\n%\na\u0001^8qS\u000e\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%I!F\u0001\ra\u0006\u0014H/\u001b;j_:tU/\u001c\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\f\u0002\u001bA\f'\u000f^5uS>tg*^7!\u0011\u001dA\u0004A1A\u0005BU\t1\u0002\\8h\t&\u00148i\\;oi\"1!\b\u0001Q\u0001\nY\tA\u0002\\8h\t&\u00148i\\;oi\u0002BQ\u0001\u0010\u0001\u0005Bu\nQa]3u+B$\u0012A\u0010\t\u0003/}J!\u0001\u0011\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003w\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u000b),h.\u001b;\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tIEI\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u0017\u0002!\t!P\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7mQ\tQU\n\u0005\u0002D\u001d&\u0011q\n\u0012\u0002\u0005)\u0016\u001cH\u000fC\u0003R\u0001\u0011\u0005Q(A\u001dce>\\WM],ji\"|E\u000eZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d7\u000b[8vY\u0012D\u0015\r\u001c;P]2{w\rR5s\r\u0006LG.\u001e:fQ\t\u0001V\nC\u0003U\u0001\u0011\u0005Q(A\u0010uKN$\u0018jT#yG\u0016\u0004H/[8o\tV\u0014\u0018N\\4DQ\u0016\u001c7\u000e]8j]RD#aU'\t\u000b]\u0003A\u0011A\u001f\u0002iQ,7\u000f\u001e*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG-\u00114uKJdun\u001a#je\u001a\u000b\u0017\u000e\\;sK>sgi\u001c7m_^,'\u000f\u000b\u0002W\u001b\")!\f\u0001C\u00017\u0006)C/Z:u!J|G-^2f\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148MK\u0006$WM\u001d\u000b\u0003}qCQ!X-A\u0002y\u000b1BZ1jYV\u0014X\rV=qKB\u0011q\f\u001e\b\u0003A\u001et!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u00114\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019AaB\u0003i\u0005!\u0005\u0011.A\tM_\u001e$\u0015N\u001d$bS2,(/\u001a+fgR\u0004\"A\u00056\u0007\u000b\u0005\u0011\u0001\u0012A6\u0014\u0007)dw\u000e\u0005\u0002\u0018[&\u0011a\u000e\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]\u0001\u0018BA9\u0019\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015y!\u000e\"\u0001t)\u0005IgaB;k!\u0003\r\nC\u001e\u0002\u0012\u0019><G)\u001b:GC&dWO]3UsB,7C\u0001;mS\u0011!\b0a\u0016\u0007\u000beT\u0007\u0012\u0011>\u0003\u0015\rCWmY6q_&tGoE\u0003yYnlx\u000e\u0005\u0002}i6\t!\u000e\u0005\u0002\u0018}&\u0011q\u0010\u0007\u0002\b!J|G-^2u\u0011\u0019y\u0001\u0010\"\u0001\u0002\u0004Q\u0011\u0011Q\u0001\t\u0003ybD\u0001\"!\u0003y\u0003\u0003%\t\u0005K\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0011\u00055\u00010!A\u0005\u0002U\tA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"!\u0005y\u0003\u0003%\t!a\u0005\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QCA\u000e!\r9\u0012qC\u0005\u0004\u00033A\"aA!os\"I\u0011QDA\b\u0003\u0003\u0005\rAF\u0001\u0004q\u0012\n\u0004\"CA\u0011q\u0006\u0005I\u0011IA\u0012\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0013!\u0019\t9#!\f\u0002\u00165\u0011\u0011\u0011\u0006\u0006\u0004\u0003WA\u0012AC2pY2,7\r^5p]&!\u0011qFA\u0015\u0005!IE/\u001a:bi>\u0014\b\"CA\u001aq\u0006\u0005I\u0011AA\u001b\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001c\u0003{\u00012aFA\u001d\u0013\r\tY\u0004\u0007\u0002\b\u0005>|G.Z1o\u0011)\ti\"!\r\u0002\u0002\u0003\u0007\u0011Q\u0003\u0005\n\u0003\u0003B\u0018\u0011!C!\u0003\u0007\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002-!I\u0011q\t=\u0002\u0002\u0013\u0005\u0013\u0011J\u0001\ti>\u001cFO]5oOR\t\u0011\u0006C\u0005\u0002Na\f\t\u0011\"\u0003\u0002P\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\u0006E\u0002+\u0003'J1!!\u0016,\u0005\u0019y%M[3di\u001a9\u0011\u0011\f6\t\u0002\u0006m#\u0001\u0002*pY2\u001cb!a\u0016mwv|\u0007bB\b\u0002X\u0011\u0005\u0011q\f\u000b\u0003\u0003C\u00022\u0001`A,\u0011%\tI!a\u0016\u0002\u0002\u0013\u0005\u0003\u0006C\u0005\u0002\u000e\u0005]\u0013\u0011!C\u0001+!Q\u0011\u0011CA,\u0003\u0003%\t!!\u001b\u0015\t\u0005U\u00111\u000e\u0005\n\u0003;\t9'!AA\u0002YA!\"!\t\u0002X\u0005\u0005I\u0011IA\u0012\u0011)\t\u0019$a\u0016\u0002\u0002\u0013\u0005\u0011\u0011\u000f\u000b\u0005\u0003o\t\u0019\b\u0003\u0006\u0002\u001e\u0005=\u0014\u0011!a\u0001\u0003+A!\"!\u0011\u0002X\u0005\u0005I\u0011IA\"\u0011)\t9%a\u0016\u0002\u0002\u0013\u0005\u0013\u0011\n\u0005\u000b\u0003\u001b\n9&!A\u0005\n\u0005=saBA?U\"\u0005\u0015\u0011M\u0001\u0005%>dGnB\u0004\u0002\u0002*D\t)!\u0002\u0002\u0015\rCWmY6q_&tG\u000fC\u0005\u0002N)\f\t\u0011\"\u0003\u0002P!9\u0011q\u0011\u0001\u0005\n\u0005%\u0015!H:vEN\u001c'/\u001b2f\u0003:$w+Y5u\r>\u0014\u0018i]:jO:lWM\u001c;\u0015\u000by\nY)a'\t\u000f\u001d\n)\t1\u0001\u0002\u000eB!\u0011qRAL\u001d\u0011\t\t*a%\u0011\u0005\tD\u0012bAAK1\u00051\u0001K]3eK\u001aL1\u0001MAM\u0015\r\t)\n\u0007\u0005\t\u0003;\u000b)\t1\u0001\u0002 \u0006A1m\u001c8tk6,'\u000f\u0005\u0005\u0002\"\u0006=\u00161WAZ\u001b\t\t\u0019K\u0003\u0003\u0002\u001e\u0006\u0015&\u0002BAT\u0003S\u000bqa\u00197jK:$8OC\u0002\u0006\u0003WS1!!,G\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011WAR\u00055Y\u0015MZ6b\u0007>t7/^7feB)q#!.\u0002:&\u0019\u0011q\u0017\r\u0003\u000b\u0005\u0013(/Y=\u0011\u0007]\tY,C\u0002\u0002>b\u0011AAQ=uK\u0002")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), this.partitionNum(), this.serverCount(), this.createTopic$default$4());
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        block3: {
            VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
            Exit$.MODULE$.setHaltProcedure((Function2 & Serializable & scala.Serializable)(statusCode, x$1) -> LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$1));
            KafkaServer server = null;
            try {
                int x$12 = this.serverCount();
                String x$13 = this.zkConnect();
                int x$14 = 3;
                boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$3();
                boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$4();
                int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$5();
                Option<SecurityProtocol> x$18 = TestUtils$.MODULE$.createBrokerConfig$default$6();
                Option<File> x$19 = TestUtils$.MODULE$.createBrokerConfig$default$7();
                Option<Properties> x$20 = TestUtils$.MODULE$.createBrokerConfig$default$8();
                boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$9();
                boolean x$22 = TestUtils$.MODULE$.createBrokerConfig$default$10();
                int x$23 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                boolean x$24 = TestUtils$.MODULE$.createBrokerConfig$default$12();
                int x$25 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                boolean x$26 = TestUtils$.MODULE$.createBrokerConfig$default$14();
                int x$27 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                Option<String> x$28 = TestUtils$.MODULE$.createBrokerConfig$default$16();
                boolean x$29 = TestUtils$.MODULE$.createBrokerConfig$default$18();
                Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$13, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$14, x$29);
                props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
                props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
                KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
                File logDir = new File((String)kafkaConfig.logDirs().head());
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
                logDir.createNewFile();
                Assert.assertTrue((boolean)logDir.isFile());
                server = TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Option)statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for broker to halt", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            }
            catch (Throwable throwable) {
                Exit$.MODULE$.resetHaltProcedure();
                if (server != null) {
                    TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon(server, (List)Nil$.MODULE$));
                }
                throw throwable;
            }
            Exit$.MODULE$.resetHaltProcedure();
            if (server == null) break block3;
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        }
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$2))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$3))).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 != leaderServerId).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$6))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> leaderServer.replicaManager().getPartition(new TopicPartition(this.topic(), i)).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.leaderReplicaIfLocal()).isDefined()).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.serverCount(), (long)((Partition)leaderServer.replicaManager().getPartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicas().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$8))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(leaderServerId, x$9))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> consumer.poll(0L).count() == 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the first message", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Replica replica = leaderServer.replicaManager().localReplicaOrException(partition);
        File logDir = ((Log)replica.log().get()).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(logDirFailureTest$Roll$) : logDirFailureTest$Roll$ != null)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                Option x$30 = qual$1.roll$default$1();
                qual$1.roll(x$30);
                throw this.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            }
            catch (KafkaStorageException e) {}
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(logDirFailureTest$Checkpoint$) : logDirFailureTest$Checkpoint$ != null)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !leaderServer.logManager().isLogDirOnline(logDir.getAbsolutePath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected log directory offline", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((boolean)leaderServer.replicaManager().localReplica(partition).isEmpty());
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw this.fail("send() should fail with either KafkaStorageException or NotLeaderForPartitionException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof KafkaStorageException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (throwable instanceof NotLeaderForPartitionException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    throw this.fail(new StringBuilder(98).append("send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ").append(throwable2.toString()).toString(), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
                }
                throw new MatchError((Object)throwable);
            }
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                producer.send(record);
                return ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$10(x$10))).get()).leader().id() != leaderServerId;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected new leader for the partition", 6000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> consumer.poll(0L).count() > 0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected some messages", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
            KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$13(x$11))).get();
            Set offlineReplicas = controllerServer.kafkaController().replicaStateMachine().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$);
            Assert.assertTrue((boolean)offlineReplicas.contains((Object)new PartitionAndReplica(new TopicPartition(this.topic(), 0), leaderServerId)));
            return;
        }
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(0L);
            return !consumer.assignment().isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ Nothing$ $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$1) {
        statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$2) {
        return x$2.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$8) {
        return x$8.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int leaderServerId$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$10(PartitionInfo x$10) {
        return x$10.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$13(KafkaServer x$11) {
        return x$11.kafkaController().isActive();
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.serverCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static interface LogDirFailureType {
    }
}

