/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002T8h\u001f\u001a47/\u001a;UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\b\"B\u0007\u0001\t\u0003q\u0011A\u0002\u001fj]&$h\bF\u0001\u0010!\tI\u0001\u0001\u0003\u0005\u0012\u0001!\u0015\r\u0011\"\u0003\u0013\u0003\u0011!\u0018.\\3\u0016\u0003M\u0001\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005a)\"\u0001C'pG.$\u0016.\\3\t\u000bi\u0001A\u0011K\u000e\u0002\u00159,XN\u0011:pW\u0016\u00148/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0006G\u0001!\t\u0006J\u0001\u000bEJ|7.\u001a:US6,GCA\n&\u0011\u00151#\u00051\u0001\u001d\u0003!\u0011'o\\6fe&#\u0007\"\u0002\u0015\u0001\t#J\u0013!\u00059s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011!&\f\t\u0003;-J!\u0001\f\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006]\u001d\u0002\raL\u0001\u0006aJ|\u0007o\u001d\t\u0003aUj\u0011!\r\u0006\u0003eM\nA!\u001e;jY*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006q\u0001!\t!O\u0001\u001ei\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\r>\u0014XK\\6o_^tGk\u001c9jGR\t!\u0006\u000b\u00028wA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\tk$\u0001\u0002+fgRDQ\u0001\u0012\u0001\u0005\u0002e\n\u0001\u0005^3ti\u001e+Go\u00144gg\u0016$8/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u00121i\u000f\u0005\u0006\u000f\u0002!\t!O\u0001\u001fi\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3MCR,7\u000f\u001e+j[\u0016D#AR\u001e\t\u000b)\u0003A\u0011A\u001d\u0002/Q,7\u000f^#naRLHj\\4t\u000f\u0016$xJ\u001a4tKR\u001c\bFA%<\u0011\u0015i\u0005\u0001\"\u0001:\u0003]!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK:{w\u000f\u000b\u0002Mw!)\u0001\u000b\u0001C\u0001s\u0005\u0001C/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016,\u0015M\u001d7jKN$H+[7fQ\ty5\bC\u0003T\u0001\u0011\u0005\u0011(A\u0017uKN$h)\u001a;dQ>3gm]3ug\n+gm\u001c:f/&$\bn\u00115b]\u001eLgnZ*fO6,g\u000e^*ju\u0016D#AU\u001e\t\u000bY\u0003A\u0011A\u001d\u0002UQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001c()\u001a4pe\u0016<\u0016\u000e\u001e5DQ\u0006tw-\u001b8h'\u0016<W.\u001a8ug\"\u0012Qk\u000f\u0005\u0006\u0007\u0001!I!W\u000b\u00025B\u0011\u0011bW\u0005\u00039\n\u00111bS1gW\u0006\u001cVM\u001d<fe\")a\f\u0001C\u0005?\u000612/\u001a8e\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH\u000fF\u0002aWB\u0004\"!Y5\u000e\u0003\tT!a\u00193\u0002\u0011I,\u0017/^3tiNT!!\u001a4\u0002\r\r|W.\\8o\u0015\t)qM\u0003\u0002i\u007f\u00051\u0011\r]1dQ\u0016L!A\u001b2\u0003%1K7\u000f^(gMN,GOU3ta>t7/\u001a\u0005\u0006Yv\u0003\r!\\\u0001\be\u0016\fX/Z:u!\t\tg.\u0003\u0002pE\n\tB*[:u\u001f\u001a47/\u001a;SKF,Xm\u001d;\t\u000fEl\u0006\u0013!a\u0001e\u0006YA-Z:uS:\fG/[8o!\ri2/^\u0005\u0003iz\u0011aa\u00149uS>t\u0007C\u0001<z\u001b\u00059(B\u0001=\u0005\u0003\u001dqW\r^<pe.L!A_<\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\t\u000bq\u0004A\u0011B?\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$H#\u0002@\u0002\u0010\u0005]\u0001\u0003B1\u0000\u0003\u0007I1!!\u0001c\u000551U\r^2i%\u0016\u001c\bo\u001c8tKB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0011\faA]3d_J$\u0017\u0002BA\u0007\u0003\u000f\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\bB\u00027|\u0001\u0004\t\t\u0002E\u0002b\u0003'I1!!\u0006c\u000511U\r^2i%\u0016\fX/Z:u\u0011\u001d\t8\u0010%AA\u0002ID\u0011\"a\u0007\u0001#\u0003%I!!\b\u0002AM,g\u000e\u001a'jgR|eMZ:fiN\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0003\u0003?Q3A]A\u0011W\t\t\u0019\u0003\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0017=\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0012q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u001b\u0001E\u0005I\u0011BA\u000f\u0003i\u0019XM\u001c3GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0001")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        LogOffsetTest logOffsetTest = this;
        synchronized (logOffsetTest) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
        }
        return this.time;
    }

    private MockTime time() {
        return !this.bitmap$0 ? this.time$lzycompute() : this.time;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void propertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)300000)).toString());
        props.put("log.segment.bytes", "140");
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetRequest request = ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-1L, 10))}))).asJava()).build((short)0);
        ListOffsetResponse response = this.sendListOffsetsRequest(request, this.sendListOffsetsRequest$default$2());
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((ListOffsetResponse.PartitionData)response.responseData().get((Object)topicPartition)).error);
    }

    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> logManager.getLog(topicPartition, logManager.getLog$default$2()).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Log for partition [topic,0] should be created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
        log.onHighWatermarkIncremented(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-1L, 15))}))).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)request, this.sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> logManager.getLog(topicPartition, logManager.getLog$default$2()).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("Log for partition ").append(topicPartition).append(" should be created").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-1L, 15))}))).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)request, this.sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(fetchRequest, this.sendFetchRequest$default$2());
        Assert.assertFalse((boolean)((MemoryRecords)((FetchResponse.PartitionData)fetchResponse.responseData().get((Object)topicPartition)).records).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        File topicLogDir = new File(topicPartitionPath);
        topicLogDir.mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            block0: {
                TopicPartition topicPartition = new TopicPartition(topic, 0);
                ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-2L, 1))}))).asJava()).build();
                Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)$this.sendListOffsetsRequest((ListOffsetRequest)request, $this.sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
                if (!BoxesRunTime.equals((Object)consumerOffsets.head(), (Object)BoxesRunTime.boxToInteger((int)1))) break block0;
                offsetChanged$1.elem = true;
            }
        });
        Assert.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testGetOffsetsBeforeNow() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(now, 15))}))).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)request, this.sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3()));
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ListOffsetRequest.PartitionData(-2L, 10))}))).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)request, this.sendListOffsetsRequest$default$2()).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).andStubAnswer((IAnswer)new IAnswer<Object>(null){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        Seq logSegments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}));
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(null, logSegment){
            public final LogSegment logSegment$1;

            public Iterable<LogSegment> answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$3 $outer;

                    public GenericCompanion<Iterable> companion() {
                        return Iterable.companion$((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.seq$((Iterable)this);
                    }

                    public Iterable<LogSegment> thisCollection() {
                        return IterableLike.thisCollection$((IterableLike)this);
                    }

                    public Iterable toCollection(Object repr) {
                        return IterableLike.toCollection$((IterableLike)this, (Object)repr);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableLike.foreach$((IterableLike)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableLike.forall$((IterableLike)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableLike.exists$((IterableLike)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableLike.find$((IterableLike)this, p);
                    }

                    public boolean isEmpty() {
                        return IterableLike.isEmpty$((IterableLike)this);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.foldRight$((IterableLike)this, z, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.reduceRight$((IterableLike)this, op);
                    }

                    public Iterable<LogSegment> toIterable() {
                        return IterableLike.toIterable$((IterableLike)this);
                    }

                    public Iterator<LogSegment> toIterator() {
                        return IterableLike.toIterator$((IterableLike)this);
                    }

                    public Object head() {
                        return IterableLike.head$((IterableLike)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
                    }

                    public Object take(int n) {
                        return IterableLike.take$((IterableLike)this, (int)n);
                    }

                    public Object drop(int n) {
                        return IterableLike.drop$((IterableLike)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size) {
                        return IterableLike.grouped$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size) {
                        return IterableLike.sliding$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                        return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
                    }

                    public Object takeRight(int n) {
                        return IterableLike.takeRight$((IterableLike)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableLike.dropRight$((IterableLike)this, (int)n);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
                    }

                    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zip$((IterableLike)this, that, bf);
                    }

                    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
                    }

                    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                        return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
                    }

                    public <B> boolean sameElements(GenIterable<B> that) {
                        return IterableLike.sameElements$((IterableLike)this, that);
                    }

                    public Stream<LogSegment> toStream() {
                        return IterableLike.toStream$((IterableLike)this);
                    }

                    public boolean canEqual(Object that) {
                        return IterableLike.canEqual$((IterableLike)this, (Object)that);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view() {
                        return IterableLike.view$((IterableLike)this);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                        return IterableLike.view$((IterableLike)this, (int)from, (int)until);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                        return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
                    }

                    public <B> Builder<B, Iterable<B>> genericBuilder() {
                        return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
                    }

                    public GenTraversable flatten(Function1 asTraversable) {
                        return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public GenTraversable transpose(Function1 asTraversable) {
                        return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public Object repr() {
                        return TraversableLike.repr$((TraversableLike)this);
                    }

                    public final boolean isTraversableAgain() {
                        return TraversableLike.isTraversableAgain$((TraversableLike)this);
                    }

                    public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                        return TraversableLike.parCombiner$((TraversableLike)this);
                    }

                    public boolean hasDefiniteSize() {
                        return TraversableLike.hasDefiniteSize$((TraversableLike)this);
                    }

                    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.map$((TraversableLike)this, f, bf);
                    }

                    public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
                    }

                    public Object filterImpl(Function1 p, boolean isFlipped) {
                        return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
                    }

                    public Object filter(Function1 p) {
                        return TraversableLike.filter$((TraversableLike)this, (Function1)p);
                    }

                    public Object filterNot(Function1 p) {
                        return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
                    }

                    public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return TraversableLike.partition$((TraversableLike)this, p);
                    }

                    public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return TraversableLike.groupBy$((TraversableLike)this, f);
                    }

                    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                        return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
                    }

                    public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
                    }

                    public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
                    }

                    public Option<LogSegment> headOption() {
                        return TraversableLike.headOption$((TraversableLike)this);
                    }

                    public Object tail() {
                        return TraversableLike.tail$((TraversableLike)this);
                    }

                    public Object last() {
                        return TraversableLike.last$((TraversableLike)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return TraversableLike.lastOption$((TraversableLike)this);
                    }

                    public Object init() {
                        return TraversableLike.init$((TraversableLike)this);
                    }

                    public Object sliceWithKnownDelta(int from, int until, int delta) {
                        return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
                    }

                    public Object sliceWithKnownBound(int from, int until) {
                        return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
                    }

                    public Object dropWhile(Function1 p) {
                        return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return TraversableLike.span$((TraversableLike)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return TraversableLike.splitAt$((TraversableLike)this, (int)n);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return TraversableLike.tails$((TraversableLike)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return TraversableLike.inits$((TraversableLike)this);
                    }

                    public Traversable<LogSegment> toTraversable() {
                        return TraversableLike.toTraversable$((TraversableLike)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                        return (Col)TraversableLike.to$((TraversableLike)this, cbf);
                    }

                    public String toString() {
                        return TraversableLike.toString$((TraversableLike)this);
                    }

                    public String stringPrefix() {
                        return TraversableLike.stringPrefix$((TraversableLike)this);
                    }

                    public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                        return TraversableLike.withFilter$((TraversableLike)this, p);
                    }

                    public Parallel par() {
                        return Parallelizable.par$((Parallelizable)this);
                    }

                    public List<LogSegment> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<LogSegment> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Seq<LogSegment> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.$outer.logSegment$1}))).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Parallelizable.$init$((Parallelizable)this);
                        TraversableLike.$init$((TraversableLike)this);
                        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                        GenTraversable.$init$((GenTraversable)this);
                        Traversable.$init$((Traversable)this);
                        GenIterable.$init$((GenIterable)this);
                        IterableLike.$init$((IterableLike)this);
                        Iterable.$init$((Iterable)this);
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaServer server() {
        return (KafkaServer)this.servers().head();
    }

    private ListOffsetResponse sendListOffsetsRequest(ListOffsetRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.LIST_OFFSETS, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ListOffsetResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendListOffsetsRequest$default$2() {
        return None$.MODULE$;
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(FetchRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendFetchRequest$default$2() {
        return None$.MODULE$;
    }
}

