/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002T8h%\u0016\u001cwN^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012a\u0005:fa2L7-\u0019'bORKW.Z'bq6\u001bX#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\t1{gn\u001a\u0005\u0007;\u0001\u0001\u000b\u0011\u0002\f\u0002)I,\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:!\u0011\u001dy\u0002A1A\u0005\u0002U\tQC]3qY&\u001c\u0017\rT1h\u001b\u0006DX*Z:tC\u001e,7\u000f\u0003\u0004\"\u0001\u0001\u0006IAF\u0001\u0017e\u0016\u0004H.[2b\u0019\u0006<W*\u0019=NKN\u001c\u0018mZ3tA!91\u0005\u0001b\u0001\n\u0003!\u0013!\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj]\u000b\u0002KA\u0011qCJ\u0005\u0003Oa\u00111!\u00138u\u0011\u0019I\u0003\u0001)A\u0005K\u00051\"/\u001a9mS\u000e\fg)\u001a;dQ^\u000b\u0017\u000e^'bq6\u001b\b\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0013\u0002)I,\u0007\u000f\\5dC\u001a+Go\u00195NS:\u0014\u0015\u0010^3t\u0011\u0019i\u0003\u0001)A\u0005K\u0005)\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKN\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005!Q\u000f^5m\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004;\u0001\u0001\u0006I!M\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002Bq\u0001\u0010\u0001A\u0002\u0013\u0005Q(A\u0004d_:4\u0017nZ:\u0016\u0003y\u00022aP$K\u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002D\r\u00051AH]8pizJ\u0011!G\u0005\u0003\rb\tq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\n\u00191+Z9\u000b\u0005\u0019C\u0002C\u0001\nL\u0013\ta%AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u0002(\u0001\u0001\u0004%\taT\u0001\fG>tg-[4t?\u0012*\u0017\u000f\u0006\u0002Q'B\u0011q#U\u0005\u0003%b\u0011A!\u00168ji\"9A+TA\u0001\u0002\u0004q\u0014a\u0001=%c!1a\u000b\u0001Q!\ny\n\u0001bY8oM&<7\u000f\t\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0003\u0015!x\u000e]5d+\u0005Q\u0006CA._\u001b\u0005a&BA/6\u0003\u0011a\u0017M\\4\n\u0005}c&AB*ue&tw\r\u0003\u0004b\u0001\u0001\u0006IAW\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f\r\u0004!\u0019!C\u0001I\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u0019)\u0007\u0001)A\u0005K\u0005a\u0001/\u0019:uSRLwN\\%eA!9q\r\u0001b\u0001\n\u0003A\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002SB\u0011!N]\u0007\u0002W*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]6\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1Q\u000f\u0001Q\u0001\n%\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\bo\u0002\u0001\r\u0011\"\u0001y\u0003\u001d\u0019XM\u001d<feF*\u0012!\u001f\t\u0003%iL!a\u001f\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0003-\u0019XM\u001d<feFzF%Z9\u0015\u0005A{\bb\u0002+}\u0003\u0003\u0005\r!\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003z\u0003!\u0019XM\u001d<feF\u0002\u0003\u0002CA\u0004\u0001\u0001\u0007I\u0011\u0001=\u0002\u000fM,'O^3se!I\u00111\u0002\u0001A\u0002\u0013\u0005\u0011QB\u0001\fg\u0016\u0014h/\u001a:3?\u0012*\u0017\u000fF\u0002Q\u0003\u001fA\u0001\u0002VA\u0005\u0003\u0003\u0005\r!\u001f\u0005\b\u0003'\u0001\u0001\u0015)\u0003z\u0003!\u0019XM\u001d<feJ\u0002\u0003bBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\rG>tg-[4Qe>\u00048/M\u000b\u0002\u0015\"9\u0011Q\u0004\u0001\u0005\u0002\u0005e\u0011\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0004\u0002CA\u0011\u0001\t\u0007I\u0011A-\u0002\u000f5,7o]1hK\"9\u0011Q\u0005\u0001!\u0002\u0013Q\u0016\u0001C7fgN\fw-\u001a\u0011\t\u0013\u0005%\u0002\u00011A\u0005\u0002\u0005-\u0012\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u00055\u0002\u0003CA\u0018\u0003o\tY$!\u0011\u000e\u0005\u0005E\"\u0002BA\u0015\u0003gQ1!!\u000en\u0003\u001d\u0019G.[3oiNLA!!\u000f\u00022\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u00042aWA\u001f\u0013\r\ty\u0004\u0018\u0002\b\u0013:$XmZ3s!\u0011\t\u0019%a\u0013\u000f\t\u0005\u0015\u0013q\t\t\u0003\u0003bI1!!\u0013\u0019\u0003\u0019\u0001&/\u001a3fM&\u0019q,!\u0014\u000b\u0007\u0005%\u0003\u0004C\u0005\u0002R\u0001\u0001\r\u0011\"\u0001\u0002T\u0005a\u0001O]8ek\u000e,'o\u0018\u0013fcR\u0019\u0001+!\u0016\t\u0013Q\u000by%!AA\u0002\u00055\u0002\u0002CA-\u0001\u0001\u0006K!!\f\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0003bBA/\u0001\u0011\u0005\u0011qL\u0001\bQ^4\u0015\u000e\\32+\t\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9GA\u0001\fG\",7m\u001b9pS:$8/\u0003\u0003\u0002l\u0005\u0015$\u0001F(gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rC\u0004\u0002p\u0001!\t!a\u0018\u0002\u000f!<h)\u001b7fe!I\u00111\u000f\u0001A\u0002\u0013\u0005\u0011QO\u0001\bg\u0016\u0014h/\u001a:t+\t\t9\bE\u0003\u0002z\u0005}\u00140\u0004\u0002\u0002|)\u0019\u0011Q\u0010\r\u0002\u0015\r|G\u000e\\3di&|g.C\u0002I\u0003wB\u0011\"a!\u0001\u0001\u0004%\t!!\"\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0004!\u0006\u001d\u0005\"\u0003+\u0002\u0002\u0006\u0005\t\u0019AA<\u0011!\tY\t\u0001Q!\n\u0005]\u0014\u0001C:feZ,'o\u001d\u0011\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006qQ\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u0014H#\u0001)\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0012\u0006)1/\u001a;Va\"\"\u00111SAM!\u0011\tY*!)\u000e\u0005\u0005u%bAAPa\u0006)!.\u001e8ji&!\u00111UAO\u0005\u0019\u0011UMZ8sK\"9\u0011q\u0015\u0001\u0005B\u0005E\u0015\u0001\u0003;fCJ$un\u001e8)\t\u0005\u0015\u00161\u0016\t\u0005\u00037\u000bi+\u0003\u0003\u00020\u0006u%!B!gi\u0016\u0014\bbBAZ\u0001\u0011\u0005\u0011\u0011S\u0001+i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]RtuNR1jYV\u0014Xm]*j]\u001edW\rT8h'\u0016<W.\u001a8uQ\u0011\t\t,a.\u0011\t\u0005m\u0015\u0011X\u0005\u0005\u0003w\u000biJ\u0001\u0003UKN$\bbBA`\u0001\u0011\u0005\u0011\u0011S\u0001-i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]R<\u0016\u000e\u001e5GC&dWO]3t'&tw\r\\3M_\u001e\u001cVmZ7f]RDC!!0\u00028\"9\u0011Q\u0019\u0001\u0005\u0002\u0005E\u0015!\f;fgRDuk\u00115fG.\u0004x.\u001b8u\u001d>4\u0015-\u001b7ve\u0016\u001cX*\u001e7uSBdW\rT8h'\u0016<W.\u001a8ug\"\"\u00111YA\\\u0011\u001d\tY\r\u0001C\u0001\u0003#\u000bq\u0006^3ti\";6\t[3dWB|\u0017N\u001c;XSRDg)Y5mkJ,7/T;mi&\u0004H.\u001a'pON+w-\\3oiNDC!!3\u00028\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0017\u0001D:f]\u0012lUm]:bO\u0016\u001cHc\u0001)\u0002V\"9\u0011q[Ah\u0001\u0004)\u0013!\u00018")
public class LogRecoveryTest
extends ZooKeeperTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps = new Properties();
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaServer> servers;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpointFile hwFile1() {
        return new OffsetCheckpointFile(new File((String)this.configProps1().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public OffsetCheckpointFile hwFile2() {
        return new OffsetCheckpointFile(new File((String)this.configProps2().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$8 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        IntegerSerializer x$9 = new IntegerSerializer();
        StringSerializer x$10 = new StringSerializer();
        int x$11 = TestUtils$.MODULE$.createProducer$default$2();
        long x$12 = TestUtils$.MODULE$.createProducer$default$3();
        long x$13 = TestUtils$.MODULE$.createProducer$default$4();
        int x$14 = TestUtils$.MODULE$.createProducer$default$5();
        int x$15 = TestUtils$.MODULE$.createProducer$default$6();
        int x$16 = TestUtils$.MODULE$.createProducer$default$7();
        int x$17 = TestUtils$.MODULE$.createProducer$default$8();
        String x$18 = TestUtils$.MODULE$.createProducer$default$9();
        int x$19 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$20 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$21 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$22 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$8, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$9, x$10));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom())));
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)this.server1(), (List)new .colon.colon((Object)this.server2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server2().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == numMessages, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(x$2);
            return BoxedUnit.UNIT;
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assert.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assert.assertEquals((long)numMessages, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        int leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = LongRef.create((long)1L);
        this.server1().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        KafkaZkClient x$23 = this.zkClient();
        String x$24 = this.topic();
        int x$25 = this.partitionId();
        Some x$26 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$27 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$28 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$23, x$24, x$25, x$27, (Option<Object>)x$26, x$28);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)leader);
        this.server1().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader must remain on broker 1, in case of ZooKeeper session expiration it can move to broker 0", (leader == 0 || leader == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Partition)this.server2().replicaManager().getPartition(this.topicPartition()).get()).inSyncReplicas().size() == 2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Server 1 is not able to join the ISR after restart", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$29 = this.zkClient();
        String x$30 = this.topic();
        int x$31 = this.partitionId();
        Some x$32 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$33 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$34 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$29, x$30, x$31, x$33, (Option<Object>)x$32, x$34);
        Assert.assertTrue((String)"Leader must remain on broker 0, in case of ZooKeeper session expiration it can move to broker 1", (leader == 0 || leader == 1 ? 1 : 0) != 0);
        this.sendMessages(1);
        ++hw.elem;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server2().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == hw$1.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server2().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == hw, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assert.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assert.assertEquals((long)hw, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        int leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = LongRef.create((long)2L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server2().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == hw$3.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.server1().shutdown();
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$35 = this.zkClient();
        String x$36 = this.topic();
        int x$37 = this.partitionId();
        Some x$38 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$39 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$40 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$35, x$36, x$37, x$39, (Option<Object>)x$38, x$40);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)leader);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server1().startup();
        this.updateProducer();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.sendMessages(2);
        hw.elem += 2L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.server1().replicaManager().localReplica(this.topicPartition()).nonEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create replica in follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server1().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == hw$3.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    private void sendMessages(int n) {
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable & scala.Serializable)x$6 -> LogRecoveryTest.$anonfun$sendMessages$1(this, BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get());
    }

    public static final /* synthetic */ void $anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(KafkaServer x$2) {
        x$2.replicaManager().checkpointHighWatermarks();
    }

    public static final /* synthetic */ Future $anonfun$sendMessages$1(LogRecoveryTest $this, int x$6) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)$this.message()));
    }

    public LogRecoveryTest() {
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMinBytes())).toString());
        this.configs = null;
        this.topic = "new-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.server1 = null;
        this.server2 = null;
        this.message = "hello";
        this.producer = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

