/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001\u001d\u00111#T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0012\u0012!\u00059s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u00111#\u0007\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0005+:LG\u000fC\u0003\u001b!\u0001\u00071$\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SD\u0001\u0006Qe>\u0004XM\u001d;jKNDQ\u0001\n\u0001\u0005B\u0015\nQa]3u+B$\u0012a\u0005\u0015\u0003G\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u000b),h.\u001b;\u000b\u00031\n1a\u001c:h\u0013\tq\u0013F\u0001\u0004CK\u001a|'/\u001a\u0005\u0006a\u0001!\t!J\u0001!i\u0016\u001cHo\u00117vgR,'/\u00133XSRD'+Z9vKN$h+\u001a:tS>t\u0017\u0007\u000b\u00020eA\u0011\u0001fM\u0005\u0003i%\u0012A\u0001V3ti\")a\u0007\u0001C\u0001K\u0005!B/Z:u\u00072,8\u000f^3s\u0013\u0012L5OV1mS\u0012D#!\u000e\u001a\t\u000be\u0002A\u0011A\u0013\u0002!Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe&#\u0007F\u0001\u001d3\u0011\u0015a\u0004\u0001\"\u0001&\u0003!!Xm\u001d;SC\u000e\\\u0007FA\u001e3\u0011\u0015y\u0004\u0001\"\u0001&\u00039!Xm\u001d;Jg&sG/\u001a:oC2D#A\u0010\u001a\t\u000b\t\u0003A\u0011A\u0013\u0002'Q,7\u000f\u001e(p)>\u0004\u0018nY:SKF,Xm\u001d;)\u0005\u0005\u0013\u0004\"B#\u0001\t\u0003)\u0013!\u0006;fgR\fU\u000f^8U_BL7m\u0011:fCRLwN\u001c\u0015\u0003\tJBQ\u0001\u0013\u0001\u0005\u0002\u0015\nq\u0006^3ti\u0006+Ho\\\"sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_JD#a\u0012\u001a\t\u000b-\u0003A\u0011A\u0013\u0002?Q,7\u000f^!vi>\u001c%/Z1uK>37i\u001c7mS\u0012Lgn\u001a+pa&\u001c7\u000f\u000b\u0002Ke!)a\n\u0001C\u0001K\u0005!B/Z:u\u00032dGk\u001c9jGN\u0014V-];fgRD#!\u0014\u001a\t\u000bE\u0003A\u0011A\u0013\u0002)Q,7\u000f\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2bQ\t\u0001&\u0007C\u0003U\u0001\u0011\u0005Q%A\fuKN$(+\u001a9mS\u000e\fGi\\<o%\u0016\u001c\bo\u001c8tK\"\u00121K\r\u0005\u0006/\u0002!\t!J\u0001'i\u0016\u001cH/S:s\u0003\u001a$XM\u001d\"s_.,'o\u00155vi\u0012{wO\\!oI*{\u0017N\\:CC\u000e\\\u0007F\u0001,3\u0011\u0015Q\u0006\u0001\"\u0001&\u0003q!Xm\u001d;BY&4XM\u0011:pW\u0016\u00148oV5uQ:{Gk\u001c9jGND#!\u0017\u001a\t\u000bu\u0003A\u0011\u00020\u0002'M,g\u000eZ'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0015\u0007}Sw\u000e\u0005\u0002aQ6\t\u0011M\u0003\u0002cG\u0006A!/Z9vKN$8O\u0003\u0002eK\u000611m\\7n_:T!!\u00024\u000b\u0005\u001d\\\u0013AB1qC\u000eDW-\u0003\u0002jC\n\u0001R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a\u0005\u0006Wr\u0003\r\u0001\\\u0001\be\u0016\fX/Z:u!\t\u0001W.\u0003\u0002oC\nyQ*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fC\u0004q9B\u0005\t\u0019A9\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\t\u0004)I$\u0018BA:\u0016\u0005\u0019y\u0005\u000f^5p]B\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fB\u0001\b]\u0016$xo\u001c:l\u0013\tIhO\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0004|\u0001E\u0005I\u0011\u0002?\u0002;M,g\u000eZ'fi\u0006$\u0017\r^1SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\u0012! \u0016\u0003cz\\\u0013a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0002\nU\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class MetadataRequestTest
extends BaseRequestTest {
    @Override
    public void propertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
    }

    @Override
    @Before
    public void setUp() {
        this.doSetup(false);
    }

    @Test
    public void testClusterIdWithRequestVersion1() {
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        String v1ClusterId = v1MetadataResponse.clusterId();
        Assert.assertNull((String)"v1 clusterId should be null", (Object)v1ClusterId);
    }

    @Test
    public void testClusterIdIsValid() {
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)2), this.sendMetadataRequest$default$2());
        TestUtils.isValidClusterId((String)metadataResponse.clusterId());
    }

    @Test
    public void testControllerId() {
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$1(x$1))).get();
        int controllerId = controllerServer.config().brokerId();
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertEquals((String)"Controller id should match the active controller", (long)controllerId, (long)metadataResponse.controller().id());
        controllerServer.shutdown();
        controllerServer.startup();
        KafkaServer controllerServer2 = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$2(x$2))).get();
        int controllerId2 = controllerServer2.config().brokerId();
        Assert.assertNotEquals((String)"Controller id should switch to a new broker", (long)controllerId, (long)controllerId2);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            MetadataResponse metadataResponse2 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
            return metadataResponse2.controller() != null && controllerServer2.apis().brokerId() == metadataResponse2.controller().id();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller id should match the active controller after failover", 5000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testRack() {
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.brokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
            MetadataRequestTest.$anonfun$testRack$1(broker);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testIsInternal() {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Iterable topicMetadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$1(internalTopic, x$3))).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$2(notInternalTopic, x$4))).get();
        Assert.assertTrue((String)"internalTopic should show isInternal", (boolean)internalTopicMetadata.isInternal());
        Assert.assertFalse((String)"notInternalTopic topic not should show isInternal", (boolean)notInternalTopicMetadata.isInternal());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.cluster().internalTopics());
    }

    @Test
    public void testNoTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), true, (short)1), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Assert.assertTrue((String)"Response should have no topics", (boolean)metadataResponse.topicMetadata().isEmpty());
    }

    @Test
    public void testAutoTopicCreation() {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        MetadataResponse response1 = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava(), true, ApiKeys.METADATA.latestVersion()), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic$1(topic1, topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2, topic3}))).asJava(), false, 3), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic$1(topic2, topic3, response2);
        MetadataResponse response3 = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic3, topic4}))).asJava(), false, 4), this.sendMetadataRequest$default$2());
        Assert.assertNull(response3.errors().get(topic3));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic4));
    }

    @Test
    public void testAutoCreateTopicWithInvalidReplicationFactor() {
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        Assert.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)topicMetadata.error());
        Assert.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assert.assertEquals((long)0L, (long)topicMetadata.partitionMetadata().size());
    }

    @Test
    public void testAutoCreateOfCollidingTopics() {
        String topic1 = "testAutoCreate_Topic";
        String topic2 = "testAutoCreate.Topic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)2L, (long)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        MetadataResponse.TopicMetadata topicMetadata2 = (MetadataResponse.TopicMetadata)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).toSeq().apply(1);
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, (Object)topicMetadata1.error());
        Assert.assertEquals((Object)topic1, (Object)topicMetadata1.topic());
        Assert.assertEquals((Object)Errors.INVALID_TOPIC_EXCEPTION, (Object)topicMetadata2.error());
        Assert.assertEquals((Object)topic2, (Object)topicMetadata2.topic());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic1, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topic1, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response2.topicMetadata()).asScala()).head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata1.error());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.NONE})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.error(), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((long)1L, (long)topicMetadata1.partitionMetadata().size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).head();
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((long)2L, (long)partitionMetadata.replicas().size());
        Assert.assertNotNull((Object)partitionMetadata.leader());
    }

    @Test
    public void testAllTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponseV0 = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), true, (short)0), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"V0 Response should have no errors", (boolean)metadataResponseV0.errors().isEmpty());
        Assert.assertEquals((String)"V0 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV0.topicMetadata().size());
        MetadataResponse metadataResponseV1 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"V1 Response should have no errors", (boolean)metadataResponseV1.errors().isEmpty());
        Assert.assertEquals((String)"V1 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV1.topicMetadata().size());
    }

    @Test
    public void testPreferredReplica() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopic("t1", (Map<Object, Seq<Object>>)replicaAssignment);
        Seq responses = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataResponse[]{this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.controllerSocketServer())), this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.notControllerSocketServer()))}));
        responses.foreach((Function1 & Serializable & scala.Serializable)response -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$1(replicaAssignment, response);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReplicaDownResponse() {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true, (short)1), this.sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        KafkaServer downNode = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$1(partitionMetadata, server))).get();
        downNode.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            MetadataResponse response = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true, (short)1), this.sendMetadataRequest$default$2());
            MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
            Node replica = (Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.replicas()).asScala()).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$5(downNode, x$12))).get();
            String string = replica.host();
            String string2 = "";
            return !(string != null ? !string.equals(string2) : string2 != null) & replica.port() == -1;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replica was not found down", 5000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        MetadataResponse v0MetadataResponse = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true, (short)0), this.sendMetadataRequest$default$2());
        Seq v0BrokerIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v0MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)"The downed broker should not be in the brokers list", (boolean)v0BrokerIds.contains((Object)downNode));
        Assert.assertTrue((String)"Response should have one topic", (v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0);
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Errors errors = v0PartitionMetadata.error();
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assert.assertTrue((String)"PartitionMetadata should have an error", (!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(30).append("Response should have ").append(replicaCount - 1).append(" replicas").toString(), (v0PartitionMetadata.replicas().size() == replicaCount - 1 ? 1 : 0) != 0);
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(new MetadataRequest((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true, (short)1), this.sendMetadataRequest$default$2());
        Seq v1BrokerIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v1MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)"The downed broker should not be in the brokers list", (boolean)v1BrokerIds.contains((Object)downNode));
        Assert.assertEquals((String)"Response should have one topic", (long)1L, (long)v1MetadataResponse.topicMetadata().size());
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Assert.assertEquals((String)"PartitionMetadata should have no errors", (Object)Errors.NONE, (Object)v1PartitionMetadata.error());
        Assert.assertEquals((String)new StringBuilder(30).append("Response should have ").append(replicaCount).append(" replicas").toString(), (long)replicaCount, (long)v1PartitionMetadata.replicas().size());
    }

    @Test
    public void testIsrAfterBrokerShutDownAndJoinsBack() {
        String topic = "isr-after-broker-shutdown";
        int replicaCount = 3;
        this.createTopic(topic, 1, replicaCount, this.createTopic$default$4());
        ((KafkaServer)this.servers().last()).shutdown();
        ((KafkaServer)this.servers().last()).awaitShutdown();
        ((KafkaServer)this.servers().last()).startup();
        this.checkIsr$1((Seq)this.servers(), topic);
    }

    @Test
    public void testAliveBrokersWithNoTopics() {
        KafkaServer serverToShutdown = (KafkaServer)((TraversableLike)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$11(x$24)))).last();
        serverToShutdown.shutdown();
        serverToShutdown.awaitShutdown();
        this.checkMetadata$1((Seq)this.servers(), this.servers().size() - 1);
        serverToShutdown.startup();
        this.checkMetadata$1((Seq)this.servers(), this.servers().size());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$1(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$2(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ void $anonfun$testRack$1(Node broker) {
        Assert.assertEquals((String)"Rack information should match config", (Object)new StringBuilder(5).append("rack/").append(broker.id()).toString(), (Object)broker.rack());
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$1(String internalTopic$1, MetadataResponse.TopicMetadata x$3) {
        String string = x$3.topic();
        String string2 = internalTopic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$2(String notInternalTopic$1, MetadataResponse.TopicMetadata x$4) {
        String string = x$4.topic();
        String string2 = notInternalTopic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final void checkAutoCreatedTopic$1(String existingTopic, String autoCreatedTopic, MetadataResponse response) {
        Assert.assertNull(response.errors().get(existingTopic));
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, response.errors().get(autoCreatedTopic));
        Assert.assertEquals((Object)new Some((Object)((KafkaServer)this.servers().head()).config().numPartitions()), (Object)this.zkClient().getTopicPartitionCount(autoCreatedTopic));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(((KafkaServer)this.servers().head()).config().numPartitions())).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), autoCreatedTopic, i, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4()));
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$3(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse.PartitionMetadata partitionMetadata) {
        Seq assignment = (Seq)replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
        Assert.assertEquals((Object)assignment, (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)assignment, (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)assignment.head()), (long)partitionMetadata.leader().id());
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$1(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse response) {
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assert.assertEquals((Object)"t1", (Object)topicMetadata.topic());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.partition()), Buffer$.MODULE$.canBuildFrom())).toSet());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).foreach((Function1 & Serializable & scala.Serializable)partitionMetadata -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$3(replicaAssignment$1, partitionMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$1(MetadataResponse.PartitionMetadata partitionMetadata$1, KafkaServer server) {
        int serverId = server.apis().brokerId();
        int leaderId = partitionMetadata$1.leader().id();
        Buffer replicaIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata$1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Buffer$.MODULE$.canBuildFrom());
        return serverId != leaderId && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$5(KafkaServer downNode$1, Node x$12) {
        return x$12.id() == downNode$1.apis().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(KafkaServer x$15) {
        return x$15.brokerState().currentState() != NotRunning$.MODULE$.state();
    }

    public static final /* synthetic */ void $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4(MetadataRequestTest $this, String topic$1, Seq expectedIsr$1, KafkaServer broker) {
        ObjectRef actualIsr = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker.config().brokerId())));
            Option firstPartitionMetadata = ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).headOption().flatMap((Function1 & Serializable & scala.Serializable)x$17 -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$17.partitionMetadata()).asScala()).headOption());
            actualIsr$1.elem = (Seq)firstPartitionMetadata.map((Function1 & Serializable & scala.Serializable)partitionMetadata -> (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.id()), (Ordering)Ordering.Int$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            Seq seq = expectedIsr$1;
            Seq seq2 = (Seq)actualIsr$1.elem;
            return !(seq != null ? !seq.equals(seq2) : seq2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Topic metadata not updated correctly in broker ").append(broker).append("\n").append(new StringBuilder(16).append("Expected ISR: ").append(expectedIsr$1).append(" \n").toString()).append(new StringBuilder(13).append("Actual ISR : ").append((Seq)actualIsr$1.elem).toString()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private final void checkIsr$1(Seq servers, String topic) {
        Seq activeBrokers = (Seq)servers.filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(x$15)));
        Seq expectedIsr = (Seq)((SeqLike)activeBrokers.map((Function1 & Serializable & scala.Serializable)broker -> new Node(broker.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaServer)broker, TestUtils$.MODULE$.boundPort$default$2()), (String)broker.config().rack().orNull(Predef$.MODULE$.$conforms())), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.id()), (Ordering)Ordering.Int$.MODULE$);
        activeBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4(this, topic, expectedIsr, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$4(KafkaServer x$20) {
        return x$20.brokerState().currentState() != NotRunning$.MODULE$.state();
    }

    private final void checkMetadata$1(Seq servers, int expectedBrokersCount) {
        ObjectRef controllerMetadataResponse = ObjectRef.create((Object)None$.MODULE$);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)this.controllerSocketServer()));
            controllerMetadataResponse$1.elem = new Some((Object)metadataResponse);
            return metadataResponse.brokers().size() == expectedBrokersCount;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Expected ").append(expectedBrokersCount).append(" brokers, but there are ").append(((MetadataResponse)((Option)controllerMetadataResponse$1.elem).get()).brokers().size()).append(" ").append("according to the Controller").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq brokersInController = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((MetadataResponse)((Option)controllerMetadataResponse.elem).get()).brokers()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.id()), (Ordering)Ordering.Int$.MODULE$);
        ((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$4(x$20)))).foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker.config().brokerId())));
                Seq brokers = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.brokers()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.id()), (Ordering)Ordering.Int$.MODULE$);
                Seq topicMetadata = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$22 -> x$22.topic(), (Ordering)Ordering.String$.MODULE$);
                Seq seq = brokersInController$1;
                Seq seq2 = brokers;
                if (seq == null) {
                    if (seq2 != null) {
                        return false;
                    }
                } else if (!seq.equals(seq2)) return false;
                Object object = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$23 -> x$23.topic(), (Ordering)Ordering.String$.MODULE$);
                Seq seq3 = topicMetadata;
                if (object == null) {
                    if (seq3 == null) return true;
                    return false;
                } else {
                    if (!object.equals(seq3)) return false;
                    return true;
                }
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic metadata not updated correctly", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$11(KafkaServer x$24) {
        return x$24.kafkaController().isActive();
    }
}

