/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.cluster.EndPoint;
import kafka.coordinator.group.OffsetConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MultipleListenersWithSameSecurityProtocolBaseTest$;
import kafka.server.MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$;
import kafka.utils.Implicits$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=x!B\u0001\u0003\u0011\u00039\u0011!M'vYRL\u0007\u000f\\3MSN$XM\\3sg^KG\u000f[*b[\u0016\u001cVmY;sSRL\bK]8u_\u000e|GNQ1tKR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t\tT*\u001e7uSBdW\rT5ti\u0016tWM]:XSRD7+Y7f'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0014\u0015m]3UKN$8cA\u0005\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\f\n\t\u00039\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001dI\u0012B1A\u0005\u0002i\tabU3dkJ,\u0017J\u001c;fe:\fG.F\u0001\u001c!\ta\u0012%D\u0001\u001e\u0015\tqr$\u0001\u0003mC:<'\"\u0001\u0011\u0002\t)\fg/Y\u0005\u0003Eu\u0011aa\u0015;sS:<\u0007B\u0002\u0013\nA\u0003%1$A\bTK\u000e,(/Z%oi\u0016\u0014h.\u00197!\u0011\u001d1\u0013B1A\u0005\u0002i\tabU3dkJ,W\t\u001f;fe:\fG\u000e\u0003\u0004)\u0013\u0001\u0006IaG\u0001\u0010'\u0016\u001cWO]3FqR,'O\\1mA!9!&\u0003b\u0001\n\u0003Q\u0012\u0001C%oi\u0016\u0014h.\u00197\t\r1J\u0001\u0015!\u0003\u001c\u0003%Ie\u000e^3s]\u0006d\u0007\u0005C\u0004/\u0013\t\u0007I\u0011\u0001\u000e\u0002\u0011\u0015CH/\u001a:oC2Da\u0001M\u0005!\u0002\u0013Y\u0012!C#yi\u0016\u0014h.\u00197!\u0011\u001d\u0011\u0014B1A\u0005\u0002i\taaR:t\u0003BL\u0007B\u0002\u001b\nA\u0003%1$A\u0004HgN\f\u0005/\u001b\u0011\t\u000fYJ!\u0019!C\u00015\u0005)\u0001\u000b\\1j]\"1\u0001(\u0003Q\u0001\nm\ta\u0001\u00157bS:\u0004\u0003b\u0002\u001e\n\u0003\u0003%IaO\u0001\fe\u0016\fGMU3t_24X\rF\u0001=!\taR(\u0003\u0002?;\t1qJ\u00196fGR4QA\u0003\u0002\u0002\u0002\u0001\u001b2aP!H!\t\u0011U)D\u0001D\u0015\t!E!\u0001\u0002{W&\u0011ai\u0011\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005![U\"A%\u000b\u0005)#\u0011aA1qS&\u0011A*\u0013\u0002\n'\u0006\u001cHnU3ukBDQAF \u0005\u00029#\u0012a\u0014\t\u0003\u0011}Bq!U C\u0002\u0013%!+\u0001\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3\u0016\u0003M\u0003\"\u0001V,\u000e\u0003US!AV\u0010\u0002\u0005%|\u0017B\u0001-V\u0005\u00111\u0015\u000e\\3\t\ri{\u0004\u0015!\u0003T\u0003=!(/^:u'R|'/\u001a$jY\u0016\u0004\u0003b\u0002/@\u0005\u0004%I!X\u0001\bg\u0016\u0014h/\u001a:t+\u0005q\u0006cA0eM6\t\u0001M\u0003\u0002bE\u00069Q.\u001e;bE2,'BA2\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003K\u0002\u00141\"\u0011:sCf\u0014UO\u001a4feB\u0011\u0001bZ\u0005\u0003Q\n\u00111bS1gW\u0006\u001cVM\u001d<fe\"1!n\u0010Q\u0001\ny\u000b\u0001b]3sm\u0016\u00148\u000f\t\u0005\bY~\u0012\r\u0011\"\u0003n\u0003%\u0001(o\u001c3vG\u0016\u00148/F\u0001o!\u0015yv.]Af\u0013\t\u0001\bMA\u0002NCB\u0004\"A]:\u000e\u0003}2A\u0001^ Ak\nq1\t\\5f]RlU\r^1eCR\f7\u0003B:\rmJ\u0001\"!D<\n\u0005at!a\u0002)s_\u0012,8\r\u001e\u0005\tuN\u0014)\u001a!C\u0001w\u0006aA.[:uK:,'OT1nKV\tA\u0010E\u0002~\u0003\u001fi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011a\u00028fi^|'o\u001b\u0006\u0005\u0003\u0007\t)!\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005\u001d!\u0002BA\u0005\u0003\u0017\ta!\u00199bG\",'BAA\u0007\u0003\ry'oZ\u0005\u0004\u0003#q(\u0001\u0004'jgR,g.\u001a:OC6,\u0007\"CA\u000bg\nE\t\u0015!\u0003}\u00035a\u0017n\u001d;f]\u0016\u0014h*Y7fA!Q\u0011\u0011D:\u0003\u0016\u0004%\t!a\u0007\u0002\u001bM\f7\u000f\\'fG\"\fg.[:n+\t\ti\u0002\u0005\u0003\u0002 \u00055b\u0002BA\u0011\u0003S\u00012!a\t\u000f\u001b\t\t)CC\u0002\u0002(\u0019\ta\u0001\u0010:p_Rt\u0014bAA\u0016\u001d\u00051\u0001K]3eK\u001aL1AIA\u0018\u0015\r\tYC\u0004\u0005\u000b\u0003g\u0019(\u0011#Q\u0001\n\u0005u\u0011AD:bg2lUm\u00195b]&\u001cX\u000e\t\u0005\u000b\u0003o\u0019(Q3A\u0005\u0002\u0005m\u0011!\u0002;pa&\u001c\u0007BCA\u001eg\nE\t\u0015!\u0003\u0002\u001e\u00051Ao\u001c9jG\u0002BaAF:\u0005\u0002\u0005}BcB9\u0002B\u0005\r\u0013Q\t\u0005\u0007u\u0006u\u0002\u0019\u0001?\t\u0011\u0005e\u0011Q\ba\u0001\u0003;A\u0001\"a\u000e\u0002>\u0001\u0007\u0011Q\u0004\u0005\b\u0003\u0013\u001aH\u0011IA&\u0003!A\u0017m\u001d5D_\u0012,GCAA'!\ri\u0011qJ\u0005\u0004\u0003#r!aA%oi\"9\u0011QK:\u0005B\u0005]\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002Z\u0005}\u0003cA\u0007\u0002\\%\u0019\u0011Q\f\b\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011MA*\u0001\u0004\t\u0019'A\u0002pE*\u00042!DA3\u0013\r\t9G\u0004\u0002\u0004\u0003:L\bbBA6g\u0012\u0005\u0013QN\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u0004\u0005\n\u0003c\u001a\u0018\u0011!C\u0001\u0003g\nAaY8qsR9\u0011/!\u001e\u0002x\u0005e\u0004\u0002\u0003>\u0002pA\u0005\t\u0019\u0001?\t\u0015\u0005e\u0011q\u000eI\u0001\u0002\u0004\ti\u0002\u0003\u0006\u00028\u0005=\u0004\u0013!a\u0001\u0003;A\u0011\"! t#\u0003%\t!a \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0011\u0016\u0004y\u0006\r5FAAC!\u0011\t9)!%\u000e\u0005\u0005%%\u0002BAF\u0003\u001b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=e\"\u0001\u0006b]:|G/\u0019;j_:LA!a%\u0002\n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005]5/%A\u0005\u0002\u0005e\u0015AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u00037SC!!\b\u0002\u0004\"I\u0011qT:\u0012\u0002\u0013\u0005\u0011\u0011T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011!\t\u0019k]A\u0001\n\u0003R\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010C\u0005\u0002(N\f\t\u0011\"\u0001\u0002*\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\n\u0005\n\u0003[\u001b\u0018\u0011!C\u0001\u0003_\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002d\u0005E\u0006BCAZ\u0003W\u000b\t\u00111\u0001\u0002N\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005]6/!A\u0005B\u0005e\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0006CBA_\u0003\u007f\u000b\u0019'D\u0001c\u0013\r\t\tM\u0019\u0002\t\u0013R,'/\u0019;pe\"I\u0011QY:\u0002\u0002\u0013\u0005\u0011qY\u0001\tG\u0006tW)];bYR!\u0011\u0011LAe\u0011)\t\u0019,a1\u0002\u0002\u0003\u0007\u00111\r\t\t\u0003\u001b\f9.a7\u0002\\6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.\u0001\u0005qe>$WoY3s\u0015\u0011\t).!\u0002\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011\\Ah\u00055Y\u0015MZ6b!J|G-^2feB)Q\"!8\u0002b&\u0019\u0011q\u001c\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\t\u0019/C\u0002\u0002f:\u0011AAQ=uK\"9\u0011\u0011^ !\u0002\u0013q\u0017A\u00039s_\u0012,8-\u001a:tA!I\u0011Q^ C\u0002\u0013%\u0011q^\u0001\nG>t7/^7feN,\"!!=\u0011\u000b}{\u0017/a=\u0011\u0011\u0005U\u00181`An\u00037l!!a>\u000b\t\u0005e\u00181[\u0001\tG>t7/^7fe&!\u0011Q`A|\u00055Y\u0015MZ6b\u0007>t7/^7fe\"A!\u0011A !\u0002\u0013\t\t0\u0001\u0006d_:\u001cX/\\3sg\u0002B\u0001B!\u0002@\u0005\u0004%\tBG\u0001\u0019W\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNl\u0007b\u0002B\u0005\u007f\u0001\u0006IaG\u0001\u001aW\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNl\u0007\u0005C\u0005\u0003\u000e}\u0012\r\u0011\"\u0005\u0003\u0010\u0005I2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7t+\t\u0011\t\u0002E\u0004\u0003\u0014\te1Da\u0007\u000e\u0005\tU!b\u0001B\fE\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0004a\nU\u0001#BA_\u0005;Y\u0012b\u0001B\u0010E\n\u00191+Z9\t\u0011\t\rr\b)A\u0005\u0005#\t!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002BqAa\n@\r#\u0011I#\u0001\nti\u0006$\u0018n\u0019&bCN\u001cVm\u0019;j_:\u001cXC\u0001B\u0016!\u0019\u0011iCa\u000e\u0003<9!!q\u0006B\u001a\u001d\u0011\t\u0019C!\r\n\u0003=I1A!\u000e\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\b\u0003:)\u0019!Q\u0007\b\u0011\t\tu\"q\n\b\u0005\u0005\u007f\u0011IE\u0004\u0003\u0003B\t\u0015c\u0002BA\u0012\u0005\u0007J\u0011!B\u0005\u0004\u0005\u000f\"\u0011!B;uS2\u001c\u0018\u0002\u0002B&\u0005\u001b\nQBS1bgR+7\u000f^+uS2\u001c(b\u0001B$\t%!!\u0011\u000bB*\u0005-Q\u0015-Y:TK\u000e$\u0018n\u001c8\u000b\t\t-#Q\n\u0005\b\u0005/zd\u0011\u0003B-\u0003M!\u0017P\\1nS\u000eT\u0015-Y:TK\u000e$\u0018n\u001c8t+\t\u0011Y\u0006\u0005\u0003\u0003^\t\rTB\u0001B0\u0015\r\u0011\tgH\u0001\u0005kRLG.\u0003\u0003\u0003f\t}#A\u0003)s_B,'\u000f^5fg\"9!\u0011N \u0005B\t-\u0014!B:fiV\u0003HC\u0001B7!\ri!qN\u0005\u0004\u0005cr!\u0001B+oSRDCAa\u001a\u0003vA!!q\u000fB?\u001b\t\u0011IH\u0003\u0003\u0003|\u0005-\u0011!\u00026v]&$\u0018\u0002\u0002B@\u0005s\u0012aAQ3g_J,\u0007b\u0002BB\u007f\u0011\u0005#1N\u0001\ti\u0016\f'\u000fR8x]\"\"!\u0011\u0011BD!\u0011\u00119H!#\n\t\t-%\u0011\u0010\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0005\u001f{D\u0011\u0001B6\u0003I!Xm\u001d;Qe>$WoY3D_:\u001cX/\\3)\t\t5%1\u0013\t\u0005\u0005o\u0012)*\u0003\u0003\u0003\u0018\ne$\u0001\u0002+fgRDqAa'@\t#\u0011i*A\u000bbI\u0012$\u0015P\\1nS\u000eT\u0015-Y:TK\u000e$\u0018n\u001c8\u0015\u0015\t5$q\u0014BR\u0005O\u0013Y\u000b\u0003\u0005\u0003\"\ne\u0005\u0019\u0001B.\u0003\u0015\u0001(o\u001c9t\u0011!\u0011)K!'A\u0002\u0005u\u0011\u0001\u00037jgR,g.\u001a:\t\u0011\t%&\u0011\u0014a\u0001\u0003;\t\u0011\"\\3dQ\u0006t\u0017n]7\t\u0011\t5&\u0011\u0014a\u0001\u0005w\t1B[1bgN+7\r^5p]\u001eI!\u0011W \u0002\u0002#\u0005!1W\u0001\u000f\u00072LWM\u001c;NKR\fG-\u0019;b!\r\u0011(Q\u0017\u0004\ti~\n\t\u0011#\u0001\u00038N)!Q\u0017B]%AQ!1\u0018Bay\u0006u\u0011QD9\u000e\u0005\tu&b\u0001B`\u001d\u00059!/\u001e8uS6,\u0017\u0002\u0002Bb\u0005{\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d1\"Q\u0017C\u0001\u0005\u000f$\"Aa-\t\u0015\u0005-$QWA\u0001\n\u000b\u0012Y\rF\u0001\u001c\u0011)\u0011yM!.\u0002\u0002\u0013\u0005%\u0011[\u0001\u0006CB\u0004H.\u001f\u000b\bc\nM'Q\u001bBl\u0011\u0019Q(Q\u001aa\u0001y\"A\u0011\u0011\u0004Bg\u0001\u0004\ti\u0002\u0003\u0005\u00028\t5\u0007\u0019AA\u000f\u0011)\u0011YN!.\u0002\u0002\u0013\u0005%Q\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yNa;\u0011\u000b5\u0011\tO!:\n\u0007\t\rhB\u0001\u0004PaRLwN\u001c\t\t\u001b\t\u001dH0!\b\u0002\u001e%\u0019!\u0011\u001e\b\u0003\rQ+\b\u000f\\34\u0011%\u0011iO!7\u0002\u0002\u0003\u0007\u0011/A\u0002yIA\u0002")
public abstract class MultipleListenersWithSameSecurityProtocolBaseTest
extends ZooKeeperTestHarness
implements SaslSetup {
    private volatile MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$ ClientMetadata$module;
    private final File trustStoreFile;
    private final ArrayBuffer<KafkaServer> servers;
    private final Map<ClientMetadata, KafkaProducer<byte[], byte[]>> producers;
    private final Map<ClientMetadata, KafkaConsumer<byte[], byte[]>> consumers;
    private final String kafkaClientSaslMechanism;
    private final scala.collection.immutable.Map<String, Seq<String>> kafkaServerSaslMechanisms;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    public static String Plain() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain();
    }

    public static String GssApi() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.GssApi();
    }

    public static String External() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External();
    }

    public static String Internal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal();
    }

    public static String SecureExternal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal();
    }

    public static String SecureInternal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal();
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    public MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$ ClientMetadata() {
        if (this.ClientMetadata$module == null) {
            this.ClientMetadata$lzycompute$1();
        }
        return this.ClientMetadata$module;
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private File trustStoreFile() {
        return this.trustStoreFile;
    }

    private ArrayBuffer<KafkaServer> servers() {
        return this.servers;
    }

    private Map<ClientMetadata, KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    private Map<ClientMetadata, KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public scala.collection.immutable.Map<String, Seq<String>> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public abstract Seq<JaasTestUtils.JaasSection> staticJaasSections();

    public abstract Properties dynamicJaasSections();

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.staticJaasSections());
        super.setUp();
        int numServers = 2;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numServers).foreach((Function1 & Serializable & scala.Serializable)brokerId -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        ((ResizableArray)this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.config(), ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)config -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$4(config);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), "__consumer_offsets", OffsetConfig$.MODULE$.DefaultOffsetsTopicNumPartitions(), 2, (Seq<KafkaServer>)this.servers(), ((KafkaServer)this.servers().head()).groupCoordinator().offsetsTopicConfigs());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramUser(), JaasTestUtils$.MODULE$.KafkaScramPassword());
        ((KafkaServer)this.servers().head()).config().listeners().foreach((Function1 & Serializable & scala.Serializable)endPoint -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$5(this, endPoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    @After
    public void tearDown() {
        this.producers().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.consumers().values().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsume() {
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$testProduceConsume$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void addDynamicJaasSection(Properties props, String listener, String mechanism, JaasTestUtils.JaasSection jaasSection) {
        ListenerName listenerName = new ListenerName(listener);
        String prefix = listenerName.saslMechanismConfigPrefix(mechanism);
        String jaasConfig = ((JaasTestUtils.JaasModule)jaasSection.modules().head()).toString();
        props.put(new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.SaslJaasConfigProp()).toString(), jaasConfig);
    }

    private final void ClientMetadata$lzycompute$1() {
        MultipleListenersWithSameSecurityProtocolBaseTest multipleListenersWithSameSecurityProtocolBaseTest = this;
        synchronized (multipleListenersWithSameSecurityProtocolBaseTest) {
            if (this.ClientMetadata$module == null) {
                this.ClientMetadata$module = new MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$(this);
            }
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$setUp$1(MultipleListenersWithSameSecurityProtocolBaseTest $this, int brokerId) {
        int x$5 = brokerId;
        String x$6 = $this.zkConnect();
        Some x$7 = new Some((Object)$this.trustStoreFile());
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$10 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$11 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<Properties> x$12 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$20 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$21 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$22 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$5, x$6, x$8, x$9, x$10, x$11, (Option<File>)x$7, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(32).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).append("://localhost:0, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal()).append("://localhost:0, ").append(new StringBuilder(30).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).append("://localhost:0, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External()).append("://localhost:0").toString()).toString());
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(22).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal()).append(":PLAINTEXT, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).append(":SASL_SSL,").append(new StringBuilder(21).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External()).append(":PLAINTEXT, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).append(":SASL_SSL").toString()).toString());
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal());
        props.put(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        props.put(KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp(), $this.kafkaClientSaslMechanism());
        props.put(new StringBuilder(0).append(new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).configPrefix()).append(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp()).toString(), ((TraversableOnce)$this.kafkaServerSaslMechanisms().apply((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal())).mkString(","));
        props.put(new StringBuilder(0).append(new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).configPrefix()).append(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp()).toString(), ((TraversableOnce)$this.kafkaServerSaslMechanisms().apply((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal())).mkString(","));
        props.put(KafkaConfig$.MODULE$.SaslKerberosServiceNameProp(), "kafka");
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq($this.dynamicJaasSections());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(TestUtils$.MODULE$.sslConfigs(Mode.SERVER, false, (Option<File>)new Some((Object)$this.trustStoreFile()), new StringBuilder(6).append("server").append(brokerId).toString(), TestUtils$.MODULE$.sslConfigs$default$5()));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal(), MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()}))).foreach((Function1 & Serializable & scala.Serializable)listenerName -> props.put(new StringBuilder(21).append(new ListenerName(listenerName).configPrefix()).append("ssl.keystore.location").toString(), props.get("ssl.keystore.location")));
        props.put("ssl.keystore.location", "invalid/file/path");
        return $this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    public static final /* synthetic */ void $anonfun$setUp$4(KafkaConfig config) {
        Assert.assertEquals((String)new StringBuilder(37).append("Unexpected listener count for broker ").append(config.brokerId()).toString(), (long)4L, (long)config.listeners().size());
        Assert.assertEquals((String)new StringBuilder(23).append("Unexpected ").append(KafkaConfig$.MODULE$.InterBrokerListenerNameProp()).append(" for broker ").append(config.brokerId()).toString(), (Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal(), (Object)config.interBrokerListenerName().value());
    }

    private final void addProducerConsumer$1(ListenerName listenerName, String mechanism, Option saslProps, Option trustStoreFile$1, String bootstrapServers$1, EndPoint endPoint$1) {
        String topic = new StringBuilder(0).append(listenerName.value()).append(this.producers().size()).toString();
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ClientMetadata clientMetadata = new ClientMetadata(this, listenerName, mechanism, topic);
        String x$23 = bootstrapServers$1;
        int x$24 = -1;
        SecurityProtocol x$25 = endPoint$1.securityProtocol();
        Option x$26 = trustStoreFile$1;
        Option x$27 = saslProps;
        long x$28 = TestUtils$.MODULE$.createProducer$default$3();
        long x$29 = TestUtils$.MODULE$.createProducer$default$4();
        int x$30 = TestUtils$.MODULE$.createProducer$default$5();
        int x$31 = TestUtils$.MODULE$.createProducer$default$6();
        int x$32 = TestUtils$.MODULE$.createProducer$default$7();
        int x$33 = TestUtils$.MODULE$.createProducer$default$8();
        String x$34 = TestUtils$.MODULE$.createProducer$default$9();
        int x$35 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$36 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$37 = TestUtils$.MODULE$.createProducer$default$15();
        this.producers().update((Object)clientMetadata, TestUtils$.MODULE$.createProducer(x$23, x$24, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$25, (Option<File>)x$26, (Option<Properties>)x$27, x$36, x$37));
        String x$38 = bootstrapServers$1;
        String x$39 = clientMetadata.toString();
        SecurityProtocol x$40 = endPoint$1.securityProtocol();
        Option x$41 = trustStoreFile$1;
        Option x$42 = saslProps;
        String x$43 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$44 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$45 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$46 = TestUtils$.MODULE$.createConsumer$default$6();
        ByteArrayDeserializer x$47 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$48 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumers().update((Object)clientMetadata, TestUtils$.MODULE$.createConsumer(x$38, x$39, x$43, x$44, x$45, x$46, x$40, (Option<File>)x$41, (Option<Properties>)x$42, x$47, x$48));
    }

    public static final /* synthetic */ void $anonfun$setUp$5(MultipleListenersWithSameSecurityProtocolBaseTest $this, EndPoint endPoint) {
        ListenerName listenerName = endPoint.listenerName();
        None$ trustStoreFile = TestUtils$.MODULE$.usesSslTransportLayer(endPoint.securityProtocol()) ? new Some((Object)$this.trustStoreFile()) : None$.MODULE$;
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)$this.servers(), listenerName);
        if (TestUtils$.MODULE$.usesSaslAuthentication(endPoint.securityProtocol())) {
            ((IterableLike)$this.kafkaServerSaslMechanisms().apply((Object)endPoint.listenerName().value())).foreach(arg_0 -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$6$adapted($this, listenerName, (Option)trustStoreFile, bootstrapServers, endPoint, arg_0));
        } else {
            $this.addProducerConsumer$1(listenerName, "", (Option)None$.MODULE$, (Option)trustStoreFile, bootstrapServers, endPoint);
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testProduceConsume$2(ClientMetadata clientMetadata$1, int i) {
        return new ProducerRecord(clientMetadata$1.topic(), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes());
    }

    public static final /* synthetic */ void $anonfun$testProduceConsume$1(MultipleListenersWithSameSecurityProtocolBaseTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ClientMetadata clientMetadata = (ClientMetadata)tuple2._1();
        KafkaProducer producer = (KafkaProducer)tuple2._2();
        IndexedSeq producerRecords = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$testProduceConsume$2(clientMetadata, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        ((TraversableLike)producerRecords.map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> (RecordMetadata)x$4.get(10L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
        KafkaConsumer consumer = (KafkaConsumer)$this.consumers().apply((Object)clientMetadata);
        consumer.subscribe(Collections.singleton(clientMetadata.topic()));
        ArrayBuffer records = new ArrayBuffer();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer.poll(50L)).asScala());
            return records.size() == producerRecords.size();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Consumed ").append(records.size()).append(" records until timeout instead of the expected ").append(producerRecords.size()).append(" records with mechanism ").append(clientMetadata.saslMechanism()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MultipleListenersWithSameSecurityProtocolBaseTest() {
        SaslSetup.$init$(this);
        this.trustStoreFile = File.createTempFile("truststore", ".jks");
        this.servers = new ArrayBuffer();
        this.producers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafkaClientSaslMechanism = MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain();
        this.kafkaServerSaslMechanisms = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.GssApi()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain(), "SCRAM-SHA-512"})))}));
    }

    public static final /* synthetic */ Object $anonfun$setUp$6$adapted(MultipleListenersWithSameSecurityProtocolBaseTest $this, ListenerName listenerName$1, Option trustStoreFile$1, String bootstrapServers$1, EndPoint endPoint$1, String mechanism) {
        $this.addProducerConsumer$1(listenerName$1, mechanism, (Option)new Some((Object)$this.kafkaClientSaslProperties(mechanism, true)), trustStoreFile$1, bootstrapServers$1, endPoint$1);
        return BoxedUnit.UNIT;
    }

    public class ClientMetadata
    implements Product,
    scala.Serializable {
        private final ListenerName listenerName;
        private final String saslMechanism;
        private final String topic;
        public final /* synthetic */ MultipleListenersWithSameSecurityProtocolBaseTest $outer;

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public String saslMechanism() {
            return this.saslMechanism;
        }

        public String topic() {
            return this.topic;
        }

        public int hashCode() {
            return Objects.hash(this.listenerName(), this.saslMechanism());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            Object object = obj;
            if (!(object instanceof ClientMetadata)) return false;
            if (((ClientMetadata)object).kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer() != this.kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer()) return false;
            ClientMetadata clientMetadata = (ClientMetadata)object;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = clientMetadata.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            String string = this.saslMechanism();
            String string2 = clientMetadata.saslMechanism();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.topic();
            String string4 = clientMetadata.topic();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return new StringBuilder(2).append(this.listenerName().value()).append(":").append(this.saslMechanism()).append(":").append(this.topic()).toString();
        }

        public ClientMetadata copy(ListenerName listenerName, String saslMechanism, String topic) {
            return new ClientMetadata(this.kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer(), listenerName, saslMechanism, topic);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public String copy$default$2() {
            return this.saslMechanism();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public String productPrefix() {
            return "ClientMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.listenerName();
                    break;
                }
                case 1: {
                    object = this.saslMechanism();
                    break;
                }
                case 2: {
                    object = this.topic();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClientMetadata;
        }

        public /* synthetic */ MultipleListenersWithSameSecurityProtocolBaseTest kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer() {
            return this.$outer;
        }

        public ClientMetadata(MultipleListenersWithSameSecurityProtocolBaseTest $outer, ListenerName listenerName, String saslMechanism, String topic) {
            this.listenerName = listenerName;
            this.saslMechanism = saslMechanism;
            this.topic = topic;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

