/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u000f\t\u0001sJ\u001a4tKR\u001chi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!AA\bCCN,'+Z9vKN$H+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C\u0001%\u0005\u0019C/Z:u\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i\u000bJ\u0014xN]\"pI\u0016\u001cH#A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0003!i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000b),h.\u001b;\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0003UKN$\b\"B\u0012\u0001\t\u0003\u0011\u0012A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u0012\u001b\u0011\u00151\u0003\u0001\"\u0003(\u0003M\t7o]3siJ+7\u000f]8og\u0016,%O]8s)\u0011\u0019\u0002&\u000e\u001e\t\u000b%*\u0003\u0019\u0001\u0016\u0002\u000b\u0015\u0014(o\u001c:\u0011\u0005-\u001aT\"\u0001\u0017\u000b\u00055r\u0013\u0001\u00039s_R|7m\u001c7\u000b\u0005=\u0002\u0014AB2p[6|gN\u0003\u0002\u0006c)\u0011!GH\u0001\u0007CB\f7\r[3\n\u0005Qb#AB#se>\u00148\u000fC\u00037K\u0001\u0007q'\u0001\u0005ce>\\WM]%e!\t!\u0002(\u0003\u0002:+\t\u0019\u0011J\u001c;\t\u000bm*\u0003\u0019\u0001\u001f\u0002\u000fI,\u0017/^3tiB\u0011Q\bQ\u0007\u0002})\u0011qHL\u0001\te\u0016\fX/Z:ug&\u0011\u0011I\u0010\u0002\u001d\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u\u0011\u0015\u0019\u0005\u0001\"\u0003E\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\u0007\u0015C\u0015\n\u0005\u0002>\r&\u0011qI\u0010\u0002\u001e\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\")aG\u0011a\u0001o!)1H\u0011a\u0001y\u0001")
public class OffsetsForLeaderEpochRequestTest
extends BaseRequestTest {
    @Test
    public void testOffsetsForLeaderEpochErrorCodes() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        java.util.Map epochs = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), 0))}))).asJava();
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)new OffsetsForLeaderEpochRequest.Builder(ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), epochs).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, request);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)OffsetsForLeaderEpochRequestTest.$anonfun$testOffsetsForLeaderEpochErrorCodes$2(x$2)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower, request);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, request);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    private void assertResponseError(Errors error, int brokerId, OffsetsForLeaderEpochRequest request) {
        OffsetsForLeaderEpochResponse response = this.sendRequest(brokerId, request);
        Assert.assertEquals((long)request.epochsByTopicPartition().size(), (long)response.responses().size());
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.responses()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)partitionData -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$1(error, partitionData);
            return BoxedUnit.UNIT;
        });
    }

    private OffsetsForLeaderEpochResponse sendRequest(int brokerId, OffsetsForLeaderEpochRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.OFFSET_FOR_LEADER_EPOCH, this.brokerSocketServer(brokerId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return OffsetsForLeaderEpochResponse.parse((ByteBuffer)response, (short)request.version());
    }

    public static final /* synthetic */ int $anonfun$testOffsetsForLeaderEpochErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        java.util.Map epochs = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$1), (Object)new OffsetsForLeaderEpochRequest.PartitionData(currentLeaderEpoch, 0))}))).asJava();
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)new OffsetsForLeaderEpochRequest.Builder(ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), epochs).build();
        this.assertResponseError(error, brokerId, request);
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, EpochEndOffset partitionData) {
        Assert.assertEquals((Object)error$1, (Object)partitionData.error());
    }
}

