/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.cluster.Broker;
import kafka.server.BrokerState;
import kafka.server.BrokerStates;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.RunningAsBroker$;
import kafka.server.ServerStartupTest;
import kafka.server.ServerStartupTest$MockKafkaServer$3$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.zookeeper.KeeperException;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u000f\t\t2+\u001a:wKJ\u001cF/\u0019:ukB$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAqa\u0001\u0001A\u0002\u0013%A#F\u0001\u0016!\t\u0011b#\u0003\u0002\u0018\u0005\tY1*\u00194lCN+'O^3s\u0011\u001dI\u0002\u00011A\u0005\ni\t!b]3sm\u0016\u0014x\fJ3r)\tY\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0003V]&$\bb\u0002\u0012\u0019\u0003\u0003\u0005\r!F\u0001\u0004q\u0012\n\u0004B\u0002\u0013\u0001A\u0003&Q#A\u0004tKJ4XM\u001d\u0011\t\u000b\u0019\u0002A\u0011I\u0014\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\u0007\u0015\u0003K%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000b),h.\u001b;\u000b\u00039\n1a\u001c:h\u0013\t\u00014FA\u0003BMR,'\u000fC\u00033\u0001\u0011\u0005q%A\ruKN$(I]8lKJ\u001c%/Z1uKNT6j\u00115s_>$\bFA\u00195!\tQS'\u0003\u00027W\t!A+Z:u\u0011\u0015A\u0004\u0001\"\u0001(\u0003\u0015\"Xm\u001d;D_:4G.[2u\u0005J|7.\u001a:Ti\u0006\u0014H/\u001e9XSRD7+Y7f!>\u0014H\u000f\u000b\u00028i!)1\b\u0001C\u0001O\u0005qB/Z:u\u0007>tg\r\\5di\n\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u0015\u0003uQBQA\u0010\u0001\u0005\u0002\u001d\n1\u0003^3ti\n\u0013xn[3s'\u0016dg-Q<be\u0016D#!\u0010\u001b\t\u000b\u0005\u0003A\u0011A\u0014\u0002;Q,7\u000f\u001e\"s_.,'o\u0015;bi\u0016\u0014VO\u001c8j]\u001e\fe\r^3s5.C#\u0001\u0011\u001b")
public class ServerStartupTest
extends ZooKeeperTestHarness {
    private KafkaServer server = null;

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @After
    public void tearDown() {
        if (this.server() != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        }
        super.tearDown();
    }

    @Test
    public void testBrokerCreatesZKChroot() {
        int brokerId = 0;
        String zookeeperChroot = "/kafka-chroot-for-unittest";
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        Object zooKeeperConnect = props.get("zookeeper.connect");
        props.put("zookeeper.connect", Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(zooKeeperConnect), zookeeperChroot));
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        boolean pathExists = this.zkClient().pathExists(zookeeperChroot);
        Assert.assertTrue((boolean)pathExists);
    }

    @Test
    public void testConflictBrokerStartupWithSamePort() {
        int brokerId2;
        int brokerId1 = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props1), TestUtils$.MODULE$.createServer$default$2()));
        int port = TestUtils$.MODULE$.boundPort(this.server(), TestUtils$.MODULE$.boundPort$default$2());
        int x$1 = brokerId2 = 1;
        String x$2 = this.zkConnect();
        int x$3 = port;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        try {
            TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props2), TestUtils$.MODULE$.createServer$default$2());
            throw this.fail("Starting a broker with the same port should fail", new Position("ServerStartupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testConflictBrokerRegistration() {
        int brokerId = 0;
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props1), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerRegistration = (Broker)this.zkClient().getBroker(brokerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("broker doesn't exists", new Position("ServerStartupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79)));
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        try {
            TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props2), TestUtils$.MODULE$.createServer$default$2());
            throw this.fail("Registering a broker with a conflicting id should fail", new Position("ServerStartupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            Assert.assertEquals((Object)brokerRegistration, (Object)this.zkClient().getBroker(brokerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("broker doesn't exists", new Position("ServerStartupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91))));
            return;
        }
    }

    @Test
    public void testBrokerSelfAware() {
        int brokerId = 0;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.server().metadataCache().getAliveBrokers().nonEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Wait for cache to update", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)1L, (long)this.server().metadataCache().getAliveBrokers().size());
        Assert.assertEquals((long)brokerId, (long)((Broker)this.server().metadataCache().getAliveBrokers().head()).id());
    }

    @Test
    public void testBrokerStateRunningAfterZK() {
        LazyRef MockKafkaServer$module = new LazyRef();
        int brokerId = 0;
        BrokerState mockBrokerState = (BrokerState)EasyMock.niceMock(BrokerState.class);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        public class Kafka_server_ServerStartupTest$MockKafkaServer$2
        extends KafkaServer {
            private final BrokerState brokerState;

            public KafkaConfig config() {
                return super.config();
            }

            public BrokerState brokerState() {
                return this.brokerState;
            }

            public Kafka_server_ServerStartupTest$MockKafkaServer$2(ServerStartupTest $outer, KafkaConfig config, BrokerState brokerState) {
                this.brokerState = brokerState;
                super(config, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
            }
        }
        this.server_$eq(new Kafka_server_ServerStartupTest$MockKafkaServer$2(null, KafkaConfig$.MODULE$.fromProps(props), this.MockKafkaServer$1(mockBrokerState, MockKafkaServer$module).$lessinit$greater$default$2()));
        mockBrokerState.newState((BrokerStates)RunningAsBroker$.MODULE$);
        public class Kafka_server_ServerStartupTest$BrokerStateInterceptor$1
        extends BrokerState {
            private final /* synthetic */ ServerStartupTest $outer;
            private final int brokerId$1;

            public void newState(BrokerStates newState) {
                Seq brokers = this.$outer.zkClient().getAllBrokersInCluster();
                Assert.assertEquals((long)1L, (long)brokers.size());
                Assert.assertEquals((long)this.brokerId$1, (long)((Broker)brokers.head()).id());
            }

            public Kafka_server_ServerStartupTest$BrokerStateInterceptor$1(ServerStartupTest $outer, int brokerId$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
            }
        }
        EasyMock.expect((Object)BoxedUnit.UNIT).andDelegateTo((Object)new Kafka_server_ServerStartupTest$BrokerStateInterceptor$1(this, brokerId)).once();
        EasyMock.replay((Object[])new Object[]{mockBrokerState});
        this.server().startup();
    }

    private static final /* synthetic */ ServerStartupTest$MockKafkaServer$3$ MockKafkaServer$lzycompute$1(BrokerState mockBrokerState$1, LazyRef MockKafkaServer$module$1) {
        ServerStartupTest$MockKafkaServer$3$ serverStartupTest$MockKafkaServer$3$;
        LazyRef lazyRef = MockKafkaServer$module$1;
        synchronized (lazyRef) {
            serverStartupTest$MockKafkaServer$3$ = MockKafkaServer$module$1.initialized() ? (ServerStartupTest$MockKafkaServer$3$)MockKafkaServer$module$1.value() : (ServerStartupTest$MockKafkaServer$3$)MockKafkaServer$module$1.initialize((Object)new ServerStartupTest$MockKafkaServer$3$(null, mockBrokerState$1));
        }
        return serverStartupTest$MockKafkaServer$3$;
    }

    private final ServerStartupTest$MockKafkaServer$3$ MockKafkaServer$1(BrokerState mockBrokerState$1, LazyRef MockKafkaServer$module$1) {
        return MockKafkaServer$module$1.initialized() ? (ServerStartupTest$MockKafkaServer$3$)MockKafkaServer$module$1.value() : ServerStartupTest.MockKafkaServer$lzycompute$1(mockBrokerState$1, MockKafkaServer$module$1);
    }
}

