/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Properties;
import kafka.common.MessageFormatter;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.DefaultMessageFormatter;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.test.MockDeserializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,7i\u001c8tk6,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t!F\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A!\u00168ji\"\u00121C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0019\u0011UMZ8sK\")1\u0005\u0001C\u0001+\u000513\u000f[8vY\u0012\u0014Vm]3u+:\u001cuN\\:v[\u0016$wJ\u001a4tKR\u001c()\u001a4pe\u0016,\u00050\u001b;)\u0005\t*\u0003CA\u000e'\u0013\t9CD\u0001\u0003UKN$\b\"B\u0015\u0001\t\u0003)\u0012!I:i_VdG\rT5nSR\u0014V-\u00193t)>l\u0015\r_'fgN\fw-\u001a'j[&$\bF\u0001\u0015&\u0011\u0015a\u0003\u0001\"\u0001\u0016\u0003\r\u001a\bn\\;mIN#x\u000e],iK:|U\u000f\u001e9vi\u000eCWmY6FeJ|'OR1jYND#aK\u0013\t\u000b=\u0002A\u0011A\u000b\u0002GMDw.\u001e7e!\u0006\u00148/\u001a,bY&$7i\u001c8tk6,'OV1mS\u0012\u001cuN\u001c4jO\"\u0012a&\n\u0005\u0006e\u0001!\t!F\u0001;g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001c\u0016.\u001c9mK\u000e{gn];nKJ4\u0016\r\\5e\u0007>tg-[4XSRDg*^7fe&\u001cwJ\u001a4tKRD#!M\u0013\t\u000bU\u0002A\u0011A\u000b\u0002SMDw.\u001e7e\u000bbLGo\u00148V]J,7m\\4oSj,GMT3x\u0007>t7/^7fe>\u0003H/[8oQ\u0011!Te\u000e\u001d\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\u000f\t\u0003u\ts!a\u000f!\u000f\u0005qzT\"A\u001f\u000b\u0005y2\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t\t%\"A\u0004qC\u000e\\\u0017mZ3\n\u0005\r#%\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0011\u0011I\u0003\u0005\u0006\r\u0002!\t!F\u0001:g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001c\u0016.\u001c9mK\u000e{gn];nKJ4\u0016\r\\5e\u0007>tg-[4XSRD7\u000b\u001e:j]\u001e|eMZ:fi\"\u0012Q)\n\u0005\u0006\u0013\u0002!\t!F\u00018g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001e<\u0016\u000e\u001e5BkR|wJ\u001a4tKR\u0014Vm]3u\u0019\u0006$Xm\u001d;)\u0005!+\u0003\"\u0002'\u0001\t\u0003)\u0012!O:i_VdG\rU1sg\u00164\u0016\r\\5e\u0007>t7/^7fe\u000e{gNZ5h/&$\b.Q;u_>3gm]3u%\u0016\u001cX\r^#be2LWm\u001d;)\u0005-+\u0003\"B(\u0001\t\u0003)\u0012!S:i_VdG\rU1sg\u00164\u0016\r\\5e\u0007>t7/^7fe\u000e{gNZ5h/&$\b.Q;u_>3gm]3u%\u0016\u001cX\r^!oI6\u000bGo\u00195j]\u001e4%o\\7CK\u001eLgN\\5oO\"\u0012a*\n\u0005\u0006%\u0002!\t!F\u00010g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001e<\u0016\u000e\u001e5O_>3gm]3u%\u0016\u001cX\r\u001e\u0015\u0003#\u0016BQ!\u0016\u0001\u0005\u0002U\tqi\u001d5pk2$W\t_5u\u001f:LeN^1mS\u0012\u001cuN\u001c4jO^KG\u000f[!vi>|eMZ:fiJ+7/\u001a;B]\u0012\u001cuN\u001c4mS\u000e$\u0018N\\4Ge>l')Z4j]:Lgn\u001a\u0015\u0005)\u0016:\u0004\bC\u0003Y\u0001\u0011\u0005Q#\u0001\u000etQ>,H\u000e\u001a)beN,7i\u001c8gS\u001e\u001chI]8n\r&dW\r\u000b\u0002XK!)1\f\u0001C\u0001+\u0005QsM]8va&#7\u000f\u0015:pm&$W\rZ%o\t&4g-\u001a:f]R\u0004F.Y2fg6+8\u000f^'bi\u000eD\u0007F\u0001.&\u0011\u0015q\u0006\u0001\"\u0001\u0016\u0003E\"Xm\u001d;DkN$x.\u001c)s_B,'\u000f^=TQ>,H\u000e\u001a\"f!\u0006\u001c8/\u001a3U_\u000e{gNZ5hkJ,W*\u001a;i_\u0012D#!X\u0013")
public class ConsoleConsumerTest {
    @Before
    public void setup() {
        ConsoleConsumer$.MODULE$.messageCount_$eq(0);
    }

    @Test
    public void shouldResetUnConsumedOffsetsBeforeExit() {
        String topic = "test";
        int maxMessages = 123;
        int totalMessages = 700;
        Long startOffset = Predef$.MODULE$.long2Long(0L);
        MockConsumer mockConsumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        ConsoleConsumer.ConsumerWrapper consumer = new ConsoleConsumer.ConsumerWrapper((Option)new Some((Object)topic), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Consumer)mockConsumer, ConsoleConsumer.ConsumerWrapper$.MODULE$.$lessinit$greater$default$6());
        mockConsumer.rebalance((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        mockConsumer.updateBeginningOffsets((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)startOffset), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)startOffset)}))).asJava());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> mockConsumer.addRecord(new ConsumerRecord(topic, i % 2, (long)(i / 2), (Object)"key".getBytes(), (Object)"value".getBytes())));
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(maxMessages), formatter, consumer, System.out, false);
        Assert.assertEquals((long)totalMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        consumer.resetUnconsumedOffsets();
        Assert.assertEquals((long)maxMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)maxMessages))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
    }

    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        int messageLimit = 10;
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, System.out, true);
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)messageLimit))).receive();
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)messageLimit))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
        consumer.cleanup();
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)printStream.checkError())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(-1), formatter, consumer, printStream, true);
        ((MessageFormatter)Mockito.verify((Object)formatter)).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.eq((Object)printStream));
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).receive();
        ((PrintStream)Mockito.verify((Object)printStream)).checkError();
        consumer.cleanup();
    }

    @Test
    public void shouldParseValidConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithNumericOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)3L, (long)config.offsetArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldExitOnUnrecognizedNewConsumerOption() {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(x$1, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(BoxesRunTime.unboxToInt((Object)x$1), message));
        String[] args = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithStringOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--property", "print.value=false"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)-1L, (long)config.offsetArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)((DefaultMessageFormatter)config.formatter()).printValue()));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetAndMatchingFromBeginning() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithNoOffsetReset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning() {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(x$2, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(BoxesRunTime.unboxToInt((Object)x$2), message));
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest", "--from-beginning"});
        try {
            ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
            ConsoleConsumer$.MODULE$.consumerProps(config);
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("request.timeout.ms=1000\n".getBytes());
        propsStream.write("group.id=group1".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("request.timeout.ms"));
        Assert.assertEquals((Object)"group1", (Object)config.consumerProps().getProperty("group.id"));
    }

    @Test
    public void groupIdsProvidedInDifferentPlacesMustMatch() {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(x$3, message) -> ConsoleConsumerTest.$anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(BoxesRunTime.unboxToInt((Object)x$3), message));
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=test-group".getBytes());
        propsStream.close();
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--consumer-property", "group.id=test-group", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"test-group", (Object)props.getProperty("group.id"));
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties"});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer.config", propsFile.getAbsolutePath()});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments"});
        config = new ConsoleConsumer.ConsumerConfig(args);
        props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"group-from-arguments", (Object)props.getProperty("group.id"));
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testCustomPropertyShouldBePassedToConfigureMethod() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "print.key=true", "--property", "key.deserializer=org.apache.kafka.test.MockDeserializer", "--property", "key.deserializer.my-props=abc"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertTrue((boolean)(config.formatter() instanceof DefaultMessageFormatter));
        Assert.assertTrue((boolean)config.formatterArgs().containsKey("key.deserializer.my-props"));
        DefaultMessageFormatter formatter = (DefaultMessageFormatter)config.formatter();
        Assert.assertTrue((boolean)(formatter.keyDeserializer().get() instanceof MockDeserializer));
        Assert.assertEquals((long)1L, (long)((MockDeserializer)formatter.keyDeserializer().get()).configs.size());
        Assert.assertEquals((Object)"abc", ((MockDeserializer)formatter.keyDeserializer().get()).configs.get("my-props"));
        Assert.assertTrue((boolean)((MockDeserializer)formatter.keyDeserializer().get()).isKey);
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(int x$2, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(int x$3, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

