/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Arrays;
import joptsimple.OptionException;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,\u0007K]8ek\u000e,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003%1\u0018\r\\5e\u0003J<7/F\u0001\u0017!\rIq#G\u0005\u00031)\u0011Q!\u0011:sCf\u0004\"AG\u0011\u000f\u0005my\u0002C\u0001\u000f\u000b\u001b\u0005i\"B\u0001\u0010\u0007\u0003\u0019a$o\\8u}%\u0011\u0001EC\u0001\u0007!J,G-\u001a4\n\u0005\t\u001a#AB*ue&twM\u0003\u0002!\u0015!1Q\u0005\u0001Q\u0001\nY\t!B^1mS\u0012\f%oZ:!\u0011\u001d9\u0003A1A\u0005\u0002U\t1\"\u001b8wC2LG-\u0011:hg\"1\u0011\u0006\u0001Q\u0001\nY\tA\"\u001b8wC2LG-\u0011:hg\u0002BQa\u000b\u0001\u0005\u00021\n\u0001\u0003^3tiZ\u000bG.\u001b3D_:4\u0017nZ:\u0015\u00035\u0002\"!\u0003\u0018\n\u0005=R!\u0001B+oSRD#AK\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014!\u00026v]&$(\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029g\t!A+Z:u\u0011\u0015Q\u0004\u0001\"\u0001-\u0003I!Xm\u001d;J]Z\fG.\u001b3D_:4\u0017nZ:)\u0005e\n\u0004\"B\u001f\u0001\t\u0003a\u0013\u0001\u0005;fgR\u0004\u0016M]:f\u0017\u0016L\bK]8qQ\ta\u0014\u0007")
public class ConsoleProducerTest {
    private final String[] validArgs = (String[])((Object[])new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] invalidArgs = (String[])((Object[])new String[]{"--t", "t3"});

    public String[] validArgs() {
        return this.validArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    @Test
    public void testValidConfigs() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1001", "localhost:1002"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testInvalidConfigs() {
        try {
            new ConsoleProducer.ProducerConfig(this.invalidArgs());
            Assert.fail((String)"Should have thrown an UnrecognizedOptionException");
        }
        catch (OptionException optionException) {}
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.validArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).newInstance();
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(reader.parseKey());
    }
}

