/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u000f\t\u0019B)^7q\u0019><7+Z4nK:$8\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u0019!X\u000e\u001d#jeV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005\u0011\u0011n\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0003GS2,\u0007BB\u0010\u0001A\u0003%a#A\u0004u[B$\u0015N\u001d\u0011\t\u000f\u0005\u0002!\u0019!C\u0001+\u00051An\\4ESJDaa\t\u0001!\u0002\u00131\u0012a\u00027pO\u0012K'\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003\u001dawn\u001a$jY\u0016,\u0012a\n\t\u0003Q=r!!K\u0017\u0011\u0005)RQ\"A\u0016\u000b\u000512\u0011A\u0002\u001fs_>$h(\u0003\u0002/\u0015\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq#\u0002\u0003\u00044\u0001\u0001\u0006IaJ\u0001\tY><g)\u001b7fA!9Q\u0007\u0001b\u0001\n\u00031\u0014\u0001\u0002;j[\u0016,\u0012a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0011\tQ!\u001e;jYNL!\u0001P\u001d\u0003\u00115{7m\u001b+j[\u0016DaA\u0010\u0001!\u0002\u00139\u0014!\u0002;j[\u0016\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015!B:fiV\u0003H#\u0001\"\u0011\u0005%\u0019\u0015B\u0001#\u000b\u0005\u0011)f.\u001b;)\u0005}2\u0005CA$M\u001b\u0005A%BA%K\u0003\u0015QWO\\5u\u0015\u0005Y\u0015aA8sO&\u0011Q\n\u0013\u0002\u0007\u0005\u00164wN]3\t\u000b=\u0003A\u0011A!\u0002\u0011Q,\u0017M\u001d#po:D#AT)\u0011\u0005\u001d\u0013\u0016BA*I\u0005\u0015\te\r^3s\u0011\u0015)\u0006\u0001\"\u0001B\u0003A!Xm\u001d;Qe&tG\u000fR1uC2{w\r\u000b\u0002U/B\u0011q\tW\u0005\u00033\"\u0013A\u0001V3ti\")1\f\u0001C\u00059\u0006\u0011\"/\u001e8Ek6\u0004Hj\\4TK\u001elWM\u001c;t)\t9S\fC\u0003_5\u0002\u0007q,\u0001\u0003be\u001e\u001c\bcA\u0005aO%\u0011\u0011M\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String logFile = new StringBuilder(25).append(this.logDir()).append("/00000000000000000000.log").toString();
    private final MockTime time = new MockTime(0L, 0L);

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String logFile() {
        return this.logFile;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        File x$1 = this.logDir();
        LogConfig x$2 = LogConfig$.MODULE$.apply();
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3());
        log.flush();
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testPrintDataLog() {
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFile()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFile()}));
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    private final void verifyRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assert.assertTrue((String)new StringBuilder(18).append("Data not printed: ").append(output).toString(), (lines.length > 2 ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String line = lines[lines.length - 2 + i];
            Assert.assertTrue((String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString(), (boolean)line.startsWith(new StringBuilder(18).append("offset: ").append(i).append(" position:").toString()));
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assert.assertFalse((String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString(), (boolean)output.matches("(?s).*offset: [0-9]* position.*"));
    }
}

