/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.Properties;
import kafka.utils.CommandLineUtils$;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u000f\t!2i\\7nC:$G*\u001b8f+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002#Q,7\u000f\u001e)beN,W)\u001c9us\u0006\u0013x\rF\u0001\u0017!\tIq#\u0003\u0002\u0019\u0015\t!QK\\5uQ\u0011\u0019\"DI\u0012\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!\u00026v]&$(\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"9\t!A+Z:u\u0003!)\u0007\u0010]3di\u0016$7%\u0001\u0013\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001\u00027b]\u001eT\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,M\tA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000b5\u0002A\u0011A\u000b\u0002AQ,7\u000f\u001e)beN,W)\u001c9us\u0006\u0013xmV5uQ:{G)\u001a7j[&$XM\u001d\u0015\u0005Yi\u00113\u0005C\u00031\u0001\u0011\u0005Q#\u0001\ruKN$\b+\u0019:tK\u0016k\u0007\u000f^=Be\u001e\f5OV1mS\u0012D#a\f\u000e\t\u000bM\u0002A\u0011A\u000b\u0002%Q,7\u000f\u001e)beN,7+\u001b8hY\u0016\f%o\u001a\u0015\u0003eiAQA\u000e\u0001\u0005\u0002U\tQ\u0002^3tiB\u000b'o]3Be\u001e\u001c\bFA\u001b\u001b\u0011\u0015I\u0004\u0001\"\u0001\u0016\u0003\r\"Xm\u001d;QCJ\u001cX-\u0011:hg^KG\u000f['vYRL\u0007\u000f\\3EK2LW.\u001b;feND#\u0001\u000f\u000e")
public class CommandLineUtilsTest {
    @Test(expected=IllegalArgumentException.class)
    public void testParseEmptyArg() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property="});
        CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseEmptyArgWithNoDelimiter() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property"});
        CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), false);
    }

    @Test
    public void testParseEmptyArgAsValid() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property=", "my.empty.property1"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assert.assertEquals((String)"Value of a key with missing value should be an empty string", (Object)props.getProperty("my.empty.property"), (Object)"");
        Assert.assertEquals((String)"Value of a key with missing value with no delimiter should be an empty string", (Object)props.getProperty("my.empty.property1"), (Object)"");
    }

    @Test
    public void testParseSingleArg() {
        String[] argArray = (String[])((Object[])new String[]{"my.property=value"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assert.assertEquals((String)"Value of a single property should be 'value' ", (Object)props.getProperty("my.property"), (Object)"value");
    }

    @Test
    public void testParseArgs() {
        String[] argArray = (String[])((Object[])new String[]{"first.property=first", "second.property=second"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assert.assertEquals((String)"Value of first property should be 'first'", (Object)props.getProperty("first.property"), (Object)"first");
        Assert.assertEquals((String)"Value of second property should be 'second'", (Object)props.getProperty("second.property"), (Object)"second");
    }

    @Test
    public void testParseArgsWithMultipleDelimiters() {
        String[] argArray = (String[])((Object[])new String[]{"first.property==first", "second.property=second=", "third.property=thi=rd"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assert.assertEquals((String)"Value of first property should be '=first'", (Object)props.getProperty("first.property"), (Object)"=first");
        Assert.assertEquals((String)"Value of second property should be 'second='", (Object)props.getProperty("second.property"), (Object)"second=");
        Assert.assertEquals((String)"Value of second property should be 'thi=rd'", (Object)props.getProperty("third.property"), (Object)"thi=rd");
    }
}

