/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.JsonValue$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005=v!B\u0001\u0003\u0011\u00039\u0011\u0001\u0003&t_:$Vm\u001d;\u000b\u0005\r!\u0011!B;uS2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tA!j]8o)\u0016\u001cHo\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\u0007\tYI\u0001i\u0006\u0002\u000b)\u0016\u001cHo\u00142kK\u000e$8\u0003B\u000b\r1m\u0001\"!D\r\n\u0005iq!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001bqI!!\b\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011})\"Q3A\u0005\u0002\u0001\n1AZ8p+\u0005\t\u0003C\u0001\u0012*\u001d\t\u0019s\u0005\u0005\u0002%\u001d5\tQE\u0003\u0002'\r\u00051AH]8pizJ!\u0001\u000b\b\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003Q9A\u0001\"L\u000b\u0003\u0012\u0003\u0006I!I\u0001\u0005M>|\u0007\u0005\u0003\u00050+\tU\r\u0011\"\u00011\u0003\r\u0011\u0017M]\u000b\u0002cA\u0011QBM\u0005\u0003g9\u00111!\u00138u\u0011!)TC!E!\u0002\u0013\t\u0014\u0001\u00022be\u0002BQaE\u000b\u0005\u0002]\"2\u0001\u000f\u001eK!\tIT#D\u0001\n\u0011\u0015yb\u00071\u0001\"Q\u0011QD\bS%\u0011\u0005u2U\"\u0001 \u000b\u0005}\u0002\u0015AC1o]>$\u0018\r^5p]*\u0011\u0011IQ\u0001\bU\u0006\u001c7n]8o\u0015\t\u0019E)A\u0005gCN$XM\u001d=nY*\tQ)A\u0002d_6L!a\u0012 \u0003\u0019)\u001bxN\u001c)s_B,'\u000f^=\u0002\u000bY\fG.^3\"\u0003}AQa\f\u001cA\u0002EBCA\u0013\u001fI\u0019\u0006\nq\u0006C\u0004O+\u0005\u0005I\u0011A(\u0002\t\r|\u0007/\u001f\u000b\u0004qA\u000b\u0006bB\u0010N!\u0003\u0005\r!\t\u0005\b_5\u0003\n\u00111\u00012\u0011\u001d\u0019V#%A\u0005\u0002Q\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001VU\t\tckK\u0001X!\tAF,D\u0001Z\u0015\tQ6,A\u0005v]\u000eDWmY6fI*\u0011qHD\u0005\u0003;f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001dyV#%A\u0005\u0002\u0001\fabY8qs\u0012\"WMZ1vYR$#'F\u0001bU\t\td\u000bC\u0004d+\u0005\u0005I\u0011\t3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0011a\u0017M\\4\u000b\u0003)\fAA[1wC&\u0011!f\u001a\u0005\b[V\t\t\u0011\"\u00011\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011\u001dyW#!A\u0005\u0002A\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002riB\u0011QB]\u0005\u0003g:\u00111!\u00118z\u0011\u001d)h.!AA\u0002E\n1\u0001\u001f\u00132\u0011\u001d9X#!A\u0005Ba\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002sB\u0019!0`9\u000e\u0003mT!\u0001 \b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u007fw\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0002U\t\t\u0011\"\u0001\u0002\u0004\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0006\u0005-\u0001cA\u0007\u0002\b%\u0019\u0011\u0011\u0002\b\u0003\u000f\t{w\u000e\\3b]\"9Qo`A\u0001\u0002\u0004\t\b\"CA\b+\u0005\u0005I\u0011IA\t\u0003!A\u0017m\u001d5D_\u0012,G#A\u0019\t\u0013\u0005UQ#!A\u0005B\u0005]\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0015D\u0011\"a\u0007\u0016\u0003\u0003%\t%!\b\u0002\r\u0015\fX/\u00197t)\u0011\t)!a\b\t\u0011U\fI\"!AA\u0002E<\u0011\"a\t\n\u0003\u0003E\t!!\n\u0002\u0015Q+7\u000f^(cU\u0016\u001cG\u000fE\u0002:\u0003O1\u0001BF\u0005\u0002\u0002#\u0005\u0011\u0011F\n\u0006\u0003O\tYc\u0007\t\b\u0003[\t\u0019$I\u00199\u001b\t\tyCC\u0002\u000229\tqA];oi&lW-\u0003\u0003\u00026\u0005=\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!91#a\n\u0005\u0002\u0005eBCAA\u0013\u0011)\t)\"a\n\u0002\u0002\u0013\u0015\u0013q\u0003\u0005\u000b\u0003\u007f\t9#!A\u0005\u0002\u0006\u0005\u0013!B1qa2LH#\u0002\u001d\u0002D\u0005\u0015\u0003BB\u0010\u0002>\u0001\u0007\u0011\u0005\u0003\u00040\u0003{\u0001\r!\r\u0005\u000b\u0003\u0013\n9#!A\u0005\u0002\u0006-\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001b\nI\u0006E\u0003\u000e\u0003\u001f\n\u0019&C\u0002\u0002R9\u0011aa\u00149uS>t\u0007#B\u0007\u0002V\u0005\n\u0014bAA,\u001d\t1A+\u001e9mKJB\u0011\"a\u0017\u0002H\u0005\u0005\t\u0019\u0001\u001d\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002`\u0005\u001d\u0012\u0011!C\u0005\u0003C\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\r\t\u0004M\u0006\u0015\u0014bAA4O\n1qJ\u00196fGR4QA\u0003\u0002\u0001\u0003W\u001a2!!\u001b\r\u0011\u001d\u0019\u0012\u0011\u000eC\u0001\u0003_\"\"!!\u001d\u0011\u0007!\tI\u0007\u0003\u0005\u0002v\u0005%D\u0011AA<\u00035!Xm\u001d;Kg>t\u0007+\u0019:tKR\u0011\u0011\u0011\u0010\t\u0004\u001b\u0005m\u0014bAA?\u001d\t!QK\\5uQ\u0011\t\u0019(!!\u0011\t\u0005\r\u0015QR\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006)!.\u001e8ji*\u0011\u00111R\u0001\u0004_J<\u0017\u0002BAH\u0003\u000b\u0013A\u0001V3ti\"A\u00111SA5\t\u0003\t9(\u0001\ruKN$H*Z4bGf,enY8eK\u0006\u001b8\u000b\u001e:j]\u001eDC!!%\u0002\u0002\"A\u0011\u0011TA5\t\u0003\t9(\u0001\nuKN$XI\\2pI\u0016\f5o\u0015;sS:<\u0007\u0006BAL\u0003\u0003C\u0001\"a(\u0002j\u0011\u0005\u0011qO\u0001\u0012i\u0016\u001cH/\u00128d_\u0012,\u0017i\u001d\"zi\u0016\u001c\b\u0006BAO\u0003\u0003C\u0001\"!*\u0002j\u0011\u0005\u0011qO\u0001\fi\u0016\u001cH\u000fU1sg\u0016$v\u000e\u000b\u0003\u0002$\u0006\u0005\u0005\u0002CAV\u0003S\"\t!a\u001e\u00025Q,7\u000f\u001e)beN,Gk\\,ji\"LeN^1mS\u0012T5o\u001c8)\t\u0005%\u0016\u0011\u0011")
public class JsonTest {
    @Test
    public void testJsonParse() {
        JsonNodeFactory jnf = JsonNodeFactory.instance;
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{}"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)new ObjectNode(jnf))));
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo\":\"bar\"s}"), (Object)None$.MODULE$);
        ObjectNode objectNode = new ObjectNode(jnf, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new TextNode("bar")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"is_enabled"), (Object)BooleanNode.TRUE)}))).asJava());
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo\":\"bar\", \"is_enabled\":true}"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)objectNode)));
        ArrayNode arrayNode = new ArrayNode(jnf);
        ((IterableLike)((TraversableLike)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)x$1 -> JsonTest.$anonfun$testJsonParse$1(BoxesRunTime.unboxToInt((Object)x$1)), Vector$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> arrayNode.add(x$1));
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("[1, 2, 3]"), (Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)arrayNode)));
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo1"), (Object)"bar1\\,bar2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo2"), (Object)"\\bar")}));
        String encoded = Json$.MODULE$.legacyEncodeAsString((Object)map);
        Option decoded = Json$.MODULE$.parseFull(encoded);
        Assert.assertEquals((Object)Json$.MODULE$.parseFull("{\"foo1\":\"bar1\\\\,bar2\", \"foo2\":\"\\\\bar\"}"), (Object)decoded);
        Assert.assertEquals((Object)decoded, (Object)Json$.MODULE$.parseFull("{\"foo1\":\"bar1\\,bar2\", \"foo2\":\"\\bar\"}"));
    }

    @Test
    public void testLegacyEncodeAsString() {
        Assert.assertEquals((Object)"null", (Object)Json$.MODULE$.legacyEncodeAsString(null));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToLong((long)1L)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToByte((byte)((byte)1))));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToShort((short)((short)1))));
        Assert.assertEquals((Object)"1.0", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToDouble((double)1.0)));
        Assert.assertEquals((Object)"\"str\"", (Object)Json$.MODULE$.legacyEncodeAsString((Object)"str"));
        Assert.assertEquals((Object)"true", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Assert.assertEquals((Object)"false", (Object)Json$.MODULE$.legacyEncodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Assert.assertEquals((Object)"[]", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertEquals((Object)"[1,2,3]", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
        Assert.assertEquals((Object)"[1,\"2\",[3]]", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))}))));
        Assert.assertEquals((Object)"{}", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assert.assertEquals((Object)"{\"a\":1,\"b\":2}", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)Json$.MODULE$.legacyEncodeAsString((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})))}))));
        Assert.assertEquals((Object)"\"str1\\\\,str2\"", (Object)Json$.MODULE$.legacyEncodeAsString((Object)"str1\\,str2"));
        Assert.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)Json$.MODULE$.legacyEncodeAsString((Object)"\"quoted\""));
    }

    @Test
    public void testEncodeAsString() {
        Assert.assertEquals((Object)"null", (Object)Json$.MODULE$.encodeAsString(null));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToLong((long)1L)));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToByte((byte)((byte)1))));
        Assert.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToShort((short)((short)1))));
        Assert.assertEquals((Object)"1.0", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToDouble((double)1.0)));
        Assert.assertEquals((Object)"\"str\"", (Object)Json$.MODULE$.encodeAsString((Object)"str"));
        Assert.assertEquals((Object)"true", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Assert.assertEquals((Object)"false", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Assert.assertEquals((Object)"[]", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava()));
        Assert.assertEquals((Object)"[null]", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))).asJava()));
        Assert.assertEquals((Object)"[1,2,3]", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).asJava()));
        Assert.assertEquals((Object)"[1,\"2\",[3],null]", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))).asJava(), null}))).asJava()));
        Assert.assertEquals((Object)"{}", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava()));
        Assert.assertEquals((Object)"{\"a\":1,\"b\":2,\"c\":null}", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava())}))).asJava()));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"b\":[3,4],\"c\":null}", (Object)Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()));
        Assert.assertEquals((Object)"\"str1\\\\,str2\"", (Object)Json$.MODULE$.encodeAsString((Object)"str1\\,str2"));
        Assert.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)Json$.MODULE$.encodeAsString((Object)"\"quoted\""));
    }

    @Test
    public void testEncodeAsBytes() {
        Assert.assertEquals((Object)"null", (Object)new String(Json$.MODULE$.encodeAsBytes(null), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToInteger((int)1)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToLong((long)1L)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToByte((byte)((byte)1))), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToShort((short)((short)1))), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"1.0", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToDouble((double)1.0)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"\"str\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"str"), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"true", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToBoolean((boolean)true)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"false", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToBoolean((boolean)false)), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"[]", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"[null]", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"[1,2,3]", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"[1,\"2\",[3],null]", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))).asJava(), null}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"{}", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"{\"a\":1,\"b\":2,\"c\":null}", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava())}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"{\"a\":[1,2],\"b\":[3,4],\"c\":null}", (Object)new String(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"\"str1\\\\,str2\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"str1\\,str2"), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"\"quoted\""), StandardCharsets.UTF_8));
    }

    @Test
    public void testParseTo() {
        String foo = "baz";
        int bar = 1;
        Either result = Json$.MODULE$.parseStringAs(new StringBuilder(20).append("{\"foo\": \"").append(foo).append("\", \"bar\": ").append(bar).append("}").toString(), ClassTag$.MODULE$.apply(TestObject.class));
        Assert.assertTrue((boolean)result.isRight());
        Assert.assertEquals((Object)new TestObject(foo, bar), (Object)result.right().get());
    }

    @Test
    public void testParseToWithInvalidJson() {
        Either result = Json$.MODULE$.parseStringAs("{invalid json}", ClassTag$.MODULE$.apply(TestObject.class));
        Assert.assertTrue((boolean)result.isLeft());
        Assert.assertEquals(JsonParseException.class, result.left().get().getClass());
    }

    public static final /* synthetic */ IntNode $anonfun$testJsonParse$1(int x$1) {
        return new IntNode(x$1);
    }

    public static class TestObject
    implements Product,
    scala.Serializable {
        private final String foo;
        private final int bar;

        public String foo() {
            return this.foo;
        }

        public int bar() {
            return this.bar;
        }

        public TestObject copy(String foo, int bar) {
            return new TestObject(foo, bar);
        }

        public String copy$default$1() {
            return this.foo();
        }

        public int copy$default$2() {
            return this.bar();
        }

        public String productPrefix() {
            return "TestObject";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.foo();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.bar());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestObject;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.foo()));
            n = Statics.mix((int)n, (int)this.bar());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestObject)) return false;
            boolean bl = true;
            if (!bl) return false;
            TestObject testObject = (TestObject)x$1;
            String string = this.foo();
            String string2 = testObject.foo();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.bar() != testObject.bar()) return false;
            if (!testObject.canEqual(this)) return false;
            return true;
        }

        public TestObject(@JsonProperty(value="foo") String foo, @JsonProperty(value="bar") int bar) {
            this.foo = foo;
            this.bar = bar;
            Product.$init$((Product)this);
        }
    }
}

