/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import kafka.admin.BrokerMetadata;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Resource;
import kafka.server.BrokerState;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.data.ACL;
import org.junit.Assert;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.collection.parallel.ParIterableLike;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Properties$;

public final class TestUtils$
implements Logging {
    public static TestUtils$ MODULE$;
    private final Random random;
    private final int RandomPort;
    private final int MockZkPort;
    private final String MockZkConnect;
    private final String SslCertificateCn;
    private final String kafka$utils$TestUtils$$transactionStatusKey;
    private final byte[] kafka$utils$TestUtils$$committedValue;
    private final byte[] kafka$utils$TestUtils$$abortedValue;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Random random() {
        return this.random;
    }

    public int RandomPort() {
        return this.RandomPort;
    }

    public int MockZkPort() {
        return this.MockZkPort;
    }

    public String MockZkConnect() {
        return this.MockZkConnect;
    }

    public String SslCertificateCn() {
        return this.SslCertificateCn;
    }

    public String kafka$utils$TestUtils$$transactionStatusKey() {
        return this.kafka$utils$TestUtils$$transactionStatusKey;
    }

    public byte[] kafka$utils$TestUtils$$committedValue() {
        return this.kafka$utils$TestUtils$$committedValue;
    }

    public byte[] kafka$utils$TestUtils$$abortedValue() {
        return this.kafka$utils$TestUtils$$abortedValue;
    }

    public File tempDir() {
        return TestUtils.tempDirectory();
    }

    public String tempTopic() {
        return new java.lang.StringBuilder(9).append("testTopic").append(this.random().nextInt(1000000)).toString();
    }

    public File tempRelativeDir(String parent) {
        File parentFile = new File(parent);
        parentFile.mkdirs();
        return TestUtils.tempDirectory((Path)parentFile.toPath(), null);
    }

    /*
     * WARNING - void declaration
     */
    public File randomPartitionLogDir(File parentDir) {
        void var3_3;
        int attempts = 1000;
        File f = (File)scala.package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> new File(parentDir, new java.lang.StringBuilder(6).append("kafka-").append(MODULE$.random().nextInt(1000000)).toString())).take(attempts).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.mkdir())).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(42).append("Failed to create directory after ").append(attempts).append(" attempts").toString()));
        f.deleteOnExit();
        return var3_3;
    }

    public File tempFile() {
        return TestUtils.tempFile();
    }

    public FileChannel tempChannel() {
        return FileChannel.open(this.tempFile().toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(KafkaConfig config, Time time) {
        void var3_3;
        KafkaServer server = new KafkaServer(config, time, KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        return var3_3;
    }

    public Time createServer$default$2() {
        return Time.SYSTEM;
    }

    public int boundPort(KafkaServer server, SecurityProtocol securityProtocol) {
        return server.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
    }

    public SecurityProtocol boundPort$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Broker createBroker(int id, String host, int port, SecurityProtocol securityProtocol) {
        return new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    public SecurityProtocol createBroker$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Properties> createBrokerConfigs(int numConfigs, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo, int logDirCount, boolean enableToken) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numConfigs).map((Function1 & Serializable & scala.Serializable)node -> TestUtils$.$anonfun$createBrokerConfigs$1(zkConnect, enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo, logDirCount, enableToken, BoxesRunTime.unboxToInt((Object)node)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String getBrokerListStrFromServers(Seq<KafkaServer> servers, SecurityProtocol protocol) {
        return ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)s -> {
            EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$getBrokerListStrFromServers$2(protocol, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(47).append("Could not find listener with security protocol ").append(protocol).toString()));
            return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(MODULE$.boundPort((KafkaServer)s, protocol)));
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public SecurityProtocol getBrokerListStrFromServers$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public String bootstrapServers(Seq<KafkaServer> servers, ListenerName listenerName) {
        return ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)s -> {
            EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$bootstrapServers$2(listenerName, x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new java.lang.StringBuilder(34).append("Could not find listener with name ").append(listenerName.value()).toString()));
            return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(listenerName)));
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public void shutdownServers(Seq<KafkaServer> servers) {
        ((ParIterableLike)servers.par()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.$anonfun$shutdownServers$1(s);
            return BoxedUnit.UNIT;
        });
    }

    public Properties createBrokerConfig(int nodeId, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack, int logDirCount, boolean enableToken) {
        Object object;
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object2 = enablePlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port))) : BoxedUnit.UNIT;
        Object object3 = enableSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort))) : BoxedUnit.UNIT;
        Object object4 = enableSaslPlaintext || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort))) : BoxedUnit.UNIT;
        Object object5 = enableSaslSsl || TestUtils$.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort))) : BoxedUnit.UNIT;
        String listeners = ((TraversableOnce)protocolAndPorts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
            int port = tuple2._2$mcI$sp();
            String string = new java.lang.StringBuilder(13).append(protocol.name).append("://localhost:").append(port).toString();
            return string;
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
        Properties props = new Properties();
        Object object6 = nodeId >= 0 ? props.put(KafkaConfig$.MODULE$.BrokerIdProp(), ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString()) : BoxedUnit.UNIT;
        props.put(KafkaConfig$.MODULE$.ListenersProp(), listeners);
        if (logDirCount > 1) {
            String logDirs = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), logDirCount).toList().map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.$anonfun$createBrokerConfig$4(BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom())).mkString(",");
            object = props.put(KafkaConfig$.MODULE$.LogDirsProp(), logDirs);
        } else {
            object = props.put(KafkaConfig$.MODULE$.LogDirProp(), this.tempDir().getAbsolutePath());
        }
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), zkConnect);
        props.put(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "10000");
        props.put(KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableControlledShutdown)).toString());
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableDeleteTopic)).toString());
        props.put(KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), "1000");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "100");
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "2097152");
        props.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        Object object7 = !props.containsKey(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp()) ? props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "5") : BoxedUnit.UNIT;
        Object object8 = !props.containsKey(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp()) ? props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0") : BoxedUnit.UNIT;
        rack.foreach((Function1 & Serializable & scala.Serializable)x$5 -> props.put(KafkaConfig$.MODULE$.RackProp(), x$5));
        if (protocolAndPorts.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$6(x0$2)))) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(Mode.SERVER, false, trustStoreFile, new java.lang.StringBuilder(6).append("server").append(nodeId).toString(), this.sslConfigs$default$5()));
        }
        if (protocolAndPorts.exists((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$7(x0$3)))) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        interBrokerSecurityProtocol.foreach((Function1 & Serializable & scala.Serializable)protocol -> props.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), protocol.name));
        Object object9 = enableToken ? props.put(KafkaConfig$.MODULE$.DelegationTokenMasterKeyProp(), "masterkey") : BoxedUnit.UNIT;
        return props;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$4() {
        return true;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$8() {
        return true;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public boolean createBrokerConfigs$default$11() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$12() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int createBrokerConfigs$default$13() {
        return 1;
    }

    public boolean createBrokerConfigs$default$14() {
        return false;
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfig$default$4() {
        return true;
    }

    public int createBrokerConfig$default$5() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$8() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$9() {
        return true;
    }

    public boolean createBrokerConfig$default$10() {
        return false;
    }

    public int createBrokerConfig$default$11() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$12() {
        return false;
    }

    public int createBrokerConfig$default$13() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$14() {
        return false;
    }

    public int createBrokerConfig$default$15() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$16() {
        return None$.MODULE$;
    }

    public int createBrokerConfig$default$17() {
        return 1;
    }

    public boolean createBrokerConfig$default$18() {
        return false;
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, int numPartitions, int replicationFactor, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        adminZkClient.createTopic(topic, numPartitions, replicationFactor, topicConfig, adminZkClient.createTopic$default$5());
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.$anonfun$createTopic$1(zkClient, topic, servers, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers) {
        return this.createTopic(zkClient, topic, partitionReplicaAssignment, servers, new Properties());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK(topic, partitionReplicaAssignment, topicConfig, adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK$default$4());
        return ((TraversableOnce)partitionReplicaAssignment.keySet().map((Function1 & Serializable & scala.Serializable)x0$4 -> TestUtils$.$anonfun$createTopic$2(zkClient, topic, servers, BoxesRunTime.unboxToInt((Object)x0$4)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public void createOffsetsTopic(KafkaZkClient zkClient, Seq<KafkaServer> servers) {
        KafkaServer server = (KafkaServer)servers.head();
        this.createTopic(zkClient, "__consumer_offsets", Predef$.MODULE$.Integer2int(server.config().getInt(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp())), Predef$.MODULE$.Short2short(server.config().getShort(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp())), servers, server.groupCoordinator().offsetsTopicConfigs());
    }

    public Nothing$ fail(String msg) {
        throw new AssertionError((Object)msg);
    }

    public MemoryRecords singletonRecords(byte[] value, byte[] key, CompressionType codec, long timestamp, byte magicValue) {
        return this.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(timestamp, key, value)}))), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7(), this.records$default$8());
    }

    public byte[] singletonRecords$default$2() {
        return null;
    }

    public CompressionType singletonRecords$default$3() {
        return CompressionType.NONE;
    }

    public long singletonRecords$default$4() {
        return -1L;
    }

    public byte singletonRecords$default$5() {
        return 2;
    }

    public MemoryRecords recordsWithValues(byte magicValue, CompressionType codec, Seq<byte[]> values) {
        return this.records((Iterable<SimpleRecord>)((Iterable)values.map((Function1 & Serializable & scala.Serializable)value -> new SimpleRecord(value), Seq$.MODULE$.canBuildFrom())), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7(), this.records$default$8());
    }

    public MemoryRecords records(Iterable<SimpleRecord> records, byte magicValue, CompressionType codec, long producerId, short producerEpoch, int sequence, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)System.currentTimeMillis(), (long)producerId, (short)producerEpoch, (int)sequence, (boolean)false, (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public byte records$default$2() {
        return 2;
    }

    public CompressionType records$default$3() {
        return CompressionType.NONE;
    }

    public long records$default$4() {
        return -1L;
    }

    public short records$default$5() {
        return -1;
    }

    public int records$default$6() {
        return -1;
    }

    public long records$default$7() {
        return 0L;
    }

    public int records$default$8() {
        return -1;
    }

    public byte[] randomBytes(int numBytes) {
        return TestUtils.randomBytes((int)numBytes);
    }

    public String randomString(int len) {
        return TestUtils.randomString((int)len);
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assert.assertEquals((String)"Buffers should have equal length", (long)(b1.limit() - b1.position()), (long)(b2.limit() - b2.position()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((String)new java.lang.StringBuilder(21).append("byte ").append(i).append(" byte not equal.").toString(), (long)b1.get(b1.position() + i), (long)b2.get(b1.position() + i)));
    }

    public <T> void checkEquals(Iterator<T> expected, Iterator<T> actual) {
        block4: {
            int length = 0;
            while (expected.hasNext() && actual.hasNext()) {
                ++length;
                Assert.assertEquals((Object)expected.next(), (Object)actual.next());
            }
            if (expected.hasNext()) {
                int length1 = length;
                while (expected.hasNext()) {
                    expected.next();
                    ++length1;
                }
                Assert.assertFalse((String)new java.lang.StringBuilder(50).append("Iterators have uneven length-- first has more: ").append(length1).append(" > ").append(length).toString(), (boolean)true);
            }
            if (!actual.hasNext()) break block4;
            int length2 = length;
            while (actual.hasNext()) {
                actual.next();
                ++length2;
            }
            Assert.assertFalse((String)new java.lang.StringBuilder(51).append("Iterators have uneven length-- second has more: ").append(length2).append(" > ").append(length).toString(), (boolean)true);
        }
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assert.assertEquals((long)expectedLength, (long)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assert.assertEquals(s1.next(), s2.next());
        }
        Assert.assertFalse((String)"Iterators have uneven length--first has more", (boolean)s1.hasNext());
        Assert.assertFalse((String)"Iterators have uneven length--second has more", (boolean)s2.hasNext());
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public Iterator<T> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<T> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.min$((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.max$((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.maxBy$((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.minBy$((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$1.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1 & Serializable & scala.Serializable)i -> builder.append(String.format("%x", buffer.get(buffer.position() + BoxesRunTime.unboxToInt((Object)i)))));
        return builder.toString();
    }

    public Properties securityConfigs(Mode mode, SecurityProtocol securityProtocol, Option<File> trustStoreFile, String certAlias, String certCn, Option<Properties> saslProperties) {
        Properties props = new Properties();
        if (this.usesSslTransportLayer(securityProtocol)) {
            SecurityProtocol securityProtocol2 = securityProtocol;
            SecurityProtocol securityProtocol3 = SecurityProtocol.SSL;
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(mode, !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null), trustStoreFile, certAlias, certCn));
        }
        if (this.usesSaslAuthentication(securityProtocol)) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name);
        return props;
    }

    public Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "producer", this.SslCertificateCn(), saslProperties);
    }

    public <K, V> KafkaProducer<K, V> createProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, int deliveryTimeoutMs, int lingerMs, int batchSize, String compressionType, int requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", ((Object)BoxesRunTime.boxToInteger((int)acks)).toString());
        producerProps.put("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)maxBlockMs)).toString());
        producerProps.put("buffer.memory", ((Object)BoxesRunTime.boxToLong((long)bufferSize)).toString());
        producerProps.put("retries", ((Object)BoxesRunTime.boxToInteger((int)retries)).toString());
        producerProps.put("delivery.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)deliveryTimeoutMs)).toString());
        producerProps.put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeoutMs)).toString());
        producerProps.put("linger.ms", ((Object)BoxesRunTime.boxToInteger((int)lingerMs)).toString());
        producerProps.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        producerProps.put("compression.type", compressionType);
        Implicits$.MODULE$.PropertiesOps(producerProps).$plus$plus$eq(this.producerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createProducer$default$2() {
        return -1;
    }

    public <K, V> long createProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createProducer$default$5() {
        return Integer.MAX_VALUE;
    }

    public <K, V> int createProducer$default$6() {
        return 30000;
    }

    public <K, V> int createProducer$default$7() {
        return 0;
    }

    public <K, V> int createProducer$default$8() {
        return 16384;
    }

    public <K, V> String createProducer$default$9() {
        return "none";
    }

    public <K, V> int createProducer$default$10() {
        return 20000;
    }

    public <K, V> SecurityProtocol createProducer$default$11() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createProducer$default$12() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createProducer$default$13() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createProducer$default$14() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$15() {
        return new ByteArraySerializer();
    }

    public boolean usesSslTransportLayer(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SSL.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean usesSaslAuthentication(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "consumer", this.SslCertificateCn(), saslProperties);
    }

    public Properties adminClientSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "admin-client", this.SslCertificateCn(), saslProperties);
    }

    public <K, V> KafkaConsumer<K, V> createConsumer(String brokerList, String groupId, String autoOffsetReset, boolean enableAutoCommit, boolean readCommitted, int maxPollRecords, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)enableAutoCommit)).toString());
        consumerProps.put("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        Implicits$.MODULE$.PropertiesOps(consumerProps).$plus$plus$eq(this.consumerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaConsumer(consumerProps, keyDeserializer, valueDeserializer);
    }

    public <K, V> String createConsumer$default$2() {
        return "group";
    }

    public <K, V> String createConsumer$default$3() {
        return "earliest";
    }

    public <K, V> boolean createConsumer$default$4() {
        return true;
    }

    public <K, V> boolean createConsumer$default$5() {
        return false;
    }

    public <K, V> int createConsumer$default$6() {
        return 500;
    }

    public <K, V> SecurityProtocol createConsumer$default$7() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createConsumer$default$8() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createConsumer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$10() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$11() {
        return new ByteArrayDeserializer();
    }

    public Seq<Broker> createBrokersInZk(KafkaZkClient zkClient, Seq<Object> ids) {
        return this.createBrokersInZk((Seq<BrokerMetadata>)((Seq)ids.map((Function1 & Serializable & scala.Serializable)x$6 -> TestUtils$.$anonfun$createBrokersInZk$1(BoxesRunTime.unboxToInt((Object)x$6)), Seq$.MODULE$.canBuildFrom())), zkClient);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> createBrokersInZk(Seq<BrokerMetadata> brokerMetadatas, KafkaZkClient zkClient) {
        void var3_3;
        zkClient.makeSurePersistentPathExists(BrokerIdsZNode$.MODULE$.path());
        Seq brokers = (Seq)brokerMetadatas.map((Function1 & Serializable & scala.Serializable)b -> {
            SecurityProtocol protocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)protocol);
            return new Broker(b.id(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 6667, listenerName, protocol)})), b.rack());
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1 & Serializable & scala.Serializable)b -> {
            zkClient.registerBroker(BrokerInfo$.MODULE$.apply(new Broker(b.id(), b.endPoints(), b.rack()), ApiVersion$.MODULE$.latestVersion(), -1));
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> deleteBrokersInZk(KafkaZkClient zkClient, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1 & Serializable & scala.Serializable)x$7 -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)x$7), "localhost", 6667, SecurityProtocol.PLAINTEXT), Seq$.MODULE$.canBuildFrom());
        ids.foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)b -> zkClient.deletePath(new java.lang.StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(b).toString()));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1 & Serializable & scala.Serializable)i -> buffer.$plus$eq((Object)new java.lang.StringBuilder(3).append("msg").append(BoxesRunTime.unboxToInt((Object)i)).toString()));
        return var2_2;
    }

    public void makeLeaderForPartition(KafkaZkClient zkClient, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        scala.collection.immutable.Map newLeaderIsrAndControllerEpochs = (scala.collection.immutable.Map)leaderPerPartitionMap.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            int leader = tuple2._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            LeaderAndIsr newLeaderAndIsr = (LeaderAndIsr)zkClient.getTopicPartitionState(topicPartition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.leaderAndIsr().newLeader(leader)).getOrElse((Function0 & Serializable & scala.Serializable)() -> LeaderAndIsr$.MODULE$.apply(leader, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new LeaderIsrAndControllerEpoch(newLeaderAndIsr, controllerEpoch));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        zkClient.setTopicPartitionStatesRaw(newLeaderIsrAndControllerEpochs, ZkVersion$.MODULE$.MatchAnyVersion());
    }

    /*
     * Unable to fully structure code
     */
    public int waitUntilLeaderIsElectedOrChanged(KafkaZkClient zkClient, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(oldLeaderOpt.isDefined() == false || newLeaderOpt.isDefined() == false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$1(), ()Ljava/lang/String;)());
        startTime = System.currentTimeMillis();
        topicPartition = new TopicPartition(topic, partition);
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$2(scala.Option scala.Option org.apache.kafka.common.TopicPartition ), ()Ljava/lang/String;)(oldLeaderOpt, newLeaderOpt, (TopicPartition)topicPartition));
        leader = ObjectRef.create((Object)None$.MODULE$);
        electedOrChangedLeader = None$.MODULE$;
        while (electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            block9: {
                block5: {
                    block7: {
                        block8: {
                            block6: {
                                leader.elem = zkClient.getLeaderForPartition(topicPartition);
                                var15_13 = (Option)leader.elem;
                                if (!(var15_13 instanceof Some)) break block5;
                                var16_14 = (Some)var15_13;
                                l = BoxesRunTime.unboxToInt((Object)var16_14.value());
                                var18_16 = new Tuple2(newLeaderOpt, oldLeaderOpt);
                                if (var18_16 == null || !((var19_17 = (Option)var18_16._1()) instanceof Some) || (newLeader = BoxesRunTime.unboxToInt((Object)(var20_18 = (Some)var19_17).value())) != l) break block6;
                                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$3(org.apache.kafka.common.TopicPartition int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l));
                                electedOrChangedLeader = (Option)leader.elem;
                                var9_12 = BoxedUnit.UNIT;
                                break block7;
                            }
                            if (var18_16 == null || !((var22_20 = (Option)var18_16._2()) instanceof Some) || (oldLeader = BoxesRunTime.unboxToInt((Object)(var23_21 = (Some)var22_20).value())) == l) break block8;
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$4(org.apache.kafka.common.TopicPartition int int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l, (int)oldLeader));
                            electedOrChangedLeader = (Option)leader.elem;
                            var9_12 = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (var18_16 == null) ** GOTO lbl-1000
                        var25_23 = (Option)var18_16._1();
                        var26_24 = (Option)var18_16._2();
                        if (None$.MODULE$.equals(var25_23) && None$.MODULE$.equals(var26_24)) {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$5(org.apache.kafka.common.TopicPartition int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l));
                            electedOrChangedLeader = (Option)leader.elem;
                            var9_12 = BoxedUnit.UNIT;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$6(org.apache.kafka.common.TopicPartition int ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (int)l));
                            var9_12 = BoxedUnit.UNIT;
                        }
                    }
                    var8_11 = BoxedUnit.UNIT;
                    break block9;
                }
                if (None$.MODULE$.equals(var15_13)) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$7(org.apache.kafka.common.TopicPartition ), ()Ljava/lang/String;)((TopicPartition)topicPartition));
                    var8_11 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)var15_13);
                }
            }
            Thread.sleep(package$.MODULE$.min(timeoutMs, 100L));
        }
        return BoxesRunTime.unboxToInt((Object)electedOrChangedLeader.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$waitUntilLeaderIsElectedOrChanged$8(long scala.Option scala.Option org.apache.kafka.common.TopicPartition scala.runtime.ObjectRef ), ()Lscala/runtime/Nothing$;)((long)timeoutMs, oldLeaderOpt, newLeaderOpt, (TopicPartition)topicPartition, (ObjectRef)leader)));
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = LongRef.create((long)1L);
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                block.apply$mcV$sp();
                return;
            }
            catch (AssertionError e) {
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed > maxWaitMs) {
                    throw e;
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(49).append("Attempt failed, sleeping for ").append(wait$1.elem).append(", and then retrying.").toString());
                Thread.sleep(wait.elem);
                wait.elem += package$.MODULE$.min(wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public void waitUntilTrue(Function0<Object> condition, Function0<String> msg, long waitTime, long pause, int maxRetries) {
        long startTime = System.currentTimeMillis();
        int retry = 0;
        while (true) {
            try {
                if (condition.apply$mcZ$sp()) {
                    return;
                }
                if (System.currentTimeMillis() > startTime + waitTime) {
                    throw this.fail((String)msg.apply());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof RetriableException) {
                    RetriableException retriableException = (RetriableException)throwable2;
                    if (retry < maxRetries) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying after error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> retriableException);
                        ++retry;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    throw throwable3;
                }
                throw throwable;
            }
            break;
        }
    }

    public long waitUntilTrue$default$3() {
        return 15000L;
    }

    public long waitUntilTrue$default$4() {
        return 100L;
    }

    public int waitUntilTrue$default$5() {
        return 0;
    }

    public <T> Tuple2<T, Object> computeUntilTrue(Function0<T> compute, long waitTime, long pause, Function1<T, Object> predicate) {
        long startTime = System.currentTimeMillis();
        Object result;
        while (!BoxesRunTime.unboxToBoolean((Object)predicate.apply(result = compute.apply()))) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <T> long computeUntilTrue$default$2() {
        return 15000L;
    }

    public <T> long computeUntilTrue$default$3() {
        return 100L;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        return server.replicaManager().getPartition(new TopicPartition(topic, partitionId)).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$isLeaderLocalOnBroker$1(x$9)));
    }

    public int findLeaderEpoch(int brokerId, TopicPartition topicPartition, Iterable<KafkaServer> servers) {
        Option leaderServer = servers.find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findLeaderEpoch$1(brokerId, x$10)));
        Partition leaderPartition = (Partition)leaderServer.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.replicaManager().getPartition(topicPartition)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.fail(new java.lang.StringBuilder(42).append("Failed to find expected replica on broker ").append(brokerId).toString()));
        return leaderPartition.getLeaderEpoch();
    }

    public int findFollowerId(TopicPartition topicPartition, Iterable<KafkaServer> servers) {
        Option followerOpt = servers.find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$findFollowerId$1(topicPartition, server)));
        return BoxesRunTime.unboxToInt((Object)followerOpt.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$findFollowerId$2(x$12))).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.fail(new java.lang.StringBuilder(30).append("Unable to locate follower for ").append(topicPartition).toString())));
    }

    public void waitUntilBrokerMetadataIsPropagated(Seq<KafkaServer> servers, long timeout) {
        Set expectedBrokerIds = ((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$1(x$13)), Seq$.MODULE$.canBuildFrom())).toSet();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilBrokerMetadataIsPropagated$4(expectedBrokerIds, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting for broker metadata to propagate to all servers", timeout, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
    }

    public long waitUntilBrokerMetadataIsPropagated$default$2() {
        return 15000L;
    }

    public int waitUntilMetadataIsPropagated(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        IntRef leader = IntRef.create((int)-1);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)servers.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilMetadataIsPropagated$3(topic, partition, leader, BoxesRunTime.unboxToBoolean((Object)result), server)))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)timeout)})), timeout, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return leader.elem;
    }

    public long waitUntilMetadataIsPropagated$default$4() {
        return 15000L;
    }

    public int waitUntilControllerElected(KafkaZkClient zkClient, long timeout) {
        Option controllerId;
        Tuple2 tuple2 = this.computeUntilTrue((Function0 & Serializable & scala.Serializable)() -> zkClient.getControllerId(), timeout, this.computeUntilTrue$default$3(), (Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.isDefined()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = controllerId = (Option)tuple2._1();
        Option controllerId2 = option;
        return BoxesRunTime.unboxToInt((Object)controllerId2.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.fail(new java.lang.StringBuilder(32).append("Controller not elected after ").append(timeout).append(" ms").toString())));
    }

    public long waitUntilControllerElected$default$2() {
        return 15000L;
    }

    public int awaitLeaderChange(Seq<KafkaServer> servers, TopicPartition tp, int oldLeader, long timeout) {
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.newLeaderExists$1(servers, tp, oldLeader).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(54).append("Did not observe leader change for partition ").append(tp).append(" after ").append(timeout).append(" ms").toString(), timeout, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return BoxesRunTime.unboxToInt((Object)TestUtils$.newLeaderExists$1(servers, tp, oldLeader).get());
    }

    public long awaitLeaderChange$default$4() {
        return 15000L;
    }

    public int waitUntilLeaderIsKnown(Seq<KafkaServer> servers, TopicPartition tp, long timeout) {
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.leaderIfExists$1(servers, tp).isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(41).append("Partition ").append(tp).append(" leaders not made yet after ").append(timeout).append(" ms").toString(), timeout, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return BoxesRunTime.unboxToInt((Object)TestUtils$.leaderIfExists$1(servers, tp).get());
    }

    public long waitUntilLeaderIsKnown$default$3() {
        return 15000L;
    }

    public void writeNonsenseToFile(File fileName, long position, int size) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> file.writeByte(MODULE$.random().nextInt(255)));
        file.close();
    }

    public void appendNonsenseToFile(File file, int size) {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND);){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> outputStream.write(MODULE$.random().nextInt(255)));
        }
    }

    public void checkForPhantomInSyncReplicas(KafkaZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas) {
        Option inSyncReplicas = zkClient.getInSyncReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Set phantomInSyncReplicas = (Set)((TraversableOnce)inSyncReplicas.get()).toSet().$minus$minus((GenTraversableOnce)assignedReplicas.toSet());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})), (boolean)phantomInSyncReplicas.isEmpty());
    }

    public void ensureNoUnderReplicatedPartitions(KafkaZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas, Seq<KafkaServer> servers) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionToBeReassigned);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option inSyncReplicas = zkClient.getInSyncReplicasForPartition(topicPartition);
            return ((SeqLike)inSyncReplicas.get()).size() == assignedReplicas.size();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under replicated")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        ObjectRef leader = ObjectRef.create((Object)None$.MODULE$);
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            leader$4.elem = zkClient.getLeaderForPartition(topicPartition);
            return ((Option)leader$4.elem).isDefined();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            KafkaServer leaderBroker = (KafkaServer)((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$ensureNoUnderReplicatedPartitions$7(leader, s)))).head();
            return leaderBroker.replicaManager().underReplicatedPartitionCount() == 0;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned), ((Option)leader$4.elem).get()})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
    }

    public void verifyNonDaemonThreadsStatus(String threadNamePrefix) {
        int threadCount = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyNonDaemonThreadsStatus$1(threadNamePrefix, t)));
        Assert.assertEquals((long)0L, (long)threadCount);
    }

    public String allThreadStackTraces() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Thread.getAllStackTraces()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Thread thread = (Thread)tuple2._1();
            StackTraceElement[] stackTrace = (StackTraceElement[])tuple2._2();
            String string = new java.lang.StringBuilder(2).append(thread.getName()).append("\n\t").append(((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTrace)).toList().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.toString(), List$.MODULE$.canBuildFrom())).mkString("\n\t")).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public LogManager createLogManager(Seq<File> logDirs, LogConfig defaultConfig, CleanerConfig cleanerConfig, MockTime time) {
        Seq x$54 = (Seq)logDirs.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.getAbsoluteFile(), Seq$.MODULE$.canBuildFrom());
        WrappedArray x$55 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        Map x$56 = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        LogConfig x$57 = defaultConfig;
        CleanerConfig x$58 = cleanerConfig;
        int x$59 = 4;
        long x$60 = 1000L;
        long x$61 = 10000L;
        long x$62 = 10000L;
        long x$63 = 1000L;
        int x$64 = 3600000;
        MockScheduler x$65 = time.scheduler();
        MockTime x$66 = time;
        BrokerState x$67 = new BrokerState();
        BrokerTopicStats x$68 = new BrokerTopicStats();
        LogDirFailureChannel x$69 = new LogDirFailureChannel(logDirs.size());
        return new LogManager(x$54, (Seq)x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, (Scheduler)x$65, x$67, x$68, x$69, (Time)x$66);
    }

    public Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public LogConfig createLogManager$default$2() {
        return LogConfig$.MODULE$.apply();
    }

    public CleanerConfig createLogManager$default$3() {
        boolean x$98 = false;
        int x$99 = CleanerConfig$.MODULE$.apply$default$1();
        long x$100 = CleanerConfig$.MODULE$.apply$default$2();
        double x$101 = CleanerConfig$.MODULE$.apply$default$3();
        int x$102 = CleanerConfig$.MODULE$.apply$default$4();
        int x$103 = CleanerConfig$.MODULE$.apply$default$5();
        double x$104 = CleanerConfig$.MODULE$.apply$default$6();
        long x$105 = CleanerConfig$.MODULE$.apply$default$7();
        String x$106 = CleanerConfig$.MODULE$.apply$default$9();
        return new CleanerConfig(x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$98, x$106);
    }

    public MockTime createLogManager$default$4() {
        return new MockTime();
    }

    public void produceMessages(Seq<KafkaServer> servers, Seq<ProducerRecord<byte[], byte[]>> records, int acks) {
        try (KafkaProducer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), acks, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7(), this.createProducer$default$8(), this.createProducer$default$9(), this.createProducer$default$10(), this.createProducer$default$11(), this.createProducer$default$12(), this.createProducer$default$13(), (Serializer)this.createProducer$default$14(), (Serializer)this.createProducer$default$15());){
            Seq futures = (Seq)records.map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), Seq$.MODULE$.canBuildFrom());
            futures.foreach((Function1 & Serializable & scala.Serializable)x$22 -> (RecordMetadata)x$22.get());
        }
        Seq topics = (Seq)((SeqLike)records.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.topic(), Seq$.MODULE$.canBuildFrom())).distinct();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("Sent ").append(records.size()).append(" messages for topics ").append(topics.mkString(",")).toString());
    }

    public Seq<String> generateAndProduceMessages(Seq<KafkaServer> servers, String topic, int numMessages, int acks) {
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x -> TestUtils$.$anonfun$generateAndProduceMessages$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records = (IndexedSeq)values.map((Function1 & Serializable & scala.Serializable)v -> new ProducerRecord(topic, (Object)v.getBytes()), IndexedSeq$.MODULE$.canBuildFrom());
        this.produceMessages(servers, (Seq<ProducerRecord<byte[], byte[]>>)records, acks);
        return values;
    }

    public int generateAndProduceMessages$default$4() {
        return -1;
    }

    public void produceMessage(Seq<KafkaServer> servers, String topic, String message, int deliveryTimeoutMs, int requestTimeoutMs) {
        String x$70 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$71 = deliveryTimeoutMs;
        int x$72 = requestTimeoutMs;
        int x$73 = this.createProducer$default$2();
        long x$74 = this.createProducer$default$3();
        long x$75 = this.createProducer$default$4();
        int x$76 = this.createProducer$default$5();
        int x$77 = this.createProducer$default$7();
        int x$78 = this.createProducer$default$8();
        String x$79 = this.createProducer$default$9();
        SecurityProtocol x$80 = this.createProducer$default$11();
        Option<File> x$81 = this.createProducer$default$12();
        Option<Properties> x$82 = this.createProducer$default$13();
        ByteArraySerializer x$83 = this.createProducer$default$14();
        ByteArraySerializer x$84 = this.createProducer$default$15();
        try (KafkaProducer producer = this.createProducer(x$70, x$73, x$74, x$75, x$76, x$71, x$77, x$78, x$79, x$72, x$80, x$81, x$82, (Serializer)x$83, (Serializer)x$84);){
            producer.send(new ProducerRecord(topic, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        }
    }

    public int produceMessages$default$3() {
        return -1;
    }

    public int produceMessage$default$4() {
        return 30000;
    }

    public int produceMessage$default$5() {
        return 20000;
    }

    public void verifyTopicDeletion(KafkaZkClient zkClient, String topic, int numPartitions, Seq<KafkaServer> servers) {
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)x$24 -> TestUtils$.$anonfun$verifyTopicDeletion$1(topic, BoxesRunTime.unboxToInt((Object)x$24)), IndexedSeq$.MODULE$.canBuildFrom());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !zkClient.isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even after a replica is restarted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !zkClient.topicExists(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Topic path /brokers/topics/%s not deleted after /admin/delete_topic/%s path is deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, topic})), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$9(server, tp))))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replica manager's should have deleted all of this topic's partitions", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$11(server, tp))))));
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)topicPartitions.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$15(server, tp))))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cleaner offset for deleted partition should have been removed", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$20(topicPartitions, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to soft-delete the data to a delete directory", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$25(topicPartitions, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to hard-delete the delete directory", this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties copyOf(Properties props) {
        void var2_2;
        Properties copy = new Properties();
        Implicits$.MODULE$.PropertiesOps(copy).$plus$plus$eq(props);
        return var2_2;
    }

    public Properties sslConfigs(Mode mode, boolean clientCert, Option<File> trustStoreFile, String certAlias, String certCn) {
        File trustStore = (File)trustStoreFile.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("SSL enabled but no trustStoreFile provided");
        });
        java.util.Map sslConfigs = TestSslUtils.createSslConfig((boolean)clientCert, (boolean)true, (Mode)mode, (File)trustStore, (String)certAlias, (String)certCn);
        Properties sslProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sslConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            Object object = sslProps.put(k, v);
            return object;
        });
        return sslProps;
    }

    public String sslConfigs$default$5() {
        return this.SslCertificateCn();
    }

    /*
     * WARNING - void declaration
     */
    public X509TrustManager trustAllCerts() {
        void var1_1;
        X509TrustManager trustManager = new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        return var1_1;
    }

    public void waitAndVerifyAcls(Set<Acl> expected, Authorizer authorizer, Resource resource) {
        String newLine = Properties$.MODULE$.lineSeparator();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set set = authorizer.getAcls(resource);
            Set set2 = expected;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append("expected acls:").append(expected.mkString(new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), newLine)).append(new java.lang.StringBuilder(8).append("but got:").append(authorizer.getAcls(resource).mkString(new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), new java.lang.StringBuilder(1).append(newLine).append("\t").toString(), newLine)).toString()).toString(), 15000L, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
    }

    public boolean isAclSecure(ACL acl, boolean sensitive) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(4).append("ACL ").append(acl).toString());
        int n = acl.getPerms();
        switch (n) {
            case 1: {
                if (!sensitive) {
                    String string = acl.getId().getScheme();
                    String string2 = "world";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string3 = "sasl";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isAclUnsecure(ACL acl) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(4).append("ACL ").append(acl).toString());
        int n = acl.getPerms();
        switch (n) {
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "world";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    private Seq<String> secureZkPaths(ZkUtils zkUtils) {
        Seq topLevelPaths = (Seq)ZkUtils$.MODULE$.SecureZkRootPaths().$plus$plus((GenTraversableOnce)ZkUtils$.MODULE$.SensitiveZkRootPaths(), Seq$.MODULE$.canBuildFrom());
        return (Seq)topLevelPaths.flatMap((Function1 & Serializable & scala.Serializable)path -> TestUtils$.subPaths$1(path, zkUtils), Seq$.MODULE$.canBuildFrom());
    }

    public void verifySecureZkAcls(ZkUtils zkUtils, int usersWithAccess) {
        this.secureZkPaths(zkUtils).foreach((Function1 & Serializable & scala.Serializable)path -> {
            TestUtils$.$anonfun$verifySecureZkAcls$1(zkUtils, usersWithAccess, path);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyUnsecureZkAcls(ZkUtils zkUtils) {
        this.secureZkPaths(zkUtils).foreach((Function1 & Serializable & scala.Serializable)path -> {
            TestUtils$.$anonfun$verifyUnsecureZkAcls$1(zkUtils, path);
            return BoxedUnit.UNIT;
        });
    }

    public void assertConcurrent(String message, Seq<Function0<Object>> functions, int timeoutMs) {
        int numThreads = functions.size();
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            ArrayBuffer arrayBuffer;
            try {
                java.util.List runnables = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)functions.map((Function1 & Serializable & scala.Serializable)function -> new Callable<BoxedUnit>(function){
                    private final Function0 function$1;

                    public void call() {
                        this.function$1.apply();
                    }
                    {
                        this.function$1 = function$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava();
                Buffer futures = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(threadPool.invokeAll(runnables, timeoutMs, TimeUnit.MILLISECONDS)).asScala();
                futures.foreach((Function1 & Serializable & scala.Serializable)future -> {
                    Object object;
                    if (future.isCancelled()) {
                        this.failWithTimeout$1(message, timeoutMs);
                        object = BoxedUnit.UNIT;
                    } else {
                        try {
                            object = future.get();
                        }
                        catch (Exception e) {
                            object = exceptions.$plus$eq((Object)e);
                        }
                    }
                    return object;
                });
                arrayBuffer = BoxedUnit.UNIT;
            }
            catch (InterruptedException interruptedException) {
                this.failWithTimeout$1(message, timeoutMs);
                arrayBuffer = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                arrayBuffer = exceptions.$plus$eq((Object)e);
            }
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)new java.lang.StringBuilder(26).append(message).append(" failed with exception(s) ").append(exceptions).toString(), (boolean)exceptions.isEmpty());
    }

    public <K, V> Seq<ConsumerRecord<byte[], byte[]>> consumeTopicRecords(Seq<KafkaServer> servers, String topic, int numMessages, String groupId, SecurityProtocol securityProtocol, Option<File> trustStoreFile, long waitTime) {
        Seq<ConsumerRecord<K, V>> seq;
        String x$87 = this.getBrokerListStrFromServers(servers, securityProtocol);
        String x$88 = groupId;
        SecurityProtocol x$89 = securityProtocol;
        Option<File> x$90 = trustStoreFile;
        String x$91 = this.createConsumer$default$3();
        boolean x$92 = this.createConsumer$default$4();
        boolean x$93 = this.createConsumer$default$5();
        int x$94 = this.createConsumer$default$6();
        Option<Properties> x$95 = this.createConsumer$default$9();
        ByteArrayDeserializer x$96 = this.createConsumer$default$10();
        ByteArrayDeserializer x$97 = this.createConsumer$default$11();
        try (KafkaConsumer<K, V> consumer = this.createConsumer(x$87, x$88, x$91, x$92, x$93, x$94, x$89, x$90, x$95, (Deserializer<K>)x$96, (Deserializer<V>)x$97);){
            consumer.subscribe(Collections.singleton(topic));
            seq = this.consumeRecords(consumer, numMessages, waitTime);
        }
        return seq;
    }

    public <K, V> String consumeTopicRecords$default$4() {
        return "group";
    }

    public <K, V> SecurityProtocol consumeTopicRecords$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> consumeTopicRecords$default$6() {
        return None$.MODULE$;
    }

    public <K, V> long consumeTopicRecords$default$7() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRecords(KafkaConsumer<K, V> consumer, int numMessages, long waitTime) {
        ArrayBuffer records = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(Duration.ofMillis(50L))).asScala());
            return records.size() >= numMessages;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(64).append("Consumed ").append(records.size()).append(" records until timeout instead of the expected ").append(numMessages).append(" records").toString(), waitTime, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        Assert.assertEquals((String)"Consumed more records than expected", (long)numMessages, (long)records.size());
        return records;
    }

    public <K, V> long consumeRecords$default$3() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRecordsFor(KafkaConsumer<K, V> consumer, long duration) {
        long startTime = System.currentTimeMillis();
        ArrayBuffer records = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(Duration.ofMillis(50L))).asScala());
            return System.currentTimeMillis() - startTime > duration;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(52).append("The timeout ").append(duration).append(" was greater than the maximum wait time.").toString(), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return records;
    }

    public <K, V> long consumeRecordsFor$default$2() {
        return 15000L;
    }

    public KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, Seq<KafkaServer> servers, int batchSize, long transactionTimeoutMs) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()));
        props.put("acks", "all");
        props.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        props.put("transaction.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)transactionTimeoutMs)).toString());
        return new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    public int createTransactionalProducer$default$3() {
        return 16384;
    }

    public long createTransactionalProducer$default$4() {
        return 60000L;
    }

    public void seedTopicWithNumberedRecords(String topic, int numRecords, Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        props.put("bootstrap.servers", this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()));
        try (KafkaProducer producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, (Object)TestUtils$.MODULE$.asBytes(((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString()), (Object)TestUtils$.MODULE$.asBytes(((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString()))));
            producer.flush();
        }
    }

    private String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private byte[] asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String assertCommittedAndGetValue(ConsumerRecord<byte[], byte[]> record) {
        Option option = ((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(record.headers().headers(this.kafka$utils$TestUtils$$transactionStatusKey())).asScala()).headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw this.fail("expected the record header to include an expected transaction status, but received nothing.");
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Header header = (Header)some.value();
        Assert.assertEquals((String)new java.lang.StringBuilder(57).append("Got ").append(this.asString(header.value())).append(" but expected the value to indicate ").append("committed status.").toString(), (Object)this.asString(this.kafka$utils$TestUtils$$committedValue()), (Object)this.asString(header.value()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.recordValueAsString(record);
    }

    public String recordValueAsString(ConsumerRecord<byte[], byte[]> record) {
        return this.asString((byte[])record.value());
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, byte[] key, byte[] value, boolean willBeCommitted) {
        Header header = new Header(willBeCommitted){
            private final boolean willBeCommitted$1;

            public String key() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$transactionStatusKey();
            }

            public byte[] value() {
                return this.willBeCommitted$1 ? TestUtils$.MODULE$.kafka$utils$TestUtils$$committedValue() : TestUtils$.MODULE$.kafka$utils$TestUtils$$abortedValue();
            }
            {
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        };
        return new ProducerRecord(topic, null, (Object)key, (Object)value, Collections.singleton(header));
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, String key, String value, boolean willBeCommitted) {
        return this.producerRecordWithExpectedTransactionStatus(topic, this.asBytes(key), this.asBytes(value), willBeCommitted);
    }

    public Map<TopicPartition, OffsetAndMetadata> consumerPositions(KafkaConsumer<byte[], byte[]> consumer) {
        HashMap offsetsToCommit = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> offsetsToCommit.put(topicPartition, (Object)new OffsetAndMetadata(consumer.position(topicPartition))));
        return offsetsToCommit.toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<ConsumerRecord<byte[], byte[]>> pollUntilAtLeastNumRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords) {
        void var3_3;
        ArrayBuffer records = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            records.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(Duration.ofMillis(50L))).asScala());
            return records.size() >= numRecords;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(55).append("Consumed ").append(records.size()).append(" records until timeout, but expected ").append(numRecords).append(" records.").toString(), this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return var3_3;
    }

    public void resetToCommittedPositions(KafkaConsumer<byte[], byte[]> consumer) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            TestUtils$.$anonfun$resetToCommittedPositions$1(consumer, topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public AlterConfigsResult alterConfigs(Seq<KafkaServer> servers, AdminClient adminClient, Properties props, boolean perBrokerConfig) {
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ConfigEntry configEntry = new ConfigEntry(k, v);
            return configEntry;
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = perBrokerConfig ? (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)servers.map((Function1 & Serializable & scala.Serializable)server -> {
            ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId())).toString());
            return new Tuple2((Object)resource, (Object)newConfig);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava() : (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    public AlterConfigsResult alterTopicConfigs(AdminClient adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfigs).asScala()).map((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ConfigEntry configEntry = new ConfigEntry(k, v);
            return configEntry;
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    public String grabConsoleOutput(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return out.toString();
    }

    public String grabConsoleError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withErr((OutputStream)err, f);
        }
        finally {
            Console$.MODULE$.err().flush();
        }
        return err.toString();
    }

    public Tuple2<String, String> grabConsoleOutputAndError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Console$.MODULE$.withErr((OutputStream)err, f));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)out.toString(), (Object)err.toString());
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz) {
        try {
            future.get();
            throw this.fail("Expected CompletableFuture.get to return an exception");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((String)new java.lang.StringBuilder(41).append("Expected an exception of type ").append(clazz.getName()).append("; got type ").append(cause.getClass().getName()).toString(), (boolean)clazz.isInstance(cause));
            return;
        }
    }

    public long totalMetricValue(KafkaServer server, String metricName) {
        java.util.Map allMetrics = server.metrics().metrics();
        double total2 = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(allMetrics.values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$totalMetricValue$1(metricName, x$26)))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(total, metric) -> BoxesRunTime.boxToDouble((double)TestUtils$.$anonfun$totalMetricValue$2(BoxesRunTime.unboxToDouble((Object)total), metric))));
        return (long)total2;
    }

    public static final /* synthetic */ Properties $anonfun$createBrokerConfigs$1(String zkConnect$1, boolean enableControlledShutdown$1, boolean enableDeleteTopic$1, Option interBrokerSecurityProtocol$1, Option trustStoreFile$1, Option saslProperties$1, boolean enablePlaintext$1, boolean enableSsl$1, boolean enableSaslPlaintext$1, boolean enableSaslSsl$1, Map rackInfo$1, int logDirCount$1, boolean enableToken$1, int node) {
        int x$27 = node;
        String x$28 = zkConnect$1;
        boolean x$29 = enableControlledShutdown$1;
        boolean x$30 = enableDeleteTopic$1;
        int x$31 = MODULE$.RandomPort();
        Option x$32 = interBrokerSecurityProtocol$1;
        Option x$33 = trustStoreFile$1;
        Option x$34 = saslProperties$1;
        boolean x$35 = enablePlaintext$1;
        boolean x$36 = enableSsl$1;
        boolean x$37 = enableSaslPlaintext$1;
        boolean x$38 = enableSaslSsl$1;
        Option x$39 = rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
        int x$40 = logDirCount$1;
        boolean x$41 = enableToken$1;
        int x$42 = MODULE$.createBrokerConfig$default$11();
        int x$43 = MODULE$.createBrokerConfig$default$13();
        int x$44 = MODULE$.createBrokerConfig$default$15();
        return MODULE$.createBrokerConfig(x$27, x$28, x$29, x$30, x$31, (Option<SecurityProtocol>)x$32, (Option<File>)x$33, (Option<Properties>)x$34, x$35, x$37, x$42, x$36, x$43, x$38, x$44, (Option<String>)x$39, x$40, x$41);
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerListStrFromServers$2(SecurityProtocol protocol$1, EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = protocol$1;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$bootstrapServers$2(ListenerName listenerName$1, EndPoint x$3) {
        ListenerName listenerName = x$3.listenerName();
        ListenerName listenerName2 = listenerName$1;
        return !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
    }

    public static final /* synthetic */ void $anonfun$shutdownServers$1(KafkaServer s) {
        s.shutdown();
        CoreUtils$.MODULE$.delete(s.config().logDirs());
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$2(SecurityProtocol protocol$2, SecurityProtocol x$4) {
        SecurityProtocol securityProtocol = x$4;
        SecurityProtocol securityProtocol2 = protocol$2;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    private static final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createBrokerConfig$2(protocol, x$4))));
    }

    public static final /* synthetic */ Object $anonfun$createBrokerConfig$4(int i) {
        return i % 2 == 0 ? MODULE$.tempDir().getAbsolutePath() : MODULE$.tempRelativeDir("data");
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$6(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
        boolean bl = MODULE$.usesSslTransportLayer(protocol);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfig$7(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
        boolean bl = MODULE$.usesSaslAuthentication(protocol);
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$createTopic$1(KafkaZkClient zkClient$4, String topic$2, Seq servers$3, int i) {
        MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)servers$3, topic$2, i, MODULE$.waitUntilMetadataIsPropagated$default$4());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)MODULE$.waitUntilLeaderIsElectedOrChanged(zkClient$4, topic$2, i, MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
    }

    public static final /* synthetic */ Tuple2 $anonfun$createTopic$2(KafkaZkClient zkClient$3, String topic$1, Seq servers$2, int x0$4) {
        int n = x0$4;
        MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)servers$2, topic$1, n, MODULE$.waitUntilMetadataIsPropagated$default$4());
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)BoxesRunTime.boxToInteger((int)MODULE$.waitUntilLeaderIsElectedOrChanged(zkClient$3, topic$1, n, MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
        return tuple2;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$createBrokersInZk$1(int x$6) {
        return new BrokerMetadata(x$6, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$1() {
        return "Can't define both the old and the new leader";
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$2(Option oldLeaderOpt$1, Option newLeaderOpt$1, TopicPartition topicPartition$3) {
        return new java.lang.StringBuilder(76).append("Waiting for leader to be elected or changed for partition ").append(topicPartition$3).append(", old leader is ").append(oldLeaderOpt$1).append(", ").append(new java.lang.StringBuilder(14).append("new leader is ").append(newLeaderOpt$1).toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$3(TopicPartition topicPartition$3, int l$1) {
        return new java.lang.StringBuilder(46).append("Expected new leader ").append(l$1).append(" is elected for partition ").append(topicPartition$3).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$4(TopicPartition topicPartition$3, int l$1, int oldLeader$2) {
        return new java.lang.StringBuilder(42).append("Leader for partition ").append(topicPartition$3).append(" is changed from ").append(oldLeader$2).append(" to ").append(l$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$5(TopicPartition topicPartition$3, int l$1) {
        return new java.lang.StringBuilder(33).append("Leader ").append(l$1).append(" is elected for partition ").append(topicPartition$3).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$6(TopicPartition topicPartition$3, int l$1) {
        return new java.lang.StringBuilder(33).append("Current leader for partition ").append(topicPartition$3).append(" is ").append(l$1).toString();
    }

    public static final /* synthetic */ String $anonfun$waitUntilLeaderIsElectedOrChanged$7(TopicPartition topicPartition$3) {
        return new java.lang.StringBuilder(40).append("Leader for partition ").append(topicPartition$3).append(" is not elected yet").toString();
    }

    public static final /* synthetic */ Nothing$ $anonfun$waitUntilLeaderIsElectedOrChanged$8(long timeoutMs$1, Option oldLeaderOpt$1, Option newLeaderOpt$1, TopicPartition topicPartition$3, ObjectRef leader$2) {
        Option option;
        String string;
        Option option2;
        Tuple2 tuple2 = new Tuple2((Object)newLeaderOpt$1, (Object)oldLeaderOpt$1);
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            int newLeader = BoxesRunTime.unboxToInt((Object)some.value());
            string = new java.lang.StringBuilder(90).append("Timing out after ").append(timeoutMs$1).append(" ms since expected new leader ").append(newLeader).append(" was not elected for partition ").append(topicPartition$3).append(", leader is ").append((Option)leader$2.elem).toString();
        } else if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            int oldLeader = BoxesRunTime.unboxToInt((Object)some.value());
            string = new java.lang.StringBuilder(96).append("Timing out after ").append(timeoutMs$1).append(" ms since a new leader that is different from ").append(oldLeader).append(" was not elected for partition ").append(topicPartition$3).append(", ").append(new java.lang.StringBuilder(10).append("leader is ").append((Option)leader$2.elem).toString()).toString();
        } else {
            string = new java.lang.StringBuilder(66).append("Timing out after ").append(timeoutMs$1).append(" ms since a leader was not elected for partition ").append(topicPartition$3).toString();
        }
        String errorMessage = string;
        return MODULE$.fail(errorMessage);
    }

    public static final /* synthetic */ boolean $anonfun$isLeaderLocalOnBroker$1(Partition x$9) {
        return x$9.leaderReplicaIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$findLeaderEpoch$1(int brokerId$1, KafkaServer x$10) {
        return x$10.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$findFollowerId$1(TopicPartition topicPartition$2, KafkaServer server) {
        boolean bl;
        Option option = server.replicaManager().getPartition(topicPartition$2);
        if (option instanceof Some) {
            Some some = (Some)option;
            Partition partition = (Partition)some.value();
            bl = !partition.leaderReplicaIdOpt().contains((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId()));
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$findFollowerId$2(KafkaServer x$12) {
        return x$12.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$waitUntilBrokerMetadataIsPropagated$1(KafkaServer x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilBrokerMetadataIsPropagated$4(Set expectedBrokerIds$1, KafkaServer server) {
        Set set = expectedBrokerIds$1;
        Set set2 = ((TraversableOnce)server.apis().metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Seq$.MODULE$.canBuildFrom())).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilMetadataIsPropagated$3(String topic$4, int partition$1, IntRef leader$3, boolean result, KafkaServer server) {
        boolean bl;
        Option partitionStateOpt = server.apis().metadataCache().getPartitionInfo(topic$4, partition$1);
        Option option = partitionStateOpt;
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)some.value();
            leader$3.elem = partitionState.basePartitionState.leader;
            bl = result && Request$.MODULE$.isValidBrokerId(leader$3.elem);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$2(Partition x$16) {
        return x$16.leaderReplicaIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$awaitLeaderChange$1(TopicPartition tp$1, int oldLeader$1, KafkaServer server) {
        return server.config().brokerId() != oldLeader$1 && server.replicaManager().getPartition(tp$1).exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$2(x$16)));
    }

    public static final /* synthetic */ int $anonfun$awaitLeaderChange$3(KafkaServer x$17) {
        return x$17.config().brokerId();
    }

    private static final Option newLeaderExists$1(Seq servers$7, TopicPartition tp$1, int oldLeader$1) {
        return servers$7.find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$awaitLeaderChange$1(tp$1, oldLeader$1, server))).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$awaitLeaderChange$3(x$17)));
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$2(Partition x$18) {
        return x$18.leaderReplicaIfLocal().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilLeaderIsKnown$1(TopicPartition tp$2, KafkaServer server) {
        return server.replicaManager().getPartition(tp$2).exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$2(x$18)));
    }

    public static final /* synthetic */ int $anonfun$waitUntilLeaderIsKnown$3(KafkaServer x$19) {
        return x$19.config().brokerId();
    }

    private static final Option leaderIfExists$1(Seq servers$8, TopicPartition tp$2) {
        return servers$8.find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$waitUntilLeaderIsKnown$1(tp$2, server))).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)TestUtils$.$anonfun$waitUntilLeaderIsKnown$3(x$19)));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoUnderReplicatedPartitions$7(ObjectRef leader$4, KafkaServer s) {
        return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)((Option)leader$4.elem).get());
    }

    public static final /* synthetic */ boolean $anonfun$verifyNonDaemonThreadsStatus$1(String threadNamePrefix$1, Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(threadNamePrefix$1);
    }

    public static final /* synthetic */ String $anonfun$generateAndProduceMessages$1(int x) {
        return new java.lang.StringBuilder(5).append("test-").append(x).toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$verifyTopicDeletion$1(String topic$3, int x$24) {
        return new TopicPartition(topic$3, x$24);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$9(KafkaServer server$1, TopicPartition tp) {
        return server$1.replicaManager().getPartition(tp).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$11(KafkaServer server$2, TopicPartition tp) {
        LogManager qual$1 = server$2.getLogManager();
        TopicPartition x$85 = tp;
        boolean x$86 = qual$1.getLog$default$2();
        return qual$1.getLog(x$85, x$86).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$17(TopicPartition tp$3, Map checkpointsPerLogDir) {
        return !checkpointsPerLogDir.contains((Object)tp$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$15(KafkaServer server$3, TopicPartition tp) {
        Seq checkpoints = (Seq)server$3.getLogManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)logDir -> new OffsetCheckpointFile(new File((File)logDir, "cleaner-offset-checkpoint"), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read(), Seq$.MODULE$.canBuildFrom());
        return checkpoints.forall((Function1 & Serializable & scala.Serializable)checkpointsPerLogDir -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$17(tp, checkpointsPerLogDir)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$22(String logDir$1, TopicPartition tp) {
        return !new File(logDir$1, new java.lang.StringBuilder(1).append(tp.topic()).append("-").append(tp.partition()).toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$20(IndexedSeq topicPartitions$1, KafkaServer server) {
        return server.config().logDirs().forall((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$22(logDir, tp)))));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$28(TopicPartition tp$4, String[] partitionDirectoryName) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName)).startsWith((GenSeq)Predef$.MODULE$.wrapString(new java.lang.StringBuilder(1).append(tp$4.topic()).append("-").append(tp$4.partition()).toString())) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName)).endsWith((GenSeq)Predef$.MODULE$.wrapString(Log$.MODULE$.DeleteDirSuffix()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$27(String logDir$2, TopicPartition tp) {
        return !((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Arrays.asList((Object[])new String[][]{new File(logDir$2).list()})).asScala()).exists((Function1 & Serializable & scala.Serializable)partitionDirectoryName -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$28(tp, partitionDirectoryName)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicDeletion$25(IndexedSeq topicPartitions$1, KafkaServer server) {
        return server.config().logDirs().forall((Function1 & Serializable & scala.Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)topicPartitions$1.forall((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$verifyTopicDeletion$27(logDir, tp)))));
    }

    private static final Seq subPaths$1(String path2, ZkUtils zkUtils$3) {
        Seq seq;
        if (zkUtils$3.pathExists(path2)) {
            String string = path2;
            seq = (Seq)((SeqLike)((TraversableLike)zkUtils$3.getChildren(path2).map((Function1 & Serializable & scala.Serializable)c -> new java.lang.StringBuilder(1).append(path2).append("/").append((String)c).toString(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)path -> TestUtils$.subPaths$1(path, zkUtils$3), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public static final /* synthetic */ void $anonfun$verifySecureZkAcls$1(ZkUtils zkUtils$2, int usersWithAccess$1, String path) {
        block0: {
            if (!zkUtils$2.pathExists(path)) break block0;
            boolean sensitive = ZkUtils$.MODULE$.sensitivePath(path);
            int aclCount = sensitive ? usersWithAccess$1 : usersWithAccess$1 + 1;
            java.util.List acls = (java.util.List)zkUtils$2.zkConnection().getAcl(path).getKey();
            Assert.assertEquals((String)new java.lang.StringBuilder(18).append("Invalid ACLs for ").append(path).append(" ").append(acls).toString(), (long)aclCount, (long)acls.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).foreach((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(acl, sensitive)));
        }
    }

    public static final /* synthetic */ void $anonfun$verifyUnsecureZkAcls$1(ZkUtils zkUtils$1, String path) {
        block0: {
            if (!zkUtils$1.pathExists(path)) break block0;
            java.util.List acls = (java.util.List)zkUtils$1.zkConnection().getAcl(path).getKey();
            Assert.assertEquals((String)new java.lang.StringBuilder(18).append("Invalid ACLs for ").append(path).append(" ").append(acls).toString(), (long)1L, (long)acls.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).foreach((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl)));
        }
    }

    private final void failWithTimeout$1(String message$1, int timeoutMs$2) {
        throw this.fail(new java.lang.StringBuilder(66).append(message$1).append(". Timed out, the concurrent functions took more than ").append(timeoutMs$2).append(" milliseconds").toString());
    }

    public static final /* synthetic */ void $anonfun$resetToCommittedPositions$1(KafkaConsumer consumer$4, TopicPartition topicPartition) {
        OffsetAndMetadata offset = consumer$4.committed(topicPartition);
        if (offset != null) {
            consumer$4.seek(topicPartition, offset.offset());
        } else {
            consumer$4.seekToBeginning(Collections.singletonList(topicPartition));
        }
    }

    public static final /* synthetic */ boolean $anonfun$totalMetricValue$1(String metricName$1, KafkaMetric x$26) {
        String string = x$26.metricName().name();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ double $anonfun$totalMetricValue$2(double total, KafkaMetric metric) {
        return total + BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.random = TestUtils.RANDOM;
        this.RandomPort = 0;
        this.MockZkPort = 1;
        this.MockZkConnect = new java.lang.StringBuilder(10).append("127.0.0.1:").append(this.MockZkPort()).toString();
        this.SslCertificateCn = "localhost";
        this.kafka$utils$TestUtils$$transactionStatusKey = "transactionStatus";
        this.kafka$utils$TestUtils$$committedValue = "committed".getBytes(StandardCharsets.UTF_8);
        this.kafka$utils$TestUtils$$abortedValue = "aborted".getBytes(StandardCharsets.UTF_8);
    }
}

